import { Request, Response, NextFunction } from "express";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res404 } from "../lib/view/404";
const stripepay = require("stripe");
import { AppRoute } from "../lib/AppRoute";
import checkDesc from "./markError";
import { sessiondata } from "../server";
import {KYCPDF } from "../config/setting.config";
const kycpdf = new KYCPDF();

const secret_key = "sk_test_51HAL9TGdXmhCeqBzWbxBTiVUDlCqizGP8NWwxDC8zIRKuef4i9kerhyixCqVZPw5Ik3fmfUe7BR2Wy2cUqrOZdWx00IQ2MEmbO";
//    const secret_key = "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";

export class StripeApi extends AppRoute {

    constructor() {
        super();
    }

    RechargeByAdmin(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let CRate: any = typeof sdata.amount != 'undefined' && sdata.amount > 0 ? sdata.amount : 0

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                if (CRate > 0) {
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`=" + sdata.idaccount;
                    obj2.prepare();
                    obj2.execute((_error: any, customer: any) => {
                        if (_error == 1) {
                            if (customer.length > 0) {
                                let obj = new ModelRawNonQuery(req, res);
                                if (sdata.paymentType == "3") {
                                    obj.nonqrysql = "UPDATE wallet SET `balance`=`balance`-" + CRate + " WHERE `idaccount` = '" + sdata.idaccount + "'";
                                } else {
                                    obj.nonqrysql = "UPDATE wallet SET `balance`=`balance`+" + CRate + " WHERE `idaccount` = '" + sdata.idaccount + "'";
                                }
                                obj.prepare();
                                obj.execute((werror: any, _result: any) => {
                                    if (werror == 1) {

                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                        iQry += "`idaccount`=" + sdata.idaccount + ", "

                                        if (sdata.paymentType == "3") {
                                            iQry += "`amount`='-" + CRate + "', "
                                        }
                                        else {
                                            iQry += "`amount`='+" + CRate + "', "
                                        }

                                        iQry += "`purpose`='Wallet successfully recharged by Admin', "

                                        iQry += "`description`='" + checkDesc(sdata.description) + "', "

                                        iQry += "`payment_type`='" + sdata.paymentType + "', "

                                        iQry += "`status`=1;"
                                        let pType = "Direct";
                                        
                                        if (sdata.paymentType == 1) {
                                            pType = "Portal Payment";
                                        } else if (sdata.paymentType == 2) {
                                            pType = "Manual Credit";
                                        } else if (sdata.paymentType == 3) {
                                            pType = "Manual Debit";
                                        } else if (sdata.paymentType == 4) {
                                            pType = "Bank Payment";
                                        } else if (sdata.paymentType == 5) {
                                            pType = "Credit Card Payment";
                                        }
                                        let objWL = new ModelRawNonQuery(req, res);
                                        objWL.nonqrysql = iQry
                                        objWL.prepare()
                                        objWL.execute((error: any, result: any) => {
                                            console.log("Transaction response::", result)
                                        })

                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `amount`, `created`, `description`, `type`) VALUE('" + sdata.idaccount + "', '" + sdata.email + "', '" + sdata.amount + "', '" + sdata.currentDateTime + "', '" + checkDesc(sdata.description) + "', '" + pType + "')";
                                        obj1.prepare();
                                        obj1.execute((__error: any, result: any) => {
                                            if (__error == 1) {
                                                let objv1 = new RawView(res);
                                                let message;
                                                if (sdata.paymentType == 3) {
                                                    message = "Balance Deducted Successfully!";
                                                }                                                
                                                else {
                                                     message = "Balance Credit Successfully!";
                                                }
                                                objv1.prepare({ data: result, message: message, status: 201 });
                                                objv1.execute();
                                            } else {
                                                let objv1 = new RawView(res);
                                                objv1.prepare({ message: "Balance Added Error With Log!", status: 502, error: result });
                                                objv1.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv1 = new RawView(res);
                                        objv1.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: _result });
                                        objv1.execute();
                                    }
                                });
                            }
                            else {
                                let objv1 = new RawView(res);
                                objv1.prepare({ message: "Customer Detail Not Found!", error: customer, status: 502 });
                                objv1.execute();
                            }
                        }
                        else {
                            let objv1 = new RawView(res);
                            objv1.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv1.execute();
                        }
                    });
                }
                else {
                    let objv1 = new RawView(res);
                    objv1.prepare({
                        message: "Balance amount should be greater then 0!",
                        status: 502,
                        error: ""
                    });
                    objv1.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Auth Key!", status: 401 });
                objv.execute();
            }
        });
    }

    public getBalance(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `wallet` WHERE idaccount=" + sessdata.idaccount;
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Balance fetched successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Wallet Not Found For this Account!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }

    public getcustBalance(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        // console.log('sdata',sdata);
        
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `wallet` WHERE idaccount=" + sdata.idaccount;
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Balance fetched successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Wallet Not Found For this Account!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!", error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    public addBalance(req: Request, res: Response, next: NextFunction) {
        let spdata = JSON.parse(req.body.data);
        let stipedata = spdata.pdata;
        let stripeToken = spdata.token;
        const stripe = stripepay(secret_key);
        let session = new SessionManagment(req, res, next);
        session.GetSession((__error: any, sessdata: any) => {
            if (__error == 1) {
                stripe.customers.create(
                    {
                        email: stripeToken.email,
                        source: stripeToken.id,
                        name: stipedata.first_name + " " + stipedata.last_name,
                        phone: stipedata.contact,
                        metadata: {
                            name: stipedata.first_name + " " + stipedata.last_name,
                            contact: stipedata.contact,
                            city: stipedata.city
                        },
                        shipping: {
                            name: stipedata.first_name + " " + stipedata.last_name,
                            phone: stipedata.contact,
                            address: {
                                line1: stipedata.address1,
                                city: stipedata.city,
                                country: stipedata.country,
                                state: stipedata.state,
                                postal_code: stipedata.postal_code
                            }
                        }/* ,
                        billing_details: {
                            email: stripeToken.email,
                            name: stipedata.first_name + " " + stipedata.last_name,
                            phone: stipedata.contact,
                            address: {
                                line1: stipedata.address1,
                                city: stipedata.city,
                                country: stipedata.country,
                                state: stipedata.state,
                                postal_code: stipedata.postal_code
                            }
                        } */,
                        address: {
                            line1: stipedata.address1,
                            city: stipedata.city,
                            country: stipedata.country,
                            state: stipedata.state,
                            postal_code: stipedata.postal_code
                        }
                    }, (err: any, customer: any) => {
                        if (err) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Invalid Card Details", error: err, status: 404 });
                            objv.execute();
                        }
                        else {
                            stripe.charges.create({
                                customer: customer.id,
                                amount: stipedata.amount * 100,
                                currency: 'USD',
                                description: 'Live Mode',
                                shipping: {
                                    name: stipedata.first_name + " " + stipedata.last_name,
                                    phone: stipedata.contact,
                                    address: {
                                        line1: stipedata.address1,
                                        city: stipedata.city,
                                        country: stipedata.country,
                                        state: stipedata.state,
                                        postal_code: stipedata.postal_code
                                    }
                                }/* ,
                                billing_details: {
                                    email: stripeToken.email,
                                    name: stipedata.first_name + " " + stipedata.last_name,
                                    phone: stipedata.contact,
                                    address: {
                                        line1: stipedata.address1,
                                        city: stipedata.city,
                                        country: stipedata.country,
                                        state: stipedata.state,
                                        postal_code: stipedata.postal_code
                                    }
                                } */
                            }, (err: any, charge: any) => {
                                if (err) {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Wrong Billing Information!", status: 404 });
                                    objv.execute();
                                }
                                else {
                                    let obj10 = new ModelRawQuery(req, res);
                                    obj10.qrysql = "SELECT * FROM `wallet` WHERE idaccount='" + sessdata.idaccount + "'";
                                    obj10.prepare();
                                    obj10.execute((__werror: any, __wresult: any) => {
                                        if (__werror == 1) {
                                            if (__wresult.length > 0) {
                                                if (__wresult[0].customer_id) {
                                                    const amount = stipedata.amount;

                                                    let CAmount: any = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0

                                                    let obj1 = new ModelRawNonQuery(req, res);
                                                    obj1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`+" + CAmount + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                    obj1.prepare();
                                                    obj1.execute((__error: any, __result: any) => {
                                                        if (__error == 1) {

                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                                            iQry += "`idaccount`=" + sessdata.idaccount + ", "

                                                            iQry += "`amount`='+" + CAmount + "', "

                                                            iQry += "`purpose`='Wallet successfully recharged by customer', "

                                                            iQry += "`status`=1;"

                                                            let objWL = new ModelRawNonQuery(req, res);
                                                            objWL.nonqrysql = iQry
                                                            objWL.prepare()
                                                            objWL.execute((error: any, result: any) => {
                                                                console.log("Transaction response::", result)
                                                            })

                                                            let obj2 = new ModelRawNonQuery(req, res);
                                                            obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`,`charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`) VALUE('" + sessdata.idaccount + "', '" + stripeToken.email + "', '" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + charge.description + "', 'stripe')";
                                                            obj2.prepare();
                                                            obj2.execute((___error: any, result: any) => {
                                                                if (___error == 1) {
                                                                    let key = stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4;
                                                                    let obj3 = new ModelRawQuery(req, res);
                                                                    obj3.qrysql = "SELECT * FROM `stripe_card` WHERE `key`= '" + key + "'";
                                                                    obj3.prepare();
                                                                    obj3.execute((____error: any, stripeCard: any) => {
                                                                        if (____error == 1) {
                                                                            if (stripeCard.length > 0) {
                                                                                let objv1 = new RawView(res);
                                                                                objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                objv1.execute();
                                                                            }
                                                                            else {
                                                                                let obj4 = new ModelRawNonQuery(req, res);
                                                                                obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`) VALUES ('" + sessdata.idaccount + "', '" + stripeToken.card.name + "', '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "', '" + charge.customer + "','" + stripeToken.id + "', '" + stripeToken.card.id + "', '" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "', '" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "', '" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "', '" + stripeToken.client_ip + "', '" + stripeToken.created + "', 'false')";
                                                                                obj4.prepare();
                                                                                obj4.execute((__werror: any, ___result: any) => {
                                                                                    if (__werror == 1) {
                                                                                        let objv1 = new RawView(res);
                                                                                        objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                        objv1.execute();
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView(res);
                                                                                        objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                            }
                                                                        }
                                                                        else {
                                                                            let objv1 = new RawView(res);
                                                                            objv1.prepare({ message: "Balance Added Error with Connection!", status: 502, error: stripeCard });
                                                                            objv1.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: __result });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    const amount = stipedata.amount;

                                                    let CAmount: any = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0

                                                    let obj1 = new ModelRawNonQuery(req, res);
                                                    obj1.nonqrysql = "UPDATE `wallet` SET `balance`=`balance`+" + CAmount + ", `customer_id`='" + charge.customer + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                    obj1.prepare();
                                                    obj1.execute((__error: any, __result: any) => {
                                                        if (__error == 1) {

                                                            let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                                            iQry += "`idaccount`=" + sessdata.idaccount + ", "

                                                            iQry += "`amount`='+" + CAmount + "', "

                                                            iQry += "`purpose`='Wallet successfully recharged by customer', "

                                                            iQry += "`status`=1;"

                                                            let objWL = new ModelRawNonQuery(req, res);
                                                            objWL.nonqrysql = iQry
                                                            objWL.prepare()
                                                            objWL.execute((error: any, result: any) => {
                                                                console.log("Transaction response::", result)
                                                            })

                                                            let obj2 = new ModelRawNonQuery(req, res);
                                                            obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`) VALUE('" + sessdata.idaccount + "', '" + stripeToken.email + "', '" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + charge.description + "', 'stripe')";
                                                            obj2.prepare();
                                                            obj2.execute((___error: any, result: any) => {
                                                                if (___error == 1) {
                                                                    let obj3 = new ModelRawQuery(req, res);
                                                                    obj3.qrysql = "SELECT * FROM `stripe_card` WHERE `key` = '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "'";
                                                                    obj3.prepare();
                                                                    obj3.execute((____error: any, stripeCard: any) => {
                                                                        if (____error == 1) {
                                                                            if (stripeCard.length > 0) {
                                                                                let objv1 = new RawView(res);
                                                                                objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                objv1.execute();
                                                                            }
                                                                            else {
                                                                                let obj4 = new ModelRawNonQuery(req, res);
                                                                                obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`) VALUES ('" + sessdata.idaccount + "', '" + stripeToken.card.name + "', '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "', '" + charge.customer + "','" + stripeToken.id + "', '" + stripeToken.card.id + "', '" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "', '" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "', '" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "', '" + stripeToken.client_ip + "', '" + stripeToken.created + "', 'true')";
                                                                                obj4.prepare();
                                                                                obj4.execute((__werror: any, ___result: any) => {
                                                                                    if (__werror == 1) {
                                                                                        let objv1 = new RawView(res);
                                                                                        objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                                        objv1.execute();
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView(res);
                                                                                        objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                            }
                                                                        }
                                                                        else {
                                                                            let objv1 = new RawView(res);
                                                                            objv1.prepare({ message: "Balance Added Error with Connection!", status: 502, error: stripeCard });
                                                                            objv1.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: __result });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                            }
                                            else {
                                                const amount = stipedata.amount;

                                                let CAmount: any = typeof stipedata.amount != 'undefined' && stipedata.amount > 0 ? stipedata.amount : 0

                                                let obj1 = new ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "INSERT INTO `wallet` (`idaccount`, `balance`, `customer_id`) VALUES('" + sessdata.idaccount + "', '" + CAmount + "', '" + charge.customer + "')";
                                                obj1.prepare();
                                                obj1.execute((__error: any, __result: any) => {
                                                    if (__error == 1) {

                                                        let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                                        iQry += "`idaccount`=" + sessdata.idaccount + ", "

                                                        iQry += "`amount`='+" + CAmount + "', "

                                                        iQry += "`purpose`='Wallet successfully recharged by customer', "

                                                        iQry += "`status`=1;"

                                                        let objWL = new ModelRawNonQuery(req, res);
                                                        objWL.nonqrysql = iQry
                                                        objWL.prepare()
                                                        objWL.execute((error: any, result: any) => {
                                                            console.log("Transaction response::", result)
                                                        })

                                                        let obj2 = new ModelRawNonQuery(req, res);
                                                        obj2.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`, `email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`) VALUE('" + sessdata.idaccount + "', '" + stripeToken.email + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + charge.description + "', 'stripe')";
                                                        obj2.prepare();
                                                        obj2.execute((___error: any, result: any) => {
                                                            if (___error == 1) {
                                                                let obj4 = new ModelRawNonQuery(req, res);
                                                                obj4.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`, `customer_id`, `token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`, `default`) VALUES ('" + sessdata.idaccount + "', '" + stripeToken.card.name + "', '" + stripeToken.card.exp_month + "-" + stripeToken.card.exp_year + "-" + stripeToken.card.last4 + "', '" + charge.customer + "','" + stripeToken.id + "', '" + stripeToken.card.id + "', '" + stripeToken.card.brand + "', '" + stripeToken.card.last4 + "', '" + stripeToken.card.cvc_check + "', '" + stripeToken.card.exp_month + "', '" + stripeToken.card.exp_year + "', '" + stripeToken.card.funding + "', '" + stripeToken.client_ip + "', '" + stripeToken.created + "', 'true')";
                                                                obj4.prepare();
                                                                obj4.execute((__werror: any, ___result: any) => {
                                                                    if (__werror == 1) {
                                                                        let objv1 = new RawView(res);
                                                                        objv1.prepare({ data: result, message: "Balance Added Successfully!", status: 201 });
                                                                        objv1.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Balance Added Error with Connection!", status: 502, data: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ message: "Balance Added Error With Connectvion!", status: 502, error: result });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "Error With Updating Wallet!", status: 502, error: __result });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 404 });
                                            objv.execute();
                                        }
                                    });
                                }
                            });

                        }
                    });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }

    updateBalance(req: Request, res: Response, next: NextFunction) {
        let spdata = JSON.parse(req.body.data);        
        let stipedata = spdata.pdata;        
        const stripe = stripepay(secret_key);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                stripe.charges.create({
                    customer: stipedata.customer_id,
                    amount: stipedata.amount * 100,
                    currency: 'USD',
                    description: 'Live Mode',
                    shipping: {
                        name: stipedata.first_name + " " + stipedata.last_name,
                        phone: stipedata.contact,
                        address: {
                            line1: stipedata.address1,
                            city: stipedata.city,
                            country: stipedata.country,
                            state: stipedata.state,
                            postal_code: stipedata.postal_code
                        }
                    }
                }, (err: any, charge: any) => {                    
                    if (err) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Invalid Card Details", error: err, status: 404 });
                        objv.execute();
                    }
                    else {
                        const amount = charge.amount / 100;
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE wallet SET `balance`= `balance`+ " + stipedata.amount + " WHERE `idaccount` = '" + sessdata.idaccount + "'";
                        obj.prepare();
                        obj.execute((_error: any, wallet: any) => {
                            if (_error == 1) {

                                let iQry: string = "INSERT INTO `wallet_recharge_log` SET "

                                iQry += "`idaccount`=" + sessdata.idaccount + ", "

                                iQry += "`amount`='+" + amount + "', "

                                iQry += "`purpose`='Wallet amount successfully updated by customer', "

                                iQry += "`status`=1;"

                                let objWL = new ModelRawNonQuery(req, res);
                                objWL.nonqrysql = iQry
                                objWL.prepare()
                                objWL.execute((error: any, result: any) => {
                                    console.log("Transaction response::", result)
                                })

                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `stripe_payment` (`idaccount`,`email`, `charge_id`, `customer_id`, `balance_transaction`, `amount`, `created`, `status`, `description`, `type`) VALUE('" + sessdata.idaccount + "', '" + stipedata.email + "','" + charge.id + "', '" + charge.customer + "', '" + charge.balance_transaction + "', '" + amount + "', '" + charge.created + "', '" + charge.status + "','" + charge.description + "', 'stripe')";
                                obj.prepare();
                                obj.execute((serror: any, result: any) => {
                                    if (serror == 1) {
                                        let obj1 = new ModelRawQuery(req, res);
                                        obj1.qrysql = "SELECT * FROM `wallet` WHERE `idaccount`=" + sessdata.idaccount;
                                        obj1.prepare();
                                        obj1.execute((____error: any, _result: any) => {
                                            if (____error == 1) {
                                                let objv1 = new RawView(res);
                                                objv1.prepare({ data: _result, message: "Balance Updated Successfully!", status: 201 });
                                                objv1.execute();
                                            } else {
                                                let objv1 = new RawView(res);
                                                objv1.prepare({ message: "Balance Updated Error With Connection!", status: 502, error: _result });
                                                objv1.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Balance Updated Error With Connection!", err: error, status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Error With Updating Balance!", err: error, status: 502 });
                                objv.execute();
                            }
                        });
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }

    updatePaymentSetting(req: Request, res: Response, next: NextFunction) {
        let spdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                let str = '';
                if (spdata.isAutoPayment === "true" || spdata.isAutoPayment === "false") {
                    obj2.qrysql = "UPDATE `wallet` SET `status`='" + spdata.isAutoPayment + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                    obj2.prepare();
                    obj2.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Setting Changed!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else if (spdata.isAutoEmail === "true" || spdata.isAutoEmail === "false") {
                    obj2.qrysql = "UPDATE `wallet` SET `isEmail`='" + spdata.isAutoEmail + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                    obj2.prepare();
                    obj2.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Setting Changed!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else if (spdata.isAutowebhook === "true" || spdata.isAutowebhook === "false") {
                    obj2.qrysql = "UPDATE `wallet` SET `isWebhook`='" + spdata.isAutowebhook + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                    obj2.prepare();
                    obj2.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Setting Changed!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else if (spdata.defaultamt || spdata.topup_amount || spdata.webhook_url) {
                    obj2.qrysql = "UPDATE `wallet` SET `min_balance`='" + spdata.defaultamt + "', `topup_amount`='" + spdata.topup_amount + "', `webhook_url` = '" + spdata.webhook_url + "' WHERE `idwallet` = '" + spdata.idwallet + "'";
                    obj2.prepare();
                    obj2.execute((upError: any, result: any) => {
                        if (upError == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Payment Setting Updated!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new Res404(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }

    paymentHistory(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        console.log(sdata);
        let condition: any = "";
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                if (sessdata.type == 1) {
                    if (sdata.selectedUser || (sdata.toDate && sdata.fromDate)) {
                        if (sdata.fromDate && sdata.toDate && !sdata.selectedUser) {
                            condition += 's.`timestamp` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59"';
                        }
                        if (sdata.selectedUser && !(sdata.toDate && sdata.fromDate)) {
                            condition += 's.`idaccount`="' + sdata.selectedUser + '"';
                        }
                        if (sdata.selectedUser && sdata.fromDate && sdata.toDate) {
                            condition += 's.timestamp BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND s.`idaccount`="' + sdata.selectedUser + '"';
                        }
                        obj2.qrysql = "SELECT acc.san, CONCAT(b.firstname,' ', b.lastname) AS `customer_name`, s.email, `amount`, s.`type` , DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id`, `balance_transaction`,  s.`status` FROM `stripe_payment` s LEFT JOIN user_profile b ON s.idaccount = b.account_id  left JOIN `account`acc ON acc.idaccount=b.account_id WHERE " + condition + " GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                    }
                    else {
                        obj2.qrysql = "SELECT acc.san, CONCAT(b.firstname,' ', b.lastname) AS `customer_name`, s.email, `amount`, s.`type` , DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id` ,`balance_transaction`,  s.`status` FROM `stripe_payment` s LEFT JOIN user_profile b ON s.idaccount = b.account_id  LEFT JOIN `account`acc ON acc.idaccount=b.account_id GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                    }
                }
                else {
                    obj2.qrysql = "SELECT acc.san, CONCAT(b.firstname,' ', b.lastname) AS `customer_name`, s.email, `amount`, s.`type` , DATE_FORMAT(s.`timestamp`, '%Y-%m-%d %H:%i:%s')`timestamp`,`description`, `charge_id` ,`balance_transaction`,  s.`status` FROM `stripe_payment` s LEFT JOIN user_profile b ON s.idaccount = b.account_id  LEFT JOIN `account`acc ON acc.idaccount=b.account_id WHERE s.idaccount='" + sessdata.idaccount + "'GROUP BY s.idstripe ORDER BY `timestamp` DESC";
                }
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Payment History Fetched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        })
    }

    stripeCards(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((serr: any, sessdata: any) => {
            if (serr == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result == null || result.length < 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "No Default Card found!", status: 404 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }

    onBoardstripecards(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((serr: any, sessdata: any) => {
            if (serr == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `idstripecard`, `name`, `email`, `last4`,`customer_id`,`con_fullname`, `exp_month`, `exp_year`, `client_ip`, `default`, DATE_FORMAT(`created_at`, '%Y-%m-%d') AS `created_at` FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "' ORDER BY `idstripecard` DESC";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Stripe Cards Not Found!", data: result, status: 400 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    stripeCardForAddBalance(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((serr: any, sessdata: any) => {
            if (serr == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `customer_id` FROM `stripe_card` WHERE `idaccount`='" + sessdata.idaccount + "'AND `default`='true'";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result == null || result.length < 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "No Default Card found!", status: 404 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Stripe Cards Fetched!", data: result, status: 200 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }

    stripeCard(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT `customer_id` FROM `wallet` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            const stripe = stripepay(secret_key);
                            stripe.paymentMethods.list({
                                customer: result[0].customer_id,
                                type: 'card',
                            }, (_err: any, success: any) => {
                                if (!_err) {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Card Details Fetched Succesfully!", data: success, status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Unable to Fetch Card Detail!", status: 404 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Unable to Fetch Card Detail!", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    createCustomerCard(req: Request, res: Response, next: NextFunction) {
        let token: any = req.body.token;
        const stripe = stripepay(secret_key);
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT  u.iduser, u.idaccount,  u.username, u.password, up.firstname, up.lastname, up.email, up.phone, ba.idbilling_address , ba.address1 , ba.address1 , ba.city , ba.state , ba.postal_code , ba.country FROM `user` AS u LEFT JOIN user_profile AS up ON u.iduser=up.iduser LEFT JOIN billing_address AS ba ON u.idaccount=ba.idaccount WHERE u.iduser='" + sessdata.iduser + "'";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        console.log(result);
                        stripe.customers.create(
                            {
                                email: token.email,
                                name: token.card.name,
                                source: token.id,
                                address: {
                                    line1: token.card.address_line1,
                                    city: token.card.address_city,
                                    country: token.card.country,
                                    state: token.card.address_state,
                                    postal_code: token.card.address_zip
                                },
                                metadata: {
                                    name: token.card.name,
                                    contact: result[0].phone,
                                    city: token.card.address_city
                                },
                                // metadata: {
                                //     name: result[0].firstname + " " + result[0].lastname,
                                //     contact: result[0].phone,
                                //     city: result[0].city
                                // },
                                shipping: {
                                    name: token.card.name,
                                    phone: result[0].contact,
                                    address: {
                                        line1: token.card.address_line1,
                                        city: token.card.address_city,
                                        country: token.card.country,
                                        state: token.card.address_state,
                                        postal_code: token.card.address_zip
                                    }
                                },
                                // shipping: {
                                //     name: result[0].firstname + " " + result[0].lastname,
                                //     phone: result[0].contact,
                                //     address: {
                                //         line1: result[0].address1,
                                //         city: result[0].city,
                                //         country: result[0].country,
                                //         state: result[0].state,
                                //         postal_code: result[0].postal_code
                                //     }
                                // },
                            }, (err: any, customer: any) => {
                                if (!err) {
                                    let obj10 = new ModelRawQuery(req, res);
                                    obj10.qrysql = "SELECT * FROM `wallet` WHERE idaccount = '" + sessdata.idaccount + "'";
                                    obj10.prepare();
                                    obj10.execute((_werror: any, __result: any) => {
                                        if (_werror == 1) {
                                            let obj3 = new ModelRawQuery(req, res);
                                            obj3.qrysql = "SELECT * FROM `stripe_card` WHERE `key` = '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "'";
                                            obj3.prepare();
                                            obj3.execute((____error: any, stripeCard: any) => {
                                                if (____error == 1) {
                                                    if (stripeCard.length > 0) {
                                                        let objv1 = new RawView(res);
                                                        objv1.prepare({ data: result, message: "This Card Already Saved!", status: 401 });
                                                        objv1.execute();
                                                    }
                                                    else {
                                                        var defaultCard: any;
                                                        if (__result.length > 0) {
                                                            if (__result[0].customer_id) {
                                                                defaultCard = 'false';
                                                                let obj1 = new ModelRawNonQuery(req, res);
                                                                obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "','" + token.email + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                                obj1.prepare();
                                                                obj1.execute((__werror: any, ___result: any) => {
                                                                    if (__werror == 1) {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Something Went Wrong With Save Stripe Card!", status: 502, data: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                defaultCard = 'true';
                                                                let obj = new ModelRawNonQuery(req, res);
                                                                obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + customer.id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                                obj.prepare();
                                                                obj.execute((werror: any, _result: any) => {
                                                                    if (werror == 1) {
                                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                                        obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                                        obj1.prepare();
                                                                        obj1.execute((__werror: any, ___result: any) => {
                                                                            if (__werror == 1) {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res);
                                                                                objv.prepare({ message: "Something Went Wrong With Save Card", status: 502, data: result });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Something Went Wrong With Update Wallet!", status: 502, data: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                        }
                                                        else {
                                                            let objv1 = new RawView(res);
                                                            objv1.prepare({ data: result, message: "Wallet Not Found For This Account", status: 502 });
                                                            objv1.execute();
                                                        }
                                                    }
                                                }
                                                else {
                                                    let objv1 = new RawView(res);
                                                    objv1.prepare({ data: result, message: "There is no Stripe Card!", status: 502 });
                                                    objv1.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Wallet!", status: 502, data: result });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Invalid Card Detail!", error: err, status: 502, data: result });
                                    objv.execute();
                                }
                            });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Please Update Billing Address!", status: 401 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    onBoardcreateCard(req: Request, res: Response, next: NextFunction) {
        let token: any = req.body.token;
        const stripe = stripepay(secret_key);
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT  u.iduser, u.idaccount,  u.username, u.password, up.firstname, up.lastname, up.email, up.phone, ba.idbilling_address , ba.address1 , ba.address1 , ba.city , ba.state , ba.postal_code , ba.country FROM `user` AS u LEFT JOIN user_profile AS up ON u.iduser=up.iduser LEFT JOIN billing_address AS ba ON u.idaccount=ba.idaccount WHERE u.iduser='" + sessdata.iduser + "' AND u.is_deleted=0";
                obj2.prepare();
                obj2.execute((_error: any, result: any) => {
                    if (_error == 1 && result.length > 0) {
                        stripe.customers.create(
                            {
                                email: token.email,
                                name: token.card.name,
                                source: token.id,
                                address: {
                                    line1: token.card.address_line1,
                                    city: token.card.address_city,
                                    country: token.card.country,
                                    state: token.card.address_state,
                                    postal_code: token.card.address_zip
                                },
                                metadata: {
                                    name: token.card.name,
                                    contact: result[0].phone,
                                    city: token.card.address_city
                                },
                                // metadata: {
                                //     name: result[0].firstname + " " + result[0].lastname,
                                //     contact: result[0].phone,
                                //     city: result[0].city
                                // },
                                shipping: {
                                    name: token.card.name,
                                    phone: result[0].contact,
                                    address: {
                                        line1: token.card.address_line1,
                                        city: token.card.address_city,
                                        country: token.card.country,
                                        state: token.card.address_state,
                                        postal_code: token.card.address_zip
                                    }
                                },
                                // shipping: {
                                //     name: result[0].firstname + " " + result[0].lastname,
                                //     phone: result[0].contact,
                                //     address: {
                                //         line1: result[0].address1,
                                //         city: result[0].city,
                                //         country: result[0].country,
                                //         state: result[0].state,
                                //         postal_code: result[0].postal_code
                                //     }
                                // },
                            }, (err: any, customer: any) => {
                                if (!err) {
                                    let obj10 = new ModelRawQuery(req, res);
                                    obj10.qrysql = "SELECT * FROM `wallet` WHERE idaccount = '" + sessdata.idaccount + "'";
                                    obj10.prepare();
                                    obj10.execute((_werror: any, __result: any) => {
                                     if (_werror == 1) {
                                            let obj3 = new ModelRawQuery(req, res);
                                            obj3.qrysql = "SELECT * FROM `stripe_card` WHERE `key` = '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "' AND `idaccount`='"+ sessdata.idaccount +"'";
                                            obj3.prepare();
                                            obj3.execute((____error: any, stripeCard: any) => {
                                                if (____error == 1) {
                                                   
                                                    if (stripeCard.length > 0) {
                                                        let objv1 = new RawView(res);
                                                        objv1.prepare({ data: result,usedData:stripeCard, message: "This Card Already Saved!", status: 401 });
                                                        objv1.execute();
                                                    }
                                                    else {
                                                        var defaultCard: any;
                                                        if (__result.length > 0) {
                                                            if (__result[0].customer_id) {
                                                                defaultCard = 'false';
                                                                let obj1 = new ModelRawNonQuery(req, res);
                                                                obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`,`email`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "','" + token.email + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                                obj1.prepare();
                                                                obj1.execute((__werror: any, ___result: any) => {
                                                                    let obj2 = new ModelRawQuery(req, res);
                                                                    obj2.qrysql ="SELECT sc.`idstripecard`,sc.`name`,sc.`email`,sc.`exp_month`,sc.`exp_year`,sc.`key`,sc.`last4` ,sc.`client_ip`,DATE_FORMAT(user.`created`, '%Y-%m-%d %T') AS created, sc.`con_fullname` FROM `stripe_card` AS sc JOIN `user` ON user.`idaccount`= sc.`idaccount` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                    // obj2.qrysql = "SELECT `idstripecard`,`name`,`email`,`exp_month`,`exp_year`,`key`,`last4` FROM `stripe_card` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                    obj2.prepare();
                                                                    obj2.execute((_error: any, scRes: any) => {
                                                                        if (__werror == 1) {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result,data1:scRes });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView(res);
                                                                            objv.prepare({ message: "Something Went Wrong With Save Stripe Card!", status: 502, data: result });
                                                                            objv.execute();
                                                                        }

                                                                    })
                                                                    
                                                                });
                                                            }
                                                            else {
                                                                defaultCard = 'true';
                                                                let obj = new ModelRawNonQuery(req, res);
                                                                obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + customer.id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                                                                obj.prepare();
                                                                obj.execute((werror: any, _result: any) => {
                                                                    if (werror == 1) {
                                                                        let obj1 = new ModelRawNonQuery(req, res);
                                                                        obj1.nonqrysql = "INSERT INTO `stripe_card` (`idaccount`, `name`, `key`,`customer_id`,`token`, `card_id`, `card_brand`, `last4`, `cvc_check`, `exp_month`, `exp_year`, `funding`, `client_ip`, `created`,`default`) VALUES ('" + sessdata.idaccount + "', '" + token.card.name + "', '" + token.card.exp_month + "-" + token.card.exp_year + "-" + token.card.last4 + "', '" + customer.id + "', '" + token.id + "', '" + token.card.id + "', '" + token.card.brand + "', '" + token.card.last4 + "', '" + token.card.cvc_check + "', '" + token.card.exp_month + "', '" + token.card.exp_year + "', '" + token.card.funding + "', '" + token.client_ip + "', '" + token.created + "', '" + defaultCard + "')";
                                                                        obj1.prepare();
                                                                        obj1.execute((__werror: any, ___result: any) => {
                                                                            let obj2 = new ModelRawQuery(req, res);
                                                                            obj2.qrysql ="SELECT sc.`idstripecard`,sc.`name`,sc.`email`,sc.`exp_month`,sc.`exp_year`,sc.`key`,sc.`last4` ,sc.`client_ip`,DATE_FORMAT(user.`created`, '%Y-%m-%d %T') AS created, sc.`con_fullname` FROM `stripe_card` AS sc JOIN `user` ON user.`idaccount`= sc.`idaccount` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                            // obj2.qrysql = "SELECT `idstripecard`,`name`,`email`,`exp_month`,`exp_year`,`key`,`last4` FROM `stripe_card` WHERE `idstripecard`='" + ___result.insertId + "'";
                                                                            obj2.prepare();
                                                                            obj2.execute((_error: any, scRes: any) => {
                                                                           
                                                                                if (__werror == 1) {
                                                                                    let objv = new RawView(res);
                                                                                    objv.prepare({ message: "Card Detail Saved Successfully!", status: 201, data: result,data1: scRes});
                                                                                    objv.execute();
                                                                                }
                                                                                else {
                                                                                    let objv = new RawView(res);
                                                                                    objv.prepare({ message: "Something Went Wrong With Save Card", status: 502, data: result });
                                                                                    objv.execute();
                                                                                }
                                                                            })

                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ message: "Something Went Wrong With Update Wallet!", status: 502, data: result });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                        }
                                                        else {
                                                            let objv1 = new RawView(res);
                                                            objv1.prepare({ data: result, message: "Wallet Not Found For This Account", status: 502 });
                                                            objv1.execute();
                                                        }
                                                    }
                                                }
                                                else {
                                                    let objv1 = new RawView(res);
                                                    objv1.prepare({ data: result, message: "There is no Stripe Card!", status: 502 });
                                                    objv1.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Wallet!", status: 502, data: result });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Invalid Card Detail!", error: err, status: 502, data: result });
                                    objv.execute();
                                }
                            });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "User not Authorized or Please Update Billing Address!", status: 401 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    setDfaultCard(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `wallet` SET `customer_id`='" + req.body.customer_id + "' WHERE `idaccount` = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_err: any, result: any) => {
                    if (_err == 1) {
                        let obj1 = new ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "UPDATE `stripe_card` SET `default`= 'false' WHERE idaccount='" + sessdata.idaccount + "'";
                        obj1.prepare();
                        obj1.execute((___err: any, wallet: any) => {
                            if (___err == 1) {
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `stripe_card` SET `default`= 'true' WHERE customer_id='" + req.body.customer_id + "'";
                                obj1.prepare();
                                obj1.execute((__err: any, card: any) => {
                                    if (__err == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Default Card Changed Successfully!", status: 201, data: card });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: card });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: wallet });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    deleteCard(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "DELETE FROM `stripe_card` WHERE `customer_id`='" + req.query.customer_id + "'";
                obj.prepare();
                obj.execute((_err: any, result: any) => {
                    if (_err == 1) {
                        obj.nonqrysql = "UPDATE `wallet` SET `customer_id`=NULL WHERE `customer_id`='" + req.query.customer_id + "'";
                        obj.prepare();
                        obj.execute((_err: any, rescard: any) => { });
                        let objv = new RawView(res);
                        objv.prepare({ message: "Card Deleted Successfully!", status: 201, data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    public saveCardForm(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let sdata = JSON.parse(req.body.data); 
            let formData = sdata.formData;
            let idcard = sdata.idstripecard;
               if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql= "UPDATE `user` SET `isCard`='true' WHERE `idaccount`='" + sessdata.idaccount + "' AND `iduser`='" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error, upRes) => {
                    if (_error == 1) {
                        let obj0 = new ModelRawNonQuery(req, res);
                          obj0.nonqrysql= "UPDATE `stripe_card` SET `con_fullname`='"+formData.con_fullname+"' WHERE `idaccount`='" + sessdata.idaccount + "' AND `idstripecard`='"+idcard+"'"
                        obj0.prepare();
                        obj0.execute((__error, upcardRes) => {

                            let obj5 = new ModelRawNonQuery(req, res);
                            obj5.nonqrysql = "UPDATE `session` SET `isCard`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                            obj5.prepare();
                            obj5.execute((_err: any, user: any) => {
                                if (_err == 1) {
                                    console.log("Session Updated Successfully!");
                                }
                                else {
                                    console.log("Session Not Updated!");
                                }
                                let obj6 = new ModelRawQuery(req, res);
                                obj6.qrysql = "SELECT * FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                obj6.prepare();
                                obj6.execute((_sessError: any, sessData: any) => {
                                    let obj7 = new ModelRawQuery(req, res);
                                    obj7.qrysql ="SELECT `con_fullname` FROM `stripe_card` WHERE `idstripecard`='" + idcard + "'";
                                    obj7.prepare();
                                    obj7.execute((_error: any, scRes: any) => {
                                        if (_sessError == 1) {
                                            let objv = new RawView(res);
                                            objv.prepare({ session: sessData, data: sessData,result:scRes, iduser: sessdata.iduser, message: "Address Saved Successfully!", status: 201 });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Somethng Went Wrong With Get Data!", status: 502 });
                                            objv.execute();
                                        }
                                    })
                                  
                                });
                            });
                          
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something went wrong!", status: 501 });
                        objv.execute();
                    }
                });
                    
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }

    public saveCardPdf(req: Request, res: Response, next: NextFunction) {        
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                if (req.file) {
                    let value: any = '';
                    //let dir = new UploadDirectory();
                    const fileName = req.file.filename; //filename_pdf
                    //value = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;                  
                    value = kycpdf.generateCardPDF + fileName;                  
                    let obj = new ModelRawNonQuery(req, res);
                    // obj.nonqrysql= "UPDATE `user` SET `card_pdf`='"+value+"' WHERE `idaccount`='" + sessData.idaccount + "' AND `iduser`='" + sessData.iduser + "'";
                    obj.nonqrysql= "UPDATE `stripe_card` SET `card_pdf`='"+value+"' WHERE `idaccount`='" + sessData.idaccount + "'";
                    obj.prepare();
                    obj.execute((_error, upRes) => {
                        // if (_error == 1) {
                        //             let objv = new RawView(res);
                        //             objv.prepare({ message: "PDF File Uploaded Successfully", status: 200 });
                        //             objv.execute();
                        //         } else {
                        //             let objv = new RawView(res);
                        //             objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        //             objv.execute();
                        //         }
                    })
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 400, message: 'Something Went Wrong with Connection!' });
                    objv.execute()
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        })
    }

      /**GET Card Pdf For Admin */
      getCardPdfForAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata: any = req.query;
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idaccount`,`card_pdf` FROM `stripe_card`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetch Successfully", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", data: result, status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session trying to access ", status: 401 });
                objv.execute();
            }
        });
    }
}