import { Request, Response, NextFunction } from "express";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { ModelPdfUpload } from "../lib/model/ModelPdfUpload";
import { AppRoute } from "../lib/AppRoute";
import { checkDesc } from "./markError";

export class TierManagement extends AppRoute {

    constructor() {
        super();
    }

    // get Tariffs
    getTraiffs(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM tariff where `idaccount` = '" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    let objv = new RawView(res)
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    })
                    objv.execute()
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    // Get Tariff Via Type

    // get Tariffs
    getTypesTraiffs(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM tariff where `idaccount` = '" + sessdata.idaccount + "' AND `type`= '" + req.query.type + "'";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    let objv = new RawView(res)
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    })
                    objv.execute()
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    // get Tariffs
    getTraiff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM tariff where `idtariff` = '" + req.query.type + "' ";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    let objv = new RawView(res)
                    objv.prepare({ data: allcamp, message: "Data Fetched Succesfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    saveTariff(req: Request, res: Response, next: NextFunction) {
        var rdata: any = [];
        rdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM tariff where name = '" + checkDesc(rdata.name) + "'";
                obj.prepare();
                obj.execute((_error: any, getTariff: any) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Tariff Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new ModelRawQuery(req, res);
                        obj2.filter = null;
                        // obj2.qrysql = "INSERT into tariff (`idaccount`,`name`, `description`, `type`) VALUES('"+sessdata.idaccount+"', '" + rdata.name + "', '" + rdata.description + "', '"+rdata.type+"')";
                        obj2.qrysql = "Call AddTariff('" + sessdata.idaccount + "', 'Registered', '" + checkDesc(rdata.name) + "', '" + checkDesc(rdata.description) + "', '" + rdata.day_num + "')";
                        obj2.prepare();
                        obj2.execute((_error: any, allcamp: any) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (allcamp.length > 0) {
                                let objv = new RawView(res);
                                objv.prepare({ data: allcamp[0], message: "Tariff Saved Successfully", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                        // });
                    }
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    copyTariff(req: Request, res: Response, next: NextFunction) {
        var rdata: any = [];
        rdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM tariff where name = '" + checkDesc(rdata.name) + "'";
                obj.prepare();
                obj.execute((_error: any, getTariff: any) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Tariff Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new ModelRawQuery(req, res);
                        obj2.filter = null;
                        // obj2.qrysql = "INSERT into tariff (`idaccount`,`name`, `description`, `type`) VALUES('"+sessdata.idaccount+"', '" + rdata.name + "', '" + rdata.description + "', '"+rdata.type+"')";
                        obj2.qrysql = "Call AddTariff('" + sessdata.idaccount + "', 'Registered', '" + checkDesc(rdata.name) + "', '" + checkDesc(rdata.description) + "', '" + rdata.day_num + "')";
                        obj2.prepare();
                        obj2.execute((_error: any, allcamp: any) => {
                            // Copy TARIFF
                            if (allcamp.length > 0 && rdata.id) {
                                let IDtar = allcamp[0][0].idtariff;
                                // voice rate Table
                                let obj = new ModelRawQuery(req, res);
                                obj.qrysql = "select * from `voice_rates` where `idtariff` = '" + rdata.id + "' ORDER BY `priority` ASC";
                                obj.prepare();
                                obj.execute((errors: any, data1: any) => {
                                    if (data1.length > 0) {
                                        let result: any = {};
                                        result = data1;
                                        result.forEach((element: any) => {
                                            let obj3 = new ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "UPDATE `voice_rates` SET `rate`='" + element.rate + "', `mo` = '" + element.mo + "', `mt` = '" + element.mt + "' WHERE `idtariff` = '" + IDtar + "' AND `type` = '" + element.type + "' AND `subtype` = '" + element.subtype + "' AND `category` = '" + element.category + "'";
                                            obj3.prepare();
                                            obj3.execute((eror: any, voiceRate: any) => {
                                                // console.log("voiceRate", voiceRate);
                                            });
                                        });

                                        let obj2 = new ModelRawQuery(req, res);
                                        obj2.qrysql = "SELECT `day_num`,`proration` FROM `tariff` WHERE `idtariff`='" + rdata.id + "'";
                                        obj2.prepare();
                                        obj2.execute((error1: any, DayNUM: any) => {
                                            if (DayNUM.length > 0) {
                                                let obj2 = new ModelRawNonQuery(req, res);
                                                obj2.nonqrysql = "UPDATE `tariff` SET `day_num`='" + DayNUM[0].day_num + "',`proration`='" + DayNUM[0].proration + "' WHERE `idtariff` = '" + IDtar + "'";
                                                obj2.prepare();
                                                obj2.execute((error2: any, uDayNUM: any) => {
                                                    // console.log("uDayNUM", uDayNUM);
                                                })
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Voice Rate Not Found!", status: 502 });
                                        objv.execute();
                                    }
                                    // sms rates table
                                    let objs = new ModelRawQuery(req, res);
                                    objs.qrysql = "select * from `sms_rate` where `id_tariff` = '" + rdata.id + "' ORDER BY `priority` ASC";
                                    objs.prepare();
                                    objs.execute((error: any, data2: any) => {
                                        if (data2.length > 0) {
                                            let result2: any = {};
                                            result2 = data2;
                                            result2.forEach((element: any) => {
                                                let obj4 = new ModelRawNonQuery(req, res);
                                                obj4.nonqrysql = "UPDATE `sms_rate` SET `MO_rates`='" + element.MO_rates + "', `MT_rates` = '" + element.MT_rates + "' WHERE `id_tariff` = '" + IDtar + "' AND `type` = '" + element.type + "' AND `category` = '" + element.category + "' AND `subcategory` = '" + element.subcategory + "'";
                                                obj4.prepare();
                                                obj4.execute((error: any, smsRate: any) => {
                                                    // console.log("smsRates", smsRate);
                                                })
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "SMS Rate Not Found!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                });
                                if (allcamp.length > 0) {
                                    let obj1 = new RawView(res);
                                    obj1.prepare({ data: allcamp[0], message: "Tariff Copied Successfully", status: 201 });
                                    obj1.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                    objv.execute();
                                }
                            }
                            else{
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    updateTariff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res)
                let sdata = [];
                sdata = req.body.data;
                obj.qrysql = "UPDATE tariff SET name='" + checkDesc(sdata.name) + "', description='" + checkDesc(sdata.description) + "' WHERE idtariff = '" + sdata.id + "'";
                obj.prepare();
                obj.execute((_error: any, allcamp: any) => {
                    if (_error == 1) {
                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "select * from tariff where idaccount = '" + sessdata.idaccount + "'";
                        obj1.prepare();
                        obj1.execute((__error: any, resResult: any) => {
                            if (__error == 1) {
                                let objv2 = new RawView(res);
                                objv2.prepare({ message: "Rate Plan Update Successfully!", data: resResult, status: 201 });
                                objv2.execute();
                            }
                            else {
                                let objv2 = new RawView(res);
                                objv2.prepare({ message: "Rate Plan Updated Connection break with fetch data!", data: resResult, status: 502 });
                                objv2.execute();
                            }
                        });
                    }
                    else {
                        let objv2 = new RawView(res);
                        objv2.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv2.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    public deleteTariff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, _sessdata: any) => {
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from tariff WHERE idtariff = '" + req.query.id + "'";
            obj.prepare();
            obj.execute((_error: any, lastid: any) => {
                if (_error == 10) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Tariff is already mapped to some accounts!", status: 401 });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Tariff Deleted Successfully", data: lastid[0], status: 201 });
                    objv.execute();
                }
            });
        });
    }


    // Save Tariff 
    saveSurcharge(req: Request, res: Response, next: NextFunction) {
        var rdata: any = [];
        rdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM surcharge where name = '" + rdata.name + "'";
                obj.prepare();
                obj.execute((_error: any, getTariff: any) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Surcharge Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new ModelRawQuery(req, res);
                        obj2.filter = null;
                        obj2.qrysql = "INSERT into surcharge (`idaccount`,`name`, `description`) VALUES ('" + sessdata.idaccount + "', '" + rdata.name + "', '" + rdata.description + "')";
                        obj2.prepare();
                        obj2.execute((_error: any, allcamp: any) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (allcamp) {
                                let objv = new RawView(res);
                                objv.prepare({ data: allcamp, message: "Surcharge Saved Successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong!" });
                                objv.execute();
                            }
                        });
                        // });
                    }
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }

    public updateSurcharge(req: Request, res: Response, next: NextFunction){
        let session =new SessionManagment(req, res, next);
        session.GetSession((error: any, session: any)=>{
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                let Qry:any ='';
                for(let key of Object.keys(rdata)){
                    let num: any = [];
                    num = key.match(/[\d\.]+/g);
                    let index = num.length;
                    let idoperator=num[index-1];
                   // let idoperator = num.at(-1);

                    /*
                    If you will request some data other than priority and rates from angular side, then you will have to change this below condition.
                    */
                   if(key !== 'priority_'+idoperator){
                        if(key !== 'idoperator_'+idoperator){
                            // console.log("keykey",key);
                            let type = key.split('_')[0];
                            let subtype = key.split('_')[1];
                            let direction = key.split('_')[2];
                            Qry += "UPDATE `surcharge_rates` SET `rates`="+rdata[key]+" WHERE `idoperator`= "+idoperator+" AND `type`= '"+type+"' AND `subtype`= '"+subtype+"' AND `direction`= '"+direction+"';\n"
                        }
                    }
                }
                let objk = new ModelRawNonQuery(req, res);
                objk.nonqrysql = Qry
                objk.prepare()
                objk.execute((error: any, data: any) => {
                    if(error == 1){
                        let objv = new RawView(res);
                        objv.prepare({ message: "Surcharge Updated Successfully!", status: 201 });
                        objv.execute();
                    }
                    else{
                        let objv = new RawView(res);
                        objv.prepare({ message: "Surcharge Not Updated Successfully!", status: 502 });
                        objv.execute();
                    }
                    
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }
    public editSurcharge(req: Request, res: Response, next: NextFunction){
        let session =new SessionManagment(req, res, next);
        session.GetSession((error: any, session: any)=>{
            if (error == 1) {
                let rdata: any  = req.body.data;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "UPDATE `surcharge` SET `name`='"+rdata.name+"', `description`='"+rdata.description+"' WHERE `idsurcharge`= '"+rdata.idsurcharge+"'";
                obj.prepare()
                obj.execute((error: any, data: any) => {
                    if(error == 1){
                        let objv = new RawView(res);
                        objv.prepare({ message: "Surcharge Updated Successfully!", status: 201 });
                        objv.execute();
                    }
                    else{
                        let objv = new RawView(res);
                        objv.prepare({ message: "Surcharge Not Updated Successfully!", status: 502 });
                        objv.execute();
                    }
                    
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }


    public updateTariffDay(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "UPDATE `tariff` SET `day_num`='" + rdata.day_num + "' WHERE `idtariff` = '" + rdata.idtariff + "'";
                obj2.prepare();
                obj2.execute((errorr: any, allcamp: any) => {
                    if (errorr == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 201, message: "(" + rdata.day_num + ") Days Updated Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Days Not Updated!" });
                        objv.execute();
                    }
                });

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    updateProRate(req: Request, res: Response, next: NextFunction) {
        let spdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                if (spdata.proration === "true" || spdata.proration === "false") {
                    obj2.qrysql = "UPDATE `tariff` SET `proration`='" + spdata.proration + "' WHERE `idtariff` = '" + spdata.idtariff + "'";
                    obj2.prepare();
                    obj2.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Proration Successfully Updated!", result: result, status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Prorate!", status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Pro-rate!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    // Save Service Profile
    saveServiceProfile(req: Request, res: Response, next: NextFunction) {
        var rdata: any = [];
        rdata = req.body.data;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM service where name = '" + checkDesc(rdata.name) + "'";
                obj.prepare();
                obj.execute((_error: any, getTariff: any) => {
                    if (getTariff.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Service Already Exists!"
                        });
                        objv.execute();
                    }
                    else {
                        let obj2 = new ModelRawQuery(req, res);
                        obj2.filter = null;
                        obj2.qrysql = "INSERT into `service` (`iduser`,`name`, `description`) VALUES ('" + sessdata.iduser + "', '" + checkDesc(rdata.name) + "', '" + checkDesc(rdata.description) + "')";
                        obj2.prepare();
                        obj2.execute((_error: any, allcamp: any) => {
                            // let obj3 = new ModelRawQuery(req, res);
                            // obj3.qrysql = "SELECT `name`, `idtariff` from `tariff` WHERE `idtariff` = '" + allcamp.insertId + "'";
                            // obj3.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ data: allcamp, message: "Service Saved Successfully!" });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!" });
                                objv.execute();
                            }
                        });
                        // });
                    }
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }


    savePreference(req: Request, res: Response, next: NextFunction) {
        let sdata: any = {};
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = [];
                rdata = JSON.parse(req.body.data);
                let tmpqurty = "INSERT INTO `preference` (`idaccount`,`idservice`,`idsupplier`,`priority`, `description`, `type`) VALUES  ";
                rdata.forEach((element: any) => {
                    tmpqurty += "('" + sessdata.idaccount + "', '" + element.idservice + "', '" + element.idsupplier + "','" + element.priority + "','" + 'Description' + "', '" + element.type + "'),";
                });
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Preference Saved Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    updatePreference(req: Request, res: Response, next: NextFunction) {
        let sdata: any = {};
        sdata = req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                sdata.forEach((result: any) => {
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "INSERT INTO `preference` (`idaccount`,`idservice`,`idsupplier`,`priority`, `type`, `key`) VALUE ('" + sessdata.idaccount + "','" + result.idservice + "', '" + result.idsupplier + "','" + result.priority + "', '" + result.type + "', '" + sessdata.idaccount + "-" + result.idservice + "-" + result.type + "-" + result.priority + "' ) ON DUPLICATE KEY UPDATE `idservice`='" + result.idservice + "', `idsupplier`='" + result.idsupplier + "',`priority`='" + result.priority + "', `key`='" + sessdata.idaccount + "-" + result.idservice + "-" + result.type + "-" + result.priority + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    })
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Preference Update Successfully!" });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getPreference(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `preference` WHERE `type` = '" + sdata.type + "' AND `idservice`='" + sdata.idservice + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }

    updatePreferenceService(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            let obj = new ModelRawQuery(req, res)
            let sdata = [];
            sdata = req.body.data;
            obj.qrysql = "UPDATE service SET name='" + checkDesc(sdata.name) + "', description='" + checkDesc(sdata.description) + "' WHERE idservice = '" + sdata.idservice + "'";
            obj.prepare();
            obj.execute((_error: any, allcamp: any) => {
                if (allcamp) {
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "select * from service where iduser = '" + sessdata.iduser + "'";
                    obj1.prepare();
                    obj1.execute((_error: any, resResult: any) => {
                        let objv2 = new RawView(res);
                        objv2.prepare({ message: "Service Profile Update Successfully!", data: resResult });
                        objv2.execute();
                    });
                }
                else {
                    let objv2 = new RawView(res);
                    objv2.prepare({ message: "Something Went Wrong!" });
                    objv2.execute();
                }
            });
        });
    }

    getServiceProfiles(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `service` WHERE `iduser`='" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }

    getServiceProfile(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT * FROM `service` WHERE `idservice`='" + sdata.idservice + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Fetched Data Successfully!", data: result[0] });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
        });
    }

    setDefaultService(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;        
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let obj1 = new ModelRawNonQuery(req, res);
                obj1.nonqrysql = "UPDATE `service` SET `is_default`='false' WHERE `iduser`='" + sdata.data.split('-')[1] + "'";
                obj1.prepare();
                obj1.execute((_error: any, result: any) => {                    
                    if (_error == 1) {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `service` SET `is_default`='true' WHERE `iduser`='" + sdata.data.split('-')[1] + "' AND `idservice`='" + sdata.data.split('-')[0] + "'";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Default Preference Service Changed Successfully!", status: 201 });
                                objv.execute();                                
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Something Went Wrong With Preference Service", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                })
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public deletePreferenceService(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, _sessdata: any) => {
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from `service` WHERE `idservice` = '" + req.query.id + "'";
            obj.prepare();
            obj.execute((_error: any, lastid: any) => {
                if (_error == 10) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Something Went Wrong!" });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Service Profile Deleted Successfully", data: lastid[0] });
                    objv.execute();
                }
            });
        });
    }

    // get Surcharge
    getSurcharges(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT idsurcharge, idaccount, name, description FROM `surcharge` where `idaccount` = '" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    if(_error == 1 && allcamp.length > 0){
                        let objv = new RawView(res)
                        objv.prepare({
                            data: allcamp,
                            message: "Data Fetched Succesfully.",
                            status:200
                        })
                        objv.execute()
                    }
                    else{
                        let objv = new RawView(res)
                        objv.prepare({
                            data: allcamp,
                            message: "No Data Available!",
                            status:502
                        })
                        objv.execute()
                    }
                    
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    getTariffList(req: Request, res: Response, next: NextFunction) {
        console.log(req.query);
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata) => {
            if (err == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "SELECT * FROM tariff";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: data, message: "Tariff Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }
    getSingleTraiff(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        let trfid = req.query.type
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                obj2.qrysql = "SELECT * FROM tariff where `idtariff` = '" + trfid + "' AND `idaccount` = '" + sessdata.idaccount + "'";
                obj2.prepare();
                obj2.execute((_error: any, allcamp: any) => {
                    let objv = new RawView(res)
                    objv.prepare({
                        data: allcamp,
                        message: "Data Fetched Succesfully"
                    })
                    objv.execute()
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No Session Data There");
                objv.execute();
            }
        });
    }
    public deleteSurcharge(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, _sessdata: any) => {
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "delete from surcharge WHERE idsurcharge = '" + req.query.id + "'";
            obj.prepare();
            obj.execute((_error: any, lastid: any) => {
                if (_error == 10) {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Surcharge is already mapped to some Tariff!", status: 200 });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "Surcharge Deleted Successfully", data: lastid[0] });
                    objv.execute();
                }
            });
        });
    }

    // public SaveRate(req: Request, res: Response, next: NextFunction) {
    //     console.log("Data===>"+req.body.data);
    //     console.log("req.query", req.query);
    //     let sdata: any;
    //     try {
    //         sdata = req.body.data;
    //     } catch (e) {
    //         sdata =  req.body.data;
    //     }

    //     console.log(sdata);

    //     let session = new SessionManagment(req, res, next);
    //     let msg = "";
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawNonQuery(req, res);
    //             obj.nonqrysql = "CALL AddBilling('" + sessdata.iduser + "', '"+sdata+"', '20')";
    //             obj.prepare();
    //             obj.execute((error: any, result: any) => {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ data: result[0], message: msg });
    //                 objv.execute();
    //             });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    public SaveRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        let msg = "";

        session.GetSession((error: any, sessdata: any) => {
            let obj2 = new ModelRawQuery(req, res);

            var result: any = [];
            obj2.filter = null;
            let rdata: any = req.body.data;
            rdata.forEach((element: any) => {
                element.forEach((ele: any) => {
                    result[ele.field] = ele.value;
                });
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT into `billing_rate` (`id_tariff`, `idinbound_rates`, `feature`, `usage`, `disconnect`, `setup`, `recurring_mrc`, `port_in_nrc`, `port_out_nrc`) VALUES('" + result.idtariff + "', '" + result.idpriority + "' , '" + result.feature + "', '" + result.usage + "' ,'" + result.disconnect + "', '" + result.setup + "', '" + result.recurringmrc + "', '" + result.portinnrc + "', '" + result.portoutnrc + "')";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                });
            });
            let objv = new RawView(res);
            objv.prepare({ message: "Rate Saved Successfully!" });
            objv.execute();
        });
    }


    updateData(req: Request, res: Response, next: NextFunction) {

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "UPDATE `billing_rate` SET `feature`='" + result.feature + "', `usage`='" + result.usage + "', `disconnect`='" + result.disconnect + "', `setup`='" + result.setup + "', `recurring_mrc`='" + result.recurringmrc + "', `port_in_nrc`='" + result.portinnrc + "', `port_out_nrc`='" + result.portoutnrc + "' WHERE `idbilling_rate`= '" + result.idbillingrate + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    })
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public UploadCSV(req: Request, res: Response, next: NextFunction) {
        let obj = new ModelRawNonQuery(req, res);
        let sdata: any = {};
        let session = new SessionManagment(req, res, next);
        let msg = "";
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                var sdata = req.body;
                let objfile = new ModelPdfUpload(req, res);
                let fdata = objfile.fileUpload();
                let obj = new ModelRawNonQuery(req, res);
                let tier_csv = fdata[0].replace(/"/g, '\\"').replace(/'/g, "\\'")
                obj.nonqrysql = "INSERT INTO `upload` (`FileName`,`DestinationPath`,`FileType`,`UserID`)	VALUES ('" + tier_csv + "', '" + req.file.destination + "', '" + req.body.filetype + "','" + req.body.sessionid + "')";
                obj.prepare();
                obj.execute((error: any, lastid: any) => {
                    let objv = new RawView(res);
                    let filepath = req.file.destination + tier_csv;
                    objv.prepare({ message: "Rate CSV Uploaded Successfully.", insertedid: lastid.insertId, filename: filepath });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getTierFeature(req: Request, res: Response, next: NextFunction) {
        let obj2 = new ModelRawQuery(req, res);
        obj2.qrysql = "SELECT idinbound_rates, feature FROM billing_feature";
        obj2.prepare();
        obj2.execute((error: any, allcamp: any) => {
            let objv = new RawView(res)
            objv.prepare({
                error: 0,
                data: allcamp,
                message: "Data Fetched Successfully"
            })
            objv.execute()
        });
    }

    getBillingRatename(req: Request, res: Response, next: NextFunction) {
        let obj2 = new ModelRawQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            obj2.qrysql = "SELECT * FROM billing_ratename";
            obj2.prepare();
            obj2.execute((error: any, allcamp: any) => {
                let objv = new RawView(res)
                objv.prepare({
                    error: 0,
                    data: allcamp,
                    message: "Data Fetched Succesfully"
                })
                objv.execute()
            });
        });
    }

    public getBillingRate(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            let msg = "";
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select `idbilling_rate`, `id_tariff`, `idinbound_rates`, `feature`, `usage`, `disconnect`, `setup`, `recurring_mrc`, `port_in_nrc`, `port_out_nrc` from `billing_rate` where `id_tariff` = '" + req.query.type + "' ORDER BY `idinbound_rates` ASC";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: result, message: msg });
                    objv.execute();
                });

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // public USA_SMS_Rates(req: Request, res: Response, next: NextFunction) {

    //     let obj = new ModelRawNonQuery(req, res);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    //             obj.nonqrysql = "INSERT into `sms_rate` (`idaccount`, id_tariff, `priority`, `category`, `MO_rates`, `MT_rates`, `subcategory`, `categoryvalue`) VALUES('"+sessdata.idaccount+"', '"+result.idtariff+"', '"+result.priority+"' ,'"+result.category+"', '"+result.MO+"', '"+result.MT+"', '"+result.subCategory+"', '"+result.categoryValue+"')";
    //             obj.prepare();
    //             obj.execute((error: any, data: any) => {
    //              });
    //         });
    //         let objv = new RawView(res);
    //         objv.prepare({ message: "Rate Saved Successfully!" });
    //         objv.execute();
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }


    public Add10DLCA2P(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `10DLC_A2P_surcharge` (`idaccount`, `id_tariff`, `priority` ,`category`, `a`, `b`, `c`, `d`, `e`, `inbound_A2P_surcharge`) VALUES('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + result.priority + "','" + result.category + "', '" + result.a + "', '" + result.b + "', '" + result.c + "', '" + result.d + "', '" + result.e + "', '" + result.inboundA2Psurcharge + "')";
                    obj.prepare();
                    obj.execute((error: any, data: any) => {
                    });
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public TollFreeA2p(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `surcharge_rates` (`idaccount`, `id_tariff`, `type` ,`operator`, `direction`, `sms1`, `sms2`, `mms1`, `mms2`,`a`,`b`,`c`,`d`,`e`,`Inbound_a2p_surcharge`) VALUES('" + sessdata.idaccount + "', '" + element.idtariff + "', '" + element.type + "', '" + element.operator + "', '" + element.direction + "', '" + element.sms1 + "', '" + element.sms2 + "','" + element.sms1 + "', '" + element.sms2 + "', '" + element.a + "', '" + element.b + "','" + element.c + "','" + element.d + "','" + element.e + "', '" + element.inboundA2Psurcharge + "')";
                    obj.prepare();
                    obj.execute((error: any, data: any) => {
                    });
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public ShortCodeRate(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT into `short_code_rates` (`idaccount`, `id_tariff`, `priority` ,`category`, `outbound_message_surcharge`, `inbound_message_surcharge`) VALUES('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + result.priority + "' ,'" + result.category + "', '" + result.outboundSurcharge + "', '" + result.inboundSurcharge + "')";
                    obj.prepare();
                    obj.execute((error: any, data: any) => {
                    });
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rate Saved Successfully!" });
                objv.execute();
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public VoiceRates(req: Request, res: Response, next: NextFunction) {
        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = [];
                result = req.body.data;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT into `voice_rates` (`idaccount`, `id_tariff`, `usa_rate`, `canada_rate`) VALUES('" + sessdata.idaccount + "', '" + result.id_tariff + "', '" + result.cvoicerate + "', '" + result.uvoicerate + "')";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (data) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Rate Saved Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // Get rates 

    public GetUSA_SMS_Rates(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "select * from `sms_rate` where `id_tariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public GetCampaignSur_Rates(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "select  `displayName`,`rate`,`nrc_rates` from `campaign_cases`";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public Get10DLCA2P(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select * from `10DLC_A2P_surcharge` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public GetTollFreeA2p(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {

                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select * from `tollfree_a2p_rates` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "'  ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public GetShortCodeRate(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select * from `short_code_rates` where `id_tariff` = '" + req.query.type + "' AND `idaccount`='" + sessdata.idaccount + "'  ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    public GetVoiceRates(req: Request, res: Response, next: NextFunction) {

        let obj = new ModelRawNonQuery(req, res);
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "Select `id_voicerate`, `id_tariff`, `usa_rate`, `canada_rate` from `voice_rates` where `id_tariff` = '" + req.query.type + "'";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: data[0], message: "Rate Fetched Successfully!" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    // Update Rates

    public update10DLCRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });

                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "UPDATE `10DLC_A2P_surcharge` SET `a`='" + result.a + "', `b` = '" + result.b + "', `c` = '" + result.c + "', `d` = '" + result.d + "', `e`= '" + result.e + "', `inbound_A2P_surcharge` = '" + result.inboundA2Psurcharge + "' WHERE `id_dlc_a2p` = '" + result.iddlca2p + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    });
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public updateTollFreeRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "UPDATE `tollfree_a2p_rates` SET `a`='" + result.a + "', `b` = '" + result.b + "', `c` = '" + result.c + "', `d` = '" + result.d + "', `e`= '" + result.e + "', `inbound_A2P_surcharge` = '" + result.inboundA2Psurcharge + "' WHERE `id_tollfree` = '" + result.idtollfree + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    })
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public updateSMSRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    let idsrt;
                    if (result.idsmsratenew !== null) {
                        idsrt = result.idsmsratenew;
                    } else {
                        idsrt = result.idsmsrate;
                    }
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "UPDATE `sms_rate` SET `MO_rates`='" + result.MO + "', `MT_rates` = '" + result.MT + "' WHERE `idsmsrate` = '" + idsrt + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    })
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public updateShortCodeRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });

                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "UPDATE `short_code_rates` SET `outbound_message_surcharge`='" + result.outboundSurcharge + "', `inbound_message_surcharge`='" + result.inboundSurcharge + "' WHERE `idshort_code` = '" + result.idshortcode + "'";
                    obj2.prepare();
                    obj2.execute((error: any, allcamp: any) => {
                    })
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!" })
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public updateVoiceRate(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj2 = new ModelRawQuery(req, res);
                let rdata = [];
                rdata = req.body.data;
                obj2.filter = null;
                obj2.qrysql = "update `voice_rates` SET `usa_rate`='" + rdata.uvoicerate + "', `canada_rate`='" + rdata.cvoicerate + "' where `id_voicerate` = '" + rdata.id_voicerate + "'";
                obj2.prepare();
                obj2.execute((error: any, allcamp: any) => {
                    if (allcamp) {
                        let objv = new RawView(res)
                        objv.prepare({
                            data: allcamp,
                            message: "Rates Updated successfully!"
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res)
                        objv.prepare({
                            error: error,
                            message: "Something went wrong!"
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }



    // Unregistered Rates 

    addvoiceRates(req: Request, res: Response, next: NextFunction) {

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `mo`, `mt`, `category`) VALUES ";
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    tmpqurty += "('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + result.priority + "', '" + result.type + "', '" + result.subtype + "', '" + result.price + "', '" + result.mo + "','" + result.mt + "', '" + result.category + "' ),";
                });
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Voice Rates Added Successfully!" });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // addiVoiceApiRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // addDepthVoiceRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // addNumberRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // onSipRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `mo`, `mt`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.mo + "', '"+result.mt+"','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // sipNumberPrice(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate` , `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"', '" + result.price + "','" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // onDepthVoiceRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `mo`, `mt`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"', '" + result.priority + "', '"+result.type+"', '"+result.subtype+"','" + result.mo + "', '" + result.mt + "', '" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    onSmsRates(req: Request, res: Response, next: NextFunction) {

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;
                let tmpqurty = "INSERT into `sms_rate` (`idaccount`, id_tariff, `priority`, `category`, `type`, `MO_rates`, `MT_rates`, `subcategory`, `categoryvalue`) VALUES ";
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                    tmpqurty += "('" + sessdata.idaccount + "', '" + result.idtariff + "', '" + result.priority + "' ,'" + result.category + "', '" + result.type + "' ,'" + result.MO + "', '" + result.MT + "', '" + result.subCategory + "', '" + result.categoryValue + "'),";
                });
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = tmpqurty.slice(0, -1);
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    if (result) {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Voice Rates Added Successfully!" });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Somthing Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // numberActivationRates(req: Request, res: Response, next: NextFunction) {

    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let result: any = {};
    //             let rdata: any = [];
    //             rdata = req.body.data;
    //             let tmpqurty="INSERT INTO `voice_rates` (`idaccount`,`idtariff`,`priority`, `type`, `subtype`, `rate`, `category`) VALUES ";
    //             rdata.forEach((element: any) => {
    //                 element.forEach((element: any) => {
    //                     result[element.field] = element.value;
    //                 });
    //                 tmpqurty += "('" + sessdata.idaccount + "', '"+result.idtariff+"','"+result.priority+"', '"+result.type+"', '"+result.subtype+"','" + result.price + "', '" + result.category + "' ),";
    //             });
    //             let obj = new ModelRawNonQuery(req, res);
    // 			obj.nonqrysql =tmpqurty.slice(0, -1);
    // 			obj.prepare();
    // 			obj.execute((error: any, result: any) => {
    // 				if(result){
    // 				let objv = new RawView(res);
    // 				objv.prepare({ message: "Voice Rates Added Successfully!" });
    // 				objv.execute();
    // 				}else{
    // 					let objv = new RawView(res);
    // 					objv.prepare({ message: "Somthing Went Wrong!" });
    // 					objv.execute();	
    // 				}
    // 			});
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    //  Get Rates For Customers
    // subCustomerRates(req: Request, res: Response, next: NextFunction) {
    //     let obj = new ModelRawNonQuery(req, res);
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawQuery(req, res);
    //             obj.qrysql = "select * from `voice_rates` where `idtariff` = '"+sessdata.idtariff+"' AND `type`='"+req.query.type+"' AND `subtype`='"+req.query.subtype+"' ORDER BY `priority` ASC";
    //             obj.prepare();
    //             obj.execute((error: any, data: any) => {
    //                 let objv = new RawView(res);
    //                 objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
    //                 objv.execute();
    //              });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare(session);
    //             objv.execute();
    //         }
    //     });
    // }

    // Get Single Unregistered rates
    voiceApiRates(req: Request, res: Response, next: NextFunction) {
       let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "select * from `voice_rates` where `idtariff` = '" + req.query.idtariff + "' AND `type`='" + req.query.type + "' AND `subtype`='" + req.query.subtype + "' ORDER BY `priority` ASC";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (data.length > 0) {
                        let objv = new RawView(res);
                        objv.prepare({ data: data, message: "Rate Fetched Successfully!" });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // Update Unregistered rates
    unregisteredRates(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let result: any = {};
                let rdata: any = [];
                rdata = req.body.data;   
                let idrats:any = [];
                rdata.forEach((element: any) => {
                    element.forEach((element: any) => {
                        result[element.field] = element.value;
                    });
                  
                    let idrt: any;
                    if (result.idratesnew !== null) {
                        idrt = result.idratesnew;
                    } else {
                        idrt = result.idrates;
                    }
                    if(result.idrates!==null)
                    {
                        idrats.push(result.idrates);
                    }
                    if(result.idrates==null)
                    {
                        console.log("Record Inserted");
                        let obj0 = new ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `idtariff` FROM `voice_rates` WHERE `idrates` IN ('"+idrats+"')";
                        obj0.prepare();
                        obj0.execute((error: any, data: any) => {
                            if(error==1)
                            {
                                let obj1 = new ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT into voice_rates (`idaccount`,`idtariff`, `priority`, `type`, `subtype`,`rate`, `mo`, `mt`,`category`) VALUES ('" + sessdata.idaccount + "', '" + data[0].idtariff + "', '" + 5 + "', 'message', 'message_activation','" + result.price + "','" + result.mo + "','" + result.mt + "','" + result.category + "')";
                                obj1.prepare();
                                obj1.execute((_error: any, res: any) => {
                                    console.log("Rates Updated Successfully!");
                                }) 
                            }
                            else{
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                                objv.execute();
                            }                           
                        })
                        
                    }
                    else {
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `voice_rates` SET `rate`='" + result.price + "', `mo` = '" + result.mo + "', `mt` = '" + result.mt + "' WHERE `idrates` = '" + idrt + "'";
                        obj2.prepare();
                        obj2.execute((__error: any, allcamp: any) => { });
                        
                    }
                });
                let objv = new RawView(res);
                objv.prepare({ message: "Rates Updated Successfully!", status: 201})
                objv.execute();

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    // SELECT tbl.id, tbl.name, CONCAT('{', GROUP_CONCAT(`data`), '}') `data` FROM (SELECT o.id, o.name, sr.type, sr.subtype, sr.direction, CONCAT('\"',sr.type, '_',sr.subtype,'_', sr.direction, '\":',sr.rates) `data` FROM `surcharge_rates` sr LEFT JOIN operator o ON sr.idoperator=o.id GROUP BY o.id, sr.type, sr.subtype, sr.direction) tbl GROUP BY tbl.id

    getSurcharge(req: Request, res: Response, next: NextFunction) {
        console.log(req.query);
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT tbl.id, tbl.name, CONCAT('{', GROUP_CONCAT(`data`), '}') `data` FROM (SELECT o.id, o.name, sr.type, sr.subtype, sr.direction, CONCAT('\"',sr.type, '_',sr.subtype,'_', sr.direction, '\":',sr.rates) `data` FROM `surcharge_rates` sr LEFT JOIN operator o ON sr.idoperator=o.id GROUP BY o.id, sr.type, sr.subtype, sr.direction) tbl GROUP BY tbl.id";
                obj.prepare();
                obj.execute((error: any, data: any) => {
                    if (error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: data, message: "Rate Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare({ message: "You Are Not Authorized!" });
                objv.execute();
            }
        });
    }


}
