import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { VOLT } from "../config/setting.config";
const crypto = require('crypto');
let volt = new VOLT();
export class Volt extends AppRoute {
    constructor() {
        super();
    }

    generateKeyPair() {
        const key = crypto.generateKeyPairSync('ec', {
            namedCurve: 'P-256',
        });

        return {
            privateKey: key.privateKey.export({
                format: 'pem',
                type: 'pkcs8',
            }),
            publicKey: key.publicKey.export({
                format: 'pem',
                type: 'spki',
            }),
        };
    }

    signMessage(privateKey: any, message: string) {
        const sign = crypto.createSign('SHA256');
        sign.write(message);
        sign.end();
        const signature = sign.sign(privateKey, 'hex');
        return signature;
    }

    public logintoVolt(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let sdata = req.body;
                const volt = new Volt();
                const { privateKey, publicKey } = volt.generateKeyPair();
                const message = 'account_id:' + sdata.idaccount + '|user_id:' + sdata.email + '';
                const hash_message = crypto.createHash('sha256').update(message).digest('hex');
                const signature = volt.signMessage(privateKey, hash_message);
                if(signature){
                    let sdata = req.body;
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT u.volt_status, up.email, u.is_deleted FROM `user` u INNER JOIN `user_profile` up ON u.iduser = up.iduser WHERE up.email = '" + sdata.email + "' AND u.idaccount = '" + sdata.idaccount + "';";
                    obj.prepare();
                    obj.execute((_errorr: any, resultt: any) => {
                        if(_errorr == 1 && resultt.length > 0){
                            if(resultt[0].is_deleted == '0'){
                                if(resultt[0].volt_status == '1'){
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `volt_response` SET `account_id`='" + sdata.idaccount + "',`key`='" + privateKey + "',`signature`='" + signature + "' WHERE `user_id`='" + sdata.email + "'";
                                    obj.prepare();
                                    obj.execute((_error: any, result: any) => {
                                        if (_error == 1 && result.affectedRows > 0) {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Volt Login Successfully.", status: 200, result: { result: result, signature: signature } });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Volt Not Logged In Successfully.", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `user` SET `volt_status`='1' WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj.prepare();
                                    obj.execute((_error: any, result: any) => {
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `volt_response` (`account_id`, `user_id`, `volt_org_id`, `volt_user_id`, `webhook_url`, `status`,`key`,`signature`) VALUES('" + sdata.idaccount + "', '" + sdata.email + "', '' ,'', '', '0', '" + privateKey + "', '" + signature + "')";
                                        obj.prepare();
                                        obj.execute((_error: any, result1: any) => {
                                            if (_error == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Volt Login Successfully!", status: 200, result: { result: result, signature: signature } });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Volt Not Logged In Successfully!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    });   
                                }
                            }
                            else{
                                let objv = new RawView(res);
                                objv.prepare({ status: 404, message: "User does not exist!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 401, message: "User is not Authorized!" });
                            objv.execute();                    
                        }
                    });
                }
                else{
                    let objv = new RawView(res);
                    objv.prepare({ message: "Volt Not Logged In Successfully!!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }

    public signalmashAuthentication(req: Request, res: Response, next: NextFunction) {
        let token = req.headers.authorization || req.body.authorization || req.query.authorization || req.body.Authorization || req.query.Authorization;
        if (token && token == volt.TOKEN) {
            let sdata = req.body;
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT u.username, u.iduser, u.volt_status, up.email, u.idaccount FROM `user` u INNER JOIN `user_profile` up ON u.iduser = up.iduser WHERE up.email = '" + sdata.user_id + "' AND u.idaccount = '" + sdata.account_id + "' AND u.`is_deleted`='0';";
            obj.prepare();
            obj.execute((_error: any, result: any) => {
                if (_error == 1 && result.length > 0) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `volt_response` SET `account_id`='" + sdata.account_id + "',`volt_org_id`='" + sdata.volt_org_id + "',`webhook_url`='" + sdata.webhook_url + "',`volt_user_id`='" + sdata.volt_user_id + "',`status`='1',`updated_at`= NOW() WHERE `user_id`='" + sdata.user_id + "'";
                    obj.prepare();
                    obj.execute((_error2, result2) => {
                        if (_error2 == 1 && result2.affectedRows > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 200, message: "User is Authorized!", data: sdata });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: "User is not Authorized!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 401, message: "User is not Authorized!" });
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView(res);
            objv.prepare({ status: 406, message: "Invalid Token to Access" });
            objv.execute();
        }       
    }
}