"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SessionManagment = exports.CurrentSession = void 0;
const MysqlManager_1 = require("./MysqlManager");
const module_config_1 = require("../../config/module.config");
const _403_1 = require("../view/403");
const md5_1 = __importDefault(require("md5"));
const server_1 = require("../../server");
const server_2 = require("../../server");
const common_lib_1 = require("../../include/common.lib");
class CurrentSession {
    __session;
    __error;
    __message;
    __requestURI = "";
    __config;
    __type;
    get requestURI() {
        return this.__requestURI;
    }
    set requestURI(val) {
        this.__requestURI = val;
    }
    get config() {
        return this.__config;
    }
    set config(val) {
        this.__config = val;
    }
    get type() {
        return this.__type;
    }
    set type(val) {
        this.__type = val;
    }
    get session() {
        return this.__session;
    }
    set session(val) {
        this.__session = val;
    }
    get error() {
        return this.__error;
    }
    set error(val) {
        this.__error = val;
    }
    get message() {
        return this.__message;
    }
    set message(val) {
        this.__message = val;
    }
}
exports.CurrentSession = CurrentSession;
class SessionManagment {
    connection;
    req;
    res;
    next;
    config = new module_config_1.modSession();
    constructor(req, res, next) {
        this.req = req;
        this.res = res;
        this.next = next;
        this.connection = new MysqlManager_1.MysqlManager();
    }
    SetSession(data, callback) {
        this.connection.Open();
        let key;
        if (data.sessionType && data.sessionType == "API")
            key = Buffer.from(data.authkey, "base64").toString("utf8");
        else
            key = (0, md5_1.default)(JSON.stringify(data) + (new Date().getUTCMilliseconds()));
        let tmp = "{\"" + this.config.data.session + "\": \"" + key + "\"}";
        let field = JSON.parse(tmp);
        let sessdata = Object.assign(data, field);
        this.connection.data = sessdata;
        this.connection.sql = "INSERT INTO `" + this.config.data.table + "` SET ?";
        let vrate = new common_lib_1.VoiceRates();
        server_1.sessiondata.set(key, sessdata);
        console.log(sessdata);
        vrate.prepareRate(this.req, this.res, sessdata.idtariff, "voice", (err, resp) => {
            server_2.voicerates.set(key, vrate);
        });
        this.connection.Execute((err, data) => {
            if (err == 1) {
                callback(err, data);
            }
            else {
                let objv = new _403_1.Res403(this.res);
                objv.prepare({ error: "User session cannot created!" });
                objv.execute();
            }
            this.connection.Close();
        });
    }
    GetSession(callback) {
        let akey = this.req.headers.authorization;
        console.log("Current authorization key:: " + akey);
        if (akey == undefined || akey == "") {
            // let objv = new Res406(this.res);
            // objv.prepare({ error: "Invalid session is called to access!" });
            // objv.execute();
            callback(0, {
                message: "Invalid Session you are trying to access",
                error: "Invalid session is called to access!"
            });
            return;
        }
        if (server_1.sessiondata.has(akey)) {
            callback(1, server_1.sessiondata.get(akey));
            return;
        }
        if (server_1.invalidsessdata.has(akey)) {
            console.log("\n====================  Invalid session authenticated   =========================\n", akey);
            // let objv = new Res406(this.res);
            // objv.prepare({ error: "Invalid session is called to access!" });
            // objv.execute();
            callback(0, {
                message: "Invalid Session you are trying to access",
                error: "Invalid session is called to access!"
            });
            return;
        }
        console.log("\n==========================  Session not exists  =================================");
        console.log("==============  Trying to creating new session with this key  ===================\n");
        this.connection.Open();
        this.connection.sql = "SELECT ?? FROM `" + this.config.data.table + "` WHERE ? AND `isDeleted`='0'";
        this.connection.data = [this.config.data.field, { authkey: akey }];
        this.connection.Row((err, data) => {
            if (err == 1) {
                server_1.sessiondata.set(akey, data);
                callback(err, data);
            }
            else {
                console.log("\n====================  Session not exists with this key  =========================\n");
                server_1.invalidsessdata.set(akey, '');
                // let objv = new Res406(this.res);
                // objv.prepare({ error: "Invalid session is called to access!" });
                // objv.execute();
                callback(0, {
                    message: "Invalid Session you are trying to access",
                    error: "Invalid session is called to access!"
                });
            }
            this.connection.Close();
        });
    }
    // public GetSession(callback: (error: any, data: any) => void) {
    //     let akey: any = this.req.headers.authorization;
    //     console.log("Current authorization key:: " + akey);
    //     if (akey == undefined || akey == "") {
    //         // let objv = new Res406(this.res);
    //         // objv.prepare({ error: "Invalid session is called to access!" });
    //         // objv.execute();
    //         callback(0, {
    //             message: "Invalid Session you are trying to access",
    //             error: "Invalid session is called to access!"
    //           });
    //         return;
    //     }
    //     if (sessiondata.has(akey)) {
    //         callback(1, sessiondata.get(akey));
    //         return;
    //     }
    //     if (invalidsessdata.has(akey)) {
    //         console.log("\n====================  Invalid session authenticated   =========================\n", akey);
    //         // let objv = new Res406(this.res);
    //         // objv.prepare({ error: "Invalid session is called to access!" });
    //         // objv.execute();
    //         callback(0, {
    //             message: "Invalid Session you are trying to access",
    //             error: "Invalid session is called to access!"
    //           });
    //         return;
    //     }
    //     console.log("\n==========================  Session not exists  =================================");
    //     console.log("==============  Trying to creating new session with this key  ===================\n");
    //     this.connection.Open();
    //     this.connection.sql = "SELECT ?? FROM `" + this.config.data.table + "` WHERE ? AND `isDeleted`=0";
    //     this.connection.data = [this.config.data.field, { authkey: akey }];
    //     this.connection.Row((err: any, data: any) => {
    //         if (err == 1) {                
    //             sessiondata.set(akey, data);
    //             callback(err, data);
    //         }
    //         else {
    //             console.log("\n====================  Session not exists with this key  =========================\n");
    //             invalidsessdata.set(akey, '');
    //             // let objv = new Res406(this.res);
    //             // objv.prepare({ error: "Invalid session is called to access!" });
    //             // objv.execute();
    //             callback(0, {
    //                 message: "Invalid Session you are trying to access",
    //                 error: "Invalid session is called to access!"
    //               });
    //         }
    //         this.connection.Close();
    //     });
    // }
    DeleteSession(callback) {
        let akey = this.req.headers.authorization;
        console.log("Current authorization key:: " + akey);
        console.log("\n=======================  Deleting current session  ==============================\n");
        this.connection.Open();
        this.connection.sql = " DELETE FROM `" + this.config.data.table + "` WHERE `" + this.config.data.session + "`='" + akey + "'";
        server_1.sessiondata.remove(akey);
        this.connection.Delete((err, data) => {
            callback(err, data);
            this.connection.Close();
        });
    }
    getdata(data, val) {
        Object.entries(data).forEach(([key, value]) => { console.log(key, value); if (key == val)
            return value; });
    }
}
exports.SessionManagment = SessionManagment;
