'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.type = void 0;
const AppRoute_1 = require("../lib/AppRoute");
const campaign_class_1 = require("../include/campaign.class");
const newcampaign_class_1 = require("../include/newcampaign.class");
const tiermanagement_class_1 = require("../include/tiermanagement.class");
const usermanagement_class_1 = require("../include/usermanagement.class");
const smsApi_1 = require("../include/smsApi");
const numberApi_1 = require("../include/numberApi");
const connections_1 = require("../include/connections");
const stripeApi_1 = require("../include/stripeApi");
const reports_class_1 = require("../include/reports.class");
const callApi_1 = require("../include/callApi");
const SwaggerLogin_1 = require("../lib/SwaggerLogin");
const agents_1 = require("../include/agents");
const common_class_1 = require("../include/common.class");
const TwoFactorAuth_1 = require("../include/TwoFactorAuth");
const SignUPLogin_1 = require("../lib/SignUPLogin");
const cnam_1 = require("../include/cnam");
const template_setting_1 = require("../include/template-setting");
const postbackUrl_1 = require("../include/postbackUrl");
const Osr_1 = require("../include/Osr");
const hookUrls_1 = require("../include/hookUrls");
const webhook_class_1 = require("../include/webhook.class");
const Reseller_1 = require("../include/Reseller");
const Commission_1 = require("../include/Commission");
var multer = require('multer');
const extMMS = require("../include/multerlib");
const extractImage = require("../include/multerImage");
var upload = multer({ dest: process.cwd() + "/uploads/" });
exports.type = upload.single('filename');
module.exports = function (app) {
    var tier = new tiermanagement_class_1.TierManagement();
    app.get("/getTariffs", tier.getTraiffs);
    app.get("/getresellerTraiff", tier.getresellerTraiff);
    app.get("/type_tariffs", tier.getTypesTraiffs);
    app.get("/getTariff", tier.getTraiff);
    app.post("/saveTariff", tier.saveTariff);
    app.put("/updateTariff", tier.updateTariff);
    app.delete("/deleteTariff", tier.deleteTariff);
    app.put("/updatetariffday", tier.updateTariffDay);
    app.put("/updateproratesetting", tier.updateProRate);
    app.post("/tier/save_rate", tier.SaveRate);
    app.put("/tier/update_rate", tier.updateData);
    app.post("/uploads/rate_csv", exports.type, tier.UploadCSV);
    app.get("/tier/get_feature", tier.getTierFeature);
    app.get("/tier/get_ratename", tier.getBillingRatename);
    app.get("/tier/billing_rate", tier.getBillingRate);
    // Unregistered Routes
    app.post("/addvoicerates", tier.addvoiceRates);
    // app.post("/ivoiceapirates", tier.addiVoiceApiRates);
    // app.post("/numberrate", tier.addNumberRates);
    // app.post("/depthvoicerate", tier.addDepthVoiceRates);
    // app.post("/siprate", tier.onSipRates);
    // app.post("/sipdepthvoicerate", tier.onDepthVoiceRates);
    // app.post("/sipnumberprice", tier.sipNumberPrice);
    // app.post("/numberactivationrates", tier.numberActivationRates)
    // Customer Rates
    // app.get("/customerrates", tier.subCustomerRates);
    app.get("/unregisteredrates", tier.voiceApiRates);
    app.put("/updateunregisteredrates", tier.unregisteredRates);
    // Add Registered Rates
    app.post("/sms_rates", tier.onSmsRates);
    app.post("/add10dlca2p", tier.Add10DLCA2P);
    app.post("/tollfreerates", tier.TollFreeA2p);
    app.post("/addshortcode", tier.ShortCodeRate);
    app.post("/addvoicerate", tier.VoiceRates);
    app.get("/CampaignReviewRates", tier.CampaignReviewRates);
    // app.get("/brandReviewRates", tier.BrandReviewRates);
    app.get("/getactivate_msg", tier.get_activatemsg);
    app.get("/lookupRates", tier.lookupRates);
    // Get Registered Rates
    app.get("/usa_sms_rates", tier.GetUSA_SMS_Rates);
    app.get("/get10dlca2p", tier.Get10DLCA2P);
    app.get("/gettollfreerate", tier.GetTollFreeA2p);
    app.get("/getshortcode", tier.GetShortCodeRate);
    app.get("/getvoicerate", tier.GetVoiceRates);
    app.get("/getcampaign_rate", tier.GetCampaignSur_Rates);
    // Update Registered Rates
    app.put("/update10DLCRate", tier.update10DLCRate);
    app.put("/updateTollFreeRate", tier.updateTollFreeRate);
    app.put("/updateSMSRate", tier.updateSMSRate);
    app.put("/updateShortCodeRate", tier.updateShortCodeRate);
    app.put("/updateVoiceRate", tier.updateVoiceRate);
    // Surcharge
    app.post("/savesurcharge", tier.saveSurcharge);
    app.get("/surcharge", tier.getSurcharges);
    app.delete("/deletesurcharge", tier.deleteSurcharge);
    // Preference
    app.post("/preferenceservice", tier.saveServiceProfile);
    app.post("/preference", tier.savePreference);
    app.get("/preference", tier.getPreference);
    app.get("/service", tier.getServiceProfiles);
    app.get("/singleservice", tier.getServiceProfile);
    app.put("/updatepreference", tier.updatePreference);
    app.put("/updateservicepreference", tier.updatePreferenceService);
    app.delete("/deleteservice", tier.deletePreferenceService);
    app.get("/getsurcharge", tier.getSurcharge);
    app.get("/tarifflist", tier.getTariffList);
    app.get("/getteriff", tier.getSingleTraiff);
    var user = new usermanagement_class_1.UserManagement();
    /**
     * To authenticate user with TimeZone
     */
    app.post("/login", user.getLogin);
    app.post("/update_sys_tz", user.SaveSysTZ);
    app.post("/admin", user.AdminSave);
    app.post("/user", extractImage, user.SaveUser);
    app.put("/custom/changepassword/", user.ChangePassword);
    app.put("/custom/changepass/", user.ChangePassword);
    app.get("/user", user.UserList);
    app.get("/users", user.ListUsers);
    app.get("/subcustomers", user.subCustomerList);
    app.get("/suppliers", user.getSupplier);
    app.get("/supplier", user.getSuppliers);
    /*added new path for dropdown customers list */
    app.get("/customerList", user.customerList);
    app.get("/singleuser", user.singleUser);
    app.post("/uploads/document_upload", exports.type, user.UploadDocuments);
    app.delete("/deleteUser", user.deleteUser);
    // delete customer own account
    app.put("/deleteAccount", user.DeleteCustomerAccount);
    app.put("/final_delete_account", user.DeleteAccount);
    app.post("/tax_calculation", user.TaxCalculation);
    // app.post("/details_cdr", user.detailsCDR);
    app.post("/add_billing_address", user.addBillingAddress);
    app.post("/get_geo_code", user.getGeoCode);
    app.get("/get_billing_address", user.getBillingAddress);
    app.get("/getInvoice", user.getInvoice);
    app.put("/update_billing_address", user.updateBillingAddress);
    // deleteUserSingleData
    app.delete("/deleteUserSingleData", user.deleteUserSingleData);
    app.post("/saveTheme", user.saveTheme);
    app.put("/updatetheme", extractImage, user.updateTheme);
    app.get("/theme", user.getTheme);
    app.get("/themes", user.getThemes);
    app.post("/signup", user.signUp);
    app.put("/onBoardingVerification", user.onBoardingVerification);
    //Link Generation for reseller Customer
    app.post("/linkGeneration", user.linkGeneration);
    app.get("/getLink", user.getLink);
    app.get("/getsingleLink", user.getsingleLink);
    app.put("/updateLink", user.updatelink);
    app.delete("/deleteURL", user.deleteURL);
    //forgot password start
    app.put("/update-password", user.updatePassword);
    app.post("/forgot-mail", user.sendMailForForgetPass);
    app.get("/verify-token", user.VerifyToken);
    //forgot password end
    app.post("/company", user.updateCompanyProfile);
    app.get("/company", user.getCompanyProfile);
    app.put("/update-tariff", user.updateTariff);
    app.put("/profile-pic", extractImage, user.updateProfilePic);
    app.put("/removeProfile-pic", extractImage, user.removeProfilePic);
    app.put("/uploadFile", extractImage, user.uploadFile);
    app.post("/sendFile", extractImage, user.sendFile);
    app.get("/getFile", user.getFile);
    // app.post("/googleLogin", user.googleLogin);
    app.post("/apiToken", user.apiToken);
    app.get("/apiToken", user.getApiToken);
    app.delete("/apiToken", user.deleteApiToken);
    // Resend Email
    app.post("/resendemail", user.resendEmail);
    // otp
    app.post("/saveotp", user.saveOtp);
    app.post("/verifyOtp", user.verifyOtp);
    /**
     * Other Routes
     */
    app.get("/get_timezones", user.GetTimeZones);
    app.get("/get_user_timezone", user.GetUserTimeZone);
    app.post("/user_timezone", user.UpdateUserTimeZone);
    // Morphing Session 
    app.get("/morphing-session", user.getMorphingSession);
    //Billing Enable or Disable
    app.put("/billingEnable", user.billingEnableOrDisable);
    app.get("/getUrlTariff", user.getUrlTariff);
    app.put("/updateOrdering", user.updateOrdering);
    /**
     * Routes for Panel + Swagger
     */
    const campaign = new campaign_class_1.Campaign();
    //--------------------- brand start--------------------------------------------------------------
    app.post("/addbrand", campaign.addBrand);
    app.post('/sendOTPforBrand', campaign.sendOTPforBrand);
    //app.get("/brand", campaign.getBrand);  // Completed in new with getBrandsDetail  swgr(brand)
    //app.get('/getbrands', campaign.getBrands); //: Completed in new with getbrands
    // app.get("/brandCampaign", campaign.getCampaigns); // Completed in new with brandCampaign
    // app.get('/getBrandsDetail', campaign.getBrandsDetail); //: Completed in new with getBrandsDetail
    //app.post("/registerbrand", campaign.brandRegister); // Completed in new with registerbrand
    // app.put('/updatebrand', campaign.updateBrand); // Completed in new with updateBrand
    //app.get("/brandRelationship", campaign.brandRelationship); // Completed in new with brandRelationship
    //app.get("/brandVertical", campaign.brandVertical);  // Completed in new with brandVertical
    //app.get("/brandEntity", campaign.brandEntityType); // Completed in new with brandEntity
    // app.put('/updateBrandIdentity', campaign.brandIdentityStatusUp); // Completed in new with brandEntity
    // app.get("/brandVettingClass", campaign.brandVettingClass); // Completed in new with brandVettingClass
    // app.get("/brandVettingProvider", campaign.brandVettingProvider); // Completed in new with brandVettingProvider
    // app.get("/brandDCA", campaign.brandDCA); // Completed in new with brandDCA
    // app.get("/altBusinessIdType", campaign.altBusinessIdType); // Completed in new with altBusinessIdType
    // app.post("/applyVetting", campaign.applyVetting); // Completed in new with applyVetting
    // app.put("/importVetting", campaign.importVetting);  // Completed in new with importVetting
    // app.get("/externalVettingList", campaign.externalVettingList); // Completed in new with externalVettingList
    // app.get("/getBrandVettingList", campaign.getBrandVettingList); // Completed in new with (not in use)
    // app.get("/getVettingClass", campaign.getVettingClass); // Completed in new with getVettingClass
    // app.get("/getVettingPartner", campaign.getVettingPartner); // Completed in new with getVettingPartner
    // app.put("/updateVettingForStatus", campaign.externalVettingBulkUpdate); // Completed in new with updateVettingForStatus
    //app.post("/brand_register", campaign.BrandRegister);
    // app.delete('/delete_brand', campaign.DeleteBrand); // Completed in new with deleteBrand
    // -------------------------- brand end--------------------------------------------------
    //----------------------------start campaign---------------------------------------------
    app.post("/addcampaign", campaign.addCampaign);
    app.post("/campaign_register", campaign.CampaignRegister);
    //app.get("/campaignCases", campaign.getCampaignCases); // Completed in new with campaignCases
    // app.put('/updateCSPID', campaign.updateCSPID); // Completed in new with updateCSPID
    // app.get('/getCSP', campaign.getCspId);  // Completed in new with getCSP
    // app.get("/cnpCampaign", campaign.getCNPCampaign); // Completed in new with cnpCampaign
    // app.get("/campaigns", campaign.getCampaign); //  Completed in new with campaigns
    // app.post("/registercampaign", campaign.registerCampaign) // Completed in new with registercampaign   
    // app.delete("/deletecampaign", campaign.deleteCampaign); // Completed in new with deletecampaign
    // app.get("/campcases", campaign.CampaignCases); 
    // app.get("/getCampaignDIDCount", campaign.getCampaignDIDCount); // Completed in new with getCampaignDIDCount
    // app.get("/getCampaignDID", campaign.getCampaignDID); // Completed in new with getCampaignDID
    // app.get("/campaignData", campaign.getCampaignForAdmin); // Completed in new with campaignData
    /** Other APIs */
    //------------------------End campaign----------------------------------------------------------
    /**
    * Routes for Panel + Swagger --for Duplicate New Campaign Routes..
    */
    const newCampaign = new newcampaign_class_1.NewCampaign();
    // Start campaign routing
    app.get("/campaignCases", newCampaign.getCampaignCases); // swagger
    app.get("/campaignCasesPanel", newCampaign.campaignCases); // panel
    app.get("/getMnoList", newCampaign.getMNOList);
    app.get("/brandCampaign", newCampaign.getCampaignByBrandId);
    app.get("/campaigns", newCampaign.getCampaign);
    app.post("/registercampaign", newCampaign.registerCampaign);
    app.put("/updateCampaign", newCampaign.updateCamapign);
    app.put("/autoRenewal", newCampaign.updateAutoRenualCampaign);
    app.get("/campaignDetails", newCampaign.getCampDetails);
    app.get("/mnoMetaData", newCampaign.mnoMetaData); // this will be fetch from campaign and campaign update page
    app.delete("/deletecampaign", newCampaign.deleteCampaign);
    app.get("/mnoDetails", newCampaign.mnoIddetails); // not in use
    app.get("/connPartnersDetails", newCampaign.getConnPartnersDetails); // not in use but connected with anguler 
    app.get("/getResellerDetails", newCampaign.getResellerDetails); // not in use but connected with anguler
    app.get("/qualifyBrandByUsecas", newCampaign.getMnoMetaDataForRegister); // this will be fetch from campaign table
    app.get("/mnoMetaDataDetails", newCampaign.getMnoMetaDataDetails); // this will be fetch from campaign and campaign update page
    // app.get("/getCampaignDetails", newCampaign.campaignDetails); // wrong code
    app.post("/campaignFilter", newCampaign.campaignFilter);
    app.get("/getCampaignDID", newCampaign.getCampaignDID);
    app.get("/getCampaignDIDCount", newCampaign.getCampaignDIDCount);
    app.get("/campaignData", newCampaign.getCampaignForAdmin);
    app.put('/updateCSPID', newCampaign.updateCSPID);
    app.get('/getCSP', newCampaign.getCspId);
    app.get("/cnpCampaign", newCampaign.getCNPCampaign);
    app.post("/CNPcampaignFilter", newCampaign.CNPcampaignFilter);
    app.get("/getCampaignsDetailId", newCampaign.getCampDetailById);
    app.get("/getPlan", newCampaign.getSubscriptionPlan);
    app.get("/brandQualifyByAllUseCases", newCampaign.brandQualifyAllUseCases); // this will be fetch from campaign table
    // End campaign routing
    // start brand and vetting routes
    app.get("/brandRelationship", newCampaign.brandRelationship);
    app.get("/brandVertical", newCampaign.brandVertical);
    app.get("/brandEntity", newCampaign.brandEntityType);
    app.get("/brandIdentityStatus", newCampaign.brandIdentityStatus);
    app.get("/altBusinessIdType", newCampaign.altBusinessIdType);
    app.get("/stockExchange", newCampaign.stockExchange);
    app.get("/brandDCA", newCampaign.brandDCA);
    app.post('/sendOTPforBrand', newCampaign.sendOTPforBrand);
    app.post("/registerbrand", newCampaign.brandRegisterNonBlocking);
    app.get('/brand', newCampaign.getBrandsDetail);
    app.get('/getbrands', newCampaign.getAllBrands);
    app.put("/updateBrand", newCampaign.updateBrand);
    app.put('/updateBrandIdentity', newCampaign.brandIdentityStatusUpdate);
    app.post("/brandFilter", newCampaign.brandFilter);
    app.post("/campaignFilterForBrand", newCampaign.campaignFilterForBrand);
    app.delete("/deleteBrand", newCampaign.deleteBrand);
    app.get("/vettingClass", newCampaign.brandVettingClass);
    app.get("/extVettingProvider", newCampaign.brandVettingProvider);
    app.get("/vettingStatus", newCampaign.brandVettingStatus);
    app.post("/applyVetting", newCampaign.applyVetting);
    app.put("/importVetting", newCampaign.importVetting);
    app.get("/externalVettingList", newCampaign.externalVettingList);
    app.get("/getBrandsVettingList", newCampaign.getBrandsVettingList);
    app.get("/getVettingClass", newCampaign.getVettingClassByEtype);
    app.get("/getVettingPartner", newCampaign.getVettingPartner);
    app.put("/updateVettingForStatus", newCampaign.externalVettingBulkUpdate);
    app.put("/revet", newCampaign.revetBrand);
    //app.post("/createMockCvToken", newCampaign.createMockCvToken);
    //app.get("/getSummeryCDRList", newCampaign.getSummeryCDRList);
    // end brand and vetting routes
    // start reseller  routing
    const reseller = new Reseller_1.Reseller();
    app.post("/saveReseller", reseller.saveReseller);
    app.get("/getReseller", reseller.getReseller);
    app.put("/updateResellerbyID", reseller.updateResellerbyID);
    app.get("/commissionTerm", reseller.commissionTerm);
    const commission = new Commission_1.Commission();
    app.get("/getCommissionPlan", commission.getCommissionPlan);
    app.get("/getCommissionTier", commission.getCommissionTier);
    app.get("/commissionDetailsFilter", commission.commissionFilter);
    app.get("/commSummaryFilter", commission.commSummaryFilter);
    const stripe = new stripeApi_1.StripeApi();
    app.post("/recharge", stripe.RechargeByAdmin);
    app.get("/getbalance", stripe.getBalance);
    app.post("/addbalance", stripe.addBalance);
    app.put("/updatebalance", stripe.updateBalance);
    app.put("/updatepaymentsetting", stripe.updatePaymentSetting);
    app.get("/paymenthistory", stripe.paymentHistory);
    app.get("/stripe-card", stripe.stripeCard);
    app.post("/create-card", stripe.createCustomerCard);
    app.get("/stripe-cards", stripe.stripeCards);
    app.get("/stripe-cards-default", stripe.stripeCardForAddBalance);
    app.put("/set-default-card", stripe.setDfaultCard);
    app.delete("/delete-card", stripe.deleteCard);
    app.get("/getcustbalance", stripe.getcustBalance);
    /**
     * Routes for Panel + Swagger
     */
    var sms = new smsApi_1.Sms();
    app.post("/messages", extMMS, sms.messages);
    app.post("/sms", sms.SendSms);
    app.post("/mms", extMMS, sms.SendMms);
    app.post("/mdrsearch", sms.mdrsearch);
    /**
     * Routes for Panel + Swagger
     */
    var call = new callApi_1.Call();
    app.post("/reptest", call.repTest);
    app.post("/originate", call.MakeOutboundCallToNumber);
    app.post("/senddtmf", call.sendDtmf);
    app.post("/barge", call.Barge);
    app.post("/hangup", call.Hangup);
    app.post("/record", call.Recording);
    app.post("/hold", call.Hold);
    app.post("/transfer", call.CallTransfer);
    app.post("/3waycall", call.ThreeWayCall);
    app.post("/makecall", call.MakeCall);
    app.post("/receiveddtmf", call.recvDtmf);
    //app.post("/blindtansfer",call.blindTransfer);
    app.get("/getcall", call.getChannelList);
    var SignupLog = new SignUPLogin_1.SignUPLogin();
    app.post("/emailverify", SignupLog.SignUPLogin);
    /**
     * Routes for Panel + Swagger
     */
    var cnam = new cnam_1.CnamApi("", "");
    app.post("/cnamadd", cnam.addCnam);
    var SwaggerLog = new SwaggerLogin_1.SwaggerLogin();
    app.post("/apiLogin", SwaggerLog.UserLogin);
    //app.post("/apilogin", SwaggerLog.UserLogin);
    /**
     * Routes for Panel + Swagger
     */
    var osrpi = new Osr_1.OsrApi("", "");
    app.put("/osrupdate", osrpi.updateNumber);
    var numberApi = new numberApi_1.Number();
    app.get("/searchtollfree", numberApi.SearchTolefree);
    app.get("/searchbyrate", numberApi.SearchByRate);
    app.get("/searchbynpa", numberApi.SearchByNpxNaa);
    app.get("/getnumberdetails", numberApi.NetworkOperators);
    app.post("/buy", numberApi.PurchaseDid);
    app.post("/enablesms", numberApi.EnableSMS);
    app.get("/enablesmsstatus", numberApi.RetrievOsr);
    app.get("/enablesmsnotifications", numberApi.RetrievOsrNotification);
    app.delete("/disablesms", numberApi.DeleteNumber);
    app.delete("/disablesinchsms", numberApi.DeleteSinchNumber);
    app.post("/disconnect", numberApi.DisconnectDid);
    app.put("/didienable", numberApi.didEnableDisable);
    app.post("/addtocart", numberApi.onAddToCart);
    app.post("/addAllToCart", numberApi.addAllToCart);
    app.get("/carts", numberApi.getCart);
    app.delete("/deletecart", numberApi.deleteCart);
    app.post("/deletecartItems", numberApi.deleteItems);
    app.delete("/clearcart", numberApi.clearCart);
    app.get("/dids", numberApi.onGetDIDs);
    app.get("/smsdids", numberApi.getSMSTextDid);
    app.post("/exportdid", numberApi.onExportDID);
    app.post("/exportorderdid", numberApi.onExportOrderDID);
    app.get('/didlocationinfo', numberApi.DidLocationInfo);
    app.put("/updatedid", numberApi.updateDid);
    app.put("/selected_dids", numberApi.updateSelectedDid);
    app.get("/getstate", numberApi.GetState);
    app.get("/getratecenter", numberApi.GetRateCenter);
    app.get("/getnpa", numberApi.GetNPA);
    app.get("/getnxx", numberApi.getDisconnectedDid);
    // app.post("/addcart", numberApi.AddCart);
    app.get("/getmdr", numberApi.GetMdr);
    app.get("/getcdr", numberApi.GetCdr);
    app.put("/disconnect-dids", numberApi.disconnectSelectedDid);
    app.get("/getStates", numberApi.getStates);
    app.put("/setConnection", numberApi.updateConnectionOnDid);
    app.post("/buy_dids", numberApi.PurchaseAllDIDs);
    app.post("/create_group_order", numberApi.CreateGroupOrder);
    app.get("/get_orders_history", numberApi.GetOrdersHistory);
    app.get("/view_order_history", numberApi.ViewOrderHistory);
    app.get("/smsProvider", numberApi.getSmsProvider);
    app.get("/getDisconnectedDid", numberApi.getDisconnectedDid);
    app.put("/restoreDisconnectDid", numberApi.restoreDisconnectDid);
    app.get("/custdidscount", numberApi.customerDidsCount);
    /**
     * Routes for Panel + Swagger
     */
    var connection = new connections_1.Connection();
    app.get('/historyDid', connection.getDidHistory);
    // app.get('/historyDid_details', connection.getDidHistoryDetails);
    app.get('/customerHistory_details', connection.getDidHistoryDetails);
    app.get('/campaignHistory_details', connection.getCampaignHistoryDetails);
    app.get("/getconnection", connection.getConnections);
    app.get("/get_inbound", connection.getInbound);
    app.get("/get_outbound", connection.getOutbound);
    app.get("/get_routing", connection.getConnectionData);
    app.get("/get_setting", connection.getExpertSetting);
    app.get("/get_url", connection.getUrlData);
    app.get("/get_urls", connection.getUrlData);
    app.post("/set_url", connection.insertUrlsData);
    app.put("/set_pass", connection.updatePassword);
    app.get("/getIP", connection.getIP);
    app.post("/saveconnection", connection.saveConnection);
    app.delete("/deleteconnection", connection.deleteConnection);
    app.get("/getDid", connection.getDid);
    app.get("/listconnection", connection.listConnections);
    app.get("/singledefconn", connection.UserDefaultConnection);
    app.get("/get_all_Key", connection.AllKeyByConnKey);
    app.post("/addcredential", connection.AddCredential);
    app.post("/addip", connection.AddIP);
    app.put("/update_ip", connection.UpdateIP);
    app.put("/updatefqdn", connection.UpdataFqdn);
    app.post("/addforwardall", connection.AddForwardAll);
    app.put("/updatehookUrls", connection.UpdateHookUrl);
    app.post("/addhookUrls", connection.AddHookUrl);
    app.post("/saveip", connection.saveIP);
    app.put("/updateip", connection.updateIP);
    app.delete("/deleteip", connection.deleteIP);
    app.post("/saveurls", connection.saveUrls);
    app.post("/save_smsinbound", connection.save_smsInbound);
    app.post("/save_smsoutbound", connection.save_smsOutbound);
    app.put("/updateconntechpre", connection.updateConnTeckPre);
    app.put("/updateconnuserpass", connection.updateConnUserPass);
    app.put("/updateconninboundcall", connection.updateConnInboundCall);
    app.put("/updateconnection", connection.updateConnection);
    app.put("/updateconnectionname", connection.updateConnectionName);
    app.put("/updatestatus", connection.updateStatus);
    app.put("/update_fqdn", connection.updateFQDN);
    app.put("/update_urls", connection.updateUrls);
    app.put("/update_expertsetting", connection.updateExpertSetting);
    app.put("/update_inbound", connection.updateInbound);
    app.put("/update_outbound", connection.updateOutbound);
    app.put("/default-connection", connection.setDefaultConnection);
    /**
     * Routes for Panel + Swagger
     */
    const agent = new agents_1.AgentClass();
    app.get("/getsingleagent", agent.getSingleAgent);
    app.get("/getagents", agent.getAgents);
    app.get("/getagent", agent.getAgent);
    app.post("/addagent", agent.addAgent);
    app.patch("/updateagent", agent.updateAgent);
    app.get("/getallagent", agent.getAllAgent);
    app.put("/agentstatus", agent.updateAgentStatus);
    app.delete("/deleteagent", agent.deleteAgent);
    app.get("/getsinglegroup", agent.getSingleGroup);
    app.get("/getgroup", agent.getGroup);
    app.post("/addgroup", agent.addGroup);
    app.patch("/updategroup", agent.updateGroup);
    app.delete("/deletegroup", agent.deleteGroup);
    app.get("/getgroups", agent.getGroups);
    // app.post("/addtiermapping", agent.addMapping);
    // app.get("/getmapping", agent.getMapping);
    // app.put("/updatemapping", agent.updateMapping);
    // app.post("/addmapping", agent.addAgentMapping);
    app.post("/agentlogin", agent.agentLogin);
    app.post("/agentstatus", agent.changeStatus);
    app.get("/agentlogout", agent.agentLogout);
    let mdbreport = new reports_class_1.Reports();
    app.get("/reports/mixed", mdbreport.MixedGraph);
    app.get("/reports/circular", mdbreport.CircularGraph);
    app.get("/reports/data", mdbreport.DataReport);
    app.get("/custom/chartdata", mdbreport.BasicReports);
    var common = new common_class_1.CommonClass();
    app.get("/details_cdr", common.getCdrFilter);
    app.get("/SummeryCdrForm", common.summeryCdrForm);
    app.get("/getmdrfilter", common.getMDRFilter);
    app.get("/summerysmsmdrfilter", common.summeryMDRFilter);
    app.get("/getmmsmdrfilter", common.getMMSMDR);
    app.get("/summerymmsmdrfilter", common.summeryMMSMDR);
    app.get("/monthly-invoice", common.montholyInvoice);
    app.get("/invoice", common.billingInvoice);
    app.get("/get_invoice_tax", common.getInvoiceTax);
    app.get("/operators", common.searchOperators);
    app.post("/upload_lerg", extractImage, common.uploadLergInfo);
    app.post("/upload_zone", extractImage, common.uploadZone);
    app.get("/lerg_category", common.categoryFromLergInfo);
    app.get("/lerg_operators", common.operatorFromLergInfo);
    app.post("/operator-mapping", common.setOperatorMapping);
    app.get("/lerg_info", common.Lerg_Info);
    app.get("/operator-mapping", common.getOperatorMapping);
    app.delete("/delete-mapping", common.deleteMapping);
    app.post('/generate-invoice', common.ganarateInvoice);
    app.get("/invoice-address", common.invoiceBillingAddress);
    app.get("/tmobile-list", common.tMobileReportList);
    app.get("/tmobile-report", common.tMobileReport);
    app.get("/zones", common.getZones);
    app.get("/csvinvoice", common.CsvInvoice);
    app.get("/demo", common.demo);
    app.post("/uploadDid", extractImage, common.uploadDID);
    app.get("/getCampaign", common.getCampaign);
    app.get("/get_connections", common.GetConnections);
    var tmpSetting = new template_setting_1.TemplateSetting();
    app.post("/email-template", tmpSetting.emailTemplate);
    app.delete("/email-template", tmpSetting.deleteEmailTempalte);
    app.get("/email-template", tmpSetting.getEmailTemplate);
    app.get("/email-templates", tmpSetting.getEmailTemplates);
    app.put("/email-template", tmpSetting.updateEmailTemplate);
    app.put("/email-template-status", tmpSetting.updateStatus);
    app.post("/sms-template", tmpSetting.smsTemplate);
    app.put("/sms-template", tmpSetting.updateSmsTemplate);
    app.put("/sms-template-status", tmpSetting.updateStatusSMS);
    app.get("/sms-template", tmpSetting.getSmsTemplate);
    app.get("/sms-templates", tmpSetting.getSmsTemplates);
    app.post("/2fa-template", tmpSetting.twofaTemaplate);
    app.get("/2fa-template", tmpSetting.get2FATemplate);
    app.get("/2fa-templates", tmpSetting.get2FATemplates);
    app.put("/2fa-template", tmpSetting.update2FATemplate);
    app.put("/2fa-defaultTemplate", tmpSetting.setDfaultTemplate);
    app.delete("/2fa-template", tmpSetting.delete2FATemplate);
    app.post("/post_mms", extMMS, tmpSetting.mmsTemplate);
    app.get("/getmms_id", tmpSetting.getMmsTemplate);
    app.get("/getmms", tmpSetting.getMmsTemplates);
    app.put("/update_mms", extMMS, tmpSetting.updateMmsTemplate);
    app.delete("/delete_mms", tmpSetting.deleteMMSTemplate);
    app.get("/refactorTemplate", tmpSetting.refactorTemplate);
    const webhook = new webhook_class_1.Webhook();
    app.get("/webhookCategory", webhook.Webhookcategory);
    app.get("/getEventtype", webhook.geteventType);
    app.post("/addWebhook", webhook.addWebhook);
    app.get("/getWebhook", webhook.getWebhook);
    app.delete("/deleteWebhook", webhook.deleteWebhook);
    app.put("/updateWebhook", webhook.updateWebhook);
    var postback = new postbackUrl_1.Postback();
    app.post("/callbackmms/v1/sinch_mms", postback.postbackMMS);
    app.post("/callbackdlr/v1/sinch_dlr", postback.postbackDLR);
    var hookrate = new hookUrls_1.HookUrls();
    app.get("/getkamrate", hookrate.getRate);
    /**
     * Routes for Panel + Swagger
     */
    const twoFactAuth = new TwoFactorAuth_1.TwoFactorAuth();
    app.post("/sendotpbysms", twoFactAuth.SendOtpBySMS);
    app.post("/sendotpbycall", twoFactAuth.SendOtpByCall);
    app.post("/verifyotp", twoFactAuth.VerifyOtp);
    app.post('/verify-call-otp', twoFactAuth.verifyCallOtp);
    app.post('/sendMMSTemplate', extMMS, twoFactAuth.sendMMSTemplate);
    app.post('/sendotpCall', twoFactAuth.SendOtpByCallOnboarding);
    var obj = new AppRoute_1.AppRoute();
    app.get("/[a-z]{1,20}/[a-z]{1,20}", obj.getMethod);
    app.get("/[a-z]{1,20}", obj.getMethod);
    app.post("/[a-z]{1,20}", obj.postMethod);
    app.put("/[a-z]{1,20}", obj.putMethod);
    app.delete("/[a-z]{1,20}", obj.deleteMethod);
    app.patch("/[a-z]{1,20}", obj.patchMethod);
};
