/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../../base/Page');
import Response = require('../../../../../../http/response');
import V2010 = require('../../../../V2010');
import { SerializableClass } from '../../../../../../interfaces';

/**
 * Initialize the AssignedAddOnExtensionList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param accountSid - The SID of the Account that created the resource
 * @param resourceSid - The SID of the Phone Number to which the Add-on is assigned
 * @param assignedAddOnSid - The SID that uniquely identifies the assigned Add-on installation
 */
declare function AssignedAddOnExtensionList(version: V2010, accountSid: string, resourceSid: string, assignedAddOnSid: string): AssignedAddOnExtensionListInstance;

interface AssignedAddOnExtensionListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AssignedAddOnExtensionContext;
  /**
   * Streams AssignedAddOnExtensionInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: AssignedAddOnExtensionInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams AssignedAddOnExtensionInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: AssignedAddOnExtensionListInstanceEachOptions, callback?: (item: AssignedAddOnExtensionInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a assigned_add_on_extension
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): AssignedAddOnExtensionContext;
  /**
   * Retrieve a single target page of AssignedAddOnExtensionInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: AssignedAddOnExtensionPage) => any): Promise<AssignedAddOnExtensionPage>;
  /**
   * Retrieve a single target page of AssignedAddOnExtensionInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: AssignedAddOnExtensionPage) => any): Promise<AssignedAddOnExtensionPage>;
  /**
   * Lists AssignedAddOnExtensionInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: AssignedAddOnExtensionInstance[]) => any): Promise<AssignedAddOnExtensionInstance[]>;
  /**
   * Lists AssignedAddOnExtensionInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: AssignedAddOnExtensionListInstanceOptions, callback?: (error: Error | null, items: AssignedAddOnExtensionInstance[]) => any): Promise<AssignedAddOnExtensionInstance[]>;
  /**
   * Retrieve a single page of AssignedAddOnExtensionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: AssignedAddOnExtensionPage) => any): Promise<AssignedAddOnExtensionPage>;
  /**
   * Retrieve a single page of AssignedAddOnExtensionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: AssignedAddOnExtensionListInstancePageOptions, callback?: (error: Error | null, items: AssignedAddOnExtensionPage) => any): Promise<AssignedAddOnExtensionPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface AssignedAddOnExtensionListInstanceEachOptions {
  callback?: (item: AssignedAddOnExtensionInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface AssignedAddOnExtensionListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface AssignedAddOnExtensionListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface AssignedAddOnExtensionPayload extends AssignedAddOnExtensionResource, Page.TwilioResponsePayload {
}

interface AssignedAddOnExtensionResource {
  account_sid: string;
  assigned_add_on_sid: string;
  enabled: boolean;
  friendly_name: string;
  product_name: string;
  resource_sid: string;
  sid: string;
  unique_name: string;
  uri: string;
}

interface AssignedAddOnExtensionSolution {
  accountSid?: string;
  assignedAddOnSid?: string;
  resourceSid?: string;
}


declare class AssignedAddOnExtensionContext {
  /**
   * Initialize the AssignedAddOnExtensionContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param accountSid - The SID of the Account that created the resource to fetch
   * @param resourceSid - The SID of the Phone Number to which the Add-on is assigned
   * @param assignedAddOnSid - The SID that uniquely identifies the assigned Add-on installation
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V2010, accountSid: string, resourceSid: string, assignedAddOnSid: string, sid: string);

  /**
   * fetch a AssignedAddOnExtensionInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AssignedAddOnExtensionInstance) => any): Promise<AssignedAddOnExtensionInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class AssignedAddOnExtensionInstance extends SerializableClass {
  /**
   * Initialize the AssignedAddOnExtensionContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - The SID of the Account that created the resource
   * @param resourceSid - The SID of the Phone Number to which the Add-on is assigned
   * @param assignedAddOnSid - The SID that uniquely identifies the assigned Add-on installation
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V2010, payload: AssignedAddOnExtensionPayload, accountSid: string, resourceSid: string, assignedAddOnSid: string, sid: string);

  private _proxy: AssignedAddOnExtensionContext;
  accountSid: string;
  assignedAddOnSid: string;
  enabled: boolean;
  /**
   * fetch a AssignedAddOnExtensionInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AssignedAddOnExtensionInstance) => any): Promise<AssignedAddOnExtensionInstance>;
  friendlyName: string;
  productName: string;
  resourceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uniqueName: string;
  uri: string;
}


declare class AssignedAddOnExtensionPage extends Page<V2010, AssignedAddOnExtensionPayload, AssignedAddOnExtensionResource, AssignedAddOnExtensionInstance> {
  /**
   * Initialize the AssignedAddOnExtensionPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: AssignedAddOnExtensionSolution);

  /**
   * Build an instance of AssignedAddOnExtensionInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AssignedAddOnExtensionPayload): AssignedAddOnExtensionInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AssignedAddOnExtensionContext, AssignedAddOnExtensionInstance, AssignedAddOnExtensionList, AssignedAddOnExtensionListInstance, AssignedAddOnExtensionListInstanceEachOptions, AssignedAddOnExtensionListInstanceOptions, AssignedAddOnExtensionListInstancePageOptions, AssignedAddOnExtensionPage, AssignedAddOnExtensionPayload, AssignedAddOnExtensionResource, AssignedAddOnExtensionSolution }
