'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var AssistantList = require('./v1/assistant').AssistantList;
var RestoreAssistantList = require(
    './v1/restoreAssistant').RestoreAssistantList;
var Version = require('../../base/Version');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize the V1 version of Autopilot
 *
 * @constructor Twilio.Autopilot.V1
 *
 * @property {Twilio.Autopilot.V1.AssistantList} assistants - assistants resource
 * @property {Twilio.Autopilot.V1.RestoreAssistantList} restoreAssistant -
 *          restoreAssistant resource
 *
 * @param {Twilio.Autopilot} domain - The twilio domain
 */
/* jshint ignore:end */
function V1(domain) {
  Version.prototype.constructor.call(this, domain, 'v1');

  // Resources
  this._assistants = undefined;
  this._restoreAssistant = undefined;
}

_.extend(V1.prototype, Version.prototype);
V1.prototype.constructor = V1;

Object.defineProperty(V1.prototype,
  'assistants', {
    get: function() {
      this._assistants = this._assistants || new AssistantList(this);
      return this._assistants;
    }
});

Object.defineProperty(V1.prototype,
  'restoreAssistant', {
    get: function() {
      this._restoreAssistant = this._restoreAssistant || new RestoreAssistantList(this);
      return this._restoreAssistant;
    }
});

module.exports = V1;
