'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignUPLogin = void 0;
const module_config_1 = require("../config/module.config");
const ModelLogin_1 = require("./model/ModelLogin");
const Session_1 = require("./model/Session");
const RawView_1 = require("./view/RawView");
const _403_1 = require("./view/403");
const RawNonQuery_1 = require("./model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const server_1 = require("../server");
const KeyCloak_1 = require("../include/KeyCloak");
const markError_1 = require("../include/markError");
let keycloak = new KeyCloak_1.Keycloak();
class SignUPLogin {
    sessdata;
    constructor() { }
    SignUPLogin(req, res, next) {
        let sdata = req.body;
        let validationKey = req.body.key;
        let isEmailVerify = req.body.isEmailVerify;
        req.body = { validationKey: validationKey, isEmailVerify: isEmailVerify, isMobileVerfy: false };
        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj3.nonqrysql = "UPDATE `user` SET `isEmailVerify`='" + isEmailVerify + "' WHERE `validationKey`='" + validationKey + "' AND `email_verification_date` > DATE_ADD(NOW(), INTERVAL -1 DAY) AND `is_deleted`=0";
        obj3.prepare();
        obj3.execute((_err, __result) => {
            if (_err == 1) {
                if (__result.affectedRows > 0) {
                    let obj = new ModelLogin_1.ModelLogin(req, res);
                    let modEmail = new module_config_1.modEmailVerify();
                    if (obj.prepare(modEmail)) {
                        obj.execute((error, result) => {
                            if (error == 2) {
                                let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                                obj5.qrysql = "SELECT iduser, username FROM `user` WHERE `validationKey`='" + validationKey + "' AND is_deleted=0";
                                obj5.prepare();
                                obj5.execute((__error, user) => {
                                    console.log("user :: ", user[0].username);
                                    if (__error == 1) {
                                        if (user.length > 0) {
                                            let objup = new RawQuery_1.ModelRawQuery(req, res);
                                            objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + user[0].iduser + "'";
                                            objup.prepare();
                                            objup.execute((__errorE, emailE) => {
                                                console.log("sdata.result :: ", sdata.result);
                                                console.log("isMissing(sdata.result) :: ", (0, markError_1.isMissing)(sdata.result));
                                                console.log("isMissing(sdata.result?.password) :: ", (0, markError_1.isMissing)(sdata?.result?.password));
                                                let pass = ((0, markError_1.isMissing)(sdata?.result) || (0, markError_1.isMissing)(sdata?.result?.password)) ? "" : (sdata?.result?.password || "");
                                                keycloak.loginKeyClock(req, res, user[0].username, pass, (errorR, resR) => {
                                                    console.log("Keycloak response ::::: ", resR);
                                                    if (errorR == 1) {
                                                        let authtoken = resR.data.body ? JSON.parse(resR?.data?.body || "") : {};
                                                        console.log("Keycloak Parsed Token:", authtoken);
                                                        let refreshtoken = authtoken.refresh_token ? authtoken.refresh_token : "";
                                                        // let accessToken = authtoken.access_token;
                                                        /* if (accessToken) { */
                                                        const authKey = { authkey: sdata.token };
                                                        let refresh_token = { refresh_token: refreshtoken };
                                                        console.log("SignUPLogin refresh_token ::", refresh_token);
                                                        const Result = Object.assign({}, result, authKey, refresh_token);
                                                        console.log("Result with auth token ::", Result);
                                                        server_1.sessiondata.set(user[0].iduser, Result);
                                                        let session = new Session_1.SessionManagment(req, res, next);
                                                        session.SetSession(Result, (error, sessdata) => {
                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj4.nonqrysql = "UPDATE `session` SET `isEmailVerify`='" + isEmailVerify + "', `sessionType`='PANEL' WHERE `iduser`='" + user[0].iduser + "'";
                                                            obj4.prepare();
                                                            obj4.execute((__err, __result) => {
                                                                if (__err == 1) {
                                                                    console.log("Session Updated.");
                                                                }
                                                                else {
                                                                    console.log("Session Not Updated.");
                                                                }
                                                            });
                                                            let tmp = "{\"email\": \"" + emailE[0].email + "\"}";
                                                            let emType = JSON.parse(tmp);
                                                            let Result1 = Object.assign(Result, emType);
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ session: result.authkey, type: "email", data: Result1, status: 201 });
                                                            objv.execute();
                                                        });
                                                        /* } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 401, message: "Token validation failed." });
                                                            objv.execute();
                                                        } */
                                                    }
                                                    else {
                                                        // Keycloak authentication failed
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 401, message: "Invalid credentials. Username or password is incorrect." });
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "You are trying to access deleted account!", status: 401 });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new _403_1.Res403(res);
                                        objv.prepare({ message: "Database Connection Break", status: 401 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new _403_1.Res403(res);
                                objv.prepare({ message: "Invalid User to set proper session!", status: 401 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new _403_1.Res403(res);
                        objv.prepare({ message: "Opps Something went wrong with Connection!", status: 502 });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Key has expired/Invalid Account!", status: 401 });
                    objv.execute();
                }
            }
        });
    }
}
exports.SignUPLogin = SignUPLogin;
