"use strict";
/**
 * Test examples demonstrating the enhanced axios request function
 * that handles both 2-param and 3-param callback patterns
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.test2ParamCallback = test2ParamCallback;
exports.test3ParamCallback = test3ParamCallback;
exports.testFormDataCallback = testFormDataCallback;
exports.testErrorHandling = testErrorHandling;
const axios_1 = require("./axios");
// Example 1: 2-parameter callback pattern
function test2ParamCallback() {
    const options = {
        method: 'GET',
        url: 'https://jsonplaceholder.typicode.com/posts/1',
        log: true
    };
    // This callback expects only 2 parameters: error and response
    (0, axios_1.request)(options, (error, response) => {
        if (!error) {
            console.log('2-Param Success:', response.statusCode);
            console.log('Response Body:', response.body);
        }
        else {
            console.error('2-Param Error:', error.message);
        }
    });
}
// Example 2: 3-parameter callback pattern
function test3ParamCallback() {
    const options = {
        method: 'POST',
        url: 'https://jsonplaceholder.typicode.com/posts',
        body: JSON.stringify({
            title: 'Test Post',
            body: 'This is a test post',
            userId: 1
        }),
        headers: {
            'Content-Type': 'application/json'
        },
        log: true
    };
    // This callback expects 3 parameters: error, response, and body
    (0, axios_1.request)(options, (error, response, body) => {
        if (!error) {
            console.log('3-Param Success:', response.statusCode);
            console.log('Response Body:', body);
            console.log('Response Object:', response);
        }
        else {
            console.error('3-Param Error:', error.message);
        }
    });
}
// Example 3: Form data with 2-param callback
function testFormDataCallback() {
    const options = {
        method: 'POST',
        url: 'https://httpbin.org/post',
        form: {
            username: 'testuser',
            password: 'testpass'
        },
        log: true
    };
    (0, axios_1.request)(options, (error, response) => {
        if (!error) {
            console.log('Form Data Success:', response.statusCode);
            console.log('Form Response:', response.body);
        }
        else {
            console.error('Form Data Error:', error.message);
        }
    });
}
// Example 4: Error handling with 3-param callback
function testErrorHandling() {
    const options = {
        method: 'GET',
        url: 'https://httpbin.org/status/404', // This will return 404
        log: true
    };
    (0, axios_1.request)(options, (error, response, body) => {
        if (!error) {
            console.log('Unexpected Success:', response.statusCode);
        }
        else {
            console.log('Expected Error:', error.message);
            console.log('Error Response:', response);
            console.log('Error Body:', body);
        }
    });
}
// Usage examples:
// test2ParamCallback();
// test3ParamCallback();
// testFormDataCallback();
// testErrorHandling();
