
import { Request, Response, NextFunction, response } from "express";
import { RawView } from "../lib/view/RawView";
import { SessionManagment } from "../lib/model/Session";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { Number } from "./numberApi";
import parseBody, { checkUserPayload } from "./markError";
import { UserManagement } from "./usermanagement.class";
import { APIBase } from "./APIBase";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
let validuser = new APIBase();
export class AdminApis {
    constructor() {
        // super();
    }

    /******************** *
    * Number APIs Started *
    * =================== *
    ********************* */

    public EnableSMSAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        const sdata = req.body;
                        let userPayLoad1: any = {
                            iduser: sdata.iduser,
                            idaccount: sdata.idaccount
                        }
                        let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let obj1 = new ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT `idtariff` FROM `user` WHERE `idaccount`= '" + sdata.idaccount + "' LIMIT 1";
                        obj1.prepare();
                        obj1.execute((proration_error, tariffdata) => {
                            if (proration_error == 1) {
                                let otherPayLoad = {
                                    idtariff: tariffdata[0].idtariff
                                }
                                let numberapi = new Number();
                                numberapi.EnableSMS(req, res, userPayLoad, otherPayLoad, next);
                            }
                        });
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    public DisableSMSAdmin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, sessdata: any) => {
            if (_error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        const sdata = req.query;
                        let userPayLoad1: any = {
                            iduser: sdata.iduser,
                            idaccount: sdata.idaccount
                        }
                        let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let numberapi = new Number();
                        numberapi.DisableSMS(req, res, userPayLoad, next);
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }




    /******************** *
     * Ob Sip Start       *
     * ================== *
     ******************** */

    public GetBrandedCallerDID(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.query.type;
                        let data = JSON.parse(sdata);
                        let userPayLoad1: any = {
                            iduser: data.iduser,
                            idaccount: data.idaccount
                        }
                        let otherPayLoad: any = {
                            type: data.type,
                        }
                        let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let UM = new UserManagement();
                        UM.Getbrandcallerdid(req, res, userPayLoad, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    public SaveBcidEid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.body.data;
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad: any = {
                            eid: sdata.eid,
                            eidName: sdata.eidName,
                        }
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let UM = new UserManagement();
                        UM.addBcidEid(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    public UpdateBcidEid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.body.data;
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad: any = {
                            eid: sdata.data.eid,
                            eidName: sdata.data.eidName,
                            idbcideid: sdata.id
                        }
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let UM = new UserManagement();
                        UM.editBcidEid(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    public deleteBcidEidById(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.query;
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad: any = {
                            idbcideid: sdata.ID
                        }
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let UM = new UserManagement();
                        UM.deleteBcidEid(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    public getBcidEidDetail(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.body;
                        let data: any = (sdata.data == 'main' || sdata.data == '') ? '' : JSON.parse(sdata.data);

                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }

                        let otherPayLoad: any = {
                            fromDate: data.from_date ?? '',
                            toDate: data.to_date ?? '',
                            eidName: data.EIDName ?? '',
                            eiD: data.bcidEid ?? ''
                        }
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let UM = new UserManagement();
                        UM.getBcidEid(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    public getBcidDidDetail(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.query;
                        let data: any = JSON.parse(sdata.type);
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad: any = {
                            fromDate: data.from_date,
                            toDate: data.to_date,
                            sipID: data.sipname,
                            bcidEID: data.bcidEid,
                            accountID: data.idaccount,
                            did: data.did
                        }
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let UM = new UserManagement();
                        UM.getBcidDid(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    public SaveBcidDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = [];
                        sdata = req.body.data;
                        let sipIP = sdata.sipName?.[0]?.idsipts;
              const rawUserdata = sdata?.san?.[0]?.userdata;

const iduser = (typeof rawUserdata === 'string' && rawUserdata.includes('-'))
  ? rawUserdata.split('-', 1)[0]
  : '';

const idaccount = (typeof rawUserdata === 'string' && rawUserdata.includes('-'))
  ? rawUserdata.split('-', 2)[1] ?? ''
  : '';

const didList = Array.isArray(sdata?.did)
  ? sdata.did.map((d: any) => d?.did)
  : [];


                        let userPayLoad1: any = {
                            iduser: iduser,
                            idaccount: idaccount
                        };

                        let otherPayLoad: any = {
                            idsipts: sipIP,
                            idbcideid: sdata.bcidEid?.[0]?.idbcideid,
                            did: didList
                        };
                        let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let UM = new UserManagement();
                        UM.addBcidDID(req, res, userPayLoad, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    public UpdateBcidDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.body.data;
                      const didList = Array.isArray(sdata?.did)
  ? sdata.did.map((d: any) => d?.did)
  : [];
                        let userPayLoad1: any = {
                            iduser: sdata.data.iduser,
                            idaccount: sdata.data.san
                        }
                        let otherPayLoad: any = {
                            idsipts: sdata.data.sipName,
                            idbcideid: sdata.data.bcidEid,
                            did: didList,
                            idbcidoverride: sdata.id
                        }
                        let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let UM = new UserManagement();
                        UM.editBcidDID(req, res, userPayLoad, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    public deleteBcidDidById(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.query;
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad: any = {
                            idbcidoverride: sdata.ID
                        }
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);

                        let UM = new UserManagement();
                        UM.deleteBcidDID(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    /******************** *
    * Number APIs End     *
    * =================== *
    ********************* */

    /******************** **
    * Hidden Endpoint Start*
    * =================== **
    ********************* */

    public add_user_note(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.body;
                        let data = sdata;
                        if (!sdata.SAN) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 400, message: "SAN is required" });
                            objv.execute();
                            return;
                        }
                        let idacc: any = data.SAN - 100000000;
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `iduser` FROM `user` WHERE `idaccount`='" + idacc + "' AND `type`='2'";
                        obj.prepare();
                        obj.execute((error: any, result: any) => {
                            if (error == 1 && result.length > 0) {
                                let userPayLoad1: any = {
                                    iduser: result[0].iduser,
                                    idaccount: idacc
                                }
                                let otherPayLoad: any = {
                                    description: data.note_description,
                                    files: req.files
                                }
                                let userPayLoad: any = checkUserPayload(userPayLoad1);

                                let UM = new UserManagement();
                                UM.saveusernotefilesforadmin(req, res, userPayLoad, otherPayLoad, next);
                            } else {
                                let objvs = new RawView(res);
                                objvs.prepare({ status: 504, message: "Something went wrong with get user detail!" });
                                objvs.execute();
                            }
                        });

                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    public service_suspend_status(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.body;
                        if (!sdata.SAN) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 400, message: "SAN is required" });
                            objv.execute();
                            return;
                        }
                        let idacc: any = sdata.SAN - 100000000;
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `iduser` FROM `user` WHERE `idaccount`='" + idacc + "' AND `type`='2'";
                        obj.prepare();
                        obj.execute((error: any, result: any) => {
                            if (error == 1 && result.length > 0) {
                                let userPayLoad1: any = {
                                    iduser: result[0].iduser,
                                    idaccount: idacc
                                }
                                let otherPayLoad: any = {
                                    data: sdata.data
                                }
                                let userPayLoad: any = checkUserPayload(userPayLoad1);

                                let UM = new UserManagement();
                                UM.updateserviceforadmin(req, res, userPayLoad, otherPayLoad, next);
                            } else {
                                let objvs = new RawView(res);
                                objvs.prepare({ status: 504, message: "Something Went Wrong wWth Get User Detail!" });
                                objvs.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }

    /******************** **
    * Hidden Endpoint End  *
    * =================== **
    ********************* */

    updatesuspendedlogin(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.body.data;
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `failed_login_account_suspension` SET `failed_Attempt`='0',`suspension_status` = '0'  WHERE `username`='" + parseBody(sdata.username) + "'";
                        obj.prepare();
                        obj.execute((error1: any, result: any) => {
                            if (error1 == 1) {
                                let obj1 = new RawView(res);
                                obj1.prepare({ status: 201 ,message: 'Account re-activated successfully!'});
                                obj1.execute();
                            } else {
                                let obj2 = new RawView(res);
                                obj2.prepare({ status: 502 ,message: 'Something went wrong with re-activate account!'});
                                obj2.execute();
                            }
                        });
                    } else {
                        let objvs = new RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                    }
                });
            } else {
                let objv = new RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
 


}
