import { Request, Response, NextFunction } from "express";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { RawView } from "../lib/view/RawView";
import { parseBody, setToZero } from "./markError";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res405 } from "../lib/view/405";
// import md5 from "md5";
import crypto from 'crypto'


export const URL = require("url").URL;


export class ApplicationAPI {
    authenticate(req: Request, res: Response, next: NextFunction) {
        console.log("Body::\n", req.body)
        console.log("Query::\n", req.query)
        console.log("Host::\n", req.get("host"))
        console.log("Origin::\n", req.get("origin"))
        let responses: any = {
            error: 1,
            message: "",
            data: {}
        }, results: any = {}

        try {
            let sdata: any = req.body.data, //JSON.parse(req.body.data),
                username: string = typeof sdata.username != 'undefined' && sdata.username ? sdata.username : "",
                password: string = typeof sdata.password != 'undefined' && sdata.password ? sdata.password : ""
            if (username && password) {
                let ePass = crypto.createHash('sha256').update(password).digest('hex');
                let iQry = "SELECT us.`iduser`, us.`username`, us.`password`,  us.`type` FROM `user` us\n"
                // iQry += "LEFT JOIN `roles` ur ON ur.iduser = us.type\n"
                iQry += "WHERE us.`username`='" + parseBody(username) + "'";

                let obj: any = new ModelRawQuery(req, res)
                obj.qrysql = iQry
                obj.prepare()
                obj.execute((error: any, result: any) => {
                    if (error == 1) {
                        if (result.length > 0) {
                            if (ePass == crypto.createHash('sha256').update(result[0].password).digest('hex')) {
                                let session = new SessionManagment(req, res, next)
                                session.SetSession(result[0], (error: any, sessdata: any) => {
                                    let obji = new ModelRawNonQuery(req, res)
                                    obji.nonqrysql = "INSERT INTO `user_activity`(`iduser`,`type``) VALUES(" + result[0].id + "," + setToZero(result[0].type) + ",'login')"
                                    obji.prepare()
                                    obji.execute((error: any, activity: any) => {
                                        let obj2 = new ModelRawQuery(req, res)
                                        obj2.qrysql = "SELECT `id`, `name` FROM `campaign` WHERE `id` IN (" + result[0].campaign + ")"
                                        obj2.prepare()
                                        obj2.execute((error: any, allcamp: any) => {
                                            responses.error = 0
                                            responses.message = "Successfully logged In."
                                            responses.data = {
                                                login: result[0],
                                                allcamp: allcamp
                                            }

                                            let objv = new RawView(res)
                                            objv.prepare(responses)
                                            objv.execute()
                                        })
                                    })
                                })
                            } else {
                                responses.message = "Invalid credential!"
                                let objv = new RawView(res)
                                objv.prepare(responses)
                                objv.execute()
                            }
                        } else {
                            responses.message = "User did not found!"
                            let objv = new RawView(res)
                            objv.prepare(responses)
                            objv.execute()
                        }
                    } else {
                        responses.message = "Something went, try again!"
                        let objv = new RawView(res)
                        objv.prepare(responses)
                        objv.execute()
                    }
                })
            } else {
                responses.message = "Invalid credential!"
                let objv = new RawView(res)
                objv.prepare(responses)
                objv.execute()
            }
        } catch (e) {
            console.log("Error :: authenticate::", e);
            //responses.message = e.message
            let objv = new RawView(res)
            objv.prepare(responses)
            objv.execute()
        }
    }

    SessionLogin(req: Request, res: Response, next: NextFunction) {
        let obj = new ModelRawQuery(req, res)
        obj.qrysql = "SELECT us.`iduser`, us.`username`, us.`password`,  us.`type` FROM `session` WHERE `authkey`='" + req.query.type + "'"
        console.log("this is rishabh", req.query.type);
        if (obj.prepare()) {
            obj.execute((_error: any, result: any) => {
                console.log(result)
                if (result.length > 0) {
                    let obj2 = new ModelRawQuery(req, res)
                    obj2.filter = null
                    obj2.qrysql = "SELECT `id`, `name` FROM `campaign` WHERE `id` IN (" + result[0].campaign + ")"
                    obj2.prepare()
                    obj2.execute((error: any, allcamp: any) => {
                        let objv = new RawView(res)
                        objv.prepare({ login: result, allcamp: allcamp })
                        objv.execute()
                    })
                }
            })
        }
        else {
            let objv = new Res405(res)
            objv.prepare({ error: "Few parameter are missing in request" })
            objv.execute()
        }
    }
}