import { SMS } from "./APISMSBase";
import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { Number } from "./numberApi";
import { SessionManagment } from "../lib/model/Session";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { Res406 } from "../lib/view/406";
import { APIBase } from "./APIBase";
import { InteliquentAPI } from "./Inteliquent";
import { parseBody, setToZero } from "./markError";
import { request } from './axios';
const Str = require('@supercharge/strings');

export class InteliquentSMS extends SMS {

    constructor() {
        super();
        this.key = "eFluR1hOVERZZGY3dHc5Tno4dzFaemhtbFpnQzpEendnQjZCMVVKc2JwaUZxRXBieW9MODY0dFR3"
    }

    public SendSms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        let sessdata: any = Data.sessdata
        let sdata: any = req.body;
        let TO = "" + sdata.TO + "";
        let len = TO.length - 10;
        let number_type = this.getType(sdata.TO);
        const uuid = Str.random(30);

        var npa = TO.slice(len, len + 3);
        let iQry: string = "SELECT `MT_rates` FROM `sms_rate` WHERE `id_tariff`='" + sessdata.idtariff + "'  AND `subcategory`='SMS' LIMIT 1;\n\n"
        iQry += "SELECT loc_state FROM `did_location_info` WHERE `npa`='" + npa + "' LIMIT 1;"

        let obj = new ModelRawQuery(req, res);
        obj.qrysql = iQry;
        obj.prepare()
        obj.execute((err: any, resp: any) => {
            let MT_rates: any = Array.isArray(resp[0]) && resp[0].length > 0 ? resp[0][0].MT_rates : 0
            let loc_state: any = Array.isArray(resp[1]) && resp[1].length > 0 ? resp[1][0].loc_state : ""

            // To check MT Rates
            if (MT_rates > 0) {

                // To check DID state
                if (loc_state) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`did_provider`,`dca`,`campaignId`) VALUES('" + uuid + "','" + sdata.TO + "','" + MT_rates + "','" + sdata.FROM + "','" + parseBody(sdata.BODY) + "','dispatched','" + npa + "','" + loc_state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "','" + DIDData.campaignId + "')";
                    obj.prepare();
                    obj.execute((error: any, responce: any) => {
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `send_sms` (`sender`, `receiver`,`msgdata`,`time`,`smsc_id`,`dlr_mask`, `service`) VALUES('" + sdata.FROM + "','" + sdata.TO + "','" + parseBody(sdata.BODY) + "',UNIX_TIMESTAMP(),'" + DIDData.SmsProvider + "','11','" + responce.insertId + "')";
                        obj.prepare();
                        obj.execute((msg_err: any, msg_resp: any) => {
                            if (msg_err == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ status: 201, message: "SMS Submit Successfully", batch_id: uuid });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "somthing went wrong", status: 502 });
                                objv.execute();
                            }
                        })
                    })
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ message: "DID State Not Found!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "MT Rates Not Found!", status: 502 });
                objv.execute();
            }
        })
    }
    // in Working 
    public SendTFSms(req: Request, res: Response, next: NextFunction, sessdata: any, DIDData: any, callback: (err: any, data: any) => void) {
        let intel = new InteliquentAPI("", sessdata, '');
        intel.sendTFSMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView(res);
            objv.prepare({ status: resp.status, message: resp.message, batch_id: resp.batch_id });
            objv.execute();
        });
    }

    // in Working
    public SendTFMms(req: Request, res: Response, next: NextFunction, sessdata: any, DIDData: any, callback: (err: any, data: any) => void) {
        let intel = new InteliquentAPI("", sessdata, '');
        intel.sendTFMMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView(res);
            objv.prepare(resp);
            objv.execute();
        });
    }

    public SendMms(req: Request, res: Response, next: NextFunction, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let len = TO.length - 10;
        let number = new Number();
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView(res);
                        obj.prepare({ "message": "Invalid DID" });
                        obj.execute();
                    } else {
                        let number_type = this.getType(sdata.TO);
                        this.getRate(req, res, sessdata.idtariff, number_type, "SMS", (sms_error, sms_rate) => {
                            if (sms_rate) {
                                var npa = TO.slice(len, len + 3);
                                let obj = new ModelRawQuery(req, res);
                                obj.qrysql = "SELECT loc_state FROM `did_location_info` WHERE `npa`='" + npa + "' LIMIT 1";
                                obj.prepare()
                                obj.execute((err, resp) => {
                                    if (resp.length > 0) {
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`connection_key`,`sms_outbound_key`) VALUES('','" + sdata.TO + "','" + sms_rate[0].MT_rates + "','" + sdata.FROM + "','" + parseBody(sdata.BODY) + "','dispatched','" + npa + "','" + resp[0].loc_state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "')";
                                        obj.prepare();
                                        obj.execute((error: any, responce: any) => {
                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `send_sms` (`sender`, `receiver`,`msgdata`,`time`,`smsc_id`,`dlr_mask`, `service`) VALUES('" + sdata.FROM + "','" + sdata.TO + "','" + parseBody(sdata.BODY) + "',UNIX_TIMESTAMP(),'sinch','11','" + responce.insertId + "')";
                                            obj.prepare();
                                            obj.execute((msg_err: any, msg_resp: any) => {
                                                if (msg_resp.insertId) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ result: "message submit successfully" });
                                                    objv.execute();
                                                } else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ result: "something went wrong" });
                                                    objv.execute();
                                                }
                                            })
                                        })
                                    } else {
                                        callback(err, '');
                                    }
                                })
                            } else {
                                callback(sms_error, '');
                            }
                        })
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });

    }

    public SendSynivMms(req: Request, res: Response, next: NextFunction, Data: any, sms_provider: string, callback: (err: any, data: any) => void) {
        this.saveSynivMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        })
    }

    getSMS(from: string, to: string, content: string, callback: (err: any, data: any) => void) {

    }
    getShortCode(short: any, callback: (err: any, data: any) => void) {

    }

    public SendSCSms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        let sessdata: any = Data.sessdata
        let sdata: any = req.body;
        let TO = "" + sdata.TO + "";
        let len = TO.length - 10;
        let number_type = this.getType(sdata.TO);
        const uuid = Str.random(30);
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT IFNULL(`MT_rates`,0)`MT_rates` FROM `sms_rate` WHERE `id_tariff`=" + sessdata.idtariff + "  AND category='short_code' AND `subcategory`='SMS' LIMIT 1";
        obj.prepare()
        obj.execute((err: any, resp: any) => {
            let MT_rates: any = resp[0].MT_rates
            // To check MT Rates
            if (MT_rates > 0) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`idaccount`,`iduser`,`number_type`,`did_provider`,`dca`,`campaignId`) VALUES('" + uuid + "','" + sdata.TO + "','" + MT_rates + "','" + sdata.FROM + "','" + parseBody(sdata.BODY) + "','dispatched','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + DIDData.DIDProvider + "','" + DIDData.SmsProvider + "','" + DIDData.campaignId + "')";
                obj.prepare();
                obj.execute((error: any, responce: any) => {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `send_sms` (`sender`, `receiver`,`msgdata`,`time`,`smsc_id`,`dlr_mask`, `service`) VALUES('" + sdata.FROM + "','" + sdata.TO + "','" + parseBody(sdata.BODY) + "',UNIX_TIMESTAMP(),'" + DIDData.SmsProvider + "','11','" + responce.insertId + "')";
                    obj.prepare();
                    obj.execute((msg_err: any, msg_resp: any) => {
                        if (msg_err == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 201, result: "SMS Submit Successfully", batch_id: uuid });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ result: "something went wrong", status: 502 });
                            objv.execute();
                        }
                    })
                })

            }
            else {
                let objv = new RawView(res);
                objv.prepare({ result: "MT Rates Not Found!", status: 502 });
                objv.execute();
            }
        })
    }

    public SendSCMms(req: Request, res: Response, next: NextFunction, Data: any, DIDData: any, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let len = TO.length - 10;
        let number = new Number();
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView(res);
                        obj.prepare({ "message": "Invalid DID" });
                        obj.execute();
                    } else {
                        let number_type = this.getType(sdata.TO);
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT IFNULL(`MT_rates`,0)`MT_rates` FROM `sms_rate` WHERE `id_tariff`=" + sessdata.idtariff + "  AND category='short_code' AND `subcategory`='MMS' LIMIT 1";
                        obj.prepare()
                        obj.execute((sms_error: any, sms_rate: any) => {
                            if (sms_rate) {
                                var npa = TO.slice(len, len + 3);
                                let obj = new ModelRawQuery(req, res);
                                obj.qrysql = "SELECT loc_state FROM `did_location_info` WHERE `npa`='" + npa + "' LIMIT 1";
                                obj.prepare()
                                obj.execute((err, resp) => {
                                    if (resp.length > 0) {
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `mdr` (`batch_id`, `to_number`, `MT_rates`,`from_number`, `messsage_body`,`status`,`npa`,`state`,`idaccount`,`iduser`,`number_type`,`connection_key`,`sms_outbound_key`) VALUES('','" + sdata.TO + "','" + sms_rate[0].MT_rates + "','" + sdata.FROM + "','" + parseBody(sdata.BODY) + "','dispatched','" + npa + "','" + resp[0].loc_state + "','" + sessdata.idaccount + "','" + sessdata.iduser + "','" + number_type + "','" + sdata.Connection + "','" + sdata.OutboundSMS + "')";
                                        obj.prepare();
                                        obj.execute((error: any, responce: any) => {
                                            let obj = new ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "INSERT INTO `send_sms` (`sender`, `receiver`,`msgdata`,`time`,`smsc_id`,`dlr_mask`, `service`) VALUES('" + sdata.FROM + "','" + sdata.TO + "','" + parseBody(sdata.BODY) + "',UNIX_TIMESTAMP(),'sinch','11','" + responce.insertId + "')";
                                            obj.prepare();
                                            obj.execute((msg_err: any, msg_resp: any) => {
                                                if (msg_resp.insertId) {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ result: "MMS sent successfully" });
                                                    objv.execute();
                                                } else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ result: "Something went wrong" });
                                                    objv.execute();
                                                }
                                            })
                                        })
                                    } else {
                                        callback(err, '');
                                    }
                                })
                            } else {
                                callback(sms_error, '');
                            }
                        })
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });

    }
}