import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { StripeApi } from "./stripeApi";
import { parseBody, setToZero } from "./markError";
import { APIBase } from "./APIBase";
let rate = new APIBase();

export class SubscriptionManagement {
    constructor() {
    }

    getSubscriptionForterrif(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id,  sa.idaccount,  sa.subscription_id,  sa.quantity AS account_quantity, sa.start_date,  sa.end_date,  sa.status, s.name, s.mrc, s.quantity AS subscription_quantity, s.description, s.proration, s.type, s.billing_frequency, a.san, up.firstname, up.lastname, stm.idtariff FROM subscription_account sa LEFT JOIN subscription s ON sa.subscription_id = s.subscription_id LEFT JOIN `account` a ON sa.idaccount = a.idaccount LEFT JOIN user_profile up ON a.idaccount = up.iduser LEFT JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id WHERE  sa.idaccount = '" + sessdata.idaccount + "' AND stm.idtariff='" + sessdata.idtariff + "'";
                obj.prepare();
                obj.execute((sError: any, sData: any) => {
                    if (sError == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    getsubscriptionforuser(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id,  sa.idaccount,  sa.subscription_id,  sa.quantity AS account_quantity,  sa.start_date,  sa.end_date,  sa.status,  s.name,  s.mrc, s.quantity AS subscription_quantity,  s.description,  s.type,  s.billing_frequency,  a.san,  up.firstname,  up.lastname,  stm.idtariff FROM subscription_account sa LEFT JOIN subscription s ON sa.subscription_id = s.subscription_id LEFT JOIN `account` a ON sa.idaccount = a.idaccount LEFT JOIN user_profile up ON a.idaccount = up.iduser LEFT JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id AND stm.idtariff = (SELECT MAX(idtariff) FROM subscription_tariff_mapping WHERE subscription_id = s.subscription_id) WHERE sa.idaccount = '" + sessdata.idaccount + "' GROUP BY sa.subscription_id, sa.idaccount, sa.act_sub_id";
                obj.prepare();
                obj.execute((sError: any, sData: any) => {
                    if (sError == 1) {

                        let objv = new RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    getUsersubscription(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id,  sa.idaccount,  sa.subscription_id,  sa.quantity AS account_quantity, sa.start_date,  sa.end_date,  sa.status, s.name, s.mrc, s.quantity AS subscription_quantity, s.description, s.type, s.billing_frequency, a.san, up.firstname, up.lastname, stm.idtariff FROM subscription_account sa LEFT JOIN subscription s ON sa.subscription_id = s.subscription_id LEFT JOIN `account` a ON sa.idaccount = a.idaccount LEFT JOIN user_profile up ON a.idaccount = up.iduser LEFT JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id WHERE  sa.idaccount = '" + sessdata.idaccount + "' ";
                obj.prepare();
                obj.execute((sError: any, sData: any) => {
                    if (sError == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    SubscriptionControl(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id, sa.idaccount, sa.subscription_id, sa.quantity AS account_quantity, sa.start_date, sa.end_date, sa.status, s.name, s.mrc, s.quantity AS subscription_quantity, s.description, s.billing_frequency,s.type, a.san, up.firstname, up.lastname FROM subscription_account sa LEFT JOIN subscription s ON sa.subscription_id = s.subscription_id LEFT JOIN `account` a ON sa.idaccount = a.idaccount LEFT JOIN user_profile up ON a.idaccount = up.iduser";
                obj.prepare();
                obj.execute((sError: any, sData: any) => {
                    if (sError == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    SubscriptionControlById(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT sa.act_sub_id, sa.idaccount, sa.subscription_id, sa.quantity AS account_quantity, sa.start_date, sa.end_date, sa.status, s.name, s.mrc, s.quantity AS subscription_quantity, s.description, s.type, s.billing_frequency,a.san,up.firstname,up.lastname FROM subscription_account sa JOIN subscription s ON sa.subscription_id = s.subscription_id JOIN `account` a ON sa.idaccount = a.idaccount JOIN user_profile up ON a.idaccount = up.iduser WHERE sa.idaccount='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((sError: any, sData: any) => {
                    if (sError == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    getSubscription(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT s.`deleted`, CASE s.deleted WHEN '1' THEN 'Active' ELSE 'Inactive' END 'deleted_status',  s.`subscription_id`, s.`mrc`, s.`ts_service`, s.`type`, s.`description`, s.`name`, s.`quantity`, s.`proration`, s.`billing_frequency`,stp.`ts_id`,stp.`ts_description`,stp.`ts_transaction`,stp.`ts_service` FROM `subscription` s LEFT JOIN `avalara_ts_pair` stp ON s.`ts_id` = stp.`ts_id`";
                obj.prepare();
                obj.execute((sError: any, sData: any) => {
                    if (sError == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    public Savesuscriptioncontrolmapping(req: Request, res: Response, sesdata: any, callback: (err: any, data: any) => void) {
        let obj0 = new ModelRawQuery(req, res)
        obj0.qrysql = "SELECT s.subscription_id,s.quantity,s.type FROM subscription s JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id WHERE stm.idtariff = '" + sesdata.idtariff + "'";
        obj0.prepare();
        obj0.execute((err: any, result: any[]) => {
            if (err == 1) {
                if (result.length > 0) {
                    let qrystr = "INSERT INTO `subscription_account` (`idaccount`, `subscription_id`,`quantity`, `start_date`,`end_date`) VALUES ";
                    result.forEach(row => {
                        let endDateModifier = row.type;
                        let currentDate = new Date();
                        let endDate: string;
                        if (endDateModifier == 1) {
                            endDate = '0000-00-00 00:00:00';
                        } else {
                            endDate = currentDate.toISOString().slice(0, 19).replace('T', ' ');
                        }
                        qrystr += "('" + sesdata.idaccount + "', '" + row.subscription_id + "','" + setToZero(row.quantity) + "', NOW(),'" + endDate + "'), ";
                    });
                    qrystr = qrystr.slice(0, -2);
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = qrystr;
                    obj.prepare();
                    obj.execute((err: any) => {
                        if (err == 1) {
                            callback(1, result);
                        } else {
                            callback(0, result);
                        }
                    });
                }
                else {
                    callback(0, result);
                }
            } else {
                callback(0, result);
            }
        })
    }

    saveSubscription(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sssdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !sssdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let billingFrequencyValue: any = (sssdata.billingfrequency == null || sssdata.billingfrequency == "" || sssdata.billingfrequency == 0) ? 0 : 1;
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `subscription` (`mrc`, `ts_service`, `ts_transaction`,`ts_id`,`description`, `name`,  `type`,`quantity`, `proration`, `billing_frequency`) VALUES ('" + setToZero(sssdata.rate) + "', '" + setToZero(sssdata.ts_service) + "',  '" + setToZero(sssdata.ts_transaction) + "','" + setToZero(sssdata.ts_id) + "','" + parseBody(sssdata.description) + "', '" + parseBody(sssdata.name) + "', '" + sssdata.type + "','" + setToZero(sssdata.quantity) + "', '" + sssdata.proration + "',  " + billingFrequencyValue + ")";
                    obj.prepare();
                    obj.execute((sError: any, sData: any) => {
                        if (sError == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 201,
                                message: "Subscription Created Successfully",
                                data: sData
                            });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Something Went Wrong"
                            });
                            objv.execute();
                        }
                    });
                }

            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    deleteSubscription(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sssdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !sssdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `act_sub_id`, `idaccount`, `subscription_id`, `quantity` FROM `subscription_account` WHERE `subscription_id`='" + sssdata + "'";
                    obj1.prepare();
                    obj1.execute((sError: any, result: any) => {
                        if (sError == 1) {
                            if (result.length > 0) {
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE `subscription_account` SET `status` = '0' WHERE `subscription_id`='" + sssdata + "'";
                                obj.prepare();
                                obj.execute((sError: any, sData: any) => {
                                    if (sError == 1) {
                                        let obj2 = new ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "UPDATE `subscription` SET `deleted` = '0' WHERE `subscription_id`='" + sssdata + "'";
                                        obj2.prepare();
                                        obj2.execute((error: any, sdata: any) => {
                                            if (error = 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    status: 200,
                                                    message: "Subscription Inactive Successfully!",
                                                    data: sData
                                                });
                                                objv.execute();
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    status: 502,
                                                    message: "Unable to Inactive subscription!",
                                                    data: sData
                                                });
                                                objv.execute();
                                            }
                                        })
                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            status: 502,
                                            message: "Something Went Wrong"
                                        });
                                        objv.execute();
                                    }
                                });
                            } else {
                                let obj2 = new ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "DELETE FROM `subscription` WHERE `subscription_id`='" + sssdata + "'";
                                obj2.prepare();
                                obj2.execute((sError: any, sData: any) => {
                                    if (sError == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 200, message: "Subscription Deleted Successfully" });
                                        objv.execute();
                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            status: 502,
                                            message: "Something Went Wrong"
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 501, message: "Issue While Fetching Subscription Details!" });
                            objv.execute();
                        }
                    });
                }

            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorized Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    updateSubscription(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sssdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !sssdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let billingFrequencyValue: any = (sssdata.billingfrequency == null || sssdata.billingfrequency == "" || sssdata.billingfrequency == 0) ? 0 : 1;
                    let id = req.query.type
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `subscription` SET `mrc` = '" + sssdata.rate + "',name='" + parseBody(sssdata.name) + "', `ts_service` = '" + setToZero(sssdata.ts_service) + "', `ts_transaction` = '" + setToZero(sssdata.ts_transaction) + "',`ts_id` = '" + setToZero(sssdata.ts_id) + "', `description` = '" + parseBody(sssdata.description) + "', `quantity` = '" + sssdata.quantity + "', `proration` = '" + sssdata.proration + "',`type`='" + sssdata.type + "',billing_frequency='" + billingFrequencyValue + "' WHERE `subscription_id` = '" + id + "'";
                    obj.prepare();
                    obj.execute((sError: any, sData: any) => {
                        if (sError == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 201,
                                message: "Subscription Updated Successfully",
                                data: sData
                            });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Something Went Wrong"
                            });
                            objv.execute();
                        }
                    });
                }

            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    getSingleSubscription(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.params:
                        msg = 'Request params not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `subscription_id`,`mrc`,`billing_frequency`,`ts_service`,`ts_transaction`,`description`, `name`,`quantity`,`proration` FROM `subscription`  WHERE `subscription_id` = '" + req.params.id + "'";
                    obj.prepare();
                    obj.execute((sError: any, sData: any) => {
                        if (sError == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 200,
                                message: "Subscription Fetch Successfull",
                                data: sData
                            });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Something Went Wrong"
                            });
                            objv.execute();
                        }
                    });
                }

            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    //no isue
    getSubsriptionidterrif(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sssdata = req.query;
                let msg: any = '';

                switch (true) {
                    case !req.query:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT s.subscription_id,s.mrc, s.ts_service,s.ts_transaction,s.description,s.name,s.billing_frequency,s.quantity,s.proration,s.type,stm.idtariff FROM subscription s JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id WHERE stm.idtariff = '" + sssdata.type + "'";
                    obj.prepare();
                    obj.execute((sError: any, sData: any) => {
                        if (sError == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 200,
                                message: "Subscription Fetch Successfull",
                                data: sData
                            });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Something Went Wrong"
                            });
                            objv.execute();
                        }
                    });
                }

            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    getSubsriptionterrif(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT s.subscription_id,s.mrc, s.ts_service,s.ts_transaction,s.description,s.name,s.quantity,s.billing_frequency,s.proration,s.type,stm.idtariff FROM subscription s JOIN subscription_tariff_mapping stm ON s.subscription_id = stm.subscription_id";
                obj.prepare();
                obj.execute((sError: any, sData: any) => {
                    if (sError == 1) {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Subscription Fetch Successfull",
                            data: sData
                        });
                        objv.execute();
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    public subscriptiontariffmapping(req: Request, res: Response, subscriptiondata: any[], allcamp: any, callback: (err: any) => void) {
        let tariffData = allcamp[0]?.idtariff ? JSON.stringify(allcamp[0].idtariff) : subscriptiondata[0]?.idtariff;
        let tariffObj = tariffData ? JSON.parse(tariffData) : allcamp;
        let qrystr = "INSERT INTO `subscription_tariff_mapping` (`idtariff`, `subscription_id`, `created_at`) VALUES ";
        subscriptiondata.forEach(subscription => {
            qrystr += "('" + tariffObj + "', '" + subscription.subscription_id + "', NOW()), ";
        });
        qrystr = qrystr.slice(0, -2);
        let obj = new ModelRawNonQuery(req, res);
        obj.nonqrysql = qrystr;
        obj.prepare();
        obj.execute((err: any) => {
            if (err == 1) {
                callback(null);
            } else {
                callback(err);
            }
        });
    }

    getFilterSubscription(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let datas = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !datas:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    // if (sessdata.type == 1) {
                    rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                        if (err == 1) {
                            var sdata = datas;
                            let iQry: string = "",
                                iQN: number = 0,
                                cond: string = "";
                            iQry = `SELECT subscription_id, mrc, ts_service, ts_transaction, description, name, quantity, proration, billing_frequency, type FROM subscription WHERE 1=1 `;

                            if (sdata.rates) {
                                cond += "AND mrc='" + sdata.rates + "' ";
                                iQN++;
                            }
                            if (sdata.quantitys) {
                                cond += "AND quantity='" + sdata.quantitys + "' ";
                                iQN++;
                            }
                            if (sdata.names) {
                                cond += "AND name LIKE '%" + sdata.names + "%' ";
                                iQN++;
                            }
                            if (sdata.typeselect !== undefined && sdata.typeselect !== "" && sdata.typeselect !== '' && sdata.typeselect !== null) {
                                cond += "AND type='" + sdata.typeselect + "' ";
                                iQN++;
                            }
                            if (iQN > 0) {
                                iQry += cond;
                            }
                            iQry += "ORDER BY subscription_id;";
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = iQry;
                            obj.prepare();
                            obj.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "Subscriptions Fetched Successfully.",
                                        status: 201
                                    });
                                    objv.execute();
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "Something Went Wrong!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objvs = new RawView(res);
                            objvs.prepare(dt);
                            objvs.execute();
                        }
                    })

                }

            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }

    getSubscriptionmappedto(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.query:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                        if (err == 1) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `act_sub_id`,`idaccount` ,`subscription_id`,`quantity` FROM `subscription_account` WHERE subscription_id = '" + req.query.type + "'";
                            obj.prepare();
                            obj.execute((sError: any, sData: any) => {
                                if (sError == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 200,
                                        message: "Subscription Fetch Successfull",
                                        data: sData
                                    });
                                    objv.execute();
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 502,
                                        message: "Something Went Wrong"
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objvv = new RawView(res);
                            objvv.prepare(dt);
                            objvv.execute();
                        }
                    });
                }

            }
            else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }


    // public checkbalanceforsubscription(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let spdata = JSON.parse(req.body.data);
    //             let stipedata = spdata;
    //              const idaccount = spdata.sesidaccount ?? spdata.idaccount ?? sessdata.idaccount;
    //              const finalAmount = Math.round(stipedata.amount);
    //             rate.checkBalance(req, res, idaccount, finalAmount, (crErr, crRes,) => {
    //                 if(crErr==0){
    //                     let objv = new RawView(res);
    //                     objv.prepare({ message: "User's Account Balance is Low!", status: 502 ,});
    //                     objv.execute();
    //                 }else{
    //                     let objv = new RawView(res);
    //                     objv.prepare({  status: 200 });
    //                     objv.execute();
    //                 }
    //              })
    //         }
    //         else {
    //             let objv = new RawView(res);
    //             objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
    //             objv.execute();
    //         }
    //     });
    // }

    public Updatesubscriptiontariffmapping(req: Request, res: Response, subscriptiondata: any[], id: any, callback: (err: any) => void) {
        if (!subscriptiondata) {
            subscriptiondata = [];
        }
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "DELETE FROM subscription_tariff_mapping WHERE idtariff = '" + id + "'";
        obj1.prepare();
        obj1.execute((err: any, sData: any) => {
            if (err === 1) {
                if (subscriptiondata.length > 0) {
                    let obj1 = new ModelRawNonQuery(req, res);
                    let qry0 = "INSERT INTO `subscription_tariff_mapping` (`idtariff`, `subscription_id`) VALUES ";

                    for (let i = 0; i < subscriptiondata.length; i++) {
                        let item = subscriptiondata[i];
                        let subscriptionId = (typeof item === "object" && item !== null)
                            ? item.subscription_id
                            : item;

                        qry0 += "('" + id + "','" + subscriptionId + "'),";
                    }

                    obj1.nonqrysql = qry0.slice(0, -1)
                    obj1.prepare();
                    obj1.execute((er: any, result: any) => {
                        if (er == 1) {
                            callback(null);
                        } else {
                            callback(er);
                        }
                    });
                } else {
                    callback(null);
                }
            } else {
                callback(err);
            }
        });
    }

    /* Updatesuscriptioncontrol(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let spdata = JSON.parse(req.body.data);
                let stipedata = spdata;
                const idaccount = spdata.sesidaccount ?? spdata.idaccount ?? sessdata.idaccount;
                let obj1 = new ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `quantity` FROM `subscription_account` WHERE `act_sub_id`='" + spdata.act_sub_id + "'";
                obj1.prepare();
                obj1.execute((err1: any, result1: any) => {
                    if (err1 == 1 && result1.length > 0) {
                        if (spdata.subscription_quantity > result1[0].quantity) {
                            let actualQuantity=spdata.subscription_quantity - result1[0].quantity
                            let rate = new APIBase();
                            rate.prorateCalculatorwallet(req, res,stipedata.subscription_id,stipedata.mrc,stipedata.proration,actualQuantity, (pc_err, prorate1,dataprorate3) => {
                                if (pc_err == 1) {
                                    let finalamount1 = prorate1;
                                    let temp3: string = "{\"amount\": \"" + finalamount1 + "\"}";
                                    let fianlprratedamount = JSON.parse(temp3);
                                    let data1: any = Object.assign(stipedata, fianlprratedamount);
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `subscription_account` SET `idaccount`='" + spdata.idaccount + "', `subscription_id`='" + spdata.subscription_id + "', `quantity`='" + setToZero(spdata.subscription_quantity) + "' WHERE `act_sub_id`='" + spdata.act_sub_id + "'";
                                    obj.prepare();
                                    obj.execute((sError: any, sData: any) => {
                                        if (sError == 1) {
                                            let st = new SubscriptionManagement();
                                            st.subscriptionBalanceDeductfromwallet(req, res, sessdata, data1, spdata, (error, resp) => {
                                                if(error==1){
                                                    
                                                    st.subscriptionlog(req, res, dataprorate3, idaccount, spdata.iduser, (err: any) => {
                                                    });
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: resp.message, status: resp.status });
                                                    objv.execute();
                                                }else{
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: resp.message, status: resp.status });
                                                    objv.execute();
                                                }
                                            });
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                status: 502,
                                                message: "Something Went Wrong"
                                            });
                                            objv.execute();
                                        }
                                    });
                                } 
                                else {
                                    let objvs = new RawView(res);
                                    objvs.prepare({ message: "Faild to Calculate Prorated Amount!", status: 502 });
                                    objvs.execute();
                                }
                            });
                        } 
                        else {
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `subscription_account` SET `idaccount`='" + spdata.idaccount + "', `subscription_id`='" + spdata.subscription_id + "', `quantity`='" + setToZero(spdata.subscription_quantity) + "' WHERE `act_sub_id`='" + spdata.act_sub_id + "'";
                            obj.prepare();
                            obj.execute((sError: any, sData: any) => {
                                if (sError == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Mapped Subscription Updated Successfully", status: 200 });
                                    objv.execute();
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 502,
                                        message: "Something Went Wrong"
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    } else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Subscription not found!",
                            status: 404
                        });
                        objv.execute();
                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    } */

    /* Savesuscriptioncontrol(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let spdata = JSON.parse(req.body.data);
                let stipedata = spdata;
                const idaccount = spdata.sesidaccount ?? spdata.idaccount ?? sessdata.idaccount;
                let type = stipedata.type;
                let currentDate = new Date();
                let endDate: string;
                if (type == 1) {
                    endDate = '0000-00-00 00:00:00';
                } else {
                    endDate = currentDate.toISOString().slice(0, 19).replace('T', ' ');
                }
                let rate = new APIBase();
                rate.prorateCalculatorwallet(req, res,stipedata.subscription_id,stipedata.mrc,stipedata.proration,stipedata.subscription_quantity,(pc_err, prorate1,dataprorate3) => {
                    if(pc_err==1){
                        let finalamount1 = prorate1;
                        let temp3: string = "{\"amount\": \"" + finalamount1 + "\"}";
                        let fianlprratedamount = JSON.parse(temp3);
                        let data1: any = Object.assign(stipedata, fianlprratedamount);

                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `subscription_account` (`idaccount`, `subscription_id`, `quantity`, `start_date`, `end_date`) VALUES ('" + stipedata.idaccount + "', '" + stipedata.subscription_id + "', '" + setToZero(stipedata.subscription_quantity) + "', NOW(), '" + endDate + "')";
                        obj.prepare();
                        obj.execute((sError: any, sData: any) => {
                            if (sError == 1) { 
                                let st = new SubscriptionManagement();
                                st.subscriptionBalanceDeductfromwallet(req, res, sessdata, data1, data1, (error, resp) => {
                                    if(error==1){
                                        st.subscriptionlog(req, res, dataprorate3, idaccount, spdata.iduser, (err: any) => {
                                        });
                                        let objv = new RawView(res);
                                        objv.prepare({ message: resp.message, status: resp.status });
                                        objv.execute();
                                    }else{
                                        let objv = new RawView(res);
                                        objv.prepare({ message: resp.message, status: resp.status });
                                        objv.execute();
                                    }
                                });
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    status: 502,
                                    message: "Something Went Wrong"
                                });
                                objv.execute();
                            }
                        });

                    }else{
                        let objvs = new RawView(res);
                        objvs.prepare({ message: "Faild to Calculate Prorated Amount!", status: 502 });
                         objvs.execute();

                    }
                });
              
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorized Access!", status: 401 });
                objvs.execute();
            }
        });
    } */
    upsubsAcc(req: Request, res: Response, stipedata: any, callback: (err: any, result: any) => void) {
        let obj = new ModelRawNonQuery(req, res);
        obj.nonqrysql = "UPDATE `subscription_account` SET `quantity`='" + setToZero(stipedata.subscription_quantity) + "' WHERE `act_sub_id`='" + stipedata.act_sub_id + "'";
        obj.prepare();
        obj.execute((sError: any, sData: any) => {
            if (sError == 1) {
                callback(1, { message: "Mapped Subscription Updated Successfully!", status: 200 })
            } else {
                callback(0, { message: "Something Went Wrong", status: 502 })
            }
        });
    }

    Savesuscriptioncontrol(req: Request, res: Response, subscriptiondata: any, sessdata: any, endDate: any, callback: (err: any, result: any) => void) {
        let stipedata = subscriptiondata;
        console.log("stipedatastipedatastipedata ::::: ", stipedata);

        const idaccount = stipedata.sesidaccount ?? stipedata.idaccount ?? sessdata.idaccount;
        let rate = new APIBase();
        rate.prorateCalculatorwallet(req, res, stipedata.subscription_id, stipedata.mrc, stipedata.proration, stipedata.subscription_quantity, (pc_err, prorate1, dataprorate3) => {
            if (pc_err == 1) {
                let payload = {
                    idaccount: stipedata.idaccount,
                    amount: prorate1,
                    purpose: 'Subscription Charges',
                    type: '-'
                };
                console.log("Savesuscriptioncontrol > walletDeduction > payload :: ", payload);

                rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                    console.log("SubscriptionManagement => Savesuscriptioncontrol Wallet deduction response:", errorD, dataD);
                    let currentDate = new Date(stipedata.date);
                    let date = currentDate.toISOString().slice(0, 19).replace('T', ' ');
                    let Subscription = new SubscriptionManagement();
                    Subscription.addSubsAcc(req, res, stipedata, 1, date, endDate, (error, result) => {
                        console.log("saveSubscriptionAdmin :: ", result);
                    })

                    let subscriptionmap = new SubscriptionManagement();
                    subscriptionmap.subscriptionlog(req, res, dataprorate3, idaccount, stipedata.iduser, (err: any) => {
                    });
                    console.log("stipedata.idaccount ::::: ", stipedata.idaccount);
                    console.log("stipedata.amount :::::::: ", prorate1);

                    callback(1, { message: "Subscription charges deducted successfully from user wallet balance", status: 200 })
                });

            } else {
                callback(0, { message: "Faild to Calculate Prorated Amount!", status: 502 })
            }
        });
    }

    public subscriptionBalanceDeductfromwallet(req: Request, res: Response, sessdata: any, stipedata: any, sdata: any, callback: (err: any, data: any) => void) {
        const finalAmount = stipedata.amount;
        let payload = {
            idaccount: stipedata.idaccount,
            amount: finalAmount,
            purpose: 'Subscription Charges',
            type: '-'
        };
        rate.walletDeduction(req, res, payload, (errorD, dataD) => {
            console.log("SubscriptionManagement => subscriptionBalanceDeductfromwallet Wallet deduction response:", errorD, dataD);
        });
    }
    /* public subscriptionBalanceDeductfromwallet(req: Request,res: Response,sessdata: any,stipedata: any,sdata: any,callback: (err: any, data: any) => void) {
            const finalAmount = stipedata.amount;
            let payload = {
                idaccount: stipedata.idaccount,
                amount: finalAmount,
                purpose: 'Subscription Balance Deducted',
                type: '-'
            };
            rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                console.log("SubscriptionManagement => subscriptionBalanceDeductfromwallet Wallet deduction response:", errorD, dataD);
            });
            let obj5 = new ModelRawNonQuery(req, res);
            obj5.nonqrysql = "UPDATE `subscription_account` SET `status` = 1 WHERE `idaccount` = '" + stipedata.idaccount + "' AND `subscription_id` = '" + stipedata.subscription_id + "'";
            obj5.prepare();
            obj5.execute((paymentError1: any, result: any) => {
                if (paymentError1 == 1) {
                    let logPayload2 = {
                        funDetail: {
                            tableName: 'wallet_recharge_log',
                            functionName: 'subscriptionBalanceDeductfromwallet',
                            logName: 'wallet'
                        },
                        data: {
                            idaccount: stipedata.idaccount,
                            amount: '-' + finalAmount,
                            description: "Subscription balance deducted successfully",
                            status: 1,
                        }
                    };
                    rate.insertLog(req, res, logPayload2, (log_error, did_log) => {
                        console.log("Transaction response::", did_log)
                    });
                    if (sessdata.type == 1) {
                        callback(1, {message: "Subscription charges deducted successfully from user wallet balance",status: 200});
                    } else {
                        callback(1, {message: "Subscription charges deducted successfully from your wallet balance",status: 200});
                    }
                } else {
                    callback(0, {message: "Failed to update subscription status",status: 503});
                }
            });
        } */

    walletdeduction(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let spdata = JSON.parse(req.body.data);
                let msg: any = '';

                switch (true) {
                    case !spdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let stipedata = spdata;
                    let st = new SubscriptionManagement();
                    st.subscriptionBalanceDeductfromwallet(req, res, sessdata, stipedata, spdata, (error, resp) => {
                        if (error == 1) {
                            st.subscriptionlog(req, res, spdata.loginfo, sessdata.idaccount, sessdata.iduser, (err: any) => {
                            });
                            let objv = new RawView(res);
                            objv.prepare({ message: resp.message, status: resp.status });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: resp.message, status: resp.status });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access", status: 401 });
                objv.execute();
            }
        });
    }
    Proratecalculatoronbord(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                rate.subscriptionProrationCalculator(req, res, sessdata.idaccount, (pc_err, prorate1, logdata) => {
                    if (pc_err == 1) {
                        let objvs = new RawView(res);
                        objvs.prepare({ message: "Prorate calculated!", data: prorate1, log: logdata, status: 200 });
                        objvs.execute();
                    } else {
                        let objvs = new RawView(res);
                        objvs.prepare({ message: "Unable To Calculate Prorated Amount!", status: 401 });
                        objvs.execute();
                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    getTsPair(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `ts_id`,`ts_transaction`,`ts_service` ,`ts_description` FROM `avalara_ts_pair`";
                        obj.prepare();
                        obj.execute((sError: any, sData: any) => {
                            if (sError == 1) {
                                let objv = new RawView(res);
                                objv.prepare({
                                    status: 200,
                                    message: "Ts_pair Fetch Successfully",
                                    data: sData
                                });
                                objv.execute();
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({
                                    status: 502,
                                    message: "Something Went Wrong"
                                });
                                objv.execute();
                            }
                        });
                    } else {
                        let objvv = new RawView(res);
                        objvv.prepare(dt);
                        objvv.execute();

                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }
    public subscriptionlog(req: Request, res: Response, subscriptiondata: any[], idaccount: any, iduser: any, callback: (err: any) => void) {
        let obj1 = new ModelRawNonQuery(req, res);
        let qry0 = "INSERT INTO `subscription_log` (`subscription_id`,`cost`,`quantity`,`iduser`,`idaccount`) VALUES ";
        for (let i = 0; i < subscriptiondata.length; i++) {
            let subscriptiondata1 = subscriptiondata[i];
            qry0 += "('" + setToZero(subscriptiondata1.subscription_id) + "', '" + setToZero(subscriptiondata1.prorate) + "','" + setToZero(subscriptiondata1.quantity) + "','" + setToZero(iduser) + "','" + setToZero(idaccount) + "'),";
        }
        obj1.nonqrysql = qry0.slice(0, -1);
        obj1.prepare();
        obj1.execute((er: any, result: any) => {
            if (er == 1) {
                callback(null);
            } else {
                callback(er);
            }
        });
    }


    updateSubscriptionSchedule(req: Request, res: Response, next: NextFunction) {
        let Session = new SessionManagment(req, res, next);
        Session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let stipedata = JSON.parse(req.body.data);
                        let msg: any = '';

                        switch (true) {
                            case !stipedata:
                                msg = 'Request body not found!';
                                break;
                        }

                        if (msg) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        } else {
                            let obj1 = new ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT `quantity`, `status` FROM `subscription_account` WHERE `act_sub_id`='" + stipedata.act_sub_id + "'";
                            obj1.prepare();
                            obj1.execute((err1: any, result1: any) => {
                                if (err1 == 1 && Array.isArray(result1) && result1.length > 0) {
                                    if (stipedata.subscription_quantity > result1[0].quantity && result1[0].status == 1) {
                                        let actualQuantity = stipedata.subscription_quantity - result1[0].quantity
                                        let rate = new APIBase();
                                        rate.prorateCalculatorwallet(req, res, stipedata.subscription_id, stipedata.mrc, stipedata.proration, actualQuantity, (pc_err, prorate1, dataprorate3) => {
                                            if (pc_err == 1) {
                                                let payload = {
                                                    idaccount: stipedata.idaccount,
                                                    amount: prorate1,
                                                    purpose: 'Subscription Charges',
                                                    type: '-'
                                                };
                                                rate.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                    console.log("SubscriptionManagement => editSubscription Wallet deduction response:", errorD, dataD);

                                                    let Subscription = new SubscriptionManagement();
                                                    Subscription.upsubsAcc(req, res, stipedata, (error, result) => {
                                                        console.log("editSubscription :: ", result);
                                                    })

                                                    let subscriptionmap = new SubscriptionManagement();
                                                    subscriptionmap.subscriptionlog(req, res, dataprorate3, stipedata.idaccount, stipedata.iduser, (err: any) => {
                                                    });

                                                    let objvv = new RawView(res);
                                                    objvv.prepare({ message: "Subscription charges deducted successfully from user wallet balance", status: 200 });
                                                    objvv.execute();
                                                });
                                            }
                                            else {
                                                let objvv = new RawView(res);
                                                objvv.prepare({ message: "Faild to Calculate Prorated Amount!", status: 502 });
                                                objvv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let Subscription = new SubscriptionManagement();
                                        Subscription.upsubsAcc(req, res, stipedata, (error, result) => {
                                            let objvv = new RawView(res);
                                            objvv.prepare(result);
                                            objvv.execute();
                                        })
                                    }
                                } else {
                                    let objvv = new RawView(res);
                                    objvv.prepare({ message: "Subscription not found!", status: 404 });
                                    objvv.execute();
                                }
                            });
                        }


                    } else {
                        let objvv = new RawView(res);
                        objvv.prepare(dt);
                        objvv.execute();
                    }
                });
            } else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        })
    }

    saveSubscriptionSchedule(req: Request, res: Response, next: NextFunction) {
        let Session = new SessionManagment(req, res, next);
        Session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let Subscription = new SubscriptionManagement();
                        let spdata = JSON.parse(req.body.data);
                        let msg: any = '';

                        switch (true) {
                            case !spdata:
                                msg = 'Request body not found!';
                                break;
                        }

                        if (msg) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        } else {
                            let currentDate = new Date(spdata.date);
                            let endDate: string;
                            if (spdata.type == 1) {
                                endDate = '0000-00-00 00:00:00';
                            } else {
                                endDate = currentDate.toISOString().slice(0, 19).replace('T', ' ');
                            }
                            if (spdata.date && new Date(spdata.date).setHours(0, 0, 0, 0) > new Date().setHours(0, 0, 0, 0)) {
                                Subscription.addSubsAcc(req, res, spdata, 2, spdata.date, endDate, (error, result) => {
                                    console.log("saveSubscriptionAdmin :: ", result);
                                    let objvv = new RawView(res);
                                    objvv.prepare(result);
                                    objvv.execute();
                                })
                            } else {
                                Subscription.Savesuscriptioncontrol(req, res, spdata, sessdata, endDate, (error, result) => {
                                    let objvv = new RawView(res);
                                    objvv.prepare({ message: result.message, status: result.status });
                                    objvv.execute();
                                });
                            }
                        }

                    } else {
                        let objvv = new RawView(res);
                        objvv.prepare(dt);
                        objvv.execute();
                    }
                })
            } else {
                let objvv = new RawView(res);
                objvv.prepare({ message: "Unauthorize Access!", status: 401 });
                objvv.execute();
            }
        });
    }

    addSubsAcc(req: Request, res: Response, stipedata: any, status: any, date: any, endDate: any, callback: (err: any, result: any) => void) {
        let obj = new ModelRawNonQuery(req, res);
        obj.nonqrysql = "INSERT INTO `subscription_account` (`idaccount`, `subscription_id`, `quantity`, `start_date`, `end_date`, `status`) " + "VALUES ('" + stipedata.idaccount + "', '" + stipedata.subscription_id + "', '" + setToZero(stipedata.subscription_quantity) + "', '" + date + "', '" + endDate + "', '" + status + "')";
        obj.prepare();
        obj.execute((sError: any, sData: any) => {
            if (sError == 1) {
                callback(1, { message: "Subscription Scheduled Successfully", status: 200 })
            } else {
                callback(0, { message: "Something Went Wrong with Subscription Schedule", status: 502 })
            }
        });
    }

    inActiveSubscription(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                rate.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let pData: any = req.body.data;
                        console.log("pData ::: ", pData);
                        let msg: any = '';

                        switch (true) {
                            case !pData:
                                msg = 'Request body not found!';
                                break;
                        }

                        if (msg) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        } else {
                            let obj = new ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `subscription_account` SET `status`=0 WHERE `act_sub_id` = '" + pData + "'";
                            obj.prepare();
                            obj.execute((sError: any, sData: any) => {
                                if (sError == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 201,
                                        message: "Subscription Inactive Successfull!",
                                    });
                                    objv.execute();
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 502,
                                        message: "Something Went Wrong"
                                    });
                                    objv.execute();
                                }
                            });
                        }


                    }
                    else {
                        let objvv = new RawView(res);
                        objvv.prepare(dt);
                        objvv.execute();
                    }
                });
            }
            else {
                let objvs = new RawView(res);
                objvs.prepare({ message: "Unauthorize Access!", status: 401 });
                objvs.execute();
            }
        });
    }

    shedulesubscription(req: Request, res: Response, subscriptiondata: any, sessdata: any, callback: (err: any, result: any) => void) {
        let spdata = subscriptiondata;
        let stipedata = spdata;
        let type = stipedata.type;
        let currentDate = new Date(spdata.date);
        let endDate: string;
        if (type == 1) {
            endDate = '0000-00-00 00:00:00';
        } else {
            endDate = currentDate.toISOString().slice(0, 19).replace('T', ' ');
        }
        let obj = new ModelRawQuery(req, res);
        obj.qrysql = "SELECT sa.subscription_id, sa.start_date, s.quantity, sa.status FROM subscription s JOIN subscription_account sa ON sa.subscription_id = s.subscription_id JOIN account ab ON sa.idaccount = ab.idaccount WHERE sa.idaccount = '" + spdata.idaccount + "'  AND s.subscription_id = '" + spdata.subscription_id + "'";
        obj.prepare();
        obj.execute((sError: any, sData: any) => {
            if (sError == 1) {
                if (!sData || sData == null || sData == '' || !sData.length) {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `subscription_account` (`idaccount`, `subscription_id`, `quantity`, `start_date`, `end_date`,status) VALUES ('" + stipedata.idaccount + "', '" + stipedata.subscription_id + "', '" + setToZero(stipedata.subscription_quantity) + "', '" + spdata.date + "', '" + endDate + "',2)";
                    obj.prepare();
                    obj.execute((Error: any, sData: any) => {
                        if (Error == 1) {

                            callback(1, { message: "Subscription Schedule Successfully!", status: 200 })
                        } else {
                            callback(0, { message: "Something Went Wrong While Scheduling Subscription!", status: 502 })
                        }
                    });
                } else {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `subscription_account` SET `idaccount`='" + spdata.idaccount + "', `subscription_id`='" + spdata.subscription_id + "', `quantity`='" + setToZero(spdata.subscription_quantity) + "',`start_date`='" + spdata.date + "',`end_date`='" + endDate + "' WHERE `act_sub_id`='" + spdata.act_sub_id + "'";
                    obj.prepare();
                    obj.execute((Error: any, sData: any) => {
                        if (Error == 1) {
                            callback(1, { message: "Schedule Subscription Updated Successfully!", status: 200 })
                        }
                    });
                }
            } else {
                callback(0, { message: "Something Went Wrong!", status: 502 })
            }
        });

    }

}





