"use strict";
const multer = require('multer');
import { NextFunction } from 'express';
import { UploadDirectory } from '../config/setting.config';

const MIME_TYPE_MAP: any = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'application/pdf': 'pdf',
    'text/plain': 'txt',
    'image/bmp':'bmp',
    'image/tiff':'tiff',
    'text/html':'htm',
    'application/vnd.oasis.opendocument.text':'odt',
    'application/rtf':'rtf',
    'application/xml':'xml',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx'
};

const storage = multer.diskStorage({
    destination: (req: any, file: any, cb: any) => {
        let appealdir = new UploadDirectory();
        const isValid = MIME_TYPE_MAP[file.mimetype];
        let error: any = "";
        if (!isValid) {
            error = new Error("Invalid file type");
        }
        cb(error, appealdir.APPEALUPLOADS);
    },
    filename: (req: any, file: any, cb: any) => {
        let file_path = file.originalname;
        let extension = file_path.split('.').pop();
        let randomName: any = Math.random().toString(36).substring(2, 12);
        const filenm = file.originalname;
        const flName = Date.now() + '-' + filenm.replace(filenm, randomName);
        const fileName = flName + '.' + extension;
        const ext = MIME_TYPE_MAP[file.mimetype];
        cb(null, fileName);
    }
});

const errorHandler = (err: any, req: Request, res: any, next: NextFunction) => {
    if (err) {
        res.status(502).json({status: 404, message: err.message});
    } else {
        next();
    }
};
 
module.exports = [multer({ storage: storage }).array('ATTACHMENTS'),errorHandler];

