import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { Socket } from "net";
import { VoiceServer } from "../config/setting.config";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { VoiceRates } from "./common.lib"
import { voicerates } from "../server";
import { LergApi } from "./lrnApi";
import { APIBase } from "./APIBase";
import { checkToDid, isMissing } from "./markError";
let validuser = new APIBase();

const vs_server = new VoiceServer();
const prefix = vs_server.Prefix;


export class Call extends APIBase {

  constructor() {
    super();
  }

  public repTest(req: Request, res: Response, next: NextFunction) {

    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let sdata = req.body;
        let msg: any = '';

        switch (true) {
          case !sdata:
            msg = 'Request body not found!';
            break;

          case !sdata.FROM || sdata.FROM == null || sdata.FROM == undefined:
            msg = 'FROM not found!';
            break;

          case !sdata.CALLEE || sdata.CALLEE == null || sdata.CALLEE == undefined:
            msg = 'CALLEE not found!';
            break;
        }

        if (msg) {
          let objv = new RawView(res);
          objv.prepare({ status: 404, message: msg });
          objv.execute();
          return;
        }
        else {
          sdata.FROM = typeof sdata.FROM === 'string' ? sdata.FROM.replace(/\D/g, '') : '';
          sdata.CALLEE = typeof sdata.CALLEE === 'string' ? sdata.CALLEE.replace(/\D/g, '') : '';

          let ratenserv = new APIBase();
          ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
            if (errorR == 1) {
              ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                if (resp.status == 200) {
                  if (typeof sdata.FROM === 'string' && sdata.FROM.length == 10) {
                    if (sdata.CALLER == '' || sdata.CALLER == 'undefined' || sdata.CALLER == null) {
                      sdata.CALLER = sdata.FROM
                    }
                    sdata.TO = sdata.CALLEE;
                    let vrate: VoiceRates;
                    if (voicerates.has(sessdata.authkey)) {
                      let tmp = voicerates.get(sessdata.authkey);
                      if (tmp !== undefined) {
                        vrate = tmp;
                      }
                      else {
                        vrate = new VoiceRates();
                        vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                          voicerates.set(sessdata.authkey, vrate);
                        });
                      }
                    }
                    else {
                      vrate = new VoiceRates();
                      vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                        voicerates.set(sessdata.authkey, vrate);
                      });
                    }
                    if (vrate.count() > 0) {
                      let PayLoad: any = {
                        TO: sdata.TO
                      }
                      let lerg = new LergApi("", "");
                      lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                        let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                        let baseapi = new APIBase();
                        baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                          if (lerg_info.length > 0) {
                            baseapi.DialCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {

                              if (call_result != undefined) {
                                let objv = new RawView(res);
                                objv.prepare(call_result);
                                objv.execute();
                              } else {
                                let objv = new RawView(res);
                                objv.prepare(call_err);
                                objv.execute();
                              }

                            })
                          } else {
                            let objv = new RawView(res);
                            objv.prepare("Lerg Info Not Found");
                            objv.execute();
                          }
                        })
                      })
                    } else {
                      let objv = new RawView(res);
                      objv.prepare("Data Not Found");
                      objv.execute();
                    }
                  } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                    objv.execute();
                  }

                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({
                    error_code: err,
                    status: resp.status,
                    message: resp.message.replace(/::SN::/g, "Call")
                  });
                  objv.execute();
                }
              });
            }
            else {
              let objv = new RawView(res);
              objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
              objv.execute();
            }
          });
        }
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }

  public MakeOutboundCallToNumber(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let sdata = req.body;
        let msg: any = '';

        switch (true) {
          case !sdata:
            msg = 'Request body not found!';
            break;

          case !sdata.FROM || sdata.FROM == null || sdata.FROM == undefined:
            msg = 'FROM not found!';
            break;

          case !sdata.CALLEE || sdata.CALLEE == null || sdata.CALLEE == undefined:
            msg = 'CALLEE not found!';
            break;
        }

        if (msg) {
          let objv = new RawView(res);
          objv.prepare({ status: 404, message: msg });
          objv.execute();
          return;
        }
        else {
          sdata.FROM = typeof sdata.FROM === 'string' ? sdata.FROM.replace(/\D/g, '') : '';
          sdata.CALLEE = typeof sdata.CALLEE === 'string' ? sdata.CALLEE.replace(/\D/g, '') : '';

          // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
          let ratenserv = new APIBase();
          ratenserv.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
            if (err == 1) {
              ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                if (errorR == 1) {
                  ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                    if (resp.status == 200) {
                      if (typeof sdata.FROM === 'string' && sdata.FROM.length == 10) {
                        if (sdata.CALLER == '' || sdata.CALLER == 'undefined' || sdata.CALLER == null) {
                          sdata.CALLER = sdata.FROM
                        }
                        sdata.TO = sdata.CALLEE;
                        let vrate: VoiceRates;
                        if (voicerates.has(sessdata.authkey)) {
                          let tmp = voicerates.get(sessdata.authkey);
                          if (tmp !== undefined) {
                            vrate = tmp;
                          }
                          else {
                            vrate = new VoiceRates();
                            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                              voicerates.set(sessdata.authkey, vrate);
                            });
                          }
                        }
                        else {
                          vrate = new VoiceRates();
                          vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                            voicerates.set(sessdata.authkey, vrate);
                          });
                        }
                        if (vrate.count() > 0) {
                          let PayLoad: any = {
                            TO: sdata.TO
                          }
                          let lerg = new LergApi("", "");
                          lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                              if (lerg_info.length > 0) {
                                baseapi.DialCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {

                                  if (call_result != undefined) {
                                    let objv = new RawView(res);
                                    objv.prepare(call_result);
                                    objv.execute();
                                  } else {
                                    let objv = new RawView(res);

                                    objv.prepare(call_err);
                                    objv.execute();
                                  }

                                })
                              }
                              else {
                                let objv = new RawView(res);
                                objv.prepare("Lerg Info Not Found");
                                objv.execute();
                              }
                            })
                          })
                        }
                        else {
                          let objv = new RawView(res);
                          objv.prepare("Data Not Found");
                          objv.execute();
                        }
                      }
                      else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                        objv.execute();
                      }
                    }
                    else {
                      let objv = new RawView(res);
                      objv.prepare({
                        error_code: err,
                        status: resp.status,
                        message: resp.message.replace(/::SN::/g, "Call")
                      });
                      objv.execute();
                    }
                  });
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                  objv.execute();
                }
              });
            }
            else {
              let objvs = new RawView(res);
              objvs.prepare(dt);
              // objvs.prepare({ status: 404, message: "Not Permitted" });
              objvs.execute();
            }
          })
        }
      }
      else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }

  public MakeCall(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let sdata = req.body;
        let msg: any = '';

        switch (true) {
          case !sdata:
            msg = 'Request body not found!';
            break;

          case !sdata.FROM || sdata.FROM == null || sdata.FROM == undefined:
            msg = 'FROM not found!';
            break;

          case !sdata.TO || sdata.TO == null || sdata.TO == undefined:
            msg = 'TO not found!';
            break;
        }

        if (msg) {
          let objv = new RawView(res);
          objv.prepare({ status: 404, message: msg });
          objv.execute();
          return;
        }
        else {

          sdata.FROM = typeof sdata.FROM === 'string' ? sdata.FROM.replace(/\D/g, '') : '';
          sdata.TO = typeof sdata.TO === 'string' ? sdata.TO.replace(/\D/g, '') : '';

          // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
          let ratenserv = new APIBase();
          ratenserv.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
            if (err == 1) {
              ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                if (errorR == 1) {
                  ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                    if (resp.status == 200) {
                      let vrate: VoiceRates;
                      if (
                        typeof sdata.FROM === 'string' &&
                        typeof sdata.TO == 'string' &&
                        sdata.FROM.length === 10 &&
                        sdata.TO.length == 10
                      ) {
                        if (voicerates.has(sessdata.authkey)) {
                          let tmp = voicerates.get(sessdata.authkey);
                          if (tmp != undefined) {
                            vrate = tmp;
                          }
                          else {
                            vrate = new VoiceRates();
                            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                              voicerates.set(sessdata.authkey, vrate);
                            });
                          }
                        }
                        else {
                          vrate = new VoiceRates();
                          vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                            voicerates.set(sessdata.authkey, vrate);
                          });
                        }
                        if (vrate.count() > 0) {
                          let lergLogin = new LergApi("", "");
                          let PayLoad: any = {
                            TO: sdata.TO
                          }
                          let lerg = new LergApi("", "");
                          lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                              if (lerg_info.length > 0) {
                                baseapi.makeCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                  if (call_result != undefined) {
                                    let objv = new RawView(res);
                                    objv.prepare(call_result);
                                    objv.execute();
                                  } else {
                                    let objv = new RawView(res);
                                    objv.prepare(call_err);
                                    objv.execute();
                                  }
                                })
                              } else {
                                let objv = new RawView(res);
                                objv.prepare("Lerg Info Not Found");
                                objv.execute();
                              }
                            })
                          })
                        } else {
                          let objv = new RawView(res);
                          objv.prepare("Data Not Found");
                          objv.execute();
                        }
                      } else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                        objv.execute();
                      }
                    }
                    else {
                      let objv = new RawView(res);
                      objv.prepare({
                        error_code: err,
                        status: resp.status,
                        message: resp.message.replace(/::SN::/g, "Make Call")
                      });
                      objv.execute();
                    }
                  });
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                  objv.execute();
                }
              });
            }
            else {
              let objvs = new RawView(res);
              objvs.prepare(dt);
              // objvs.prepare({ status: 404, message: "Not Permitted" });
              objvs.execute();
            }
          });
        }
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }

  public MakeCallviaMedia(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let sdata = req.body;
        let msg: any = '';

        switch (true) {
          case !sdata:
            msg = 'Request body not found!';
            break;

          case !sdata.FROM || sdata.FROM == null || sdata.FROM == undefined:
            msg = 'FROM not found!';
            break;

          case !sdata.TO || sdata.TO == null || sdata.TO == undefined:
            msg = 'TO not found!';
            break;

          case !sdata.mediaID || sdata.mediaID == null || sdata.mediaID == undefined:
            msg = 'mediaID not found!';
            break;
        }

        if (msg) {
          let objv = new RawView(res);
          objv.prepare({ status: 404, message: msg });
          objv.execute();
          return;
        }

        else {
          sdata.FROM = typeof sdata.FROM === 'string' ? sdata.FROM.replace(/\D/g, '') : '';
          sdata.TO = typeof sdata.TO === 'string' ? sdata.TO.replace(/\D/g, '') : '';
          let ratenserv = new APIBase();
          ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
            if (errorR == 1) {
              ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                if (resp.status == 200) {
                  if (
                    typeof sdata.FROM === 'string' &&
                    typeof sdata.TO == 'string' &&
                    sdata.FROM.length === 10 &&
                    sdata.TO.length == 10
                  ) {
                    let vrate: VoiceRates;
                    if (voicerates.has(sessdata.authkey)) {
                      let tmp = voicerates.get(sessdata.authkey);
                      if (tmp != undefined) {
                        vrate = tmp;
                      }
                      else {
                        vrate = new VoiceRates();
                        vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                          voicerates.set(sessdata.authkey, vrate);
                        });
                      }
                    }
                    else {
                      vrate = new VoiceRates();
                      vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                        voicerates.set(sessdata.authkey, vrate);

                      });
                    }

                    if (vrate.count() > 0) {
                      let lergLogin = new LergApi("", "");
                      let PayLoad: any = {
                        TO: sdata.TO
                      }
                      let lerg = new LergApi("", "");
                      lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                        let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                        let baseapi = new APIBase();
                        baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                          if (lerg_info.length > 0) {
                            baseapi.makeCallviaMedia(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                              if (call_result != undefined) {
                                let objv = new RawView(res);
                                objv.prepare(call_result);
                                objv.execute();
                              } else {
                                let objv = new RawView(res);
                                objv.prepare(call_err);
                                objv.execute();
                              }
                            })
                          } else {
                            let objv = new RawView(res);
                            objv.prepare("Lerg Info Not Found");
                            objv.execute();
                          }
                        })
                      })
                    } else {
                      let objv = new RawView(res);
                      objv.prepare("Data Not Found");
                      objv.execute();
                    }

                  } else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: "Invalid Number. Please enter 10 digit number" });
                    objv.execute();
                  }
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({
                    error_code: err,
                    status: resp.status,
                    message: resp.message.replace(/::SN::/g, "Make Call Via Media")
                  });
                  objv.execute();
                }
              });
            }
            else {
              let objv = new RawView(res);
              objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
              objv.execute();
            }
          });
        }
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }


  public sendDtmf(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let message: any = "";
        switch (true) {
          case (!req.body):
            message = "Request body not found!";
            break;
          case (!req.body.UUID):
            message = "UUID is required!";
            break;
          case (!req.body.TONE):
            message = "TONE is required!";
            break;
          default:
            message = "";
        }
        if (message) {
          let objv = new RawView(res);
          objv.prepare({ status: 400, message });
          objv.execute();
        }
        else {
          // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
          validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
            if (err == 1) {
              let digit: any;
              digit = req.body.TONE;
              let client = new Socket();
              client.connect(parseInt(vs_server.PORT), vs_server.HOST, () => {
                console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
                client.write('auth ' + vs_server.PASS + '\n\n');
                console.log("Password : " + vs_server.PASS);
                client.write('api uuid_send_dtmf ' + req.body.UUID + " " + digit + '\n\n');
                client.on("data", (respon) => {
                  let tmp = respon.toString().split("\n");
                  tmp.forEach((elem: any) => {
                    if (elem != undefined) {
                      if (elem.length > 0) {
                        console.log(elem);
                        let t1 = elem.split("OK");
                        if (t1.length == 2) {
                          console.log(t1);
                          if (t1[0] == "+") {
                            res.status(200).send(t1[1].trim());
                            client.end();
                          }
                        }
                      }
                    }
                  });
                });

                client.on("error", (e) => {
                  console.log(e);
                })

                client.on("end", () => {

                })
              });
            }
            else {
              let objvs = new RawView(res);
              objvs.prepare(dt);
              // objvs.prepare({ status: 404, message: "Not Permitted" });
              objvs.execute();
            }
          });
        }
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }

  public recvDtmf(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let message: any = "";
        switch (true) {
          case (!req.body):
            message = "Request body not found!";
            break;
          case (!req.body.UUID):
            message = "UUID is required!";
            break;
          case (!req.body.TONE):
            message = "TONE is required!";
            break;
          default:
            message = "";
        }
        if (message) {
          let objv = new RawView(res);
          objv.prepare({ status: 400, message });
          objv.execute();
        }
        else {
          // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
          validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
            if (err == 1) {
              let digit: any;
              digit = req.body.TONE;
              let client = new Socket();
              client.connect(parseInt(vs_server.PORT), vs_server.HOST, () => {
                console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
                client.write('auth ' + vs_server.PASS + '\n\n');
                console.log("Password : " + vs_server.PASS);
                client.write('api uuid_recv_dtmf ' + req.body.UUID + " " + digit + '\n\n');
                client.on("data", (respon) => {
                  let tmp = respon.toString().split("\n");
                  tmp.forEach((elem: any) => {
                    if (elem != undefined) {
                      if (elem.length > 0) {
                        console.log(elem);
                        let t1 = elem.split("OK");
                        if (t1.length == 2) {
                          console.log(t1);
                          if (t1[0] == "+") {
                            res.status(200).send(t1[1].trim());
                            client.destroy();
                          }
                        }
                      }
                    }
                  });
                });

                client.on("error", (e) => {
                  console.log(e);
                })

                client.on("end", () => {

                })
              });

            }
            else {
              let objvs = new RawView(res);
              objvs.prepare(dt);
              // objvs.prepare({ status: 404, message: "Not Permitted" });
              objvs.execute();
            }
          });
        }
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }

  public ThreeWayCall(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let ratenserv = new APIBase();
        // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
        ratenserv.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
          if (err == 1) {
            let sdata = req.body;
            let message: any = "";
            switch (true) {
              case (!sdata || !('UUID' in req.body || 'Number' in req.body)):
                message = "Missing request body!";
                break;
              case (!sdata.Number || isMissing(sdata.Number)):
                message = "Number is required!";
                break;
              case (!sdata.UUID || isMissing(sdata.UUID)):
                message = "UUID is required!";
                break;
              case (sdata.Number && checkToDid('Number', sdata.Number) != ''):
                message = checkToDid('Number', sdata.Number);
                break;
              default:
                message = "";
            }
            if (message) {
              let objv = new RawView(res);
              objv.prepare({ status: 400, message });
              objv.execute();
              return;
            }
            else {
              sdata.Number = typeof sdata.Number === 'string' ? sdata.Number.replace(/\D/g, '') : '';
              ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                if (errorR == 1) {
                  ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                    if (resp.status == 200) {
                      if (typeof sdata.Number === 'string' && sdata.Number.length == 10) {
                        let vrate: VoiceRates;
                        if (voicerates.has(sessdata.authkey)) {
                          let tmp = voicerates.get(sessdata.authkey);
                          if (tmp !== undefined) {
                            vrate = tmp;
                          }
                          else {
                            vrate = new VoiceRates();
                            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                              voicerates.set(sessdata.authkey, vrate);
                              //let objv = new Res406(res);
                              //objv.prepare({ status: 401, message: "Unauthorized User" });
                              //objv.execute();
                            });
                          }
                        }
                        else {
                          vrate = new VoiceRates();
                          vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                            voicerates.set(sessdata.authkey, vrate);
                            //let objv = new Res406(res);
                            //objv.prepare({ status: 401, message: "Unauthorized User" });
                            //objv.execute();
                          });
                        }

                        if (vrate.count() > 0) {
                          let rate = vrate.getCallRate(req.body.Number);
                          let PayLoad: any = {
                            TO: sdata.Number
                          }
                          let lerg = new LergApi("", "");
                          lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                              if (lerg_info.length > 0) {
                                baseapi.ThreeWayCall(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                  if (call_result != undefined) {
                                    let objv = new RawView(res);
                                    objv.prepare(call_result);
                                    objv.execute();
                                  } else {
                                    let objv = new RawView(res);
                                    objv.prepare(call_err);
                                    objv.execute();
                                  }
                                })
                              } else {
                                let objv = new RawView(res);
                                objv.prepare("Lerg Info Not Found");
                                objv.execute();
                              }
                            })
                          })

                        } else {
                          let objv = new RawView(res);
                          objv.prepare("Data Not Found");
                          objv.execute();
                        }

                      } else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                        objv.execute();
                      }
                    }
                    else {
                      let objv = new RawView(res);
                      objv.prepare({
                        error_code: err,
                        status: resp.status,
                        message: resp.message.replace(/::SN::/g, "Call")
                      });
                      objv.execute();
                    }
                  });
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                  objv.execute();
                }
              });
            }
          }
          else {
            let objvs = new RawView(res);
            objvs.prepare(dt);
            // objvs.prepare({ status: 404, message: "Not Permitted" });
            objvs.execute();
          }
        });
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }


  public Hangup(req: Request, res: Response, next: NextFunction) {
    console.log("Req==>" + JSON.stringify(req.body));
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let message: any = "";
        let socketData = req.body.UUID;
        switch (true) {
          case (!req.body):
            message = "Request body not found!";
            break;
          case (!socketData || isMissing(socketData)):
            message = "UUID is required!";
            break;
          default:
            message = "";
        }
        if (message) {
          let objv = new RawView(res);
          objv.prepare({ status: 400, message });
          objv.execute();
        }
        else {
          // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
          validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
            if (err == 1) {
              let client = new Socket();
              let state: string = "";
              client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
                console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
                client.write('auth ' + vs_server.PASS + '\n\n');
                console.log("Password : " + vs_server.PASS);
                console.log(socketData);
                client.write('api uuid_kill ' + socketData + '\n\n');
                res.status(200).send();
                client.on("data", (respon) => {
                  console.log(respon.toString());
                  let tmp = respon.toString().split("\n");
                  tmp.forEach((elem: any) => {
                    if (elem != undefined) {
                      if (elem.length > 0) {
                        console.log(elem);
                        let t1 = elem.split("OK");
                        if (t1.length == 2) {
                          console.log(t1);
                          if (t1[0] == "+") {
                            state = "Hangup Channel";
                            client.end();
                          }
                        }
                      }
                    }
                  });
                });

                client.on("error", (e) => {
                  console.log(e);
                })
                client.on("end", () => {
                  console.log(state);
                  if (state.length > 0) {
                    let tmp = state;
                    state = "";
                    res.status(200).send(tmp);
                  }
                })
              });

            }
            else {
              let objvs = new RawView(res);
              objvs.prepare(dt);
              // objvs.prepare({ status: 404, message: "Not Permitted" });
              objvs.execute();
            }
          });
        }
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }

  public Barge(req: Request, res: Response, next: NextFunction) {
    let sdata = req.body;
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
        let ratenserv = new APIBase();
        ratenserv.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
          if (err == 1) {
            let msg: any = '';
            switch (true) {
              case (!sdata):
                msg = "Request body not found!";
                break;
              case (!sdata.Number && sdata.Number == null && sdata.Number == undefined):
                msg = "Number not found!";
                break;
              case (sdata.Number && !/^[0-9]+$/.test(sdata.Number)):
                msg = "Number is Invalid!";
                break;
              case (!req.body.Extension):
                msg = "Extension is required!";
                break;
              default:
                msg = "";
            }
            if (msg) {
              let objv = new RawView(res);
              objv.prepare({ status: 404, message: msg });
              objv.execute();
              return;
            }
            else {
              sdata.Number = typeof sdata.Number === 'string' ? sdata.Number.replace(/\D/g, '') : '';
              ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                if (errorR == 1) {
                  ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                    if (resp.status == 200) {
                      let vrate: VoiceRates;
                      console.log(sessdata)
                      if (sdata.Number.length == 10) {
                        if (voicerates.has(sessdata.authkey)) {
                          let tmp = voicerates.get(sessdata.authkey);
                          if (tmp !== undefined) {
                            vrate = tmp;
                          }
                          else {
                            vrate = new VoiceRates();
                            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                              voicerates.set(sessdata.authkey, vrate);
                            });
                          }
                        }
                        else {
                          vrate = new VoiceRates();
                          vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                            voicerates.set(sessdata.authkey, vrate);
                          });
                        }

                        if (vrate.count() > 0) {
                          let PayLoad: any = {
                            TO: sdata.Number
                          }
                          let lerg = new LergApi("", "");
                          lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                              if (lerg_info.length > 0) {
                                baseapi.Barge(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                  if (call_result != undefined) {
                                    let objv = new RawView(res);
                                    objv.prepare(call_result);
                                    objv.execute();
                                  } else {
                                    let objv = new RawView(res);
                                    objv.prepare(call_err);
                                    objv.execute();
                                  }
                                })
                              } else {
                                let objv = new RawView(res);
                                objv.prepare("Lerg Info Not Found");
                                objv.execute();
                              }
                            })
                          })
                        }
                        else {
                          let objv = new RawView(res);
                          objv.prepare("Data Not Found");
                          objv.execute();
                        }
                      } else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                        objv.execute();
                      }
                    }
                    else {
                      let objv = new RawView(res);
                      objv.prepare({
                        error_code: err,
                        status: resp.status,
                        message: resp.message.replace(/::SN::/g, "Call")
                      });
                      objv.execute();
                    }
                  });
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                  objv.execute();
                }
              });
            }
          }
          else {
            let objvs = new RawView(res);
            objvs.prepare(dt);
            // objvs.prepare({ status: 404, message: "Not Permitted" });
            objvs.execute();
          }
        });
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }

  public Hold(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let message: any = "";
        const validTypes = ['Start', 'Stop', 'Toggle'];
        let socketData = req.body.UUID;
        switch (true) {
          case (!req.body):
            message = "Request body not found!";
            break;
          case (!socketData):
            message = "UUID is required!";
            break;
          case (!req.body.Type):
            message = "Type is required!";
            break;
          case (req.body.Type && !validTypes.includes(req.body.Type)):
            message = "type is invalid!";
            break;
          default:
            message = "";
        }
        if (message) {
          let objv = new RawView(res);
          objv.prepare({ status: 400, message });
          objv.execute();
        }
        else {
          // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
          validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
            if (err == 1) {
              let cmd = "";
              if (req.body.Type == "Start") {
                cmd = "api uuid_hold " + socketData;
              } else if (req.body.Type == "Stop") {
                cmd = "api uuid_hold off " + socketData;
              } else {
                cmd = "api uuid_hold toggle " + socketData;
              }
              console.log("cmd==>" + cmd);
              let client = new Socket();
              client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
                console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
                client.write('auth ' + vs_server.PASS + '\n\n');
                console.log("Password : " + vs_server.PASS);
                client.write(cmd + '\n\n');
                client.on("data", (respon) => {
                  let tmp = respon.toString().split("\n");
                  tmp.forEach((elem: any) => {
                    if (elem != undefined) {
                      if (elem.length > 0) {
                        console.log(elem);
                        let t1 = elem.split("OK");
                        if (t1.length == 2) {
                          console.log(t1);
                          if (t1[0] == "+") {
                            res.status(200).send(t1[1].trim());
                            client.destroy();
                          }
                        }
                      }
                    }
                  });
                });

                client.on("error", (e) => {
                  console.log(e);
                })

                client.on("end", () => {

                })
              });
            }
            else {
              let objvs = new RawView(res);
              objvs.prepare(dt);
              // objvs.prepare({ status: 404, message: "Not Permitted" });
              objvs.execute();
            }
          });
        }
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }

  public Recording(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let message: any = "";
        const validTypes = ['Start', 'Stop'];
        switch (true) {
          case (!req.body):
            message = "Request body not found!";
            break;
          case (!req.body.UUID):
            message = "UUID is required!";
            break;
          case (!req.body.Recording):
            message = "Recording is required!";
            break;
          case (req.body.Recording && !validTypes.includes(req.body.Recording)):
            message = "Recording is invalid!";
            break;
          default:
            message = "";
        }
        if (message) {
          let objv = new RawView(res);
          objv.prepare({ status: 400, message });
          objv.execute();
        }
        else {
          // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
          let ratenserv = new APIBase();
          ratenserv.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
            if (err == 1) {
              ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                if (errorR == 1) {
                  ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                    if (resp.status == 200) {
                      let vrate: VoiceRates;
                      console.log(sessdata)
                      if (voicerates.has(sessdata.authkey)) {
                        console.log("hii");
                        let tmp = voicerates.get(sessdata.authkey);
                        if (tmp !== undefined) {
                          vrate = tmp;
                        }
                        else {
                          vrate = new VoiceRates();
                          vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                            voicerates.set(sessdata.authkey, vrate);
                          });
                        }
                      }
                      else {
                        vrate = new VoiceRates();
                        vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                          voicerates.set(sessdata.authkey, vrate);
                        });
                      }
                      let cmd = "";
                      console.log("vrate", vrate);
                      let rate = vrate.RecordRate("true");
                      console.log("Rate", rate);
                      if (req.body.Recording == "Start") {
                        cmd = "api uuid_record " + req.body.UUID + " start /usr/local/freeswitch/recording/" + req.body.UUID;
                      } else {
                        cmd = "api uuid_record " + req.body.UUID + " stop /usr/local/freeswitch/recording/" + req.body.UUID;
                      }
                      console.log("Req==>" + cmd);
                      let client = new Socket();
                      client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
                        console.log('CONNECTED TO: ' + vs_server.HOST + ':' + vs_server.PORT);
                        client.write('auth ' + vs_server.PASS + '\n\n');
                        client.write(cmd + '\n\n');
                        client.on("data", (respon) => {
                          let tmp = respon.toString().split("\n");
                          tmp.forEach((elem: any) => {
                            if (elem != undefined) {
                              if (elem.length > 0) {
                                console.log("Ele", elem);
                                let t1 = elem.split("OK");
                                if (t1.length == 2) {
                                  console.log("T1", t1);
                                  if (t1[0] == "+") {
                                    console.log("api uuid_setvar " + req.body.UUID + " rec_rate " + rate + '\n\n');
                                    client.write("api uuid_setvar " + req.body.UUID + " rec_rate " + rate + '\n\n');
                                    res.status(200).send(t1[1].trim());
                                    client.destroy();
                                  }
                                }
                              }
                            }
                          });
                        });

                        client.on("error", (e) => {
                          console.log(e);
                        })

                        client.on("end", () => {

                        })
                      });
                    }
                    else {
                      let objv = new RawView(res);
                      objv.prepare({
                        error_code: err,
                        status: resp.status,
                        message: resp.message.replace(/::SN::/g, "Recording")
                      });
                      objv.execute();
                    }
                  });
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                  objv.execute();
                }
              });
            }
            else {
              let objvs = new RawView(res);
              objvs.prepare(dt);
              // objvs.prepare({ status: 404, message: "Not Permitted" });
              objvs.execute();
            }
          });
        }
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }

  public CallTransfer(req: Request, res: Response, next: NextFunction) {
    let sdata = req.body;
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        let message: any = "";
        switch (true) {
          case (!sdata):
            message = "Missing Parameter: Number, UUID!";
            break;
          case (sdata == '' || sdata == 'null' || sdata == 'undefined'):
            message = "Missing Parameter: Number, UUID!";
            break;
          case (!sdata.Number):
            message = "Number is required!";
            break;
          case (!sdata.UUID):
            message = "UUID is required!";
            break;
          case (sdata.Number && !/^[0-9]+$/.test(sdata.Number)):
            message = "Number is Invalid!";
            break;
          default:
            message = "";
        }
        if (message) {
          let objv = new RawView(res);
          objv.prepare({ status: 400, message });
          objv.execute();
        }
        else {


          // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
          let ratenserv = new APIBase();
          ratenserv.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
            if (err == 1) {
              ratenserv.checkBalance(req, res, sessdata.idaccount, .10, (errorR, resR) => {
                if (errorR == 1) {
                  ratenserv.serviceActivation(req, res, sessdata, "3", (err, resp) => {
                    if (resp.status == 200) {
                      let vrate: VoiceRates;
                      if (typeof sdata.Number === 'string' && sdata.Number.length == 10) {
                        if (voicerates.has(sessdata.authkey)) {
                          let tmp = voicerates.get(sessdata.authkey);
                          if (tmp !== undefined) {
                            vrate = tmp;
                          }
                          else {
                            vrate = new VoiceRates();
                            vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                              voicerates.set(sessdata.authkey, vrate);
                              // let objv = new Res406(res);
                              // objv.prepare({ status: 401, message: "Unauthorized User" });
                              // objv.execute();
                            });
                          }
                        }
                        else {
                          vrate = new VoiceRates();
                          vrate.prepareRate(req, res, sessdata.idtariff, "voice", () => {
                            voicerates.set(sessdata.authkey, vrate);
                            // let objv = new Res406(res);
                            // objv.prepare({ status: 401, message: "Unauthorized User" });
                            // objv.execute();
                          });
                        }
                        if (vrate.count() > 0) {
                          let rate = vrate.getCallRate(req.body.Number);
                          let PayLoad: any = {
                            TO: sdata.Number
                          }
                          let lerg = new LergApi("", "");
                          lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber: any = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                              if (lerg_info.length > 0) {
                                baseapi.CallTransfer(req, res, next, sessdata, lerg_info, vrate, (call_err, call_result) => {
                                  if (call_result != undefined) {
                                    let objv = new RawView(res);
                                    objv.prepare(call_result);
                                    objv.execute();
                                  } else {
                                    let objv = new RawView(res);
                                    objv.prepare(call_err);
                                    objv.execute();
                                  }
                                })
                              } else {
                                let objv = new RawView(res);
                                objv.prepare("Lerg Info Not Found");
                                objv.execute();
                              }
                            })
                          })
                        } else {
                          let objv = new RawView(res);
                          objv.prepare("Data Not Found");
                          objv.execute();
                        }
                      } else {
                        let objv = new RawView(res);
                        objv.prepare({ status: 502, message: "Invalid Number.Please enter 10 digit number" });
                        objv.execute();
                      }
                    }
                    else {
                      let objv = new RawView(res);
                      objv.prepare({
                        error_code: err,
                        status: resp.status,
                        message: resp.message.replace(/::SN::/g, "CallTransfer")
                      });
                      objv.execute();
                    }
                  });
                }
                else {
                  let objv = new RawView(res);
                  objv.prepare({ status: 503, message: "Please add funds to your account or contact support." });
                  objv.execute();
                }
              });

            }
            else {
              let objvs = new RawView(res);
              objvs.prepare(dt);
              // objvs.prepare({ status: 404, message: "Not Permitted" });
              objvs.execute();
            }
          });
        }
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }

  // public blindTransfer(req: Request, res: Response, next: NextFunction) {
  //   let session = new SessionManagment(req, res, next);
  //   session.GetSession((error: any, sessdata: any) => {
  //     if (error == 1) {
  //       let client = new Socket();
  //       client.connect(parseInt(vs_server.PORT), vs_server.HOST, function () {
  //         client.write('auth ' + vs_server.PASS + '\n\n');
  //         console.log("api uuid_transfer " + req.body.UUID.trim() + " -bleg 88791" + req.body.NUMBER.trim() + " XML default \n\n");
  //         client.write("api uuid_transfer " + req.body.UUID.trim() + " -bleg 88791" + req.body.NUMBER.trim() + " XML default \n\n");
  //         client.on("data", (respon) => {
  //           let tmp = respon.toString().split("\n");
  //           tmp.forEach((elem: any) => {
  //             if (elem != undefined) {
  //               if (elem.length > 0) {
  //                 console.log(elem);
  //                 let t1 = elem.split("OK");
  //                 if (t1.length == 2) {
  //                   console.log(t1);
  //                   if (t1[0] == "+") {
  //                     res.status(200).send({ message: "Call Connected Successfully", uuid: t1[1].trim() });
  //                     client.destroy();
  //                   }
  //                 }
  //               }
  //             }
  //           });
  //         });

  //         client.on("error", (e) => {
  //           console.log(e);
  //         })

  //         client.on("end", () => {

  //         })
  //       });
  //     } else {
  //       let objv = new Res406(res);
  //       objv.prepare({ status: 401, message: "Unauthorized User" });
  //       objv.execute();
  //     }
  //   });
  // }

  public getChannelList(req: Request, res: Response, next: NextFunction) {
    let session = new SessionManagment(req, res, next);
    session.GetSession((error: any, sessdata: any) => {
      if (error == 1) {
        // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
        validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
          if (err == 1) {
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT *  FROM `channels` WHERE `accountcode`='" + sessdata.idaccount + "'";
            obj.prepare();
            obj.execute((err: any, resp: any) => {
              if (resp.length > 0) {
                let objv = new RawView(res);
                objv.prepare({ message: "Channels List", data: resp });
                objv.execute();
              } else {
                let objv = new RawView(res);
                objv.prepare("Data Not Found");
                objv.execute();
              }
            });
          }
          else {
            let objvs = new RawView(res);
            objvs.prepare(dt);
            // objvs.prepare({ status: 404, message: "Not Permitted" });
            objvs.execute();
          }
        });
      } else {
        let objv = new Res406(res);
        objv.prepare({ status: 401, message: "Unauthorized User" });
        objv.execute();
      }
    });
  }
}