"use strict";
const multer = require('multer');
import { UploadDirectory } from '../config/setting.config';

const MIME_TYPE_MAP: any = {
    'text/csv': 'csv',
    'audio/3gpp': '3ga',
    'video/3gpp': '3gp',
    'text/plain': 'txt',
    'audio/amr': 'amr',
    'video/x-msvideo': 'avi',
    'image/bmp': 'bmp',
    'application/x-bzip2': 'bz2',
    'application/calendar': 'cal',
    'text/css': 'css',
    'image/dib': 'dib',
    'audio/flac': 'flac',
    'video/x-flv': 'flv',
    'image/gif': 'gif',
    'application/x-gzip': 'gz',
    'image/x-icon': 'ico',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'application/javascript': 'js',
    'application/json': 'json',
    'audio/mpeg': 'm1a',
    'video/m1v': 'm1v',
    'audio/m2a': 'm2a',
    'audio/x-m4a': 'm4a',
    'audio/m4b': 'm4b',
    'audio/x-mp3': 'mp3',
    'video/mp4': 'mp4',
    'audio/x-ms-wma': 'mpa',
    'video/mpeg': 'mpeg',
    'video/mpg': 'mpg',
    'application/pdf': 'pdf',
    'image/pjpeg': 'pjpeg',
    'image/png': 'png',
    'video/quicktime': 'qt',
    'text/rtf': 'rtf',
    'audio/x-wav': 'wav',
    'video/webm': 'webm',
    'image/webp': 'webp',
    'video/x-ms-wmv': 'wmv',
    'application/xml': 'xml',
    'application/zip': 'zip'
};

const storage = multer.diskStorage({
    destination: (req: any, file: any, cb: any) => {
        let campaigndir = new UploadDirectory();
        const isValid = MIME_TYPE_MAP[file.mimetype];
        let error: any = "";
        /* if (!isValid) {
            error = new Error("Invalid file type");
        } */
        cb(error, campaigndir.CAMPAIGNUPLOAD);
    },
    filename: (req: any, file: any, cb: any) => {
        let file_path = file.originalname;
        let extension = file_path.split('.').pop();
        let randomName: any = Math.random().toString(36).substring(2, 12);
        const filenm = file.originalname;
        const flName = Date.now() + '-' + filenm.replace(filenm, randomName);
        const fileName = flName + '.' + extension;
        const ext = MIME_TYPE_MAP[file.mimetype];
        cb(null, fileName);
    }
});

module.exports = [multer({ storage: storage }).array('ATTACHMENTS')];

