
import { Request, Response, NextFunction } from "express";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { RawView } from "../lib/view/RawView";
import { cnam } from "../config/setting.config";
import parseBody from "./markError";
import { APIBase } from "./APIBase";
let validuser = new APIBase();
const UrlCnam = new cnam();
import { request } from './axios';

export class CnamApi {
    private key: string;
    private secret: string;
    private priority: string;
    private account: string;

    constructor(proirity: string, account: string) {
        this.key = "signalmash.com_did";
        this.secret = "092klqoz,s";
        this.priority = proirity;
        this.account = account;
    }

    /* <===  Outbound CNAM Entry ==> */
    public outboundCNAM(req: Request, res: Response, callback: (err: any, data: any) => void): void {
        let sdata = req.body;
        let options = {
            'method': 'GET',
            'url': UrlCnam.cnamUrl + "2139924664" + '&did=' + "2139924668",
            // 'url': 'http://104.219.42.181/cname/call.php?number="2139924664"&did="2139924668"',
            'headers': {
                'Content-Type': 'application/json',
                'Content-Length': 32,
            },
        };
        console.log("options", options);
        request(options, (error: any, response: any) => {
            if (response) {
                try {
                    console.log(`response`, response)
                    res.status(200).send({ "message": "Add Number Successfully", "result": response.body });
                }
                catch (e) {
                    console.log("Error :: outboundCNAM::", e);
                    let obj = new RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }

            } else {
                console.log(`Error`, error)
                res.status(110).send({ "error":  "Something went wrong!" });
            }
        });
    }

    /* <=== Inbound CNAM Entry ==> */
    public inboudCNAM(req: Request, res: Response, callback: (err: any, data: any) => void): void {
        let sdata = req.body;
        let options = {
            'method': 'GET',
            'url': UrlCnam.cnamUrl + "2139924664" + '&did=' + "2139924668",
            // 'url': 'http://104.219.42.181/cname/call.php?number="2139924664"&did="2139924668"',
            'headers': {
                'Content-Type': 'application/json',
                'Content-Length': 32,
            },
        };
        console.log("options", options);
        request(options, (error: any, response: any) => {
            if (response) {
                try {
                    console.log(`response`, response)
                    res.status(200).send({ "message": "Add Number Successfully", "result": response.body });
                }
                catch (e) {
                    console.log("Error :: inboudCNAM::", e);
                    let obj = new RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            } else {
                console.log(`Error`, error)
                res.status(110).send({ "error":  "Something went wrong!" });
            }
        });
    }

    public addCnam(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let msg: any = '';

        switch (true) {
            case !sdata:
                msg = 'Request body not found!';
                break;
        }

        if (msg) {
            let objv = new RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        } else {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                if (error == 1) {
                    const namecheck = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+$/;
                    let message: any = "";
                    switch (true) {
                        case (!sdata):
                            message = "Missing request body!";
                            break;
                        case (sdata == '' || sdata == 'null' || sdata == 'undefined'):
                            message = "Missing request body!";
                            break;
                        case (!sdata.Name):
                            message = "Name is required!";
                            break;
                        case (sdata.Name && !namecheck.test(sdata.Name)):
                            message = "Name is invalid!";
                            break;
                        case (sdata.DID && !/^[0-9]+$/.test(sdata.DID)):
                            message = "DID must be numeric!";
                            break;
                        case (!sdata.DID):
                            message = "DID is required!";
                            break;
                        default:
                            message = "";
                    }
                    if (message) {
                        let objv = new RawView(res);
                        objv.prepare({ status: 400, message });
                        objv.execute();
                    }
                    else {
                        // if(sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201 || sessdata.type== 202 || sessdata.type==203){
                        validuser.checksessionvalid1_2_201_202_203(req, res, sessdata, (err, dt) => {
                            if (err == 1) {
                                let obj = new ModelRawNonQuery(req, res);
                                obj.nonqrysql = "INSERT INTO `cnam` (`idaccount`, `iduser`, `name`, `did`) VALUE('" + sessdata.idaccount + "','" + sessdata.iduser + "','" + parseBody(sdata.Name) + "','" + sdata.DID + "')";
                                obj.prepare();
                                obj.execute((cnam_error, cnam_resp) => {
                                    if (cnam_error == 1) {
                                        let obj = new RawView(res);
                                        obj.prepare({ status: 201, message: "CNAM add successfully" });
                                        obj.execute()
                                    } else {
                                        let obj = new RawView(res);
                                        obj.prepare({ status: 502, message: "Something went wrong with connection!" });
                                        obj.execute()
                                    }
                                })
                            }
                            else {
                                let objvs = new RawView(res);
                                objvs.prepare(dt);
                                // objvs.prepare({ status: 404, message: "Not Permitted" });
                                objvs.execute();
                            }
                        })
                    }
                } else {
                    let objv = new Res406(res);
                    objv.prepare("No session data there");
                    objv.execute();
                }
            });
        }

    }

}
