import { Request, Response, NextFunction } from "express";
import HashMap from "hashmap";
// import { AppRoute } from "../lib/AppRoute";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { SessionManagment } from "../lib/model/Session";
import parseBody from "./markError";
import { MicroservicesUrlandKey} from "../config/setting.config";
const microUrls = new MicroservicesUrlandKey();
import { request } from './axios';

export class VoiceRates {
    private rate_data: HashMap<string, string>;

    constructor() {
        this.rate_data = new HashMap();
    }

    public count() {
        return this.rate_data.count();
    }

    public getDIDRate(did: string) {
        console.log("did", did);
        console.log("did", did.length);
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);
        if ((digit == "800" || digit == "822" || digit == "9" || digit == "844" || digit == "855" || digit == "866" || digit == "877" || digit == "888") && number.length == 10) {
            return this.rate_data.get("toll_free_number")
        } else if (digit == "808" && number.length == 10) {
            return this.rate_data.get("united_states - Hawaii (Zone 2)");
        } else if (digit == "907" && number.length == 10) {
            return this.rate_data.get("united_states - Alaska (Zone 3)");
        }
        else if (number.length == 10) {
            return this.rate_data.get("united_states_lower 48 (Zone 1)");
        }
        else if (number.length == 10) {
            return this.rate_data.get("local_number");
        }
        else {
            return this.rate_data.get("sip_interface");
        }
    }

    public getCallRate(did: string) {
        console.log("did", did);
        console.log("did", did.length);
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);
        if ((digit == "800" || digit == "822" || digit == "833" || digit == "844" || digit == "855" || digit == "866" || digit == "877" || digit == "888") && number.length == 10) {
            return this.rate_data.get("united_states_toll_free")
        } else if (digit == "808" && number.length == 10) {
            return this.rate_data.get("united_states - Hawaii (Zone 2)");
        } else if (digit == "907" && number.length == 10) {
            return this.rate_data.get("united_states - Alaska (Zone 3)");
        }
        else if (number.length == 10) {
            return this.rate_data.get("united_states_lower 48 (Zone 1)");
        }
        else {
            return this.rate_data.get("sip_interface");
        }
    }

    public getCallRates(did: string, zone: String) {
        console.log("did", did);
        console.log("did", did.length);
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 3);

        if ((digit == "800" || digit == "822" || digit == "833" || digit == "844" || digit == "855" || digit == "866" || digit == "877" || digit == "888") && number.length == 10) {
            return this.rate_data.get("united_states_toll_free");
        }
        else if (zone) {
            switch (zone) {
                case "Zone 2":
                    return this.rate_data.get("united_states - Hawaii (Zone 2)808");

                case "Zone 3":
                    return this.rate_data.get("united_states - Alaska (Zone 3)907");

                case "Zone 4":
                    return this.rate_data.get("united_state High Cost (Zone 4)");

                case "Zone 5":
                    return this.rate_data.get("united_state High Cost (Zone 5)");

                default:
                    return this.rate_data.get("united_states_lower 48 (Zone 1)");
            }
        }
        else {
            return this.rate_data.get("united_states_lower 48 (Zone 1)");
        }
        /* else {
            return this.rate_data.get("sip_trunking");
        } */
    }

    public getZone(req: Request, res: Response, did: any, callback: (err: any, data: any) => void) {
        let len = did.length - 10;
        console.log(did);
        let number = did.slice(len, did.length);
        let digit = number.slice(0, 6);
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `tz` FROM `zones` WHERE `npanxx`='" + digit + "'";
        obj1.prepare()
        obj1.execute((err, zone) => {
            if (err && zone.length > 0) {
                callback("", zone[0].tz);
            }
            else {
                callback("0", "");
            }
        });
    }

    public AMDRate(status: any) {
        if (status == "true")
            return this.rate_data.get("answering_machine_detection");
        else
            return "0";
    }

    public RecordRate(status: string) {
        if (status == "true") {
            console.log("record", this.rate_data.get("call_recording"));
            return this.rate_data.get("call_recording");
        }
        else
            return "0";
    }

    public setRate(data: HashMap<string, string>) {
        this.rate_data = data;
    }

    public getType(did: any) {
        console.log("did", did);
        let rate_type;
        let len = did.length - 10;
        let number = did.slice(len, did.length);
        console.log("number", number);
        let digit = number.slice(0, 3);
        console.log("digit", digit);
        if ((digit == 800 || digit == 822 || digit == 833 || digit == 844 || digit == 855 || digit == 866 || digit == 877 || digit == 888) && number.length == 10) {
            rate_type = "TF";
        }
        else if (number.length == 10) {
            rate_type = "NN";
        }
        else {
            rate_type = "short_code";
        }
        return rate_type;
    }

    public prepareRate(req: any, res: any, tariff: number, type: string, callback: (err: any, data: any) => void) {
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT IF(`rate`>0,`rate`,`mt`) `rate` ,`category` FROM `voice_rates` WHERE `idtariff`='" + tariff + "'  AND `type`='" + type + "'";
        obj1.prepare()
        obj1.execute((err, voice_rate) => {
            if (voice_rate.length > 0) {
                voice_rate.forEach((element: any) => {
                    this.rate_data.set(element.category, element.rate);
                });
                callback("", this.rate_data);
            } else {
                callback(err, "")
            }
        });
    }

    public verifyDid(req: Request, res: Response, callback: (err: any, data: any) => void) {
        let sdata = req.body;
        let didNumber = sdata.FROM;
        // let len = didNumber.length - 10;
        // let number = didNumber.slice(len, didNumber.length);
        let session = new SessionManagment(req, res, () => { });
        session.GetSession((error: any, sessdata: any) => {
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT * FROM `did_buy` WHERE `did`='" + didNumber + "'";
            obj.prepare();
            obj.execute((err, did) => {
                if (did.length > 0) {
                    callback('', 1);
                } else {
                    callback('', 1);
                }
            });
        });
    }

    public getState(req: any, res: any, did: any, callback: (err: any, data: any) => void) {
        let len = did.length - 10;
        var npa = did.slice(len, len + 3);
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT loc_state FROM `did_location_info` WHERE `npa`='" + npa + "' LIMIT 1";
        obj1.prepare()
        obj1.execute((err, state) => {
            if (state.length > 0) {
                callback("", state);
            } else {
                callback(err, "")
            }
        });
    }

    async insertBatch(req: Request, res: Response, dataBatch: string[][]): Promise<void> {
        let iQry = `INSERT INTO lerg_info (npa, nxx, block, ocn, lata, state, co_name_spec_c, category, lergdate, region, lata_name, country, rate_center) VALUES `;
        dataBatch.forEach((DID: any) => {
            iQry += `('${parseBody(DID[0])}','${parseBody(DID[1])}','${parseBody(DID[2])}','${parseBody(DID[3])}','${parseBody(DID[4])}','${parseBody(DID[5])}','${parseBody(DID[6])}','${parseBody(DID[7])}','${parseBody(DID[8])}','${parseBody(DID[9])}','${parseBody(DID[10])}','${parseBody(DID[11])}','${parseBody(DID[12])}'),`;
        });
        iQry = iQry.slice(0, -1);

        let obj = new ModelRawNonQuery(req, res);
        obj.nonqrysql = iQry;
        obj.prepare();

        return new Promise((resolve, reject) => {
            obj.execute((error: any, result: any) => {
                if (error == 1) {
                    console.log("Inserted batch successfully:", result);
                    resolve(result);
                } else {
                    console.error("Error inserting batch:", error);
                    reject(new Error('Failed to insert batch'));
                }
            });
        });
    }
     
    public checkIpWhiteListed(req: Request, res: Response, ipaddress: any, sessdata: any, callback: (err: any, data: any) => void) {
        console.log(sessdata.sessionType);
        console.log(ipaddress);
        if ((sessdata.sessionType == 'API' || sessdata.sessionType == 'SAPI') && sessdata.type != 1) {
            let options: any = {
                'method': 'GET',
                'url': microUrls.IpWhiteListedChecking + '/getiplevel/' + ipaddress + '/' + sessdata.authkey,
                'headers': {
                    'Content-Type': 'application/json',
                },
            };
            request(options, (error: any, response: any, body: any) => {
                try {
                    if (response && response.headers['content-type'] && response.headers['content-type'].includes('application/json') && response.body !== undefined && response.body) {
                        let data = JSON.parse(response.body);
                        if (data) {
                            console.log("data :: ", data);
                            if (data.status == 200 || data.status == 204) {
                                callback(1, {status: data.status, message: data.message});
                            }
                            else {
                                this.checkIpWhiteListed1(req, res, ipaddress, sessdata.authkey, callback);
                            }
                        }
                        else {
                            this.checkIpWhiteListed1(req, res, ipaddress, sessdata.authkey, callback);
                        }
                    }
                    else {
                        this.checkIpWhiteListed1(req, res, ipaddress, sessdata.authkey, callback);
                    }
                } catch (e) {
                    console.error("Error API :: ", e);
                    this.checkIpWhiteListed1(req, res, ipaddress, sessdata.authkey, callback);
                }
            });
        } 
        else {
            callback(1, { status: 200, message: "IP Whitelisting : No need to check API for PANEL and MORPHING!" });
        }
    }
 
    public checkIpWhiteListed1(req: Request, res: Response, ipaddress: any, authkey: any, callback: (err: any, data: any) => void) {
        let obj1 = new ModelRawQuery(req, res);
        obj1.qrysql = "SELECT `idapi`, `key`, `api_type` FROM `api` WHERE `key`='" + authkey + "' AND `api_type` = 1";
        obj1.prepare();
        obj1.execute((err, resp) => {
            if (err == 1) {
                if (resp && resp.length > 0) {
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `ip`, `idapi` FROM `api_ip` WHERE `ip`='" + ipaddress + "' AND `idapi`='" + resp[0].idapi + "'";
                    obj1.prepare();
                    obj1.execute((err, resp1) => {
                        if (err == 1) {
                            if (resp1 && resp1.length > 0) {
                                callback(1, { status: 200, message: "API is allowed." });
                            }
                            else {
                                callback(0, { status: 204, message: "API is not allowed for current IP!" });
                            }
                        }
                        else {
                            callback(0, { status: 501, message: "Something went wrong with get details from api ip!" });
                        }
                    });                    
                }
                else {
                    callback(1, { status: 200, message: "API is allowed." });
                }
            }
            else {
                callback(0, { status: 501, message: "Something went wrong with get detail from api" });
            }
        });
    }

}

