import e, { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
// import { AppRoute } from "../lib/AppRoute";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { parseBody, setToZero } from "./markError";
const Str = require('@supercharge/strings').Str;
import { APIBase } from "./APIBase";
let validuser = new APIBase();
const makeNumber = (length: number) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}
const makeChar = (length: number) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
}

const makeRanChar = (length: number) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    return result;
}

const generatePassword = () => {
    let result: any = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
}

export class Connection {
    constructor() {
        // super();

    }

    getConnections(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                /* let idaccount: any = (req.query.type === 'main') ? sessdata.idaccount : req.query.type ?? sessdata.idaccount; */
                let idaccount: any
                if (sessdata.type == 1) {
                    idaccount = (req.query.type == 'main') ? sessdata.idaccount : req.query.type ?? sessdata.idaccount;
                } else {
                    idaccount = sessdata.idaccount
                }

                let obj = new ModelRawQuery(req, res);
                if (sessdata.type == 22) {
                    obj.qrysql = "SELECT iduser, idaccount,port, name, username, password, status,idendpoint,isDefault, connection_key, tech_prefix, forward, forward_type FROM `endpoint` WHERE `iduser`= " + sessdata.iduser + "";
                }
                else {
                    obj.qrysql = "SELECT e.iduser, e.idaccount, e.idendpoint, e.name, e.username, e.password,  e.isDefault, e.status, e.connection_key, e.tech_prefix, CONCAT(us.firstname,' ',us.lastname) AS fullname, e.forward, e.forward_type,e.port FROM `endpoint`e JOIN `user_profile`us ON us.iduser = e.iduser WHERE e.`idaccount`= " + idaccount + " ORDER BY e.`idendpoint` DESC";
                }
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Connection Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // it is not in use
    getDid(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `did` FROM did_buy";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Did Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // get did history
    getDidHistory(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let ext_field: any;
                let sdata = req.query;
                let msg: any = '';

                switch (true) {
                    case !sdata:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    if (sessdata.type == 1) {
                        ext_field = ", CAST(`account_id` AS UNSIGNED) AS account_id,`iduser`"
                    }
                    let idact: any = sdata.selectedUser !== undefined && sdata.selectedUser !== 'undefined' && sdata.selectedUser ? sdata.selectedUser : 0;
                    let idaccount = (typeof idact === 'string' && idact.includes('-')) ? idact.split('-')[1] : '';
                    let condition: any = "";
                    let obj = new ModelRawQuery(req, res);
                    if (sdata.fromDate || sdata.toDate || sdata.didnumber || sdata.didnpa || sdata.selectedUser) {

                        if (sdata.didnumber && sdata.didnpa && sdata.fromDate && sdata.toDate && sdata.selectedUser) {
                            condition += 'created_at BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `did` LIKE "%' + sdata.didnumber + '%" AND `npa`="' + sdata.didnpa + '" AND `account_id`="' + idaccount + '"';
                        }

                        else if (sdata.didnpa && sdata.selectedUser && sdata.fromDate && sdata.toDate) {
                            condition += '`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `account_id`="' + idaccount + '" AND `npa`="' + sdata.didnpa + '"';
                        }

                        else if (sdata.didnumber && sdata.selectedUser && sdata.fromDate && sdata.toDate) {
                            condition += '`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `did` LIKE "%' + sdata.didnumber + '%" AND `account_id`="' + idaccount + '"';
                        }

                        else if (sdata.didnpa && sdata.didnumber && sdata.fromDate && sdata.toDate) {
                            condition += '`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `npa`="' + sdata.didnpa + '" AND `did` LIKE "%' + sdata.didnumber + '%"';
                        }

                        else if (sdata.didnpa && sdata.fromDate && sdata.toDate) {
                            condition += '`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `npa`="' + sdata.didnpa + '"';
                        }

                        else if (sdata.selectedUser && sdata.fromDate && sdata.toDate) {
                            condition += '`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `account_id`="' + idaccount + '"';
                        }

                        else if (sdata.didnumber && sdata.fromDate && sdata.toDate) {
                            condition += 'created_at BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59" AND `did` LIKE "%' + sdata.didnumber + '%"';
                        }

                        else {
                            condition += '`created_at` BETWEEN "' + sdata.fromDate + ' 00:00:00" AND "' + sdata.toDate + ' 23:59:59"';
                        }

                        obj.qrysql = "SELECT DISTINCT(TRIM('\r' FROM did )) AS did,`provider` " + ext_field + " FROM `did_log` WHERE " + condition + " ORDER BY `iddidlog` DESC LIMIT 1000";

                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "DID Log Fetched Successfully!", status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "No data Found!", status: 502 });
                        objv.execute();
                    }
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // get did history Details
    /*getDidHistoryDetails(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let splitdata = sdata.type.split('_');
        let iduser = splitdata[0];
        let did = splitdata[1];

        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT dl.iduser,dl.did,ch.iduser,dl.status,dl.provider,ch.`campaign_name`,ch.`campaign_key`, CONCAT(up.firstname,' ',up.lastname)`customer_name`, (SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=0  LIMIT 1) sdate, (SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=1 ORDER BY id DESC LIMIT 1) edate FROM `did_log` dl INNER JOIN `campaign_history` ch ON dl.`iddidlog`=ch.`iddidlog` INNER JOIN `user_profile` up ON up.iduser=dl.iduser WHERE dl.iduser='" + iduser + "' AND dl.did='" + did + "' GROUP BY ch.iddidlog ORDER BY ch.in_use ASC;";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Did Log Detail Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Did Log Detail!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }*/

    getDidHistoryDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let ext_field: any;
                let sdata: any = req.query;
                let msg: any = '';

                switch (true) {
                    case !sdata:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    if (sessdata.type == 1) {
                        ext_field = "up.iduser,"
                    }
                    let did = sdata.type;
                    let obj = new ModelRawQuery(req, res);
                    //obj.qrysql = "SELECT DISTINCT dl.iddidlog, dl.iduser, CONCAT(up.firstname,' ',up.lastname)`customer`, dl.created_at `sdate`, dl.updated_at `edate`, IF(dl.created_at IS NOT NULL AND dl.updated_at IS NOT NULL, DATEDIFF(dl.updated_at, dl.created_at), 'N/A') duration FROM `did_log` dl INNER JOIN `user_profile` up ON up.iduser=dl.iduser WHERE dl.did='" + did + "' ORDER BY dl.iddidlog DESC";
                    // obj.qrysql = "SELECT up.iduser,CONCAT(up.firstname,' ',up.lastname)`customer`,dl.`description`,dl.created_at AS `date`,CASE WHEN dl.event_type = '1' THEN 'DID Buy' WHEN dl.event_type = '2' THEN 'Import DID' WHEN dl.event_type = '3' THEN 'Auto Renewal Enable' WHEN dl.event_type = '33' THEN 'Auto Renewal Disable' WHEN dl.event_type = '4' THEN 'Connection Enable' WHEN dl.event_type = '44' THEN 'Connection Disable' WHEN dl.event_type = '5' THEN 'Disconnect DID' WHEN dl.event_type = '6' THEN 'Campaign Enable' WHEN dl.event_type = '66' THEN 'Campaign Disable From OSR' WHEN dl.event_type = '67' THEN 'Campaign Disable From SINCH' END AS event_type FROM `did_log` dl LEFT JOIN `user_profile` up ON up.iduser = dl.iduser WHERE dl.did='" + did + "'ORDER BY dl.iddidlog DESC;";
                    //obj.qrysql = "SELECT up.iduser,CONCAT(up.firstname,' ',up.lastname)`customer`,dl.`description`,dl.created_at AS `date`,CASE WHEN dl.event_type = '1' THEN 'DID Buy' WHEN dl.event_type = '2' THEN 'Import DID' WHEN dl.event_type = '3' THEN 'Auto Renewal Enable' WHEN dl.event_type = '4' THEN 'Connection Enable' WHEN dl.event_type = '5' THEN 'Disconnect DID from Provider' WHEN dl.event_type = '6' THEN 'DID provisioned TO OSR' WHEN dl.event_type = '7' THEN 'DID provisioned TO SINCH' WHEN dl.event_type = '8' THEN 'Auto Renewal Disable' WHEN dl.event_type = '9' THEN 'Connection Disable' WHEN dl.event_type = '10' THEN 'DID Disconnect From OSR' WHEN dl.event_type = '11' THEN 'DID Disconnect From SINCH' WHEN dl.event_type = '12' THEN 'OSR Provisioning Failed' WHEN dl.event_type = '13' THEN 'SINCH Provisioning Failed' WHEN dl.event_type = '14' THEN 'Connection Changed' WHEN dl.event_type = '15' THEN 'DID Billed' WHEN dl.event_type = '16' THEN 'DID Disconnect Failed From OSR' WHEN dl.event_type = '17' THEN 'DID Disconnect failed From SINCH' END AS event_type FROM `did_log` dl LEFT JOIN `user_profile` up ON up.iduser = dl.iduser WHERE dl.did='" + did + "'ORDER BY dl.iddidlog DESC;";

                    obj.qrysql = "SELECT " + ext_field + " CONCAT(up.firstname,' ',up.lastname)`customer`,dl.`description`,dl.created_at AS `date`,CASE WHEN dl.event_type = '1' THEN 'DID Buy' WHEN dl.event_type = '2' THEN 'Import DID' WHEN dl.event_type = '3' THEN 'Auto Renewal Enable' WHEN dl.event_type = '4' THEN 'Connection Enable' WHEN dl.event_type = '5' THEN 'Disconnect DID from Provider'WHEN dl.event_type = '6' THEN 'DID provisioned TO OSR' WHEN dl.event_type = '7' THEN 'DID provisioned TO SINCH' WHEN dl.event_type = '8' THEN 'Auto Renewal Disable' WHEN dl.event_type = '9' THEN 'Connection Disable' WHEN dl.event_type = '10' THEN 'DID Disconnect From OSR' WHEN dl.event_type = '11' THEN 'DID Disconnect From SINCH' WHEN dl.event_type = '12' THEN 'OSR Provisioning Failed'WHEN dl.event_type = '13' THEN 'SINCH Provisioning Failed' WHEN dl.event_type = '14' THEN 'Connection Changed' WHEN dl.event_type = '15' THEN 'DID Billed' WHEN dl.event_type = '16' THEN 'DID re-provisioned to SINCH' WHEN dl.event_type = '17' THEN 'DID disconnect failed from OSR' WHEN dl.event_type = '18' THEN 'DID disconnect failed from SINCH' WHEN dl.event_type = '19' THEN 'DID provisioning ACCEPTED to SYNIVERSE' WHEN dl.event_type = '20' THEN 'DID provisioning CONFLICT to SYNIVERSE' WHEN dl.event_type = '21' THEN 'DID provisioning PENDING to SYNIVERSE' WHEN dl.event_type = '22' THEN 'DID provisioning DEPLOYED to SYNIVERSE' WHEN dl.event_type = '23' THEN 'DID provisioning DEPLOYED_FAILED / ADD_FAILED to SYNIVERSE' WHEN dl.event_type = '24' THEN 'DID provisioning ADDED to SYNIVERSE' WHEN dl.event_type = '25' THEN 'DID provisioning MARK_DELETE to SYNIVERSE' WHEN dl.event_type = '26' THEN 'DID provisioning DELETE_FAILED / REMOVE_FAILED to SYNIVERSE' WHEN dl.event_type = '27' THEN 'DID provisioning REMOVED to SYNIVERSE' WHEN dl.event_type = '28' THEN 'DID provisioned to INTELLIQUENT' WHEN dl.event_type = '29' THEN 'DID provisioning failed to INTELLIQUENT' WHEN dl.event_type = '30' THEN 'DID provisioning MARK_DELETE to INTELLIQUENT' WHEN dl.event_type = '31' THEN 'Bulk DID Delete Initiated'END AS event_type FROM `did_log` dl LEFT JOIN `user_profile` up ON up.iduser = dl.iduser WHERE dl.did='" + did + "'ORDER BY dl.iddidlog DESC;";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Customer History Detail Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Did Log Detail!", status: 502 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getCampaignHistoryDetails(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let ext_field: any;
                let sdata: any = req.query;
                let msg: any = '';

                switch (true) {
                    case !sdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    if (sessdata.type == 1) {
                        ext_field = "dl.iduser,"
                    }
                    let did = sdata.type;
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT " + ext_field + " dl.did,ch.`campaign_name`,ch.`campaign_key`, GROUP_CONCAT(in_use)`in_use`,(SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=0  LIMIT 1) sdate, (SELECT created_at FROM campaign_history WHERE iddidlog=dl.`iddidlog` AND in_use=1 ORDER BY id DESC LIMIT 1) edate FROM `did_log` dl INNER JOIN `campaign_history` ch ON dl.`iddidlog`=ch.`iddidlog` WHERE dl.did='" + did + "' GROUP BY ch.campaign_key ORDER BY ch.id ASC";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Campaign History Detail Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Did Log Detail!", status: 502 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    AddCredential(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let rdata: any = {};
                        rdata = req.body;
                        let msg: any = '';

                        switch (true) {
                            case !rdata:
                                msg = 'Request body not found!';
                                break;
                        }

                        if (msg) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        } else {
                            validuser.checkcharValid(rdata.ConnectionKey, 500, 'ConnectionKey', (err2, msg2) => {
                                if (err2 == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare(msg2);
                                    objv.execute();
                                }
                                else {
                                    let obj01 = new ModelRawQuery(req, res);
                                    obj01.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `connection_key`='" + rdata.ConnectionKey + "'";
                                    obj01.prepare()
                                    obj01.execute((error01: any, result01: any) => {
                                        if (error01 == 1) {
                                            if (result01.length > 0) {
                                                if (rdata.Password) {
                                                    if (typeof rdata.Password === 'string' && rdata.Password.length >= 8) {
                                                        if (typeof rdata.Password === 'string' && rdata.Password.length <= 30) {
                                                            validuser.checkNameValid(rdata.Username, '500', 'Username', (err2, msg2) => {
                                                                if (err2 == 1) {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare(msg2);
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    const passw = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,30}$/;
                                                                    const username = /^[a-zA-Z_@#]+$/;
                                                                    rdata.Username = parseBody(typeof rdata.Username === 'string' ? rdata.Username.replace(/[@#]/g, '_') : '');
                                                                    if (rdata.Username.match(username)) {
                                                                        if (rdata.Password.match(passw)) {
                                                                            let obj2 = new ModelRawNonQuery(req, res);
                                                                            obj2.filter = null;
                                                                            obj2.nonqrysql = "UPDATE `endpoint` SET `username`='" + parseBody(rdata.Username) + "', `password`='" + parseBody(rdata.Password) + "' WHERE `connection_key`='" + rdata.ConnectionKey + "'";
                                                                            obj2.prepare();
                                                                            obj2.execute((_error: any, allcamp: any) => {
                                                                                if (_error == 1) {
                                                                                    let objv = new RawView(res)
                                                                                    objv.prepare({
                                                                                        message: "Connection Add Successfully",
                                                                                        status: 201
                                                                                    })
                                                                                    objv.execute();
                                                                                }
                                                                                else {
                                                                                    let objv = new RawView(res)
                                                                                    objv.prepare({
                                                                                        message: "Something Went Wrong With Connection!",
                                                                                        status: 502
                                                                                    })
                                                                                    objv.execute();
                                                                                }
                                                                            });
                                                                        }
                                                                        else {
                                                                            let objv = new RawView(res)
                                                                            objv.prepare({
                                                                                message: "At least One Uppercase Letter, One Lowercase Letter and At least One Number!",
                                                                                status: 503
                                                                            })
                                                                            objv.execute();
                                                                        }
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res)
                                                                        objv.prepare({
                                                                            message: "Username Accept Only Character and Underscore!",
                                                                            status: 503
                                                                        })
                                                                        objv.execute();
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView(res)
                                                            objv.prepare({
                                                                message: "Password should be max 30 character long!",
                                                                status: 504
                                                            })
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView(res)
                                                        objv.prepare({
                                                            message: "Password should be minimum 8 character long",
                                                            status: 505
                                                        })
                                                        objv.execute();
                                                    }
                                                } else {
                                                    let objv = new RawView(res)
                                                    objv.prepare({
                                                        message: "Password is required",
                                                        status: 505
                                                    })
                                                    objv.execute();
                                                }
                                            } else {
                                                let objv = new RawView(res)
                                                objv.prepare({
                                                    message: "Connection key does not exist!",
                                                    status: 400
                                                })
                                                objv.execute();

                                            }
                                        } else {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "Unable to Get campaign key!",
                                                status: 502
                                            })
                                            objv.execute();

                                        }

                                    })
                                }
                            });
                        }

                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    /* AddIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + req.body.ConnectionKey + "' AND `idaccount`='"+sessdata.idaccount+"'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let rdata: any = [];
                            let da = req.body.IP.split(',');
                            da.forEach((element: any) => {
                                rdata.push({ idendpoint: result[0].idendpoint, ip: element })
                            });
                            rdata.forEach((element: any) => {
                                let obj2 = new ModelRawQuery(req, res);
                                obj2.qrysql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES('" + element.idendpoint + "', '" + element.ip + "')";
                                obj2.prepare();
                                obj2.execute((_error: any, allcamp: any) => {
                                });
                            });
                            let objv = new RawView(res);
                            objv.prepare({ status: 201, message: "IP Add Successfully!" });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Connection Key not found", status: 404 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    } */
    // used only swagger side

    AddIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.body:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                        if (err == 1) {
                            validuser.checkcharValid(req.body.ConnectionKey, 500, 'ConnectionKey', (err2, msg2) => {
                                if (err2 == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare(msg2);
                                    objv.execute();
                                } else {
                                    let obj = new ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `connection_key`='" + req.body.ConnectionKey + "' AND `idaccount`='" + sessdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((_error: any, result: any) => {
                                        if (_error == 1) {
                                            if (result.length > 0) {
                                                let rdata: any = [];
                                                let uipVal = '';
                                                let checkIp: boolean = false;
                                                let isValidIP: boolean = false;
                                                if (req.body.IP && typeof req.body.IP === 'string' && req.body.IP != 'null' && req.body.IP != 'undefiend' && req.body.IP != '') {
                                                    let da = req.body.IP.split(',');
                                                    const octet = '(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)';
                                                    const regex = new RegExp(`^${octet}\\.${octet}\\.${octet}\\.${octet}$`);
                                                    da.forEach((element: any) => {
                                                        rdata.push({ idendpoint: result[0].idendpoint, ip: element });
                                                        checkIp = regex.test(element);
                                                        if (!checkIp) {
                                                            isValidIP = true;
                                                        }
                                                    });
                                                    if (!isValidIP) {
                                                        let unique = da.filter((items: any, i: any, ar: string | any[]) => ar.indexOf(items) === i);
                                                        let uniqueAllData: any = [...new Map(rdata.map((item: { [x: string]: any; }) => [item['ip'], item])).values()];
                                                        for (let uip of unique) {
                                                            uipVal += "'" + uip + "'" + ','
                                                        }

                                                        let checkUniqueIp = uipVal.slice(0, uipVal.length - 1);
                                                        let obj0 = new ModelRawQuery(req, res);
                                                        obj0.qrysql = "SELECT `idendpoint`, `ip` FROM `ip_address` WHERE `ip` IN (" + checkUniqueIp + ") && idendpoint!='" + uniqueAllData[0].idendpoint + "'";
                                                        obj0.prepare();
                                                        obj0.execute((error: any, data: any) => {
                                                            if (error == 1) {
                                                                if (data.length > 0) {
                                                                    let objv = new RawView(res)
                                                                    objv.prepare({
                                                                        message: "IP Address already exists!",
                                                                        status: 502
                                                                    })
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    if (uniqueAllData.length == rdata.length) {
                                                                        rdata.forEach((element: any) => {
                                                                            let obj2 = new ModelRawNonQuery(req, res);
                                                                            obj2.nonqrysql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES('" + element.idendpoint + "', '" + element.ip + "')";
                                                                            obj2.prepare();
                                                                            obj2.execute((_error: any, allcamp: any) => {
                                                                            });
                                                                        });
                                                                        let objv = new RawView(res);
                                                                        objv.prepare({ status: 201, message: "IP Add Successfully!" });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res)
                                                                        objv.prepare({
                                                                            message: "Duplicate Ip Address!",
                                                                            status: 503
                                                                        })
                                                                        objv.execute();
                                                                    }
                                                                }
                                                            }
                                                            else {
                                                                let objv = new RawView(res)
                                                                objv.prepare({
                                                                    message: "Something Went Wrong with Ip Address!",
                                                                    status: 504
                                                                })
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "IPaddress format is Incorrect", status: 505 });
                                                        objv.execute();
                                                    }

                                                } else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "IPaddress  is required", status: 505 });
                                                    objv.execute();

                                                }

                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ message: "Data not found", status: 404 });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Connection", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                            })


                        } else {
                            let objv = new RawView(res);
                            objv.prepare(dt);
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    /* UpdateIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + req.body.ConnectionKey + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        if (result.length > 0) {
                            let rdata: any = [];
                            let da = req.body.IP.split(',');
                            da.forEach((element: any) => {
                                rdata.push({ idendpoint: result[0].idendpoint, ip: element })
                            });
                            let obj3 = new ModelRawQuery(req, res);
                            obj3.qrysql = "delete from ip_address where idendpoint = '" + rdata[0].idendpoint + "'";
                            obj3.prepare();
                            obj3.execute((derror: any, allcamp: any) => {
                                if (derror == 1) {
                                    let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                    rdata.forEach((element: any) => {
                                        sql += "('" + element.idendpoint + "','" + element.ip + "'),"
                                    });
                                    sql = sql.substring(0, sql.length - 1);
                                    let obj2 = new ModelRawQuery(req, res);
                                    obj2.qrysql = sql;
                                    obj2.prepare();
                                    obj2.execute((_error: any, allcamp: any) => {
                                        if (_error == 1) {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "IP Updated Successfully!",
                                                status: 201
                                            })
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "Something Went Wrong With Connection!",
                                                status: 502
                                            })
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                    rdata.forEach((element: any) => {
                                        sql += "('" + element.idendpoint + "','" + element.ip + "'),"
                                    });
                                    sql = sql.substring(0, sql.length - 1);
                                    let obj2 = new ModelRawQuery(req, res);
                                    obj2.qrysql = sql;
                                    obj2.prepare();
                                    obj2.execute((_error: any, allcamp: any) => {
                                        if (_error == 1) {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "IP Updated Successfully!",
                                                status: 201
                                            })
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "Something Went Wrong With Connection!",
                                                status: 502
                                            })
                                            objv.execute();
                                        }
                                    });
                                }
                            });
                        } else {
                            let objv = new RawView(res)
                            objv.prepare({
                                message: "Connection Key not found!",
                                status: 404
                            })
                            objv.execute();
                        }
                    } else {
                        let objv = new RawView(res)
                        objv.prepare({
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        })
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    } */

    UpdateIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.body:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                        if (err == 1) {
                            validuser.checkcharValid(req.body.ConnectionKey, 500, 'ConnectionKey', (err2, msg2) => {
                                if (err2 == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare(msg2);
                                    objv.execute();
                                }
                                else {
                                    let obj = new ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT idendpoint FROM `endpoint` WHERE `connection_key`='" + req.body.ConnectionKey + "' AND `idaccount`='" + sessdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((_error: any, result: any) => {
                                        if (_error == 1) {
                                            if (result.length > 0) {
                                                let rdata: any = [];
                                                if (req.body.IP && typeof req.body.IP === 'string' && req.body.IP != 'null' && req.body.IP != 'undefiend' && req.body.IP != '') {
                                                    let da = req.body.IP.split(',');
                                                    let uipVal = '';
                                                    let checkIp: boolean = false;
                                                    let isValidIP: boolean = false;
                                                    const octet = '(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]?|0)';
                                                    const regex = new RegExp(`^${octet}\\.${octet}\\.${octet}\\.${octet}$`);
                                                    da.forEach((element: any) => {
                                                        rdata.push({ idendpoint: result[0].idendpoint, ip: element });
                                                        checkIp = regex.test(element);
                                                        if (!checkIp) {
                                                            isValidIP = true;
                                                        }
                                                    });
                                                    if (!isValidIP) {
                                                        let unique = da.filter((items: any, i: any, ar: string | any[]) => ar.indexOf(items) === i);
                                                        let uniqueAllData: any = [...new Map(rdata.map((item: { [x: string]: any; }) => [item['ip'], item])).values()];
                                                        for (let uip of unique) {
                                                            uipVal += "'" + uip + "'" + ','
                                                        }
                                                        let checkUniqueIp = uipVal.slice(0, uipVal.length - 1);
                                                        let obj0 = new ModelRawQuery(req, res);
                                                        obj0.qrysql = "SELECT `idendpoint`, `ip` FROM `ip_address` WHERE `ip` IN (" + checkUniqueIp + ") && idendpoint!='" + uniqueAllData[0].idendpoint + "'";
                                                        obj0.prepare();
                                                        obj0.execute((error: any, data: any) => {
                                                            if (error == 1) {
                                                                if (data.length > 0) {
                                                                    let objv = new RawView(res)
                                                                    objv.prepare({
                                                                        message: "IP Address already exists!",
                                                                        status: 502
                                                                    })
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    if (uniqueAllData.length == rdata.length) {
                                                                        let obj3 = new ModelRawNonQuery(req, res);
                                                                        obj3.nonqrysql = "DELETE FROM ip_address WHERE idendpoint = '" + rdata[0].idendpoint + "'";
                                                                        obj3.prepare();
                                                                        obj3.execute((derror: any, allcamp: any) => {
                                                                            if (derror == 1) {
                                                                                let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                                                                rdata.forEach((element: any) => {
                                                                                    sql += "('" + element.idendpoint + "','" + element.ip + "'),"
                                                                                });
                                                                                sql = sql.substring(0, sql.length - 1);
                                                                                let obj2 = new ModelRawNonQuery(req, res);
                                                                                obj2.nonqrysql = sql;
                                                                                obj2.prepare();
                                                                                obj2.execute((_error: any, allcamp: any) => {
                                                                                    if (_error == 1) {
                                                                                        let objv = new RawView(res)
                                                                                        objv.prepare({
                                                                                            message: "IP Updated Successfully!",
                                                                                            status: 201
                                                                                        })
                                                                                        objv.execute();
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView(res)
                                                                                        objv.prepare({
                                                                                            message: "Something Went Wrong With Connection!",
                                                                                            status: 502
                                                                                        })
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                            }
                                                                            else {
                                                                                let objv = new RawView(res)
                                                                                objv.prepare({
                                                                                    message: "Something Went Wrong With Update IP!",
                                                                                    status: 506
                                                                                })
                                                                                objv.execute();

                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res)
                                                                        objv.prepare({
                                                                            message: "Duplicate Ip Address!",
                                                                            status: 503
                                                                        })
                                                                        objv.execute();
                                                                    }
                                                                }
                                                            }
                                                            else {
                                                                let objv = new RawView(res)
                                                                objv.prepare({
                                                                    message: "Something Went Wrong with Ip Address!",
                                                                    status: 504
                                                                })
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ message: "IPaddress format is Incorrect", status: 505 });
                                                        objv.execute();
                                                    }


                                                } else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ message: "IPaddress  is required", status: 505 });
                                                    objv.execute();

                                                }

                                            } else {
                                                let objv = new RawView(res)
                                                objv.prepare({
                                                    message: "Data not found!",
                                                    status: 404
                                                })
                                                objv.execute();
                                            }
                                        } else {
                                            let objv = new RawView(res)
                                            objv.prepare({
                                                message: "Something Went Wrong With Connection!!",
                                                status: 502
                                            })
                                            objv.execute();
                                        }
                                    });

                                }
                            });


                        } else {
                            let objv = new RawView(res);
                            objv.prepare(dt);
                            // objv.prepare({ status: 404, message: "Not Permitted" });
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    UpdataFqdn(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let rdata: any = req.body;
                        let msg: any = '';

                        switch (true) {
                            case !rdata:
                                msg = 'Request body not found!';
                                break;
                        }

                        if (msg) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        } else {
                            validuser.checkcharValid(rdata.ConnectionKey, 500, 'ConnectionKey', (err2, msg2) => {
                                if (err2 == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare(msg2);
                                    objv.execute();
                                } else {
                                    let obj = new ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + rdata.ConnectionKey + "' AND `idaccount`='" + sessdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((_error: any, result: any) => {
                                        if (_error == 1) {
                                            if (result.length > 0) {
                                                validuser.checkNameValid(rdata.user, '500', 'User', (err2, msg2) => {
                                                    if (err2 == 1) {
                                                        let objv = new RawView(res);
                                                        objv.prepare(msg2);
                                                        objv.execute();
                                                    } else {
                                                        if (rdata.type && rdata.type != 'null' && rdata.type != 'null' && rdata.type != '') {
                                                            if (rdata.type == "A" || rdata.type == "SRV") {
                                                                let obj2 = new ModelRawNonQuery(req, res);

                                                                obj2.filter = null;
                                                                obj2.nonqrysql = "UPDATE routing_profile SET FQDN_type='" + rdata.type + "', FQDN_user='" + parseBody(rdata.user) + "' WHERE idendpoint='" + result[0].idendpoint + "'";
                                                                obj2.prepare();
                                                                obj2.execute((_error: any, allcamp: any) => {
                                                                    if (_error == 1) {
                                                                        let objv = new RawView(res)
                                                                        obj2.prepare();
                                                                        objv.prepare({
                                                                            status: 201,
                                                                            message: "Updated Successfully"
                                                                        })
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView(res)
                                                                        obj2.prepare();
                                                                        objv.prepare({
                                                                            status: 502,
                                                                            message: "Something Went Wrong With Connection!"
                                                                        })
                                                                        objv.execute();
                                                                    }
                                                                });

                                                            } else {
                                                                let objv2 = new RawView(res)
                                                                objv2.prepare({
                                                                    status: 500,
                                                                    message: "Type is Invalid!"
                                                                })
                                                                objv2.execute()
                                                            }
                                                        } else {
                                                            let objv2 = new RawView(res)
                                                            objv2.prepare({
                                                                status: 500,
                                                                message: "Type is required!"
                                                            })
                                                            objv2.execute();
                                                        }
                                                    }
                                                })
                                            } else {
                                                let objv2 = new RawView(res)
                                                objv2.prepare({
                                                    status: 404,
                                                    message: "Connection Key not found"
                                                })
                                                objv2.execute();
                                            }
                                        } else {
                                            let objv2 = new RawView(res)
                                            objv2.prepare({
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            })
                                            objv2.execute();
                                        }
                                    });
                                }
                            });
                        }

                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    AddForwardAll(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let rdata: any = {};
                        rdata = req.body;
                        let msg: any = '';

                        switch (true) {
                            case !rdata:
                                msg = 'Request body not found!';
                                break;
                        }

                        if (msg) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        } else {
                            validuser.checkcharValid(rdata.ConnectionKey, 500, 'ConnectionKey', (err2, msg2) => {
                                if (err2 == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare(msg2);
                                    objv.execute();
                                }
                                else {
                                    let obj = new ModelRawQuery(req, res);
                                    obj.qrysql = "SELECT idendpoint FROM `endpoint` where `connection_key`='" + rdata.ConnectionKey + "' AND `idaccount`='" + sessdata.idaccount + "'";
                                    obj.prepare();
                                    obj.execute((_error: any, result: any) => {
                                        if (_error == 1) {
                                            if (result.length > 0) {
                                                let obj2 = new ModelRawNonQuery(req, res);
                                                let number;
                                                switch (rdata.forward_type) {
                                                    case "Sip uri":
                                                        number = 1;
                                                        break;
                                                    case "Number":
                                                        number = 2;
                                                        break;
                                                    case "IP Address":
                                                        number = 3;
                                                        break;
                                                    case "Group":
                                                        number = 4;
                                                        break;
                                                    case "Extension":
                                                        number = 5;
                                                        break;
                                                }
                                                obj2.filter = null;
                                                obj2.nonqrysql = "UPDATE `endpoint` SET `forward_type`='" + number + "',`forward`='" + parseBody(rdata.forward) + "' WHERE `connection_key`='" + rdata.ConnectionKey + "' AND `idaccount`=" + sessdata.idaccount + "";
                                                obj2.prepare();
                                                obj2.execute((_error: any, allcamp: any) => {
                                                    if (_error == 1) {
                                                        if (allcamp.affectedRows > 0) {
                                                            let objv = new RawView(res)
                                                            objv.prepare({
                                                                message: "Connection Updated Successfully",
                                                                status: 201
                                                            })
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView(res)
                                                            objv.prepare({
                                                                message: "Connection Not Updated Successfully",
                                                                status: 503
                                                            })
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        let objv = new RawView(res)
                                                        objv.prepare({
                                                            message: "Something Went Wrong With Connection!",
                                                            status: 502
                                                        })
                                                        objv.execute();
                                                    }
                                                });
                                            } else {
                                                let objv2 = new RawView(res)
                                                objv2.prepare({
                                                    status: 404,
                                                    message: "Connection Key not found"
                                                })
                                                objv2.execute();
                                            }
                                        } else {
                                            let objv2 = new RawView(res)
                                            objv2.prepare({
                                                status: 504,
                                                message: "Something went wrong with connection!"
                                            })
                                            objv2.execute();
                                        }
                                    });
                                }
                            });
                        }

                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        // objv.prepare({ status: 404, message: "Not Permitted" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    AddHookUrl(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        const urlPattern = /^(https?:\/\/)?([a-zA-Z0-9.-]+)(:\d+)?(\/[^\s#?]*)?(\?[^\s#]*)?(#[^\s]*)?$/;
                        let message: any = "";
                        switch (true) {
                            case (!sdata):
                                message = "Request body not Found!";
                                break;
                            case (!sdata.ConnectionKey && !sdata.Type && !sdata.Urls):
                                message = "Missing request body!";
                                break;
                            case (!sdata.ConnectionKey || sdata.ConnectionKey == '' || sdata.ConnectionKey == 'null' || sdata.ConnectionKey == 'undefined'):
                                message = "Connection Key is Required!";
                                break;
                            case (!sdata.Type || sdata.Type == '' || sdata.Type == 'null' || sdata.Type == 'undefined'):
                                message = "Type is Required!";
                                break;
                            case (!sdata.Urls || sdata.Urls == '' || sdata.Urls == 'null' || sdata.Urls == 'undefined'):
                                message = "Urls is Required!";
                                break;
                            case (sdata.Type != 'CDR Url' && sdata.Type != 'SMS Receive' && sdata.Type != 'SMS Status'):
                                message = "Type is invalid";
                                break;
                            case (!sdata.ConnectionKey || !/^[A-Za-z0-9_\-]{30}$/.test(sdata.ConnectionKey)):
                                message = "Connection Key is invalid!";
                                break;
                            case (!urlPattern.test(sdata.Urls)):
                                message = "Invalid Url!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 402, message: message });
                            objv.execute();
                        } else {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `idendpoint` FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "' AND `idaccount`= '" + sessdata.idaccount + "'";
                            obj.prepare();
                            obj.execute((_errorChk: any, resLt: any) => {
                                if (_errorChk == 1) {
                                    if (resLt.length > 0) {
                                        let type: any;
                                        let priority: any;
                                        switch (sdata.Type) {
                                            case "CDR Url":
                                                type = "cdr";
                                                priority = '0';
                                                break;
                                            case "SMS Receive":
                                                type = "sms-received";
                                                priority = '1';
                                                break;
                                            case "SMS Status":
                                                type = "sms-status";
                                                priority = '2';
                                                break;
                                        }
                                        let obj1 = new ModelRawQuery(req, res);
                                        obj1.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE idendpoint=(SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') AND `type`= '" + type + "'";
                                        obj1.prepare();
                                        obj1.execute((_errorgt: any, result: any) => {
                                            if (_errorgt == 1) {
                                                if (result.length > 0) {
                                                    let obj = new ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "UPDATE hooksetting SET url='" + parseBody(sdata.Urls) + "' WHERE idendpoint=(SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') AND type='" + type + "'";
                                                    obj.prepare();
                                                    obj.execute((hook_error: any, hook_result: any) => {
                                                        if (hook_error == 1) {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Webhook Url Inserted Successfully", status: 201 });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Something went wrong with Insert Urls!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let obj11 = new ModelRawNonQuery(req, res);
                                                    obj11.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES ((SELECT idaccount FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "'), (SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') , '" + type + "' , '" + parseBody(sdata.Urls) + "', " + setToZero(priority) + " , '')";
                                                    obj11.prepare();
                                                    obj11.execute((_error: any, data: any) => {
                                                        if (_error == 1) {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Webhook Url Inserted Successfully", status: 201 });
                                                            objv.execute();
                                                        } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ message: "Something went wrong with Insert Urls!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                            }
                                            else {
                                                let objv2 = new RawView(res)
                                                objv2.prepare({
                                                    status: 504,
                                                    message: "Something went wrong with hook data!"
                                                })
                                                objv2.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv2 = new RawView(res)
                                        objv2.prepare({
                                            status: 404,
                                            message: "Connection Key not found"
                                        })
                                        objv2.execute();
                                    }
                                }
                                else {
                                    let objv2 = new RawView(res)
                                    objv2.prepare({
                                        status: 504,
                                        message: "Something went wrong with connection!"
                                    })
                                    objv2.execute();
                                }
                            });
                        }
                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        // objv.prepare({ status: 404, message: "Not Permitted" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }



    UpdateHookUrl(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        const urlPattern = /^(https?:\/\/)?([a-zA-Z0-9.-]+)(:\d+)?(\/[^\s#?]*)?(\?[^\s#]*)?(#[^\s]*)?$/;
                        let message: any = "";
                        switch (true) {
                            case (!sdata):
                                message = "Request body not found!";
                                break;
                            case (!sdata.ConnectionKey && !sdata.Type && !sdata.Urls):
                                message = "Missing request body!";
                                break;
                            case (!sdata.ConnectionKey || sdata.ConnectionKey == '' || sdata.ConnectionKey == 'null' || sdata.ConnectionKey == 'undefined'):
                                message = "Connection Key is Required!";
                                break;
                            case (!sdata.Type || sdata.Type == '' || sdata.Type == 'null' || sdata.Type == 'undefined'):
                                message = "Type is Required!";
                                break;
                            case (!sdata.Urls || sdata.Urls == '' || sdata.Urls == 'null' || sdata.Urls == 'undefined'):
                                message = "Urls is Required!";
                                break;
                            case (sdata.Type != 'CDR Url' && sdata.Type != 'SMS Receive' && sdata.Type != 'SMS Status'):
                                message = "Type is invalid";
                                break;
                            case (!sdata.ConnectionKey || !/^[A-Za-z0-9_\-]{30}$/.test(sdata.ConnectionKey)):
                                message = "Connection Key is invalid!";
                                break;
                            case (!urlPattern.test(sdata.Urls)):
                                message = "Invalid Url!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 402, message: message });
                            objv.execute();
                        } else {
                            // if ((sdata.Urls && sdata.ConnectionKey && sdata.Type)) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `idendpoint` FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "' AND `idaccount`= '" + sessdata.idaccount + "'";
                            obj.prepare();
                            obj.execute((errorChk: any, resLt: any) => {
                                if (errorChk == 1) {
                                    if (resLt.length > 0) {
                                        let type;
                                        switch (sdata.Type) {
                                            case "CDR Url":
                                                type = "cdr";
                                                break;
                                            case "SMS Receive":
                                                type = "sms-received";
                                                break;
                                            case "SMS Status":
                                                type = "sms-status";
                                                break;
                                        }
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE hooksetting SET url='" + parseBody(sdata.Urls) + "' WHERE idendpoint=(SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') AND type='" + type + "'";
                                        obj.prepare();
                                        obj.execute((hook_error: any, hook_result: any) => {
                                            if (hook_error == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 201, message: "Webhook Urls Updated Successfully" });
                                                objv.execute();
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv2 = new RawView(res)
                                        objv2.prepare({
                                            status: 404,
                                            message: "Connection Key not found"
                                        })
                                        objv2.execute();
                                    }
                                }
                                else {
                                    let objv2 = new RawView(res)
                                    objv2.prepare({
                                        status: 504,
                                        message: "Something went wrong with connection!"
                                    })
                                    objv2.execute();
                                }
                            });
                        }
                        // else {
                        //     let objv2 = new RawView(res)
                        //     objv2.prepare({
                        //         status: 402,
                        //         message: "All fields are required!"
                        //     })
                        //     objv2.execute();
                        // }
                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    getInbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let msg: any = '';

                switch (true) {
                    case !sdata:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT ani, dnis, ringback_timeout, answer_timeout, enable_prack, enable_privacy_zone, enable_sip_compact,sip_uri,media_type,inbound_key, recording FROM inbound WHERE idendpoint=" + sdata.type + "";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Inbound Connection Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Connection", status: 502 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getOutbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let msg: any = '';

                switch (true) {
                    case !sdata:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT outbound_key, caller_id, recording,  uuid_detail, country, initiated_by, voice_profile, type, media_type, generate_ringback, enable_ringback, amd FROM outbound WHERE idendpoint=" + sdata.type + "";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Outbound Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    // currently this function not in use
    getConnectionData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid1_2_22_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new ModelRawQuery(req, res);
                        obj.qrysql = "SELECT idrouting_profile, idendpoint, encode_header, DTMF_type, enable_on_net, comfort_noise, FQDN_type, FQDN_user FROM routing_profile";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Routing Profile Fetched Successfully!", status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        // objv.prepare({ message: "Service Unavialable!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    getUrlData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let ext_field: any;
                let sdata = req.query;
                let msg: any = '';

                switch (true) {
                    case !sdata:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    if (sessdata.type == 1) {
                        ext_field = "idaccount,"
                    }
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT " + ext_field + " idhooksetting, idendpoint, type, url, priority, sms_key FROM `hooksetting` WHERE `idendpoint`=" + sdata.type + " AND `idaccount`=" + sessdata.idaccount + "";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Hooksetting Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    getExpertSetting(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let msg: any = '';

                switch (true) {
                    case !sdata:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT encode_header, enable_on_net, DTMF_type, comfort_noise FROM `routing_profile` WHERE `idendpoint`=" + sdata.type + "";
                    obj.prepare();
                    obj.execute((_error: any, result: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Routing Profile Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    saveConnection(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const connection_key = Str.random(30);
                const randDigit = connection_key.slice(4, 12);
                var rdata: any = [];
                rdata = req.body.data != undefined ? req.body.data : req.body;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                        if (err == 1) {
                            validuser.checkNameValid(rdata.connectionName, '500', 'Connection name', (err2, msg2) => {
                                if (err2 == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare(msg2);
                                    objv.execute();
                                }
                                else {
                                    let obj1 = new ModelRawQuery(req, res);
                                    obj1.qrysql = "SELECT `idendpoint` FROM endpoint where `idaccount`='" + sessdata.idaccount + "' AND name = '" + parseBody(rdata.connectionName) + "'";
                                    obj1.prepare();
                                    obj1.execute((_error: any, getConn: any) => {
                                        if (_error == 1) {
                                            if (getConn.length > 0) {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    message: "Connection Already Exists!",
                                                    status: 404
                                                });
                                                objv.execute();
                                            }
                                            else {
                                                let obj8 = new ModelRawQuery(req, res);
                                                obj8.qrysql = "SELECT `idendpoint` FROM endpoint where isDefault = 'true'";
                                                obj8.prepare();
                                                obj8.execute((cerror: any, getConn1: any) => {
                                                    if (cerror == 1) {
                                                        var isDefault: any;
                                                        if (getConn1.length > 0) {
                                                            isDefault = "false";
                                                        }
                                                        else {
                                                            isDefault = "true";
                                                        }

                                                        let obj2 = new ModelRawNonQuery(req, res);
                                                        obj2.filter = null;
                                                        let username = Math.random().toString(36).substr(2, 11);
                                                        //let username = sessdata.username + val;
                                                        //let password = randDigit;
                                                        let password = generatePassword();
                                                        const inbound_key = Str.random(30);
                                                        const outbound_key = Str.random(30);
                                                        obj2.nonqrysql = "CALL addconnection('" + sessdata.idaccount + "', '" + sessdata.iduser + "', '" + parseBody(rdata.connectionName) + "', '" + connection_key + "', '" + parseBody(username) + "', '" + parseBody(password) + "', '" + inbound_key + "', '" + outbound_key + "', '" + isDefault + "')";
                                                        obj2.prepare();
                                                        obj2.execute((__error: any, allcamp: any) => {
                                                            if (__error == 1) {
                                                                let newData = allcamp[0];
                                                                delete newData[0].idendpoint
                                                                delete newData[0].iduser
                                                                delete newData[0].idaccount
                                                                delete newData[0].isDeleted
                                                                delete newData[0].isbalance
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    data: newData[0],
                                                                    message: "Connection Saved Successfully!",
                                                                    status: 201
                                                                });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    data: allcamp[0],
                                                                    message: "Something Went Wrong With Connection",
                                                                    status: 502
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            message: "Something Went Wrong With DB Connection!",
                                                            status: 502
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                message: "Something Went Wrong With DB Connection!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }

                            });
                        } else {
                            let objv = new RawView(res);
                            objv.prepare(dt);
                            // objv.prepare({ status: 404, message: "Not Permitted" });
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    saveConnectionIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                const connection_key = Str.random(30);
                const randDigit = connection_key.slice(4, 12);
                var rdata: any = [];
                rdata = req.body.data != undefined ? req.body.data : req.body;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    validuser.checkNameValid(rdata.connectionName, '500', 'Connection name', (err2, msg2) => {
                        if (err2 == 1) {
                            let objv = new RawView(res);
                            objv.prepare(msg2);
                            objv.execute();
                        }
                        else {
                            let obj1 = new ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT idendpoint FROM endpoint where `idaccount`=" + sessdata.idaccount + " AND name = '" + parseBody(rdata.connectionName) + "'";
                            obj1.prepare();
                            obj1.execute((_error: any, getConn: any) => {
                                if (_error == 1) {
                                    if (getConn.length > 0) {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            message: "Connection Already Exists!",
                                            status: 404
                                        });
                                        objv.execute();
                                    }
                                    else {
                                        let obj8 = new ModelRawQuery(req, res);
                                        obj8.qrysql = "SELECT `idendpoint` FROM endpoint where isDefault = 'true'";
                                        obj8.prepare();
                                        obj8.execute((cerror: any, getConn1: any) => {
                                            if (cerror == 1) {
                                                var isDefault: any;
                                                if (getConn1.length > 0) {
                                                    isDefault = "false";
                                                }
                                                else {
                                                    isDefault = "true";
                                                }

                                                let obj2 = new ModelRawNonQuery(req, res);
                                                obj2.filter = null;
                                                let username = Math.random().toString(36).substr(2, 11);
                                                //let username = sessdata.username + val;
                                                //let password = randDigit;
                                                let password = generatePassword();
                                                const inbound_key = Str.random(30);
                                                const outbound_key = Str.random(30);
                                                obj2.nonqrysql = "CALL addconnection(" + sessdata.idaccount + ", " + sessdata.iduser + ", '" + parseBody(rdata.connectionName) + "', '" + connection_key + "', '" + parseBody(username) + "', '" + parseBody(password) + "', '" + inbound_key + "', '" + outbound_key + "', '" + isDefault + "')";
                                                obj2.prepare();
                                                obj2.execute((__error: any, allcamp: any) => {
                                                    if (__error == 1) {
                                                        let newData = allcamp[0];
                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            data: newData[0],
                                                            message: "Connection Saved Successfully!",
                                                            status: 201
                                                        });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            data: allcamp[0],
                                                            message: "Something Went Wrong With Connection",
                                                            status: 502
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    message: "Something Went Wrong With DB Connection!",
                                                    status: 502
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Something Went Wrong With DB Connection!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    getIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let sdata = req.query;
                let msg: any = '';

                switch (true) {
                    case !sdata:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                    validuser.checksessionvalid1_2_22_201_202_203(req, res, sessdata, (err, dt) => {
                        if (err == 1) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT id_ipaddress,idendpoint,ip FROM ip_address WHERE idendpoint=" + sdata.type + "";
                            obj.prepare();
                            obj.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result, message: "IP Address Fetched Successfully!", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        } else {
                            let objv = new RawView(res);
                            objv.prepare(dt);
                            // objv.prepare({ message: "Service unavailable!", status: 502 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    deleteConnection(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.query:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let sdata: any = req.query.id;
                    let sdata1 = JSON.parse(sdata);
                    let obj = new ModelRawNonQuery(req, res)
                    obj.nonqrysql = "SELECT `idendpoint`,`isDefault` FROM `endpoint` WHERE `idendpoint` = '" + sdata1.endpoint + "'";
                    obj.prepare();
                    obj.execute((error1: any, result: any) => {
                        if (error1 == 1) {
                            if (result.length > 0) {
                                if (result[0].isDefault == 'true') {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 400,
                                        message: "Existing default connection cannot be deleted!"
                                    });
                                    objv.execute();
                                } else {
                                    if (sdata1.data.addcheck == true && sdata1.did.length !== 0) {
                                        let didValues = sdata1.did.map((item: { did: string }) => item.did).join("','");
                                        let obj0 = new ModelRawNonQuery(req, res)
                                        obj0.nonqrysql = "SELECT `connection_key` FROM `endpoint` WHERE `isDefault` = 'true' AND `iduser` = '" + sdata1.iduser + "' "
                                        obj0.prepare();
                                        obj0.execute((error2: any, result1: any) => {
                                            if (error2 == 1) {
                                                let obj1 = new ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = `UPDATE did_buy SET connection_key = '${result1[0].connection_key}' WHERE did IN ('${didValues}') AND connection_key = '${sdata1.key}'`;
                                                obj1.prepare();
                                                obj1.execute((errors: any, result2: any) => {
                                                    if (errors == 1) {
                                                        let delConn = new Connection();
                                                        delConn.deleteconnectiondetails(req, res, sdata1.endpoint, (errorr, resp) => {
                                                            let objv = new RawView(res);
                                                            objv.prepare(resp);
                                                            objv.execute();
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 502, message: "Something Went Wrong With Connection!" });
                                                        objv.execute();
                                                    }
                                                })
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 502, message: "Something Went Wrong With Get Connection Key!" });
                                                objv.execute();
                                            }
                                        })
                                    }
                                    if (sdata1.did.length == 0) {
                                        let delConn = new Connection();
                                        delConn.deleteconnectiondetails(req, res, sdata1.endpoint, (errorr, resp) => {
                                            let objv = new RawView(res);
                                            objv.prepare(resp);
                                            objv.execute();
                                        });
                                    } if (sdata1.data.addcheck == false && sdata1.did.length !== 0) {
                                        let didValues = sdata1.did.map((item: { did: string }) => item.did).join("','");
                                        let obj1 = new ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = `UPDATE did_buy SET connection_key = '' WHERE did IN ('${didValues}') AND connection_key = '${sdata1.key}'`;
                                        obj1.prepare();
                                        obj1.execute((errors: any, result: any) => {
                                            if (errors == 1) {
                                                let delConn = new Connection();
                                                delConn.deleteconnectiondetails(req, res, sdata1.endpoint, (errorr, resp) => {
                                                    let objv = new RawView(res);
                                                    objv.prepare(resp);
                                                    objv.execute();
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection!" });
                                                objv.execute();
                                            }
                                        })
                                    }
                                }
                            } else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 505, message: "Kindly enter correct Connection Key!" });
                                objv.execute();
                            }
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ status: 501, message: "Something Went Wrong with Get Detail!" });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    deleteconnectiondetails(req: Request, res: Response, idendpoint: any, callback: (err: any, data: any) => void) {
        let obj0 = new ModelRawNonQuery(req, res);
        obj0.nonqrysql = "DELETE FROM inbound WHERE idendpoint = " + idendpoint + "";
        obj0.prepare();
        obj0.execute((error0: any, resInbound: any) => {
            console.log("Connection's inbound data has Deleted from inbound table");
        });

        let obj1 = new ModelRawNonQuery(req, res);
        obj1.nonqrysql = "DELETE FROM outbound WHERE idendpoint = " + idendpoint + "";
        obj1.prepare();
        obj1.execute((error1: any, resOutbound: any) => {
            console.log("Connection's outbound data has Deleted from outbound table");
        });

        let obj2 = new ModelRawNonQuery(req, res);
        obj2.nonqrysql = "DELETE FROM ip_address WHERE idendpoint = " + idendpoint + "";
        obj2.prepare();
        obj2.execute((error2: any, resIP: any) => {
            console.log("Connection's ip_address data has Deleted from ip_address table");
        });

        let obj3 = new ModelRawNonQuery(req, res);
        obj3.nonqrysql = "DELETE FROM routing_profile WHERE idendpoint = " + idendpoint + "";
        obj3.prepare();
        obj3.execute((error3: any, resRP: any) => {
            console.log("Connection's  routing_profile data has Deleted from routing_profile table");
        });

        let obj4 = new ModelRawNonQuery(req, res);
        obj4.nonqrysql = "DELETE FROM hooksetting WHERE idendpoint = " + idendpoint + "";
        obj4.prepare();
        obj4.execute((error4: any, resHS: any) => {
            console.log("Connection's hooksetting data has Deleted from hooksetting table");
        });

        let obj5 = new ModelRawNonQuery(req, res);
        obj5.nonqrysql = "DELETE FROM endpoint WHERE idendpoint = " + idendpoint + "";
        obj5.prepare();
        obj5.execute((error5: any, getresp: any) => {
            if (error5 == 1) {
                callback(1, { status: 201, message: "Connection Deleted Successfully!" })
            } else {
                callback(0, { status: 502, message: "Something Went Wrong With Connection!" })
            }
        })
    }

    saveIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.body:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    var rdata: any = [];
                    Array.isArray(req?.body?.data?.IPArr) && (rdata = req.body.data.IPArr, rdata.forEach((element: any) => {
                        let obj2 = new ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "INSERT INTO ip_address (`iduser`, `idaccount`, `idendpoint`, `ip`) VALUES('" + sessdata.iduser + "', '" + sessdata.idaccount + "', '" + element.idendpoint + "', '" + element.ip + "')";
                        obj2.prepare();
                        obj2.execute((_error: any, allcamp: any) => { });
                    }));

                    let objv = new RawView(res);
                    objv.prepare({ message: "IP Saved Successfully!" });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    save_smsOutbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.filter = null;
                    obj2.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type`='" + rdata.type + "' AND `idaccount`='" + sessdata.idaccount + "'";
                    obj2.prepare();
                    obj2.execute((_error: any, response: any) => {
                        if (_error == 1) {
                            if (response.length > 0) {
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE hooksetting SET `url`='" + parseBody(rdata.delivery_url) + "' WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type` = '" + rdata.type + "' AND `idaccount`='" + sessdata.idaccount + "'";
                                obj3.execute((error: any, result: any) => {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result, message: "Updated Successfully!", status: 201 });
                                    objv.execute();
                                });
                            }
                            else {
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "INSERT INTO hooksetting(`idaccount`, `idendpoint`, `type`, `url`) VALUES ('" + sessdata.idaccount + "', '" + rdata.idendpoint + "', '" + rdata.type + "', '" + parseBody(rdata.delivery_url) + "')";
                                obj3.execute((error: any, result: any) => {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result, message: "Saved Successfully!", status: 201 });
                                    objv.execute();
                                });
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ error: response, message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }

    save_smsInbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.filter = null;
                    obj2.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type`='" + rdata.type + "' AND `idaccount`='" + sessdata.idaccount + "'";
                    obj2.prepare();
                    obj2.execute((_error: any, response: any) => {
                        if (_error == 1) {
                            if (response != null && response != '') {
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE hooksetting SET `url`='" + parseBody(rdata.url) + "' WHERE `idendpoint` = '" + rdata.idendpoint + "' AND `type` = '" + rdata.type + "'  AND `idaccount`='" + sessdata.idaccount + "'";
                                obj3.execute((__error: any, result: any) => {
                                    if (__error == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result, message: "Updated Successfully", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result, message: "Updated Successfully", status: 502 });
                                        objv.execute();
                                    }
                                });
                            } else {
                                let obj3 = new ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "INSERT INTO hooksetting(`idaccount`, `idendpoint`, `type`, `url`) VALUES ('" + sessdata.idaccount + "', '" + rdata.idendpoint + "', '" + rdata.type + "', '" + rdata.url + "')";
                                obj3.execute((__error: any, result: any) => {
                                    if (__error == 1) {
                                        let objv = new RawView(res);
                                        objv.prepare({ data: result, message: "Saved Successfully!", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        })
    }


    saveUrls(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                let result: any = [];
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    Array.isArray(rdata) && rdata.forEach((element: any) => {
                        Array.isArray(element) && element.forEach((ele: any) => {
                            result[ele.field] = ele.value;
                        });


                        let sms_key = Str.random(30);
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES(" + sessdata.idaccount + ", " + result.idendpoint + ", '" + result.type + "', '" + parseBody(result.url) + "', " + setToZero(result.ID) + ", '" + sms_key + "')";
                        obj.prepare();
                        obj.execute((error: any, data: any) => {
                        });
                    });
                    let objv = new RawView(res);
                    objv.prepare({ message: "Updated Successfully", status: 201 });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    deleteIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.query:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE FROM ip_address WHERE id_ipaddress = '" + req.query.id + "'";
                    obj.prepare();
                    obj.execute((_error: any, lastid: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "IP Deleted Successfully.", data: lastid[0], status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", data: lastid[0], status: 201 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateInbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = {};
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    obj2.nonqrysql = "UPDATE inbound SET dnis='" + rdata.dnis + "', ani='" + rdata.ani + "', ringback_timeout='" + rdata.ringback_timeout + "', answer_timeout='" + rdata.answer_timeout + "', channel_limit='" + rdata.channel_limit + "', sip_uri='" + rdata.sip_uri + "', media_type='" + rdata.media_type + "', enable_sip_compact='" + rdata.enable_sip_compact + "', enable_privacy_zone='" + rdata.enable_privacy_zone + "', enable_prack='" + rdata.enable_prack + "', recording='" + rdata.recording + "' WHERE idendpoint=" + rdata.idendpoint + "";
                    obj2.prepare();
                    obj2.execute((_error: any, data: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                error: 0,
                                data: data,
                                message: "Inbound Updated Successfully!",
                                status: 201
                            })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error: 0,
                                data: data,
                                message: "Something Went Wrong With Connection!",
                                status: 502
                            })
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateOutbound(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = {};
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let ntype = req.body.data.type;
                    let uuid: any = '';
                    if (rdata.uuid_detail && rdata.uuid_detail != 'null') { uuid = rdata.uuid_detail; } else { uuid = ''; }
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    obj2.nonqrysql = "UPDATE outbound SET caller_id='" + parseBody(rdata.caller_id) + "', type='" + ntype + "', country='" + rdata.country + "', channel_limit='" + rdata.channel_limit + "', initiated_by='" + rdata.initiated_by + "', voice_profile='" + rdata.voice_profile + "', media_type='" + rdata.media_type + "', enable_ringback='" + rdata.ringback + "', generate_ringback='" + rdata.tone + "', recording='" + rdata.recording + "', uuid_detail='" + parseBody(uuid) + "', amd='" + rdata.amd + "' WHERE idendpoint=" + rdata.idendpoint + "";
                    obj2.prepare();
                    obj2.execute((_error: any, allcamp: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                error: 0,
                                data: allcamp,
                                message: "Outbound Updated Successfully",
                                status: 201
                            })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error: 0,
                                data: allcamp,
                                message: "Something Went Wrong With Connection!",
                                status: 502
                            })
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateConnectionName(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = {};
                rdata = req.body.data;
                let message: any = "";
                switch (true) {
                    case (!rdata || !('data' in req.body)):
                        message = "Missing request body";
                        break;
                    case (rdata.connectionName && !/^.{1,255}$/.test(rdata.connectionName)):
                        message = "Connection name is invalid";
                        break;
                    default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView(res)
                    objv.prepare({ message: message, status: 501, error: 0 })
                    objv.execute();
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    obj2.nonqrysql = "UPDATE `endpoint` SET `name`='" + parseBody(rdata.connectionName) + "', `brandId`='" + rdata.brand + "', `campaignId`='" + rdata.campaign + "'  WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + "";
                    obj2.prepare();
                    obj2.execute((_error: any, allcamp: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                error: 0,
                                data: allcamp,
                                message: "Connection Name Updated Successfully",
                                status: 201
                            })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                error: 0,
                                data: allcamp,
                                message: "Something Went Wrong With Connection Name!",
                                status: 502
                            })
                            objv.execute();
                        }
                    });
                }
                // });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateConnTeckPre(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = {};
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    obj2.nonqrysql = "UPDATE `endpoint` SET `tech_prefix`='" + rdata.tech_prefix + "' WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + "";
                    obj2.prepare();
                    obj2.execute((_error: any, trechPre: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res)
                            objv.prepare({ data: trechPre, message: "Tech Prefix Updated Successfully!", status: 201 })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res)
                            objv.prepare({
                                data: trechPre, message: "Something Went Wrong With Tech Prefix!", status: 502
                            })
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data Available!");
                objv.execute();
            }
        });
    }
    updateConnUserPass(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = {};
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    obj2.nonqrysql = "UPDATE `endpoint` SET `username`='" + parseBody(rdata.username) + "', `password`='" + parseBody(rdata.password) + "' WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + "";
                    obj2.prepare();
                    obj2.execute((_error: any, credentials: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res)
                            objv.prepare({ error: 0, data: credentials, message: "Credentials Updated Successfully!", status: 201 })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res)
                            objv.prepare({
                                error: 0, data: credentials, message: "Something Went Wrong With Credentials!", status: 502
                            })
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data Available!");
                objv.execute();
            }
        });
    }
    updateConnInboundCall(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = {};
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    let conn = '';
                    if (rdata.forward_type !== 1 && rdata.forward_type !== 2) {
                        conn = ", `port`=" + setToZero(rdata.port) + "";
                    }
                    obj2.nonqrysql = "UPDATE `endpoint` SET `forward_type`='" + rdata.forward_type + "',`forward`='" + parseBody(rdata.forward) + "' " + conn + " WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + " ";
                    obj2.prepare();
                    obj2.execute((_error: any, credentials: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res)
                            objv.prepare({ error: 0, data: credentials, message: "Forwards Updated Successfully!", status: 201 })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res)
                            objv.prepare({
                                error: 0, data: credentials, message: "Something Went Wrong With Forwords!", status: 502
                            })
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data Available!");
                objv.execute();
            }
        });
    }
    updateStatus(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.body:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj = new ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE endpoint SET status='" + req.body.data + "' WHERE idendpoint=" + req.query.id + " AND `idaccount`=" + sessdata.idaccount + ""
                    obj.prepare();
                    obj.execute((_error: any, lastid: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Status Update Successfully.", data: lastid[0], status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Status Update Successfully.", data: lastid, status: 502 });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateConnection(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = {};
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    let techPrefix: any;
                    if (rdata.tech_prefix) {
                        techPrefix = rdata.tech_prefix;
                    } else {
                        techPrefix = '';
                    }
                    obj2.nonqrysql = "UPDATE `endpoint` SET `name`='" + parseBody(rdata.connectionName) + "', `username`='" + rdata.username + "', `password`='" + rdata.password + "', `tech_prefix`='" + techPrefix + "',`forward_type`='" + rdata.forward_type + "',`forward`='" + rdata.forward + "', `brandId`='" + rdata.brand + "', `campaignId`='" + rdata.campaign + "' WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + "";
                    obj2.prepare();
                    obj2.execute((_error: any, allcamp: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res)
                            objv.prepare({
                                error: 0,
                                data: allcamp,
                                message: "Connection Updated Successfully",
                                status: 201
                            })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res)
                            objv.prepare({
                                error: 0,
                                data: allcamp,
                                message: "Something Went Wrong With Connection!",
                                status: 502
                            })
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateFQDN(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata;
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    obj2.nonqrysql = "UPDATE routing_profile SET FQDN_type='" + rdata.type + "', FQDN_user='" + rdata.user + "' WHERE idendpoint='" + rdata.idendpoint + "'";
                    obj2.prepare();
                    obj2.execute((_error: any, allcamp: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 201,
                                message: "Updated Successfully"
                            })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Something Went Wrong With Connection!"
                            })
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    // updateIP(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let rdata: any = [];
    //             rdata = req.body.data.IPArr
    //             let obj3 = new ModelRawQuery(req, res);
    //             obj3.qrysql = "delete from ip_address where idendpoint = '" + rdata[0].idendpoint + "'";
    //             obj3.prepare();
    //             obj3.execute((derror: any, allcamp: any) => {
    //                 if (derror == 1) {
    //                     let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
    //                     rdata.forEach((element: any) => {
    //                         sql += "('" + element.idendpoint + "','" + element.ip + "'),"
    //                     });
    //                     sql = sql.substring(0, sql.length - 1);
    //                     let obj2 = new ModelRawQuery(req, res);
    //                     obj2.qrysql = sql;
    //                     obj2.prepare();
    //                     obj2.execute((_error: any, allcamp: any) => {
    //                         if (_error == 1) {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "IP Updated Successfully!",
    //                                 status: 201
    //                             })
    //                             objv.execute();
    //                         }
    //                         else {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "Duplicate Entry Please Try Again!",
    //                                 status: 1062
    //                             })
    //                             objv.execute();
    //                         }
    //                     });
    //                 }
    //                 else {
    //                     let sql = "INSERT INTO ip_address (`iduser`, `idaccount`,`idendpoint`, `ip`) VALUES ";
    //                     rdata.forEach((element: any) => {
    //                         sql += "('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + element.idendpoint + "','" + element.ip + "'),"
    //                     });
    //                     sql = sql.substring(0, sql.length - 1);
    //                     let obj2 = new ModelRawQuery(req, res);
    //                     obj2.qrysql = sql;
    //                     obj2.prepare();
    //                     obj2.execute((_error: any, allcamp: any) => {
    //                         if (_error == 1) {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "IP Updated Successfully!",
    //                                 data: allcamp,
    //                                 status: 201
    //                             })
    //                             objv.execute();
    //                         }
    //                         else {
    //                             let objv = new RawView(res)
    //                             objv.prepare({
    //                                 message: "Something Went Wrong With Connection!",
    //                                 status: 502
    //                             })
    //                             objv.execute();
    //                         }
    //                     });
    //                 }
    //             });
    //             // obj2.filter = null;
    //         } else {
    //             let objv = new Res406(res);
    //             objv.prepare("No session data there");
    //             objv.execute();
    //         }
    //     });
    // }

    updateIP(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.body:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let rdata: any = [];
                    rdata = req.body.data.IPArr
                    let ipVal = '';
                    let uipVal = '';
                    let uniqueIp: any = [];
                    let uniqueData: any = [];
                    for (let ip of rdata) {
                        ipVal += "'" + ip.ip + "'" + ','
                    }
                    Array.isArray(rdata) &&
                        rdata.forEach((element: any) => {
                            uniqueIp.push(element.ip);
                            uniqueData.push({
                                idendpoint: element.idendpoint,
                                ip: element.ip
                            });
                        });

                    let unique = uniqueIp.filter((items: any, i: any, ar: string | any[]) => ar.indexOf(items) === i);
                    let uniqueAllData: any = [...new Map(uniqueData.map((item: { [x: string]: any; }) => [item['ip'], item])).values()];
                    for (let uip of unique) {
                        uipVal += "'" + uip + "'" + ','
                    }
                    if (uniqueAllData[0].idendpoint && uniqueAllData[0].idendpoint !== undefined && uniqueAllData[0].idendpoint !== 'undefined') {
                        let checkUniqueIp = uipVal.slice(0, uipVal.length - 1);
                        let obj0 = new ModelRawQuery(req, res);
                        obj0.qrysql = "SELECT `idendpoint`, `ip` from `ip_address` WHERE `ip` IN (" + checkUniqueIp + ") AND idendpoint!=" + uniqueAllData[0].idendpoint + "";
                        obj0.prepare();
                        obj0.execute((error: any, data: any) => {
                            if (error == 1) {
                                if (data.length > 0) {
                                    let objv = new RawView(res)
                                    objv.prepare({
                                        message: "IP Address already exists!",
                                        status: 502
                                    })
                                    objv.execute();
                                }
                                else {
                                    if (uniqueAllData.length == uniqueData.length) {
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "DELETE from ip_address WHERE idendpoint = " + uniqueAllData[0].idendpoint + "";
                                        obj3.prepare();
                                        obj3.execute((derror: any, delRes: any) => {
                                            if (derror == 1) {
                                                let sql = "INSERT INTO ip_address (`idendpoint`, `ip`) VALUES ";
                                                uniqueAllData.forEach((element: any) => {
                                                    sql += "(" + element.idendpoint + ",'" + element.ip + "'),"
                                                });
                                                sql = sql.substring(0, sql.length - 1);
                                                let obj2 = new ModelRawNonQuery(req, res);
                                                obj2.nonqrysql = sql;
                                                obj2.prepare();
                                                obj2.execute((_error: any, insertRes: any) => {
                                                    if (_error == 1) {
                                                        let obj1 = new ModelRawQuery(req, res);
                                                        obj1.qrysql = "SELECT ip,id_ipaddress FROM `ip_address` WHERE `idendpoint`=" + uniqueAllData[0].idendpoint + "";
                                                        obj1.prepare();
                                                        obj1.execute((_errorget: any, resultenp: any) => {
                                                            if (_errorget) {
                                                                let objv = new RawView(res)
                                                                objv.prepare({
                                                                    message: "IP Inserted Successfully!",
                                                                    status: 201,
                                                                    dataip: resultenp
                                                                })
                                                                objv.execute();
                                                            } else {
                                                                let objv = new RawView(res)
                                                                objv.prepare({
                                                                    message: "IP Not Inserted!",
                                                                    status: 502,
                                                                    dataip: resultenp
                                                                })
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res)
                                                        objv.prepare({
                                                            message: "IP Address already exists!!",
                                                            status: 502
                                                        })
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView(res)
                                                objv.prepare({
                                                    message: "Something Went Wrong With Update IP!",
                                                    status: 506
                                                })
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView(res)
                                        objv.prepare({
                                            message: "Duplicate Ip Address!",
                                            status: 502
                                        })
                                        objv.execute();
                                    }
                                }
                            }
                            else {
                                let objv = new RawView(res)
                                objv.prepare({
                                    message: "Something Went Wrong with Ip Address!",
                                    status: 502
                                })
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new Res406(res);
                        objv.prepare("Something went wrong with IP Address update. Please try again.");
                        objv.execute();
                    }
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    updateUrls(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = [];
                let result: any = [];
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    Array.isArray(rdata) && rdata.forEach((element: any) => {
                        Array.isArray(element) && element.forEach((ele: any) => {
                            result[ele.field] = ele.value;
                        });


                        // if(result.idhooksetting){
                        if (result.url == null) {
                            result.url = '';
                        }
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE hooksetting SET url='" + parseBody(result.url) + "' WHERE idendpoint=" + result.idendpoint + " AND type='" + result.type + "' AND `idaccount`=" + sessdata.idaccount + "";
                        obj.prepare();
                        obj.execute((error: any, data: any) => {
                        });
                        // }
                        // else{
                        //     let sms_key = Str.random(30);
                        //     let obj = new ModelRawNonQuery(req, res);
                        //     obj.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES('" + sessdata.idaccount + "', '" +result.idendpoint + "', '" + result.type + "', '" + result.url + "', '" + result.ID + "', '"+sms_key+"')";
                        //     obj.prepare();
                        //     obj.execute((error: any, data: any) => {
                        //     });
                        // }
                    });
                    let objv = new RawView(res);
                    objv.prepare({ message: "Updated Successfully", status: 201 });
                    objv.execute();
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    insertUrlsData(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let idendpoint = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !idendpoint:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    // delete
                    // let obj0 = new ModelRawQuery(req, res);
                    // obj0.qrysql = "SELECT * FROM `hooksetting` WHERE `idendpoint`='"+ idendpoint +"'";
                    // obj0.prepare();
                    // obj0.execute((_errorgt: any, resultchk: any) => {
                    //     if(resultchk.length <= 2){
                    //         let obj00 = new ModelRawQuery(req, res);
                    //         obj00.qrysql = "delete from hooksetting where idendpoint = '" + idendpoint + "'";
                    //         obj00.prepare();
                    //         obj00.execute((derror: any, allcamp: any) => {
                    // insert
                    let obj1 = new ModelRawQuery(req, res);
                    obj1.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE `idendpoint`='" + idendpoint + "' AND `type`= 'cdr' AND `idaccount`='" + sessdata.idaccount + "'";
                    obj1.prepare();
                    obj1.execute((_errorgt: any, resultcdr: any) => {

                        if (resultcdr == '') {
                            let obj11 = new ModelRawNonQuery(req, res);
                            obj11.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES  (" + sessdata.idaccount + ", " + idendpoint + " , 'cdr' , '', 0 , '')";
                            obj11.prepare();
                            obj11.execute((_error: any, data: any) => { });
                        }
                    });
                    let obj2 = new ModelRawQuery(req, res);
                    obj2.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE `idendpoint`='" + idendpoint + "' AND `type`= 'sms-status'";
                    obj2.prepare();
                    obj2.execute((_errorgt: any, resultstatus: any) => {

                        if (resultstatus == '') {
                            let obj22 = new ModelRawNonQuery(req, res);
                            obj22.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES  (" + sessdata.idaccount + ", " + idendpoint + " , 'sms-status' , '', 2 , '')";
                            obj22.prepare();
                            obj22.execute((_error: any, data: any) => { });
                        }
                    });
                    let obj3 = new ModelRawQuery(req, res);
                    obj3.qrysql = "SELECT `idendpoint` FROM `hooksetting` WHERE `idendpoint`=" + idendpoint + " AND `type`= 'sms-received'";
                    obj3.prepare();
                    obj3.execute((errorgtreceived: any, resultreceived: any) => {

                        if (resultreceived == '') {
                            let obj33 = new ModelRawNonQuery(req, res);
                            obj33.nonqrysql = "INSERT INTO hooksetting (`idaccount`,`idendpoint`, `type`, `url`, `priority`, `sms_key`) VALUES  (" + sessdata.idaccount + ", " + idendpoint + " , 'sms-received' , '', 1 , '')";
                            obj33.prepare();
                            obj33.execute((_error: any, data: any) => { });
                        }
                    });
                    //});
                    let objv = new RawView(res);
                    objv.prepare({ error: 0, message: "Updated Successfully", status: 201 })
                    objv.execute();
                    //     }
                    // });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    public updateExpertSetting(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = {};
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    obj2.nonqrysql = "UPDATE routing_profile SET encode_header='" + rdata.Encode + "', comfort_noise='" + rdata.enable_comfort + "', enable_on_net='" + rdata.enable_on_net + "', DTMF_type='" + rdata.DTMF_type + "' WHERE idendpoint=" + rdata.idendpoint + "";
                    obj2.prepare();
                    obj2.execute((_error: any, allcamp: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res)
                            obj2.prepare();
                            objv.prepare({
                                error: 0,
                                data: allcamp,
                                message: "Updated Successfully",
                                status: 201
                            })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res)
                            obj2.prepare();
                            objv.prepare({
                                error: 0,
                                data: allcamp,
                                message: "Something Went Wrong With Connection!",
                                status: 502
                            })
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    public updatePassword(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE endpoint SET username='" + parseBody(rdata.password) + "' WHERE idendpoint='" + rdata.idendpoint + "' AND `idaccount`='" + sessdata.idaccount + "'";
                    obj2.prepare();
                    obj2.execute((_error: any, upPass: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res)
                            objv.prepare({ error: 1, data: upPass, message: "Updated Successfully", status: 201 })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res)
                            objv.prepare({ error: 0, message: "Something Went Wrong With update Password!", status: 502 })
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data available!");
                objv.execute();
            }
        });
    }

    listConnectionsSwagger(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let resultAll: any = [];
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "CALL ListConnection('" + sessdata.idaccount + "')";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                if (result.length > 0) {
                                    for (let r of result[0]) {
                                        delete r.idendpoint
                                        resultAll.push(r);
                                    }
                                    let objv = new RawView(res);
                                    objv.prepare({ data: [resultAll], message: "List Connection Fetched!", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: [], message: "No Data Found!", status: 502 });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        // objv.prepare({ status: 404, message: "Not Permitted" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    listConnectionsPanel(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL ListConnection('" + sessdata.idaccount + "')";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "List Connection Fetched!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    UserDefaultConnection(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let ext_field: any;
                let ext_field1: any;
                if (sessdata.type == 1) {
                    ext_field = "e.idaccount,e.iduser,"
                    ext_field1 = "idaccount,iduser,"
                }
                let obj = new ModelRawQuery(req, res);
                if (sessdata.type == 22) {
                    obj.qrysql = "SELECT " + ext_field1 + " idendpoint, connection_key, name FROM `endpoint` WHERE `isDefault`='true' AND `iduser`= '" + sessdata.iduser + "'";
                }
                else {
                    obj.qrysql = "SELECT e.idendpoint, e.connection_key, e.name, " + ext_field + " CONCAT(us.firstname,' ',us.lastname) AS fullname FROM `endpoint`e JOIN `user_profile`us ON us.iduser = e.iduser WHERE `isDefault`='true' AND e.`idaccount`= '" + sessdata.idaccount + "'";
                }
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        let objv = new RawView(res);
                        objv.prepare({ data: result, message: "Single Connection Fetched!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    AllKeyByConnKey(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid1_2_22_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let key = req.query.type;
                        let msg: any = '';

                        switch (true) {
                            case !key:
                                msg = 'Request query not found!';
                                break;
                        }

                        if (msg) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        } else {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT endpoint.idendpoint,endpoint.connection_key, inbound.inbound_key, outbound.outbound_key FROM endpoint JOIN inbound ON endpoint.idendpoint = inbound.idendpoint JOIN outbound ON endpoint.idendpoint = outbound.idendpoint WHERE `connection_key`= '" + key + "'";
                            obj.prepare();
                            obj.execute((_error: any, result: any) => {
                                if (_error == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare({ data: result, message: "Key Fetched!", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Key!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }

                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        // objv.prepare({ message: "Service Unavialable!", status: 503 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    setDefaultConnection(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                validuser.checksessionvalid1_2_22_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        let Idendpoint: any, idaccount: any, iduser: any, message: any = '';
                        switch (true) {
                            case (!sdata || !('data' in sdata)):
                                message = "Missing request body";
                                break;
                            case (sessData.type == 1 && !sdata.data?.idaccount):
                                message = "Idaccount is required for admin";
                                break;
                            case (sessData.type == 1 && !sdata.data?.iduser):
                                message = "iduser is required for admin";
                                break;
                            case (!sdata.data?.idendpoint || !/^[1-9]\d*$/.test(sdata.data.idendpoint)):
                                message = "idendpoint is required/invalid";
                                break;
                            case (sessData.type == 1 && (!/^[1-9]\d*$/.test(sdata.data.idaccount) || !/^[1-9]\d*$/.test(sdata.data.iduser))):
                                message = "idaccount and iduser must be integers";
                                break;
                            default:
                                message = '';
                        }
                        if (message) {
                            let objv = new RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                            return;
                        }
                        if (sessData.type == 1) {
                            idaccount = sdata.data.idaccount;
                            iduser = sdata.data.iduser;
                        } else {
                            idaccount = sessData.idaccount;
                            iduser = sessData.iduser;
                        }
                        Idendpoint = sdata.data.idendpoint
                        let obj = new ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `endpoint` SET `isDefault`='false' WHERE `idaccount`=" + idaccount + "";
                        obj.prepare();
                        obj.execute((_error: any, result: any) => {
                            if (_error == 1) {
                                if (result.affectedRows > 0) {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `endpoint` SET `isDefault`='true' WHERE `idendpoint`=" + Idendpoint + " AND `idaccount`=" + idaccount + "";
                                    obj.prepare();
                                    obj.execute((__error: any, _result: any) => {
                                        if (__error == 1) {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 201, message: "Default Connection Changed Successfully!" });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 502, message: "Something Went Wrong With Connection Updation." });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 404, message: "Record not updated." })
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView(res);
                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection Updation!" });
                                objv.execute();
                            }
                        });
                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    // new endpoint for swagger
    updateconn(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 22) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let rdata: any = {};
                        rdata = req.body;
                        let msg: any = '';

                        switch (true) {
                            case !rdata:
                                msg = 'Request body not found!';
                                break;
                        }

                        if (msg) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        } else {
                            validuser.checkNameValid(rdata.connectionName, '500', 'Connection name', (err2, msg2) => {
                                if (err2 == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare(msg2);
                                    objv.execute();
                                } else {
                                    validuser.checkcharValid(rdata.ConnectionKey, 500, 'ConnectionKey', (err2, msg2) => {
                                        if (err2 == 1) {
                                            let objv = new RawView(res);
                                            objv.prepare(msg2);
                                            objv.execute();
                                        } else {
                                            let obj2 = new ModelRawNonQuery(req, res);
                                            obj2.nonqrysql = "UPDATE `endpoint` SET `name`='" + parseBody(rdata.connectionName) + "' WHERE `connection_key`='" + parseBody(rdata.ConnectionKey) + "'";
                                            obj2.prepare();
                                            obj2.execute((error1: any, result: any) => {
                                                if (error1 == 1) {
                                                    if (result.affectedRows > 0) {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 201, message: "Connection Name Updated Successfully" })
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 404, message: "Record not updated or Connection Key does not match." })
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 501, message: "Something Went Wrong With Connection Name Updation!" })
                                                    objv.execute();
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                        }

                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        // objv.prepare({ status: 404, message: "Not Permitted" });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    setDefaultConn(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessErr: any, sessData: any) => {
            if (sessErr == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.query:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let connkey: any = req.query.Connectionkey;
                    // if (sessData.type == 2 || sessData.type == 22) {
                    // if (sessData.type == 2 || sessData.type == 201 || sessData.type == 202 || sessData.type == 203) {
                    validuser.checksessionvalid2_201_202_203(req, res, sessData, (err, dt) => {
                        if (err == 1) {
                            validuser.checkcharValid(connkey, 500, 'ConnectionKey', (err2, msg2) => {
                                if (err2 == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare(msg2);
                                    objv.execute();
                                }
                                else {
                                    let objj1 = new ModelRawNonQuery(req, res)
                                    objj1.nonqrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `connection_key` = '" + connkey + "'";
                                    objj1.prepare();
                                    objj1.execute((error1: any, result: any) => {
                                        if (error1 == 1) {
                                            if (result.length > 0) {
                                                let obj = new ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `endpoint` SET `isDefault`='false' WHERE `iduser`=" + sessData.iduser + " AND `idaccount`=" + sessData.idaccount + "";
                                                obj.prepare();
                                                obj.execute((error: any, result: any) => {
                                                    if (error == 1) {
                                                        let obj = new ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "UPDATE `endpoint` SET `isDefault`='true' WHERE `connection_key`='" + connkey + "' AND `idaccount`=" + sessData.idaccount + "";
                                                        obj.prepare();
                                                        obj.execute((error1: any, result1: any) => {
                                                            if (error1 == 1) {
                                                                if (result1.affectedRows > 0) {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ status: 200, message: "Default Connection Changed Successfully!" });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare({ status: 404, message: "Record not updated. Connection Key does not match." })
                                                                    objv.execute();
                                                                }
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({ status: 502, message: "Something Went Wrong With Connection" });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({ status: 501, message: "Default Connection Not Changed!" });
                                                        objv.execute();
                                                    }
                                                });
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 505, message: "Kindly enter correct Connection Key!" });
                                                objv.execute();
                                            }
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 501, message: "Something Went Wrong!" });
                                            objv.execute();
                                        }
                                    })
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare(dt);
                            // objv.prepare({ status: 404, message: "Not Permitted" });
                            objv.execute();
                        }
                    });
                }

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }


    deleteConn(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 22) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let msg: any = '';

                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }

                        if (msg) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        } else {
                            let connkey: any = req.query.ConnectionKey;
                            validuser.checkcharValid(connkey, 500, 'ConnectionKey', (err2, msg2) => {
                                if (err2 == 1) {
                                    let objv = new RawView(res);
                                    objv.prepare(msg2);
                                    objv.execute();
                                }
                                else {
                                    let obj = new ModelRawNonQuery(req, res)
                                    obj.nonqrysql = "SELECT `idendpoint`,`isDefault` FROM `endpoint` WHERE `connection_key` = '" + connkey + "'";
                                    obj.prepare();
                                    obj.execute((error1: any, result: any) => {
                                        if (error1 == 1) {
                                            if (result.length > 0) {
                                                if (result[0].isDefault == 'true') {
                                                    let objv = new RawView(res);
                                                    objv.prepare({
                                                        status: 400,
                                                        message: "Existing default connection cannot be deleted!"
                                                    });
                                                    objv.execute();
                                                } else {
                                                    let obj2 = new ModelRawQuery(req, res);
                                                    obj2.qrysql = "SELECT `did` FROM `did_buy` WHERE `connection_key`= '" + connkey + "'";
                                                    obj2.prepare();
                                                    obj2.execute((error2: any, getres: any) => {
                                                        if (error2 == 1) {
                                                            if (getres.length > 0) {
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    status: 400,
                                                                    message: "Existing number need to be reassigned or removed from connection before deleted the connection!"
                                                                });
                                                                objv.execute();
                                                            } else {
                                                                let delConn = new Connection();
                                                                delConn.deleteconnectiondetails(req, res, result[0].idendpoint, (errorr, resp) => {
                                                                    let objv = new RawView(res);
                                                                    objv.prepare(resp);
                                                                    objv.execute();
                                                                });
                                                            }
                                                        } else {
                                                            let objv = new RawView(res);
                                                            objv.prepare({ status: 502, message: "Something Went Wrong with DID!" });
                                                            objv.execute();
                                                        }
                                                    })
                                                }
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 505, message: "Kindly enter correct Connection Key!" });
                                                objv.execute();
                                            }
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 501, message: "Something Went Wrong!" });
                                            objv.execute();
                                        }
                                    });
                                }
                            });
                        }

                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        // objv.prepare({ status: 404, message: "Not Permitted" });
                        objv.execute();
                    }
                })
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }

    deletehookUrls(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 22) {
                // if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.query;
                        let message: any = "";
                        switch (true) {
                            case (!sdata):
                                message = "Request query not found!";
                                break;
                            case (!sdata.ConnectionKey && !sdata.Type):
                                message = "Missing request params ConnectionKey and Type!";
                                break;
                            case (!sdata.ConnectionKey || sdata.ConnectionKey == '' || sdata.ConnectionKey == 'null' || sdata.ConnectionKey == 'undefined'):
                                message = "Connection Key is Required!";
                                break;
                            case (!sdata.Type || sdata.Type == '' || sdata.Type == 'null' || sdata.Type == 'undefined'):
                                message = "Type is Required!";
                                break;
                            case (sdata.Type != 'CDR Url' && sdata.Type != 'SMS Receive' && sdata.Type != 'SMS Status'):
                                message = "Type is invalid";
                                break;
                            case (!sdata.ConnectionKey || !/^[A-Za-z0-9_\-]{30}$/.test(sdata.ConnectionKey)):
                                message = "Connection Key is invalid!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 402, message: message });
                            objv.execute();
                        } else {
                            // if ((sdata.ConnectionKey && sdata.Type)) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `idendpoint` FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "' AND `idaccount`= '" + sessdata.idaccount + "'";
                            obj.prepare();
                            obj.execute((errorChk: any, resLt: any) => {
                                if (errorChk == 1) {
                                    if (resLt.length > 0) {
                                        let type;
                                        switch (sdata.Type) {
                                            case "CDR Url":
                                                type = "cdr";
                                                break;
                                            case "SMS Receive":
                                                type = "sms-received";
                                                break;
                                            case "SMS Status":
                                                type = "sms-status";
                                                break;
                                        }
                                        let obj = new ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "UPDATE hooksetting SET url='' WHERE idendpoint=(SELECT idendpoint FROM `endpoint` where `connection_key`='" + sdata.ConnectionKey + "') AND type='" + type + "'";
                                        obj.prepare();
                                        obj.execute((hook_error: any, hook_result: any) => {
                                            if (hook_error == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 201, message: "Webhook Urls Deleted Successfully" });
                                                objv.execute();
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv2 = new RawView(res)
                                        objv2.prepare({
                                            status: 404,
                                            message: "Connection Key not found!"
                                        })
                                        objv2.execute();
                                    }
                                }
                                else {
                                    let objv2 = new RawView(res)
                                    objv2.prepare({
                                        status: 504,
                                        message: "Something went wrong with connection!"
                                    })
                                    objv2.execute();
                                }
                            });
                        }
                        // else {
                        //     let objv2 = new RawView(res)
                        //     objv2.prepare({
                        //         status: 402,
                        //         message: "All fields are required!"
                        //     })
                        //     objv2.execute();
                        // }
                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        // objv.prepare({ status: 404, message: "Not Permitted" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }


    viewhookUrls(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((sessionError: any, sessionData: any) => {
            if (sessionError === 1) {
                // if (sessionData.type == 2 || sessionData.type == 22 ) {
                //  if (sessionData.type == 2 || sessionData.type == 201 || sessionData.type == 202 || sessionData.type == 203) {
                validuser.checksessionvalid2_201_202_203(req, res, sessionData, (err, dt) => {
                    if (err == 1) {
                        let sdata: any = req.query;
                        let message: any = "";
                        switch (true) {
                            case (!sdata):
                                message = "Request query not found!";
                                break;
                            case (!sdata.ConnectionKey && !sdata.Type):
                                message = "Missing request params ConnectionKey and Type!";
                                break;
                            case (!sdata.ConnectionKey || sdata.ConnectionKey == '' || sdata.ConnectionKey == 'null' || sdata.ConnectionKey == 'undefined'):
                                message = "Connection Key is Required!";
                                break;
                            case (!sdata.Type || sdata.Type == '' || sdata.Type == 'null' || sdata.Type == 'undefined'):
                                message = "Type is Required!";
                                break;
                            case (sdata.Type != 'CDR Url' && sdata.Type != 'SMS Receive' && sdata.Type != 'SMS Status'):
                                message = "Type is invalid";
                                break;
                            case (!sdata.ConnectionKey || !/^[A-Za-z0-9_\-]{30}$/.test(sdata.ConnectionKey)):
                                message = "Connection Key is invalid!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView(res);
                            objv.prepare({ status: 402, message: message });
                            objv.execute();
                        } else {
                            // if (sdata.ConnectionKey && sdata.Type) {
                            let obj = new ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `connection_key`='" +
                                sdata.ConnectionKey + "' AND `idaccount`='" + sessionData.idaccount + "'";
                            obj.prepare();
                            obj.execute((errorChk: any, resLt: any) => {
                                if (errorChk == 1) {
                                    if (resLt.length > 0) {
                                        let type = "";
                                        switch (sdata.Type) {
                                            case "CDR Url":
                                                type = "cdr";
                                                break;
                                            case "SMS Receive":
                                                type = "sms-received";
                                                break;
                                            case "SMS Status":
                                                type = "sms-status";
                                                break;
                                            default:
                                                let objv = new RawView(res);
                                                objv.prepare({ status: 400, message: "Invalid Type!" });
                                                objv.execute();
                                                return;
                                        }

                                        let obj1 = new ModelRawQuery(req, res);
                                        obj1.qrysql = "SELECT h.type, h.url FROM hooksetting h JOIN endpoint e ON h.idendpoint = e.idendpoint WHERE e.connection_key = '" + sdata.ConnectionKey + "' AND h.type = '" + type + "';";
                                        obj1.prepare();
                                        obj1.execute((hookError: any, hookResult: any) => {
                                            if (hookError == 1) {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    status: 200,
                                                    message: "Webhook URLs retrieved successfully.",
                                                    data: hookResult,
                                                });
                                                objv.execute();
                                            } else {
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    status: 502,
                                                    message: "Something went wrong with the connection!",
                                                });
                                                objv.execute();
                                            }
                                        });
                                    } else {
                                        let objv = new RawView(res);
                                        objv.prepare({
                                            status: 404,
                                            message: "Connection Key not found!",
                                        });
                                        objv.execute();
                                    }
                                } else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        status: 504,
                                        message: "Something Went Wrong With Get Idendpoint!",
                                    });
                                    objv.execute();
                                }
                            });
                            // } else {
                            //     let objv = new RawView(res);
                            //     objv.prepare({
                            //         status: 402,
                            //         message: "All fields are required!",
                            //     });
                            //     objv.execute();
                        }
                    } else {
                        let objv = new RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare("No session data found");
                objv.execute();
            }
        });
    }


    getAssociatedDID(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let msg: any = '';

                switch (true) {
                    case !req.query:
                        msg = 'Request query not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj = new ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `did`FROM `did_buy` WHERE `connection_key`= '" + req.query.type + "'";
                    obj.prepare();
                    obj.execute((error: any, result: any) => {
                        if (error == 1) {
                            let objv = new RawView(res);
                            objv.prepare({ data: result, message: "Associated DID Fetched Succesfully!", status: 201 });
                            objv.execute();
                        } else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                            objv.execute();
                        }
                    });
                }


            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    deleteForward(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let rdata: any = {};
                rdata = req.body.data;
                let msg: any = '';

                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }

                if (msg) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                } else {
                    let obj2 = new ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    let conn = (rdata.forward_type != 1 && rdata.forward_type != 2) ? ", `port`='5060'" : ", `port`=NULL";
                    obj2.nonqrysql = "UPDATE `endpoint` SET `forward_type`= NULL ,`forward`='' " + conn + " WHERE `idendpoint`=" + rdata.idendpoint + " AND `idaccount`=" + sessdata.idaccount + " ";
                    obj2.prepare();
                    obj2.execute((_error: any, credentials: any) => {
                        if (_error == 1) {
                            let objv = new RawView(res)
                            objv.prepare({ error: 0, data: credentials, message: "Forwards Deleted Successfully!", status: 201 })
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res)
                            objv.prepare({
                                error: 0, data: credentials, message: "Something Went Wrong With Forwords!", status: 502
                            })
                            objv.execute();
                        }
                    });
                }

            } else {
                let objv = new Res406(res);
                objv.prepare("No session data Available!");
                objv.execute();
            }
        });
    }

}