import { Request, Response, NextFunction } from "express";
import { SessionManagment } from "../lib/model/Session";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { ModelRawQuery } from "../lib/model/RawQuery";
import { Res405 } from "../lib/view/405";
import { RawView } from "../lib/view/RawView";
import { Res406 } from "../lib/view/406";

export class Postback {

    constructor() {

    }

    public postbackMMS(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let msg: any = '';

        switch (true) {
            case !sdata:
                msg = 'Request body not found!';
                break;
        }

        if (msg) {
            let objv = new RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        } else {
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "INSERT INTO `postbackurl` (`from`,`to`,`message_subject`,`origin`,`file`,`timestamp`) VALUES('" + sdata.from + "','" + sdata.to + "','" + sdata.message_subject + "','" + sdata.origin + "','" + sdata.file + "','" + sdata.timestamp + "')";
            obj.prepare();
            obj.execute((_error: any, result: any) => {
                if (_error == 1) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 201, message: "Postback MMS Insert Successfully" });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: "Something went wrong!" });
                    objv.execute();
                }
            });
        }


    }

    public postbackDLR(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let msg: any = '';

        switch (true) {
            case !sdata:
                msg = 'Request body not found!';
                break;
        }

        if (msg) {
            let objv = new RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        } else {
            let obj = new ModelRawNonQuery(req, res);
            obj.nonqrysql = "INSERT INTO `postback_dlr` (`mms_id`,`operator_id`,`status`,`from`,`to`,`timestamp`) VALUES('" + sdata.mms_id + "','" + sdata.operator_id + "','" + sdata.status + "','" + sdata.from + "','" + sdata.to + "','" + sdata.timestamp + "') ";;
            obj.prepare();
            obj.execute((_error: any, result: any) => {
                if (_error == 1) {
                    let objv = new RawView(res);
                    objv.prepare({ status: 201, message: "Postback DLR Insert Successfully" });
                    objv.execute();
                }
                else {
                    let objv = new RawView(res);
                    objv.prepare({ status: 502, message: "Something went wrong!" });
                    objv.execute();
                }
            });
        }

    }
}