import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
import { ModelRawQuery } from "../lib/model/RawQuery";

export class Reports {
    constructor() { }

    /**
     * To get the dashboard reports for (Admin + Customer + Sub-Customer)
     */
    public BasicReports(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query;
        let msg: any = '';

        switch (true) {
            case !sdata:
                msg = 'Request query not found!';
                break;
        }

        if (msg) {
            let objv = new RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        } else {
            let iduserOrIdaccount: any = parseInt(sdata.idaccountuser);
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                if (error == 1) {
                    let cur_day = (new Date().getDate());
                    let cur_month = (new Date().getMonth() + 1);
                    let cur_year = (new Date().getFullYear());

                    let Rcondition: any;

                    let db_table: any;
                    if (sdata.tab == "msg")
                        db_table = 'dashboard_mdr';
                    else
                        db_table = 'dashboard_cdr';

                    let obj = new ModelRawQuery(req, res);
                    if (sdata.type == "usage") {
                        console.log("case 1");
                        if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232) {
                            let user: any;
                            if (iduserOrIdaccount == '0') {
                                user = sessdata.idaccount;
                                Rcondition = "`idaccount`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                            }
                            else {
                                user = iduserOrIdaccount;
                                Rcondition = "`iduser`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"

                            }
                        }
                        else if (sessdata.type == 1) {
                            let user: any;
                            if (iduserOrIdaccount == '0') {
                                user = sessdata.idaccount;
                                Rcondition = "YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"

                            }
                            else {
                                user = iduserOrIdaccount;
                                Rcondition = "`idaccount`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                            }
                        }
                        else {
                            Rcondition = "`iduser`='" + iduserOrIdaccount + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                        }
                        obj.qrysql = "SELECT SUM(CASE WHEN `direction` = 'inbound' THEN `cost` ELSE 0 END) AS `Inbound Usage`,SUM(CASE WHEN `direction` = 'outbound' THEN `cost` ELSE 0 END) AS `Outbound Usage` FROM " + db_table + " WHERE " + Rcondition + "";
                        obj.prepare();
                    }
                    if (sdata.type == "outbound") {
                        console.log("case 2");
                        if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232) {
                            let user: any;
                            if (iduserOrIdaccount == '0') {
                                user = sessdata.idaccount;
                                Rcondition = "`idaccount`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "' AND `direction`='outbound'"
                            }
                            else {
                                user = iduserOrIdaccount;
                                Rcondition = "`iduser`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "' AND `direction`='outbound'"
                            }
                        }
                        else if (sessdata.type == 1) {
                            let user: any;
                            if (iduserOrIdaccount == '0') {
                                user = sessdata.idaccount;
                                Rcondition = "YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "' AND `direction`='outbound'"
                            }
                            else {
                                user = iduserOrIdaccount;
                                Rcondition = "`idaccount`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "' AND `direction`='outbound'"
                            }
                        }
                        else {
                            Rcondition = "`iduser`='" + iduserOrIdaccount + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "' AND `direction`='outbound'"
                        }
                        if (sdata.tab == "voice") {
                            obj.qrysql = "SELECT SUM(`sec10` + `sec20` + `sec30` + `sec60` + `sec120` + `sec180` + `sec300` + `sec600` + `sec900` + `secmax`) `Connected`,SUM(`failure`) `Other Failure`, SUM(`busy`) `Busy`, SUM(`noanswer`) `No-Answer`, SUM(`congestion`) `Conjestion` FROM `dashboard_cdr` WHERE " + Rcondition + " group by date_format(`date`,'%Y-%m')";
                            obj.prepare();
                        }
                        else if (sdata.tab == "msg") {
                            obj.qrysql = "SELECT SUM(`completed`) AS `Completed`, SUM(`failed` ) AS `Failed`, SUM(`rejected`) AS `Rejected` FROM `dashboard_mdr` WHERE " + Rcondition + " group by date_format(`date`,'%Y-%m')";
                            obj.prepare();
                        }
                    }
                    if (sdata.type == "inbound") {
                        console.log("case 3");
                        if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232) {
                            let user: any;
                            if (iduserOrIdaccount == '0') {
                                user = sessdata.idaccount;
                                Rcondition = "`idaccount`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "' AND `direction`='inbound'"
                            } else {
                                user = iduserOrIdaccount;
                                Rcondition = "`iduser`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "' AND  `direction`='inbound'"
                            }
                        }
                        else if (sessdata.type == 1) {
                            let user: any;
                            if (iduserOrIdaccount == '0') {
                                user = sessdata.idaccount;
                                Rcondition = "YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "' AND `direction`='inbound'"

                            } else {
                                user = iduserOrIdaccount;
                                Rcondition = "`idaccount`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                            }
                        }
                        else {
                            Rcondition = "`iduser`='" + iduserOrIdaccount + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                        }
                        if (sdata.tab == "voice") {
                            obj.qrysql = "SELECT SUM(`sec10` + `sec20` + `sec30` + `sec60` + `sec120` + `sec180` + `sec300` + `sec600` + `sec900` + `secmax`)`Connected`, SUM(`failure`)`Other Failure`,SUM(`busy`)`Busy`,SUM(`noanswer`)`No-Answer`,SUM(`congestion`)`Conjestion` FROM `dashboard_cdr` WHERE " + Rcondition + " group by date_format(`date`,'%Y-%m')";
                            obj.prepare();
                        }
                        else if (sdata.tab == "msg") {
                            obj.qrysql = "SELECT SUM(`completed`) AS `Completed`, SUM(`failed` ) AS `Failed`,SUM(`rejected`) AS `Rejected` FROM `dashboard_mdr` WHERE " + Rcondition + " group by date_format(`date`,'%Y-%m')";
                            obj.prepare();
                        }

                    }
                    if (sdata.type == "udaily") {
                        console.log("case 4");
                        if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232) {
                            let user: any;
                            if (iduserOrIdaccount == '0') {
                                user = sessdata.idaccount;
                                Rcondition = "`idaccount`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                            } else {
                                user = iduserOrIdaccount;
                                Rcondition = "`iduser`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                            }
                        }
                        else if (sessdata.type == 1) {
                            let user: any;
                            if (iduserOrIdaccount == '0') {
                                user = sessdata.idaccount;
                                Rcondition = "YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"

                            } else {
                                user = iduserOrIdaccount;
                                Rcondition = "`idaccount`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                            }
                        }
                        else {
                            Rcondition = "`iduser`='" + iduserOrIdaccount + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                        }
                        obj.qrysql = "SELECT DATE_FORMAT(`date`, '%Y-%m-%d')AS `Date`, SUM(CASE WHEN direction = 'inbound' THEN cost ELSE 0 END) AS `Inbound Usage`,SUM(CASE WHEN direction = 'outbound' THEN cost ELSE 0 END) AS `Outbound Usage` FROM " + db_table + " WHERE " + Rcondition + " group by `date` ORDER BY `date` ASC";
                        obj.prepare();
                    }
                    if (sdata.type == "daily") {
                        console.log("case 5");
                        if (sessdata.type == 2 || sessdata.type == 201 || sessdata.type == 202 || sessdata.type == 203 || sessdata.type == 231 || sessdata.type == 232) {
                            let user: any;
                            if (iduserOrIdaccount == '0') {
                                user = sessdata.idaccount;
                                Rcondition = "`idaccount`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                            } else {
                                user = iduserOrIdaccount;
                                Rcondition = "`iduser`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                            }
                        }
                        else if (sessdata.type == 1) {
                            let user: any;
                            if (iduserOrIdaccount == '0') {
                                user = sessdata.idaccount;
                                Rcondition = "YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                            } else {
                                user = iduserOrIdaccount;
                                Rcondition = "`idaccount`='" + user + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                            }
                        }
                        else {
                            Rcondition = "`iduser`='" + iduserOrIdaccount + "' AND YEAR(`date`)='" + cur_year + "' AND `monthnum`='" + cur_month + "'"
                        }
                        if (sdata.tab == "voice") {
                            obj.qrysql = "SELECT DATE_FORMAT(`date`, '%Y-%m-%d')AS `Date`,SUM(CASE WHEN direction = 'inbound' THEN duration ELSE 0 END) AS `Inbound Minutes`,SUM(IF(direction = 'outbound',duration,0)) AS `Outbound Minutes`,SUM(CASE WHEN direction = 'inbound' THEN cost ELSE 0 END) AS `Inbound Usage`,SUM(CASE WHEN direction = 'outbound' THEN cost ELSE 0 END) AS `Outbound Usage` FROM `dashboard_cdr` WHERE " + Rcondition + " GROUP BY `Date` ORDER BY `Date` ASC";
                            obj.prepare();
                        }
                        else if (sdata.tab == "msg") {
                            obj.qrysql = "SELECT DATE_FORMAT(`date`, '%Y-%m-%d') AS `Date`,SUM(CASE WHEN `direction` = 'inbound' THEN `msg_count` ELSE 0 END) AS `Inbound SMS`,SUM(CASE WHEN `direction` = 'outbound' THEN `msg_count` ELSE 0 END) AS `Outbound SMS`,SUM(CASE WHEN `direction` = 'inbound' THEN `cost` ELSE 0 END) AS `Inbound Usage`,SUM(CASE WHEN `direction` = 'outbound' THEN `cost` ELSE 0 END) AS `Outbound Usage` FROM `dashboard_mdr` WHERE " + Rcondition + " GROUP BY `Date` ORDER BY `Date` ASC";
                            obj.prepare();
                        }
                    }
                    if (sdata.type == "hourly") {
                        console.log("case 6");
                        if (sessdata.type == 1 && iduserOrIdaccount == '0') {
                            if (sdata.tab == "msg") {
                                obj.qrysql = "SELECT hour(`timestamp`) `Hour`, MAX(out_sms_1_min) as `Outbound SMS`, MAX(`in_sms_1_min`) as `Inbound SMS`, MAX(`dlr_1_min`) as `DLR` FROM `kannel_stats` WHERE YEAR(`timestamp`)='" + cur_year + "' AND MONTH(`timestamp`)='" + cur_month + "' AND DAY(`timestamp`)='" + cur_day + "' GROUP BY HOUR(`timestamp`)";
                                obj.prepare();
                            }
                        }
                    }
                    obj.execute((err: any, data: any) => {
                        if (err == 1) {
                            res.status(200).json({
                                count: data.length,
                                reports: data,
                                message: "Reports Fetched successfully!"
                            });
                        }
                    });
                }
                else {
                    let objv = new Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            });
        }

    }


    /** @Dashboard report's data **/

    public getChartReportData(req: Request, res: Response, next: NextFunction) {
        console.log("req.body.data::", req.body.data)
        let sdata = JSON.parse(req.body.data)
        let msg: any = '';

        switch (true) {
            case !sdata:
                msg = 'Request body not found!';
                break;
        }

        if (msg) {
            let objv = new RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        } else {
            let session = new SessionManagment(req, res, next);
            session.GetSession((error: any, sessdata: any) => {
                if (error == 1) {
                    let obj = new ModelRawQuery(req, res)
                    let objv = new RawView(res)

                    // Voice Usages Report 

                    if (sdata.rtype == 1) {
                        let iQry: string = "SELECT  SUM(IF(direction='outbound', ((IFNULL(IF(leg_from>0,leg_from,0),0)+IFNULL(IF(leg_to>0,leg_to,0),0)+IFNULL(IF(rec_rate>0,rec_rate,0),0)+IFNULL(IF(amd_rate>0,amd_rate,0),0))*billsec)/60,0)) `obdcost`,SUM(IF(direction='inbound', ((IFNULL(IF(leg_from>0,leg_from,0),0)+IFNULL(IF(leg_to>0,leg_to,0),0)+IFNULL(IF(rec_rate>0,rec_rate,0),0)+IFNULL(IF(amd_rate>0,amd_rate,0),0))*billsec)/60,0)) `ibdcost` FROM cdr WHERE DATE_FORMAT(start_stamp, '%Y-%m')= DATE_FORMAT(NOW(), '%Y-%m')";

                        obj.qrysql = iQry
                        obj.prepare()
                        obj.execute((error: any, result: any) => {
                            console.log("result::", result)
                            if (error == 1) {
                                // let total: any = result.length > 0 ? result[0].total : 0
                                objv.prepare({
                                    error: 0,
                                    message: "Records fetched successfully.",
                                    data: result
                                })
                                objv.execute()
                            } else {
                                objv.prepare({
                                    error: 1,
                                    message: "Something went wrong!"
                                })
                                objv.execute()
                            }
                        })
                    }

                    // Voice Inbound Report 

                    else if (sdata.rtype == 2) {
                        let iQry: string = "SELECT COUNT(*) calls, IFNULL(SUM(IF(hangup_cause_q850=41 || hangup_cause_q850=63 || hangup_cause_q850=44 || hangup_cause_q850=34,1,0)),0) `conjestion`,IFNULL(SUM(IF(hangup_cause_q850=17,1,0)),0) `busy`, IFNULL(SUM(IF(hangup_cause_q850=19,1,0)),0) `noanswer`, IFNULL(SUM(IF(hangup_cause_q850=57 || hangup_cause_q850=54 || hangup_cause_q850=52,1,0)),0) `failure` FROM cdr  WHERE DATE_FORMAT(start_stamp, '%Y-%m')= DATE_FORMAT(NOW(), '%Y-%m') AND direction='inbound'";

                        obj.qrysql = iQry
                        obj.prepare()
                        obj.execute((error: any, result: any) => {
                            console.log("result::", result)
                            if (error == 1) {
                                // let total: any = result.length > 0 ? result[0].total : 0
                                objv.prepare({
                                    error: 0,
                                    message: "Records fetched successfully.",
                                    data: result
                                })
                                objv.execute()
                            } else {
                                objv.prepare({
                                    error: 1,
                                    message: "Something went wrong!"
                                })
                                objv.execute()
                            }
                        })
                    }

                    // Voice Outbound Report 

                    else if (sdata.rtype == 3) {
                        let iQry: string = "SELECT COUNT(*) calls, IFNULL(SUM(IF(hangup_cause_q850=41 || hangup_cause_q850=63 || hangup_cause_q850=44 || hangup_cause_q850=34,1,0)),0) `conjestion`,IFNULL(SUM(IF(hangup_cause_q850=17,1,0)),0) `busy`, IFNULL(SUM(IF(hangup_cause_q850=19,1,0)),0) `noanswer`, IFNULL(SUM(IF(hangup_cause_q850=57 || hangup_cause_q850=54 || hangup_cause_q850=52,1,0)),0) `failure` FROM cdr  WHERE DATE_FORMAT(start_stamp, '%Y-%m')= DATE_FORMAT(NOW(), '%Y-%m') AND direction='outbound'";

                        obj.qrysql = iQry
                        obj.prepare()
                        obj.execute((error: any, result: any) => {
                            console.log("result::", result)
                            if (error == 1) {
                                // let total: any = result.length > 0 ? result[0].total : 0
                                objv.prepare({
                                    error: 0,
                                    message: "Records fetched successfully.",
                                    data: result
                                })
                                objv.execute()
                            } else {
                                objv.prepare({
                                    error: 1,
                                    message: "Something went wrong!"
                                })
                                objv.execute()
                            }
                        })
                    }

                    // Voice Received Failed Report

                    else if (sdata.rtype == 4) {
                        // Inbound Cost
                        let iQry: string = "SELECT  DATE_FORMAT(start_stamp, '%Y-%m-%d') `date`, SUM(IF(direction='inbound', ((IFNULL(IF(leg_from>0,leg_from,0),0)+IFNULL(IF(leg_to>0,leg_to,0),0)+IFNULL(IF(rec_rate>0,rec_rate,0),0)+IFNULL(IF(amd_rate>0,amd_rate,0),0))*billsec)/60,0))*1000 `ibdcost` FROM cdr WHERE DATE_FORMAT(start_stamp, '%Y-%m')= DATE_FORMAT(NOW(), '%Y-%m') GROUP BY DATE_FORMAT(start_stamp, '%Y-%m-%d')"
                        obj.qrysql = iQry
                        obj.prepare()
                        obj.execute((error: any, result1: any) => {
                            console.log("result::", result1)
                            if (error == 1) {
                                if (result1.length > 0) {
                                    // Outbond Cost
                                    let iQry1: string;
                                    let obj1 = new ModelRawQuery(req, res)
                                    iQry1 = "SELECT  DATE_FORMAT(start_stamp, '%Y-%m-%d') `date`, SUM(IF(direction='outbound', ((IFNULL(IF(leg_from>0,leg_from,0),0)+IFNULL(IF(leg_to>0,leg_to,0),0)+IFNULL(IF(rec_rate>0,rec_rate,0),0)+IFNULL(IF(amd_rate>0,amd_rate,0),0))*billsec)/60,0))*1000 `obdcost` FROM cdr WHERE DATE_FORMAT(start_stamp, '%Y-%m')= DATE_FORMAT(NOW(), '%Y-%m') GROUP BY DATE_FORMAT(start_stamp, '%Y-%m-%d')"
                                    obj1.qrysql = iQry1
                                    obj1.prepare()
                                    obj1.execute((error: any, result2: any) => {
                                        if (error == 1) {
                                            console.log(result1, result2)
                                            let Received: any = []
                                            let Failed: any = []
                                            // let gD: any = {}

                                            if (result1.length > 0) {
                                                result1.forEach((ele: any) => {
                                                    Received[ele.date] = (Received[ele.date] && Received[ele.ibdcost])
                                                    console.log(Received, "res1");
                                                    // gD[ele.date] = 0
                                                })
                                            }
                                            if (result2.length > 0) {
                                                result2.forEach((ele: any) => {
                                                    Failed[ele.date] = (Failed[ele.date] && Failed[ele.obdcost])
                                                    // gD[ele.date] = 0
                                                    console.log(Failed, "res2");
                                                })
                                            }

                                            console.log("Received Failed::", Failed, Received)

                                            objv.prepare({
                                                error: 0,
                                                message: "Records fetched successfully.",
                                                data: {
                                                    Received: Received,
                                                    Failed: Failed

                                                }
                                            })
                                            objv.execute()
                                        } else {
                                            objv.prepare({
                                                error: 1,
                                                message: "Something went wrong!"
                                            })
                                            objv.execute()
                                        }
                                    })
                                } else {
                                    objv.prepare({
                                        error: 0,
                                        message: "Records fetched successfully.",
                                        data: []
                                    })
                                    objv.execute()
                                }
                            }
                        })
                    }

                    // Daily Usage

                    else if (sdata.rtype == 6) {
                        // Inbound Cost
                        let iQry: string = "SELECT  DATE_FORMAT(start_stamp, '%Y-%m-%d') `date`, SUM(IF(direction='inbound', ((IFNULL(IF(leg_from>0,leg_from,0),0)+IFNULL(IF(leg_to>0,leg_to,0),0)+IFNULL(IF(rec_rate>0,rec_rate,0),0)+IFNULL(IF(amd_rate>0,amd_rate,0),0))*billsec)/60,0)) `ibdcost` FROM cdr WHERE DATE_FORMAT(start_stamp, '%Y-%m')= DATE_FORMAT(NOW(), '%Y-%m') GROUP BY DATE_FORMAT(start_stamp, '%Y-%m-%d')"
                        obj.qrysql = iQry
                        obj.prepare()
                        obj.execute((error: any, result: any) => {
                            console.log("result::", result)
                            if (error == 1) {
                                if (result.length > 0) {
                                    let Result1: any = result
                                    // Outbond Cost
                                    let iQry1: string;
                                    let obj1 = new ModelRawQuery(req, res)
                                    iQry1 = "SELECT  DATE_FORMAT(start_stamp, '%Y-%m-%d') `date`, SUM(IF(direction='outbound', ((IFNULL(IF(leg_from>0,leg_from,0),0)+IFNULL(IF(leg_to>0,leg_to,0),0)+IFNULL(IF(rec_rate>0,rec_rate,0),0)+IFNULL(IF(amd_rate>0,amd_rate,0),0))*billsec)/60,0)) `obdcost` FROM cdr WHERE DATE_FORMAT(start_stamp, '%Y-%m')= DATE_FORMAT(NOW(), '%Y-%m') GROUP BY DATE_FORMAT(start_stamp, '%Y-%m-%d')"
                                    obj1.qrysql = iQry1
                                    obj1.prepare()
                                    obj1.execute((error: any, result: any) => {
                                        if (error == 1) {
                                            let Result2: any = result

                                            let Received: any = {}
                                            let Failed: any = {}
                                            // let gD: any = {}

                                            if (Result1.length > 0) {
                                                Result1.forEach((ele: any) => {
                                                    Received[ele.date] = (Received[ele.date] || 0) + 1
                                                    // gD[ele.date] = 0
                                                })
                                            }
                                            if (Result2.length > 0) {
                                                Result2.forEach((ele: any) => {
                                                    Failed[ele.date] = (Failed[ele.date] || 0) + 1
                                                    // gD[ele.date] = 0
                                                })
                                            }

                                            console.log("Received Failed6::", Failed, Received)

                                            objv.prepare({
                                                error: 0,
                                                message: "Records fetched successfully.",
                                                data: {
                                                    Received: Received,
                                                    Failed: Failed

                                                }
                                            })
                                            objv.execute()
                                        } else {
                                            objv.prepare({
                                                error: 1,
                                                message: "Something went wrong!"
                                            })
                                            objv.execute()
                                        }
                                    })
                                } else {
                                    objv.prepare({
                                        error: 0,
                                        message: "Records fetched successfully.",
                                        data: []
                                    })
                                    objv.execute()
                                }
                            }
                        })
                    }

                    else {
                        objv.prepare({
                            error: 1,
                            message: "Something went wrong!"
                        })
                        objv.execute()
                    }

                }
                else {
                    let objv = new Res406(res);
                    objv.prepare(session);
                    objv.execute();
                }
            });
        }


    }

}