"use strict";
const multer1 = require('multer');
import { UploadDirectory } from '../config/setting.config';

const MIME_TYPE_MAP1: any = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'image/gif': 'gif',
    'image/webp': 'webp',
    'text/csv': 'csv',
    'application/pdf': 'pdf',
    'text/plain': 'txt',
    'audio/mpeg': 'mp3',
    'audio/wav': 'wav',
    'audio/webm': 'weba',
    'video/mp4': 'mp4',
    'application/vnd.ms-excel': 'xls',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'xlsx',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx'
};

const storage1 = multer1.diskStorage({
    destination: (req: any, file: any, cb: any) => {
        let mmsdir = new UploadDirectory();
        const isValid = MIME_TYPE_MAP1[file.mimetype];
        let error: any = "";
        if (!isValid) {
            error = new Error("Invalid file type");
        }
        cb(error, mmsdir.FEDERALFILEUPLOAD);
    },
    filename: (req: any, file: any, cb: any) => {
        let file_path = file.originalname;
        let extension = file_path.split('.').pop();
        let randomName: any = Math.random().toString(36).substring(2, 12);
        const filenm = file.originalname;
        const flName = Date.now() + '-' + filenm.replace(filenm, randomName);
        const fileName = flName + '.' + extension;
        const ext = MIME_TYPE_MAP1[file.mimetype];
        cb(null, fileName);
    }
});


module.exports = multer1({ storage: storage1 }).single('UPLOAD');
