import { Request, Response, NextFunction } from "express";
import { RawView } from "../lib/view/RawView";
import { ModelRawNonQuery } from "../lib/model/RawNonQuery";
import { SessionManagment } from "../lib/model/Session";
import { Res406 } from "../lib/view/406";
// import { AppRoute } from "../lib/AppRoute";
import { parseBody, setToZero } from "./markError";

export class Users {
    constructor() {
        // super();
    }

    public AddCustomer(req: Request, res: Response, next: NextFunction) {
        console.log(req.body.data);
        let sdata: any;
        try {
            sdata = JSON.parse(req.body.data);
        } catch (e) {
            console.log("Error :: AddCustomer::",e);                                                               
            sdata = req.body.data;
        }
        let session = new SessionManagment(req, res, next);
        let msg = "";
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                if (sdata.iduser == -1) {
                    obj.nonqrysql = "CALL AddCustomer(-1, " + sessdata.id + ", 1, '" + parseBody(sdata.username) + "','" + sdata.password + "','" + sdata.email + "','','" + sdata.contact + "','" + sdata.fullname + "','','','Male',0,0,0,0,'')";
                    msg = "Customer Account is added successfully";
                }
                else {
                    obj.nonqrysql = "CALL AddCustomer('" + sdata.iduser + "', " + sessdata.id + ", 1, '','','" + sdata.email + "','" + parseBody(sdata.company) + "','" + sdata.contact + "','" + parseBody(sdata.fullname) + "','" + parseBody(sdata.address) + "','" + parseBody(sdata.city) + "','" + sdata.gender + "','" + sdata.billingrate + "','" + sdata.maxprice + "','" + sdata.maxagent + "','" + setToZero(sdata.creditlimit) + "', '" + sdata.servers + "')";
                    msg = "Customer Account is updated successfully";

                }
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    //console.log(result);
                    let objv = new RawView(res);
                    objv.prepare({ data: result[0], message: msg });
                    objv.execute();
                });

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public AddSupplier(req: Request, res: Response, next: NextFunction) {
        console.log(req.body.data);
        let sdata: any;
        try {
            sdata = JSON.parse(req.body.data);
        } catch (e) {
            console.log("Error :: AddSupplier::",e);                                                               
            sdata = req.body.data;
        }
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                if (sdata.id == -1)
                    obj.nonqrysql = "CALL AddSupplier('-1', '" + sdata.name + "','" + sdata.ipaddress + "','" + sdata.prefix + "','" + sdata.rates + "', '')";
                else
                    obj.nonqrysql = "CALL  UpdateProviders('" + sdata.id + "', '" + sdata.name + "','" + sdata.ip + "','" + sdata.prefix + "','" + sdata.rate + "', '" + sdata.servers + "')";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    //console.log(result);
                    let objv = new RawView(res);
                    objv.prepare({ data: result, message: "Supplier is added successfully" });
                    objv.execute();
                });

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

 /*   public getServer(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.query.filter;
        let session = new SessionManagment(req, res, next);
        try {
            sdata = JSON.parse(sdata);
        }
        catch (err: any) {
            console.log("Error :: getServer::",err);                                                               
        }
        console.log(sdata);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL getUserServer('" + sdata.id + "')";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: result[0], message: "Get server details successfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    } */

    public DeleteSupplier(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                console.log(req.query);
                var sdata = req.query;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL DeleteSupplier(" + sdata.id + ")";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: result, message: "Delete data successfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public DeleteCustomer(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                console.log(req.query);
                var sdata = req.query;
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL DeleteUser(" + sessdata.id + ", " + sdata.id + ")";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    let objv = new RawView(res);
                    objv.prepare({ data: result, message: "Delete data successfully" });
                    objv.execute();
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public Recharge(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                console.log(req.body.data);
                let sdata: any;
                try {
                    sdata = JSON.parse(req.body.data);
                } catch (e) {
                    console.log("Error :: Recharge::",e);                                                               
                    sdata = req.body.data;
                }
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL AddBalance(" + sessdata.id + ", " + sdata.userid + ", '" + sdata.amount + "','" + sdata.description + "')";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    console.log(result);
                    let objv = new RawView(res);
                    objv.prepare({ data: result[0], message: "Account is recharged successfully" });
                    objv.execute();
                });

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }

    public ManageServer(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                console.log(req.body.data);
                let sdata: any;
                try {
                    sdata = JSON.parse(req.body.data);
                } catch (e) {
                    console.log("Error :: ManageServer::",e);                                                               
                    sdata = req.body.data;
                }
                let obj = new ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL ManageServer(" + sdata.id + ", '" + sdata.detail + "')";
                obj.prepare();
                obj.execute((error: any, result: any) => {
                    console.log(result);
                    let objv = new RawView(res);
                    objv.prepare(res);
                    objv.execute();
                });

            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}