"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const avro = require("avsc");
const addgroupSchema = {
    type: "record",
    name: "Group",
    fields: [
        { name: "idgroup", type: "int" },
        { name: "GroupName", type: "string" },
        { name: "Strategy", type: { type: "array", items: "string" } },
        { name: "TierRulesApply", type: "boolean" },
        { name: "Description", type: "string" },
    ],
};
const addAgentSchema = {
    type: "record",
    name: "Agent",
    fields: [
        { name: "IdAgent", type: "int" },
        { name: "FullName", type: "string" },
        { name: "UserName", type: "string" },
        { name: "CallerId", type: { type: "array", items: "string" } },
        { name: "Password", type: "string" },
        { name: "Group", type: "string" },
        { name: "VmPin", type: "int" },
    ],
};
const schemas = {
    addgroup: avro.Type.forSchema(addgroupSchema),
    addagent: avro.Type.forSchema(addAgentSchema),
};
exports.default = schemas;
