"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPostalCode = exports.isValidUrl = exports.isAlphanumeric = exports.checkFromDid = exports.checkCustomerId = exports.checkBrandId = exports.checkCampaignId = exports.checkConnectionKey = exports.checkToDid = exports.isMissing = exports.checkGroupKey = exports.checkDid = exports.checkvalue = exports.checkUserPayload = exports.setEnum = exports.setToZero = exports.parseBody = exports.ipAddressAndBrowser = exports.isNumber = void 0;
const Str = require('@supercharge/strings').Str;
const jwt = require('jsonwebtoken');
const { networkInterfaces } = require('os');
const prgmch = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+/;
const checkvalue = (val) => {
    if (typeof val !== 'string')
        return true; // invalid if not string
    return !prgmch.test(val); // true if it doesn't pass regex (invalid)
};
exports.checkvalue = checkvalue;
const checkDid = (did) => {
    if (typeof did !== 'string')
        return "DID is invalid"; // invalid if not string
    if (!/^[1-9]\d*$/.test(did))
        return "DID must be digits with 10 digits integer"; // must be digits
    if (did.length != 10)
        return "DID must be digits with 10 digits"; // must be exactly 10 digits
    return ''; // valid
};
exports.checkDid = checkDid;
const checkGroupKey = (value) => {
    if (typeof value !== 'string') {
        return "Group key must be a string";
    }
    if (!/^(?!.*[-_].*[-_])(?=.*[-_])?[A-Za-z0-9_-]{10}$/.test(value)) {
        return "Group key is invalid/must be 10 letter of string";
    }
    return '';
};
exports.checkGroupKey = checkGroupKey;
const checkConnectionKey = (value) => {
    if (typeof value !== "string" || !/^[A-Za-z0-9_-]{30}$/.test(value)) {
        return "Connection key is invalid";
    }
    return "";
};
exports.checkConnectionKey = checkConnectionKey;
const checkCampaignId = (value) => {
    if (typeof value !== "string" || !/^C[A-Z0-9]{6}$/.test(value)) {
        return "CampaignId must be exactly 7 characters long and start with 'C'!";
    }
    return "";
};
exports.checkCampaignId = checkCampaignId;
const checkBrandId = (value) => {
    if (typeof value !== "string" || !/^B[A-Z0-9]{6}$/.test(value)) {
        return "brandId Must be upper-case alphanumeric characters with prefix letter 'B'!";
    }
    return "";
};
exports.checkBrandId = checkBrandId;
const checkCustomerId = (value) => {
    if (typeof value !== "string" || !/^cus_[A-Za-z0-9]{14}$/.test(value)) {
        return "Must start with 'cus_' followed by 14 alphanumeric characters (letters and digits)";
    }
    return "";
};
exports.checkCustomerId = checkCustomerId;
const wordpattern = /^[A-Za-z0-9]+(?: [A-Za-z0-9]+)*$/;
const isAlphanumeric = (val) => {
    if (typeof val !== "string")
        return false; // invalid if not string
    return wordpattern.test(val); // true if invalid
};
exports.isAlphanumeric = isAlphanumeric;
const isMissing = (val) => {
    return (!val || val == undefined ||
        val == null ||
        val == "undefined" ||
        val == "null" ||
        (typeof val === "string" && val.trim() === ""));
};
exports.isMissing = isMissing;
const isValidUrl = (value) => {
    const urlPattern = /^(https?:\/\/)?(([a-zA-Z0-9\-]+\.)+[a-zA-Z]{2,}|localhost|(\d{1,3}\.){3}\d{1,3})(:\d+)?(\/[^\s]*)?$/;
    return urlPattern.test(value.trim());
};
exports.isValidUrl = isValidUrl;
const universalZip = /^[A-Za-z0-9](?:[A-Za-z0-9 \-]{0,8}[A-Za-z0-9])?$/;
const isPostalCode = (value) => {
    if (typeof value !== "string")
        return true;
    return !universalZip.test(value.trim());
};
exports.isPostalCode = isPostalCode;
const checkToDid = (field, value) => {
    if (typeof value !== 'string')
        return `${field} is invalid`; // invalid if not string
    if (!/^[1-9]\d*$/.test(value))
        return `${field} must be digits with 10 digits integer`; // must be digits
    if (value.length != 10)
        return `${field} must be digits with 10 digits`; // must be exactly 10 digits
    return ''; // valid
};
exports.checkToDid = checkToDid;
const checkFromDid = (field, value) => {
    if (typeof value !== "string")
        return `${field} number is invalid`; // must be string
    if (!/^[1-9]\d*$/.test(value))
        return `${field} number must contain digits integer`; // must be digits
    if (value.length < 5 || value.length > 10)
        return `${field} number must be Valid`;
    return ""; // valid
};
exports.checkFromDid = checkFromDid;
const checkUserPayload = (sdata) => {
    let result = null;
    if (sdata?.iduser || sdata?.idaccount) {
        result = {
            iduser: sdata.iduser,
            idaccount: sdata.idaccount
        };
    }
    return result;
};
exports.checkUserPayload = checkUserPayload;
const parseBody = (desc) => {
    let result = '';
    if (typeof desc === 'string') {
        result = desc.trim()
            .replace(/\\/g, '\\\\')
            .replace(/"/g, '\\"')
            .replace(/'/g, "\\'");
    }
    return result;
};
exports.parseBody = parseBody;
const setToZero = (data) => {
    let description = data ?? '';
    let dest = Number(description);
    if (dest == '') {
        return 0;
    }
    else {
        return data;
    }
};
exports.setToZero = setToZero;
const setEnum = (data) => {
    if (data === null || data === undefined || data === '') {
        return false;
    }
    return data;
};
exports.setEnum = setEnum;
const isNumber = (num) => {
    let result = '';
    let number = num ? num : 0;
    if (isNaN(number) == false && typeof parseInt(number) == "number") {
        result = number;
        console.log("result :: ", result);
        return result;
    }
    else {
        result = 'NaN';
        console.log("result :: ", result);
        return result;
    }
};
exports.isNumber = isNumber;
const ipAddressAndBrowser = (req) => {
    /* login history Create  Token */
    let secret = Str.random(15);
    let Token = jwt.sign({
        exp: Math.floor(Date.now() / 1000),
    }, secret);
    //To Get ipaddress
    const nets = networkInterfaces();
    const ipAddress = [];
    for (const name of Object.keys(nets)) {
        for (const net of nets[name]) {
            const familyV4Value = typeof net.family === 'string' ? 'IPv4' : 4;
            if (net.family === familyV4Value && !net.internal) {
                ipAddress.push(net.address);
            }
        }
    }
    /*To Get Browser Name */
    const userAgentString = req.headers['user-agent'];
    const userAgent = userAgentString;
    let browserName = 'unknown';
    if (userAgent?.includes('Safari')) {
        browserName = 'Safari';
    }
    if (userAgent?.includes('Chrome')) {
        browserName = 'Google Chrome';
    }
    if (userAgent?.includes('Edg')) {
        browserName = 'Microsoft Edge';
    }
    if (userAgent?.includes('OPR')) {
        browserName = 'Opera';
    }
    if (userAgent?.includes('msie')) {
        browserName = 'Internet Explorer';
    }
    if (userAgent?.includes('Firefox')) {
        browserName = 'Firefox';
    }
    let sysInfo = {
        ipAddress: [req.headers['x-forwarded-for'] || req.socket.remoteAddress],
        browserName: browserName, uniqueToken: Token
    };
    return sysInfo;
};
exports.ipAddressAndBrowser = ipAddressAndBrowser;
//export default checkDesc
exports.default = parseBody;
