"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InfobipSMS = void 0;
const APISMSBase_1 = require("./APISMSBase");
const RawView_1 = require("../lib/view/RawView");
const Inteliquent_1 = require("./Inteliquent");
const InfobipAPI_1 = require("./InfobipAPI");
class InfobipSMS extends APISMSBase_1.SMS {
    constructor() {
        super();
    }
    SendSms(req, res, next, Data, DIDData, callback) {
        this.saveSMS(req, res, next, Data.sessdata, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }
    SendMms(req, res, next, Data, sms_provider, callback) {
        this.saveMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        });
    }
    // Not in Use. it may be changed as per requirement
    SendTFSms(req, res, next, sessdata, DIDData, callback) {
        let intel = new Inteliquent_1.InteliquentAPI("", sessdata, '');
        intel.sendTFSMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: resp.status, message: resp.message, batch_id: resp.batch_id });
            objv.execute();
        });
    }
    SendTFMms(req, res, next, sessdata, DIDData, callback) {
        let intel = new Inteliquent_1.InteliquentAPI("", sessdata, '');
        intel.sendTFMMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView_1.RawView(res);
            objv.prepare(resp);
            objv.execute();
        });
    }
    SendSynivMms(req, res, next, Data, sms_provider, callback) {
        this.saveSynivMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        });
    }
    SendSCSms(req, res, next, Data, DIDData, callback) {
        let info = new InfobipAPI_1.InfobipAPI("", Data.sessdata, "");
        info.saveSCSMS(req, res, Data, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }
    SendSCMms(req, res, next, Data, DIDData, callback) {
        let info = new InfobipAPI_1.InfobipAPI("", Data.sessdata, "");
        info.saveSCMMS(req, res, Data, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }
}
exports.InfobipSMS = InfobipSMS;
