"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeleSMS = void 0;
const APISMSBase_1 = require("./APISMSBase");
const RawView_1 = require("../lib/view/RawView");
const Session_1 = require("../lib/model/Session");
const numberApi_1 = require("./numberApi");
const _406_1 = require("../lib/view/406");
const lrnApi_1 = require("./lrnApi");
const APIBase_1 = require("./APIBase");
const Inteliquent_1 = require("./Inteliquent");
const InteliquentSMS_1 = require("./InteliquentSMS");
class TeleSMS extends APISMSBase_1.SMS {
    constructor() {
        super();
        this.key = "48de6c84-7726-4879-bc08-f7a5dcf63f1c";
        this.account = "";
    }
    SendSms(req, res, next, Data, DIDData, callback) {
        this.saveSMS(req, res, next, Data, DIDData, (sms_err, sms_result) => {
            if (sms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(sms_err);
                objv.execute();
            }
        });
    }
    // Not in Use. it may be changed as per requirement
    SendTFSms(req, res, next, sessdata, DIDData, callback) {
        let intel = new Inteliquent_1.InteliquentAPI("", sessdata, '');
        intel.sendTFSMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: resp.status, message: resp.message, batch_id: resp.batch_id });
            objv.execute();
        });
    }
    SendTFMms(req, res, next, sessdata, DIDData, callback) {
        let intel = new Inteliquent_1.InteliquentAPI("", sessdata, '');
        intel.sendTFMMS(req, res, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView_1.RawView(res);
            objv.prepare(resp);
            objv.execute();
        });
    }
    SendSynivMms(req, res, next, Data, sms_provider, callback) {
        this.saveSynivMMS(req, res, next, Data, sms_provider, (mms_err, mms_result) => {
            if (mms_result != undefined) {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_result);
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare(mms_err);
                objv.execute();
            }
        });
    }
    SendSCSms(req, res, next, sessdata, DIDData, callback) {
        let intel = new InteliquentSMS_1.InteliquentSMS();
        intel.SendSCSms(req, res, next, sessdata, DIDData, (errorr, resp) => {
            let objv = new RawView_1.RawView(res);
            objv.prepare(resp);
            objv.execute();
        });
    }
    SendMms(req, res, next, token, sms_provider, callback) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let number = new numberApi_1.Number();
                number.verifyDid(req, res, (error, responce) => {
                    if (responce == -1) {
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ message: "Invalid DID" });
                        obj.execute();
                    }
                    else {
                        let PayLoad = {
                            TO: TO
                        };
                        let lerg = new lrnApi_1.LergApi("", "");
                        lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                            let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                            let baseapi = new APIBase_1.APIBase();
                            baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                                if (lerg_info.length > 0) {
                                    let Data = {
                                        sessdata: sessdata,
                                        lerg_info: lerg_info
                                    };
                                    this.saveSMS(req, res, next, Data, sms_provider, (sms_err, sms_result) => {
                                        if (sms_result != undefined) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare(sms_result);
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare(sms_err);
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Lerg Info Not Found" });
                                    objv.execute();
                                }
                            });
                        });
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    SendSCMms(req, res, next, Data, DIDData, callback) {
        let sdata = req.body;
        let TO = "" + sdata.TO + "";
        let didData = Data.DIDdata;
        let fType = Data.fileType;
        let file = Data.file;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let PayLoad = {
                    TO: TO
                };
                let lerg = new lrnApi_1.LergApi("", "");
                lerg.lrnDetailsM1(req, res, PayLoad, (lrn_err, lrn_detail) => {
                    let ToNumber = lrn_detail.lrn ? lrn_detail.lrn : PayLoad.TO;
                    let baseapi = new APIBase_1.APIBase();
                    baseapi.getLrnDetails(req, res, ToNumber, (lerg_err, lerg_info) => {
                        if (lerg_info.length > 0) {
                            this.saveSCMMS(req, res, next, sessdata, lerg_info, DIDData, didData, fType, file, (sms_err, sms_result) => {
                                if (sms_result != undefined) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare(sms_result);
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare(sms_err);
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Lerg Info Not Found" });
                            objv.execute();
                        }
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
}
exports.TeleSMS = TeleSMS;
