"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BlitzAPI = void 0;
const APIBase_1 = require("./APIBase");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const markError_1 = __importStar(require("./markError"));
const axios_1 = require("./axios");
let insertdid = new APIBase_1.APIBase();
class BlitzAPI extends APIBase_1.APIBase {
    key;
    secret;
    priority;
    sessdata;
    timekey;
    constructor(proirity, sessdata, timekey) {
        super();
        this.key = "cGFua2FqQGd2ZW50dXJlLm5ldDpjYWRiZjViYTM4ODA2YjcxMjU1ZWE3YTRlNGM3MzQ1NzU3ODU5NTA5";
        this.timekey = timekey;
        this.secret = "";
        this.priority = proirity;
        this.sessdata = sessdata;
    }
    getNpaNxx(req, res, pLoad, callback) {
        if (this.priority == "100") {
            console.log("Exit from Blitz");
            callback('', '');
        }
        else {
            let baseapi = new APIBase_1.APIBase();
            baseapi.login(req, res, (token_err, token_resp) => {
                if (token_resp) {
                    const sdata = req.query;
                    console.log("sdata", sdata);
                    var url;
                    if (sdata.NPA != undefined) {
                        url = "https://apicontrol.call48.com/api/v4/search?type=local&npa=" + sdata.NPA + "&limit=" + sdata.Qty;
                    }
                    if (sdata.NPA != undefined && sdata.NXX != undefined) {
                        url = "https://apicontrol.call48.com/api/v4/search?type=local&npa=" + sdata.NPA + "&nxx=" + sdata.NPA + "&limit=" + sdata.Qty;
                    }
                    let options = {
                        'method': 'GET',
                        'url': url,
                        'headers': {
                            'Authorization': token_resp
                        },
                    };
                    (0, axios_1.request)(options, (error, response) => {
                        if (!error) {
                            try {
                                let data = JSON.parse(response.body);
                                console.log("Reponcnce==>", data);
                                if (data.code == 200) {
                                    if (data.data.result.length > 0) {
                                        let str = data.data.result;
                                        let path = this.sessdata.path ? this.sessdata.path : 'false';
                                        let hsmpData = [];
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        let qrystr = "INSERT INTO `did_search` (`idaccount`,`phone_number`, `rate_center`, `state`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE";
                                        str.forEach((ele) => {
                                            let hmp = {
                                                phone_number: ele.number,
                                                rate_center: (0, markError_1.default)(ele.ratecenter),
                                                state: (0, markError_1.default)(ele.state),
                                                supplier_tier: (0, markError_1.default)(ele.tier)
                                            };
                                            hsmpData.push(hmp);
                                            qrystr += "('" + this.sessdata.idaccount + "','" + ele.number + "', '" + ele.ratecenter + "', '" + ele.state + "', '" + "blitz" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.tier + "','nrc:" + ele.setup_rate + ",mrc:" + ele.monthly_rate + ",usage:" + ele.per_minute_rate + "','" + pLoad.rate + "','" + sdata.CampaignId + "','" + path + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + this.timekey + "'),";
                                        });
                                        this.saveHmp(this.timekey, 'blitz', hsmpData);
                                        obj1.nonqrysql = qrystr.slice(0, -1);
                                        obj1.prepare();
                                        obj1.execute((err, data) => {
                                            callback(err, data);
                                        });
                                    }
                                    else {
                                        let obj = new RawView_1.RawView(res);
                                        obj.prepare({ message: "No DID's found on [" + sdata.NPA + "]" });
                                        obj.execute();
                                    }
                                }
                                else {
                                    callback('', data);
                                }
                            }
                            catch (e) {
                                console.log("Error :: blitz->getNpaNxx::", e);
                                callback(error, '');
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    });
                }
                else {
                    callback(token_err, '');
                }
            });
        }
    }
    getByRate(req, res, pLoad, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            var sdata = req.query;
            let options = {
                'method': 'GET',
                'url': "https://api.thinq.com/inbound/get-numbers?searchType=domestic&searchBy=ratecenter&quantity=" + sdata.Qty + "&contiguous=false&state=" + sdata.State + "&rateCenter=" + sdata.RateCenter + "",
                'headers': {
                    'Authorization': 'Basic ' + this.key
                },
            };
            console.log("Options", options);
            (0, axios_1.request)(options, (error, response) => {
                if (!error) {
                    try {
                        let data = JSON.parse(response.body);
                        console.log("data==>", data);
                        if (data.dids != undefined && data.dids.length > 0) {
                            let str = data.dids;
                            let path = this.sessdata.path ? this.sessdata.path : 'false';
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            let found = false;
                            let hsmpData = [];
                            let qrystr = "INSERT INTO `did_search` (`idaccount`,`friendly_name`, `phone_number`, `locality`, `rate_center`, `state`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`,`supplier_rate`,`rates`,`camp_registry`,`path`,`idapi`,`key`) VALUE ";
                            str.forEach((ele) => {
                                if (ele.thinqTier == 0) {
                                    let did = "" + ele.id + "";
                                    let number = did.substring(1, 11);
                                    let hmp = {
                                        phone_number: number,
                                        rate_center: (0, markError_1.default)(ele.ratecenter),
                                        state: (0, markError_1.default)(ele.state),
                                        supplier_tier: (0, markError_1.default)(ele.thinqTier)
                                    };
                                    hsmpData.push(hmp);
                                    qrystr += "('" + this.sessdata.idaccount + "', '" + ele.didSummary + "','" + number + "', '" + ele.ratecenter + "', '" + ele.ratecenter + "', '" + ele.state + "', '" + "blitz" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','NN','" + ele.thinqTier + "','','" + pLoad.rate + "','" + sdata.CampaignId + "','" + path + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + this.timekey + "'),";
                                    found = true;
                                }
                            });
                            if (found) {
                                this.saveHmp(this.timekey, 'blitz', hsmpData);
                                obj1.nonqrysql = qrystr.slice(0, -1);
                            }
                            else
                                obj1.nonqrysql = "";
                            obj1.prepare();
                            obj1.execute((err, data) => {
                                callback(err, data);
                            });
                        }
                        else {
                            callback('', data);
                        }
                    }
                    catch (e) {
                        console.log("Error :: blitz->getByRate::", e);
                        callback(error, '');
                    }
                }
                else {
                    callback(error, '');
                }
            });
        }
    }
    getTollFree(req, res, pLoad, callback) {
        if (this.priority == "100") {
            callback('', '');
        }
        else {
            this.getRate(req, res, this.sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                if (err == 1 && voice_rate.length > 0) {
                    var sdata = req.query;
                    var options = {
                        'method': 'GET',
                        'url': "https://api.thinq.com/inbound/get-numbers?searchType=tollfree&searchBy=&quantity=" + sdata.Qty + "&contiguous=false",
                        'headers': {
                            'Authorization': 'Basic ' + this.key
                        },
                    };
                    (0, axios_1.request)(options, (error, response) => {
                        if (!error) {
                            try {
                                let data = JSON.parse(response.body);
                                console.log("data", data);
                                if (data.dids != undefined && data.dids.length > 0) {
                                    let str = data.dids;
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `did_search` (`idaccount`,`friendly_name`, `phone_number`, `locality`, `rate_center`, `state`, `provider`, `iduser`, `priorty`,`type`,`supplier_tier`, `rates`,`path`,`idapi`,`key`) VALUE ";
                                    str.forEach((ele) => {
                                        let did = "" + ele.id + "";
                                        let number = did.substring(1, 11);
                                        qrystr += "('" + this.sessdata.idaccount + "', '" + ele.didSummary + "','" + number + "', '" + ele.ratecenter + "', '" + ele.ratecenter + "', '" + ele.state + "', '" + "thinQ" + "', '" + this.sessdata.iduser + "', '" + this.priority + "','TF','" + ele.thinqTier + "', '" + pLoad.rate + "','" + this.sessdata.path + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','" + this.timekey + "'),";
                                    });
                                    obj1.nonqrysql = qrystr.slice(0, -1);
                                    obj1.prepare();
                                    obj1.execute((err, data) => {
                                        callback(err, data);
                                    });
                                }
                                else {
                                    callback('', data);
                                }
                            }
                            catch (e) {
                                console.log("Error :: blitz->getTollFree::", e);
                                callback(error, '');
                            }
                        }
                        else {
                            callback(error, '');
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Account setting invalid because rate not found" });
                    objv.execute();
                }
            });
        }
    }
    buyDID(req, res, callback) {
        const sdata = req.body;
        let types;
        let did = (sdata && typeof sdata.DID === 'string') ? sdata.DID.trim() : String(sdata.DID || '').trim();
        let len = did.length - 10;
        let npa = did.slice(len, len + 3);
        let nxx = did.slice(len + 3, len + 6);
        let Did = did.slice(len, len + 10);
        this.getRateCenter(req, res, npa, nxx, (err, ratecenter_state) => {
            let ratecenter = ratecenter_state[0] !== undefined ? ratecenter_state[0].rc_abbre : '';
            let state = ratecenter_state[0] !== undefined ? ratecenter_state[0].loc_state : '';
            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
            obj1.qrysql = "SELECT `type`,`rates` from `did_search` WHERE `iduser`='" + this.sessdata.iduser + "' AND `phone_number`='" + did + "'";
            obj1.prepare();
            obj1.execute((error, did_details) => {
                if (did_details.length > 0) {
                    types = did_details[0].type == 'TF' ? 'TF' : 'NN';
                    var options = {
                        'method': 'POST',
                        'url': 'https://api.thinq.com/account/15080/origination/order/create',
                        'headers': {
                            'Authorization': 'Basic ' + this.key,
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            "order": {
                                "tns": [
                                    {
                                        "route_id": 7818,
                                        "did": did
                                    }
                                ],
                                "blocks": []
                            }
                        })
                    };
                    (0, axios_1.request)(options, (error, response) => {
                        if (!error) {
                            try {
                                console.log("response", response.body);
                                let data = JSON.parse(response.body);
                                if (data.id != undefined) {
                                    console.log(data.id);
                                    var options = {
                                        'method': 'POST',
                                        'url': 'https://api.thinq.com/account/15080/origination/order/complete/' + `${data.id}`,
                                        'headers': {
                                            'Authorization': 'Basic ' + this.key,
                                            'Content-Type': 'application/json'
                                        }
                                    };
                                    (0, axios_1.request)(options, (error, response) => {
                                        console.log("Data", sdata);
                                        if (!error) {
                                            try {
                                                let ddata = JSON.parse(response.body);
                                                if (ddata.code == 404) {
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({ status: ddata.code, result: ddata });
                                                    obj.execute();
                                                }
                                                else {
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `did_buy` (`account_id`, `user_id`, `status`, `did`,`provider`,`order_id`,`type`,`iduser`,`disconnect_did_status`,`npa`,`nxx`,`state`,`ratecenter`,`inbound_key`,`outbound_key`,`connection_key`,`sms_inbound_key`,`sms_outbound_key`,`rates`,`camp_registry`,`idapi`,`sms_provider`) VALUE('" + ddata.account_id + "','" + ddata.user_id + "','" + ddata.status + "','" + Did + "','thinQ','" + data.id + "','" + types + "','" + this.sessdata.iduser + "','1','" + npa + "','" + nxx + "','" + state + "','" + ratecenter + "','" + sdata.InboundVoice + "','" + sdata.OutboundVoice + "','" + sdata.Connection + "','" + sdata.InboundSMS + "','" + sdata.OutboundSMS + "','" + did_details[0].rates + "','" + sdata.CampaignId + "','" + (0, markError_1.setToZero)(this.sessdata.idapi) + "','sinch')";
                                                    obj.prepare();
                                                    obj.execute((did_err, did_data) => {
                                                        if (did_err == 1) {
                                                            let dateObj = new Date();
                                                            let day = dateObj.getUTCDate();
                                                            let totalDays = 30 - day + 1;
                                                            let prorate = (totalDays * did_details[0].rates) / 30;
                                                            console.log(prorate);
                                                            let payload = {
                                                                idaccount: this.sessdata.idaccount,
                                                                amount: prorate,
                                                                purpose: 'DID Purchase',
                                                                type: '-'
                                                            };
                                                            insertdid.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                console.log("buyDID => walletDeduction Wallet deduction response:", errorD, dataD);
                                                            });
                                                            let logPayload = {
                                                                funDetail: {
                                                                    tableName: 'did_log',
                                                                    functionName: 'buyDID',
                                                                    logName: 'DID'
                                                                },
                                                                data: {
                                                                    account_id: this.sessdata.idaccount,
                                                                    status: 'completed',
                                                                    provider: 'thinQ',
                                                                    did: Did,
                                                                    order_id: data.id,
                                                                    type: types,
                                                                    npa: npa,
                                                                    nxx: nxx,
                                                                    state: state,
                                                                    disconnect_did_status: '1',
                                                                    iduser: this.sessdata.iduser,
                                                                    ratecenter: ratecenter,
                                                                    rates: did_details[0].rates,
                                                                    idapi: this.sessdata.idapi,
                                                                    pro_rates: prorate,
                                                                }
                                                            };
                                                            insertdid.insertLog(req, res, logPayload, (log_error, did_log) => {
                                                                let obj = new RawView_1.RawView(res);
                                                                obj.prepare({ status: 201, message: "DID buy successfully", result: [{ "did": did }] });
                                                                obj.execute();
                                                            });
                                                        }
                                                        else {
                                                            let obj = new RawView_1.RawView(res);
                                                            obj.prepare({ status: 502, message: "Something went wrong with connection!" });
                                                            obj.execute();
                                                        }
                                                    });
                                                }
                                            }
                                            catch (e) {
                                                console.log("Error :: blitz->buyDID::", e);
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                obj.execute();
                                            }
                                        }
                                        else {
                                            let obj = new RawView_1.RawView(res);
                                            obj.prepare({ status: 400, error: error });
                                            obj.execute();
                                        }
                                    });
                                }
                                else {
                                    let obj = new RawView_1.RawView(res);
                                    obj.prepare({ status: data.code, message: data.message, error: data });
                                    obj.execute();
                                }
                            }
                            catch (e) {
                                console.log("Error :: blitz->buyDID::", e);
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }
                        }
                        else {
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ status: 400, error: error });
                            obj.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "Did Not Available" });
                    objv.execute();
                }
            });
        });
    }
    disconnectDID(req, res, callback) {
        let sdata = req.body;
        console.log("sdata", sdata);
        let objv = new RawView_1.RawView(res);
        objv.prepare({ status: 502, message: "Something went wrong with disconnect!!" });
        objv.execute();
        /* let number = new Number();
        number.countDays(req, res, sdata.DID.trim(), (err, countdays) => {
            if (countdays) {
                if (countdays > 90) {
                    var options = {
                        'method': 'POST',
                        'url': 'https://api.thinq.com/account/15080/origination/disconnect',
                        'headers': {
                            'Content-Type': 'application/json',
                            'Authorization': 'Basic ' + this.key
                        },
                        body: JSON.stringify({
                            "dids": [sdata.DID.trim()]
                        })
                    };
                    request(options, (error: any, response: any) => {
                        if (!error) {
                            try{
                                let data: any = JSON.parse(response.body);
                                console.log("data", data);
                                if (data.status == "completed") {
                                    let obj = new ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `did_buy` set `disconnect_did_status`='0',`updated_at`=NOW() WHERE `did`='" + sdata.DID.trim() + "'AND `iduser`='" + this.sessdata.iduser + "'";
                                    obj.prepare();
                                    obj.execute((error, resp) => {
                                        if (error == 1) {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 201, message: "DID Disconnected Successfully" });
                                            objv.execute();
                                        } else {
                                            let objv = new RawView(res);
                                            objv.prepare({ status: 502, message: "Something went wrong with connection" });
                                            objv.execute();
                                        }
                                    })
                                } else {
                                    let obj = new RawView(res);
                                    obj.prepare({ status: data.code, message: data.message });
                                    obj.execute()
                                }
                            }
                            catch(e){
                                console.log("Error :: blitz->disconnectDID::",e);
                                let obj = new RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }
                        } else {
                            let obj = new RawView(res);
                            obj.prepare({ status: 400, error: error });
                            obj.execute()
                        }
                    });
                } else {
                    let obj = new RawView(res);
                    obj.prepare({ status: 417, message: "Days are Less then 90 So you can not disconnect Did from this Account" });
                    obj.execute();
                }
            } else {
                let obj = new RawView(res);
                obj.prepare({ status: 404, message: "Data Not Found" })
                obj.execute();
            }
        }); */
    }
}
exports.BlitzAPI = BlitzAPI;
