"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const multer1 = require('multer');
const setting_config_1 = require("../config/setting.config");
const MIME_TYPE_MAP1 = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'image/gif': 'gif',
    'image/webp': 'webp',
    'text/csv': 'csv',
    'application/pdf': 'pdf',
    'text/plain': 'txt',
    'audio/mpeg': 'mp3',
    'audio/wav': 'wav',
    'audio/webm': 'weba',
    'video/mp4': 'mp4',
    'application/vnd.ms-excel': 'xls',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet': 'xlsx',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx'
};
const storage1 = multer1.diskStorage({
    destination: (req, file, cb) => {
        let mmsdir = new setting_config_1.UploadDirectory();
        const isValid = MIME_TYPE_MAP1[file.mimetype];
        let error = "";
        if (!isValid) {
            error = new Error("Invalid file type");
        }
        cb(error, mmsdir.KYCFILEUPLOAD);
    },
    filename: (req, file, cb) => {
        let file_path = file.originalname;
        let extension = file_path.split('.').pop();
        let randomName = Math.random().toString(36).substring(2, 12);
        const filenm = file.originalname;
        const flName = Date.now() + '-' + filenm.replace(filenm, randomName);
        const fileName = flName + '.' + extension;
        const ext = MIME_TYPE_MAP1[file.mimetype];
        cb(null, fileName);
    }
});
module.exports = multer1({ storage: storage1 }).single('UPLOAD');
