"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TZ = exports.UserManagement = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
const _406_1 = require("../lib/view/406");
// import { AppRoute } from "../lib/AppRoute";
const ModelPdfUpload_1 = require("../lib/model/ModelPdfUpload");
const RawQuery_1 = require("../lib/model/RawQuery");
const Str = require('@supercharge/strings').Str;
// var nodemailer = require("nodemailer");
const jwt = require('jsonwebtoken');
const axios_1 = require("./axios");
const server_1 = require("../server");
const setting_config_1 = require("../config/setting.config");
const markError_1 = require("./markError");
const APIBase_1 = require("./APIBase");
const AccountDelete_1 = require("./AccountDelete");
const newcampaign_class_1 = require("./newcampaign.class");
const KeyCloak_1 = require("./KeyCloak");
let keycloak = new KeyCloak_1.Keycloak();
let URLlink = new setting_config_1.LinkVerify();
let profile_pic = new setting_config_1.Profile();
const emailSetting = new setting_config_1.EmailSettingForSupport();
const supportEmail = emailSetting.EMAIL;
const templateURL = new setting_config_1.TemplateURl();
const FromSmtpMail = new setting_config_1.SMTPDetails();
const FromEmail = FromSmtpMail.from;
const uploadDirectory = new setting_config_1.UploadDirectory();
const note = new setting_config_1.Notes();
const smNumber = new setting_config_1.SignalmashNumber();
const msAPIURL = new setting_config_1.SignalmashUrl();
const validuser = new APIBase_1.APIBase();
const isValidEmail = (value) => /^(?!.*\.\.)(?!\.)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,10}(?<!\.)$/.test(value);
const isEmpty = (value) => !value || value == 'undefined' || value == 'null' || undefined || value == null || value === '';
const isValidtarif = (value) => /^[0-9]+$/.test(value);
const makeNumber = (length) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const makeChar = (length) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const makeRanChar = (length) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const generatePassword = () => {
    let result = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
};
const MIME_TYPE_MAPs = {
    'text/csv': 'csv', //re
    'audio/3gpp': '3ga',
    'video/3gpp': '3gp',
    'text/plain': 'txt',
    'audio/amr': 'amr',
    'video/x-msvideo': 'avi',
    'image/bmp': 'bmp',
    'application/x-bzip2': 'bz2',
    'application/calendar': 'cal',
    'text/css': 'css',
    'image/dib': 'dib',
    'audio/flac': 'flac',
    'video/x-flv': 'flv',
    'image/gif': 'gif',
    'application/x-gzip': 'gz',
    'image/x-icon': 'ico',
    'image/jpeg': 'jpeg', //re
    'image/jpg': 'jpg', //re
    'application/javascript': 'js',
    'application/json': 'json',
    'audio/mpeg': 'm1a',
    'video/m1v': 'm1v',
    'audio/m2a': 'm2a',
    'audio/x-m4a': 'm4a',
    'audio/m4b': 'm4b',
    'audio/x-mp3': 'mp3', //re
    'video/mp4': 'mp4', //re
    'audio/x-ms-wma': 'mpa',
    'video/mpeg': 'mpeg',
    'video/mpg': 'mpg',
    'application/pdf': 'pdf', //re
    'image/pjpeg': 'pjpeg',
    'image/png': 'png', //jj
    'video/quicktime': 'qt',
    'text/rtf': 'rtf',
    'audio/x-wav': 'wav',
    'video/webm': 'webm',
    'image/webp': 'webp',
    'video/x-ms-wmv': 'wmv',
    'application/xml': 'xml',
    'application/zip': 'zip'
};
class UserManagement {
    constructor() {
        // super();
    }
    makeNumber(len) {
        var result = '';
        var characters = '09876543212346543098765123456789';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        return result;
    }
    makeChar(len) {
        var result = '';
        var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        return result;
    }
    makeRanChar(len) {
        var result = '';
        var characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        return result;
    }
    /**
     * To authenticate user with TimeZone
     */
    getMorphingSession(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let pData = req.query;
                let msg = '';
                switch (true) {
                    case !pData:
                        msg = 'Request query not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, kyc_verify_status,`isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time`,`country` FROM `session` WHERE `authkey` = '" + pData.key + "'";
                    obj.prepare();
                    obj.execute((error, resSession) => {
                        let data = resSession[0];
                        let objup = new RawQuery_1.ModelRawQuery(req, res);
                        objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + resSession[0].iduser + "'";
                        objup.prepare();
                        objup.execute((__errorE, emailE) => {
                            let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                            obj7.qrysql = "SELECT country FROM billing_address WHERE idaccount='" + resSession[0].idaccount + "'";
                            obj7.prepare();
                            obj7.execute((error, result1) => {
                                let addresdata = result1[0]?.country !== '' && result1[0]?.country !== undefined && result1[0]?.country !== 'undefined' ? result1[0].country : '';
                                let country = { "country": addresdata };
                                let emType = { "email": emailE[0].email };
                                let result = Object.assign(data, emType, country);
                                if (error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Session Data Fetch Successfully!", status: 200, data: [result] });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong to Fetch Session", status: 502, result: result });
                                    objv.execute();
                                }
                            });
                        });
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /* getLogin(req: Request, res: Response, next: NextFunction) {
        let sdata: any = req.body.data;
        if (sdata && sdata !== 'undefined' && sdata !== undefined && sdata !== '') {
            let pass1: any = sdata.password;
            let message: any = "", status: any = "", dataLogin: any;
            switch (true) {
                case (!sdata):
                    message = "Request body not found!";
                    status = 403;
                    break;
                case (!sdata.username || isMissing(sdata.username)):
                    message = "Missing Username field, Kindly contact to administration";
                    status = 403;
                    break;
                case (sdata.username && checkvalue(sdata.username)):
                    message = "Username is invalid";
                    status = 404;
                    break;
                case (!sdata.password || isMissing(sdata.password)):
                    message = "Missing Password field";
                    status = 403;
                    break;
                default:
                    message = "";
                    status = "";
            }
            if (message) {
                let objv = new RawView(res);
                objv.prepare({ status: status, message: message });
                objv.execute();
                return;
            } else {
                let user = new UserManagement();
                user.checkaccountsuspension(req, res, sdata.username, (errlogin, resLogin) => {
                    if (errlogin == 1) {
                        let obj: any = new ModelRawQuery(req, res)
                        let iQry: string = "SELECT us.`iduser`, us.`idaccount`, us.`username`, us.`password`, us.`type`, us.`default`, us.`idtariff`, us.`isEmailVerify`, us.`isMobileVerify`, us.`isPlan`, us.`isAddress`,us.`isCard`,us.`newUser_status`, '-08:00' client_time, IF(us.`is_deleted` = 0, 9, us.`is_deleted`) acc_status, us.`kyc_verify_status`, us.`resetPassword` FROM `user` us\n"
                        iQry += "WHERE us.`username`='" + parseBody(sdata.username) + "';"
                        obj.qrysql = iQry;
                        if (obj.prepare()) {
                            obj.execute((error: any, result: any) => {
                                if (result.length > 0) {
                                    if (result[0].password && (result[0].password != null || result[0].password != undefined || result[0].password != 'null' || result[0].password != 'undefined')) {
                                        console.log("getLogin result :: ", result);
                                        let objup = new ModelRawQuery(req, res);
                                        objup.qrysql = "SELECT `email` FROM `user_profile` WHERE `iduser`='" + result[0].iduser + "'";
                                        objup.prepare();
                                        objup.execute((__errorE: any, emailE: any) => {
                                            let emails = emailE[0].email !== '' && emailE[0].email !== undefined && emailE[0].email !== 'undefined' ? emailE[0].email : ''
                                            if ((bcrypt.compareSync(pass1, result[0].password))) {
                                                if (result[0].type == 1 || result[0].type == 2 || result[0].type == 22 || result[0].type == 201 || result[0].type == 202 || result[0].type == 203 || result[0].type == 231 || result[0].type == 232) {
                                                    let data: any = result[0];
                                                    delete data.password;
                                                    let loginType = { "sessionType": sdata.sessionType };
                                                    let Result: any = Object.assign(data, loginType);
                                                    if ((data.acc_status == 9) || (sdata.typeCheck && sdata.typeCheck == "admin_checking")) {
                                                        delete data.acc_status
                                                        let session = new SessionManagment(req, res, next);
                                                        session.SetSession(Result, (error: any, sessdata: any) => {
                                                            // To set User Login Activity
                                                            let sysInfo = ipAddressAndBrowser(req);
                                                            let objh = new ModelRawNonQuery(req, res);
                                                            objh.nonqrysql = "INSERT INTO `user_login_history`(`iduser`, `idaccount`, `type`, `token`, `ipaddress`, `browser`, `login_time`, `login_type`) VALUES ('" + result[0].iduser + "','" + result[0].idaccount + "','" + result[0].type + "', '" + Result.authkey + "', '" + sysInfo.ipAddress[0] + "', '" + sysInfo.browserName + "', NOW(),'login')";
                                                            objh.prepare();
                                                            objh.execute((error: any, data: any) => {

                                                            });
                                                            // To Merge
                                                            let obj1 = new ModelRawQuery(req, res);
                                                            obj1.qrysql = "SELECT `country` FROM `billing_address` WHERE `idaccount`='" + result[0].idaccount + "'";
                                                            obj1.prepare()
                                                            obj1.execute((error: any, dataaddres: any) => {
                                                                let addresdata = sessdata.type !== 1 && dataaddres.length > 0 && dataaddres[0].country !== '' && dataaddres[0].country !== undefined && dataaddres[0].country !== null && dataaddres[0].country !== 'undefined' && dataaddres[0].country !== 'null' ? dataaddres[0].country : '';
                                                                let addType = { "country": addresdata };
                                                                let emType = { "email": emails };
                                                                let data1: any = Object.assign(data, emType, addType);
                                                                let objv = new RawView(res);
                                                                objv.prepare(data1);
                                                                objv.execute();
                                                            });
                                                            // To set user failed login History
                                                            dataLogin = { iduser: result[0].iduser, idaccount: result[0].idaccount, username: sdata.username, checkpoint: '1', count: '0' }
                                                            user.suspendAccount(req, res, dataLogin, (err, resL) => {
                                                                console.log("resL suspendAccount ::", resL);
                                                            })
                                                        });
                                                    }
                                                    else {
                                                        let errMsg: string = data.acc_status == 1 ? "Your account deletion in under process!" : "Your account has been deleted, If you want to restore kindly contact with customer support!"
                                                        let errCode = data.acc_status == 1 ? "DelInProcess" : "Deleted";
                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            message: errMsg, error: errCode
                                                        });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView(res);
                                                    objv.prepare({ status: 401, message: "You are not Authorized for this Panel!" });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                dataLogin = { iduser: result[0].iduser, idaccount: result[0].idaccount, username: sdata.username, checkpoint: '2' }
                                                user.suspendAccount(req, res, dataLogin, (err, resL) => {
                                                    console.log("resL suspendAccount ::", resL);
                                                })
                                                let objv = new RawView(res);
                                                objv.prepare({
                                                    status: 404, message: "Invalid Password, Kindly check again!"
                                                });
                                                objv.execute();
                                            }
                                        });
                                    } else {
                                        dataLogin = { iduser: result[0].iduser, idaccount: result[0].idaccount, username: sdata.username, checkpoint: '2' }
                                        user.suspendAccount(req, res, dataLogin, (err, resL) => {
                                            console.log("resL suspendAccount ::", resL);
                                        })
                                        let objv = new RawView(res);
                                        objv.prepare({ status: 404, message: "This user has not set password!" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    dataLogin = { iduser: '', idaccount: '', username: sdata.username, checkpoint: '2' }
                                    user.suspendAccount(req, res, dataLogin, (err, resL) => {
                                        console.log("resL suspendAccount ::", resL);
                                    })
                                    let objv = new RawView(res);
                                    objv.prepare({ status: 404, message: "Invalid Username, Kindly check again!" });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                status: 422, message: "Few parameter are missing in request!"
                            });
                            objv.execute();
                        }
                        // }
                        // else {
                        //     let objv = new RawView(res);
                        //     objv.prepare({ status: 403, message: "Missing Username or Password field, Kindly contact to administration" });
                        //     objv.execute();
                        // }
                    } else {
                        let objv = new RawView(res);
                        objv.prepare(resLogin);
                        objv.execute();
                    }
                })
            }
        } else {
            let objv = new RawView(res);
            objv.prepare({ status: 422, message: "Few parameter are missing in request!" });
            objv.execute();
        }
    } */
    getLogin(req, res, next) {
        let sdata = req.body.data;
        if (sdata && sdata !== '' && sdata !== undefined && sdata !== '') {
            let pass1 = sdata.password;
            let message = "", status = "", dataLogin;
            switch (true) {
                case (!sdata.username || (0, markError_1.isMissing)(sdata.username)):
                    message = "Missing Username field, Kindly contact to administration";
                    status = 403;
                    break;
                case (sdata.username && (0, markError_1.checkvalue)(sdata.username)):
                    message = "Username is invalid";
                    status = 404;
                    break;
                case (!sdata.password || (0, markError_1.isMissing)(sdata.password)):
                    message = "Missing Password field";
                    status = 403;
                    break;
                default:
                    message = "";
                    status = "";
            }
            if (message) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: status, message: message });
                objv.execute();
                return;
            }
            else {
                let user = new UserManagement();
                console.log("Sending Credentials To Keycloak :: Username :: ", sdata.username);
                keycloak.loginKeyClock(req, res, sdata.username, pass1, (errorR, resR) => {
                    console.log("Keycloak Response :: ", resR);
                    if (errorR == 1) {
                        let authtoken = JSON.parse(resR.data.body);
                        console.log("Keycloak Parsed Token:", authtoken);
                        let accessToken = authtoken.access_token;
                        console.log("Access Token Received :: ", accessToken ? "YES :: " + accessToken : "NO");
                        if (accessToken) {
                            user.checkaccountsuspension(req, res, sdata.username, (errlogin, resLogin) => {
                                if (errlogin == 1) {
                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                    let iQry = "SELECT us.`iduser`, us.`idaccount`, us.`username`, us.`type`, us.`default`, us.`idtariff`, us.`isEmailVerify`, us.`isMobileVerify`, us.`isPlan`, us.`isAddress`, us.`isCard`, us.`newUser_status`, '-08:00' client_time, IF(us.`is_deleted` = 0, 9, us.`is_deleted`) acc_status, us.`kyc_verify_status`, us.`resetPassword` FROM `user` us WHERE us.`username`='" + (0, markError_1.parseBody)(sdata.username) + "';";
                                    obj.qrysql = iQry;
                                    if (obj.prepare()) {
                                        obj.execute((error, result) => {
                                            if (result.length > 0) {
                                                if (result[0].acc_status == 9 || (sdata.typeCheck && sdata.typeCheck == "admin_checking")) {
                                                    let data = result[0];
                                                    let objup = new RawQuery_1.ModelRawQuery(req, res);
                                                    objup.qrysql = "SELECT `email` FROM `user_profile` WHERE `iduser`='" + result[0].iduser + "'";
                                                    objup.prepare();
                                                    objup.execute((__errorE, emailE) => {
                                                        let emails = emailE[0].email !== '' && emailE[0].email !== undefined && emailE[0].email !== 'undefined' ? emailE[0].email : '';
                                                        if (result[0].type == 1 || result[0].type == 2 || result[0].type == 22 || result[0].type == 201 || result[0].type == 202 || result[0].type == 203 || result[0].type == 231 || result[0].type == 232) {
                                                            let authKey = { "authkey": accessToken };
                                                            let refresh_token = { "refresh_token": authtoken.refresh_token };
                                                            let loginType = { "sessionType": sdata.sessionType };
                                                            let Result = Object.assign(data, loginType, authKey, refresh_token);
                                                            delete data.acc_status;
                                                            let session = new Session_1.SessionManagment(req, res, next);
                                                            session.SetSession(Result, (error, sessdata) => {
                                                                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                                                                let objh = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                objh.nonqrysql = "INSERT INTO `user_login_history`(`iduser`, `idaccount`, `type`, `token`, `ipaddress`, `browser`, `login_time`, `login_type`) VALUES ('" + result[0].iduser + "','" + result[0].idaccount + "','" + result[0].type + "', '" + Result.authkey + "', '" + sysInfo.ipAddress[0] + "', '" + sysInfo.browserName + "', NOW(),'login')";
                                                                objh.prepare();
                                                                objh.execute((error, data) => {
                                                                });
                                                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                                                obj1.qrysql = "SELECT `country` FROM `billing_address` WHERE `idaccount`='" + result[0].idaccount + "'";
                                                                obj1.prepare();
                                                                obj1.execute((error, dataaddres) => {
                                                                    let addresdata = sessdata.type !== 1 && dataaddres.length > 0 && dataaddres[0].country !== '' && dataaddres[0].country !== undefined && dataaddres[0].country !== null && dataaddres[0].country !== 'undefined' && dataaddres[0].country !== 'null' ? dataaddres[0].country : '';
                                                                    let addType = { "country": addresdata };
                                                                    let emType = { "email": emails };
                                                                    let data1 = Object.assign(data, emType, addType, authKey, refresh_token);
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare(data1);
                                                                    objv.execute();
                                                                });
                                                            });
                                                            dataLogin = { iduser: result[0].iduser, idaccount: result[0].idaccount, username: sdata.username, checkpoint: '1', count: '0' };
                                                            user.suspendAccount(req, res, dataLogin, (err, resL) => {
                                                                console.log("resL suspendAccount ::", resL);
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ status: 401, message: "You are not Authorized for this Panel!" });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let errMsg = result[0].acc_status == 1 ? "Your account deletion is under process!" : "Your account has been deleted, If you want to restore kindly contact with customer support!";
                                                    let errCode = result[0].acc_status == 1 ? "DelInProcess" : "Deleted";
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: errMsg, error: errCode });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 404, message: "User record not found in local database. Kindly contact administration." });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 422, message: "Few parameters are missing in request!" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare(resLogin);
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 401, message: "Token validation failed." });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(resR);
                        objv.execute();
                    }
                });
            }
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 422, message: "Few parameters are missing in request!" });
            objv.execute();
        }
    }
    checkaccountsuspension(req, res, username, callback) {
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT `suspended_id`,`iduser`,`idaccount`,`failed_attempt`,`suspension_status`,`suspended_at`,`ip_address`,`username`,`created_at` FROM `failed_login_account_suspension` WHERE `username`='" + (0, markError_1.parseBody)(username) + "'";
        obj.prepare();
        obj.execute((error, result) => {
            if (error == 1) {
                if (result.length > 0) {
                    if (result[0].suspension_status == 1) {
                        callback(0, { message: 'Your account has been temporary suspended. Please try again after 24 hours.', status: 501 });
                    }
                    else if (result[0].suspension_status == 2) {
                        callback(0, { message: 'Your account has been permanently suspended. Please contact to administration.', status: 501 });
                    }
                    else {
                        callback(1, { message: 'Active', status: '200' });
                    }
                }
                else {
                    callback(1, { message: "No suspension account found!", status: 502 });
                }
            }
            else {
                callback(0, { message: "Something went wrong with check account suspension!", status: 502 });
            }
        });
    }
    suspendAccount(req, res, data, callback) {
        console.log(data);
        let count = 0, suspension = '0', suspend_date = '';
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT `suspended_id`,`iduser`,`idaccount`,`failed_attempt`,`suspension_status`, `ip_address`,`username`,`created_at` FROM `failed_login_account_suspension` WHERE `username`='" + (0, markError_1.parseBody)(data.username) + "'";
        obj.prepare();
        obj.execute((error, result) => {
            if (error == 1) {
                if (result.length > 0) {
                    if (data.checkpoint == 2) {
                        count = result[0].failed_attempt + 1;
                        console.log("countcountcountcount", count);
                        suspension = count == 3 ? '1' : count == 6 ? '2' : '0';
                        console.log("suspensionsuspensionsuspension", suspension);
                    }
                    else {
                        count = 0;
                        suspension = '0';
                    }
                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj1.nonqrysql = "UPDATE `failed_login_account_suspension` SET `failed_attempt`='" + count + "',`suspension_status` = '" + suspension + "',`updated_at`= NOW(),`suspended_at`=NOW() WHERE `username`='" + (0, markError_1.parseBody)(data.username) + "'";
                    obj1.prepare();
                    obj1.execute((error2, result2) => {
                        if (error2 == 1) {
                            callback(1, { status: 200, message: "Failed login updated successfully!" });
                        }
                        else {
                            callback(0, { status: 502, message: "Something went wrong with failed login data!" });
                        }
                    });
                }
                else {
                    // if (data.checkpoint == 2) {
                    count = data.count ?? 1;
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "INSERT INTO `failed_login_account_suspension` (`iduser`,`idaccount`,`failed_attempt`,`suspension_status`,`ip_address`,`username`) VALUES ('" + (0, markError_1.setToZero)(data.iduser) + "','" + (0, markError_1.setToZero)(data.idaccount) + "','" + count + "','0','" + sysInfo.ipAddress[0] + "','" + (0, markError_1.parseBody)(data.username) + "')";
                    obj2.prepare();
                    obj2.execute((error1, result1) => {
                        if (error1 == 1) {
                            callback(1, { status: 200, message: "Failed login saved successfully!" });
                        }
                        else {
                            callback(0, { status: 502, message: "Something went wrong with failed login data!" });
                        }
                    });
                    // } else {
                    //     callback(1, { status: 200, message: "Failed login saved successfully!" })
                    // }
                }
            }
            else {
                callback(0, { message: "Something went wrong with check account suspension!", status: 502 });
            }
        });
    }
    getMorphingLogin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1_2(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1 || sessdata.type == 2) {
                        let sdata = req.body.data;
                        let message = '';
                        let status = '';
                        switch (true) {
                            case (!sdata || sdata == 'undefined' || sdata == undefined || sdata == ''):
                                message = "Few parameter are missing in request!";
                                status = 422;
                                break;
                            case (!sdata.username || sdata.username == '' || sdata.username == "null" || sdata.username == "undefined"):
                                message = "Username is required";
                                status = 501;
                                break;
                            case (!sdata.typeCheck || sdata.typeCheck == '' || sdata.typeCheck == "null" || sdata.typeCheck == "undefined"):
                                message = "Typecheck is required";
                                status = 501;
                                break;
                            case (!sdata.sessionType || sdata.sessionType == '' || sdata.sessionType == "null" || sdata.sessionType == "undefined"):
                                message = "Sessiontype is required";
                                status = 501;
                                break;
                            default:
                                message = "";
                                status = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: status, message: message });
                            objv.execute();
                        }
                        else {
                            // if (sdata && sdata !== 'undefined' && sdata !== undefined && sdata !== '') {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            let iQry = "SELECT us.iduser, us.idaccount, us.username, us.type, us.default, us.idtariff, us.isEmailVerify, us.isMobileVerify, us.isPlan, us.isAddress,us.isCard,us.newUser_status, '-08:00' client_time, IF(us.is_deleted = 0, 9, us.is_deleted) acc_status, us.kyc_verify_status, us.resetPassword FROM user us\n";
                            iQry += "WHERE us.`username`='" + (0, markError_1.parseBody)(sdata.username) + "';";
                            obj.qrysql = iQry;
                            if (obj.prepare()) {
                                obj.execute((error, result) => {
                                    if (result.length > 0) {
                                        let objup = new RawQuery_1.ModelRawQuery(req, res);
                                        objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + result[0].iduser + "'";
                                        objup.prepare();
                                        objup.execute((__errorE, emailE) => {
                                            let objup7 = new RawQuery_1.ModelRawQuery(req, res);
                                            objup7.qrysql = "SELECT country FROM `billing_address` WHERE `idaccount`='" + result[0].idaccount + "'";
                                            objup7.prepare();
                                            objup7.execute((__errorEE, result7) => {
                                                let emails = emailE.length > 0 && emailE[0].email ? emailE[0].email : '';
                                                let country = result7.length > 0 && result7[0].country ? result7[0].country.trim() : '';
                                                if (result[0].type == 1 || result[0].type == 2 || result[0].type == 22 || result[0].type == 201 || result[0].type == 202 || result[0].type == 203 || result[0].type == 231 || result[0].type == 232) {
                                                    let data = result[0];
                                                    let loginType = { "sessionType": sdata.sessionType };
                                                    let Result = Object.assign(data, loginType);
                                                    if ((data.acc_status == 9) || (sdata.typeCheck && sdata.typeCheck == "admin_checking")) {
                                                        delete data.acc_status;
                                                        let session = new Session_1.SessionManagment(req, res, next);
                                                        session.SetSession(Result, (error, sessdata) => {
                                                            // To set User Login Activity
                                                            let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                                                            let objh = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            objh.nonqrysql = "INSERT INTO `user_login_history`(`iduser`, `idaccount`, `type`, `token`, `ipaddress`, `browser`, `login_time`, `login_type`) VALUES ('" + result[0].iduser + "','" + result[0].idaccount + "','" + result[0].type + "', '" + Result.authkey + "', '" + sysInfo.ipAddress[0] + "', '" + sysInfo.browserName + "', NOW(),'login')";
                                                            objh.prepare();
                                                            objh.execute((error, data) => { });
                                                            // To Merge
                                                            let emType = { "email": emails };
                                                            let tmpcountryType = { "country": country };
                                                            let data1 = Object.assign(data, emType, tmpcountryType);
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare(data1);
                                                            objv.execute();
                                                        });
                                                    }
                                                    else {
                                                        let errMsg = data.acc_status == 1 ? "Your account deletion in under process!" : "Your account has been deleted, If you want to restore kindly contact with customer support!";
                                                        let errCode = data.acc_status == 1 ? "DelInProcess" : "Deleted";
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            message: errMsg, error: errCode
                                                        });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 401, message: "You are not Authorized for this Panel!" });
                                                    objv.execute();
                                                }
                                            });
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 404, message: "Invalid Username, Kindly check again!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: 422, message: "Few parameter are missing in request!"
                                });
                                objv.execute();
                            }
                            // } else {
                            //     let objv = new RawView(res);
                            //     objv.prepare({ status: 422, message: "Few parameter are missing in request!" });
                            //     objv.execute();
                            // }
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**
     * To save the system timezone into user's profile
     */
    SaveSysTZ(req, res, next) {
        let sdata = null;
        try {
            sdata = JSON.parse(req.body.data);
        }
        catch (e) {
            console.log("Error :: SaveSysTZ::", e);
            sdata = req.body.data;
        }
        let msg = '';
        switch (true) {
            case !sdata:
                msg = 'Request body not found!';
                break;
        }
        if (msg) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        }
        else {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    let objr = new RawQuery_1.ModelRawQuery(req, res);
                    let objv = new RawView_1.RawView(res);
                    objr.qrysql = "SELECT id FROM `tbl_timezones` WHERE utc='" + sdata.utc + "' AND tzCode='" + sdata.tzCode + "';";
                    objr.prepare();
                    objr.execute((error, result) => {
                        if (error == 1) {
                            let id_tz = result.length > 0 ? result[0].id : 0;
                            obj.nonqrysql = "REPLACE INTO `tbl_timezone_config`(id_timezone, id_user) VALUES(" + id_tz + ", " + sessdata.iduser + ");";
                            obj.prepare();
                            obj.execute((error, result) => {
                                if (error == 1) {
                                    /**
                                     * It will update the current user's
                                     * session table + session data
                                     */
                                    obj.nonqrysql = "UPDATE `session` SET `client_time`='" + sdata.utc + "' WHERE `authkey`='" + sessdata.authkey + "';";
                                    obj.prepare();
                                    obj.execute((error, result2) => {
                                        sessdata.client_time = sdata.utc;
                                        server_1.sessiondata.set(sessdata.authkey, sessdata);
                                    });
                                }
                                else {
                                    objv.prepare({
                                        error: 1,
                                        message: "Something went wrong!"
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            objv.prepare({
                                error: 1,
                                message: "Something went wrong!"
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare({ status: 401, message: "Unauthorized User!" });
                    objv.execute();
                }
            });
        }
    }
    VerifyUrl(req, res, next) {
        let gquery = req.query;
        let message = '';
        switch (true) {
            case (!gquery || !('type' in gquery)):
                message = "Missing Parameter : type";
                break;
            case (gquery.type == '' || gquery.type == 'null' || gquery.type == 'undefined'):
                message = "Type is empty or null";
                break;
            default:
                message = "";
        }
        if (message) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ message: message, status: 502 });
            objv.execute();
            return;
        }
        else {
            const decodedUrl = decodeURIComponent(gquery.type);
            let obj = new RawQuery_1.ModelRawQuery(req, res);
            obj.qrysql = "SELECT `url`  FROM `signup_referral_link` WHERE `url` = '" + (0, markError_1.parseBody)(decodedUrl) + "'";
            obj.prepare();
            obj.execute((_error, getUrl) => {
                if (_error == 1) {
                    if (getUrl.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "URL Matched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "This Link has been expired!", status: 404 });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Somthing went wrong with verifying url!", status: 502 });
                    objv.execute();
                }
            });
        }
    }
    signUp(req, res, next) {
        // const ipAddress = req.socket.remoteAddress;
        let sdata = req.body.data;
        let msg = '';
        switch (true) {
            case !sdata:
                msg = 'Request body not found!';
                break;
        }
        if (msg) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        }
        else {
            let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
            let data = req.query;
            let reseller_id;
            let signup_link_id;
            let url = data.type;
            let signUpLinkUrl = '';
            let filePath = URLlink.SIGNALHOST;
            const url1 = typeof url === 'string' && url.includes('/signup') ? url.split('/signup')[1] : '';
            console.log(url1, 'hgyugtyfyft');
            let url2 = url1.split('url=')[1];
            if (url2 == undefined) {
                reseller_id = null;
                signup_link_id = null;
            }
            else {
                let url4 = url.split(filePath + '/#/signup?url=')[1];
                let decodeUrl = Buffer.from(url4, "base64").toString("utf8").replace('_', '=').replace('_', '=');
                let user_id = decodeUrl.split('iduser=')[1];
                reseller_id = user_id.split('&idtariff')[0];
                signup_link_id = decodeUrl.split('&ukey=')[1];
                signUpLinkUrl = signup_link_id.replace(/[^A-Za-z:0-9]/g, "");
            }
            const passwd = (sdata && typeof sdata.password == 'string') ? sdata.password.trim() : sdata.password;
            let secret = Str.random(15);
            let validationKey = jwt.sign({
                exp: Math.floor(Date.now() / 1000) + (60 * 60),
                data: sdata.email + ":" + passwd
            }, secret);
            var isPlan;
            var tariff;
            if (sdata.tariff1 == -1 || sdata.tariff1 == 0) {
                isPlan = false;
                tariff = '-1';
            }
            else {
                isPlan = true;
                tariff = sdata.tariff1;
            }
            if (sdata.imgUrl) {
                sdata.imgUrl = sdata.imgUrl;
            }
            else {
                sdata.imgUrl = "https://portal.signalmash.com/assets/img/icon.png";
            }
            let ustatus = sdata.status ? true : false;
            const prgmch = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+$/;
            const empattern = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
            if (prgmch.test(sdata.firstName) && prgmch.test(sdata.lastName)) {
                if (empattern.test(sdata.email)) {
                    const firstname = (typeof sdata?.firstName == 'string')
                        ? (0, markError_1.parseBody)(sdata.firstName).trim()
                        : (0, markError_1.parseBody)(sdata.firstName).trim();
                    const lastname = (typeof sdata?.lastname == 'string')
                        ? (0, markError_1.parseBody)(sdata.lastName).trim()
                        : (0, markError_1.parseBody)(sdata.lastName).trim();
                    const domainVal = (typeof sdata?.email == 'string' && sdata.email.includes('@'))
                        ? sdata.email.split('@')[1]
                        : sdata.email.split('@')[1];
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `ip_address`, `email`, `domain_name`, `first_name`, `last_name`, `contact` FROM `domain_block` WHERE `ip_address` = '" + sysInfo.ipAddress[0] + "' OR `email` = '" + (0, markError_1.parseBody)(sdata.email) + "' OR `first_name` = '" + firstname + "' OR `last_name` = '" + lastname + "' OR `domain_name` = '" + domainVal + "'";
                    obj.prepare();
                    obj.execute((_errDomainBlk, getDomainBlock) => {
                        if (_errDomainBlk == 1 && getDomainBlock.length > 0) {
                            let errMsg = '';
                            if (getDomainBlock[0].email == sdata.email)
                                errMsg = "Please use valid business email and not a generic personal email to sign up.";
                            else if (getDomainBlock[0].domain_name == sdata.email.split('@')[1])
                                errMsg = "Please use valid business email and not a generic personal email to sign up.";
                            else if (getDomainBlock[0].first_name == sdata.firstName)
                                errMsg = "Unable to complete your registration, please contact support for further assistance.";
                            else if (getDomainBlock[0].last_name == sdata.lastName)
                                errMsg = "Unable to complete your registration, please contact support for further assistance.";
                            else if (getDomainBlock[0].ipAddress == sdata.ipAddress)
                                errMsg = "Unable to complete your registration, please contact support for further assistance.";
                            else
                                errMsg = "You Can't Register With Invalid Details!";
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: errMsg,
                                status: 501
                            });
                            objv.execute();
                        }
                        else {
                            if (passwd && (0, markError_1.checkPassword)(passwd) == '') {
                                // if (passwd) {
                                keycloak.createUser(req, res, sdata.email, passwd, sdata.email, sdata.firstName, sdata.lastName, (errorR, resR) => {
                                    console.log("createUser :: ", resR);
                                    if (errorR == 1) {
                                        keycloak.loginKeyClock(req, res, sdata.email, passwd, (errorRR, resRR) => {
                                            console.log("Keycloak Response ::", resRR);
                                            if (errorRR == 1) {
                                                let authtoken = JSON.parse(resRR.data.body);
                                                console.log("Key Parsed Token:", authtoken);
                                                let accessToken = authtoken.access_token;
                                                console.log("Access Token Received :: ", accessToken);
                                                if (accessToken) {
                                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE email = '" + (0, markError_1.parseBody)(sdata.email) + "' OR username = '" + (0, markError_1.parseBody)(sdata.email) + "'";
                                                    obj.prepare();
                                                    obj.execute((_error, getEmail) => {
                                                        if (_error == 1) {
                                                            if (getEmail.length > 0) {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    message: "Email Or Username Already Exists!",
                                                                    status: 404
                                                                });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objp = new RawQuery_1.ModelRawQuery(req, res);
                                                                let Qry = '';
                                                                if (reseller_id) {
                                                                    Qry = "SELECT `idservice` FROM `reseller` WHERE iduser=" + reseller_id + "";
                                                                }
                                                                else {
                                                                    Qry = "SELECT `idservice` FROM `service` WHERE iduser=1 AND `is_default`='true'";
                                                                }
                                                                objp.qrysql = Qry;
                                                                objp.prepare();
                                                                objp.execute((errservp, _resp) => {
                                                                    let service_id = _resp?.[0]?.idservice != null ? _resp[0].idservice : 0;
                                                                    //hash password
                                                                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj2.nonqrysql = "CALL AddUserNext(-1, -1, '" + (0, markError_1.parseBody)(sdata.email) + "','2','" + (0, markError_1.parseBody)(sdata.firstName).trim() + "','" + (0, markError_1.parseBody)(sdata.lastName).trim() + "','" + (0, markError_1.parseBody)(sdata.email) + "',' ','" + sdata.imgUrl + "','1', " + (0, markError_1.setToZero)(tariff) + ", " + (0, markError_1.setToZero)(sdata.tariff2) + ", '" + ustatus + "', " + (0, markError_1.setToZero)(service_id) + ", 0)";
                                                                    obj2.prepare();
                                                                    obj2.execute((__error, __res) => {
                                                                        let iduser = __res[0];
                                                                        if (__error == 1) {
                                                                            const numeric = '0123456789';
                                                                            let popin = '';
                                                                            for (let i = 0; i < 4; i++) {
                                                                                popin += numeric[Math.floor(Math.random() * numeric.length)];
                                                                            }
                                                                            popin = popin.split('').sort(() => Math.random() - 0.5).join('');
                                                                            // To Update User
                                                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj3.nonqrysql = "UPDATE `user` SET `trust_score`='1',`validationKey`='" + validationKey + "', `secret`='" + secret + "', `isPlan`='" + isPlan + "', `idtariff`=" + (0, markError_1.setToZero)(tariff) + ",`ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "',`resetPassword`='1',`reseller_iduser`=" + (0, markError_1.setToZero)(reseller_id) + ",`signup_link_id`='" + signUpLinkUrl + "',`newUser_status`='1',`email_verification_date`=NOW() WHERE `iduser`=" + iduser[0].userid + "";
                                                                            obj3.prepare();
                                                                            obj3.execute((_err, __result) => {
                                                                                if (_err == 1) {
                                                                                    console.log("User Updated Successfully!");
                                                                                }
                                                                                else {
                                                                                    console.log("Error With Update User!");
                                                                                }
                                                                            });
                                                                            // To Update Account
                                                                            let objA = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            objA.nonqrysql = "UPDATE `account` SET `san`=(100000000 + " + iduser[0].account + "),`portoutpin`='" + popin + "' WHERE `idaccount`=" + iduser[0].account + "";
                                                                            objA.prepare();
                                                                            objA.execute((_errAccount, __resultAccount) => {
                                                                                if (_errAccount == 1) {
                                                                                    console.log("San Number Updated.");
                                                                                }
                                                                                else {
                                                                                    console.log("Error With SAN Number!");
                                                                                }
                                                                            });
                                                                            // To Insert Account owner category
                                                                            let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj5.nonqrysql = "INSERT INTO `notification_subscriber_email`(`idaccount`,`iduser`,`nec_id`,`email`) VALUES (" + iduser[0].account + "," + iduser[0].userid + ",5,'" + (0, markError_1.parseBody)(sdata.email) + "')";
                                                                            obj5.prepare();
                                                                            obj5.execute((_err, __result) => {
                                                                                if (_err == 1) {
                                                                                    console.log("Email Inserted Successfully!");
                                                                                }
                                                                                else {
                                                                                    console.log("Error With insert Email!");
                                                                                }
                                                                            });
                                                                            // To Insert Account Services
                                                                            const um = new UserManagement();
                                                                            um.accountServices(req, res, iduser[0].account, (errorr, resp) => {
                                                                                if (resp.status == 200) {
                                                                                    console.log("Services Inserted Successfully.");
                                                                                }
                                                                                else {
                                                                                    console.log("Something went wrong in account service insertion!");
                                                                                }
                                                                            });
                                                                            // To save search api_rate
                                                                            let data = { iduser: iduser[0].userid, idaccount: iduser[0].account, req_type: 1, type: 2 };
                                                                            um.saveApiRate(req, res, data, (errorr, resp) => {
                                                                            });
                                                                            // To Create Connection
                                                                            const connection_key = Str.random(30);
                                                                            const randDigit = connection_key.slice(4, 12);
                                                                            var rdata = [];
                                                                            let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                                            obj2.filter = null;
                                                                            const val = Math.floor(1000 + Math.random() * 9000);
                                                                            let username = Math.random().toString(36).substr(2, 11);
                                                                            let password = generatePassword();
                                                                            const inbound_key = Str.random(30);
                                                                            const outbound_key = Str.random(30);
                                                                            const val1 = Math.floor(1000 + Math.random() * 9000);
                                                                            const connName = (0, markError_1.parseBody)(sdata.firstName).trim() + val1;
                                                                            obj2.qrysql = "CALL addconnection(" + iduser[0].account + ", " + iduser[0].userid + ", '" + (0, markError_1.parseBody)(connName) + "', '" + connection_key + "', '" + (0, markError_1.parseBody)(username) + "', '" + (0, markError_1.parseBody)(password) + "', '" + inbound_key + "', '" + outbound_key + "', 'true')";
                                                                            obj2.prepare();
                                                                            obj2.execute((__error, allcamp) => {
                                                                                if (__error == 1) {
                                                                                    console.log("Connection Created Successfully.");
                                                                                }
                                                                                else {
                                                                                    console.log("Registered Successfully! But Default Connection Not Created!");
                                                                                }
                                                                            });
                                                                            // To Update Billing Address
                                                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj.nonqrysql = "INSERT INTO `billing_address` (`idaccount`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`,`customerType`, `businessName`, `ein`, `website`, `title`, `groupExmpt_number`) VALUES ('" + iduser[0].account + "', '" + (0, markError_1.parseBody)(sdata.first_name).trim() + "', '" + (0, markError_1.parseBody)(sdata.last_name).trim() + "', '" + sdata.contact_number + "', '" + (0, markError_1.parseBody)(sdata.email) + "', '" + (0, markError_1.parseBody)(sdata.address1) + "', '" + (0, markError_1.parseBody)(sdata.address2) + "', '" + (0, markError_1.parseBody)(sdata.city) + "', '" + (0, markError_1.parseBody)(sdata.state) + "', '" + (0, markError_1.parseBody)(sdata.postal_code) + "', '" + sdata.country + "', '" + sdata.customerType + "', '" + (0, markError_1.parseBody)(sdata.businessName) + "', '" + (0, markError_1.parseBody)(sdata.ein) + "', '" + (0, markError_1.parseBody)(sdata.website) + "', '" + (0, markError_1.parseBody)(sdata.title) + "', " + (0, markError_1.setToZero)(sdata.groupExmpt_number) + ")";
                                                                            obj.prepare();
                                                                            obj.execute((_error, data) => {
                                                                                if (__error == 1) {
                                                                                    console.log("Billing Address Added Successfully.");
                                                                                }
                                                                                else {
                                                                                    console.log("Billing Address Not Added!");
                                                                                }
                                                                            });
                                                                            // To Update Timezone
                                                                            let objTime = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            objTime.nonqrysql = "INSERT INTO `tbl_timezone_config` SET `id_timezone`=16, id_user=" + iduser[0].userid + "";
                                                                            objTime.prepare();
                                                                            objTime.execute((errTime, sTime) => {
                                                                                if (errTime == 1) {
                                                                                    console.log("Time Zone Updated!");
                                                                                }
                                                                                else {
                                                                                    console.log("Registered Successfully! But Default Time Zone has error!");
                                                                                }
                                                                            });
                                                                            // To Send Mail To Support
                                                                            let objsup = new RawQuery_1.ModelRawQuery(req, res);
                                                                            objsup.qrysql = "SELECT `subject`,`template`,`cc`,`bcc` FROM `email_template` WHERE type='signup_notification_to_support'";
                                                                            objsup.prepare();
                                                                            objsup.execute((emlErr, emlRes) => {
                                                                                if (emlErr == 1) {
                                                                                    if (emlRes.length > 0) {
                                                                                        let objsu = new RawQuery_1.ModelRawQuery(req, res);
                                                                                        objsu.qrysql = "SELECT rp.firstname, rp.lastname, r.organization_name FROM reseller_profile rp JOIN reseller r ON rp.iduser = r.iduser WHERE rp.iduser = '" + reseller_id + "';";
                                                                                        objsu.prepare();
                                                                                        objsu.execute((err, resp) => {
                                                                                            let tmpDataSup = emlRes[0].template;
                                                                                            let san = Math.floor(Math.floor(100000000) + Math.floor(iduser[0].account));
                                                                                            tmpDataSup = tmpDataSup.replace(/{SAN_NUMBER}/g, san);
                                                                                            tmpDataSup = tmpDataSup.replace(/{FIRST_NAME}/g, sdata.firstName);
                                                                                            tmpDataSup = tmpDataSup.replace(/{LAST_NAME}/g, sdata.lastName);
                                                                                            tmpDataSup = tmpDataSup.replace(/{EMAIL}/g, sdata.email);
                                                                                            if (reseller_id) {
                                                                                                if (err == 1) {
                                                                                                    tmpDataSup = tmpDataSup.replace(/{Reseller Organization}/g, 'Reseller Organization');
                                                                                                    tmpDataSup = tmpDataSup.replace(/{RESELLER_BUSINESS_NAME}/g, resp[0].organization_name);
                                                                                                    tmpDataSup = tmpDataSup.replace(/{Reseller Contact}/g, 'Reseller Contact');
                                                                                                    tmpDataSup = tmpDataSup.replace(/{RESELLER_FIRST_NAME}/g, resp[0].firstname);
                                                                                                    tmpDataSup = tmpDataSup.replace(/{RESELLER_LAST_NAME}/g, resp[0].lastname);
                                                                                                    tmpDataSup = tmpDataSup.replace(/{Registration Link Name}/g, 'Registration Link Name');
                                                                                                    tmpDataSup = tmpDataSup.replace(/{REGISTRATION_LINK_NAME}/g, signUpLinkUrl);
                                                                                                }
                                                                                                else {
                                                                                                    console.log("Data fetching error for reselelr");
                                                                                                }
                                                                                            }
                                                                                            else {
                                                                                                tmpDataSup = tmpDataSup.replace(/{Reseller Organization}/g, '');
                                                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_BUSINESS_NAME}/g, '');
                                                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_FIRST_NAME}/g, '');
                                                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_LAST_NAME}/g, '');
                                                                                                tmpDataSup = tmpDataSup.replace(/{Reseller Contact}/g, '');
                                                                                                tmpDataSup = tmpDataSup.replace(/{REGISTRATION_LINK_NAME}/g, '');
                                                                                                tmpDataSup = tmpDataSup.replace(/{Registration Link Name}/g, '');
                                                                                            }
                                                                                            let obj10 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                            const Spmail = supportEmail.split(",");
                                                                                            let qry = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES";
                                                                                            for (let i = 0; i < Spmail.length; i++) {
                                                                                                let entry = Spmail[i];
                                                                                                qry += "(" + iduser[0].userid + "," + iduser[0].account + ",'" + FromEmail + "','" + (0, markError_1.parseBody)(entry) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','New User Signup', '" + (0, markError_1.parseBody)(tmpDataSup) + "','New User Signup','1','" + emlRes[0].cc + "','" + emlRes[0].bcc + "'),";
                                                                                            }
                                                                                            obj10.nonqrysql = qry.slice(0, -1);
                                                                                            obj10.prepare();
                                                                                            obj10.execute((_err, __result) => {
                                                                                                if (_err == 1) {
                                                                                                    console.log("Mail successfully sent to support.");
                                                                                                }
                                                                                                else {
                                                                                                    console.log("Mail not sent to support.");
                                                                                                }
                                                                                            });
                                                                                        });
                                                                                    }
                                                                                    else {
                                                                                        console.log("No Email Template Available For Support Notification.");
                                                                                    }
                                                                                }
                                                                                else {
                                                                                    console.log("Something Went Wrong With Get Email Template.");
                                                                                }
                                                                            });
                                                                            let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                                                            obj4.qrysql = "SELECT body, otp_digit, tmp_type FROM `2fa_template` WHERE iduser=1 AND tmp_type='sms' AND `default`='1'";
                                                                            obj4.prepare();
                                                                            obj4.execute((errOtp, _res) => {
                                                                                let message = "";
                                                                                let otp_digit = "";
                                                                                let temp_type = "";
                                                                                let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
                                                                                let temp_key = '';
                                                                                let charactersLength = characters.length;
                                                                                for (let i = 0; i < 25; i++) {
                                                                                    temp_key += characters.charAt(Math.floor(Math.random() * charactersLength));
                                                                                }
                                                                                if (_res.length > 0) {
                                                                                    message = _res[0].body;
                                                                                    otp_digit = _res[0].otp_digit;
                                                                                    temp_type = _res[0].tmp_type;
                                                                                }
                                                                                else {
                                                                                    message = "Your One time Password is {OTP}";
                                                                                    otp_digit = "5";
                                                                                    temp_type = "sms";
                                                                                }
                                                                                let objTime = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                objTime.nonqrysql = "INSERT INTO `2fa_template`(`iduser`, `otp_digit`,`body`, `tmp_type`,`template_key`,`default`) VALUES (" + iduser[0].userid + "," + (0, markError_1.setToZero)(otp_digit) + ",'" + (0, markError_1.parseBody)(message) + "', '" + temp_type + "','" + temp_key + "','1')";
                                                                                objTime.prepare();
                                                                                objTime.execute((err, sTime) => {
                                                                                    if (err == 1) {
                                                                                        let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                                                                        obj4.qrysql = "SELECT `subject`,`template`,`cc`,`bcc` FROM `email_template` WHERE type='email_verification'";
                                                                                        obj4.prepare();
                                                                                        obj4.execute((emlErr, emlRes) => {
                                                                                            if (emlErr == 1) {
                                                                                                if (emlRes.length > 0) {
                                                                                                    let tmpData = emlRes[0].template;
                                                                                                    tmpData = tmpData.replace(/{FIRST_NAME}/g, sdata.firstName);
                                                                                                    tmpData = tmpData.replace(/{LAST_NAME}/g, sdata.lastName);
                                                                                                    tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);
                                                                                                    let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                                    obj11.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES (" + iduser[0].userid + "," + iduser[0].account + ",'" + FromEmail + "','" + (0, markError_1.parseBody)(sdata.email) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','Thank You For Registration', '" + (0, markError_1.parseBody)(tmpData) + "','Thank You For Registration','2','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                                                                    obj11.prepare();
                                                                                                    obj11.execute((_err, __result) => {
                                                                                                        if (_err == 1) {
                                                                                                            console.log("Email Send Successfully ::: ", { result: sdata, token: accessToken, key: validationKey, iduser: iduser[0].userid, status: 201, message: "Congratulations on your well-deserved success. Account Successfully Created And Email Sent To Your " + sdata.email });
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ result: sdata, token: accessToken, refresh_token: authtoken.refresh_token, key: validationKey, iduser: iduser[0].userid, status: 201, message: "Congratulations on your well-deserved success. Account Successfully Created And Email Sent To Your " + sdata.email });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ status: 401, message: "Registered Successfully But verification Email Not Send. Kindly Contact With Support!" });
                                                                                                            objv.execute();
                                                                                                            console.log("Error In Updating Password!");
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                                else {
                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                    objv.prepare({ message: "Registered Successfully. Email Template Not Available!", status: 502 });
                                                                                                    objv.execute();
                                                                                                }
                                                                                            }
                                                                                            else {
                                                                                                let objv = new RawView_1.RawView(res);
                                                                                                objv.prepare({ message: "Registered But Error With Fetching Email Data!", status: 502 });
                                                                                                objv.execute();
                                                                                            }
                                                                                        });
                                                                                    }
                                                                                    else {
                                                                                        let objv = new RawView_1.RawView(res);
                                                                                        objv.prepare({ message: "Template not Inserted Successfully!", status: 502 });
                                                                                        objv.execute();
                                                                                    }
                                                                                });
                                                                            });
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Something Went Wrong with Signup!", status: 502 });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                });
                                                            }
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Something Went with Connection!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 401, message: "Token validation failed." });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                console.log("Keycloak Login User Failed While Signup::: ", resR);
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare(resRR);
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        console.log("Keycloak Create User Failed ::: ", resR);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare(resR);
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: (0, markError_1.checkPassword)(passwd),
                                    status: 501
                                });
                                objv.execute();
                            }
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Invalid Email Address ", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid First Name or Last Name ", status: 502 });
                objv.execute();
            }
        }
    }
    accountServices(req, res, idaccount, callback) {
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT `fs_id`,`fs_name` FROM `feature_service`";
        obj.prepare();
        obj.execute((_error, result) => {
            let qry = "INSERT INTO `account_service` (`idaccount`,`fs_id`,`as_status`) VALUES";
            result.forEach((ele) => {
                qry += "(" + idaccount + "," + ele.fs_id + ",'1'),";
            });
            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
            obj.nonqrysql = qry.slice(0, -1);
            obj.prepare();
            obj.execute((_err, data) => {
                if (_err == 1) {
                    callback(1, { message: "Account services inserted successfully!", status: 200 });
                }
                else {
                    callback(0, { message: "Something went wrong!", status: 502 });
                }
            });
        });
    }
    saveApiRate(req, res, data, callback) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj.nonqrysql = "INSERT INTO `api_rate_limit` (`iduser`, `idaccount`, `req_type`, `type`) VALUES (" + data.iduser + "," + data.idaccount + "," + data.req_type + "," + data.type + ")";
        obj.prepare();
        obj.execute((err, dataa) => {
            if (err == 1) {
                console.log(1, { status: 200, message: "API Rate saved successfully!" });
            }
            else {
                console.log(0, { status: 502, message: "API Rate not saved!" });
            }
        });
    }
    AdminSave(req, res, next) {
        // const ipAddress = req.socket.remoteAddress;
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        let sdataa;
        let subscriptiondata;
        let sdata;
        let filePath = "https://portal.signalmash.com/assets/img/icon.png";
        try {
            sdataa = JSON.parse(req.body.data);
            sdata = sdataa.cdata;
            subscriptiondata = sdataa.subscriptionid;
        }
        catch (e) {
            console.log("Error :: AdminSave::", e);
            sdataa = JSON.parse(req.body.data);
            sdata = sdataa.cdata;
            subscriptiondata = sdataa.subscriptionid;
        }
        ;
        if (req.file) {
            const fileName = req.file.filename;
            filePath = msAPIURL.SignalmashAPIURL + '/uploads/' + fileName;
        }
        if (sdata.profile_pic) {
            filePath = sdata.profile_pic;
        }
        let passwd = sdata.password.trim();
        let session = new Session_1.SessionManagment(req, res, next);
        let msg = "";
        let ustatus = sdata.status ? true : false;
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                if (sdata.idaccount == -1) {
                    if (passwd && (0, markError_1.checkPassword)(passwd) == '') {
                        keycloak.createUser(req, res, sdata.user_name, passwd, sdata.email, sdata.first_name, sdata.last_name, (errorR, resR) => {
                            if (errorR == 1) {
                                /**
                                * To add/save customer from admin side
                                */
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                obj.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE username = '" + (0, markError_1.parseBody)(sdata.user_name) + "' OR email = '" + (0, markError_1.parseBody)(sdata.email) + "'";
                                obj.prepare();
                                obj.execute((_error, getUser) => {
                                    if (_error == 1) {
                                        if (getUser.length > 0) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "Username or Email Already Exists!",
                                                status: 404
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            let planVerify = sdata.tariff1 ? 'true' : 'false';
                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj1.nonqrysql = "CALL AddUserNext(-1, -1, '" + (0, markError_1.parseBody)(sdata.user_name) + "','" + sdata.type + "','" + (0, markError_1.parseBody)(sdata.first_name) + "','" + (0, markError_1.parseBody)(sdata.last_name) + "','" + (0, markError_1.parseBody)(sdata.email) + "','" + sdata.contact_number + "','" + filePath + "','1', " + (0, markError_1.setToZero)(sdata.tariff1) + ", " + (0, markError_1.setToZero)(sdata.tariff2) + ", '" + ustatus + "', " + (0, markError_1.setToZero)(sdata.service) + ", " + (0, markError_1.setToZero)(sdata.credit_limit) + ")";
                                            if (sdata.type == 2) {
                                                msg = "Customer Added Successfully.";
                                            }
                                            if (sdata.type == 3) {
                                                msg = "Supplier Added Successfully.";
                                            }
                                            obj1.prepare();
                                            obj1.execute((__error, result) => {
                                                if (__error == 1) {
                                                    let newRes = result[0];
                                                    // To Create Customer
                                                    const connection_key = Str.random(30);
                                                    const randDigit = connection_key.slice(4, 12);
                                                    var rdata = [];
                                                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj2.filter = null;
                                                    const val = Math.floor(1000 + Math.random() * 9000);
                                                    let username = Math.random().toString(36).substr(2, 11);
                                                    let password = generatePassword();
                                                    const inbound_key = Str.random(30);
                                                    const outbound_key = Str.random(30);
                                                    const val1 = Math.floor(1000 + Math.random() * 9000);
                                                    const connName = (0, markError_1.parseBody)(sdata.first_name) + val1;
                                                    obj2.qrysql = "CALL addconnection(" + newRes[0].account + ", " + newRes[0].userid + ", '" + (0, markError_1.parseBody)(connName) + "', '" + connection_key + "', '" + (0, markError_1.parseBody)(username) + "', '" + (0, markError_1.parseBody)(password) + "', '" + inbound_key + "', '" + outbound_key + "', 'true')";
                                                    obj2.prepare();
                                                    obj2.execute((__error, allcamp) => {
                                                        if (__error == 1) {
                                                            console.log("Connection Created Successfully.");
                                                        }
                                                        else {
                                                            console.log("Connection Not Created!");
                                                        }
                                                    });
                                                    // To Update Billing Address
                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj.nonqrysql = "INSERT INTO `billing_address` (`idaccount`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`,`customerType`, `businessName`, `ein`, `website`, `title`, `groupExmpt_number`) VALUES ('" + newRes[0].account + "', '" + (0, markError_1.parseBody)(sdata.first_name) + "', '" + (0, markError_1.parseBody)(sdata.last_name) + "', '" + sdata.contact_number + "', '" + (0, markError_1.parseBody)(sdata.email) + "', '" + (0, markError_1.parseBody)(sdata.address1) + "', '" + (0, markError_1.parseBody)(sdata.address2) + "', '" + (0, markError_1.parseBody)(sdata.city) + "', '" + (0, markError_1.parseBody)(sdata.state) + "', '" + (0, markError_1.parseBody)(sdata.postal_code).trim() + "', '" + sdata.country + "', '" + sdata.customerType + "', '" + (0, markError_1.parseBody)(sdata.businessName) + "', '" + (0, markError_1.parseBody)(sdata.ein) + "', '" + (0, markError_1.parseBody)(sdata.website) + "', '" + (0, markError_1.parseBody)(sdata.title) + "', " + (0, markError_1.setToZero)(sdata.groupExmpt_number) + ")";
                                                    obj.prepare();
                                                    obj.execute((_error, data) => {
                                                        if (__error == 1) {
                                                            console.log("Billing Address Added Successfully.");
                                                        }
                                                        else {
                                                            console.log("Billing Address Not Added!");
                                                        }
                                                    });
                                                    const numeric = '0123456789';
                                                    let popin = '';
                                                    for (let i = 0; i < 4; i++) {
                                                        popin += numeric[Math.floor(Math.random() * numeric.length)];
                                                    }
                                                    popin = popin.split('').sort(() => Math.random() - 0.5).join('');
                                                    // To Update User
                                                    let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj11.nonqrysql = "UPDATE `user` SET `trust_score`='1',`isEmailVerify`='" + sdata.isEmailVerify + "',`isMobileVerify`='" + sdata.isMobileVerify + "', `isPlan`= '" + planVerify + "', `isAddress`='" + sdata.isAddress + "', `ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "',`isCard`='false',`newUser_status`='1',`resetPassword`='1',`reseller_iduser`=" + (0, markError_1.setToZero)(sdata.reseller_id) + " WHERE `idaccount`=" + newRes[0].account + "";
                                                    obj11.prepare();
                                                    obj11.execute((_errorrr, resultt) => {
                                                        if (_errorrr == 1) {
                                                            console.log("User Updated Successfully.");
                                                        }
                                                        else {
                                                            console.log("User Not Updated!");
                                                        }
                                                    });
                                                    let obj15 = new UserManagement();
                                                    obj15.sendEmailVerify(req, res, sdata, newRes, next);
                                                    // To Update Account
                                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj3.nonqrysql = "UPDATE `account` SET `san`=(100000000 + " + newRes[0].account + "),`portoutpin`='" + popin + "' WHERE `idaccount`=" + newRes[0].account + "";
                                                    obj3.prepare();
                                                    obj3.execute((_uperr, __result) => {
                                                        if (_uperr == 1) {
                                                            console.log("Account Updated Successfully.");
                                                        }
                                                        else {
                                                            console.log("Account Not Updated!");
                                                        }
                                                    });
                                                    // To insert Account owner category
                                                    let obj12 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj12.nonqrysql = "INSERT INTO `notification_subscriber_email`(`idaccount`,`iduser`,`nec_id`,`email`) VALUES (" + newRes[0].account + "," + newRes[0].userid + ",5,'" + (0, markError_1.parseBody)(sdata.email) + "')";
                                                    obj12.prepare();
                                                    obj12.execute((_err, __result) => {
                                                        if (_err == 1) {
                                                            console.log("Email Inserted Successfully!");
                                                        }
                                                        else {
                                                            console.log("Error With insert Email!");
                                                        }
                                                    });
                                                    // To Insert Account Services
                                                    const um = new UserManagement();
                                                    um.accountServices(req, res, newRes[0].account, (errorr, resp) => {
                                                        if (resp.status == 200) {
                                                            console.log("Services Inserted Successfully.");
                                                        }
                                                        else {
                                                            console.log("Something went wrong in account service insertion!");
                                                        }
                                                    });
                                                    // To save search api_rate
                                                    let data = { iduser: newRes[0].userid, idaccount: newRes[0].account, req_type: 1, type: 2 };
                                                    um.saveApiRate(req, res, data, (errorr, resp) => {
                                                    });
                                                    /* if (subscriptiondata !== null && subscriptiondata !== undefined) {
                                                    let subscriptionmap = new SubscriptionManagement();
                                                    subscriptionmap.Savesuscriptioncontrolmapping(req, res, subscriptiondata, newRes[0].account, (err: any) => {
                                                    if (err == 0) {
                                                    console.log("Something went Wrong");
                                                    } else {
                                                    console.log("Subscription Data Saved");
                                                    }
                                                    });
                                                    } */
                                                    // To Insert Timezone Config
                                                    let objTime = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    objTime.nonqrysql = "INSERT INTO `tbl_timezone_config` SET `id_timezone`=16, id_user=" + newRes[0].userid + "";
                                                    objTime.prepare();
                                                    objTime.execute((errTime, sTime) => {
                                                        if (errTime == 1) {
                                                            console.log("Time Zone Inserted Successfully.");
                                                        }
                                                        else {
                                                            console.log("Time Zone Not Inserted!");
                                                        }
                                                    });
                                                    let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj4.qrysql = "SELECT body, otp_digit, tmp_type FROM `2fa_template` WHERE iduser=1 AND tmp_type='sms' AND `default`='1'";
                                                    obj4.prepare();
                                                    obj4.execute((sessdata, _res) => {
                                                        let message = "";
                                                        let otp_digit = "";
                                                        let temp_type = "";
                                                        let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
                                                        let temp_key = '';
                                                        let charactersLength = characters.length;
                                                        for (let i = 0; i < 25; i++) {
                                                            temp_key += characters.charAt(Math.floor(Math.random() * charactersLength));
                                                        }
                                                        if (_res.length > 0) {
                                                            message = _res[0].body;
                                                            otp_digit = _res[0].otp_digit;
                                                            temp_type = _res[0].tmp_type;
                                                        }
                                                        else {
                                                            message = "Your One time Password is {OTP}";
                                                            otp_digit = "5";
                                                            temp_type = "sms";
                                                        }
                                                        let objTime = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        objTime.nonqrysql = "INSERT INTO `2fa_template`(`iduser`, `otp_digit`,`body`, `tmp_type`,`template_key`,`default`) VALUES (" + newRes[0].userid + "," + (0, markError_1.setToZero)(otp_digit) + ",'" + (0, markError_1.parseBody)(message) + "', '" + temp_type + "','" + temp_key + "','1')";
                                                        objTime.prepare();
                                                        objTime.execute((err, sTime) => {
                                                            if (err == 1) {
                                                                console.log("Default Template Created.");
                                                            }
                                                            else {
                                                                console.log("Template Not Created!");
                                                            }
                                                        });
                                                    });
                                                    keycloak.sendVerifyEmail(req, res, sdata.user_name, sdata.isEmailVerify, '0', (errRess, dataRess) => {
                                                        console.log(errRess, dataRess);
                                                    });
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ data: result[0], message: "Customer Created Successfully!", status: 201 });
                                                    objv.execute();
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ data: result[0], message: "Customer Not Created!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With User Name Or Email Checking!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                console.log("Keycloak Create User Failed While Admin Create User::: ", resR);
                                let objv = new RawView_1.RawView(res);
                                objv.prepare(resR);
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: (0, markError_1.checkPassword)(passwd),
                            status: 501
                        });
                        objv.execute();
                    }
                }
                else {
                    /**
                    * To add/save subcustomer of customer from admin side
                    */
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT up.email ,u. username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE username = '" + (0, markError_1.parseBody)(sdata.user_name) + "' OR email = '" + (0, markError_1.parseBody)(sdata.email) + "'";
                    obj.prepare();
                    obj.execute((_error, getUser) => {
                        if (_error == 1) {
                            if (getUser.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Username or Email Already Exists!", status: 404 });
                                objv.execute();
                            }
                            else {
                                keycloak.createUser(req, res, sdata.user_name, passwd, sdata.email, sdata.first_name, sdata.last_name, (errorR, resR) => {
                                    if (errorR == 1) {
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "CALL AddUserNext('" + sdata.idaccount + "', -1, '" + (0, markError_1.parseBody)(sdata.user_name) + "','" + sdata.type + "','" + (0, markError_1.parseBody)(sdata.first_name) + "','" + (0, markError_1.parseBody)(sdata.last_name) + "','" + (0, markError_1.parseBody)(sdata.email) + "','" + sdata.contact_number + "','" + filePath + "','0', " + (0, markError_1.setToZero)(sdata.tariff1) + "," + (0, markError_1.setToZero)(sdata.tariff2) + ", '" + ustatus + "', " + (0, markError_1.setToZero)(sdata.service) + ", " + (0, markError_1.setToZero)(sdata.credit_limit) + ")";
                                        if (sdata.type == 2) {
                                            msg = "Customer Updated Successfully";
                                        }
                                        if (sdata.type == 3) {
                                            msg = "Supplier Updated Successfully";
                                        }
                                        obj1.prepare();
                                        obj1.execute((_error, result) => {
                                            if (_error == 1) {
                                                let newRes = result[0];
                                                // To Create Customer
                                                const connection_key = Str.random(30);
                                                const randDigit = connection_key.slice(4, 12);
                                                var rdata = [];
                                                let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                                obj2.filter = null;
                                                const val = Math.floor(1000 + Math.random() * 9000);
                                                let username = Math.random().toString(36).substr(2, 11);
                                                let password = generatePassword();
                                                const inbound_key = Str.random(30);
                                                const outbound_key = Str.random(30);
                                                const val1 = Math.floor(1000 + Math.random() * 9000);
                                                const connName = (0, markError_1.parseBody)(sdata.first_name) + val1;
                                                obj2.qrysql = "CALL addconnection(" + newRes[0].account + ", " + newRes[0].userid + ", '" + (0, markError_1.parseBody)(connName) + "', '" + connection_key + "', '" + (0, markError_1.parseBody)(username) + "', '" + (0, markError_1.parseBody)(password) + "', '" + inbound_key + "', '" + outbound_key + "', 'true')";
                                                obj2.prepare();
                                                obj2.execute((__error, allcamp) => {
                                                    if (__error == 1) {
                                                        console.log("Connection Created Successfully.");
                                                    }
                                                    else {
                                                        console.log("Connection Not Created!");
                                                    }
                                                });
                                                // To save search api_rate
                                                const um = new UserManagement();
                                                let data = { iduser: newRes[0].userid, idaccount: newRes[0].account, req_type: 1, type: 22 };
                                                um.saveApiRate(req, res, data, (errorr, resp) => {
                                                });
                                                /* if (subscriptiondata !== null && subscriptiondata !== undefined) {
                                                let subscriptionmap = new SubscriptionManagement();
                                                subscriptionmap.Savesuscriptioncontrolmapping(req, res, subscriptiondata, newRes[0].account, (err: any) => {
                                                if (err == 0) {
                                                console.log("Something went Wrong");
                                                } else {
                                                console.log("Subscription Data Saved");
                                                }
                                                });
                                                } */
                                                if (sdata.type == 22) {
                                                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj0.qrysql = "SELECT `idtariff`,`idservice` FROM `user` WHERE idaccount = " + sdata.idaccount + "";
                                                    obj0.prepare();
                                                    obj0.execute((_errorser, getSer) => {
                                                        if (_errorser == 1) {
                                                            let service = getSer.length > 0 && getSer[0].idservice ? getSer[0].idservice : 0;
                                                            let idtariff = getSer.length > 0 && getSer[0].idtariff ? getSer[0].idtariff : 0;
                                                            let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj11.nonqrysql = "UPDATE `user` SET `idtariff`=" + (0, markError_1.setToZero)(idtariff) + ",`idservice`=" + (0, markError_1.setToZero)(service) + ",`isAddress`='true',`isCard`='true',`newUser_status`='" + sdata.newUser_status + "',`resetPassword`='1', `ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "' WHERE `iduser`=" + newRes[0].userid + "";
                                                            obj11.prepare();
                                                            obj11.execute((_errorrr, resultt) => {
                                                                if (_errorrr == 1) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ data: resultt[0], message: "Sub Customer Created Successfully!", status: 201 });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ data: resultt, message: "Something Went Wrong With Connection!", status: 502 });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Something Went Wrong With Tarif And Service!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ data: result[0], message: "Profile Updated Successfully!", status: 201 });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        console.log("Keycloak Create User Failed While Admin Create User:: ", resR);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare(resR);
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With User Name Or Email Checking!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    SaveUser(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let sdata;
                let filePath = "https://portal.signalmash.com/assets/img/icon.png";
                try {
                    sdata = JSON.parse(req.body.data);
                }
                catch (e) {
                    sdata = req.body.data;
                }
                if (req.file) {
                    const fileName = req.file.filename;
                    // var filePath = req.protocol + '://' + req.get("host") + "/uploads/" + fileName;
                    filePath = msAPIURL.SignalmashAPIURL + '/uploads/' + fileName;
                }
                if (sdata.profile_pic != null || sdata.profile_pic != undefined) {
                    filePath = sdata.profile_pic;
                }
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let ustatus = sdata.status ? true : false;
                let objj1 = new RawQuery_1.ModelRawQuery(req, res);
                objj1.qrysql = "SELECT `ip_address`, `email`, `domain_name`, `first_name`, `last_name`, `contact` FROM `domain_block` WHERE `ip_address` = '" + sysInfo.ipAddress[0] + "' OR `email` = '" + (0, markError_1.parseBody)(sdata.email) + "' OR `first_name` = '" + (0, markError_1.parseBody)(sdata.first_name).trim() + "' OR `last_name` = '" + (0, markError_1.parseBody)(sdata.last_name).trim() + "' OR `domain_name` = '" + sdata.email.split('@')[1] + "' OR `contact`='" + sdata.contact_number + "'";
                objj1.prepare();
                objj1.execute((_errDomainBlk, getDomainBlock) => {
                    if (_errDomainBlk == 1 && getDomainBlock.length > 0) {
                        let errMsg = '';
                        if (getDomainBlock[0].email == sdata.email)
                            errMsg = "Please use valid business email and not a generic personal email to sign up.";
                        else if (getDomainBlock[0].domain_name == sdata.email.split('@')[1])
                            errMsg = "Please use valid business email and not a generic personal email to sign up.";
                        else if (getDomainBlock[0].first_name == sdata.first_name)
                            errMsg = "Unable to complete your registration, please contact support for further assistance.";
                        else if (getDomainBlock[0].last_name == sdata.last_name)
                            errMsg = "Unable to complete your registration, please contact support for further assistance.";
                        else if (getDomainBlock[0].ipAddress == sdata.ipAddress)
                            errMsg = "Unable to complete your registration, please contact support for further assistance.";
                        else if (getDomainBlock[0].contact == sdata.contact_number)
                            errMsg = "Unable to complete your registration, please contact support for further assistance.";
                        else
                            errMsg = "You Can't Register With Invalid Details!";
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: errMsg,
                            status: 501
                        });
                        objv.execute();
                    }
                    else {
                        if (sdata.iduser == -1) {
                            /**
                            * To save/add subcustomer of customer from customer side
                            */
                            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT up.email ,u.username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE username = '" + (0, markError_1.parseBody)(sdata.user_name) + "'";
                            obj1.prepare();
                            obj1.execute((_error, result) => {
                                console.log("Same User Data :::::", result);
                                let username = (result.length > 0) ? result[0].username : '';
                                if (_error == 1) {
                                    // if(result.length > 0){
                                    if (username == sdata.user_name) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "Username Already Exists!",
                                            status: 404
                                        });
                                        objv.execute();
                                        return;
                                    }
                                    else {
                                        let type = (Array.isArray(sdata.type) && sdata.type.length > 0 && sdata.type[0].hasOwnProperty('user_type')) ? sdata.type[0].user_type : sdata.type;
                                        console.log("Add Section :::: ", type);
                                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj0.qrysql = "SELECT `idtariff`,`idservice` FROM `user` WHERE idaccount = " + sdata.idaccount + " LIMIT 1";
                                        obj0.prepare();
                                        obj0.execute((_errorser, getSer) => {
                                            if (_errorser == 1) {
                                                let service = getSer.length > 0 && getSer[0].idservice ? getSer[0].idservice : 0;
                                                let idtariff = getSer.length > 0 && getSer[0].idtariff ? getSer[0].idtariff : 0;
                                                let obj12 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj12.nonqrysql = "INSERT INTO `user` SET `idaccount`='" + sessdata.idaccount + "', `username`='" + (0, markError_1.parseBody)(sdata.user_name) + "', `type`='" + type + "', `default`='0', idtariff=" + (0, markError_1.setToZero)(idtariff) + ",`idservice`=" + (0, markError_1.setToZero)(service) + ",`isAddress`='true', `status`= '" + ustatus + "', `isEmailVerify`='true', `isMobileVerify`='true', `isPlan`='true', isCard='true',`newUser_status`='1',`resetPassword`='1',`ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "'";
                                                obj12.prepare();
                                                obj12.execute((errorrr, resultt) => {
                                                    if (errorrr == 1) {
                                                        let iduser = resultt.insertId;
                                                        let obj13 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj13.nonqrysql = "INSERT INTO `user_profile` SET `iduser`='" + iduser + "',`account_id` = '" + sessdata.idaccount + "',`firstname`='" + (0, markError_1.parseBody)(sdata.first_name) + "', `lastname`='" + (0, markError_1.parseBody)(sdata.last_name) + "', `email`='" + (0, markError_1.parseBody)(sdata.email) + "', `phone`='" + sdata.contact_number + "',`profile_pic`='" + filePath + "'";
                                                        obj13.prepare();
                                                        obj13.execute((errup, resup) => {
                                                            if (errup == 1) {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ data: resultt[0], message: "Customer Created Successfully!", status: 201 });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ data: resultt[0], message: "Customer created successfully but profile not created!", status: 505 });
                                                                objv.execute();
                                                            }
                                                        });
                                                        let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                                                        obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='multi_user_password_setup'";
                                                        obj5.prepare();
                                                        obj5.execute((emlErr, emlRes) => {
                                                            if (emlErr == 1) {
                                                                if (emlRes.length > 0) {
                                                                    let secret = Str.random(15);
                                                                    let validationKey = jwt.sign({
                                                                        exp: Math.floor(Date.now() / 1000) + (60 * 60),
                                                                        data: sdata.email
                                                                    }, secret);
                                                                    let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "',`isResetPassword` = 'true' WHERE `username`='" + (0, markError_1.parseBody)(sdata.user_name) + "' AND `is_deleted`=0";
                                                                    obj3.prepare();
                                                                    obj3.execute((_uperr, __result) => { });
                                                                    let tmpData = emlRes[0].template;
                                                                    tmpData = tmpData.replace(/{FIRST_NAME}/g, sdata.first_name);
                                                                    tmpData = tmpData.replace(/{LAST_NAME}/g, sdata.last_name);
                                                                    tmpData = tmpData.replace(/{PASSWORD_PAGE_LINK}/g, templateURL.URL + '/#/setpassword/' + validationKey);
                                                                    tmpData = tmpData.replace(/{USERNAME}/g, sdata.user_name);
                                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + (0, markError_1.parseBody)(sdata.email) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','Mail Send for Set User Password.', '" + (0, markError_1.parseBody)(tmpData) + "','Mail Send for Set User Password.','25','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                                    obj1.prepare();
                                                                    obj1.execute((_err, __result) => {
                                                                        if (_err == 1) {
                                                                            console.log("Email Send Successfully!");
                                                                        }
                                                                        else {
                                                                            console.log("Opps Email Not Sent!");
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    console.log("Template Data Not Found!");
                                                                }
                                                            }
                                                            else {
                                                                console.log("Something Went Wrong with DB!");
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ data: resultt[0], message: "Customer Not Created!", status: 502 });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Something Went Wrong With Get Tariff And Update User.", status: 501 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result[0], message: "Something Went Wrong With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let type = (Array.isArray(sdata.type) && sdata.type.length > 0 && sdata.type[0].hasOwnProperty('user_type')) ? sdata.type[0].user_type : sdata.type;
                            keycloak.editKeyclockuser(req, res, sdata, (errorR) => {
                                if (errorR == 1) {
                                    console.log("Edit Section :::: ", type);
                                    /**
                                    * To update subcustomer and customer from customer side and admin side
                                    */
                                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj1.qrysql = "SELECT up.email ,u.username FROM `user` u JOIN `user_profile` up ON up.iduser=u.iduser WHERE u.username = '" + (0, markError_1.parseBody)(sdata.user_name) + "' AND u.iduser != " + sdata.iduser + "";
                                    obj1.prepare();
                                    obj1.execute((_error, result) => {
                                        let username = (result.length > 0) ? result[0].username : '';
                                        if (_error == 1) {
                                            console.log(result, "resullttt updatedd");
                                            // if (result.length > 0) {
                                            if (username == sdata.user_name) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    message: "Username or Email Already Exists!",
                                                    status: 404
                                                });
                                                objv.execute();
                                            }
                                            else {
                                                if (type == 2) {
                                                    console.log("customer type :::::", type);
                                                    obj.nonqrysql = "CALL AddUserNext('" + sdata.idaccount + "', " + sdata.iduser + ", '" + (0, markError_1.parseBody)(sdata.user_name) + "','" + type + "','" + (0, markError_1.parseBody)(sdata.first_name) + "','" + (0, markError_1.parseBody)(sdata.last_name) + "','" + (0, markError_1.parseBody)(sdata.email) + "','" + sdata.contact_number + "','" + filePath + "','0', " + (0, markError_1.setToZero)(sdata.tariff1) + "," + (0, markError_1.setToZero)(sdata.tariff2) + ", '" + ustatus + "', " + (0, markError_1.setToZero)(sdata.service) + ", " + (0, markError_1.setToZero)(sdata.credit_limit) + ")";
                                                    obj.prepare();
                                                    obj.execute((_error, result) => {
                                                        if (_error == 1) {
                                                            let newRes = result[0];
                                                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                                            obj0.qrysql = "SELECT `idtariff`, `idservice` FROM `user` WHERE idaccount = " + sdata.idaccount + "";
                                                            obj0.prepare();
                                                            obj0.execute((_errorser, getSer) => {
                                                                if (_errorser == 1) {
                                                                    let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj11.nonqrysql = "UPDATE `billing_address` SET `first_name`='" + (0, markError_1.parseBody)(sdata.first_name) + "',`last_name`='" + (0, markError_1.parseBody)(sdata.last_name) + "', `contact`='" + sdata.contact_number + "',`email`='" + (0, markError_1.parseBody)(sdata.email) + "', `address1`='" + (0, markError_1.parseBody)(sdata.address1) + "', `address2`='" + (0, markError_1.parseBody)(sdata.address2) + "', `city`='" + (0, markError_1.parseBody)(sdata.city) + "', `state`='" + (0, markError_1.parseBody)(sdata.state) + "', `postal_code`='" + (0, markError_1.parseBody)(sdata.postal_code).trim() + "', `country`='" + sdata.country + "',`customerType`='" + sdata.customerType + "', `businessName`='" + (0, markError_1.parseBody)(sdata.businessName) + "', `ein`='" + (0, markError_1.parseBody)(sdata.ein) + "', `website`='" + (0, markError_1.parseBody)(sdata.website) + "', `title`='" + (0, markError_1.parseBody)(sdata.title) + "', `groupExmpt_number`=" + (0, markError_1.setToZero)(sdata.groupExmpt_number) + " WHERE `idaccount`=" + sdata.idaccount + "";
                                                                    obj11.prepare();
                                                                    obj11.execute((_errBil, resultBil) => {
                                                                        if (_errBil == 1) {
                                                                            console.log("Biilling Address Updated Successfully.");
                                                                        }
                                                                        else {
                                                                            console.log("Biilling Address Not Updated!");
                                                                        }
                                                                    });
                                                                    let service = getSer.length > 0 && getSer[0].idservice ? getSer[0].idservice : 0;
                                                                    let idtariff = getSer.length > 0 && getSer[0].idtariff ? getSer[0].idtariff : 0;
                                                                    let planVerify = (sdata.tariff1 && sdata.tariff1 !== -1) ? 'true' : 'false';
                                                                    // To send the mail
                                                                    let obj15 = new UserManagement();
                                                                    obj15.sendEmailVerify(req, res, sdata, newRes, next);
                                                                    // To Update User table
                                                                    let obj12 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj12.nonqrysql = "UPDATE `user` SET `isEmailVerify`='" + sdata.isEmailVerify + "',`isMobileVerify`='" + sdata.isMobileVerify + "', `isPlan`= '" + planVerify + "', `isAddress`='" + sdata.isAddress + "',`ipAddress`='" + sysInfo.ipAddress[0] + "',`browser`='" + sysInfo.browserName + "',`idtariff`=" + (0, markError_1.setToZero)(idtariff) + ",`idservice`=" + (0, markError_1.setToZero)(service) + ",`reseller_iduser`=" + (0, markError_1.setToZero)(sdata.reseller_id) + " WHERE `idaccount`=" + sdata.idaccount + "";
                                                                    obj12.prepare();
                                                                    obj12.execute((_errorrr, resultt) => {
                                                                        if (_errorrr == 1) {
                                                                            keycloak.sendVerifyEmail(req, res, sdata.user_name, sdata.isEmailVerify, '0', (errRess, dataRess) => {
                                                                                console.log(errRess, dataRess);
                                                                            });
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ data: resultt[0], message: "Customer Updated Successfully!", status: 201 });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ data: resultt, message: "Something Went Wrong With Customer Update!", status: 502 });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                    // To Update Email
                                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj4.nonqrysql = "UPDATE `notification_subscriber_email` SET `email`= '" + (0, markError_1.parseBody)(sdata.email) + "' WHERE `idaccount`= " + newRes[0].account + " AND `nec_id` = 5";
                                                                    obj4.prepare();
                                                                    obj4.execute((_uperr, __result) => {
                                                                        if (_uperr == 1) {
                                                                            console.log("Email Updated Successfully.");
                                                                        }
                                                                        else {
                                                                            console.log("EMail Not Updated!");
                                                                        }
                                                                    });
                                                                    // To Update Session table
                                                                    let obj13 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj13.nonqrysql = "UPDATE `session` SET `idtariff`=" + (0, markError_1.setToZero)(idtariff) + " WHERE `idaccount`=" + sdata.idaccount + "";
                                                                    obj13.prepare();
                                                                    obj13.execute((_errorS, resultS) => {
                                                                        if (_errorS == 1) {
                                                                            // let P=0;
                                                                            // To update Has table
                                                                            let objS = new RawQuery_1.ModelRawQuery(req, res);
                                                                            objS.qrysql = "SELECT `authKey` FROM `session` WHERE `idaccount`=" + sdata.idaccount + "";
                                                                            objS.prepare();
                                                                            objS.execute((errKey, delKey) => {
                                                                                if (errKey == 1) {
                                                                                    if (delKey.length > 0) {
                                                                                        for (let x of delKey) {
                                                                                            let currSess = server_1.sessiondata.get(x.authKey);
                                                                                            currSess.idtariff = idtariff;
                                                                                            server_1.sessiondata.set(x.authKey, currSess);
                                                                                        }
                                                                                    }
                                                                                }
                                                                            });
                                                                            console.log("idtariff updated successfully in session! :: ", idtariff);
                                                                        }
                                                                        else {
                                                                            console.log("idtariff not updated in session! :: ", idtariff);
                                                                        }
                                                                    });
                                                                    // To Update API table
                                                                    let obj14 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj14.nonqrysql = "UPDATE `api` SET `idtariff`=" + (0, markError_1.setToZero)(idtariff) + " WHERE `idaccount`=" + sdata.idaccount + "";
                                                                    obj14.prepare();
                                                                    obj14.execute((_errorA, resultA) => {
                                                                        if (_errorA == 1) {
                                                                            console.log("idtariff updated successfully in API! :: ", idtariff);
                                                                        }
                                                                        else {
                                                                            console.log("idtariff not updated in API table :: ", idtariff);
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong With Tariff And Service!", status: 502 });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    console.log("customer type ::::", type);
                                                    let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj11.nonqrysql = "UPDATE `user` SET `type`='" + type + "' WHERE `iduser`=" + sdata.iduser + "";
                                                    obj11.prepare();
                                                    obj11.execute((_errorrr, resultt) => {
                                                        if (_errorrr == 1) {
                                                            console.log("User Type Updated");
                                                        }
                                                        else {
                                                            console.log("User Type Not Updated!");
                                                        }
                                                    });
                                                    let obj13 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                    obj13.nonqrysql = "UPDATE `user_profile` SET `firstname`='" + (0, markError_1.parseBody)(sdata.first_name) + "', `lastname`='" + (0, markError_1.parseBody)(sdata.last_name) + "', `email`='" + (0, markError_1.parseBody)(sdata.email) + "', `phone`='" + sdata.contact_number + "' WHERE `iduser`='" + sdata.iduser + "'";
                                                    obj13.prepare();
                                                    obj13.execute((errup, resup) => {
                                                        if (errup == 1) {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Customer Updated Successfully.", status: 201 });
                                                            objv.execute();
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Something Went Wrong With Customer Update.", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With User Name Or Email Checking!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Customer not updated successfully!" });
                                    objv.execute();
                                }
                            });
                        }
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    sendEmailVerify(req, res, sdata, newRes, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let secret = Str.random(15);
                let validationKey = jwt.sign({
                    exp: Math.floor(Date.now() / 1000) + (60 * 60),
                    data: sdata.email + sdata.password
                }, secret);
                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "', `secret`='" + secret + "', `email_verification_date`=NOW() WHERE `iduser`='" + newRes[0].userid + "' AND  `is_deleted`=0";
                obj3.prepare();
                obj3.execute((_err, __result) => {
                    if (_err == 1) {
                        if (__result.affectedRows > 0) {
                            let tempType;
                            if (sdata.isEmailVerify == 'true' || sdata.isEmailVerify == true) {
                                tempType = "welcome";
                            }
                            if (sdata.isEmailVerify == 'false' || sdata.isEmailVerify == false) {
                                tempType = "email_verification";
                            }
                            let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                            obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='" + tempType + "'";
                            obj5.prepare();
                            obj5.execute((emlErr, emlRes) => {
                                if (emlErr == 1) {
                                    if (emlRes.length > 0) {
                                        let tmpData = emlRes[0].template;
                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, sdata.first_name);
                                        tmpData = tmpData.replace(/{LAST_NAME}/g, sdata.last_name);
                                        tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);
                                        // var smtpTransport = nodemailer.createTransport({
                                        //     service: "gmail",
                                        //     host: "smtp.gmail.com",
                                        //     port: 587,
                                        //     secure: true,
                                        //     auth: {
                                        //         user: "mailto:donotreply@nglcommunications.com",
                                        //         pass: "yr%5V9GB"
                                        //     }
                                        // });
                                        // var mailOptions = {
                                        //     from: 'Signalmash <mailto:donotreply@signalmash.com>',
                                        //     to: sdata.email,
                                        //     usernmae: sdata.user_name,
                                        //     email: sdata.email,
                                        //     subject: `${emlRes[0].subject}`,
                                        //     text: "Thank You For Registration",
                                        //     html: `${tmpData}`
                                        // }
                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                        //     if (_emailError) {
                                        //         console.log("Opps Email Not Sent!");
                                        //     } else {
                                        //         console.log("Email Send  Successfully!");
                                        //     }
                                        // });
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + newRes[0].userid + "','" + newRes[0].account + "','" + FromEmail + "','" + (0, markError_1.parseBody)(sdata.email) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','Mail Send for Email Verification.', '" + (0, markError_1.parseBody)(tmpData) + "','Mail Send for Email Verification.','3','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                        obj1.prepare();
                                        obj1.execute((_err, __result) => {
                                            if (_err == 1) {
                                                console.log("Email Send  Successfully!");
                                            }
                                            else {
                                                console.log("Opps Email Not Sent!");
                                            }
                                        });
                                    }
                                    else {
                                        console.log("Template Data Not Found!");
                                    }
                                }
                                else {
                                    console.log("Something Went Wrong with DB!");
                                }
                            });
                        }
                        else {
                            console.log("Invalid Key/Invalid Account!");
                        }
                    }
                    else {
                        console.log("Something Went Wrong with DB!");
                    }
                });
            }
            else {
                console.log(session);
            }
        });
    }
    UserList(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let msg = "";
                switch (true) {
                    case (!sdata):
                        msg = "Missing query params!";
                        break;
                    case (!sdata.type):
                        msg = "Missing request type in params!";
                        break;
                    case (sdata == '' || sdata == 'null' || sdata == 'undefined'):
                        msg = "Missing query params!";
                        break;
                    case (!/^(?!\s*$).+/.test(sdata)):
                        msg = "type cannot be empty or only spaces!";
                        break;
                    case (!/^(?!\s*$).+/.test(sdata.type)):
                        msg = "type cannot be empty or only spaces!";
                        break;
                    case (sdata.type && (sdata.type !== "main" && sdata.type !== "profile" && sdata.type !== "detail" && sdata.type !== "edit")):
                        msg = "type is invalid!";
                        break;
                    case (sdata.type == "edit" && (!sdata.idaccount)):
                        msg = "idaccount is required!";
                        break;
                    case (sdata.type == "edit" && !/^[0-9]+$/.test(sdata.iduser)):
                        msg = "iduser is Invalid!";
                        break;
                    case (sdata.type == "edit" && !/^[0-9]+$/.test(sdata.idaccount)):
                        msg = "idaccount is Invalid!";
                        break;
                    case (sdata.type == "edit" && !sdata.iduser):
                        msg = "iduser is required !";
                        break;
                    default:
                        msg = "";
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: msg, status: 500 });
                    objv.execute();
                }
                else {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    if (sdata.type == "main") {
                        obj.nonqrysql = "CALL ListUser(" + sessdata.idaccount + ", " + sessdata.iduser + ", -1)";
                    }
                    else if (sdata.type == "profile") {
                        obj.nonqrysql = "CALL ListUser(" + sessdata.idaccount + ", " + sessdata.iduser + ", 1)";
                    }
                    else if (sdata.type == "detail") {
                        obj.nonqrysql = "CALL ListUser(" + sessdata.idaccount + ", " + sessdata.iduser + ", 2)";
                    }
                    else if (sdata.type == "edit") {
                        obj.nonqrysql = "CALL ListUser(" + sdata.idaccount + ", " + sdata.iduser + ", 3)";
                    }
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Profile Fetched Successfully!", status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    ListUsers(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let idaccount, iduser;
                let msg = "";
                switch (true) {
                    case (sessdata.type == 1 && (!sdata || !('type' in req.query || 'idaccount' in req.query || 'iduser' in req.query))):
                        msg = "Misisng parameter type,idaccount & iduser in request for admin!";
                        break;
                    case (sessdata.type != 1 && (!sdata || !('type' in req.query))):
                        msg = "Misisng parameter type in request for customer!";
                        break;
                    case (sessdata.type == 1 && !sdata.type || (0, markError_1.isMissing)(sdata.type)):
                        msg = "type is required!";
                        break;
                    case (sessdata.type == 1 && (!sdata.iduser || (0, markError_1.isMissing)(sdata.iduser))):
                        msg = "iduser is required!";
                        break;
                    case (sessdata.type == 1 && (!sdata.idaccount || (0, markError_1.isMissing)(sdata.idaccount))):
                        msg = "idaccount is required!";
                        break;
                    case (sdata.type && (sdata.type !== "profile" || !/^(?!\s*$).+/.test(sdata.type))):
                        msg = "type is invalid!";
                        break;
                    case (sessdata.type === 1 &&
                        sdata?.idaccount &&
                        (typeof sdata.idaccount !== 'number' && typeof sdata.idaccount !== 'string'
                            ? true
                            : !/^\d+$/.test(sdata.idaccount.toString()))):
                        msg = "idaccount must be numeric";
                        break;
                    case (sessdata.type === 1 &&
                        sdata?.iduser &&
                        (typeof sdata.iduser !== 'number' && typeof sdata.iduser !== 'string'
                            ? true
                            : !/^\d+$/.test(sdata.iduser.toString()))):
                        msg = "iduser must be numeric";
                        break;
                        break;
                    default:
                        msg = "";
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: msg, status: 501 });
                    objv.execute();
                }
                else {
                    idaccount = sessdata.type == 1 ? sdata.idaccount : sessdata.idaccount;
                    iduser = sessdata.type == 1 ? sdata.iduser : sessdata.iduser;
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    if (sdata.type == "profile") {
                        obj.nonqrysql = "CALL ListUser(" + idaccount + ", " + iduser + ", 1)";
                    }
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            if (result.length > 0) {
                                for (const item of result[0]) {
                                    if (sessdata.type !== 1) {
                                        delete item.idaccount;
                                        delete item.iduser;
                                        delete item.reseller_iduser;
                                    }
                                }
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "Profile Fetched Successfully!", status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    singleUser(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT u.iduser, u.idaccount, u.idtariff, u.idservice, u.type, u.created, u.isEmailVerify, u.isMobileVerify, u.isAddress, u.isCard, u.isPlan, u.is_deleted, u.newUser_status, u.restore_date, u.kyc_verify_status, u.volt_status, u.federal_status ,uf.firstname,uf.lastname,uf.email,u.resetPassword,u.username FROM `user`u inner join `user_profile`uf on u.iduser=uf.iduser WHERE u.`iduser`='" + sessdata.iduser + "'";
                obj1.prepare();
                obj1.execute((_error1, result1) => {
                    if (_error1 == 1 && result1.length > 0) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT a.subscription_payment, b.idaccount, b.address1, b.address2, b.city, b.state, b.contact, b.postal_code, b.country, b.customerType, b.title, b.ein, b.website, b.groupExmpt_number, b.businessName, w.balance, w.credit_limit FROM `billing_address` b JOIN `wallet` w ON w.idaccount = b.idaccount JOIN `account` a ON a.idaccount = b.idaccount WHERE  `b`.idaccount=" + result1[0].idaccount + "";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                let sessData1 = {
                                    authkey: sessdata.authkey,
                                    type: result1[0].type,
                                    iduser: result1[0].iduser,
                                    username: result1[0].username,
                                    idaccount: result1[0].idaccount,
                                    isEmailVerify: result1[0].isMobileVerify,
                                    isMobileVerify: result1[0].isMobileVerify,
                                    isAddress: result1[0].isAddress,
                                    isPlan: result1[0].isPlan,
                                    isCard: result1[0].isCard,
                                    newUser_status: result1[0].newUser_status,
                                    idtariff: result1[0].idtariff,
                                    kyc_verify_status: result1[0].kyc_verify_status,
                                    country: (result.length > 0 && result[0].country) ? result[0].country : '',
                                    email: result1[0].email
                                };
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, data1: result1, sessdata: [sessData1], message: "Profile Fetched Successfully!", status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong List User", status: 502, error: _error });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With User", status: 502, error: _error1 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getSingleUsersForAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let iduser = req.query.type;
                validuser.checksessionvalid_1_2(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1 || sessdata.type == 2) {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT u.iduser, u.idaccount, u.idtariff, u.idservice, u.type, u.created, u.isEmailVerify, u.isMobileVerify, u.isAddress, u.isCard, u.isPlan, u.is_deleted, u.newUser_status, u.restore_date, u.kyc_verify_status, u.volt_status, u.federal_status ,uf.firstname,uf.lastname,uf.email FROM `user`u inner join `user_profile`uf on u.iduser=uf.iduser WHERE u.`iduser`=" + iduser + "";
                        obj1.prepare();
                        obj1.execute((_error1, result1) => {
                            if (_error1 == 1 && result1.length > 0) {
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                obj.qrysql = "SELECT b.idaccount, b.address1, b.address2, b.city, b.state, b.contact, b.postal_code, b.country, b.customerType, b.title, b.ein, b.website, b.groupExmpt_number, b.businessName, w.balance, w.credit_limit FROM `billing_address` b JOIN `wallet` w ON w.idaccount = b.idaccount WHERE `b`.idaccount=" + result1[0].idaccount + "";
                                obj.prepare();
                                obj.execute((_error, result) => {
                                    if (_error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ data: result, data1: result1, message: "Profile Fetched Successfully!", status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong List User", status: 502, error: _error });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With User", status: 502, error: _error1 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    subCustomerList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                // obj.qrysql = "SELECT iduser,idaccount,username,idtariff,status FROM `user` WHERE `idaccount`=" + sessdata.idaccount + " AND `is_deleted`='0'";
                obj.qrysql = "SELECT DISTINCT u.iduser, u.idaccount, u.username, u.idtariff, u.status, (SELECT CONCAT(up.firstname, ' ', up.lastname) FROM user_profile up WHERE up.iduser = u.iduser ) AS customer_name FROM user u WHERE u.idaccount = '" + sessdata.idaccount + "' AND u.is_deleted = '0'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Sub Customer Fetched!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    // getAllUsers(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let Qry: any = '';
    //             let obj = new ModelRawQuery(req, res);
    //             //Qry += "SET SESSION group_concat_max_len = 1000000;\n"
    //             // Qry += `SELECT c.idaccount, c.iduser, c.idtariff, c.type, ac.san, CONCAT(up.firstname,' ',up.lastname) name, CONCAT( '[',( SELECT GROUP_CONCAT( CONCAT( '{"idaccount":"', s.idaccount, '","iduser":"', s.iduser, '","idtariff":"', s.idtariff, '","type":"', s.type, '","name":"', REPLACE(REPLACE(REPLACE(REPLACE(CONCAT(uu.firstname, ' ', uu.lastname), '"', '\\"'), "'", "\\'"), '\n', '\\n'), "\\'", "\\'"), '"', '}' ) SEPARATOR ',') FROM user s LEFT JOIN user_profile uu ON uu.iduser = s.iduser INNER JOIN account a ON a.idaccount = s.idaccount WHERE s.type = 22 AND s.idaccount = c.idaccount ), ']') AS customer_data FROM user c LEFT JOIN user_profile up ON c.iduser = up.iduser INNER JOIN account ac ON ac.idaccount = c.idaccount WHERE c.type = 2 AND c.is_deleted=0 GROUP BY c.idaccount;`
    //             Qry += `SELECT c.idaccount, MAX(c.iduser) AS iduser, MAX(c.idtariff) AS idtariff, c.type, ac.san, CONCAT(MAX(up.firstname),' ',MAX(up.lastname)) AS name,CONCAT( '[',(SELECT GROUP_CONCAT(CONCAT('{"idaccount":"', s.idaccount, '","iduser":"', s.iduser, '","idtariff":"', s.idtariff, '","type":"', s.type, '","name":"', REPLACE(REPLACE(REPLACE(REPLACE(CONCAT(uu.firstname, ' ', uu.lastname), '"', '\"'), "'", "\'"), '\n', '\n'), "'", "\'"), '"', '}' ) SEPARATOR ',' ) FROM user s LEFT JOIN user_profile uu ON uu.iduser = s.iduser INNER JOIN account a ON a.idaccount = s.idaccount WHERE s.type = 22 AND s.idaccount = c.idaccount), ']') AS customer_data FROM user c LEFT JOIN user_profile up ON c.iduser = up.iduser INNER JOIN account ac ON ac.idaccount = c.idaccount WHERE c.type = 2 AND c.is_deleted = 0 GROUP BY c.idaccount;`;
    //             obj.qrysql = Qry;
    //             obj.prepare();
    //             obj.execute((_error: any, result: any) => {
    //                 if (_error == 1) {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ data: result, message: "Sub Customer Fetched!", status: 201 });
    //                     objv.execute();
    //                 }
    //                 else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
    //                     objv.execute();
    //                 }
    //             });
    //         }
    //         else {
    //             let objv = new Res406(res);
    //             objv.prepare({ status: 401, message: "Unauthorized User!" });
    //             objv.execute();
    //         }
    //     });
    // }
    // getAllUsers(req: Request, res: Response, next: NextFunction) {
    //     let session = new SessionManagment(req, res, next);
    //     session.GetSession((error: any, sessdata: any) => {
    //         if (error == 1) {
    //             let obj = new ModelRawQuery(req, res);
    //             // Fetch Customers
    //             let customerQry: string = `SELECT c.idaccount, c.iduser, c.idtariff, c.type, ac.san, CONCAT(up.firstname, ' ', up.lastname) AS name FROM user c LEFT JOIN user_profile up ON c.iduser = up.iduser INNER JOIN account ac ON ac.idaccount = c.idaccount WHERE c.type = 2 AND c.is_deleted = 0;`;
    //             obj.qrysql = customerQry;
    //             obj.prepare();
    //             obj.execute((custError: any, customerResult: any) => {
    //                 if (custError == 1) {
    //                     // Fetch Sub-Customers
    //                     let obj1 = new ModelRawQuery(req, res);
    //                     let subCustomerQry: string = `SELECT s.idaccount, s.iduser, s.idtariff, s.type, CONCAT(up.firstname, ' ', up.lastname) AS name FROM user s LEFT JOIN user_profile up ON s.iduser = up.iduser INNER JOIN account a ON a.idaccount = s.idaccount WHERE s.type = 22 AND s.is_deleted = 0;`;
    //                     obj1.qrysql = subCustomerQry;
    //                     obj1.prepare();
    //                     obj1.execute((subError: any, subCustomerResult: any) => {
    //                         if (subError == 1) {
    //                             let objv = new RawView(res);
    //                             objv.prepare({ customers: customerResult, subCustomers: subCustomerResult, message: "Customers and Sub-Customers Fetched!", status: 201 });
    //                             objv.execute();
    //                         } else {
    //                             let objv = new RawView(res);
    //                             objv.prepare({ customers: [], subCustomers: [], message: "Failed to Fetch Sub-Customers", status: 502 });
    //                             objv.execute();
    //                         }
    //                     });
    //                 } else {
    //                     let objv = new RawView(res);
    //                     objv.prepare({ customers: [], subCustomers: [], message: "Failed to Fetch Customers", status: 502 });
    //                     objv.execute();
    //                 }
    //             });
    //         } else {
    //             let objv = new Res406(res);
    //             objv.prepare({ status: 401, message: "Unauthorized User!" });
    //             objv.execute();
    //         }
    //     });
    // }
    getAllUsers(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                let customerAndSubCustomerQry = `SELECT c.idaccount,c.iduser,c.idservice,c.idtariff,c.type,ac.san, CONCAT(up.firstname, ' ', up.lastname) AS name FROM user c LEFT JOIN user_profile up ON c.iduser = up.iduser INNER JOIN account ac ON ac.idaccount = c.idaccount WHERE (c.type = 2 OR c.type = 22) AND c.is_deleted = 0;`;
                obj.qrysql = customerAndSubCustomerQry;
                obj.prepare();
                obj.execute((custError, result) => {
                    if (custError == 1) {
                        let customers = result.filter((user) => user.type === 2);
                        let subCustomers = result.filter((user) => user.type === 22);
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            customers: customers,
                            subCustomers: subCustomers,
                            message: "Customers and Sub-Customers Fetched!",
                            status: 201
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ customers: [], subCustomers: [], message: "Failed to Fetch Users", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    updateProfilePic(req, res, next) {
        let filePath;
        if (req.file) {
            const fileName = req.file.filename;
            //filePath = req.protocol + '://' + req.get('host') + '/uploads/' + fileName;
            filePath = profile_pic.profile_pic + '/uploads/' + fileName;
        }
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj6.nonqrysql = "UPDATE `user_profile` SET `profile_pic`='" + filePath + "' WHERE `iduser`=" + sessdata.iduser + "";
                obj6.prepare();
                obj6.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Profile Picture Update Successfully!", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    removeProfilePic(req, res, next) {
        let filePath = req.protocol + '://' + req.get('host') + '/uploads/default.jpg';
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj6.nonqrysql = "UPDATE `user_profile` SET `profile_pic`='" + filePath + "' WHERE `iduser`=" + sessdata.iduser + "";
                obj6.prepare();
                obj6.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Profile Picture Remove Successfully!", data: result, status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getGeoCode(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                const isEmpty = (value) => value == undefined || value == null || value == '' || value == 'null' || value == 'undefined';
                const requiredFields = ['address1', 'city', 'state', 'postal_code'];
                let sdata = req.body.data;
                let message = "";
                switch (true) {
                    case (!sdata):
                        message = "Address data is required";
                        break;
                    case requiredFields.some(f => isEmpty(sdata[f])):
                        const missingFields = requiredFields.filter(f => isEmpty(sdata[f]));
                        message = missingFields.join(', ') + ' ' + (missingFields.length > 1 ? 'are required!' : 'is required!');
                        break;
                    case (!isEmpty(sdata?.postal_code) &&
                        (typeof sdata.postal_code === 'string' || Array.isArray(sdata.postal_code))
                        ? sdata.postal_code.length < 5
                        : true):
                        message = "Postal code must be at least 5 characters!";
                        break;
                    default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: message, status: 502 });
                    objv.execute();
                }
                else {
                    let options = {
                        'method': 'POST',
                        'url': 'https://communicationsua.avalara.net/api/v2/geo/geocode',
                        'headers': {
                            'client_id': '2221',
                            'Authorization': 'Basic dmlrYXNAZ3ZlbnR1cmUubmV0OmshR3BBdDNKNU5GTUt3UA==',
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify([
                            {
                                "ref": "Address Request",
                                "cass": true,
                                "addr": sdata.address1,
                                "city": sdata.city,
                                "st": sdata.state,
                                "zip": sdata.postal_code
                            }
                        ])
                    };
                    (0, axios_1.request)(options, function (error, response) {
                        if (!error) {
                            try {
                                let Data = JSON.parse(response.body);
                                if (Data[0].err == undefined && Data[0].pcd !== undefined && Data[0].pcd > 0) {
                                    let objv = new RawView_1.RawView(res);
                                    // objv.prepare({ message: "Geocode Fetched Successfully!", data: { "giocode": Data[0].pcd }, status: 200 });
                                    objv.prepare({ data: { "giocode": Data[0].pcd }, status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: 'Please Enter a Validate Address', status: 502 });
                                    objv.execute();
                                }
                            }
                            catch (e) {
                                console.log("Error :: getGeoCode::", e);
                                let obj = new RawView_1.RawView(res);
                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                obj.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: 'Please Enter a Validate Address', status: 502 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    addBillingAddress(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let msg = '';
                switch (true) {
                    case !sdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `first_name`,`last_name`,`idaccount` FROM `billing_address` WHERE `idaccount`='" + sessdata.idaccount + "'";
                    obj0.prepare();
                    obj0.execute((_erro, datachk) => {
                        if (datachk.length > 0) {
                            let obj00 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj00.nonqrysql = "UPDATE `billing_address` SET `address1`='" + (0, markError_1.parseBody)(sdata.address1) + "',`address2`='" + (0, markError_1.parseBody)(sdata.address2) + "',`city`='" + (0, markError_1.parseBody)(sdata.city) + "',`state`='" + (0, markError_1.parseBody)(sdata.state) + "',`postal_code`='" + (0, markError_1.parseBody)(sdata.postal_code).trim() + "',`country`='" + (0, markError_1.parseBody)(sdata.country) + "', `first_name`='" + (0, markError_1.parseBody)(sdata.first_name) + "', `last_name`='" + (0, markError_1.parseBody)(sdata.last_name) + "', `email`='" + (0, markError_1.parseBody)(sdata.email) + "', `title`='" + (0, markError_1.parseBody)(sdata.title) + "',`ein`='" + (0, markError_1.parseBody)(sdata.ein) + "',`website`='" + (0, markError_1.parseBody)(sdata.website) + "',`groupExmpt_number`=" + (0, markError_1.setToZero)(sdata.groupExmpt_number) + ",`customerType`='" + sdata.customerType + "',`businessName`='" + (0, markError_1.parseBody)(sdata.businessName) + "' WHERE `idaccount`='" + sessdata.idaccount + "'";
                            obj00.prepare();
                            obj00.execute((_uerro, updateBa) => {
                                if (_uerro == 1) {
                                    let umc = new UserManagement();
                                    umc.inBillingAdd(req, res, updateBa, next);
                                }
                            });
                        }
                        else {
                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                            obj0.qrysql = "SELECT `firstname`,`lastname` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                            obj0.prepare();
                            obj0.execute((_erro, resultIn) => {
                                if (resultIn.length > 0) {
                                    let rdata = req.body.data;
                                    let first_name = '';
                                    let last_name = '';
                                    if (!rdata.first_name) {
                                        first_name = resultIn[0].firstname;
                                    }
                                    else {
                                        first_name = rdata.first_name;
                                    }
                                    if (!rdata.last_name) {
                                        last_name = resultIn[0].lastname;
                                    }
                                    else {
                                        last_name = rdata.last_name;
                                    }
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "INSERT INTO `billing_address` (`idaccount`, `first_name`, `last_name`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`, `title`, `ein`, `website`,`groupExmpt_number`,`businessName`,`customerType`) VALUES ('" + sessdata.idaccount + "', '" + (0, markError_1.parseBody)(first_name) + "', '" + (0, markError_1.parseBody)(last_name) + "', '" + (0, markError_1.parseBody)(rdata.email) + "', '" + (0, markError_1.parseBody)(rdata.address1) + "', '" + (0, markError_1.parseBody)(rdata.address2) + "', '" + (0, markError_1.parseBody)(rdata.city) + "', '" + (0, markError_1.parseBody)(rdata.state) + "', '" + (0, markError_1.parseBody)(rdata.postal_code) + "', '" + (0, markError_1.parseBody)(rdata.country) + "','" + (0, markError_1.parseBody)(rdata.title) + "','" + (0, markError_1.parseBody)(rdata.ein) + "','" + (0, markError_1.parseBody)(rdata.website) + "'," + (0, markError_1.setToZero)(rdata.groupExmpt_number) + ",'" + (0, markError_1.parseBody)(rdata.businessName) + "','" + (0, markError_1.parseBody)(rdata.customerType) + "')";
                                    obj.prepare();
                                    obj.execute((_error, data) => {
                                        if (_error == 1) {
                                            let umc = new UserManagement();
                                            umc.inBillingAdd(req, res, data, next);
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Data not found!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    inBillingAdd(req, res, data, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let countryobj = req.body.data.country;
                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj4.nonqrysql = "UPDATE `user` SET `isAddress`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                obj4.prepare();
                obj4.execute((_error, user) => {
                    if (_error == 1) {
                        console.log("User's isAddress Updated Successfully!");
                    }
                    else {
                        console.log("User's isAddress Not Updated!");
                    }
                });
                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj5.nonqrysql = "UPDATE `session` SET `isAddress`='true', `country`='" + countryobj + "' WHERE `iduser`='" + sessdata.iduser + "'";
                obj5.prepare();
                obj5.execute((_err, user) => {
                    if (_err == 1) {
                        console.log("Session Updated Successfully!");
                    }
                    else {
                        console.log("Session Not Updated!");
                    }
                    let obj6 = new RawQuery_1.ModelRawQuery(req, res);
                    obj6.qrysql = "SELECT `authkey`,`type`,`iduser`,`username`,`idaccount`,`isEmailVerify`,`isMobileVerify`,`isAddress`,`isPlan`,`isCard`,`newUser_status`,`idtariff`,`kyc_verify_status` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                    obj6.prepare();
                    obj6.execute((_sessError, sessData) => {
                        if (_sessError == 1) {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `kyc_verify_status` FROM `user` WHERE `iduser` = '" + sessdata.iduser + "'";
                            obj.prepare();
                            obj.execute((errorr, getUser) => {
                                if (errorr == 1 && getUser.length > 0) {
                                    let temp1 = "{\"country\": \"" + countryobj + "\"}";
                                    let getUser1 = "{\"kyc_verify_status\": \"" + getUser[0].kyc_verify_status + "\"}";
                                    let temp2 = JSON.parse(temp1);
                                    let getUser2 = JSON.parse(getUser1);
                                    let data1 = Object.assign(sessData[0], temp2, getUser2);
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ session: [data1], data: [data1], iduser: sessdata.iduser, message: "Address Saved Successfully!", status: 201 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Somethng Went Wrong With Get Data!", status: 502 });
                            objv.execute();
                        }
                    });
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /* * * * * * * * * * * *
     * To send mail to support and customer
     */
    sendOnboardingComplateMail(req, res, next) {
        let sdata = req.body.data;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                obj7.qrysql = "SELECT `username`,`idtariff`,`reseller_iduser`,`signup_link_id` FROM `user` WHERE `idaccount`='" + sessdata.idaccount + "' AND `isEmailVerify`='true' AND `isMobileVerify`='true' AND `isAddress`='true' AND `isPlan`='true' AND `is_deleted`=0";
                obj7.prepare();
                obj7.execute((userErr, userRes) => {
                    let userResData = userRes[0];
                    if (userErr == 1 && userRes.length > 0) {
                        let objT = new RawQuery_1.ModelRawQuery(req, res);
                        objT.qrysql = "SELECT `name` FROM `tariff` WHERE `idtariff`=" + userResData.idtariff + "";
                        objT.prepare();
                        objT.execute((trfErr, terRes) => {
                            let trfName = trfErr == 1 && terRes.length > 0 && terRes[0].name ? terRes[0].name : 'CUSTOM PLAN';
                            let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                            obj7.qrysql = "SELECT `san` FROM `account` WHERE `idaccount`=" + sessdata.idaccount + "";
                            obj7.prepare();
                            obj7.execute((accErr, accRes) => {
                                let accResData = accRes[0];
                                if (accErr == 1 && accRes.length > 0) {
                                    let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj7.qrysql = "SELECT `firstname`,`lastname`,`phone`,`email` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj7.prepare();
                                    obj7.execute((bErr, billingRes) => {
                                        let getUser = billingRes[0];
                                        if (bErr == 1 && billingRes.length > 0) {
                                            // To send mail to customer
                                            let obj9 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj9.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='onboarding_complete_notification_to_customer'";
                                            obj9.prepare();
                                            obj9.execute((emlErr, emlRes) => {
                                                if (emlErr == 1) {
                                                    if (emlRes.length > 0) {
                                                        let tmpData = emlRes[0].template;
                                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                        tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + (0, markError_1.parseBody)(FromEmail) + "','" + (0, markError_1.parseBody)(getUser.email) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','Thank You For Complete Registration Send Mail to Customer', '" + (0, markError_1.parseBody)(tmpData) + "','Thank You For Complete Onboarding Process','4','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                        obj1.prepare();
                                                        obj1.execute((_err, __result) => {
                                                            if (_err == 1) {
                                                                console.log("Email Send Succesfully!");
                                                            }
                                                            else {
                                                                console.log("Email Not Sent!");
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        console.log("Data Not Available!");
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with Get Data!");
                                                }
                                            });
                                            // To send mail to support
                                            let obj8 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj8.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='onboarding_complete_notification_to_support'";
                                            obj8.prepare();
                                            obj8.execute((emlErr, emlRes) => {
                                                if (emlErr == 1) {
                                                    // To send mail to support
                                                    if (emlRes.length > 0) {
                                                        let tmpDataSup = emlRes[0].template;
                                                        let objsu = new RawQuery_1.ModelRawQuery(req, res);
                                                        tmpDataSup = tmpDataSup.replace(/{SAN_NUMBER}/g, accResData.san);
                                                        tmpDataSup = tmpDataSup.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                        tmpDataSup = tmpDataSup.replace(/{LAST_NAME}/g, getUser.lastname);
                                                        tmpDataSup = tmpDataSup.replace(/{EMAIL}/g, getUser.email);
                                                        tmpDataSup = tmpDataSup.replace(/{PHONE}/g, getUser.phone);
                                                        tmpDataSup = tmpDataSup.replace(/{TARIFF}/g, trfName);
                                                        objsu.qrysql = "SELECT rp.firstname, rp.lastname, r.organization_name FROM reseller_profile rp JOIN reseller r ON rp.iduser = r.iduser WHERE rp.iduser = '" + userResData.reseller_iduser + "';";
                                                        objsu.prepare();
                                                        objsu.execute((err, resp) => {
                                                            if (userResData.reseller_iduser !== 0) {
                                                                if (err == 1) {
                                                                    tmpDataSup = tmpDataSup.replace(/{Reseller Organization}/g, 'Reseller Organization');
                                                                    tmpDataSup = tmpDataSup.replace(/{RESELLER_BUSINESS_NAME}/g, resp[0].organization_name);
                                                                    tmpDataSup = tmpDataSup.replace(/{Reseller Contact}/g, 'Reseller Contact');
                                                                    tmpDataSup = tmpDataSup.replace(/{RESELLER_FIRST_NAME}/g, resp[0].firstname);
                                                                    tmpDataSup = tmpDataSup.replace(/{RESELLER_LAST_NAME}/g, resp[0].lastname);
                                                                    tmpDataSup = tmpDataSup.replace(/{Registration Link Name}/g, 'Registration Link Name');
                                                                    tmpDataSup = tmpDataSup.replace(/{REGISTRATION_LINK_NAME}/g, userResData.signup_link_id);
                                                                }
                                                                else {
                                                                    console.log("Error fetching in reseller data");
                                                                }
                                                            }
                                                            else {
                                                                tmpDataSup = tmpDataSup.replace(/{Reseller Organization}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_BUSINESS_NAME}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{Reseller Contact}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_FIRST_NAME}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{RESELLER_LAST_NAME}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{Registration Link Name}/g, '');
                                                                tmpDataSup = tmpDataSup.replace(/{REGISTRATION_LINK_NAME}/g, '');
                                                            }
                                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            // obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + supportEmail + "', 'New Signalmash Customer','Thank You For Complete Registration Send Mail to Support', '" + parseBody(tmpDataSup) + "','Thank You For Complete Onboarding Process','4')";
                                                            const Spmail = supportEmail.split(",");
                                                            let qry = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES";
                                                            for (let i = 0; i < Spmail.length; i++) {
                                                                let entry = Spmail[i];
                                                                qry += "('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + (0, markError_1.parseBody)(entry) + "', 'New Signalmash Customer','Thank You For Complete Registration Send Mail to Support', '" + (0, markError_1.parseBody)(tmpDataSup) + "','Thank You For Complete Onboarding Process','4','" + emlRes[0].cc + "','" + emlRes[0].bcc + "'),";
                                                            }
                                                            obj1.nonqrysql = qry.slice(0, -1);
                                                            obj1.prepare();
                                                            obj1.execute((_err, __result) => {
                                                                if (_err == 1) {
                                                                    console.log("Email Send Succesfully!");
                                                                }
                                                                else {
                                                                    console.log("Email Not Sent!");
                                                                }
                                                            });
                                                        });
                                                    }
                                                    else {
                                                        console.log("Data Not Available!");
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with Get Data!");
                                                }
                                            });
                                            // To send welcome email to customer 
                                            let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj7.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='welcome_email'";
                                            obj7.prepare();
                                            obj7.execute((emlErr, emlRes) => {
                                                if (emlErr == 1) {
                                                    if (emlRes.length > 0) {
                                                        let tmpData = emlRes[0].template;
                                                        tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                        tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                                        // var mailOptions = {
                                                        //     from: 'Signalmash <donotreply@signalmash.com>',
                                                        //     to: `${getUser.email}`,
                                                        //     usernmae: userResData.username,
                                                        //     email: getUser.email,
                                                        //     subject: `${emlRes[0].subject}`,
                                                        //     text: "Welcome Email",
                                                        //     html: `${tmpData}`
                                                        // }
                                                        // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                        //     if (_emailError) {
                                                        //         console.log("Welcome Email Not Sent!");
                                                        //     }
                                                        //     else {
                                                        //         console.log("Welcome Email Send Succesfully!");
                                                        //     }
                                                        // });
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + (0, markError_1.parseBody)(FromEmail) + "','" + (0, markError_1.parseBody)(getUser.email) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','Welcome Email', '" + (0, markError_1.parseBody)(tmpData) + "','Welcome Email','16','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                        obj1.prepare();
                                                        obj1.execute((_err, __result) => {
                                                            if (_err == 1) {
                                                                console.log("Welcome Email Send Succesfully!");
                                                            }
                                                            else {
                                                                console.log("Welcome Email Not Sent");
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        console.log("Data Not Available!");
                                                    }
                                                }
                                                else {
                                                    console.log("Something Went Wrong with Get Welcome Email Data!");
                                                }
                                            });
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "Welcome Mail Sent Successfully!", status: 201
                                            });
                                            objv.execute();
                                        }
                                        else {
                                            console.log("User Information Not Avalilable!");
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "User Information Not Avalilable!", status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    console.log("Account Data Not Available!");
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        message: "Account Data Not Available!", status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        });
                    }
                    else {
                        console.log("Onboarding Not Complete or Account Not Available/Invalid Account!");
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: "Onboarding Not Complete or Account Not Available/Invalid Account!", status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                console.log("Session Not Available!");
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getBillingAddress(req, res, next) {
        let sdata = req.query;
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let msg = "";
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                // obj.qrysql = "SELECT ba.idbilling_address as id_billing_address, ba.first_name, ba.last_name, ba.address1, ba.address2, ba.city, ba.state, ba.postal_code, ba.country, up.firstname, up.lastname, up.phone, up.email FROM billing_address ba RIGHT JOIN user_profile up ON ba.idaccount= (SELECT idaccount from user where iduser='" + sessdata.iduser + "') WHERE up.`iduser` = '" + sessdata.iduser + "'";
                obj.qrysql = "SELECT ba.idbilling_address as id_billing_address, ba.first_name, ba.last_name, ba.address1, ba.address2, ba.city, ba.state, ba.postal_code, ba.country, ba.ein, ba.website, ba.groupExmpt_number, ba.businessName, ba.customerType, up.firstname, up.lastname, up.phone, up.email FROM billing_address ba RIGHT JOIN user_profile up ON ba.idaccount= (SELECT idaccount from user where iduser=" + sessdata.iduser + ") WHERE up.`iduser` = " + sessdata.iduser + "";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 0,
                            data: result,
                            message: msg,
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: result,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getInvoice(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let msg = "";
            let sdata = req.query;
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idinvoice`,`idaccount`,`invoice_number`,`created_at`,`san`,`first_name`,`last_name`,`address1`,`address2`,`city`,`state`,`postal_code`,`country`,`email`,`phone`,`customer_name`,`mrc_cost`,`commission_amount` FROM invoice";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 0,
                            data: result,
                            message: msg,
                            status: 200
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: result,
                            message: "Something Went Wrong With Connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    updateBillingAddress(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, _sessdata) => {
            if (error == 1) {
                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let sdata = [];
                sdata = req.body.data;
                let rdata = [];
                rdata = req.body.data;
                let msg = '';
                switch (true) {
                    case (!req.body.data):
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    obj2.nonqrysql = "UPDATE `billing_address` SET `address1`='" + (0, markError_1.parseBody)(rdata.address1) + "', `address2`='" + (0, markError_1.parseBody)(rdata.address2) + "', `city`='" + (0, markError_1.parseBody)(rdata.city) + "', `state`='" + (0, markError_1.parseBody)(rdata.state) + "', `postal_code`='" + (0, markError_1.parseBody)(rdata.postal_code).trim() + "', `country`='" + (0, markError_1.parseBody)(rdata.country) + "' WHERE `idbilling_address` = '" + rdata.idbilling_address + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                        if (error == 1) {
                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "UPDATE `user` SET `isAddress`='true' WHERE `iduser`='" + _sessdata.iduser + "'";
                            obj4.prepare();
                            obj4.execute((_error, user) => {
                                if (_error == 1) {
                                    let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "UPDATE `session` SET `isAddress`='true' WHERE `iduser`='" + _sessdata.iduser + "'";
                                    obj5.prepare();
                                    obj5.execute((_err, user) => {
                                        if (_err == 1) {
                                            let obj6 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj6.qrysql = "SELECT `authkey`,`type`,`iduser`,`username`,`idaccount`,`isEmailVerify`,`isMobileVerify`,`isAddress`,`isPlan`,`isCard`,`newUser_status`,`idtariff` FROM `session` WHERE `authkey`='" + _sessdata.authkey + "'";
                                            obj6.prepare();
                                            obj6.execute((_sessError, sessData) => {
                                                if (_sessError == 1) {
                                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj.qrysql = "SELECT `kyc_verify_status` FROM `user` WHERE `iduser` = '" + _sessdata.iduser + "'";
                                                    obj.prepare();
                                                    obj.execute((errorr, getUser) => {
                                                        if (errorr == 1 && getUser.length > 0) {
                                                            let temp1 = "{\"country\": \"" + rdata.country + "\"}";
                                                            let temp2 = JSON.parse(temp1);
                                                            let getUser1 = "{\"kyc_verify_status\": \"" + getUser[0].kyc_verify_status + "\"}";
                                                            let getUser2 = JSON.parse(getUser1);
                                                            let data1 = Object.assign(sessData[0], temp2, getUser2);
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ session: [data1], data: [data1], iduser: _sessdata.iduser, message: "Address Updated Successfully!!", status: 201 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Somethng Went Wrong With Get Data!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Address Updated Successfully Error With Connection!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Address Updated Successfully Error With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                error: error,
                                message: "Something went wrong with Connection!",
                                status: 502
                            });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getSupplier(req, res, next) {
        /* let sdata = req.query;
        if (sdata.type == "detail") {
            super.getMethod(req, res, next);
        }
        else { */
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            let msg = "";
            if (error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL getSupplier(" + sessdata.iduser + ")";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: msg, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
        /* } */
    }
    getSuppliers(req, res, next) {
        /* let sdata = req.query;
        if (sdata.type == "detail") {
            super.getMethod(req, res, next);
        }
        else { */
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, _sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idsupplier`, `tollfree`, `provider`,`did`, `sms`, `voice` FROM `service_provider`";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        /* for (const item of result) {
                            delete item.value;
                        } */
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Supplier Fatched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: _error, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
        /* } */
    }
    // Upload File
    UploadDocuments(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let objfile = new ModelPdfUpload_1.ModelPdfUpload(req, res);
                let fdata = objfile.fileUpload();
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let fileName = fdata[0].replace(/"/g, '\\"').replace(/'/g, "\\'");
                const filePath = req.protocol + '://' + req.get("host") + "/uploads/" + fileName;
                obj.nonqrysql = "INSERT INTO `upload` (`filename`,`destination_path`,`filetype`,`UserID`)VALUES ('" + fileName + "', '" + filePath + "', '" + req.file.mimetype + "','" + sessdata.iduser + "')";
                obj.prepare();
                obj.execute((_error, lastid) => {
                    let objv = new RawView_1.RawView(res);
                    let filepath = req.file.filename + fileName;
                    objv.prepare({ message: "File Uploaded Successfully.", insertedid: lastid.insertId, filename: filepath });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**
     *
     *
     * api
     */
    getCompanyProfile(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `idcompany`,`idaccount`,`company_name`,`ein`,`address`,`city`,`state`,`postal_code`,`website`,`country`,`email`,`phone` FROM `company` WHERE `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Company Profile Fetched Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Profile Details!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    updateCompanyProfile(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = [];
                rdata = req.body.data;
                let message = '';
                switch (true) {
                    case (isEmpty(rdata) || !rdata):
                        message = "Missing request body!";
                        break;
                    case (isEmpty(rdata.idcompany) ||
                        isEmpty(rdata.company_name) || isEmpty(rdata.ein) || isEmpty(rdata.phone) ||
                        isEmpty(rdata.email) || isEmpty(rdata.address) || isEmpty(rdata.city) ||
                        isEmpty(rdata.state) || isEmpty(rdata.country) || isEmpty(rdata.postal_code) || isEmpty(rdata.website)):
                        message = "idcompany, company name, ein, phone, email, address, city, state, country, postal code website fields are required!";
                        break;
                    case (rdata.country && (!Array.isArray(rdata.country) || !['US', 'Canada'].includes(rdata.country[0]))):
                        message = "Country is invalid! It must be 'US' or 'Canada'.";
                        break;
                    case !(0, markError_1.isAlphanumeric)(rdata.address):
                        message = "address is invalid";
                        break;
                    case !(0, markError_1.isAlphanumeric)(rdata.company_name):
                        message = "company name is invalid";
                        break;
                    case !(0, markError_1.isAlphanumeric)(rdata.state):
                        message = "state is invalid!";
                        break;
                    case !isValidtarif(rdata.phone):
                        message = "phone is invalid!";
                        break;
                    case !isValidtarif(rdata.ein):
                        message = "ein is invalid!";
                        break;
                    case (0, markError_1.isPostalCode)(rdata.postal_code):
                        message = "postal code is invalid!";
                        break;
                    case !isValidEmail(rdata.email):
                        message = "email is invalid!";
                        break;
                    default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: message });
                    objv.execute();
                }
                else {
                    if (rdata.idcompany != "") {
                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj2.nonqrysql = "UPDATE `company` SET `company_name`='" + (0, markError_1.parseBody)(rdata.company_name) + "', `ein`='" + (0, markError_1.parseBody)(rdata.ein) + "', `address`='" + (0, markError_1.parseBody)(rdata.address) + "', `city`='" + (0, markError_1.parseBody)(rdata.city) + "', `state`='" + (0, markError_1.parseBody)(rdata.state) + "', `postal_code`='" + (0, markError_1.parseBody)(rdata.postal_code) + "', `website`='" + (0, markError_1.parseBody)(rdata.website) + "', `country`='" + (0, markError_1.parseBody)(rdata.country[0]) + "', `email`='" + (0, markError_1.parseBody)(rdata.email) + "', `phone`='" + rdata.phone + "' WHERE `idcompany` = '" + rdata.idcompany + "'";
                        obj2.prepare();
                        obj2.execute((error, allcamp) => {
                            if (error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    data: allcamp,
                                    message: "Company Profile Updated Successfully!",
                                    status: 201
                                });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    error: error,
                                    message: "Something went wrong With Company Profile Details!",
                                    status: 502
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `company` (`idaccount`, `company_name`, `ein`, `phone`, `email`, `address`, `city`, `state`, `country`, `postal_code`, `website`) VALUES ('" + sessdata.idaccount + "', '" + (0, markError_1.parseBody)(rdata.company_name) + "', '" + (0, markError_1.parseBody)(rdata.ein) + "', '" + rdata.phone + "', '" + (0, markError_1.parseBody)(rdata.email) + "', '" + (0, markError_1.parseBody)(rdata.address) + "', '" + (0, markError_1.parseBody)(rdata.city) + "', '" + (0, markError_1.parseBody)(rdata.state) + "', '" + (0, markError_1.parseBody)(rdata.country) + "', '" + rdata.postal_code + "', '" + (0, markError_1.parseBody)(rdata.website) + "')";
                        obj.prepare();
                        obj.execute((_error, data) => {
                            if (_error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Company Profile Saved Successfully!", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something went wrong With Company Profile Details!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    ChangePassword(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                console.log(req.body.data);
                let sdata;
                try {
                    sdata = JSON.parse(req.body.data);
                }
                catch (err) {
                    sdata = req.body.data;
                }
                let message = '';
                const isEmpty = (value) => value == undefined || value == null || value == '' || value == 'null' || value == 'undefined';
                const requiredFields = { 'old_password': 'old password', 'npass': 'new password', 'confirm_password': 'confirm password' };
                switch (true) {
                    case (!sdata || !('data' in req.body)):
                        message = "Change password data is required";
                        break;
                    case Object.keys(requiredFields).some(f => isEmpty(sdata[f])):
                        const missingFields = Object.entries(requiredFields).filter(([f]) => isEmpty(sdata[f])).map(([_, label]) => label);
                        message = missingFields.join(', ') + ' ' + (missingFields.length > 1 ? 'are required!' : 'is required!');
                        break;
                    case ((!isEmpty(sdata.npass) &&
                        typeof sdata.npass === "string" &&
                        sdata.npass.length < 8) ||
                        (!isEmpty(sdata.confirm_password) &&
                            typeof sdata.confirm_password === "string" &&
                            sdata.confirm_password.length < 8)):
                        const shortFields = Object.entries({
                            npass: "New password",
                            confirm_password: "Confirm password",
                        })
                            .filter(([f]) => typeof sdata[f] === "string" &&
                            sdata[f].length < 8 &&
                            !isEmpty(sdata[f]))
                            .map(([_, label]) => label);
                        message = shortFields.join(", ") +
                            " " +
                            (shortFields.length > 1
                                ? "must be at least 8 characters!"
                                : "must be at least 8 characters!");
                        break;
                    case (!isEmpty(sdata.old_password) && !isEmpty(sdata.npass) && (sdata.old_password == sdata.npass)):
                        message = "Old Password and New Password cannot be the same";
                        break;
                    case (!isEmpty(sdata.npass) && !isEmpty(sdata.confirm_password) && (sdata.npass != sdata.confirm_password)):
                        message = "New Password and Confirm Password do not match";
                        break;
                    default:
                        message = "";
                }
                console.log("mypassss", message);
                if (message) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: message, status: 502 });
                    objv.execute();
                }
                else {
                    const passwd = (typeof sdata?.confirm_password === 'string')
                        ? sdata.confirm_password.trim().slice(0, 256)
                        : sdata?.confirm_password ?? null;
                    if (passwd && (0, markError_1.checkPassword)(passwd) == '') {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT up.firstname, up.lastname, up.email,u.username FROM `user` u JOIN user_profile up ON u.iduser = up.iduser WHERE u.iduser = '" + sessdata.iduser + "'";
                        obj1.prepare();
                        obj1.execute((Err, Res) => {
                            if (Err == 1) {
                                console.log("payload", Res);
                                let payload = {
                                    password: passwd,
                                    type: Res[0]
                                };
                                keycloak.loginKeyClock(req, res, Res[0].username, sdata.old_password, (errorRR, resRR) => {
                                    if (errorRR == 1) {
                                        keycloak.resetKeyCloakPass(req, res, payload, (errorR, resR) => {
                                            if (errorR == 1) {
                                                let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                                                obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='reset_password'";
                                                obj5.prepare();
                                                obj5.execute((emlErr, emlRes) => {
                                                    if (emlErr == 1) {
                                                        if (emlRes.length > 0) {
                                                            let tmpData = emlRes[0].template;
                                                            tmpData = tmpData.replace(/{FIRST_NAME}/g, Res[0].firstname);
                                                            tmpData = tmpData.replace(/{LAST_NAME}/g, Res[0].lastname);
                                                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + (0, markError_1.parseBody)(Res[0].email) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','Mail Send for Change Password', '" + (0, markError_1.parseBody)(tmpData) + "','Your Password Changed Successfully','5','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                            obj1.prepare();
                                                            obj1.execute((_err, __result) => {
                                                                console.log("Email Send Successfully!");
                                                                if (_err == 1) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Password Changed Successfully!", status: 201 });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    console.log("Oops Email Not Sent!");
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            console.log("Template Data Not Found!");
                                                            let objv0 = new RawView_1.RawView(res);
                                                            objv0.prepare({ status: 402, msg: "Template Data Not Found!" });
                                                            objv0.execute();
                                                        }
                                                    }
                                                    else {
                                                        console.log("Something Went Wrong with DB!");
                                                        let objv0 = new RawView_1.RawView(res);
                                                        objv0.prepare({ status: 403, msg: "Something Went Wrong with DB!" });
                                                        objv0.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                console.log("resetKeyCloakPass ChangePassword - callback:", errorR, resR);
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 503, message: "Password not reset successfully!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 401, message: "You have enter wrong old password!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv0 = new RawView_1.RawView(res);
                                objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                objv0.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: (0, markError_1.checkPassword)(passwd),
                            status: 501
                        });
                        objv.execute();
                    }
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    deleteUserSingleData(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, _sessdata) => {
            let sdata = req.query;
            let message = "";
            switch (true) {
                case !sdata:
                    message = "Missing request parameters!";
                    break;
                case !("ID" in sdata):
                    message = "Missing parameter 'ID'!";
                    break;
                case isNaN(Number(sdata.ID)):
                    message = "Parameter 'ID' must be numeric!";
                    break;
                case Number(sdata.ID) <= 0:
                    message = "Parameter 'ID' must be greater than 0!";
                    break;
                default:
                    message = "";
            }
            if (message) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 400, message });
                objv.execute();
                return;
            }
            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
            obj0.qrysql = "SELECT `username` FROM `user` WHERE `iduser` = '" + sdata.ID + "'";
            obj0.prepare();
            obj0.execute((_error, result1) => {
                if (_error == 1) {
                    let username = result1[0].username;
                    let sm = new UserManagement();
                    keycloak.DeleteuserKeyclock(req, res, (0, markError_1.parseBody)(username), (deleteKCRes) => {
                        if (deleteKCRes == 1) {
                            sm.deleteMultiUser(req, res, sdata.ID, (errorr, resp) => {
                                if (errorr == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare(resp);
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare(resp);
                                    objv.execute();
                                }
                            });
                            // let obj = new ModelRawNonQuery(req, res);
                            // obj.nonqrysql = "DELETE FROM `user` WHERE iduser = '" + sdata.ID + "'";
                            // obj.prepare();
                            // obj.execute((_error: any, lastid: any) => {
                            //     if (_error == 1) {
                            //         if (lastid.affectedRows <= 0) {
                            //             let objv = new RawView(res);
                            //             objv.prepare({ message: "No user present with the request id!", data: lastid[0], status: 201 });
                            //             objv.execute();
                            //         } else {
                            //             let objv = new RawView(res);
                            //             objv.prepare({ message: "User Deleted Successfully!", data: lastid[0], status: 201 });
                            //             objv.execute();
                            //         }
                            //     }
                            //     else {
                            //         let objv = new RawView(res);
                            //         objv.prepare({ message: "Something Went Wrong With Connection!", error: _error, status: 502 });
                            //         objv.execute();
                            //     }
                            // });
                        }
                        else if (deleteKCRes == 2) {
                            sm.deleteMultiUser(req, res, sdata.ID, (errorr, resp) => {
                                if (errorr == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare(resp);
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare(resp);
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "User not deleted successfully!", error: _error, status: 502 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Connection!", error: _error, status: 502 });
                    objv.execute();
                }
            });
        });
    }
    deleteMultiUser(req, res, data, callback) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj.nonqrysql = "DELETE FROM `user` WHERE iduser = '" + data + "'";
        obj.prepare();
        obj.execute((_error, lastid) => {
            if (_error == 1) {
                if (lastid.affectedRows <= 0) {
                    callback(1, { message: "No user present with the request id!", data: lastid[0], status: 201 });
                }
                else {
                    callback(1, { message: "User Deleted Successfully!", data: lastid[0], status: 201 });
                }
            }
            else {
                callback(0, { message: "Something Went Wrong With Connection!", error: _error, status: 502 });
            }
        });
    }
    deleteUser(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, _sessdata) => {
            if (error == 1) {
                /* let sdata: any = req.query.id;
                let dData = JSON.parse(sdata); */
                let sdata = req.query;
                let dData;
                try {
                    dData = JSON.parse(sdata.id);
                }
                catch {
                    dData = (sdata.id);
                }
                let message = "";
                switch (true) {
                    case (!dData):
                        message = "Missing request Parameter";
                        break;
                    case (!dData?.iduser || ["", "null", "undefined"].includes(dData.iduser)):
                        message = "iduser is required";
                        break;
                    case (!Number.isInteger(Number(dData.iduser)) || Number(dData.iduser) <= 0):
                        message = "iduser must be integer";
                        break;
                    case (!dData?.idaccount || ["", "null", "undefined"].includes(dData.idaccount)):
                        message = "idaccount is required";
                        break;
                    case (!Number.isInteger(Number(dData.idaccount)) || Number(dData.idaccount) <= 0):
                        message = "idaccount must be integer";
                        break;
                    default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: message, status: 502 });
                    objv.execute();
                    return;
                }
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "CALL DeleteUser('" + dData.idaccount + "', '" + dData.iduser + "')";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Delete User Successfully!", status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    // Admin Side Delete and Restore
    DeleteCustomerAccount(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data ? req.body.data : req.body;
                let msg = '';
                switch (true) {
                    case !sdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let isDeleted = req.body.data && req.body.data !== undefined ? sdata.isDeleted : '1';
                    //let type: any = req.body.data && req.body.data !== undefined ? 'panel' : 'swagger';
                    let sesidaccount = req.body.data && req.body.data !== undefined ? sdata.sesidaccount : sessdata.idaccount;
                    var disDID = [];
                    disDID.length = 0;
                    disDID.splice(0, disDID.length);
                    var disDIDid = [];
                    disDIDid.length = 0;
                    disDIDid.splice(0, disDIDid.length);
                    var notdisDID = [];
                    notdisDID.length = 0;
                    notdisDID.splice(0, notdisDID.length);
                    var notdisDIDid = [];
                    notdisDIDid.length = 0;
                    notdisDIDid.splice(0, notdisDIDid.length);
                    let allCampaignkey = [];
                    /* let arrStr: any = '';
                    let TotalDays: any; */
                    let con = "";
                    if (isDeleted == 0) // restore
                        con = "`restore_date`=NOW()";
                    if (isDeleted == 1) // delete
                        con = "`pending_deleted_date`=NOW()";
                    let obju = new RawQuery_1.ModelRawQuery(req, res);
                    obju.qrysql = "SELECT `iduser`,`username` FROM user WHERE `idaccount`=" + sdata.sesidaccount + " AND `type`='2'";
                    obju.prepare();
                    obju.execute((usererr, userRes) => {
                        console.log("username :: ", userRes[0].username);
                        // from panel side hit -> restore account
                        if (isDeleted == 0) {
                            let allDID = [];
                            let allDIDId = [];
                            let allBrandId = [];
                            let allCampaign = [];
                            let allIdUsers = [];
                            keycloak.userEnableDisbale(req, res, { user_name: userRes[0].username, enabled: true }, (errRess, dataRess) => {
                                if (errRess == 1) {
                                    // Delete DID
                                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj0.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sdata.sesidaccount + "' AND `disconnect_did_status`='2'";
                                    obj0.prepare();
                                    obj0.execute((_errorDID, resultDID) => {
                                        if (_errorDID == 1) {
                                            let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            let qrystr = "INSERT INTO `did_log` (`account_id`, `did`, `iduser`, `disconnect_did_status`, `event_type`, `description`) VALUE ";
                                            for (let d of resultDID) {
                                                allDIDId.push(d.iddid);
                                                allDID.push(d.did);
                                                qrystr += "('" + sessdata.idaccount + "', '" + d.did + "', '" + sessdata.iduser + "', 1, 59, 'Bulk DID Deleted Restored'),";
                                            }
                                            if (allDIDId.length > 0) {
                                                // To create bulk log
                                                obj11.nonqrysql = qrystr.slice(0, -1);
                                                obj11.prepare();
                                                obj11.execute((err, data) => {
                                                });
                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status` = '1', `subscription_auto_renew`='true' WHERE `iddid` IN(" + allDIDId + ")";
                                                obj1.prepare();
                                                obj1.execute((_error, result) => {
                                                    if (_error == 1) {
                                                        console.log("All DID Restored", allDIDId);
                                                    }
                                                });
                                            }
                                        }
                                    });
                                    let obju = new RawQuery_1.ModelRawQuery(req, res);
                                    obju.qrysql = "SELECT `iduser` FROM user WHERE `idaccount`=" + sdata.sesidaccount + "";
                                    obju.prepare();
                                    obju.execute((_uerror, iduserRes) => {
                                        if (iduserRes.length > 0) {
                                            for (let u of iduserRes) {
                                                allIdUsers.push(u.iduser);
                                            }
                                            if (allIdUsers.length > 0) {
                                                // Delete Campaign
                                                let objc = new RawQuery_1.ModelRawQuery(req, res);
                                                objc.qrysql = "SELECT `id_campaign`,`campaign_key`,`iduser`,`idaccount` FROM campaign WHERE `deleted`= 0 AND `autoRenewal`='false' AND `iduser` IN(" + allIdUsers + ")";
                                                objc.prepare();
                                                objc.execute((_cerror, campaignRes) => {
                                                    if (campaignRes.length > 0) {
                                                        for (let c of campaignRes) {
                                                            allCampaign.push(c.id_campaign);
                                                            allCampaignkey.push({
                                                                iduser: c.iduser,
                                                                idaccount: c.idaccount,
                                                                campaign_key: c.campaign_key
                                                            });
                                                        }
                                                        let allCampaignIds = allCampaign.length > 0 ? allCampaign : "''";
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "UPDATE `campaign` SET `delete_date`= NULL WHERE `id_campaign` IN(" + allCampaignIds + ")";
                                                        obj1.prepare();
                                                        obj1.execute((errorCamp, resultCamp) => {
                                                            if (resultCamp.affectedRows > 0) {
                                                                let fun = new newcampaign_class_1.NewCampaign();
                                                                Promise.all(allCampaignkey.map((item) => {
                                                                    return new Promise((resolve, reject) => {
                                                                        fun.campaignAutoRenewal(req, res, item.campaign_key, item.idaccount, item.iduser, true, (error, resp) => {
                                                                            if (error == 1) {
                                                                                console.log("Campaign autorenewal true updated successfully:", resp);
                                                                                resolve(resp);
                                                                            }
                                                                            else {
                                                                                console.error("Error updating campaign:", error);
                                                                                reject(error);
                                                                            }
                                                                        });
                                                                    });
                                                                })).then(() => {
                                                                    console.log("All campaigns autorenewal updated successfully.");
                                                                }).catch(err => {
                                                                    console.error("Some campaigns failed to update:", err);
                                                                });
                                                                console.log("All Campaign Removed", allCampaign);
                                                            }
                                                        });
                                                    }
                                                });
                                                // Delete Brand
                                                let objb = new RawQuery_1.ModelRawQuery(req, res);
                                                objb.qrysql = "SELECT `idbrand` FROM brand WHERE `deleted`= 0 AND `delete_date` IS NOT NULL AND `iduser` IN(" + allIdUsers + ")";
                                                objb.prepare();
                                                objb.execute((_errB, brandRe) => {
                                                    if (brandRe.length > 0) {
                                                        for (let b of brandRe) {
                                                            allBrandId.push(b.idbrand);
                                                        }
                                                        let allBrandIDs = allBrandId.length > 0 ? allBrandId : "''";
                                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj2.nonqrysql = "UPDATE `brand` SET `delete_date` = NULL WHERE `idbrand` IN(" + allBrandIDs + ")";
                                                        obj2.prepare();
                                                        obj2.execute((_errorBrand, resultBrand) => {
                                                            if (resultBrand.length > 0) {
                                                                console.log("All Brand Removed", allBrandId);
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        }
                                    });
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `session` SET `isDeleted` = '0' WHERE `idaccount` = " + sesidaccount + "";
                                    obj.prepare();
                                    obj.execute((error, delSessRes) => {
                                        console.log("All Session Restored");
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "CALL ConnectionDeleteForAccount(" + sesidaccount + ",'restore')";
                                        obj.prepare();
                                        obj.execute((error, result) => {
                                            console.log(result);
                                        });
                                        /* let obj00 = new ModelRawQuery(req, res);
                                        obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sesidaccount + "";
                                        obj00.prepare();
                                        obj00.execute((error: any, resultIdEnPoints: any) => {

                                            let endPointId: any = [];
                                            for (let i of resultIdEnPoints) {
                                                endPointId.push(i.idendpoint)
                                            }
                                            let endPointIds = endPointId.length > 0 ? endPointId : "''";
                                            let obj01 = new ModelRawNonQuery(req, res);
                                            obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                                            obj01.prepare();
                                            obj01.execute((error: any, resInbound: any) => {
                                                console.log("Inbound Restored");
                                            })
                                            let obj02 = new ModelRawNonQuery(req, res);
                                            obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                                            obj02.prepare();
                                            obj02.execute((error: any, resOutbound: any) => {
                                                console.log("Outbound Restored");
                                            })
                                            let obj03 = new ModelRawNonQuery(req, res);
                                            obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                                            obj03.prepare();
                                            obj03.execute((error: any, resIp: any) => {
                                                console.log("IP Address Removed");
                                            })
                                            let obj04 = new ModelRawNonQuery(req, res);
                                            obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                                            obj04.prepare();
                                            obj04.execute((error: any, resRoute: any) => {
                                                console.log("Routing Removed");
                                            })
                                            let obj05 = new ModelRawNonQuery(req, res);
                                            obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '0' WHERE idendpoint IN (" + endPointIds + ")";
                                            obj05.prepare();
                                            obj05.execute((error: any, resHook: any) => {
                                                console.log("Hooksetting Removed");
                                            })
                                        }) */
                                        let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj0.nonqrysql = "UPDATE `api` SET `isDeleted` = '0' WHERE `idaccount` = " + sesidaccount + "";
                                        obj0.prepare();
                                        obj0.execute((error, delApiRes) => {
                                            console.log("Api Details Restored");
                                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj2.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '0' WHERE `idaccount` = " + sesidaccount + "";
                                            obj2.prepare();
                                            obj2.execute((error, result) => {
                                                console.log("All Connection Restored");
                                                // updation for both side (panel hit and swagger hit)
                                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj3.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + isDeleted + "', " + con + " WHERE `idaccount` = " + sesidaccount + "";
                                                obj3.prepare();
                                                obj3.execute((_error, result) => {
                                                    if (_error == 1) {
                                                        // if (sdata.selectedoption == "deleteWithAccounting") {
                                                        //     let fun = new AccountDelete();
                                                        //     fun.closingInvoice(req, res, sdata, next);
                                                        // }
                                                        // if (sdata.checkbox == true && sdata.selectedoption == "deleteWithoutAccounting") {
                                                        //     let mail = new UserManagement();
                                                        //     mail.EmailSend(req, res, sdata, next)
                                                        // }
                                                        // if (sdata.selectedoption == "deleteWithoutAccounting") {
                                                        //     let objv = new RawView(res);
                                                        //     objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                                        //     objv.execute();
                                                        // }
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ message: "Something Went Wrong With Delete Customer!", status: 502 });
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        });
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Delete Customer Account!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            // from swagger and panel side hit delete account
                            let objS = new RawQuery_1.ModelRawQuery(req, res);
                            objS.qrysql = "SELECT `authKey` FROM `session` WHERE `idaccount`=" + sesidaccount + "";
                            objS.prepare();
                            objS.execute((errKey, delKey) => {
                                if (errKey == 1) {
                                    if (delKey.length > 0) {
                                        for (let x of delKey) {
                                            server_1.sessiondata.delete(x.authKey);
                                        }
                                    }
                                }
                                let obj22 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj22.nonqrysql = "UPDATE `subscription_account` SET `status` = '0' WHERE idaccount ='" + sesidaccount + "'";
                                obj22.prepare();
                                obj22.execute((error, resOutbound) => {
                                    console.log("subscription account inactive");
                                });
                            });
                            if (sessdata.type == 1) {
                                keycloak.userEnableDisbale(req, res, { user_name: userRes[0].username, enabled: false }, (errRess, dataRess) => {
                                    if (errRess == 1) {
                                        let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj7.nonqrysql = "UPDATE `session` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                                        obj7.prepare();
                                        obj7.execute((error, delSessRes) => {
                                            console.log("All Session Removed");
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "CALL ConnectionDeleteForAccount(" + sesidaccount + ",'delete')";
                                            obj.prepare();
                                            obj.execute((error, result) => {
                                                console.log(result);
                                            });
                                            /* let obj00 = new ModelRawQuery(req, res);
                                            obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sesidaccount + "";
                                            obj00.prepare();
                                            obj00.execute((error: any, resultIdEnPoint: any) => {
                                                let endPointId: any = [];
                                                for (let i of resultIdEnPoint) {
                                                    endPointId.push(i.idendpoint)
                                                }
                                                let endPointIds = endPointId.length > 0 ? endPointId : "''";
                                                let obj01 = new ModelRawNonQuery(req, res);
                                                obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                obj01.prepare();
                                                obj01.execute((error: any, resInbound: any) => {
                                                    console.log("Inbound Removed");
                                                })
                                                let obj02 = new ModelRawNonQuery(req, res);
                                                obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                obj02.prepare();
                                                obj02.execute((error: any, resOutbound: any) => {
                                                    console.log("Outbound Removed");
                                                })

                                                let obj03 = new ModelRawNonQuery(req, res);
                                                obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                obj03.prepare();
                                                obj03.execute((error: any, resIp: any) => {
                                                    console.log("IP Address Removed");
                                                })
                                                let obj04 = new ModelRawNonQuery(req, res);
                                                obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                obj04.prepare();
                                                obj04.execute((error: any, resRoute: any) => {
                                                    console.log("Routing Removed");
                                                })
                                                let obj05 = new ModelRawNonQuery(req, res);
                                                obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                obj05.prepare();
                                                obj05.execute((error: any, resHook: any) => {
                                                    console.log("Hooksetting Removed");
                                                })
                                            }) */
                                            let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj8.nonqrysql = "UPDATE `api` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                                            obj8.prepare();
                                            obj8.execute((error, delApiRes) => {
                                                console.log("Api Details Removed");
                                                let obj9 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj9.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                                                obj9.prepare();
                                                obj9.execute((error, result) => {
                                                    console.log("All Connection Removed");
                                                });
                                            });
                                        });
                                        //updation for both side (panel hit and swagger hit)
                                        let obj10 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj10.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + isDeleted + "', " + con + " WHERE `idaccount` = " + sesidaccount + "";
                                        obj10.prepare();
                                        obj10.execute((errorr, result) => {
                                            if (errorr == 1) {
                                                if (sdata.selectedoption == "deleteWithAccounting") {
                                                    let fun = new AccountDelete_1.AccountDelete();
                                                    fun.closingInvoice(req, res, sdata, next);
                                                }
                                                if (sdata.checkbox == true && sdata.selectedoption == "deleteWithoutAccounting") {
                                                    let mail = new UserManagement();
                                                    mail.EmailSend(req, res, sdata, next);
                                                }
                                                if (sdata.selectedoption == "deleteWithoutAccounting") {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Something Went Wrong With Delete Customer!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Delete Customer Account!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else if (sessdata.type == 2) {
                                let Obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                Obj4.qrysql = "SELECT `balance` FROM `wallet` WHERE `idaccount`=" + sesidaccount + " AND (`balance` + `credit_limit`) >= 0";
                                Obj4.prepare();
                                Obj4.execute((crErr, crRes) => {
                                    if (crErr == 1 && crRes.length > 0) {
                                        let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj5.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sesidaccount + "' AND `disconnect_did_status`='1'";
                                        obj5.prepare();
                                        obj5.execute((_errorDID, resultDID) => {
                                            let DIDIds = [];
                                            for (let x of resultDID) {
                                                DIDIds.push(x.iddid);
                                            }
                                            let didid = DIDIds.length > 0 ? DIDIds : "''";
                                            let obj6 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj6.qrysql = "SELECT t.day_num,d.iddid,d.created_at,d.did,d.did_disconnect_days, DATEDIFF(NOW(), d.`created_at`) AS remaining_days FROM `did_buy` d INNER JOIN `user` u ON d.iduser=u.iduser INNER JOIN `tariff` t ON u.idtariff=t.idtariff WHERE d.iddid IN(" + didid + ")";
                                            obj6.prepare();
                                            obj6.execute((errday, resday) => {
                                                if (errday == 1) {
                                                    if (resday.length > 0) {
                                                        for (let y of resday) {
                                                            /* let did_buy_date = y.created_at;
                                                            let today_date: any = new Date();
                                                            const oneDay = 1000 * 60 * 60 * 24;
                                                            const diffInTime = today_date.getTime() - did_buy_date.getTime();
                                                            TotalDays = Math.round(diffInTime / oneDay);
                                                            if (TotalDays) {
                                                                if (TotalDays > y.day_num) {
                                                                    disDID.push(y.did);
                                                                    disDIDid.push(y.iddid);
                                                                } else {
                                                                    notdisDID.push(y.did);
                                                                    notdisDIDid.push(y.iddid);
                                                                }
                                                            } */
                                                            if (y.remaining_days >= y.did_disconnect_days) {
                                                                disDID.push(y.did);
                                                                disDIDid.push(y.iddid);
                                                            }
                                                            else {
                                                                notdisDID.push(y.did);
                                                                notdisDIDid.push(y.iddid);
                                                            }
                                                        }
                                                        if (notdisDIDid.length > 0) {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                status: 502, message: "This account cannot be deleted because [" + notdisDID.length + "] DIDs Are Active and [" + disDIDid.length + "] DIDs are inActive.",
                                                                data: { notDisconnectDid: { message: "Not Disconnected DIDs Data", didCount: notdisDID.length, did: notdisDID }, disconnectDid: { message: "Disconnected DIDs Data", didCount: disDID.length, did: disDID } }
                                                            });
                                                            objv.execute();
                                                        }
                                                    }
                                                    else {
                                                        keycloak.userEnableDisbale(req, res, { user_name: sessdata.username, enabled: false }, (errRess, dataRess) => {
                                                            if (errRess == 1) {
                                                                let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj7.nonqrysql = "UPDATE `session` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                                                                obj7.prepare();
                                                                obj7.execute((__error, delSessRes) => {
                                                                    console.log("All Session Removed");
                                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj.nonqrysql = "CALL ConnectionDeleteForAccount(" + sesidaccount + ",'delete')";
                                                                    obj.prepare();
                                                                    obj.execute((error, result) => {
                                                                        console.log(result);
                                                                    });
                                                                    /* let obj00 = new ModelRawQuery(req, res);
                                                                    obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sesidaccount + "";
                                                                    obj00.prepare();
                                                                    obj00.execute((error: any, resultIdEnPoint: any) => {
                                                                        let endPointId: any = [];
                                                                        for (let i of resultIdEnPoint) {
                                                                            endPointId.push(i.idendpoint)
                                                                        }
                                                                        let endPointIds = endPointId.length > 0 ? endPointId : "''";
                                                                        let obj01 = new ModelRawNonQuery(req, res);
                                                                        obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                                        obj01.prepare();
                                                                        obj01.execute((error: any, resInbound: any) => {
                                                                            console.log("Inbound Removed");
                                                                        })
                                                                        let obj02 = new ModelRawNonQuery(req, res);
                                                                        obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                                        obj02.prepare();
                                                                        obj02.execute((error: any, resOutbound: any) => {
                                                                            console.log("Outbound Removed");
                                                                        })
                                                                        let obj03 = new ModelRawNonQuery(req, res);
                                                                        obj03.nonqrysql = "UPDATE `ip_address` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                                        obj03.prepare();
                                                                        obj03.execute((error: any, resIp: any) => {
                                                                            console.log("IP Address Removed");
                                                                        })
                                                                        let obj04 = new ModelRawNonQuery(req, res);
                                                                        obj04.nonqrysql = "UPDATE `routing_profile` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                                        obj04.prepare();
                                                                        obj04.execute((error: any, resRoute: any) => {
                                                                            console.log("Routing Removed");
                                                                        })
                                                                        let obj05 = new ModelRawNonQuery(req, res);
                                                                        obj05.nonqrysql = "UPDATE `hooksetting` SET `isDeleted` = '1' WHERE idendpoint IN (" + endPointIds + ")";
                                                                        obj05.prepare();
                                                                        obj05.execute((error: any, resHook: any) => {
                                                                            console.log("Hooksetting Removed");
                                                                        })
                                                                        let obj9 = new ModelRawNonQuery(req, res);
                                                                        obj9.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                                                                        obj9.prepare();
                                                                        obj9.execute((error: any, result: any) => {
                                                                            console.log("All Connection Removed");
                                                                        })
                                                                    }) */
                                                                    let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj8.nonqrysql = "UPDATE `api` SET `isDeleted` = '1' WHERE `idaccount` = " + sesidaccount + "";
                                                                    obj8.prepare();
                                                                    obj8.execute((error, delApiRes) => {
                                                                        console.log("Api Details Removed");
                                                                    });
                                                                });
                                                                //updation for both side (panel hit and swagger hit)
                                                                let obj10 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                obj10.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + isDeleted + "', " + con + " WHERE `idaccount` = " + sesidaccount + "";
                                                                obj10.prepare();
                                                                obj10.execute((_error, result) => {
                                                                    if (_error == 1) {
                                                                        if (sdata.selectedoption == "deleteWithAccounting") {
                                                                            let fun = new AccountDelete_1.AccountDelete();
                                                                            fun.closingInvoice(req, res, sdata, next);
                                                                        }
                                                                        if (sdata.checkbox == true && sdata.selectedoption == "deleteWithoutAccounting") {
                                                                            let mail = new UserManagement();
                                                                            mail.EmailSend(req, res, sdata, next);
                                                                        }
                                                                        if (sdata.selectedoption == "deleteWithoutAccounting") {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Account And Other Data Deleted!", status: 201 });
                                                                            objv.execute();
                                                                        }
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ message: "Something Went Wrong With Delete Customer!", status: 502 });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ message: "Something Went Wrong With Delete Customer Account!", status: 502 });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "DID Not Fetched!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Account Balance is Low!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "You have not access to Delete Account!", status: 502 });
                                objv.execute();
                            }
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    EmailSend(req, res, sdata, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession(async (error, sessdata) => {
            if (error == 1) {
                let objem = new RawQuery_1.ModelRawQuery(req, res);
                objem.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type` = 'close_account'";
                objem.prepare();
                objem.execute((____errorem, _resultem) => {
                    if (____errorem == 1 && _resultem.length > 0) {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT firstname , lastname, email FROM `user_profile` WHERE iduser = '" + sdata.sesiduser + "'";
                        obj1.prepare();
                        obj1.execute((____errorup, _resultup) => {
                            if (____errorup == 1) {
                                const formattedTemplate = _resultem[0].template
                                    .replace('{FIRST_NAME}', _resultup[0].firstname)
                                    .replace('{LAST_NAME}', _resultup[0].lastname);
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sdata.sesiduser + "','" + sdata.sesidaccount + "','" + FromEmail + "','" + (0, markError_1.parseBody)(_resultup[0].email) + "', '" + (0, markError_1.parseBody)(_resultem[0].subject) + "','" + (0, markError_1.parseBody)(formattedTemplate) + "','Account Deleted From Admin','26','" + _resultem[0].cc + "','" + _resultem[0].bcc + "')";
                                obj1.prepare();
                                obj1.execute((_err, __result) => {
                                    if (_err == 1) {
                                        console.log("Email Sent Succesfully!");
                                    }
                                    else {
                                        console.log("Opps Email Not Sent!");
                                    }
                                });
                            }
                            else {
                                console.log('Account Profile Not Found at the Time Closing Invoice');
                            }
                        });
                    }
                    else {
                        console.log('Live Payment Email Template Not Found at the Time Closing Invoice');
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    DeleteAccount(req, res, next) {
        let sdata = req.body.data;
        let msg = '';
        switch (true) {
            case !sdata:
                msg = 'Request body not found!';
                break;
        }
        if (msg) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        }
        else {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let allDID = [];
                    let allDIDId = [];
                    let allBrandId = [];
                    let allCampaign = [];
                    let allIdUsers = [];
                    // Delete DID
                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                    obj0.qrysql = "SELECT `iddid`,`did` FROM `did_buy` WHERE `account_id`='" + sdata.sesidaccount + "' AND `disconnect_did_status`='1'";
                    obj0.prepare();
                    obj0.execute((_errorDID, resultDID) => {
                        if (_errorDID == 1) {
                            for (let d of resultDID) {
                                allDIDId.push(d.iddid);
                                allDID.push(d.did);
                            }
                            if (allDIDId.length > 0) {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `did_buy` SET `disconnect_did_status` = '2' WHERE `iddid` IN(" + allDIDId + ")";
                                obj1.prepare();
                                obj1.execute((_error, result) => {
                                    if (_error == 1) {
                                        console.log("All DID Removed", allDIDId);
                                    }
                                });
                            }
                        }
                    });
                    let obju = new RawQuery_1.ModelRawQuery(req, res);
                    obju.qrysql = "SELECT `iduser` from user WHERE `idaccount`='" + sdata.sesidaccount + "'";
                    obju.prepare();
                    obju.execute((_uerror, iduserRes) => {
                        if (iduserRes.length > 0) {
                            for (let u of iduserRes) {
                                allIdUsers.push(u.iduser);
                            }
                            if (allIdUsers.length > 0) {
                                // Delete Campaign
                                let objc = new RawQuery_1.ModelRawQuery(req, res);
                                objc.qrysql = "SELECT `id_campaign` from campaign WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                                objc.prepare();
                                objc.execute((_cerror, campaignRes) => {
                                    if (campaignRes.length > 0) {
                                        for (let c of campaignRes) {
                                            allCampaign.push(c.id_campaign);
                                        }
                                        let allCampaignIds = allCampaign.length > 0 ? allCampaign : "''";
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `campaign` SET `deleted` = '2' WHERE `id_campaign` IN(" + allCampaignIds + ")";
                                        obj1.prepare();
                                        obj1.execute((errorCamp, resultCamp) => {
                                            if (resultCamp.length > 0) {
                                                console.log("All Campaign Removed", allCampaign);
                                            }
                                        });
                                    }
                                });
                                // Delete Brand
                                let objb = new RawQuery_1.ModelRawQuery(req, res);
                                objb.qrysql = "SELECT `idbrand` from brand WHERE `deleted`= 0 AND `iduser` IN(" + allIdUsers + ")";
                                objb.prepare();
                                objb.execute((_errB, brandRe) => {
                                    if (brandRe.length > 0) {
                                        for (let b of brandRe) {
                                            allBrandId.push(b.idbrand);
                                        }
                                        let allBrandIDs = allBrandId.length > 0 ? allBrandId : "''";
                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "UPDATE `brand` SET `deleted` = '2' WHERE `idbrand` IN(" + allBrandIDs + ")";
                                        obj2.prepare();
                                        obj2.execute((_errorBrand, resultBrand) => {
                                            if (resultBrand.length > 0) {
                                                console.log("All Brand Removed", allBrandId);
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    });
                    // add here delete feature for session,api and connection.
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE FROM `session` WHERE `idaccount`='" + sdata.sesidaccount + "' AND `isDeleted` = '1'";
                    obj.prepare();
                    obj.execute((__error, delSessRes) => {
                        console.log("All Session Remove");
                        let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "DELETE FROM `api` WHERE `idaccount`='" + sdata.sesidaccount + "' AND `isDeleted` = '1'";
                        obj0.prepare();
                        obj0.execute((___error, delApiRes) => {
                            console.log("Api Details Remove");
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "DELETE FROM `endpoint` WHERE `idaccount`='" + sdata.sesidaccount + "' AND `isDeleted` = '1'";
                            obj1.prepare();
                            obj1.execute((____error, result) => {
                                console.log("All Connection Remove");
                            });
                        });
                    });
                    // closed here
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "UPDATE `user` SET `is_deleted` = '" + sdata.isDeleted + "', `deleted_date`=NOW() WHERE `idaccount` = '" + sdata.sesidaccount + "'";
                    obj2.prepare();
                    obj2.execute((_errorDEL, resultDEL) => {
                        if (_errorDEL == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: allDID, message: "Account Successfully Deleted!", status: 201 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Release DID From Account Delete Process!", status: 502 });
                            objv.execute();
                        }
                    });
                    let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                    obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = '" + sdata.sesidaccount + "'";
                    obj00.prepare();
                    obj00.execute((____error, resultIdEnPoint) => {
                        let endPointId = [];
                        for (let i of resultIdEnPoint) {
                            endPointId.push(i.idendpoint);
                        }
                        let endPointIds = endPointId.length > 0 ? endPointId : "''";
                        let obj01 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj01.nonqrysql = "UPDATE `inbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                        obj01.prepare();
                        obj01.execute((error, resInbound) => {
                            if (sdata.isDeleted == 0) {
                                console.log("Inbound Restored");
                            }
                            else {
                                console.log("Inbound Removed");
                            }
                        });
                        let obj02 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj02.nonqrysql = "UPDATE `outbound` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE idendpoint IN (" + endPointIds + ")";
                        obj02.prepare();
                        obj02.execute((error, resOutbound) => {
                            if (sdata.isDeleted == 0) {
                                console.log("Outbound Restored");
                            }
                            else {
                                console.log("OutBound Removed");
                            }
                        });
                    });
                    let obj03 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj03.nonqrysql = "UPDATE `endpoint` SET `isDeleted` = '" + sdata.isDeleted + "' WHERE `idaccount` = '" + sdata.sesidaccount + "'";
                    obj03.prepare();
                    obj03.execute((____error, result) => {
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare({ status: 401, message: "Unauthorized User!" });
                    objv.execute();
                }
            });
        }
    }
    /* * * * * * * * * *
     * To check balance
     */
    checkBalance(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((errorSes, sessData) => {
            if (errorSes == 1) {
                let data = req.query;
                if (!data || !data.apiKey || data.apiKey == '' || data.apiKey == 'null' || data.apiKey === 'undefined') {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: "apikey not found!" });
                    objv.execute();
                    return;
                }
                let um = new UserManagement();
                um.getSessData(req, res, data.apiKey, next, (err, idacc) => {
                    if (err == 1 && idacc > 1) {
                        let base = new APIBase_1.APIBase();
                        base.checkSwaggerBalance(req, res, idacc, (errorR, resR) => {
                            if (errorR == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, message: "Available Balance", data: { balance: resR.balance } });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 403, message: "Balance not found!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 404, message: "apiKey not found!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getSessData(req, res, akey, next, callback) {
        if (server_1.sessiondata.has(akey)) {
            let currSess = server_1.sessiondata.get(akey);
            callback(1, currSess.idaccount);
        }
        else {
            if (server_1.invalidsessdata.has(akey)) {
                callback(0, '');
            }
            else {
                let obj00 = new RawQuery_1.ModelRawQuery(req, res);
                obj00.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `isCard`, `newUser_status`, `idapi`, `isAddress`, `isPlan`, `tz_diff`, `server_time`, `client_time`, `sessionType`, `authkey` FROM `session` WHERE `isDeleted`=0 AND `authkey` = '" + akey + "'";
                obj00.prepare();
                obj00.execute((err, res) => {
                    if (err == 1 && res.length > 0) {
                        server_1.sessiondata.set(akey, res[0]);
                        callback(1, res[0].idaccount);
                    }
                    else {
                        server_1.invalidsessdata.set(akey, '');
                        callback(0, '');
                    }
                });
            }
        }
    }
    // public TaxAuthentication(req: Request, res: Response, next: NextFunction) {
    //     console.log(req.body.data);
    //     let sdata = req.body.data
    //     var request = require('request');
    //     var options = {
    //         'method': 'POST',
    //         'url': sdata.url,
    //         'headers': {
    //             'Content-Type': 'application/json'
    //         },
    //         body: JSON.stringify(sdata.data)
    //     };
    //     request(options, function (error: any, response: any) {
    //         console.log(response.body)
    //         let objv = new RawView(res);
    //         objv.prepare(response.body);
    //         objv.execute();
    //     });
    // }
    TaxCalculation(req, res, _next) {
        let sdata = req.body.data;
        let msg = '';
        switch (true) {
            case !sdata:
                msg = 'Request body not found!';
                break;
        }
        if (msg) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        }
        else {
            var request = require('request');
            var options = {
                'method': 'POST',
                'url': 'http://localhost/avatax/php/trunk/charges/cal_taxaxtion',
                'headers': {
                    'Content-Type': 'application/json',
                    'Cookie': 'AuthToken=' + sdata.data.token
                },
                body: JSON.stringify(sdata.data)
            };
            request(options, function (_error, response) {
                if (!_error) {
                    try {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(response.body);
                        objv.execute();
                    }
                    catch (e) {
                        console.log("Error :: TaxCalculation::", e);
                        let obj = new RawView_1.RawView(res);
                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                        obj.execute();
                    }
                }
                else {
                    let obj = new RawView_1.RawView(res);
                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                    obj.execute();
                }
            });
        }
    }
    /* public detailsCDR(req: Request, res: Response, next: NextFunction) {
        let sdata = req.query;
        let session = new SessionManagment(req, res, next);
        session.GetSession((_error: any, _sessdata: any) => {
            let obj = new ModelRawQuery(req, res);
            obj.qrysql = "SELECT * FROM cdr WHERE date1 = '" + sdata.from_date + "' AND date2= '" + sdata.to_date + "' AND ani= '" + sdata.from_ani + "' AND did= '" + sdata.to_did + "' AND callid= '" + sdata.call_id + "' ";
            obj.prepare();
            obj.execute((_error: any, lastid: any) => {
                let objv = new RawView(res);
                objv.prepare({ message: "Fetched Data Successfully!", data: lastid[0] });
                objv.execute();
            });
        });
    } */
    apiToken(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid2_22_201_202(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        const key = Str.random(30);
                        var rdata = req.body.data;
                        const prgmch = /^(?!.*<\/?[a-zA-Z][\w\-]*[^>]*>)(?!.*[=<>\/])(?!\s*$).+$/;
                        const isEmpty = (value) => value == undefined || value == null || value == '' || value == 'null' || value == 'undefined';
                        const isNumeric = (value) => /^[0-9]+$/.test(String(value));
                        const requiredFieldsBase = ['name'];
                        let requiredFields = [...requiredFieldsBase];
                        let message = "";
                        if (sessdata.type == 2 || sessdata.type == 201) {
                            requiredFields.push('user', 'account');
                            if (rdata && (rdata.idtariff != undefined && rdata.idtariff != null)) {
                                requiredFields.push('idtariff');
                            }
                        }
                        switch (true) {
                            case !rdata:
                                message = "Invalid request!";
                                break;
                            case requiredFields.some(f => isEmpty(rdata[f])):
                                const missingFields = requiredFields.filter(f => isEmpty(rdata[f]));
                                message = missingFields.join(', ') + ' ' + (missingFields.length > 1 ? 'are required!' : 'is required!');
                                break;
                            case ['user', 'account', 'idtariff'].some(f => rdata[f] != undefined && rdata[f] != null && (!isNumeric(rdata[f]) || Number(rdata[f]) <= 0)):
                                const invalidNumbers = ['user', 'account', 'idtariff'].filter(f => rdata[f] != undefined && rdata[f] != null && (!isNumeric(rdata[f]) || Number(rdata[f]) <= 0));
                                message = invalidNumbers.join(', ') + ' ' + (invalidNumbers.length > 1 ? 'must be numeric!' : 'must be numeric!');
                                break;
                            case rdata.status && (rdata.status != true && rdata.status != false):
                                message = "status must be true or false!";
                                break;
                            case (rdata.name && typeof rdata.name === 'string'):
                                rdata.name = rdata.name.replace(/\s/g, '').replace(/(\..*)\./g, '$1');
                                break;
                            case (rdata.name && !prgmch.test(rdata.name)):
                                message = "name is Invalid";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: message });
                            objv.execute();
                        }
                        else {
                            // let idaccount: any = (sessdata.type == 1) ? rdata.idaccount : sessdata.idaccount;
                            // let iduser: any = (sessdata.type == 1) ? rdata.iduser : sessdata.iduser;
                            let iduser = (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201) ? rdata.user : sessdata.iduser;
                            let idaccount = (sessdata.type == 1 || sessdata.type == 2 || sessdata.type == 201) ? rdata.account : sessdata.idaccount;
                            let obbjj = new RawQuery_1.ModelRawQuery(req, res);
                            obbjj.qrysql = "SELECT COUNT(idaccount) AS total_count FROM `api` WHERE `idaccount` = '" + idaccount + "';";
                            obbjj.prepare();
                            obbjj.execute((errorbbjj, ressultj) => {
                                if (errorbbjj == 1 && ressultj.length > 0) {
                                    let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj0.qrysql = "(SELECT `limit` AS ip_limit, `data_type` FROM `data_creation_limitation` WHERE `data_type` = 1 AND `idaccount` IN ('" + idaccount + "', 0) ORDER BY FIELD(`idaccount`, '" + idaccount + "', 0) LIMIT 1) UNION ALL (SELECT `limit` AS api_limit, `data_type` FROM `data_creation_limitation` WHERE `data_type` = 2 AND `idaccount` IN ('" + idaccount + "', 0) ORDER BY FIELD(`idaccount`, '" + idaccount + "', 0) LIMIT 1)";
                                    obj0.prepare();
                                    obj0.execute((error0, result0) => {
                                        if (error0 == 1 && result0.length > 0) {
                                            if (ressultj[0].total_count <= result0[0].ip_limit) {
                                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                obj.qrysql = "SELECT COUNT(*) AS total_ip_count FROM `api_ip` WHERE `idapi` IN (SELECT idapi FROM `api` WHERE idaccount = '" + idaccount + "')";
                                                obj.prepare();
                                                obj.execute((error, getCount) => {
                                                    if (error == 1 && getCount.length > 0) {
                                                        const existingCount = getCount[0].api_ip_count || 0;
                                                        let newIpCount = 0;
                                                        if (existingCount >= result0[1].ip_limit) {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                message: "You have reached the maximum limit of IPs (" + result0[1].ip_limit + ") for your account.",
                                                                status: 404
                                                            });
                                                            objv.execute();
                                                            return;
                                                        }
                                                        if (rdata.rangeip && rdata.ipdatas) {
                                                            newIpCount = parseInt(rdata.rangeip) || 0;
                                                        }
                                                        else if (Array.isArray(rdata?.IPArr) &&
                                                            rdata.IPArr.some((item) => typeof item?.ip === 'string' && item.ip.trim() !== '')) {
                                                            const uniqueIPs = [...new Set(rdata.IPArr.map((item) => item.ip.trim()))].filter(ip => ip !== '');
                                                            newIpCount = uniqueIPs.length;
                                                        }
                                                        const totalCount = existingCount + newIpCount;
                                                        const remainingLimit = result0[1].ip_limit - existingCount;
                                                        if (totalCount > result0[1].ip_limit) {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                message: "You can add only " + remainingLimit + " more IP(s).",
                                                            });
                                                            objv.execute();
                                                            return;
                                                        }
                                                        else {
                                                            // const sanitizeName = (value: string): string => value.replace(/\s/g, '').replace(/(\..*)\./g, '$1');
                                                            // rdata.name = sanitizeName(rdata.name);
                                                            let rStatus = !rdata.status || rdata.status == '' || rdata.status == 'Null' || rdata.status == null || rdata.status == 'undefined' ? false : rdata.status;
                                                            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                                            obj1.qrysql = "SELECT `name`,`key` FROM `api` where `name` = '" + (0, markError_1.parseBody)(rdata.name) + "' AND `iduser` = '" + rdata.user + "'";
                                                            obj1.prepare();
                                                            obj1.execute((_error, getConn) => {
                                                                if (getConn[0]) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        message: "Token Already Exists at This Account!",
                                                                        status: 404
                                                                    });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let idtariff = (sessdata.type == 2 || sessdata.type == 201) && rdata.idtariff !== undefined && rdata.idtariff !== null ? rdata.idtariff : sessdata.idtariff;
                                                                    if (idtariff < 0) {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({
                                                                            message: "There is no tariff selected in this account. please contact to administration.", status: 501
                                                                        });
                                                                        objv.execute();
                                                                        return;
                                                                    }
                                                                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                                                                    obj.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `isEmailVerify`, `isMobileVerify`, `isAddress`, `isPlan`, `isCard`,  `newUser_status`, `resetPassword`, `kyc_verify_status`, `is_deleted`,`status` FROM `user` WHERE `iduser` = '" + iduser + "'";
                                                                    obj.prepare();
                                                                    obj.execute((errorr, getUser) => {
                                                                        if (errorr == 1 && getUser.length > 0) {
                                                                            let Status = getUser[0].status == '' || getUser[0].status == 'Null' || getUser[0].status == null ? false : getUser[0].status;
                                                                            let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                            obj5.nonqrysql = "INSERT INTO `api` (`idaccount`, `iduser`, `idtariff`, `name`, `key`, `path`,`isDeleted`,`api_type`) VALUES(" + idaccount + ", " + iduser + ", " + (0, markError_1.setToZero)(idtariff) + " ,'" + (0, markError_1.parseBody)(rdata.name) + "', '" + key + "', '" + rStatus + "', '" + getUser[0].is_deleted + "','" + (0, markError_1.setToZero)(rdata.ipdata) + "')";
                                                                            obj5.prepare();
                                                                            obj5.execute((eerror, result) => {
                                                                                if (eerror == 1) {
                                                                                    if (rdata.IPArr && rdata.IPArr.some((item) => item.ip && item.ip.trim() !== '') || (rdata.ipdatas && rdata.rangeip)) {
                                                                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                        if (rdata.IPArr && rdata.IPArr.some((item) => item.ip && item.ip.trim() !== '')) {
                                                                                            const uniqueIPs = [...new Set(rdata.IPArr.map((item) => item.ip.trim()))].filter(ip => ip !== '');
                                                                                            let qry = "INSERT INTO `api_ip`(`idapi`, `ip`) VALUES ";
                                                                                            for (let ip of uniqueIPs) {
                                                                                                qry += `('${(0, markError_1.setToZero)(result.insertId)}','${ip}'),`;
                                                                                            }
                                                                                            obj3.nonqrysql = qry.slice(0, -1);
                                                                                            obj3.prepare();
                                                                                        }
                                                                                        else {
                                                                                            let baseIp = rdata.ipdatas;
                                                                                            let range = parseInt(rdata.rangeip) || 0;
                                                                                            function ipToNum(ip) {
                                                                                                // only run for real strings that look like IPv4
                                                                                                if (typeof ip !== 'string')
                                                                                                    return null;
                                                                                                const parts = ip.split('.');
                                                                                                if (!Array.isArray(parts) || parts.length !== 4)
                                                                                                    return null;
                                                                                                const nums = parts.map(p => {
                                                                                                    // disallow empty, leading/trailing spaces are trimmed
                                                                                                    const s = String(p).trim();
                                                                                                    if (s === '')
                                                                                                        return NaN;
                                                                                                    // parse in base 10 and avoid hex/octal pitfalls
                                                                                                    const n = Number(s);
                                                                                                    return Number.isFinite(n) ? Math.floor(n) : NaN;
                                                                                                });
                                                                                                // all must be 0..255
                                                                                                if (nums.some(n => Number.isNaN(n) || n < 0 || n > 255))
                                                                                                    return null;
                                                                                                // safe bit-shift conversion; >>> 0 makes it unsigned
                                                                                                return ((nums[0] << 24) | (nums[1] << 16) | (nums[2] << 8) | nums[3]) >>> 0;
                                                                                            }
                                                                                            function numToIp(num) {
                                                                                                return ((num >>> 24) + '.' + ((num >>> 16) & 255) + '.' + ((num >>> 8) & 255) + '.' + (num & 255));
                                                                                            }
                                                                                            let baseParts = baseIp.split('.').map(Number);
                                                                                            let lastOctet = baseParts[3];
                                                                                            let baseNum = ipToNum(baseIp);
                                                                                            let ipSet = new Set();
                                                                                            let totalToAdd;
                                                                                            if (range < lastOctet) {
                                                                                                totalToAdd = 1;
                                                                                            }
                                                                                            else {
                                                                                                let maxPossible = 255 - lastOctet + 1;
                                                                                                let requested = range - lastOctet + 1;
                                                                                                totalToAdd = Math.min(requested, maxPossible, 25);
                                                                                                if (totalToAdd < 1)
                                                                                                    totalToAdd = 1;
                                                                                            }
                                                                                            for (let i = 0; i < totalToAdd; i++) {
                                                                                                ipSet.add(numToIp(baseNum + i));
                                                                                            }
                                                                                            const uniqueIPs = Array.from(ipSet);
                                                                                            let qry2 = "INSERT INTO `api_ip`(`idapi`,`ip`) VALUES ";
                                                                                            for (let ip of uniqueIPs) {
                                                                                                qry2 += `('${(0, markError_1.setToZero)(result.insertId)}','${ip}'),`;
                                                                                            }
                                                                                            obj3.nonqrysql = qry2.slice(0, -1);
                                                                                            obj3.prepare();
                                                                                        }
                                                                                        obj3.execute((errors, resultIP) => {
                                                                                            if (errors == 1) {
                                                                                                console.log("IP Added Successfully");
                                                                                            }
                                                                                            else {
                                                                                                console.log("IP Not Added");
                                                                                            }
                                                                                        });
                                                                                    }
                                                                                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                    obj2.nonqrysql = "INSERT INTO `session` (`iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`,  `newUser_status`, `resetPassword`, `kyc_verify_status`, `isDeleted`, `tz_diff`, `server_time`, `client_time`, `sessionType`) VALUES(" + iduser + ", " + idaccount + ", '" + (0, markError_1.parseBody)(getUser[0].username) + "', '" + getUser[0].type + "', '" + getUser[0].default + "', " + (0, markError_1.setToZero)(idtariff) + ", '" + key + "', '" + Status + "', '" + getUser[0].isEmailVerify + "', '" + getUser[0].isMobileVerify + "', '" + (0, markError_1.setToZero)(result.insertId) + "', '" + getUser[0].isAddress + "', '" + getUser[0].isPlan + "', '" + getUser[0].isCard + "', '" + getUser[0].newUser_status + "', '" + getUser[0].resetPassword + "', '" + getUser[0].kyc_verify_status + "', '" + getUser[0].is_deleted + "', '" + sessdata.tz_diff + "', '" + sessdata.server_time + "', '" + sessdata.client_time + "', 'API')";
                                                                                    obj2.prepare();
                                                                                    obj2.execute((error, resultSess) => {
                                                                                        if (error == 1) {
                                                                                            let objv = new RawView_1.RawView(res);
                                                                                            objv.prepare({
                                                                                                status: 201, message: "Token Saved Successfully."
                                                                                            });
                                                                                            objv.execute();
                                                                                        }
                                                                                        else {
                                                                                            let objv = new RawView_1.RawView(res);
                                                                                            objv.prepare({
                                                                                                status: 503, message: "Token Not Saved!"
                                                                                            });
                                                                                            objv.execute();
                                                                                        }
                                                                                    });
                                                                                }
                                                                                else {
                                                                                    let objv = new RawView_1.RawView(res);
                                                                                    objv.prepare({
                                                                                        status: 502, message: "Something Went Wrong With API Token!"
                                                                                    });
                                                                                    objv.execute();
                                                                                }
                                                                            });
                                                                        }
                                                                    });
                                                                }
                                                            });
                                                        }
                                                    }
                                                    else {
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 502, message: "You have reached the maximum limit of " + result0[0].ip_limit + " API Tokens." });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Something Went Wrong!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Something Went Wrong!" });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getApiToken(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                validuser.checksessionvalid_1_2_22_201(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        if (!req.query) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 401, message: "Invalid request!" });
                            objv.execute();
                        }
                        else {
                            let con = '';
                            let ext_field;
                            if (sessdata.type == 22) {
                                con += "`iduser`=" + sessdata.iduser + " AND ";
                            }
                            if (sessdata.type == 2 || sessdata.type == 201) {
                                con += "`idaccount`=" + sessdata.idaccount + " AND ";
                            }
                            if (sessdata.type == 1) {
                                ext_field = "`iduser`,`idaccount`,";
                                con = '';
                            }
                            obj5.qrysql = "SELECT " + ext_field + " `idapi`,`name`,`key`,`created`,`api_type` FROM `api` WHERE " + con + " isDeleted='0'";
                            obj5.prepare();
                            obj5.execute((_error, result) => {
                                if (_error == 1) {
                                    if (result.length > 0) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            data: result,
                                            message: "Token Fetched Successfully!",
                                            status: 200
                                        });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            data: result,
                                            message: "No Data Found!",
                                            status: 404
                                        });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "Something Went Wrong With Connection!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    deleteApiToken(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessData) => {
            if (error == 1) {
                validuser.checksessionvalid_1_2_22_201(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let data = req.query.id;
                        let message = "";
                        if (!data) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 401, message: "Invalid request!" });
                            objv.execute();
                        }
                        else {
                            let apiid = data.split('@')[0];
                            let apikey = data.split('@')[1];
                            switch (true) {
                                case (!data || typeof data !== 'string' || data.indexOf('@') === -1):
                                    message = "Missing or Invalid Api key!";
                                    break;
                                case (!apiid || apiid == '' || apiid == 'null' || apiid == 'undefined'):
                                    message = "Before @ value is Required!";
                                    break;
                                case (!/^[1-9]\d*$/.test(apiid)):
                                    message = "Before @ must be an integer!";
                                    break;
                                case (!apikey || !/^[A-Za-z0-9_\-]{30}$/.test(apikey)):
                                    message = "After @ value must be equal to 30 and valid value!";
                                    break;
                                default:
                                    message = "";
                            }
                            if (message) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 507, message: message });
                                objv.execute();
                            }
                            else {
                                server_1.sessiondata.delete(apikey);
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "DELETE FROM `session` WHERE `authKey` = (SELECT `key` FROM `api` WHERE `idapi`='" + apiid + "')";
                                obj1.prepare();
                                obj1.execute((_errorKey, resultKey) => {
                                    if (_errorKey) {
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "DELETE FROM `api` WHERE `idapi` = '" + apiid + "'";
                                        obj.prepare();
                                        obj.execute((_error, result) => {
                                            console.log(_error, result);
                                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj2.nonqrysql = "DELETE FROM `api_ip` WHERE `idapi` = '" + apiid + "'";
                                            obj2.prepare();
                                            obj2.execute((_error, result) => {
                                                console.log("Releted IP delted from api_ip");
                                            });
                                            let mess = '';
                                            let status = '';
                                            switch (true) {
                                                case (_error == 1 && result.affectedRows > 0):
                                                    mess = "Api Key Deleted Successfully!";
                                                    status = "201";
                                                    break;
                                                case (_error == 1 && result.affectedRows == 0):
                                                    mess = "Api Token Does Not Exist!";
                                                    status = "502";
                                                    break;
                                                default:
                                                    mess = "";
                                                    status = "";
                                            }
                                            if (mess) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: mess, status: status });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Data not deleted from api!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Data not deleted from session", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    ViewIP(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                validuser.checksessionvalid_1_2_22_201(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        if (!req.query) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 401, message: "Invalid request!" });
                            objv.execute();
                        }
                        else {
                            obj5.qrysql = "SELECT `idapi`,`ip`,`api_ip_id` FROM `api_ip` WHERE `idapi`='" + req.query.type + "'";
                            obj5.prepare();
                            obj5.execute((_error, result) => {
                                if (_error == 1) {
                                    if (result.length > 0) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            data: result,
                                            message: "Ip Fetched Successfully!",
                                            status: 200
                                        });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            data: result,
                                            message: "No Data Found!",
                                            status: 404
                                        });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "Something Went Wrong With Connection!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    AddIp(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1_2_22_201(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let rdata = req.body.data.data;
                        let idapi = req.body.data.idapi;
                        let idaccount = (sessdata.type == 1) ? req.body.data.idaccount : sessdata.idaccount;
                        let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                        obj0.qrysql = "(SELECT `limit` AS ip_limit, `data_type` FROM `data_creation_limitation` WHERE `data_type` = 1 AND `idaccount` IN ('" + idaccount + "', 0) ORDER BY FIELD(`idaccount`, '" + idaccount + "', 0) LIMIT 1) UNION ALL (SELECT `limit` AS api_limit, `data_type` FROM `data_creation_limitation` WHERE `data_type` = 2 AND `idaccount` IN ('" + idaccount + "', 0) ORDER BY FIELD(`idaccount`, '" + idaccount + "', 0) LIMIT 1)";
                        obj0.prepare();
                        obj0.execute((error0, result0) => {
                            if (error0 == 1 && result0.length > 0) {
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                obj.qrysql = "SELECT COUNT(*) AS total_ip_count FROM `api_ip` WHERE `idapi` IN (SELECT idapi FROM `api` WHERE idaccount = '" + idaccount + "')";
                                obj.prepare();
                                obj.execute((error, getCount) => {
                                    if (error == 1 && getCount.length > 0) {
                                        const existingCount = getCount[0].api_ip_count || 0;
                                        let newIpCount = 0;
                                        if (existingCount >= result0[1].ip_limit) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "You have reached the maximum limit of " + result0[1].ip_limit + " IPs for all API Tokens.",
                                                status: 404
                                            });
                                            objv.execute();
                                            return;
                                        }
                                        if ((typeof rdata?.rangeip === 'string' || typeof rdata?.rangeip === 'number') &&
                                            rdata?.ipdatas) {
                                            // Safely convert to number
                                            const rangeIpVal = parseInt(rdata.rangeip, 10);
                                            newIpCount = Number.isFinite(rangeIpVal) ? rangeIpVal : 0;
                                        }
                                        else if (Array.isArray(rdata?.IPArr) &&
                                            rdata.IPArr.some((item) => typeof item?.ip === 'string' && item.ip.trim() !== '')) {
                                            // Safely handle IP array
                                            const uniqueIPs = [
                                                ...new Set(rdata.IPArr
                                                    .map((item) => (typeof item?.ip === 'string' ? item.ip.trim() : ''))
                                                    .filter((ip) => ip !== '')),
                                            ];
                                            newIpCount = uniqueIPs.length;
                                        }
                                        else {
                                            newIpCount = 0; // default fallback
                                        }
                                        const totalCount = existingCount + newIpCount;
                                        const remainingLimit = result0[1].ip_limit - existingCount;
                                        if (totalCount > result0[1].ip_limit) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                message: "You can add only " + remainingLimit + " more IP(s).",
                                            });
                                            objv.execute();
                                            return;
                                        }
                                        else {
                                            if (rdata.ipdata == '1') {
                                                if ((rdata.IPArr && rdata.IPArr.some((item) => item.ip && item.ip.trim() !== '')) || (rdata.ipdatas && rdata.rangeip)) {
                                                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj1.qrysql = "SELECT ip FROM `api_ip` WHERE idapi = '" + (0, markError_1.setToZero)(idapi) + "'";
                                                    obj1.prepare();
                                                    obj1.execute((checkErr, existingIPs) => {
                                                        if (checkErr == 1) {
                                                            const existingIPSet = new Set(existingIPs.map((row) => row.ip.trim()));
                                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            if (rdata.IPArr && rdata.IPArr.some((item) => item.ip && item.ip.trim() !== '')) {
                                                                const uniqueIPs = [...new Set(rdata.IPArr.map((item) => item.ip.trim()))]
                                                                    .filter(ip => ip !== '' && !existingIPSet.has(ip));
                                                                if (uniqueIPs.length === 0) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        message: "All IPs are already present on this token!",
                                                                        status: 404
                                                                    });
                                                                    objv.execute();
                                                                    return;
                                                                }
                                                                let qry = "INSERT INTO `api_ip`(`idapi`, `ip`) VALUES ";
                                                                for (let ip of uniqueIPs) {
                                                                    qry += `('${(0, markError_1.setToZero)(idapi)}','${ip}'),`;
                                                                }
                                                                obj3.nonqrysql = qry.slice(0, -1);
                                                                obj3.prepare();
                                                            }
                                                            else {
                                                                let baseIp = rdata.ipdatas;
                                                                let range = parseInt(rdata.rangeip) || 0;
                                                                function ipToNum(ip) {
                                                                    const parts = (typeof ip == 'string' && ip.includes('.'))
                                                                        ? ip.split('.').map(Number)
                                                                        : [];
                                                                    return ((parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8) | parts[3]) >>> 0;
                                                                }
                                                                function numToIp(num) {
                                                                    return [
                                                                        (num >>> 24) & 255,
                                                                        (num >>> 16) & 255,
                                                                        (num >>> 8) & 255,
                                                                        num & 255
                                                                    ].join('.');
                                                                }
                                                                const parts = baseIp.split('.').map(Number);
                                                                if (parts.length !== 4 || parts.some(isNaN)) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Invalid base IP", status: 400 });
                                                                    objv.execute();
                                                                    return;
                                                                }
                                                                const lastOctet = parts[3];
                                                                const baseNum = ipToNum(baseIp);
                                                                let startOctet = lastOctet;
                                                                let endOctet;
                                                                if (range < lastOctet) {
                                                                    endOctet = lastOctet;
                                                                }
                                                                else {
                                                                    endOctet = Math.min(range, lastOctet + 24, 255);
                                                                }
                                                                const totalToAdd = endOctet - startOctet + 1;
                                                                const ipCandidates = [];
                                                                for (let oct = 0; oct < totalToAdd; oct++) {
                                                                    ipCandidates.push(numToIp(baseNum + oct));
                                                                }
                                                                const uniqueIPs = ipCandidates.filter(ip => !existingIPSet.has(ip));
                                                                if (uniqueIPs.length === 0) {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        message: "All IPs are already present on this token!",
                                                                        status: 404
                                                                    });
                                                                    objv.execute();
                                                                    return;
                                                                }
                                                                let qry2 = "INSERT INTO `api_ip`(`idapi`,`ip`) VALUES ";
                                                                qry2 += uniqueIPs.map(ip => `('${(0, markError_1.setToZero)(idapi)}','${ip}')`).join(',');
                                                                obj3.nonqrysql = qry2;
                                                                obj3.prepare();
                                                            }
                                                            obj3.execute((errors, resultIP) => {
                                                                if (errors == 1) {
                                                                    let obbjj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obbjj.nonqrysql = "UPDATE `api` SET `api_type`='" + rdata.ipdata + "' WHERE `idapi`='" + (0, markError_1.setToZero)(idapi) + "'";
                                                                    obbjj.prepare();
                                                                    obbjj.execute((error, result) => { });
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        message: "Ip Added Successfully!",
                                                                        status: 200
                                                                    });
                                                                    objv.execute();
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({
                                                                        message: "Something Went Wrong while Adding Ip!",
                                                                        status: 404
                                                                    });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({
                                                                message: "Something Went Wrong",
                                                                status: 404
                                                            });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                            }
                                            else {
                                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj.nonqrysql = "UPDATE `api` SET `api_type`='" + rdata.ipdata + "' WHERE `idapi`='" + (0, markError_1.setToZero)(idapi) + "'";
                                                obj.prepare();
                                                obj.execute((error, result) => {
                                                    if (error == 1) {
                                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj1.nonqrysql = "DELETE FROM `api_ip` WHERE `idapi` = '" + (0, markError_1.setToZero)(idapi) + "'";
                                                        obj1.prepare();
                                                        obj1.execute((errors, resultIP) => {
                                                            if (errors == 1) {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    message: "Ip Updated Successfully!",
                                                                    status: 200
                                                                });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    message: "Something Went Wrong while Adding Ip!",
                                                                    status: 404
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            message: "Something Went Wrong",
                                                            status: 404
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "Something Went Wrong",
                                            status: 404
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something Went Wrong!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    deleteip(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, _sessdata) => {
            validuser.checksessionvalid_1_2_22_201(req, res, _sessdata, (err, dt) => {
                if (err == 1) {
                    const data = JSON.parse(req.query.ID);
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT api_ip_id FROM api_ip WHERE idapi = " + data.idapi;
                    obj.prepare();
                    obj.execute((error1, result1) => {
                        if (error1 == 1 && result1 && result1.length > 0) {
                            const allIpIds = result1.map((r) => r.api_ip_id);
                            const ipsToDelete = data.ips.filter((id) => allIpIds.includes(id));
                            const remainingIps = allIpIds.filter((id) => !ipsToDelete.includes(id));
                            if (remainingIps.length === 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "At least one IP must remain on the token", status: 400 });
                                objv.execute();
                                return;
                            }
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "DELETE FROM `api_ip` WHERE api_ip_id IN (" + ipsToDelete.join(",") + ") AND idapi = " + data.idapi;
                            obj1.prepare();
                            obj1.execute((error2, resp) => {
                                if (error2 == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "IP(s) deleted successfully!", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something went wrong while deleting", status: 500 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "No IPs found for this idapi.", status: 404 });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare(dt);
                    objv.execute();
                }
            });
        });
    }
    copyToken(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            validuser.checksessionvalid2_22_201_202(req, res, sessdata, (err, dt) => {
                if (err == 1) {
                    let idapi = req.body.data;
                    let msg = '';
                    switch (true) {
                        case !req.body.data:
                            msg = 'Request body not found!';
                            break;
                    }
                    if (msg) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 404, message: msg });
                        objv.execute();
                        return;
                    }
                    else {
                        const key = Str.random(30);
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `iduser`,`idaccount`,`api_type`,`name`,`type`,`path` FROM `api` WHERE `idapi` = '" + idapi + "'";
                        obj.prepare();
                        obj.execute((error1, getApi) => {
                            if (error1 == 1 && getApi.length > 0) {
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `isEmailVerify`, `isMobileVerify`, `isAddress`, `isPlan`, `isCard`,  `newUser_status`, `resetPassword`, `kyc_verify_status`, `is_deleted`,`status` FROM `user` WHERE `iduser` = '" + getApi[0].iduser + "'";
                                obj1.prepare();
                                obj1.execute((errorr, getUser) => {
                                    if (errorr == 1 && getUser.length > 0) {
                                        let Status = getUser[0].status == '' || getUser[0].status == 'Null' || getUser[0].status == null ? false : getUser[0].status;
                                        let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj5.nonqrysql = "INSERT INTO `api` (`idaccount`, `iduser`, `idtariff`, `name`, `key`, `path`, `isDeleted`, `api_type`) VALUES(" + getApi[0].idaccount + "," + getApi[0].iduser + "," + (0, markError_1.setToZero)(getUser[0].idtariff) + ",'" + (0, markError_1.parseBody)(getApi[0].name) + " - copy','" + key + "','" + getApi[0].path + "','" + getUser[0].is_deleted + "','" + (0, markError_1.setToZero)(getApi[0].api_type) + "')";
                                        obj5.prepare();
                                        obj5.execute((eerror, result) => {
                                            if (eerror == 1) {
                                                if (getApi[0].api_type == 1) {
                                                    let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj3.qrysql = "SELECT `ip` FROM `api_ip` WHERE `idapi` = '" + idapi + "'";
                                                    obj3.prepare();
                                                    obj3.execute((error3, getIP) => {
                                                        if (error3 == 1 && getIP.length > 0) {
                                                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            let qry = "INSERT INTO `api_ip`(`idapi`, `ip`) VALUES ";
                                                            for (let i = 0; i < getIP.length; i++) {
                                                                qry += "('" + (0, markError_1.setToZero)(result.insertId) + "','" + getIP[i].ip + "'),";
                                                            }
                                                            obj4.nonqrysql = qry.slice(0, -1);
                                                            obj4.prepare();
                                                            obj4.execute((errors, resultIP) => {
                                                                if (errors == 1) {
                                                                    console.log("IP Copied Successfully");
                                                                }
                                                                else {
                                                                    console.log("IP Not Copied");
                                                                }
                                                            });
                                                        }
                                                        else {
                                                        }
                                                    });
                                                }
                                                else {
                                                    console.log("API Type is not 1, skipping IP copy.");
                                                }
                                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj2.nonqrysql = "INSERT INTO `session` (`iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`,  `newUser_status`, `resetPassword`, `kyc_verify_status`, `isDeleted`, `tz_diff`, `server_time`, `client_time`, `sessionType`) VALUES(" + getUser[0].iduser + ", " + getUser[0].idaccount + ", '" + (0, markError_1.parseBody)(getUser[0].username) + "', '" + getUser[0].type + "', '" + getUser[0].default + "', " + (0, markError_1.setToZero)(getUser[0].idtariff) + ", '" + key + "', '" + Status + "', '" + getUser[0].isEmailVerify + "', '" + getUser[0].isMobileVerify + "', '" + (0, markError_1.setToZero)(result.insertId) + "', '" + getUser[0].isAddress + "', '" + getUser[0].isPlan + "', '" + getUser[0].isCard + "', '" + getUser[0].newUser_status + "', '" + getUser[0].resetPassword + "', '" + getUser[0].kyc_verify_status + "', '" + getUser[0].is_deleted + "', '" + sessdata.tz_diff + "', '" + sessdata.server_time + "', '" + sessdata.client_time + "', 'API')";
                                                obj2.prepare();
                                                obj2.execute((error, resultSess) => {
                                                    if (error == 1) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            status: 201, message: "Token Saved Successfully."
                                                        });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            status: 503, message: "Token Not Saved!"
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    status: 502, message: "Something Went Wrong With API Token!"
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            status: 502, message: "Something Went Wrong With API Token!"
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: 502, message: "Something Went Wrong With API Token!"
                                });
                                objv.execute();
                            }
                        });
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare(dt);
                    objv.execute();
                }
            });
        });
    }
    saveTheme(req, res, next) {
        var rdata = [];
        rdata = req.body.data;
        let msg = '';
        switch (true) {
            case !rdata:
                msg = 'Request body not found!';
                break;
        }
        if (msg) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        }
        else {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    obj2.nonqrysql = "INSERT into `theme` (`idaccount`, `brandName`, `domain`, `customLogo`, `email`, `phone`, `support_url`, `header_color`, `navbar_color`, `sidebar_color`, `ssl_certificate`, `ssl_key`) VALUES('" + sessdata.idaccount + "', '" + rdata.brandName + "', '" + rdata.domain + "', '" + rdata.custom_logo + "', '" + (0, markError_1.parseBody)(rdata.email) + "', '" + rdata.phone + "', '" + rdata.support_url + "', '" + rdata.header_color + "', '" + rdata.navbar_color + "', '" + rdata.sidebar_color + "', '" + rdata.ssl_certificate + "', '" + rdata.ssl_key + "')";
                    obj2.prepare();
                    obj2.execute((_error, result) => {
                        if (result) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ data: result, message: "Theme Saved Successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Successfully!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare({ status: 401, message: "Unauthorized User!" });
                    objv.execute();
                }
            });
        }
    }
    updateTheme(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let filePath;
                let rdata = [];
                rdata = JSON.parse(req.body.data);
                let msg = '';
                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    if (req.file) {
                        const fileName = req.file.filename;
                        filePath = msAPIURL.SignalmashAPIURL + '/uploads/' + fileName;
                    }
                    else if (rdata.logo == undefined || rdata.logo == null) {
                        filePath = "./assets/img/logo.png";
                    }
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.filter = null;
                    obj2.nonqrysql = "UPDATE `theme` SET `brandName`='" + rdata.brandName + "', `domain`='" + rdata.domain + "', `customLogo`='" + filePath + "', `email`='" + rdata.email + "', `phone`='" + rdata.phone + "', `support_url`='" + rdata.support_url + "', `header_color`='" + rdata.header_color + "', `navbar_color`='" + rdata.navbar_color + "', `sidebar_color`='" + rdata.sidebar_color + "', `ssl_certificate`='" + rdata.ssl_certificate + "', `ssl_key`='" + rdata.ssl_key + "' WHERE `id_theme`='" + rdata.id_theme + "'";
                    obj2.prepare();
                    obj2.execute((error, allcamp) => {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 0,
                            data: allcamp,
                            message: "Theme Updated Successfully"
                        });
                        objv.execute();
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getThemes(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `id_theme`,`idaccount`,`brandName`,`domain`,`customLogo`,`email`,`phone`,`support_url`,`header_color`,`navbar_color`,`navbar_color`,`sidebar_color`,`ssl_certificate`,`ssl_key` FROM `theme` WHERE `idaccount` = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (result.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Theme data Fetched!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "NO Data Found!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getTheme(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "select `id_theme`,`idaccount`,`brandName`,`domain`,`customLogo`,`email`,`phone`,`support_url`,`header_color`,`navbar_color`,`navbar_color`,`sidebar_color`,`ssl_certificate`,`ssl_key` from theme where id_theme='" + req.query.type + "' AND idaccount = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Theme data Fetched!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    deleteTheme(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = "delete from `theme` WHERE `id_theme` = '" + req.query.id + "' AND idaccount = '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Theme Deleted Successfully!", data: result });
                    objv.execute();
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    saveOtp(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                let sdata = req.body;
                let msg = '';
                switch (true) {
                    case !sdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let verification_through;
                    let verification_via = 0;
                    if (sdata.otp) {
                        verification_through = 1;
                    }
                    else {
                        verification_through = 0;
                    }
                    let otp = Math.floor(100000 + Math.random() * 900000);
                    let TO = (typeof sdata?.TO === 'string')
                        ? sdata.TO.trim()
                        : (sdata?.TO ?? '');
                    sdata.otp = otp;
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `ip_address`, `contact` FROM `domain_block` WHERE `ip_address` = '" + sysInfo.ipAddress[0] + "' OR `contact` = '" + TO + "'";
                    obj.prepare();
                    obj.execute((_errDomainBlk, getDomainBlock) => {
                        if (_errDomainBlk == 1 && getDomainBlock.length > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Invalid Account Registration!",
                                status: 501
                            });
                            objv.execute();
                        }
                        else {
                            let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                            obj4.qrysql = "SELECT `firstname`,`lastname` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                            obj4.prepare();
                            obj4.execute((_error, user) => {
                                let getUser = user[0];
                                if (error == 1) {
                                    let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj5.qrysql = "SELECT `body` FROM `sms_template` WHERE type='mobile_verification'";
                                    obj5.prepare();
                                    obj5.execute((emlErr, emlRes) => {
                                        if (emlErr == 1 && emlRes.length > 0) {
                                            let BODY = emlRes[0].body;
                                            BODY = BODY.replace(/{FIRST_NAME}/g, getUser.firstname);
                                            BODY = BODY.replace(/{LAST_NAME}/g, getUser.lastname);
                                            BODY = BODY.replace(/{OTP}/g, sdata.otp);
                                            let key = Str.random(30);
                                            var headers = {
                                                'accept': '*/*',
                                                'Authorization': msAPIURL.SignalmashSMSAuthKey,
                                                'Content-Type': 'application/x-www-form-urlencoded'
                                            };
                                            /* let TO =  (typeof sdata?.sdata.sdata.TO == 'string')
  ? sdata.TO.trim()
  : sdata.TO; */
                                            // var dataString = 'FROM=' + smNumber.otpviasms + '&TO=' +TO+ '&BODY=' + BODY + '&Connection=&OutboundSMS=';
                                            var options = {
                                                url: msAPIURL.SignalmashSMSAPIURL + '/sms',
                                                method: 'POST',
                                                headers: headers,
                                                body: JSON.stringify({
                                                    FROM: smNumber.otpviasms,
                                                    TO: TO,
                                                    BODY: BODY,
                                                    Connection: "",
                                                    OutboundSMS: ""
                                                })
                                            };
                                            (0, axios_1.request)(options, (sms_err, sms_responce) => {
                                                try {
                                                    if (sms_responce && sms_responce.headers['content-type'].includes('application/json') && sms_responce.body !== undefined && sms_responce.body) {
                                                        let sms_resp = JSON.parse(sms_responce.body);
                                                        if (sms_resp.status == 201) {
                                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                            obj.nonqrysql = "INSERT INTO `two_factor_auth` (`iduser`, `otp`, `from`, `to`, `session_id`) VALUES(" + sessdata.iduser + ", " + (0, markError_1.setToZero)(sdata.otp) + ", '" + smNumber.otpviasms + "', '" + sdata.TO + "', '" + key + "')";
                                                            obj.prepare();
                                                            obj.execute((mdr_err, mdr_resp) => {
                                                                if (mdr_err == 1) {
                                                                    let obj = new RawView_1.RawView(res);
                                                                    obj.prepare({ result: "Success", data: mdr_resp, message: "OTP Sent Successfully", status: 201 });
                                                                    obj.execute();
                                                                }
                                                                else {
                                                                    let obj = new RawView_1.RawView(res);
                                                                    obj.prepare({ result: "Failed", message: "Something Went Wrong with Connection!", status: 502 });
                                                                    obj.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let obj = new RawView_1.RawView(res);
                                                            obj.prepare({ message: sms_resp.message, status: 503 });
                                                            obj.execute();
                                                        }
                                                    }
                                                    else {
                                                        let obj = new RawView_1.RawView(res);
                                                        obj.prepare({ message: 'OTP Not Sent!', status: 504 });
                                                        obj.execute();
                                                    }
                                                }
                                                catch (e) {
                                                    console.log("Error saveOtp ::", e);
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({ message: 'OTP Not Sent!', status: 504 });
                                                    obj.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare("SMS Template not Fateched Successfully!");
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare("User not Fateched Successfully!");
                                    objv.execute();
                                }
                            });
                        }
                    });
                    let objj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    objj0.nonqrysql = "INSERT INTO `phone_verification_log` (`iduser`,`idaccount`,`did`,`ipaddress`,`verification_through`,`verification_via`) VALUES ('" + sessdata.iduser + "', '" + sessdata.idaccount + "','" + TO + "','" + sysInfo.ipAddress[0] + "','" + (0, markError_1.setToZero)(verification_through) + "','" + (0, markError_1.setToZero)(verification_via) + "')";
                    objj0.prepare();
                    objj0.execute((_error, getresotp) => {
                        console.log("Log Inserted Successfully!");
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /* verifyOtp(req: Request, res: Response, next: NextFunction) {
        let sdata = req.body;
        let session = new SessionManagment(req, res, next);
        session.GetSession((err: any, sessdata: any) => {
            if (err == 1) {
                let obj = new ModelRawQuery(req, res);
                //obj.qrysql = "SELECT `otp` FROM `two_factor_auth` WHERE `iduser` = '" + sessdata.iduser + "' AND `otp`='" + sdata.otp + "' AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created)<300";
                obj.qrysql = "SELECT `otp` FROM `two_factor_auth` WHERE `iduser` = " + sessdata.iduser + " AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created)<300 ORDER BY id DESC LIMIT 1";
                obj.prepare();
                obj.execute((error: any, getEmail: any) => {
                    if (error == 1) {
                        if (getEmail.length > 0 && getEmail[0].otp == sdata.otp) {
                            let obj1 = new ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `user` SET `isEmailVerify`= 'true', `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                            obj1.prepare();
                            obj1.execute((_error: any, success: any) => {
                                if (_error == 1) {
                                    let obj5 = new ModelRawNonQuery(req, res);
                                    obj5.nonqrysql = "UPDATE `session` SET `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj5.prepare();
                                    obj5.execute((_sessErr: any, sessRes: any) => {
                                        if (_sessErr == 1) {
                                            let obj6 = new ModelRawNonQuery(req, res);
                                            obj6.nonqrysql = "UPDATE `user_profile` SET `phone`='" + sdata.TO + "' WHERE `iduser`='" + sessdata.iduser + "'";
                                            obj6.prepare();
                                            obj6.execute((_sessError: any, sessData: any) => {
                                                let objup = new ModelRawQuery(req, res);
                                                objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                                objup.prepare();
                                                objup.execute((__errorE: any, emailE: any) => {
                                                    if (_sessError == 1) {
                                                        let obj7 = new ModelRawQuery(req, res);
                                                        obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                                        obj7.prepare();
                                                        obj7.execute((sError: any, sData: any) => {
                                                            if (sError == 1) {

                                                                let tmp: string = "{\"email\": \"" + emailE[0].email + "\"}";
                                                                let emType = JSON.parse(tmp);
                                                                let sData1: any = Object.assign(sData, emType);
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    message: "OTP Verified Successfully!",
                                                                    status: 200,
                                                                    session: sData1
                                                                });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                let objv = new RawView(res);
                                                                objv.prepare({
                                                                    message: "OTP verified error with connection!",
                                                                    status: 502
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView(res);
                                                        objv.prepare({
                                                            message: "Mobile number not verified!",
                                                            status: 500
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let objv = new RawView(res);
                                            objv.prepare({
                                                errMessage: "Mobile number not verified!",
                                                status: 502
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView(res);
                                    objv.prepare({
                                        message: "Mobile number not verified!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({
                                message: "You have enter wrong OTP!",
                                status: 502
                            });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({
                            message: "Something went wrong with connection!",
                            status: 502
                        });
                        objv.execute();
                    }
                });
            } else {
                let objv = new Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    } */
    verifyOtp(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err === 1) {
                let sdata = req.body;
                let msg = '';
                switch (true) {
                    case !sdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `country` FROM `billing_address` WHERE `idaccount`='" + sessdata.idaccount + "'";
                    obj.prepare();
                    obj.execute((_err, result) => {
                        if (_err === 1) {
                            let country = result[0]?.country || '';
                            if (!['US', 'CA', 'USA', 'UNITED STATES', 'CANADA'].includes(country)) {
                                let objup = new RawQuery_1.ModelRawQuery(req, res);
                                objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                objup.prepare();
                                objup.execute((__errorE, emailE) => {
                                    if (__errorE === 1) {
                                        let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`, `newUser_status`, `tz_diff`, `server_time`, `client_time`, `country` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                        obj7.prepare();
                                        obj7.execute((sError, sData) => {
                                            if (sError === 1) {
                                                let emails = emailE[0]?.email || '';
                                                let data1 = { ...sData[0], email: emails, country };
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    message: "Your address is updated from admin side, refresh your page.",
                                                    status: 505,
                                                    session: data1
                                                });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    message: "Session data retrieval failed!",
                                                    status: 505
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "Email retrieval error!",
                                            status: 505
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let obj = new RawQuery_1.ModelRawQuery(req, res);
                                obj.qrysql = "SELECT `otp` FROM `two_factor_auth` WHERE `iduser` = " + sessdata.iduser + " AND UNIX_TIMESTAMP()-UNIX_TIMESTAMP(created)<300 ORDER BY id DESC LIMIT 1";
                                obj.prepare();
                                obj.execute((error, getEmail) => {
                                    if (error === 1 && getEmail.length > 0 && getEmail[0].otp == sdata.otp) {
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `user` SET `isEmailVerify`='true', `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                        obj1.prepare();
                                        obj1.execute((_error, success) => {
                                            if (_error === 1) {
                                                let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj5.nonqrysql = "UPDATE `session` SET `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                                obj5.prepare();
                                                obj5.execute((_sessErr, sessRes) => {
                                                    if (_sessErr === 1) {
                                                        let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj6.nonqrysql = "UPDATE `user_profile` SET `phone`='" + sdata.TO + "' WHERE `iduser`='" + sessdata.iduser + "'";
                                                        obj6.prepare();
                                                        obj6.execute((_sessError, sessData) => {
                                                            if (_sessError === 1) {
                                                                let objup = new RawQuery_1.ModelRawQuery(req, res);
                                                                objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                                                objup.prepare();
                                                                objup.execute((__errorE, emailE) => {
                                                                    if (__errorE === 1) {
                                                                        let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                                                                        obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`, `newUser_status`, `tz_diff`, `server_time`, `client_time`, `country` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                                                        obj7.prepare();
                                                                        obj7.execute((sError, sData) => {
                                                                            if (sError === 1) {
                                                                                let emType = { email: emailE[0].email };
                                                                                let sData1 = Object.assign(sData[0], emType);
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({
                                                                                    message: "OTP Verified Successfully!",
                                                                                    status: 200,
                                                                                    session: sData1
                                                                                });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({
                                                                                    message: "OTP verified error with connection!",
                                                                                    status: 502
                                                                                });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({
                                                                            message: "Failed to retrieve email!",
                                                                            status: 502
                                                                        });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    message: "Mobile number update failed!",
                                                                    status: 502
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            message: "Mobile number not verified!",
                                                            status: 502
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    message: "Failed to update user verification status!",
                                                    status: 502
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "Invalid or expired OTP!",
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Failed to fetch country!",
                                status: 502
                            });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    resendEmail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let secret = Str.random(15);
                let validationKey = jwt.sign({
                    exp: Math.floor(Date.now() / 1000) + (60 * 60),
                    data: sessdata.email + sessdata.password
                }, secret);
                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "', `secret`='" + secret + "', `email_verification_date`=NOW() WHERE `iduser`='" + sessdata.iduser + "' AND  `is_deleted`=0";
                obj3.prepare();
                obj3.execute((_err, __result) => {
                    if (_err == 1) {
                        if (__result.affectedRows > 0) {
                            let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                            obj4.qrysql = "SELECT `firstname`,`lastname`,`email` FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                            obj4.prepare();
                            obj4.execute((_error, user) => {
                                let getUser = user[0];
                                if (_err == 1) {
                                    let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE type='email_verification'";
                                    obj5.prepare();
                                    obj5.execute((emlErr, emlRes) => {
                                        if (emlErr == 1) {
                                            if (emlRes.length > 0) {
                                                let tmpData = emlRes[0].template;
                                                tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                                tmpData = tmpData.replace(/{VALIDATION_KEY}/g, validationKey);
                                                // var smtpTransport = nodemailer.createTransport({
                                                //     service: "gmail",
                                                //     host: "smtp.gmail.com",
                                                //     port: 587,
                                                //     secure: true,
                                                //     auth: {
                                                //         user: "donotreply@nglcommunications.com",
                                                //         pass: "yr%5V9GB"
                                                //     }
                                                // });
                                                // var mailOptions = {
                                                //     from: 'Signalmash <donotreply@signalmash.com>',
                                                //     to: getUser.email,
                                                //     usernmae: getUser.email,
                                                //     email: getUser.email,
                                                //     subject: `${emlRes[0].subject}`,
                                                //     text: "Thank You For Registration",
                                                //     html: `${tmpData}`
                                                // }
                                                // smtpTransport.sendMail(mailOptions, (_emailError: any, emailRes: any) => {
                                                //     if (_emailError) {
                                                //         let objv = new RawView(res);
                                                //         objv.prepare({ status: 401, errMessage: "Opps Email Not Sent!", error: _emailError });
                                                //         objv.execute();
                                                //     } else {
                                                //         let objv = new RawView(res);
                                                //         objv.prepare({ iduser: sessdata.iduser, status: 201, data: emailRes, message: "Email Send Succesfully!" });
                                                //         objv.execute();
                                                //     }
                                                // });
                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + (0, markError_1.parseBody)(getUser.email) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','Resend Mail Send for Not Getting Mail Previously', '" + (0, markError_1.parseBody)(tmpData) + "','Resend Mail Send successfully','6','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                obj1.prepare();
                                                obj1.execute((_err, __result) => {
                                                    console.log("Email Send Succesfully!");
                                                    if (_err == 1) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ iduser: sessdata.iduser, status: 201, message: "Email Send Succesfully!" });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        console.log("Error In Updating Password!");
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 401, errMessage: "Opps Email Not Sent!" });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 401, errMessage: "Templating Data Not Found!" });
                                                objv.execute();
                                            }
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ errMessage: "Invalid Key/Invalid Account!", status: 401 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ errMessage: "Something Went Wrong with DB!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    updateTariff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let sdata = req.body.data;
                let message = '';
                switch (true) {
                    case (isEmpty(sdata)):
                        message = "Missing request body data!";
                        break;
                    case (isEmpty(sdata.tariff1)):
                        message = "tariff1 is required!";
                        break;
                    case !isValidtarif(sdata.tariff1):
                        message = "tariff1 is invalid!";
                        break;
                    default:
                        message = "";
                }
                if (message) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: message });
                    objv.execute();
                }
                else {
                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    //obj4.nonqrysql = "UPDATE `user` LEFT JOIN `account` ON `user`.`idaccount`=`account`.`idaccount` SET `idtariff`='" + sdata.tariff1 + "', `idtariff1`='" + sdata.tariff1 + "', `isPlan`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                    obj4.nonqrysql = "UPDATE `user` LEFT JOIN `account` ON `user`.`idaccount`=`account`.`idaccount` SET `idtariff`=" + (0, markError_1.setToZero)(sdata.tariff1) + ", `idtariff1`=" + (0, markError_1.setToZero)(sdata.tariff1) + ", `isPlan`='true' WHERE `user`.`idaccount`=" + sessdata.idaccount + "";
                    obj4.prepare();
                    obj4.execute((error, user) => {
                        if (error == 1) {
                            let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            //obj5.nonqrysql = "UPDATE `session` SET `isPlan`='true', `idtariff`='" + sdata.tariff1 + "' WHERE `iduser`='" + sessdata.iduser + "'";
                            obj5.nonqrysql = "UPDATE `session` SET `isPlan`='true', `idtariff`=" + (0, markError_1.setToZero)(sdata.tariff1) + " WHERE `idaccount`=" + sessdata.idaccount + "";
                            obj5.prepare();
                            obj5.execute((_err, user) => {
                                if (_err == 1) {
                                    /* if (subscriptiondata !== null && subscriptiondata !== undefined) {
                                        let subscriptionmap = new SubscriptionManagement();
                                        subscriptionmap.Savesuscriptioncontrolmapping(req, res, subscriptiondata, sessdata.idaccount, (err: any) => {
                                            if (err == 0) {
                                                console.log("Something went Wrong");
                                            } else {
                                                console.log("Subscription Data Saved");
                                            }
                                        });
                                    } */
                                    let objup = new RawQuery_1.ModelRawQuery(req, res);
                                    objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                    objup.prepare();
                                    objup.execute((errorE, emailE) => {
                                        let currSess = server_1.sessiondata.get(req.headers.authorization);
                                        currSess.idtariff = sdata.tariff1;
                                        currSess.isPlan = "true";
                                        server_1.sessiondata.set(req.headers.authorization, currSess);
                                        let obj6 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj6.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                        obj6.prepare();
                                        obj6.execute((seserr, sessionData) => {
                                            if (seserr == 1) {
                                                let tmp = "{\"email\": \"" + emailE[0].email + "\"}";
                                                let emType = JSON.parse(tmp);
                                                let sessionData1 = Object.assign(sessionData, emType);
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Tariff Updated Successfully!", status: 201, session: sessionData1 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Tariff Updated Error With Connection!", status: 502, error: sessionData });
                                                objv.execute();
                                            }
                                        });
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Tariff Updated Error With Connection! ", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    currentSession(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let msg = '';
                switch (true) {
                    case !req.query:
                        msg = 'Request query not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`,`isCard`,`newUser_status`, `tz_diff`, `server_time`, `client_time` FROM `session` WHERE `authkey`='" + req.query.authkey + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Session Fetched Successfully!", status: 200, session: result });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Session Not Fetched DB Error!", status: 502, error: sessdata });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    /**
     * To get the list of TimeZones
     */
    GetTimeZones(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let objv = new RawView_1.RawView(res);
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT id, label utc FROM `tbl_timezones`;";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (error == 1) {
                        result = result || [];
                        objv.prepare({
                            error: 0,
                            message: "Records fetched successfully.",
                            data: result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "Something Went Wrong!"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**
     * To get the user's TimeZone
     */
    GetUserTimeZone(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let iduser = sessdata.iduser;
                let iQry = "SELECT a.id, a.id_timezone, b.label utc FROM `tbl_timezone_config` a\n";
                iQry += "INNER JOIN `tbl_timezones` b ON b.id=a.id_timezone\n";
                iQry += "WHERE a.id_user=" + iduser + ";";
                let objv = new RawView_1.RawView(res);
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = iQry;
                obj.prepare();
                obj.execute((_error, result) => {
                    if (error == 1) {
                        result = Array.isArray(result) && result.length > 0 ? result[0] : null;
                        objv.prepare({
                            error: 0,
                            message: "Record fetched successfully.",
                            data: result
                        });
                        objv.execute();
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "Something Went Wrong!"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**
     * To update the user's TimeZone
     */
    UpdateUserTimeZone(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = req.body.data;
                let msg = '';
                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    if (typeof rdata.timezone != 'undefined' && rdata.timezone) {
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "REPLACE INTO `tbl_timezone_config`(id_timezone, id_user) VALUES(" + rdata.timezone + ", " + sessdata.iduser + ");";
                        obj1.prepare();
                        obj1.execute((error, result) => {
                            if (error == 1) {
                                /**
                                 * Update the TimeZone in user's session data
                                 */
                                /* let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                obj2.qrysql = "SELECT `iduser`, `password`,ext_name FROM `user` WHERE iduser>0 AND iduser<=200";
                                obj2.prepare();
                                obj2.execute((error, result) => {
                                    if (error == 1 && Array.isArray(result) && result.length > 0) {
                                        result.forEach(ele => {
                                            let pwt12 = bcrypt.hashSync(ele.ext_name, 10);
                                            let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj3.nonqrysql = "UPDATE `user` SET `password`='" + pwt12 + "' WHERE `iduser`='" + ele.iduser + "';";
                                            obj3.prepare();
                                            obj3.execute((error, result2) => {console.log("Users:: "+pwt12+" :: ", ele)});
                                        });
                                    }
                                }); */
                                /* let obj2 = new ModelRawQuery(req, res);
                                obj2.qrysql = "SELECT a.utc client_time FROM tbl_timezones a WHERE a.id=" + rdata.timezone + ";"
                                obj2.prepare()
                                obj2.execute((error: any, result: any) => {
                                    if (error == 1 && Array.isArray(result) && result.length > 0) {
                                        let obj3 = new ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `session` SET `client_time`='" + result[0].client_time + "' WHERE `authkey`='" + sessdata.authkey + "';"
                                        obj3.prepare()
                                        obj3.execute((error: any, result2: any) => {
                                            sessdata.client_time = result[0].client_time
                                            sessiondata.set(sessdata.authkey, sessdata)
                                        })
                                    }
                                }) */
                                objv.prepare({
                                    error: 0,
                                    message: "Successfully saved."
                                });
                                objv.execute();
                            }
                            else {
                                objv.prepare({
                                    error: 1,
                                    message: "Something Went Wrong!"
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        objv.prepare({
                            error: 1,
                            message: "Invalid data!"
                        });
                        objv.execute();
                    }
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**************************
    *  Forgot Password start  *
    **************************/
    sendMailForForgetPass(req, res, next) {
        // let sdataa: any = req.query.type;
        let sdataa = req.body.data;
        let sdata;
        try {
            sdata = sdataa ? (sdataa.startsWith("{") ? JSON.parse(sdataa) : { sdataa: sdataa }) : null;
        }
        catch (err) {
            sdata = req.body.data;
        }
        let message = '';
        const emailPattern = /^(?!.*\.\.)(?!\.)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,10}(?<!\.)$/;
        switch (true) {
            case (!sdata):
                message = "Missing Parameter";
                break;
            case (typeof sdata.email !== 'string' || typeof sdata.username !== 'string'):
                message = "Email and Username must be valid strings";
                break;
            case (!sdata.email || !sdata.username):
                message = "Email & Username is required";
                break;
            case (!emailPattern.test(sdata.email)):
                message = "Email is invalid";
                break;
            case (!/^\s*\S.*$/.test(sdata.username)):
                message = "Please enter a valid username";
                break;
            case (sdata.username == '' || sdata.username == 'null' || sdata.username == 'undefined'):
                message = "Username is required";
                break;
            default:
                message = "";
        }
        if (message) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 501, message: message });
            objv.execute();
        }
        else {
            let obj = new RawQuery_1.ModelRawQuery(req, res);
            obj.qrysql = "SELECT u.iduser,u.idaccount,us.email, us.firstname, us.lastname, u.username FROM user_profile us JOIN `user` u ON us.iduser=u.iduser WHERE us.`email`='" + (0, markError_1.parseBody)(sdata.email) + "' AND u.username='" + (0, markError_1.parseBody)(sdata.username) + "' AND u.`is_deleted`=0";
            obj.prepare();
            obj.execute((_error, user) => {
                if (_error == 1) {
                    if (user.length > 0) {
                        if (sdata.email.toLowerCase() == user[0].email.toLowerCase() && sdata.username.toLowerCase() == user[0].username.toLowerCase()) {
                            let getUser = user[0];
                            let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                            obj4.qrysql = "SELECT template, subject,`cc`,`bcc` FROM `email_template` WHERE type='forgot_password'";
                            obj4.prepare();
                            obj4.execute((emlErr, emlRes) => {
                                if (emlErr == 1) {
                                    if (emlRes.length > 0) {
                                        let secret = Str.random(15);
                                        let validationKey = jwt.sign({
                                            exp: Math.floor(Date.now() / 1000) + (60 * 60),
                                            data: sdata.email
                                        }, secret);
                                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj3.nonqrysql = "UPDATE `user` SET `validationKey`='" + validationKey + "',`isResetPassword` = 'true'  WHERE `username`='" + (0, markError_1.parseBody)(getUser.username) + "' AND `is_deleted`=0";
                                        obj3.prepare();
                                        obj3.execute((_uperr, __result) => {
                                            if (_uperr == 1) {
                                                let tmpData = emlRes[0].template;
                                                tmpData = tmpData.replace(/{FIRST_NAME}/g, getUser.firstname);
                                                tmpData = tmpData.replace(/{LAST_NAME}/g, getUser.lastname);
                                                tmpData = tmpData.replace(/{TYPE}/g, 'Signalmash');
                                                tmpData = tmpData.replace(/{URL}/g, templateURL.URL + '/#/password/reset-password/' + validationKey);
                                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + getUser.iduser + "','" + getUser.idaccount + "','" + FromEmail + "','" + (0, markError_1.parseBody)(getUser.email) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','Mail Send for Forget Password  ', '" + (0, markError_1.parseBody)(tmpData) + "','Mail Send for Forget Password','7','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                obj1.prepare();
                                                obj1.execute((_err, __result) => {
                                                    console.log("Data Inserted In DB!");
                                                    if (_err == 1) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 201, message: "Password Reset Email Sent!", message1: "Please Check your email and follow the included link to finish resetting your password." });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        console.log("Error In Updating Password!");
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 401, message: "Opps Email Not Sent!" });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Something went Wrong!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Verification Email not Send!", status: 502 });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Error With Fetching Email Data!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: "Email and Username not matched!" });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 404, message: "Email Not Found/Invalid Account!" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Something Went Wrong to Fetch Email!" });
                    objv.execute();
                }
            });
        }
    }
    VerifyToken(req, res, next) {
        let key = req.query.type;
        let msg = '';
        switch (true) {
            case !req.query:
                msg = 'Request query not found!';
                break;
        }
        if (msg) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        }
        else {
            let obj = new RawQuery_1.ModelRawQuery(req, res);
            obj.qrysql = "SELECT `isResetPassword` FROM `user` WHERE validationKey='" + key + "' AND `is_deleted`=0";
            obj.prepare();
            obj.execute((error, result) => {
                if (result.length > 0) {
                    if (result[0].isResetPassword == 'true') {
                        if (error == 1 && result.length > 0) {
                            let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj4.nonqrysql = "UPDATE `user` SET `isResetPassword`='false' WHERE validationKey='" + key + "' AND `is_deleted`=0";
                            obj4.prepare();
                            obj4.execute((emlErr, emlRes) => {
                                if (emlErr == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ error: 0, status: 201, message: "Successfull Verified Please Enter Your New Password!", data: result });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ error: 0, status: 502, message: "Successfull Verified Status Not Changed!", data: result });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ error: 1, status: 502, message: "The Link You Followed Has Expired!" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ error: 1, status: 404, message: "Invalid Account!" });
                    objv.execute();
                }
            });
        }
    }
    updatePassword(req, res, next) {
        let alldata = req.body.data;
        let passwd = alldata.password.trim();
        if (passwd && (0, markError_1.checkPassword)(passwd) == '') {
            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
            obj0.qrysql = "SELECT up.firstname, up.lastname, up.email, u.username, u.iduser, u.idaccount FROM `user` u JOIN `user_profile` up ON u.iduser = up.iduser WHERE u.validationKey = '" + alldata.key + "';";
            obj0.prepare();
            obj0.execute((error, Res) => {
                if (error == 1) {
                    let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                    obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='reset_password'";
                    obj5.prepare();
                    obj5.execute((emlErr, emlRes) => {
                        if (emlErr == 1) {
                            console.log("payload", Res);
                            let payload = {
                                password: passwd,
                                type: Res[0]
                            };
                            if (emlRes.length > 0) {
                                keycloak.resetKeyCloakPass(req, res, payload, (errorR, resR) => {
                                    if (errorR == 1) {
                                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj1.nonqrysql = "UPDATE `user` SET `isResetPassword`='true' WHERE `validationKey`='" + alldata.key + "' AND `is_deleted`=0";
                                        obj1.prepare();
                                        obj1.execute((Err, Result) => {
                                            if (Result.affectedRows > 0) {
                                                let tmpData = emlRes[0].template;
                                                tmpData = tmpData.replace(/{FIRST_NAME}/g, Res[0].firstname);
                                                tmpData = tmpData.replace(/{LAST_NAME}/g, Res[0].lastname);
                                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj2.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`, `from`, `to`, `subject`, `text`, `html`, `type`, `status`, `cc`, `bcc`) VALUES ('" + Res[0].iduser + "', '" + Res[0].idaccount + "', '" + FromEmail + "', '" + (0, markError_1.parseBody)(Res[0].email) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "', 'Mail Send to Update Password.', '" + (0, markError_1.parseBody)(tmpData) + "', 'Thank You for Updating Your Password.', '8', '" + emlRes[0].cc + "', '" + emlRes[0].bcc + "')";
                                                obj2.prepare();
                                                obj2.execute((_err, __result) => {
                                                    if (_err == 1) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            status: 201,
                                                            message: "Password Updated Successfully!"
                                                        });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        console.log("Error In Updating Password!");
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            status: 401,
                                                            message: "Oops Email Not Sent!"
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv0 = new RawView_1.RawView(res);
                                                objv0.prepare({
                                                    error: 1,
                                                    status: 505,
                                                    message: "Something Went Wrong!"
                                                });
                                                objv0.execute();
                                            }
                                        });
                                    }
                                    else {
                                        console.log("resetKeyCloakPass updatePassword - callback:", errorR, resR);
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 503, message: "Password not updated successfully!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                console.log("Template Data Not Found!");
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    message: "Something went wrong with find template!",
                                    status: 503
                                });
                                objv.execute();
                            }
                        }
                        else {
                            console.log("Something Went Wrong with DB!");
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Something went wrong with find template.",
                                status: 504
                            });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({
                        message: "Password Verification Key has expired/Invalid Account!",
                        status: 401
                    });
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({
                message: (0, markError_1.checkPassword)(passwd),
                status: 501
            });
            objv.execute();
        }
    }
    /************************
    *  Forgot Password end  *
    ************************/
    /* added here query for usersCustomer list for dropdown */
    customerList(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let ext_field;
                if (sessdata.type == 1) {
                    ext_field = "a.san,u.iduser,";
                }
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT " + ext_field + " u.username, up.firstname, up.lastname FROM `user`u LEFT JOIN account a ON a.idaccount=u.idaccount RIGHT JOIN user_profile up ON u.iduser=up.iduser WHERE u.`is_deleted`= 0 AND a.`idaccount`= '" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Customer Fetched!", status: 201 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    billingEnableOrDisable(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body.data;
                        let message = "";
                        switch (true) {
                            case (!sdata || !('data' in req.body)):
                                message = "Missing Parameter";
                                break;
                            case (!sdata?.idaccount || ["", "null", "undefined"].includes(sdata.idaccount)):
                                message = "Idaccount is required";
                                break;
                            case (!Number.isInteger(Number(sdata.idaccount)) || Number(sdata.idaccount) <= 0):
                                message = "Idaccount must be integer";
                                break;
                            case (!["0", "1", 0, 1].includes(sdata.bVal)):
                                message = "Is billing must be 0 or 1";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                            return;
                        }
                        let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj0.nonqrysql = "UPDATE `account` SET `is_billing`='" + (0, markError_1.setToZero)(sdata.bVal) + "' WHERE `idaccount`=" + sdata.idaccount + "";
                        obj0.prepare();
                        obj0.execute((error, result) => {
                            if (error == 1) {
                                let objv0 = new RawView_1.RawView(res);
                                objv0.prepare({ error: 0, status: 201, message: "Successfully Updated." });
                                objv0.execute();
                            }
                            else {
                                let objv0 = new RawView_1.RawView(res);
                                objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                objv0.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    kycUpdateStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body.data;
                let msg = '';
                switch (true) {
                    case !sdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj0.nonqrysql = "UPDATE `user` SET `kyc_verify_status`='1' WHERE `idaccount`='" + sdata.idaccount + "'";
                    obj0.prepare();
                    obj0.execute((error, result) => {
                        if (error == 1) {
                            let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj1.nonqrysql = "UPDATE `know_your_customer` SET `approve_date`= NOW() WHERE `idaccount`='" + sdata.idaccount + "' AND `iduser`='" + sdata.iduser + "'";
                            obj1.prepare();
                            obj1.execute((errors, result) => {
                                if (errors == 1) {
                                    let objv0 = new RawView_1.RawView(res);
                                    objv0.prepare({ error: 0, status: 201, message: "KYC Successfully Verified." });
                                    objv0.execute();
                                }
                                else {
                                    let objv0 = new RawView_1.RawView(res);
                                    objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                                    objv0.execute();
                                }
                            });
                        }
                        else {
                            let objv0 = new RawView_1.RawView(res);
                            objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong!" });
                            objv0.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    /** start onBoardingVerification */
    onBoardingVerification(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = JSON.parse(req.body.data);
                let msg = '';
                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let arrData;
                    if (rdata.email) {
                        arrData = '`isEmailVerify`=' + rdata.email;
                    }
                    if (rdata.phone) {
                        arrData = '`isMobileVerify`=' + rdata.phone;
                    }
                    if (rdata.isAddress) {
                        arrData = '`isAddress`=' + rdata.isAddress;
                    }
                    let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj0.filter = null;
                    obj0.nonqrysql = "UPDATE `user` SET '" + arrData + "'  WHERE `idaccount`='" + sessdata.idaccount + "'";
                    obj0.prepare();
                    obj0.execute((_error, bvRes) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "onBoarding Verification Updated Successfully",
                                status: 200
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Brand Update!", status: 502 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**Inset query for Domain Block */
    domainBlock(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                var rdata = [];
                rdata = req.body.data;
                let msg = '';
                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj2.nonqrysql = "INSERT INTO `domain_block` (`ip_address`, `email`, `domain_name`, `first_name`, `last_name`, `contact`) VALUES('" + rdata.ip + "', '" + (0, markError_1.parseBody)(rdata.email) + "', '" + rdata.specific_domain + "', '" + (0, markError_1.parseBody)(rdata.first_name) + "', '" + (0, markError_1.parseBody)(rdata.last_name) + "', '" + rdata.contact + "')";
                    obj2.prepare();
                    obj2.execute((_error, allcamp) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 200, message: "Domain Block Saved Successfully!" });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Domain Blocke Not Created Successfully!" });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**GET query for Domain Block */
    getDomainBlk(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                var sdata = req.query;
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `domain_block_id`,`ip_address`,`email`,`domain_name`,`first_name`,`last_name`,`contact`, `created_at` FROM `domain_block` ORDER BY `domain_block_id` DESC";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Domain Block Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get Domain Block List!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**PUT query for Domain Block */
    updateDomainBlock(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                var sdata = req.body.data;
                let msg = '';
                switch (true) {
                    case !sdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `domain_block` SET `ip_address`='" + sdata.ip + "', `email`='" + (0, markError_1.parseBody)(sdata.email) + "', `domain_name`='" + (0, markError_1.parseBody)(sdata.specific_domain) + "', `first_name`='" + (0, markError_1.parseBody)(sdata.first_name) + "', `last_name`='" + (0, markError_1.parseBody)(sdata.last_name) + "', `contact`='" + sdata.contact + "'  WHERE `domain_block_id`='" + sdata.domen_id + "'";
                    obj.prepare();
                    obj.execute((_error, result) => {
                        if (_error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Domain Block Updated Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /*DELETE query for Domain block*/
    deleteDomainBlock(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let msg = '';
                switch (true) {
                    case !req.query:
                        msg = 'Request query not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE FROM `domain_block` WHERE `domain_block_id`='" + req.query.domain_block_id + "'";
                    obj.prepare();
                    obj.execute((_err, result) => {
                        if (_err == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Domain Block Deleted Successfully!", status: 201, data: result });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to Access!", status: 401 });
                objv.execute();
            }
        });
    }
    /* public compairePassword(req: Request, res: Response, next: NextFunction) {
        let session = new SessionManagment(req, res, next);
        session.GetSession((error: any, sessdata: any) => {
            if (error == 1) {
                let nullPassword: any = [];
                let matchedPassword: any = [];
                let notmatchedPassword: any = [];
                let obj = new ModelRawQuery(req, res);
                obj.qrysql = "SELECT `password`, `ext_name`, `username`,`idaccount`,`iduser` FROM `user`";
                obj.prepare();
                obj.execute((_error: any, result: any) => {
                    if (_error == 1) {
                        for (let i of result) {

                            if (i.ext_name && i.password) {
                                let ext = bcrypt.compareSync(i.ext_name, i.password);
                                if (ext) {
                                    matchedPassword.push({ status: ext, ext_name: i.ext_name, password: i.password, username: i.username, iduser: i.iduser, idaccount: i.idaccount });
                                }
                                else {
                                    notmatchedPassword.push({ status: ext, ext_name: i.ext_name, password: i.password, username: i.username, iduser: i.iduser, idaccount: i.idaccount });
                                }
                            }
                            else {
                                nullPassword.push({ status: null, ext_name: i.ext_name, password: i.password, username: i.username, iduser: i.iduser, idaccount: i.idaccount });
                            }
                        }
                        if (matchedPassword.length > 0 || notmatchedPassword.length > 0) {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Data Fetched Successfully!", status: 200, data: { matchedPassword: matchedPassword, notmatchedPassword: notmatchedPassword, nullPassword: nullPassword } });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView(res);
                            objv.prepare({ message: "Data Not Fetched!", status: 502, data: { matchedPassword: [], notmatchedPassword: [], nullExtPassword: [] } });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    } */
    getResellerUsers(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `reseller_iduser`,`signup_link_id`,`validationKey` from `user` where `iduser`= '" + sessdata.iduser + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Reseller Users Fetched Successfully!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Get Reseller Users List!", status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getResellerTariff(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query;
                if (!sdata?.type) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Missing 'type' parameter!", status: 400 });
                    return objv.execute();
                }
                let data;
                try {
                    data = JSON.parse(sdata.type);
                }
                catch (e) {
                    console.log("Error in getResellerTariff :: ", e);
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Invalid JSON in 'type' parameter!", status: 400 });
                    return objv.execute();
                }
                /* if (!/^\d+$/.test(data.iduser)) {
                     let objvo = new RawView(res);
                    objvo.prepare({ status: 400, message: "Invalid iduser." });
                    return objvo.execute();
                } */
                if ((typeof data.key !== "string" || data.key.trim() === "")) {
                    let objh = new RawView_1.RawView(res);
                    objh.prepare({ message: "Invalid Request!", status: 400 });
                    return objh.execute();
                }
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `url`,`key`,`link_id`,`name` as iname FROM `signup_referral_link` WHERE `key`='" + data.key + "'";
                obj.prepare();
                obj.execute((_error, result1) => {
                    if (_error == 1) {
                        if (result1.length > 0) {
                            let url = result1[0].url;
                            let url1 = url.split('/#/signup?url=')[1];
                            let decodeUrl = Buffer.from(url1, "base64").toString("utf8");
                            let idtariff = decodeUrl.split('idtariff=')[1];
                            let idtarifff = idtariff.split('&ukey=')[0];
                            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                            obj1.qrysql = "SELECT t.idtariff, t.idaccount, t.name, t.description, t.type,t.tariff_link, t.day_num,s.order_by, t.proration FROM tariff t JOIN signup_referral_link_tariff s ON t.idtariff = s.idtariff WHERE t.idtariff IN (" + idtarifff + ") AND s.link_id = " + result1[0].link_id + "";
                            obj1.prepare();
                            obj1.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, data1: result1, message: "Tariff Fetched Successfully!", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "No Url Found!", status: 503 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    resellerData(req, res, tariff, result, next) {
        let obj3 = new RawQuery_1.ModelRawQuery(req, res);
        obj3.qrysql = "SELECT `idtariff`,`idaccount`,`name`,`description`,`type`,`day_num`,`proration` FROM `tariff` WHERE idtariff IN (" + tariff + ")";
        obj3.prepare();
        obj3.execute((error, result3) => {
            if (error == 1) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ data: result3, data1: result, message: "Tariff Fetched Successfully!", status: 200 });
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                objv.execute();
            }
        });
    }
    getUserStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.query.type;
                let msg = '';
                switch (true) {
                    case !req.query:
                        msg = 'Request query not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `newUser_status` FROM `user` WHERE `iduser` ='" + sdata + "'";
                    obj.prepare();
                    obj.execute((__error, result) => {
                        if (__error == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Fetch User Status Successfully!", data: result, status: 200 });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Something went wrong!", status: 501 });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**GET data by id */
    kycVerifyHeader(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let ext_field;
                if (sessdata.type == 1) {
                    ext_field = "`iduser`,`idaccount`,";
                }
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT " + ext_field + " `kyc_verify_status` FROM `user` WHERE `iduser`='" + sessdata.iduser + "' AND `idaccount`='" + sessdata.idaccount + "'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1 && result.length > 0) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Kyc Details Fatched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong With KYC Verification!", data: result, status: 502, error: result });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    resetPassword(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let sdata = req.body;
                if (sdata.old_password == 'undefined' || sdata.old_password == null) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Password Not Found.", error: 0 });
                    objv.execute();
                }
                else {
                    let passwd = (typeof sdata.confirm_password === 'string') ? sdata.confirm_password.trim() : (sdata.confirm_password ?? '');
                    if (passwd && (0, markError_1.checkPassword)(passwd) == '') {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT up.firstname, up.lastname, up.email,u.username FROM `user` u JOIN user_profile up ON u.iduser = up.iduser WHERE u.iduser = '" + sessdata.iduser + "'";
                        obj1.prepare();
                        obj1.execute((Err, Res) => {
                            if (Err == 1) {
                                console.log("payload", Res);
                                let payload = {
                                    password: passwd,
                                    type: Res[0]
                                };
                                keycloak.loginKeyClock(req, res, Res[0].username, sdata.old_password, (errorRR, resRR) => {
                                    if (errorRR == 1) {
                                        keycloak.resetKeyCloakPass(req, res, payload, (errorR, resR) => {
                                            if (errorR == 1) {
                                                let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj4.nonqrysql = "UPDATE `user` SET `resetPassword`='1' WHERE `iduser`='" + sessdata.iduser + "'";
                                                obj4.prepare();
                                                obj4.execute((error1, user) => {
                                                    if (error1 == 1) {
                                                        let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                                                        obj5.qrysql = "SELECT `template`,`subject`,`cc`,`bcc` FROM `email_template` WHERE `type`='reset_password'";
                                                        obj5.prepare();
                                                        obj5.execute((emlErr, emlRes) => {
                                                            if (emlErr == 1) {
                                                                if (emlRes.length > 0) {
                                                                    let tmpData = emlRes[0].template;
                                                                    tmpData = tmpData.replace(/{FIRST_NAME}/g, Res[0].firstname);
                                                                    tmpData = tmpData.replace(/{LAST_NAME}/g, Res[0].lastname);
                                                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                    obj1.nonqrysql = "INSERT INTO `email_send`(`iduser`, `idaccount`,`from`,`to`, `subject`,`text`,`html`,`type`,`status`,`cc`,`bcc`) VALUES ('" + sessdata.iduser + "','" + sessdata.idaccount + "','" + FromEmail + "','" + (0, markError_1.parseBody)(Res[0].email) + "', '" + (0, markError_1.parseBody)(emlRes[0].subject) + "','Mail Send for Reset Password', '" + (0, markError_1.parseBody)(tmpData) + "','Mail Send for Reset Password','9','" + emlRes[0].cc + "','" + emlRes[0].bcc + "')";
                                                                    obj1.prepare();
                                                                    obj1.execute((_err, __result) => {
                                                                        console.log("Email Send  Successfully!");
                                                                        if (_err == 1) {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Password Changed Successfully!", status: 201 });
                                                                            objv.execute();
                                                                        }
                                                                        else {
                                                                            console.log("Error In Updating Password!");
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ status: 201, message: "Password reset successfully but mail not sent!" });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    console.log("Template Data Not Found!");
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ status: 201, message: "Password reset successfully but mail not sent!" });
                                                                    objv.execute();
                                                                }
                                                            }
                                                            else {
                                                                console.log("Something Went Wrong with DB!");
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 201, message: "Password reset successfully but mail not sent!" });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv0 = new RawView_1.RawView(res);
                                                        objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong update user!" });
                                                        objv0.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                console.log("resetKeyCloakPass ChangePassword - callback:", errorR, resR);
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 503, message: "Password not reset successfully!" });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 401, message: "You have enter wrong old password!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv0 = new RawView_1.RawView(res);
                                objv0.prepare({ error: 1, status: 502, message: "Something Went Wrong with user detail!" });
                                objv0.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            message: (0, markError_1.checkPassword)(passwd),
                            status: 501
                        });
                        objv.execute();
                    }
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    getfeatureService(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT fs_id, fs_name_code, fs_name FROM feature_service";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1 && result.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Feature Details Fatched!", data: result, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Data not Available!", data: result, status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    getSuspendedService(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `idaccount` FROM `account_service` WHERE `as_status`='0' GROUP BY idaccount";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1 && result.length > 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Details Fatched!", data: result, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    getfeatureServiceById(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let idaccount = req.query.type;
                        let msg = '';
                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            /* if (setservicedata.has(idaccount.toString())) {
                                console.log("comming form hashMap")
                                let objv = new RawView(res);
                                objv.prepare({ message: "Feature Details Fatched!", data: setservicedata.get(idaccount.toString()), status: 200 });
                                objv.execute();
                            } else { */
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT fs_id, idaccount, as_status From account_service where idaccount ='" + idaccount + "'";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1 && result.length > 0) {
                                    console.log("comming from database");
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Feature Details Fatched!", data: result, status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong!", data: result, status: 500, error: result });
                                    objv.execute();
                                }
                            });
                            /* } */
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    getfeatureServiceStatus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT `fs_id`,`as_status` FROM `account_service` WHERE `idaccount`='" + sessdata.idaccount + "' AND `as_status` = '1'";
                obj.prepare();
                obj.execute((_error, result) => {
                    if (_error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Details Fatched!", data: result, status: 200 });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    updateSuspendedService(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let rdata = [];
                        rdata = req.body.data;
                        let msg = '';
                        switch (true) {
                            case !rdata:
                                msg = 'Request body not found!';
                                break;
                            case !Array.isArray(rdata):
                                msg = 'Invalid request format! Expected an array.';
                                break;
                            case rdata.length === 0:
                                msg = 'Request array is empty!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            rdata.forEach((element, index) => {
                                /* let idaccount = String(element.idaccount)
                                if (setservicedata.has(idaccount.toString())) {
                                    let hashMapData: any;
                                    hashMapData = setservicedata.get(idaccount.toString())
                                    let index = hashMapData.findIndex((obj: any) => obj.fs_id === element.fs_id);
                                    if (index !== -1) {
                                        hashMapData[index].as_status = element.as_status;
                                        setservicedata.set(idaccount.toString(), hashMapData);
                                    }
                                } */
                                let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj2.nonqrysql = "UPDATE `account_service` SET `as_status`='" + element.as_status + "' WHERE `idaccount`='" + element.idaccount + "' AND `fs_id`='" + element.fs_id + "'";
                                obj2.prepare();
                                obj2.execute((error, result) => {
                                    if (error == 1) {
                                        if (result.affectedRows > 0) {
                                            console.log("data updated Successfully for ", element.fs_id);
                                        }
                                        else {
                                            console.log("data Not updated Successfully", element.fs_id);
                                        }
                                    }
                                    else {
                                        console.log("Something went wrong with update");
                                    }
                                });
                            });
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "Service updated Successfully!", status: 200 });
                            objv.execute();
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    suspendAllServices(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let rdata = req.body;
                let msg = '';
                switch (true) {
                    case !rdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    validuser.checksessionvalid_1_2(req, res, sessdata, (err, dt) => {
                        if (err == 1) {
                            // if (sessdata.type == 1 || sessdata.type == 2) {
                            let ida = '';
                            if (sessdata.type == 1)
                                ida = rdata.idaccount;
                            else
                                ida = sessdata.idaccount;
                            let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj2.nonqrysql = "UPDATE `account_service` SET `as_status`='0' WHERE `idaccount`=" + ida + "";
                            obj2.prepare();
                            obj2.execute((error, result) => {
                                if (error == 1) {
                                    if (result.affectedRows > 0) {
                                        console.log("Service Suspended Successfully!");
                                    }
                                    else {
                                        console.log("Service Not Suspended Successfully");
                                    }
                                }
                                else {
                                    console.log("Something went wrong with update");
                                }
                            });
                        }
                        else {
                            console.log("You are not accessible.");
                        }
                    });
                }
            }
            else {
                console.log("Invalid Session!");
            }
        });
    }
    Payment_status(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                validuser.checksessionvalid_1(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        // if (sessData.type == 1) {
                        let sdata = JSON.parse(req.body.data);
                        let msg = '';
                        switch (true) {
                            case !sdata:
                                msg = 'Request body not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let objj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            objj1.nonqrysql = "UPDATE `user` set `trust_score`='" + sdata.trustscore + "' WHERE `idaccount`='" + sdata.idaccount + "'";
                            objj1.prepare();
                            objj1.execute((error, result) => {
                                if (error == 1) {
                                    let objv2 = new RawView_1.RawView(res);
                                    objv2.prepare({ message: 'Payment Status Update Successfully!', data: result, status: 200 });
                                    objv2.execute();
                                }
                                else {
                                    let objv2 = new RawView_1.RawView(res);
                                    objv2.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                    objv2.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objvv = new RawView_1.RawView(res);
                        objvv.prepare(dt);
                        objvv.execute();
                    }
                });
            }
            else {
                let objv2 = new _406_1.Res406(res);
                objv2.prepare({ status: 401, message: "Unauthorized User!" });
                objv2.execute();
            }
        });
    }
    trust_score(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                validuser.checksessionvalid_1(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        // if (sessData.type == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT score , description FROM `stripe_trust_score`";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: 'Trust Score Fetch Successfully!', data: result, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    /**CSP Configuration OBNSystme **/
    getcpsdata(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT (100000000 + a.idaccount) AS san, a.idaccount, a.cps, u.username, up.firstname, up.lastname FROM account a JOIN user u ON u.idaccount = a.idaccount LEFT JOIN user_profile up ON up.iduser = u.iduser WHERE a.account_type = '2' AND u.type = '2' AND u.is_deleted = '0' ORDER BY a.idaccount DESC";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "CPS List Fetched Successfully!", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    updatecpsdata(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let sdata = req.body.data;
                        let msg = '';
                        switch (true) {
                            case !sdata:
                                msg = 'Request body not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `account` SET cps = '" + (0, markError_1.setToZero)(sdata.cps) + "' WHERE idaccount = '" + sdata.san + "'";
                            obj.prepare();
                            obj.execute((error, result) => {
                                if (error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, message: "CPS Data Updated Successfully!", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getsiptrunking(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `idsipts`,`sip_ip`,`sip_prefix`,`sip_name`,`created_at`,`type` FROM `sip_trunking_setting` ORDER BY idsipts DESC";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ data: result, message: "SIP Trunking Setting Fetched Successfully!", status: 201 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    addsiptrunking(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body.data;
                        let msg = '';
                        const sipname = (typeof sdata.sipname == 'string')
                            ? (0, markError_1.parseBody)(sdata.sipname.trim())
                            : (0, markError_1.parseBody)(sdata.sipname);
                        const sipprefix = (typeof sdata.sipprefix == 'string')
                            ? (0, markError_1.parseBody)(sdata.sipprefix.trim())
                            : (0, markError_1.parseBody)(sdata.sipprefix);
                        switch (true) {
                            case !sdata:
                                msg = 'Request body not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "INSERT INTO `sip_trunking_setting` (`sip_ip`, `sip_name`, `sip_prefix`,`type`) VALUES('" + (0, markError_1.parseBody)(sdata.sipip) + "', '" + sipname + "', '" + sipprefix + "','" + sdata.sip_type + "')";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (result) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, message: "SIP Trunking Setting Saved Successfully!", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        // }
                        // })
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    editsiptrunk(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let sdata = req.body.data;
                        // let objj = new ModelRawQuery(req, res);
                        // objj.qrysql = "SELECT `sip_ip`,`sip_prefix`,`sip_name` FROM `sip_trunking_setting` where (`sip_ip` = '" + sdata.data.sipip + "' OR `sip_prefix`='" + parseBody(sdata.data.sipprefix.trim()) + "' OR `sip_name`='" + parseBody(sdata.data.sipname.trim()) + "') AND `idsipts` != '" + sdata.id + "'";
                        // objj.prepare();
                        // objj.execute((_error: any, getres: any) => {
                        //     if (getres.length > 0) {
                        //         let message = "";
                        //         let sipIpExists = getres.some((item: any) => item.sip_ip === parseBody(sdata.data.sipip));
                        //         let sipPrefixExists = getres.some((item: any) => item.sip_prefix === parseBody(sdata.data.sipprefix.trim()));
                        //         let sipNameExists = getres.some((item: any) => item.sip_name === parseBody(sdata.data.sipname.trim()));
                        //         if (sipIpExists && sipPrefixExists && sipNameExists) {
                        //             message = "All Data SIP Trunking Setting Already Exists";
                        //         } else if (sipIpExists) {
                        //             message = "SIP IP Already Exists";
                        //         } else if (sipPrefixExists) {
                        //             message = "SIP Prefix Already Exists";
                        //         } else if (sipNameExists) {
                        //             message = "SIP Name Already Exists";
                        //         }
                        //         let objv = new RawView(res);
                        //         objv.prepare({ message: message, status: 404 });
                        //         objv.execute();
                        // } else {
                        let msg = '';
                        switch (true) {
                            case !sdata:
                                msg = 'Request body not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            const sipname = (typeof sdata.data.sipname == 'string')
                                ? (0, markError_1.parseBody)(sdata.data.sipname.trim())
                                : (0, markError_1.parseBody)(sdata.data.sipname);
                            const sipprefix = (typeof sdata.data.sipprefix == 'string')
                                ? (0, markError_1.parseBody)(sdata.data.sipprefix.trim())
                                : (0, markError_1.parseBody)(sdata.data.sipprefix);
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "UPDATE `sip_trunking_setting` SET sip_ip = '" + sdata.data.sipip + "',sip_prefix = '" + sipprefix + "',sip_name = '" + sipname + "',type = '" + sdata.data.sip_type + "' WHERE idsipts = '" + sdata.id + "'";
                            obj.prepare();
                            obj.execute((error, result) => {
                                if (error == 1) {
                                    // To update sip trunking profile
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj1.nonqrysql = "UPDATE `sip_override` SET `sip_override_ip`='" + sdata.data.sipip + "',`sip_override_prefix`='" + sipprefix + "' WHERE `idsipts`='" + sdata.id + "'";
                                    obj1.prepare();
                                    obj1.execute((_error, result) => {
                                        console.log("Data Updated Successfully!");
                                    });
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, message: "SIP Trunking Data Updated Successfully!", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                        // }
                        // })
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    deletesiptrunk(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let msg = '';
                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "DELETE FROM `sip_trunking_setting` WHERE `idsipts` = '" + req.query.ID + "'";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 201, message: "SIP Trunking Setting Deleted Successfully!" });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 503, message: "Something Went Wrong!" });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    Getsiptrunkdetail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "Select so.`idsipts`,so.`idaccount`,so.`idoverride`,so.`sip_override_ip`,so.`sip_override_prefix`,sts.`sip_name`,so.`created_at` From `sip_override` so JOIN `sip_trunking_setting` sts ON so.`idsipts` = sts.`idsipts`";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1) {
                                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                obj1.qrysql = "SELECT `type`,`idsipts`,`sip_name` FROM `sip_trunking_setting` WHERE `type` = '1'";
                                obj1.prepare();
                                obj1.execute((error1, result1) => {
                                    if (error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ data: result, data1: result1, message: "SIP Trunking Profile List Fetched Successfully!", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    saveSIPtrunking(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let sdata = [];
                        sdata = req.body.data;
                        let msg = '';
                        switch (true) {
                            case !sdata:
                                msg = 'Request body not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let sipIP = sdata.sip_name[0].sipIP;
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `idaccount` FROM `sip_override` where `idaccount` = '" + sdata.selectuser[0].userdata + "'";
                            obj.prepare();
                            obj.execute((_error, getSip) => {
                                if (getSip[0]) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        message: "SIP Trunking Profile Already Exists",
                                        status: 404
                                    });
                                    objv.execute();
                                }
                                else {
                                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj1.qrysql = "Select `sip_ip`,`sip_prefix` From `sip_trunking_setting` WHERE `idsipts` = '" + sipIP + "'";
                                    obj1.prepare();
                                    obj1.execute((error, result) => {
                                        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj2.nonqrysql = "INSERT into `sip_override` (`idsipts`,`idaccount`,`sip_override_ip`,`sip_override_prefix`) VALUES('" + sipIP + "','" + sdata.selectuser[0].userdata + "','" + (0, markError_1.parseBody)(result[0].sip_ip) + "','" + (0, markError_1.parseBody)(result[0].sip_prefix) + "')";
                                        obj2.prepare();
                                        obj2.execute((_error, result) => {
                                            if (result) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ data: result, message: "SIP Trunking Profile Created Successfully!", status: 201 });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: 502, message: "Something Went Wrong With Data!" });
                                                objv.execute();
                                            }
                                        });
                                    });
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    updateSIPtrunking(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let sdata = JSON.parse(req.body.data);
                        let msg = '';
                        switch (true) {
                            case !sdata:
                                msg = 'Request body not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                            obj1.qrysql = "Select `sip_ip`,`sip_prefix` From `sip_trunking_setting` WHERE `idsipts` = '" + sdata.idsipIP + "'";
                            obj1.prepare();
                            obj1.execute((error, result) => {
                                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj.nonqrysql = "UPDATE `sip_override` SET `idsipts`='" + sdata.idsipIP + "',`sip_override_ip`='" + (0, markError_1.parseBody)(result[0].sip_ip) + "',`sip_override_prefix`='" + (0, markError_1.parseBody)(result[0].sip_prefix) + "' WHERE `idoverride` = '" + sdata.IDsip + "'";
                                obj.prepare();
                                obj.execute((_error, result) => {
                                    if (_error == 1) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ data: result, message: "SIP Trunking Profile Updated Successfully", status: 201 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: "Something Went Wrong With Data!", status: 502 });
                                        objv.execute();
                                    }
                                });
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    deleteSIPtrunking(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let msg = '';
                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "DELETE From `sip_override` WHERE `idoverride` = '" + req.query.ID + "'";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "SIP Trunking Profile Deleted Successfully!", data: result, status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Data!", status: 502, error: result });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getfilterdetails(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let data = req.body.data;
                        let msg = '';
                        switch (true) {
                            case !data:
                                msg = 'Request body not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let conditions = [];
                            const sipprefix = (typeof data.sipoverrideprefix == 'string')
                                ? (0, markError_1.parseBody)(data.sipoverrideprefix.trim())
                                : (0, markError_1.parseBody)(data.sipoverrideprefix);
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            if (data.sipname) {
                                // conditions.push('sts.`sip_name` LIKE "%' + parseBody(data.sipname.trim()) + '%"');
                                conditions.push('sts.`sip_name` = "' + (0, markError_1.parseBody)(data.sipname[0].sipName) + '"');
                            }
                            if (data.sipoverrideprefix) {
                                conditions.push('so.`sip_override_prefix` LIKE "%' + (0, markError_1.parseBody)(data.sipoverrideprefix.trim()) + '%"');
                            }
                            if (data.sipip) {
                                conditions.push('so.`sip_override_ip` = "' + (0, markError_1.parseBody)(data.sipip) + '"');
                            }
                            if (Array.isArray(data.san) && data.san.length > 0) {
                                conditions.push('so.`idaccount` = "' + data.san[0].userdata + '"');
                            }
                            if (data.from_date && data.to_date) {
                                conditions.push('so.`created_at` BETWEEN "' + data.from_date + ' 00:00:00" AND "' + data.to_date + ' 23:59:59"');
                            }
                            let condition = conditions.length > 0 ? ' WHERE ' + conditions.join(' AND ') : '';
                            obj.qrysql = "Select so.`idsipts`,so.`idaccount`,so.`idoverride`,so.`sip_override_ip`,so.`sip_override_prefix`,sts.`sip_name`,so.`created_at` From `sip_override` so JOIN `sip_trunking_setting` sts ON so.`idsipts` = sts.`idsipts`" + condition;
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        data: result, message: "SIP Trunking Profile List Fetched Successfully!", status: 201
                                    });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With List!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getcount(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let msg = '';
                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let data = req.query.type;
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT COUNT(*) AS total_count FROM `sip_override` WHERE `idsipts` = '" + data + "'";
                            obj.prepare();
                            obj.execute((error, result) => {
                                if (error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, message: "Total Count Sip Trunking Profile Fetched Successfully!", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    // new module api for obsip
    Getbrandcallerdid(req, res, userPayLoad, otherPayLoad, next) {
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT db.did FROM did_buy db WHERE db.account_id = '" + userPayLoad.idaccount + "' AND db.type = '" + otherPayLoad.type + "' AND db.disconnect_did_status = '1' AND NOT EXISTS (SELECT 1 FROM sip_bcid_override sbo WHERE sbo.did = db.did AND sbo.idaccount = db.account_id) GROUP BY db.did";
        obj.prepare();
        obj.execute((error, result) => {
            if (error == 1) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ data: result, message: "Branded Caller DID Fetched Successfully!", status: 201 });
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                objv.execute();
            }
        });
    }
    addBcidEid(req, res, otherPayLoad, next) {
        let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj2.nonqrysql = "INSERT into `sip_bcid_eid` (`eid`,`eid_name`) VALUES('" + (0, markError_1.parseBody)(otherPayLoad.eid.trim()) + "','" + (0, markError_1.parseBody)(otherPayLoad.eidName.trim()) + "')";
        obj2.prepare();
        obj2.execute((error1, result) => {
            if (error1 == 1) {
                if (result.affectedRows > 0) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: result, message: "BCID EID Setting Created Successfully!", status: 201 });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Something Went Wrong With Data!" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "Something Went Wrong With Data!" });
                objv.execute();
            }
        });
    }
    editBcidEid(req, res, otherPayLoad, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj.nonqrysql = "UPDATE `sip_bcid_eid` SET eid = '" + (0, markError_1.parseBody)(otherPayLoad.eid.trim()) + "',eid_name = '" + (0, markError_1.parseBody)(otherPayLoad.eidName.trim()) + "' WHERE idbcideid = '" + otherPayLoad.idbcideid + "'";
        obj.prepare();
        obj.execute((error1, result) => {
            if (error1 == 1) {
                if (result.affectedRows > 0) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ data: result, message: "BCID EID Setting Updated Successfully!", status: 201 });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Something Went Wrong With Data!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                objv.execute();
            }
        });
    }
    getBcidEid(req, res, otherPayLoad, next) {
        let condition = "";
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        if (otherPayLoad.eiD || otherPayLoad.eidName || (otherPayLoad.toDate && otherPayLoad.fromDate)) {
            if (otherPayLoad.eiD) {
                condition += "`eid` = '" + (0, markError_1.parseBody)(otherPayLoad.eiD) + "' AND";
            }
            if (otherPayLoad.eidName) {
                condition += "`eid_name` = '" + (0, markError_1.parseBody)(otherPayLoad.eidName) + "' AND ";
            }
            if (otherPayLoad.fromDate && otherPayLoad.toDate) {
                condition += '`created_at` BETWEEN "' + otherPayLoad.fromDate + ' 00:00:00" AND "' + otherPayLoad.toDate + ' 23:59:59"';
            }
            obj.qrysql = "SELECT `idbcideid`,`eid`,`eid_name`,`created_at` FROM `sip_bcid_eid` WHERE " + condition;
        }
        else {
            obj.qrysql = "SELECT `idbcideid`,`eid`,`eid_name`,`created_at` FROM `sip_bcid_eid`";
        }
        obj.prepare();
        obj.execute((error1, result) => {
            if (error1 == 1) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ data: result, message: "SIP BCID Setting Fetched Successfully!", status: 201 });
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                objv.execute();
            }
        });
    }
    deleteBcidEid(req, res, otherPayLoad, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj.nonqrysql = "DELETE FROM `sip_bcid_eid` WHERE `idbcideid` = '" + otherPayLoad.idbcideid + "'";
        obj.prepare();
        obj.execute((error1, result) => {
            if (error1 == 1) {
                if (result.affectedRows > 0) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 201, message: "SIP BCID Setting Deleted Successfully!" });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 503, message: "Something Went Wrong!" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 503, message: "Something Went Wrong!" });
                objv.execute();
            }
        });
    }
    getBcidDid(req, res, otherPayLoad, next) {
        let condition = "";
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        if (otherPayLoad.did || otherPayLoad.accountID || otherPayLoad.sipID || otherPayLoad.bcidEID || (otherPayLoad.toDate && otherPayLoad.fromDate)) {
            if (otherPayLoad.sipID) {
                condition += "`idsipts` = '" + otherPayLoad.sipID + "' AND";
            }
            if (otherPayLoad.bcidEID) {
                condition += "`idbcideid` = '" + otherPayLoad.bcidEID + "' AND ";
            }
            if (otherPayLoad.accountID) {
                condition += "`idaccount` = '" + otherPayLoad.accountID + "' AND ";
            }
            if (otherPayLoad.did) {
                condition += "`did` = '" + otherPayLoad.did + "' AND ";
            }
            if (otherPayLoad.fromDate && otherPayLoad.toDate) {
                condition += '`created_at` BETWEEN "' + otherPayLoad.fromDate + ' 00:00:00" AND "' + otherPayLoad.toDate + ' 23:59:59"';
            }
            obj.qrysql = "SELECT sbo.`idbcidoverride`,sbo.`idbcideid`,sbo.`idaccount`,(100000000 + sbo.`idaccount`) AS san,sbo.`idsipts`,sbo.`sip_override_prefix`,sbo.`sip_override_ip`,sbo.`did`,sbo.`idbcideid`,sbo.`eid`,sbo.`created_at`,(SELECT `eid_name` FROM `sip_bcid_eid` WHERE `idbcideid`=sbo.`idbcideid`) AS `eid_name`,(SELECT `sip_name` FROM `sip_trunking_setting` WHERE `idsipts`=sbo.`idsipts`) AS `sip_name`,(SELECT `type` FROM `sip_trunking_setting` WHERE `idsipts`=sbo.`idsipts`) AS `type` FROM `sip_bcid_override` sbo WHERE " + condition;
        }
        else {
            obj.qrysql = "SELECT sbo.`idbcidoverride`,sbo.`idbcideid`,sbo.`idaccount`,(100000000 + sbo.`idaccount`) AS san,sbo.`idsipts`,sbo.`sip_override_prefix`,sbo.`sip_override_ip`,sbo.`did`,sbo.`idbcideid`,sbo.`eid`,sbo.`created_at`,(SELECT `eid_name` FROM `sip_bcid_eid` WHERE `idbcideid`=sbo.`idbcideid`) AS `eid_name`,(SELECT `sip_name` FROM `sip_trunking_setting` WHERE `idsipts`=sbo.`idsipts`) AS `sip_name`,(SELECT `type` FROM `sip_trunking_setting` WHERE `idsipts`=sbo.`idsipts`) AS `type` FROM `sip_bcid_override` sbo";
        }
        obj.prepare();
        obj.execute((error1, result) => {
            if (error1 == 1) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ data: result, message: "SIP BCID Setting Fetched Successfully!", status: 201 });
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Something Went Wrong!", status: 502 });
                objv.execute();
            }
        });
    }
    addBcidDID(req, res, userPayLoad, otherPayLoad, next) {
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "Select `sip_ip`,`sip_prefix` From `sip_trunking_setting` WHERE `idsipts` = '" + otherPayLoad.idsipts + "'";
        obj1.prepare();
        obj1.execute((error1, result1) => {
            if (error1 == 1) {
                if (result1.length > 0) {
                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                    obj2.qrysql = "Select `eid` From `sip_bcid_eid` WHERE `idbcideid` = '" + otherPayLoad.idbcideid + "'";
                    obj2.prepare();
                    obj2.execute((error2, result2) => {
                        if (error2 == 1) {
                            if (result2.length > 0) {
                                let number = otherPayLoad.did.length;
                                let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                let qry0 = "INSERT into `sip_bcid_override` (`idaccount`,`idsipts`,`sip_override_prefix`,`sip_override_ip`,`did`,`idbcideid`,`eid`) VALUES";
                                for (let i = 0; i < number; i++) {
                                    let entry1 = otherPayLoad.did[i];
                                    qry0 += "('" + userPayLoad.idaccount + "','" + otherPayLoad.idsipts + "','" + (0, markError_1.parseBody)(result1[0].sip_prefix) + "','" + result1[0].sip_ip + "','" + entry1 + "','" + otherPayLoad.idbcideid + "','" + (0, markError_1.parseBody)(result2[0].eid) + "'),";
                                }
                                obj0.nonqrysql = qry0.slice(0, -1);
                                obj0.prepare();
                                obj0.execute((error3, result3) => {
                                    if (error3 == 1) {
                                        if (result3.affectedRows > 0) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ data: result3, message: "BCID DID Created Successfully!", status: 201 });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Something Went Wrong With Data!" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Something Went Wrong With Data!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something Went Wrong With Get Data!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something Went Wrong With Get Data!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Something Went Wrong With Get Data!" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "Something Went Wrong With Get Data!" });
                objv.execute();
            }
        });
    }
    editBcidDID(req, res, userPayLoad, otherPayLoad, next) {
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = "Select `sip_ip`,`sip_prefix` From `sip_trunking_setting` WHERE `idsipts` = '" + otherPayLoad.idsipts + "'";
        obj1.prepare();
        obj1.execute((error1, result1) => {
            if (error1 == 1) {
                if (result1.length > 0) {
                    let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                    obj2.qrysql = "Select `eid` From `sip_bcid_eid` WHERE `idbcideid` = '" + otherPayLoad.idbcideid + "'";
                    obj2.prepare();
                    obj2.execute((error2, result2) => {
                        if (error2 == 1) {
                            if (result2.length > 0) {
                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "DELETE FROM `sip_bcid_override` WHERE `idbcidoverride` = '" + otherPayLoad.idbcidoverride + "'";
                                obj3.prepare();
                                obj3.execute((error3, result3) => {
                                    if (error3 == 1) {
                                        if (result3.affectedRows > 0) {
                                            let number = otherPayLoad.did.length;
                                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            let qry0 = "INSERT into `sip_bcid_override` (`idaccount`,`idsipts`,`sip_override_prefix`,`sip_override_ip`,`did`,`idbcideid`,`eid`) VALUES";
                                            for (let i = 0; i < number; i++) {
                                                let entry1 = otherPayLoad.did[i];
                                                qry0 += "('" + userPayLoad.idaccount + "','" + otherPayLoad.idsipts + "','" + (0, markError_1.parseBody)(result1[0].sip_prefix) + "','" + result1[0].sip_ip + "','" + entry1 + "','" + otherPayLoad.idbcideid + "','" + (0, markError_1.parseBody)(result2[0].eid) + "'),";
                                            }
                                            obj0.nonqrysql = qry0.slice(0, -1);
                                            obj0.prepare();
                                            obj0.execute((error4, result4) => {
                                                if (error4 == 1) {
                                                    if (result4.affectedRows > 0) {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ data: result4, message: "BCID DID Updated Successfully!", status: 201 });
                                                        objv.execute();
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 502, message: "Something Went Wrong With Data!" });
                                                        objv.execute();
                                                    }
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 502, message: "Something Went Wrong With Data!" });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Something Went Wrong With Delete Data!" });
                                            objv.execute();
                                        }
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Something Went Wrong With Delete Data!" });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something Went Wrong With Get Data!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 502, message: "Something Went Wrong With Get Data!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 502, message: "Something Went Wrong With Get Data!" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "Something Went Wrong With Get Data!" });
                objv.execute();
            }
        });
    }
    deleteBcidDID(req, res, otherPayLoad, next) {
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj.nonqrysql = "DELETE FROM `sip_bcid_override` WHERE `idbcidoverride` = '" + otherPayLoad.idbcidoverride + "'";
        obj.prepare();
        obj.execute((error1, result) => {
            if (error1 == 1) {
                if (result.affectedRows > 0) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 201, message: "BCID DID Deleted Successfully!" });
                    objv.execute();
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 503, message: "Something Went Wrong With Data!" });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 503, message: "Something Went Wrong!" });
                objv.execute();
            }
        });
    }
    closingInvoiceDetail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let sdata = req.query;
                        let msg = '';
                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let condition = "";
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            if (sdata.selectedUser || (sdata.to_date && sdata.from_date)) {
                                if (sdata.from_date && sdata.to_date && !sdata.selectedUser) {
                                    condition += 'a.`created_at` BETWEEN "' + sdata.from_date + ' 00:00:00" AND "' + sdata.to_date + ' 23:59:59"';
                                }
                                if (sdata.selectedUser && !(sdata.to_date && sdata.from_date)) {
                                    condition += 'a.`idaccount`="' + sdata.selectedUser + '"';
                                }
                                if (sdata.selectedUser && sdata.from_date && sdata.to_date) {
                                    condition += 'a.created_at BETWEEN "' + sdata.from_date + ' 00:00:00" AND "' + sdata.to_date + ' 23:59:59" AND a.`idaccount`="' + sdata.selectedUser + '"';
                                }
                                obj.qrysql = "SELECT `a`.`san`,`a`.`idinvoice`,`a`.`path`,`a`.`idaccount`, `a`.`invoice_number`, a.customer_name, DATE_FORMAT(`a`.`created_at`, '%Y-%m-%d')`created_at`, `ai`.`total_amount`,`ai`.`tax` FROM `account_invoice` `a` INNER JOIN `account_invoice_closing` `ai` ON `a`.`idinvoice`=`ai`.`idinvoice`  WHERE " + condition + "   GROUP BY `a`.`idinvoice` ORDER BY `a`.`created_at` DESC";
                            }
                            else {
                                obj.qrysql = "SELECT `a`.`san`,`a`.`idinvoice`,`a`.`path`,`a`.`idaccount`, `a`.`invoice_number`, a.customer_name, DATE_FORMAT(`a`.`created_at`, '%Y-%m-%d')`created_at`, `ai`.`total_amount`,`ai`.`tax` FROM `account_invoice` `a` INNER JOIN `account_invoice_closing` `ai` ON `a`.`idinvoice`=`ai`.`idinvoice`   GROUP BY `a`.`idinvoice` ORDER BY `a`.`created_at` DESC";
                            }
                            obj.prepare();
                            obj.execute((error, result) => {
                                if (error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, message: "Closing Invoice Fetched Successfully!", status: 201 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    userFilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let msg = '';
                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let qdata = req.query.type;
                            var sdata = JSON.parse(qdata);
                            let iQry = "", iQN = 0, cond = "";
                            iQry = "SELECT DISTINCT u.kyc_verify_status,u.volt_status,u.trust_score,u.federal_status,u.card_pdf,a.san,u.reseller_iduser,a.is_billing,u.isEmailVerify,w.balance,w.credit_limit,u.isMobileVerify,u.isAddress, 1 `utype`,u.isPlan, u.iduser, u.idaccount, u.`username` `user_name`, u.type,u.is_deleted,u.deleted_date , u.pending_deleted_date , isCard,newUser_status,ba.title, u.created , up.firstname `first_name`, up.lastname `last_name`, up.email, up.phone `contact_number`,IF(LENGTH(up.profile_pic)=0 || up.profile_pic='undefined' || up.profile_pic IS NULL, CONCAT(CEIL(1+RAND()*7),'.jpg'), up.profile_pic) profile_pic, u.idtariff, u.idservice FROM `user` u LEFT JOIN `account` a ON a.idaccount=u.idaccount LEFT JOIN `user_profile` up ON u.iduser=up.iduser LEFT JOIN `wallet` w ON w.idaccount = u.idaccount LEFT JOIN `billing_address` ba ON ba.idaccount = u.idaccount  WHERE u.type = 2 ";
                            // iQry = "SELECT * FROM `user` \n"
                            if ((Array.isArray(sdata.idaccount) && sdata.idaccount.length > 0 && sdata.idaccount[0].userdata)) {
                                cond += "AND u.idaccount='" + sdata.idaccount[0].userdata + "' ";
                                iQN++;
                            }
                            if (sdata.from_date != '' && sdata.from_date && !sdata.to_date) {
                                cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')>='" + sdata.from_date + "' ";
                                iQN++;
                            }
                            if (sdata.to_date != '' && sdata.to_date && !sdata.from_date) {
                                cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')<='" + sdata.to_date + "' ";
                                iQN++;
                            }
                            if (sdata.from_date && sdata.to_date) {
                                cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')>='" + sdata.from_date + "' AND DATE_FORMAT(u.created, '%Y-%m-%d')<='" + sdata.to_date + "' ";
                                iQN++;
                            }
                            if ((Array.isArray(sdata.service) && sdata.service.length > 0 && sdata.service[0].preferid)) {
                                cond += "AND u.idservice='" + sdata.service[0].preferid + "' ";
                                iQN++;
                            }
                            if ((Array.isArray(sdata.regTariff) && sdata.regTariff.length > 0 && sdata.regTariff[0].regid)) {
                                cond += "AND u.idtariff='" + sdata.regTariff[0].regid + "' ";
                                iQN++;
                            }
                            if (iQN > 0) {
                                iQry += cond;
                                iQry = iQry.slice(0, -1) + "\n";
                            }
                            iQry += "ORDER BY `created`;";
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = iQry;
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "User Fetched Successfully.",
                                        status: 201
                                    });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "Something Went Wrong!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    permanentDeleteAccount(req, res, next) {
        let sdata = req.body.data;
        let msg = '';
        switch (true) {
            case !sdata:
                msg = 'Request body not found!';
                break;
        }
        if (msg) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        }
        else {
            let session = new Session_1.SessionManagment(req, res, next);
            session.GetSession((error, sessdata) => {
                if (error == 1) {
                    validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                        if (err == 1) {
                            // if (sessdata.type == 1) {
                            // let mmessage:any='Customer Account Deleted Successfully.!', mstatus:any=201;
                            //Delete From User table
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT `iduser`, `idaccount`, `idtariff`, `idservice`, `username`, `type`, `default`, `selected`, `did`, `sms`, `voice`, `status`, DATE_FORMAT(`created`, '%Y-%m-%d %H:%i:%s') as `created`, `isEmailVerify`, `isMobileVerify`, `validationKey`, `secret`, `isAddress`, `isCard`, `isPlan`, `isResetPassword`, `is_deleted`, `newUser_status`, DATE_FORMAT(`pending_deleted_date`, '%Y-%m-%d %H:%i:%s') as `pending_deleted_date`, DATE_FORMAT(`deleted_date`, '%Y-%m-%d %H:%i:%s') as `deleted_date`, DATE_FORMAT(`restore_date`, '%Y-%m-%d %H:%i:%s') as `restore_date`, `ipAddress`, `browser`,`signup_link_id`, `reseller_iduser`, `email_verification_date`, `card_pdf`, `kyc_verify_status`, `volt_status`, `federal_status`, `resetPassword`, `trust_score` FROM `user` WHERE `idaccount` = '" + sdata.idaccount + "'";
                            obj.prepare();
                            obj.execute((error, userRes) => {
                                if (error == 1 && userRes.length > 0) {
                                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `archive_user` (`iduser`, `idaccount`, `idtariff`, `idservice`, `username`, `type`, `default`, `selected`, `did`, `sms`, `voice`, `status`, `created`, `isEmailVerify`, `isMobileVerify`, `validationKey`, `secret`, `isAddress`, `isCard`, `isPlan`, `isResetPassword`, `is_deleted`, `newUser_status`, `pending_deleted_date`, `deleted_date`, `restore_date`, `ipAddress`, `browser`, `signup_link_id`, `reseller_iduser`, `email_verification_date`, `card_pdf`, `kyc_verify_status`, `volt_status`, `federal_status`, `resetPassword`, `trust_score`) VALUES";
                                    userRes.forEach((ele) => {
                                        qrystr += "('" + ele.iduser + "','" + ele.idaccount + "','" + (0, markError_1.setToZero)(ele.idtariff) + "','" + (0, markError_1.setToZero)(ele.idservice) + "','" + (0, markError_1.parseBody)(ele.username) + "','" + ele.type + "','" + ele.default + "','" + (0, markError_1.setEnum)(ele.selected) + "','" + ele.did + "','" + ele.sms + "','" + ele.voice + "','" + (0, markError_1.setEnum)(ele.status) + "','" + ele.created + "','" + (0, markError_1.setEnum)(ele.isEmailVerify) + "','" + (0, markError_1.setEnum)(ele.isMobileVerify) + "','" + ele.validationKey + "','" + ele.secret + "','" + (0, markError_1.setEnum)(ele.isAddress) + "','" + (0, markError_1.setEnum)(ele.isCard) + "','" + (0, markError_1.setEnum)(ele.isPlan) + "','" + (0, markError_1.setEnum)(ele.isResetPassword) + "','" + ele.is_deleted + "','" + ele.newUser_status + "','" + ele.pending_deleted_date + "','" + ele.deleted_date + "','" + ele.restore_date + "','" + ele.ipAddress + "','" + ele.browser + "','" + ele.signup_link_id + "','" + (0, markError_1.setToZero)(ele.reseller_iduser) + "','" + ele.email_verification_date + "','" + ele.card_pdf + "','" + (0, markError_1.setToZero)(ele.kyc_verify_status) + "','" + (0, markError_1.setToZero)(ele.volt_status) + "','" + (0, markError_1.setToZero)(ele.federal_status) + "','" + ele.resetPassword + "','" + (0, markError_1.setToZero)(ele.trust_score) + "'),";
                                    });
                                    obj2.nonqrysql = qrystr.slice(0, -1);
                                    obj2.prepare();
                                    obj2.execute((err_user, user_res) => {
                                        keycloak.DeleteuserKeyclock(req, res, (0, markError_1.parseBody)(userRes[0].username), (deleteKCRes) => {
                                            if (deleteKCRes == 1) {
                                                console.log("✅ User deleted successfully from Keycloak!");
                                            }
                                            else {
                                                console.log("⚠️ Failed to delete user from Keycloak");
                                            }
                                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj.nonqrysql = "DELETE FROM `user` WHERE `idaccount`='" + sdata.idaccount + "'";
                                            obj.prepare();
                                            obj.execute((error, deluserRes) => { });
                                        });
                                    });
                                }
                                else {
                                    console.log({ mmessage: "Data not found from user", mstatus: 504 });
                                }
                            });
                            // Delete From User Profile Table
                            let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                            obj3.qrysql = "SELECT `idsupplier`, `iduser`, `firstname`, `lastname`, `email`, `phone`, `profile_pic`, `domain`, `secret`, `key`, `account_id`, `auth_token`, `uploaded_file` FROM `user_profile` WHERE  `account_id` = '" + sdata.idaccount + "'";
                            obj3.prepare();
                            obj3.execute((error, userProfRes) => {
                                if (error == 1 && userProfRes.length > 0) {
                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `archive_user_profile` (`idsupplier`, `iduser`, `firstname`, `lastname`, `email`, `phone`, `profile_pic`, `domain`, `secret`, `key`, `account_id`, `auth_token`, `uploaded_file`) VALUES";
                                    userProfRes.forEach((ele) => {
                                        qrystr += "('" + ele.idsupplier + "','" + ele.iduser + "','" + (0, markError_1.parseBody)(ele.firstname) + "','" + (0, markError_1.parseBody)(ele.lastname) + "','" + (0, markError_1.parseBody)(ele.email) + "','" + ele.phone + "','" + ele.profile_pic + "','" + ele.domain + "','" + ele.secret + "','" + ele.key + "','" + ele.account_id + "','" + ele.auth_token + "','" + ele.uploaded_file + "'),";
                                    });
                                    obj4.nonqrysql = qrystr.slice(0, -1);
                                    obj4.prepare();
                                    obj4.execute((err_userPro, user_res) => {
                                        if (err_userPro == 1) {
                                            let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj5.nonqrysql = "DELETE FROM `user_profile` WHERE `account_id`='" + sdata.idaccount + "'";
                                            obj5.prepare();
                                            obj5.execute((error, deluserRes) => { });
                                        }
                                        else {
                                            console.log({ message: "Data not Inserted Successfully in user_profile!", status: 503 });
                                        }
                                    });
                                }
                                else {
                                    console.log({ message: "Data not found from account!", status: 504 });
                                }
                            });
                            // Delete From Account Table
                            let obj6 = new RawQuery_1.ModelRawQuery(req, res);
                            obj6.qrysql = "SELECT `idaccount`, `san`, `idtariff1`, `idtariff2`, `account_type`, `balance`, `credit`, `deleted`, DATE_FORMAT(`created`, '%Y-%m-%d %H:%i:%s') as `created`, `csp_id`, `is_billing`, `ib_channel`, `ob_channel`, `cps` FROM `account` WHERE `idaccount` = '" + sdata.idaccount + "'";
                            obj6.prepare();
                            obj6.execute((error, accRes) => {
                                if (error == 1 && accRes.length > 0) {
                                    let obj7 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `archive_account` (`idaccount`, `san`, `idtariff1`, `idtariff2`, `account_type`, `balance`, `credit`, `deleted`, `created`, `csp_id`, `is_billing`, `ib_channel`, `ob_channel`, `cps`) VALUES";
                                    accRes.forEach((ele) => {
                                        qrystr += "('" + ele.idaccount + "','" + ele.san + "','" + (0, markError_1.setToZero)(ele.idtariff1) + "','" + (0, markError_1.setToZero)(ele.idtariff2) + "','" + ele.account_type + "','" + (0, markError_1.setToZero)(ele.balance) + "','" + (0, markError_1.setToZero)(ele.credit) + "','" + (0, markError_1.setToZero)(ele.deleted) + "','" + ele.created + "','" + (0, markError_1.setToZero)(ele.csp_id) + "','" + (0, markError_1.setToZero)(ele.is_billing) + "','" + (0, markError_1.setToZero)(ele.ib_channel) + "','" + (0, markError_1.setToZero)(ele.ob_channel) + "','" + (0, markError_1.setToZero)(ele.cps) + "'),";
                                    });
                                    obj7.nonqrysql = qrystr.slice(0, -1);
                                    obj7.prepare();
                                    obj7.execute((err_userPro, user_res) => {
                                        if (err_userPro == 1) {
                                            let iQry = "SET FOREIGN_KEY_CHECKS = 0;\n";
                                            iQry += "DELETE FROM `account` WHERE `idaccount`='" + sdata.idaccount + "';\n";
                                            iQry += "SET FOREIGN_KEY_CHECKS = 1;";
                                            let obj8 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj8.nonqrysql = iQry;
                                            obj8.prepare();
                                            obj8.execute((error, deluserRes) => { });
                                        }
                                        else {
                                            console.log({ message: "Data not Inserted Successfully in archive_account!", status: 503 });
                                        }
                                    });
                                }
                                else {
                                    console.log({ message: "Data not found from account!", status: 504 });
                                }
                            });
                            // Delete From Billing Address Table
                            let obj9 = new RawQuery_1.ModelRawQuery(req, res);
                            obj9.qrysql = "SELECT `idbilling_address`, `idaccount`, `customerType`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`, `title`, `ein`, `website`, `legal_name`, `groupExmpt_number`, `businessName`, `is_valid` FROM `billing_address` WHERE `idaccount` ='" + sdata.idaccount + "'";
                            obj9.prepare();
                            obj9.execute((error, billRes) => {
                                if (error == 1 && billRes.length > 0) {
                                    let obj10 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qrystr = "INSERT INTO `archive_billing_address` (`idbilling_address`, `idaccount`, `customerType`, `first_name`, `last_name`, `contact`, `email`, `address1`, `address2`, `city`, `state`, `postal_code`, `country`, `title`, `ein`, `website`, `legal_name`, `groupExmpt_number`, `businessName`, `is_valid`) VALUES";
                                    billRes.forEach((ele) => {
                                        qrystr += "('" + ele.idbilling_address + "','" + ele.idaccount + "','" + ele.customerType + "','" + (0, markError_1.parseBody)(ele.first_name) + "','" + (0, markError_1.parseBody)(ele.last_name) + "','" + ele.contact + "','" + (0, markError_1.parseBody)(ele.email) + "','" + (0, markError_1.parseBody)(ele.address1) + "','" + (0, markError_1.parseBody)(ele.address2) + "','" + (0, markError_1.parseBody)(ele.city) + "','" + (0, markError_1.parseBody)(ele.state) + "','" + (0, markError_1.parseBody)(ele.postal_code) + "','" + (0, markError_1.parseBody)(ele.country) + "','" + (0, markError_1.parseBody)(ele.title) + "','" + (0, markError_1.parseBody)(ele.ein) + "','" + (0, markError_1.parseBody)(ele.website) + "','" + (0, markError_1.parseBody)(ele.legal_name) + "','" + (0, markError_1.setToZero)(ele.groupExmpt_number) + "','" + (0, markError_1.parseBody)(ele.businessName) + "','" + (0, markError_1.setToZero)(ele.is_valid) + "'),";
                                    });
                                    obj10.nonqrysql = qrystr.slice(0, -1);
                                    obj10.prepare();
                                    obj10.execute((err_userPro, user_res) => {
                                        if (err_userPro == 1) {
                                            let obj11 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                            obj11.nonqrysql = "DELETE FROM `billing_address` WHERE `idaccount`='" + sdata.idaccount + "'";
                                            obj11.prepare();
                                            obj11.execute((error, deluserRes) => { });
                                        }
                                        else {
                                            console.log({ message: "Data not Inserted Successfully in archive_billing_address!", status: 503 });
                                        }
                                    });
                                }
                                else {
                                    console.log({ message: "Data not found from billing_address!", status: 504 });
                                }
                            });
                            // Delete Connections 
                            let obj00 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj00.nonqrysql = "CALL ConnectionDeleteForAccount(" + sdata.idaccount + ",'permanent_delete')";
                            obj00.prepare();
                            obj00.execute((error, result) => {
                                console.log(result);
                            });
                            /* let obj00 = new ModelRawQuery(req, res);
                            obj00.qrysql = "SELECT `idendpoint` FROM `endpoint` WHERE `idaccount` = " + sdata.idaccount + "";
                            obj00.prepare();
                            obj00.execute((error: any, resultIdEnPoints: any) => {
                                if (error == 1 && resultIdEnPoints.length > 0) {
                                    let ids: any = resultIdEnPoints.map((ele: any) => `'${ele.idendpoint}'`).join(",");
                                    // Data Removed from Endpoint Table for Connection
                                    let obj13 = new ModelRawNonQuery(req, res);
                                    obj13.nonqrysql = "DELETE FROM `endpoint` WHERE `idaccount`='" + sdata.idaccount + "'";
                                    obj13.prepare();
                                    obj13.execute((____error: any, result: any) => {
                                        console.log("All Connection Data Deleted");
                                    })

                                    let obj14 = new ModelRawNonQuery(req, res);
                                    obj14.nonqrysql = "DELETE FROM `inbound` WHERE `idendpoint` IN (" + ids + ")";
                                    obj14.prepare();
                                    obj14.execute((____error: any, result: any) => {
                                        console.log("All inbound Data Deleted");
                                    });

                                    // Data Removed from outbound Table for Connection
                                    let obj15 = new ModelRawNonQuery(req, res);
                                    obj15.nonqrysql = "DELETE FROM `outbound` WHERE `idendpoint` IN (" + ids + ")";

                                    obj15.prepare();
                                    obj15.execute((____error: any, result: any) => {
                                        console.log("All outbound Data Deleted");
                                    })

                                    // Data Removed from hooksetting Table for Connection
                                    let obj16 = new ModelRawNonQuery(req, res);
                                    obj16.nonqrysql = "DELETE FROM `hooksetting` WHERE `idaccount`='" + sdata.idaccount + "'";
                                    obj16.prepare();
                                    obj16.execute((____error: any, result: any) => {
                                        console.log("All hooksetting Data Deleted");
                                    })

                                    // Data Removed from ip_address Table for Connection
                                    let obj17 = new ModelRawNonQuery(req, res);
                                    obj17.nonqrysql = "DELETE FROM `ip_address` WHERE `idendpoint` IN (" + ids + ")";
                                    obj17.prepare();
                                    obj17.execute((____error: any, result: any) => {
                                        console.log("All IP Address Data Deleted");
                                    })

                                    // Data Removed from ip_address Table for Connection
                                    let obj18 = new ModelRawNonQuery(req, res);
                                    obj18.nonqrysql = "DELETE FROM `routing_profile` WHERE `idendpoint` IN (" + ids + ")";
                                    obj18.prepare();
                                    obj18.execute((____error: any, result: any) => {
                                        console.log("All Routing Profile Data Deleted");
                                    })

                                } else {
                                    console.log({ message: "Data not found from endpoint!", status: 504 });
                                }

                            }); */
                            //Data Removed from Session Table
                            let obj18 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj18.nonqrysql = "DELETE FROM `session` WHERE `idaccount`='" + sdata.idaccount + "'";
                            obj18.prepare();
                            obj18.execute((__error, delSessRes) => {
                                console.log("All Session Data Deleted");
                            });
                            //Data API from Session Table
                            let obj0 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj0.nonqrysql = "DELETE FROM `api` WHERE `idaccount`=" + sdata.idaccount + " ";
                            obj0.prepare();
                            obj0.execute((___error, delApiRes) => {
                                console.log("All API Data Deleted");
                            });
                            let obj19 = new RawView_1.RawView(res);
                            obj19.prepare({ message: 'Customer Account Deleted Successfully.!', status: 201 });
                            obj19.execute();
                        }
                        else {
                            let objvs = new RawView_1.RawView(res);
                            objvs.prepare(dt);
                            objvs.execute();
                        }
                    });
                }
                else {
                    let objv = new _406_1.Res406(res);
                    objv.prepare({ status: 401, message: "Unauthorized User!" });
                    objv.execute();
                }
            });
        }
    }
    CustomerCount(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let msg = '';
                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let sdata = req.query.type;
                            let data = JSON.parse(sdata);
                            let idUser = data.iduser;
                            let IDAccount = data.idaccount;
                            // brand 
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT SUM(CASE WHEN identityStatus = '' AND deleted = 0 THEN 1 ELSE 0 END) AS pending_brand, SUM(CASE WHEN identityStatus = 'VERIFIED' AND deleted = 0 THEN 1 ELSE 0 END) AS verified, SUM(CASE WHEN identityStatus = 'VETTED_VERIFIED' AND deleted = 0 THEN 1 ELSE 0 END) AS vetted_verified, SUM(CASE WHEN identityStatus = 'UNVERIFIED' AND deleted = 0 THEN 1 ELSE 0 END) AS unverified, SUM(CASE WHEN identityStatus = 'SELF_DECLARED' AND deleted = 0 THEN 1 ELSE 0 END) AS self_declared, SUM(CASE WHEN deleted = 1 THEN 1 ELSE 0 END) AS deleted FROM brand WHERE STATUS = 0 AND `idaccount` = '" + IDAccount + "'";
                            obj.prepare();
                            obj.execute((error, result) => {
                                if (error == 1) {
                                    // campaign
                                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                    obj1.qrysql = "SELECT SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 7 AND c.deleted = 0 THEN 1 ELSE 0 END) AS pending_campaign, SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 1 AND c.deleted = 0 THEN 1 ELSE 0 END) AS campaign_shared, SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 0 AND c.deleted = 0 THEN 1 ELSE 0 END) AS approved_campaign, SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 5 AND c.deleted = 0 THEN 1 ELSE 0 END) AS rejected,SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 3 AND c.deleted = 0 THEN 1 ELSE 0 END) AS provisioning_complete,SUM(CASE WHEN c.STATUS = '0' AND c.provisioning_status = 4 AND c.deleted = 0 THEN 1 ELSE 0 END) AS provisioning_failed,SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 3 AND c.deleted = 0 THEN 1 ELSE 0 END) AS provisioning_redundant_complete,SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 4 AND c.deleted = 0 THEN 1 ELSE 0 END) AS provisioning_redundant_failed,SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 7 AND c.deleted = 0 THEN 1 ELSE 0 END) AS pending_redundant_campaign, SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 1 AND c.deleted = 0 THEN 1 ELSE 0 END) AS campaign_shared_redundant, SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 0 AND c.deleted = 0 THEN 1 ELSE 0 END) AS approved_redundant_campaign, SUM(CASE WHEN c.STATUS = '2' AND c.provisioning_status = 5 AND c.deleted = 0 THEN 1 ELSE 0 END) AS rejected_redundant_campaign, SUM(CASE WHEN c.STATUS = '2' OR c.STATUS = '0' THEN 1 ELSE 0 END) AS total_camp, SUM(CASE WHEN (c.STATUS = '2' ) AND c.deleted = 1 THEN 1 ELSE 0 END) AS deleted_camp,SUM(CASE WHEN ( c.STATUS = '0') AND c.deleted = 1 THEN 1 ELSE 0 END) AS deleted_redundant_camp FROM brand b INNER JOIN campaign c ON c.idbrand = b.brandId WHERE c.`idaccount` = '" + IDAccount + "'";
                                    obj1.prepare();
                                    obj1.execute((err, resultcam) => {
                                        if (err == 1) {
                                            let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                                            obj2.qrysql = "SELECT COUNT(*) AS total_conn, (SELECT name FROM endpoint WHERE iduser =  '" + idUser + "' AND isdefault = true LIMIT 1) AS default_name,(SELECT connection_key FROM endpoint WHERE iduser =  '" + idUser + "' AND isdefault = true LIMIT 1) AS connection_key FROM endpoint WHERE `iduser` = '" + idUser + "'";
                                            obj2.prepare();
                                            obj2.execute((errr, resultcon) => {
                                                if (errr == 1) {
                                                    // tariff  reselelr and etc
                                                    let obj3 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj3.qrysql = "SELECT COALESCE(u.kyc_verify_status, NULL) AS kyc_verify_status, COALESCE(u.federal_status, NULL) AS federal_status, COALESCE(t.name, NULL) AS tariff_name, COALESCE(s.name, NULL) AS service_name FROM user u LEFT JOIN tariff t ON u.idtariff = t.idtariff LEFT JOIN service s ON u.idservice = s.idservice WHERE u.iduser = '" + idUser + "' AND u.idaccount = '" + IDAccount + "'";
                                                    obj3.prepare();
                                                    obj3.execute((eror, resulttr) => {
                                                        if (eror == 1) {
                                                            // subcustomer
                                                            let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                                            obj4.qrysql = "SELECT COUNT(*) AS total_subCust FROM user WHERE type = 22 AND `idaccount` = '" + IDAccount + "'";
                                                            obj4.prepare();
                                                            obj4.execute((erorr, resultsc) => {
                                                                if (erorr == 1) {
                                                                    // credit cards 
                                                                    let obj5 = new RawQuery_1.ModelRawQuery(req, res);
                                                                    obj5.qrysql = "SELECT COALESCE(active_card, NULL) AS active_card, COALESCE(deleted_card, NULL) AS deleted_card, exp_year, last4, exp_month FROM (SELECT (SELECT COUNT(*) FROM stripe_card WHERE idaccount = '" + IDAccount + "' AND isdeleted = '0') AS active_card, (SELECT COUNT(*) FROM stripe_card WHERE idaccount = '" + IDAccount + "' AND isdeleted = '1') AS deleted_card, exp_year, last4, exp_month FROM stripe_card WHERE idaccount = '" + IDAccount + "' AND `default` = true LIMIT 1) AS subquery UNION ALL SELECT NULL AS active_card, NULL AS deleted_card, NULL AS exp_year, NULL AS last4, NULL AS exp_month WHERE NOT EXISTS (SELECT 1 FROM stripe_card WHERE idaccount = '" + IDAccount + "' AND `default` = true)";
                                                                    obj5.prepare();
                                                                    obj5.execute((errorr, resultCar) => {
                                                                        if (errorr == 1) {
                                                                            // billing adre
                                                                            let obj6 = new RawQuery_1.ModelRawQuery(req, res);
                                                                            obj6.qrysql = "SELECT ba.idbilling_address as id_billing_address, ba.first_name, ba.last_name, ba.address1, ba.address2, ba.city, ba.state, ba.postal_code, ba.country, ba.ein, ba.website, ba.groupExmpt_number, ba.businessName, ba.customerType, up.firstname, up.lastname, up.phone, up.email FROM billing_address ba RIGHT JOIN user_profile up ON ba.`idaccount` = '" + IDAccount + "' WHERE up.`iduser` = '" + idUser + "'";
                                                                            obj6.prepare();
                                                                            obj6.execute((eroor, resultba) => {
                                                                                if (eroor == 1) {
                                                                                    // Wallert 
                                                                                    let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                                                                    obj4.qrysql = "SELECT balance , min_balance,credit_limit,topup_amount FROM wallet WHERE `idaccount` = '" + IDAccount + "'";
                                                                                    obj4.prepare();
                                                                                    obj4.execute((errrr, resultw) => {
                                                                                        if (errrr == 1) {
                                                                                            let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                                                                            obj4.qrysql = "SELECT COUNT(CASE WHEN a.as_status = '1' THEN 1 END) AS active_service, COUNT(CASE WHEN a.as_status = '0' THEN 1 END) AS suspended_service, GROUP_CONCAT(CASE WHEN a.as_status = '1' THEN f.fs_name END ORDER BY f.fs_name ASC SEPARATOR ', ') AS active_service_name, GROUP_CONCAT(CASE WHEN a.as_status = '0' THEN f.fs_name END ORDER BY f.fs_name ASC SEPARATOR ', ') AS suspended_service_name FROM account_service a INNER JOIN feature_service f ON a.fs_id = f.fs_id WHERE a.idaccount = '" + IDAccount + "'";
                                                                                            obj4.prepare();
                                                                                            obj4.execute((errorr, resultsus) => {
                                                                                                if (errorr == 1) {
                                                                                                    let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                                                                                    obj4.qrysql = "SELECT SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' THEN 1 ELSE 0 END) AS active_local_did, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '0' THEN 1 ELSE 0 END) AS disconnect_local_did, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `osr_status` = 'register' AND `sinch_status` = '1' THEN 1 ELSE 0 END) AS active_sms_local, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `sinch_status` = '0' THEN 1 ELSE 0 END) AS disable_sms_local, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `sinch_status` = '2' THEN 1 ELSE 0 END) AS provisioning_waiting, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `sinch_status` = '3' THEN 1 ELSE 0 END) AS provisioning_inprocess, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `sinch_status` = '4' THEN 1 ELSE 0 END) AS provision_exist, SUM(CASE WHEN `type` = 'NN' AND `disconnect_did_status` = '1' AND `sinch_status` = '5' AND (sinch_retry < '2' OR sinch_retry >= '2' )  THEN 1 ELSE 0 END) AS provision_failed, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '1' THEN 1 ELSE 0 END) AS active_tollfree_did, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '0' THEN 1 ELSE 0 END) AS disconnect_tollfree_did, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '1' AND `sinch_status` = '1' AND `osr_status` = 'register' THEN 1 ELSE 0 END) AS active_sms_tollfree, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '1' AND `sinch_status` = '0' THEN 1 ELSE 0 END) AS disable_sms_tollfree, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '1' AND `sinch_status` = '15' THEN 1 ELSE 0 END) AS sms_capable_tollfree, SUM(CASE WHEN `type` = 'TF' AND `disconnect_did_status` = '1' AND `sinch_status` = '16' THEN 1 ELSE 0 END) AS smsverification_inprocess_tollfree,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '1' THEN 1 ELSE 0 END) AS active_shortcode_did,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '0' THEN 1 ELSE 0 END) AS disconnect_shortcode_did,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '1' AND did_sub_type = '0' THEN 1 ELSE 0 END) AS random_shortcode_did,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '1' AND did_sub_type = '1' THEN 1 ELSE 0 END) AS vanity_shortcode_did,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '1' AND did_sub_type = '2' THEN 1 ELSE 0 END) AS migrated_shortcode_did,SUM(CASE WHEN `type` = 'SC' AND `disconnect_did_status` = '1' AND did_sub_type = '3' THEN 1 ELSE 0 END) AS cust_migrated_shortcode_did FROM `did_buy` WHERE `account_id` = '" + IDAccount + "' AND iduser = '" + idUser + "'";
                                                                                                    obj4.prepare();
                                                                                                    obj4.execute((errrrr, resultdid) => {
                                                                                                        if (errrrr == 1) {
                                                                                                            let obj4 = new RawQuery_1.ModelRawQuery(req, res);
                                                                                                            obj4.qrysql = "SELECT COALESCE(rp.firstname, NULL) AS firstname, COALESCE(rp.lastname, NULL) AS lastname, CASE WHEN u.signup_link_id IS NOT NULL THEN srl.url ELSE NULL END AS signup_url FROM `user` u LEFT JOIN reseller_profile rp ON u.reseller_iduser = rp.iduser LEFT JOIN signup_referral_link srl ON u.signup_link_id = srl.key WHERE u.iduser = '" + idUser + "' AND u.idaccount = '" + IDAccount + "' UNION ALL SELECT NULL AS firstname, NULL AS lastname, NULL AS signup_url WHERE NOT EXISTS (SELECT 1 FROM `user` u WHERE u.iduser = '" + idUser + "' AND u.idaccount = '" + IDAccount + "')";
                                                                                                            obj4.prepare();
                                                                                                            obj4.execute((errorr, resultres) => {
                                                                                                                if (errorr == 1) {
                                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                                    objv.prepare({ data: result, data2: resultcam, data3: resultcon, data4: resulttr, data5: resultsc, data6: resultCar, data7: resultba, data8: resultw, data9: resultsus, data10: resultdid, data11: resultres, message: "Customer Data Fetched Successfully", status: 201 });
                                                                                                                    objv.execute();
                                                                                                                }
                                                                                                                else {
                                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                                    objv.prepare({ message: "Something Went Wrong With Details!", status: 502 });
                                                                                                                    objv.execute();
                                                                                                                }
                                                                                                            });
                                                                                                        }
                                                                                                        else {
                                                                                                            let objv = new RawView_1.RawView(res);
                                                                                                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                                                            objv.execute();
                                                                                                        }
                                                                                                    });
                                                                                                }
                                                                                                else {
                                                                                                    let objv = new RawView_1.RawView(res);
                                                                                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                                                    objv.execute();
                                                                                                }
                                                                                            });
                                                                                        }
                                                                                        else {
                                                                                            let objv = new RawView_1.RawView(res);
                                                                                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                                            objv.execute();
                                                                                        }
                                                                                    });
                                                                                }
                                                                                else {
                                                                                    let objv = new RawView_1.RawView(res);
                                                                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                                    objv.execute();
                                                                                }
                                                                            });
                                                                        }
                                                                        else {
                                                                            let objv = new RawView_1.RawView(res);
                                                                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                            objv.execute();
                                                                        }
                                                                    });
                                                                }
                                                                else {
                                                                    let objv = new RawView_1.RawView(res);
                                                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                                    objv.execute();
                                                                }
                                                            });
                                                        }
                                                        else {
                                                            let objv = new RawView_1.RawView(res);
                                                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                            objv.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                                    objv.execute();
                                                }
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getattachment(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj = new RawQuery_1.ModelRawQuery(req, res);
                obj.qrysql = "SELECT un.id AS user_note_id,un.iduser,un.idaccount,un.description,un.created_at AS user_note_created_at,GROUP_CONCAT(una.filepath SEPARATOR ', ') AS filepaths,GROUP_CONCAT(una.filename SEPARATOR ', ') AS filenames FROM user_notes AS un LEFT JOIN user_notes_attachment AS una ON un.id = una.id WHERE un.iduser = '" + req.query.type + "' GROUP BY un.id, un.iduser, un.idaccount, un.description, un.created_at";
                obj.prepare();
                obj.execute((sError, sData) => {
                    if (sError == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 200,
                            message: "Notes fetched successfully",
                            data: sData
                        });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            status: 502,
                            message: "Something Went Wrong"
                        });
                        objv.execute();
                    }
                });
            }
        });
    }
    SendUserNotes(req, res, next) {
        const session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error === 1) {
                const sssdata = req.body.data;
                let msg = '';
                switch (true) {
                    case !sssdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    const lastInsertion = JSON.parse(sssdata.lastId);
                    const obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "INSERT INTO `user_notes` (`iduser`, `idaccount`,`description`, `created_at`) VALUES ('" + sssdata.iduser + "','" + sssdata.idaccount + "','" + (0, markError_1.parseBody)(sssdata.note).trim() + "', NOW())";
                    obj.prepare();
                    obj.execute((errr, result) => {
                        if (errr === 1) {
                            let insertedId = result.insertId;
                            let updateCount = 0;
                            if (lastInsertion.length === 0) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: 200,
                                    message: "User Notes Saved Successfully",
                                });
                                objv.execute();
                                return;
                            }
                            lastInsertion.forEach((id) => {
                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE `user_notes_attachment` SET `id` = '" + insertedId + "' WHERE `id_una` = '" + id + "'";
                                obj3.prepare();
                                obj3.execute((err, result) => {
                                    updateCount++;
                                    if (updateCount === lastInsertion.length) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            status: 200,
                                            message: "User Notes Saved Successfully",
                                        });
                                        objv.execute();
                                    }
                                    if (err !== 1) {
                                        console.error("Failed to update attachment:", id);
                                    }
                                });
                            });
                        }
                        else {
                            let objv = new _406_1.Res406(res);
                            objv.prepare({ status: 401, message: "Unable To insert User Notes!" });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getRecentAttechment(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let ssdata = req.query;
                let msg = '';
                switch (true) {
                    case !ssdata:
                        msg = 'Request query not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `id_una`,`id`,`unique_upload_id`,`filename`,`filepath`,`created_at` FROM `user_notes_attachment` WHERE `unique_upload_id`='" + ssdata.type + "' ORDER BY `created_at` DESC LIMIT 1";
                    obj.prepare();
                    obj.execute((sError, sData) => {
                        if (sError == 1) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                status: 200,
                                message: "File Upload Successfully",
                                data: sData[0]
                            });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Something wwent wrong while uploading file"
                            });
                            objv.execute();
                        }
                    });
                }
            }
        });
    }
    deleteUserNotes(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let ssdata = req.query;
                let msg = '';
                switch (true) {
                    case !ssdata:
                        msg = 'Request query not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "DELETE FROM `user_notes_attachment` WHERE `id_una`='" + ssdata.id + "'";
                    obj.prepare();
                    obj.execute((err, delRes) => {
                        if (err == 1) {
                            let obj = new RawView_1.RawView(res);
                            obj.prepare({ status: 201, message: " Notes File Deleted Successfully" });
                            obj.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                status: 502,
                                message: "Something wwent wrong while deleting file"
                            });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    saveUserNoteFile(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                let ssdata = req.body;
                let msg = '';
                switch (true) {
                    case !ssdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let file = req.files;
                    let uploadedFile;
                    let fileSize;
                    if (Array.isArray(file)) {
                        uploadedFile = file[0];
                    }
                    else {
                        uploadedFile = file && file['ATTACHMENTS'] ? file['ATTACHMENTS'][0] : undefined;
                    }
                    if (!uploadedFile) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: "No file uploaded", status: 400 });
                        objv.execute();
                        return;
                    }
                    fileSize = uploadedFile.size;
                    const maxIndividualFileSizeBytes = 5 * 1024 * 1024;
                    if (fileSize <= maxIndividualFileSizeBytes) {
                        const isValid = MIME_TYPE_MAPs[uploadedFile.mimetype];
                        if (!isValid) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "File type " + uploadedFile.filename.split('.').pop() + " not accepted", status: 402 });
                            objv.execute();
                            return;
                        }
                        let value = note.Notescsv + uploadedFile.filename;
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "INSERT INTO `user_notes_attachment` (`unique_upload_id`, `filename`, `filepath`, `created_at`) VALUES ('" + ssdata.UNKEY + "', '" + uploadedFile.filename + "', '" + value + "', NOW())";
                        obj.prepare();
                        obj.execute((_err, result) => {
                            if (_err == 1) {
                                let lastid = result.insertId;
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: 'Notes File Uploaded Successfully', data: result, lastId: lastid, status: 200 });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something went wrong!", status: 505 });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ message: 'File size limit exceeded', status: 200 });
                        objv.execute();
                    }
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    phoneVerification(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err === 1) {
                const sdata = req.body.data;
                let msg = '';
                switch (true) {
                    case !sdata:
                        msg = 'Request body not found!';
                        break;
                }
                if (msg) {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 404, message: msg });
                    objv.execute();
                    return;
                }
                else {
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT `country` FROM `billing_address` WHERE `idaccount`='" + sessdata.idaccount + "'";
                    obj.prepare();
                    obj.execute((_err, result) => {
                        if (_err === 1) {
                            let country = result[0].country;
                            if (!['US', 'CA', 'USA', 'UNITED STATES', 'CANADA'].includes(country)) {
                                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj1.nonqrysql = "UPDATE `user` SET `isEmailVerify`= 'true', `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                obj1.prepare();
                                obj1.execute((_error, success) => {
                                    if (_error === 1) {
                                        let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj5.nonqrysql = "UPDATE `session` SET `isMobileVerify`='true' WHERE `iduser`='" + sessdata.iduser + "'";
                                        obj5.prepare();
                                        obj5.execute((_sessErr, sessRes) => {
                                            if (_sessErr === 1) {
                                                let obj6 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                obj6.nonqrysql = "UPDATE `user_profile` SET `phone`='" + sdata.TO + "' WHERE `iduser`='" + sessdata.iduser + "'";
                                                obj6.prepare();
                                                obj6.execute((_sessError, sessData) => {
                                                    if (_sessError === 1) {
                                                        let objup = new RawQuery_1.ModelRawQuery(req, res);
                                                        objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                                        objup.prepare();
                                                        objup.execute((__errorE, emailE) => {
                                                            let emails = emailE[0].email !== '' && emailE[0].email !== undefined && emailE[0].email !== 'undefined' ? emailE[0].email : '';
                                                            if (__errorE === 1) {
                                                                let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                                                                obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`, `newUser_status`, `tz_diff`, `server_time`, `client_time`, `country` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                                                obj7.prepare();
                                                                obj7.execute((sError, sData) => {
                                                                    if (sError === 1) {
                                                                        let tmp = "{\"email\": \"" + emails + "\"}";
                                                                        let emType = JSON.parse(tmp);
                                                                        let temp1 = "{\"country\": \"" + country + "\"}";
                                                                        let temp2 = JSON.parse(temp1);
                                                                        let data1 = Object.assign(sData[0], emType, temp2);
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({
                                                                            message: "Phone Number Updated Successfully!",
                                                                            status: 200,
                                                                            session: data1
                                                                        });
                                                                        objv.execute();
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({
                                                                            message: "Phone verified error with connection!",
                                                                            status: 502
                                                                        });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    message: "Unable to fetch email!",
                                                                    status: 500
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            message: "Phone number update failed!",
                                                            status: 502
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    errMessage: "Mobile verification session update failed!",
                                                    status: 502
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "User update failed!",
                                            status: 502
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                            else {
                                let objup = new RawQuery_1.ModelRawQuery(req, res);
                                objup.qrysql = "SELECT email FROM `user_profile` WHERE `iduser`='" + sessdata.iduser + "'";
                                objup.prepare();
                                objup.execute((__errorE, emailE) => {
                                    let emails = emailE[0].email !== '' && emailE[0].email !== undefined && emailE[0].email !== 'undefined' ? emailE[0].email : '';
                                    if (__errorE === 1) {
                                        let obj7 = new RawQuery_1.ModelRawQuery(req, res);
                                        obj7.qrysql = "SELECT `iduser`, `idaccount`, `username`, `type`, `default`, `idtariff`, `authkey`, `status`, `isEmailVerify`, `isMobileVerify`, `idapi`, `isAddress`, `isPlan`, `isCard`, `newUser_status`, `tz_diff`, `server_time`, `client_time`, `country` FROM `session` WHERE `authkey`='" + sessdata.authkey + "'";
                                        obj7.prepare();
                                        obj7.execute((sError, sData) => {
                                            if (sError === 1) {
                                                let tmp = "{\"email\": \"" + emails + "\"}";
                                                let emType = JSON.parse(tmp);
                                                let temp1 = "{\"country\": \"" + country + "\"}";
                                                let temp2 = JSON.parse(temp1);
                                                let data1 = Object.assign(sData[0], emType, temp2);
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    message: "Your address is updated from admin side we have to refresh your page",
                                                    status: 505,
                                                    session: data1
                                                });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({
                                                    message: "Something went wrong!",
                                                    status: 505
                                                });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({
                                            message: "Something went wrong!",
                                            status: 505
                                        });
                                        objv.execute();
                                    }
                                });
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({
                                message: "Failed to fetch country!",
                                status: 502
                            });
                            objv.execute();
                        }
                    });
                }
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    saveusernotefilesforadmin(req, res, userPayLoad, otherPayLoad, next) {
        let key = 'SN' + Math.random().toString(36).slice(2);
        let file = otherPayLoad.files;
        let uploadedFile;
        let fileSize;
        if (!otherPayLoad.description) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 400, message: "Description is required" });
            objv.execute();
            return;
        }
        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
        obj.nonqrysql = "INSERT INTO `user_notes` (`iduser`,`idaccount`,`description`) VALUES ('" + userPayLoad.iduser + "','" + userPayLoad.idaccount + "','" + (0, markError_1.parseBody)(otherPayLoad.description.trim()) + "')";
        obj.prepare();
        obj.execute((error1, result) => {
            if (error1 == 1) {
                if (Array.isArray(otherPayLoad.files) && otherPayLoad.files.length > 0) {
                    if (Array.isArray(file)) {
                        uploadedFile = file[0];
                    }
                    else {
                        uploadedFile = file && file['ATTACHMENTS'] ? file['ATTACHMENTS'][0] : undefined;
                    }
                    fileSize = uploadedFile.size;
                    const maxIndividualFileSizeBytes = 5 * 1024 * 1024;
                    let value = note.Notescsv + uploadedFile.filename;
                    if (fileSize <= maxIndividualFileSizeBytes) {
                        const isValid = MIME_TYPE_MAPs[uploadedFile.mimetype];
                        if (!isValid) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: "File type " + uploadedFile.filename.split('.').pop() + " not accepted", status: 402 });
                            objv.execute();
                            return;
                        }
                        let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj1.nonqrysql = "INSERT INTO `user_notes_attachment` (`unique_upload_id`, `id`, `filename`, `filepath`) VALUES ('" + key + "', '" + result.insertId + "', '" + uploadedFile.filename + "', '" + value + "')";
                        obj1.prepare();
                        obj1.execute((error2, result1) => {
                            if (error2 == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, message: 'Note saved successfully' });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 203, message: "Description saved successfully but media file not save" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 503, message: "File size limit exceeded. File size should be less than 5MB" });
                        objv.execute();
                    }
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 200, message: 'Note saved successfully' });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 501, message: "Something Went Wrong With User Note!" });
                objv.execute();
            }
        });
    }
    updateserviceforadmin(req, res, userPayLoad, otherPayLoad, next) {
        const data = otherPayLoad.data;
        const statusMap = {};
        data.forEach(item => {
            const key = Object.keys(item)[0];
            const value = item[key];
            statusMap[key] = value ? 1 : 0;
        });
        const featureKeys = Object.keys(statusMap);
        const featureList = featureKeys.map(key => `'${key}'`).join(",");
        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
        obj1.qrysql = `SELECT fs_id, fs_name_code FROM feature_service WHERE fs_name_code IN (${featureList})`;
        obj1.prepare();
        obj1.execute((error1, result1) => {
            if (error1 == 1) {
                const foundKeys = result1.map((row) => row.fs_name_code);
                const notFoundKeys = featureKeys.filter(key => !foundKeys.includes(key));
                if (result1.length > 0) {
                    const enrichedResult = result1.map((row) => {
                        const fsName = row.fs_name_code;
                        const as_status = statusMap[fsName] ?? 0;
                        return { ...row, as_status };
                    });
                    let updated = [];
                    let failed = [...notFoundKeys];
                    let total = enrichedResult.length;
                    let completed = 0;
                    enrichedResult.forEach((item) => {
                        let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj3.nonqrysql = `UPDATE account_service SET as_status = ${item.as_status} WHERE idaccount = '${userPayLoad.idaccount}' AND fs_id = ${item.fs_id}`;
                        obj3.prepare();
                        obj3.execute((error3, result3) => {
                            if (error3 == 1) {
                                updated.push(item.fs_name_code);
                            }
                            else {
                                failed.push(item.fs_name_code);
                            }
                            completed++;
                            if (completed === total) {
                                const objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: failed.length === 0 ? 201 : 203,
                                    message: failed.length === 0 ? "All services updated successfully!" : "Some services failed to update or were not found.",
                                    data: {
                                        updated,
                                        failed
                                    }
                                });
                                objv.execute();
                            }
                        });
                    });
                }
                else {
                    const objv = new RawView_1.RawView(res);
                    objv.prepare({
                        status: 404,
                        message: "No services matched. All provided keys are invalid.",
                        data: {
                            updated: [],
                            failed: featureKeys
                        }
                    });
                    objv.execute();
                }
            }
            else {
                const objv = new RawView_1.RawView(res);
                objv.prepare({ status: 502, message: "Something Went Wrong With Get feature Service Details!" });
                objv.execute();
            }
        });
    }
    userFilterfornonus(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let msg = '';
                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let qdata = req.query.type;
                            var sdata = JSON.parse(qdata);
                            let iQry = "", iQN = 0, cond = "";
                            iQry = "SELECT DISTINCT u.kyc_verify_status,u.volt_status,u.trust_score,u.federal_status,u.card_pdf,a.san,u.reseller_iduser,a.is_billing,u.isEmailVerify,w.balance,w.credit_limit,u.isMobileVerify,u.isAddress, 1 `utype`,u.isPlan, u.iduser, u.idaccount, u.`username` `user_name`, u.type,u.is_deleted,u.deleted_date , u.pending_deleted_date , isCard,newUser_status,ba.title, u.created , up.firstname `first_name`, up.lastname `last_name`, up.email, up.phone `contact_number`,IF(LENGTH(up.profile_pic)=0 || up.profile_pic='undefined' || up.profile_pic IS NULL, CONCAT(CEIL(1+RAND()*7),'.jpg'), up.profile_pic) profile_pic, u.idtariff, u.idservice ,ba.country FROM `user` u LEFT JOIN `account` a ON a.idaccount=u.idaccount LEFT JOIN `user_profile` up ON u.iduser=up.iduser LEFT JOIN `wallet` w ON w.idaccount = u.idaccount LEFT JOIN `billing_address` ba ON ba.idaccount = u.idaccount  WHERE u.type = 2 ";
                            // iQry = "SELECT * FROM `user` \n"
                            if ((Array.isArray(sdata.san) && sdata.san.length > 0 && sdata.san[0].userdata)) {
                                cond += cond += "AND u.idaccount='" + sdata.san[0].userdata + "' ";
                                iQN++;
                            }
                            if (sdata.from_date != '' && sdata.from_date && !sdata.to_date) {
                                cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')>='" + sdata.from_date + "' ";
                                iQN++;
                            }
                            if (sdata.to_date != '' && sdata.to_date && !sdata.from_date) {
                                cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')<='" + sdata.to_date + "' ";
                                iQN++;
                            }
                            if (sdata.from_date && sdata.to_date) {
                                cond += "AND DATE_FORMAT(u.created, '%Y-%m-%d')>='" + sdata.from_date + "' AND DATE_FORMAT(u.created, '%Y-%m-%d')<='" + sdata.to_date + "' ";
                                iQN++;
                            }
                            if (sdata.emailid != '' && sdata.emailid) {
                                cond += "AND up.email ='" + (0, markError_1.parseBody)(sdata.emailid) + "' ";
                                iQN++;
                            }
                            if (sdata.customername != '' && sdata.customername) {
                                cond += "AND CONCAT(up.firstname, ' ', up.lastname) COLLATE utf8mb4_general_ci LIKE '%" + (0, markError_1.parseBody)(sdata.customername) + "%' ";
                                iQN++;
                            }
                            if (iQN > 0) {
                                iQry += cond;
                                iQry = iQry.slice(0, -1) + "\n";
                            }
                            iQry += "ORDER BY `created`;";
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = iQry;
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "User Fetched Successfully.",
                                        status: 201
                                    });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "Something Went Wrong!",
                                        status: 502
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getUserType(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT `id_user_type` , `user_type` , `user_type_name` FROM `sm_user_type`";
                obj1.prepare();
                obj1.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 200, message: "User Type Fetched Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    setUserPassword(req, res, next) {
        let sdata = req.body.data;
        let msg = '';
        switch (true) {
            case !sdata:
                msg = 'Request body not found!';
                break;
        }
        if (msg) {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 404, message: msg });
            objv.execute();
            return;
        }
        else {
            let passwd = (typeof sdata?.password === 'string') ? sdata.password.trim() : '';
            if (passwd && (0, markError_1.checkPassword)(passwd) == '') {
                let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                obj0.qrysql = "SELECT up.firstname, up.lastname, up.email, u.username, u.iduser, u.idaccount FROM `user` u JOIN `user_profile` up ON u.iduser = up.iduser WHERE u.validationKey='" + sdata.key + "'";
                obj0.prepare();
                obj0.execute((error, result) => {
                    if (error == 1) {
                        keycloak.createUser(req, res, result[0].username, passwd, result[0].email, result[0].firstname, result[0].lastname, (errorR, resR) => {
                            if (errorR == 1) {
                                keycloak.sendVerifyEmail(req, res, result[0].username, 'true', '0', (errRess, dataRess) => {
                                    console.log(errRess, dataRess);
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `user` SET `resetPassword`='1' WHERE `validationKey`= '" + sdata.key + "' AND `is_deleted`=0";
                                    obj.prepare();
                                    obj.execute((error, result1) => {
                                        if (error == 1) {
                                            let obj1 = new RawView_1.RawView(res);
                                            obj1.prepare({ message: 'Password set successfully!', status: 201 });
                                            obj1.execute();
                                        }
                                        else {
                                            let obj2 = new RawView_1.RawView(res);
                                            obj2.prepare({ message: 'Something went wrong with setting password!', status: 502 });
                                            obj2.execute();
                                        }
                                    });
                                });
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({
                                    status: 502,
                                    message: "Something went wrong",
                                });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let obj2 = new RawView_1.RawView(res);
                        obj2.prepare({ message: 'Something went wrong with setting password!', status: 502 });
                        obj2.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    message: (0, markError_1.checkPassword)(passwd),
                    status: 501
                });
                objv.execute();
            }
        }
    }
    getPermissions(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                obj1.qrysql = "SELECT rp.`id_role`, rp.`feature_id`, rp.`module_id`, rp.`read`, rp.`write`, rp.`id_user_type`, f.`feature_name`, m.`module_name` FROM `sm_roles_and_permissions` rp JOIN `sm_user_type` ut ON rp.`id_user_type` = ut.`id_user_type` JOIN `sm_features` f ON rp.`feature_id` = f.`feature_id` JOIN `sm_modules` m ON rp.`module_id` = m.`module_id` WHERE ut.`user_type` = " + sessdata.type + "";
                obj1.prepare();
                obj1.execute((error, result) => {
                    if (error == 1) {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 200, message: "User Permissions Fetched Successfully!", data: result });
                        objv.execute();
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({ status: 502, message: "Something went wrong!" });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    getmultiuser(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT up.firstname AS user_firstname, up.lastname AS user_lastname, u.created, up.email, u.username, u.iduser, u.idaccount, u.type, up_main.firstname AS account_firstname, up_main.lastname AS account_lastname, up.phone FROM `user` u LEFT JOIN `user_profile` up ON up.iduser = u.iduser LEFT JOIN `user_profile` up_main ON up_main.iduser = (SELECT up_sub.iduser FROM `user` u_sub JOIN `user_profile` up_sub  ON up_sub.iduser = u_sub.iduser WHERE u_sub.idaccount = u.idaccount ORDER BY u_sub.created ASC LIMIT 1) WHERE u.type IN (22, 201, 202, 203, 231, 232) AND u.is_deleted=0;";
                        obj1.prepare();
                        obj1.execute((error, result) => {
                            if (error == 1) {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 200, message: "Multi-User list Fetched Successfully!", data: result });
                                objv.execute();
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 502, message: "Something went wrong with multiuser!" });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    multiuserfilter(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let msg = '';
                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let data = req.query.type;
                            let sdata = JSON.parse(data);
                            let condition = "";
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            if (sdata.customername) {
                                condition += " AND `u`.`idaccount` = '" + sdata.customername + "'";
                            }
                            if (sdata.email) {
                                condition += ' AND `up`.`email` = "' + (0, markError_1.parseBody)(sdata.email) + '" ';
                            }
                            if (sdata.usertype) {
                                condition += ' AND `u`.`type` = "' + sdata.usertype + '"';
                            }
                            if (sdata.from_date && sdata.to_date) {
                                condition += ' AND `u`.`created` BETWEEN "' + sdata.from_date + ' 00:00:00" AND "' + sdata.to_date + ' 23:59:59"';
                            }
                            if (sdata.additionaluser) {
                                condition += ' AND `u`.`iduser` = "' + sdata.additionaluser + '"';
                            }
                            obj.qrysql = "SELECT up.firstname AS user_firstname, up.lastname AS user_lastname, u.created, up.email, u.username, u.iduser, u.idaccount, u.type, up_main.firstname AS account_firstname, up_main.lastname AS account_lastname, up.phone FROM `user` u LEFT JOIN `user_profile` up ON up.iduser = u.iduser LEFT JOIN `user_profile` up_main ON up_main.iduser = (SELECT up_sub.iduser FROM `user` u_sub JOIN `user_profile` up_sub  ON up_sub.iduser = u_sub.iduser WHERE u_sub.idaccount = u.idaccount ORDER BY u_sub.created ASC LIMIT 1) WHERE u.type IN (22, 201, 202, 203, 231, 232) " + condition + "";
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        data: result,
                                        message: "MultiUser List Fetched Successfully!",
                                        status: 200
                                    });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({
                                        message: "Something Went Wrong With List!",
                                        status: 502,
                                        error: result
                                    });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    fetchFailedBilling(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let msg = '';
                        switch (true) {
                            case !req.query:
                                msg = 'Request query not found!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            let sdata = req.query.type;
                            let data = sdata ? JSON.parse(sdata) : {};
                            let idaccount = data.idaccount !== undefined && data.idaccount ? data.idaccount : '';
                            let from_date = data.from_date !== undefined ? data.from_date : '';
                            let to_date = data.to_date !== undefined ? data.to_date : '';
                            let conditionU = '';
                            let condition = '';
                            if (idaccount) {
                                conditionU += ' AND idaccount="' + idaccount + '"';
                            }
                            if (from_date && to_date) {
                                condition += ' AND `created_at` BETWEEN "' + from_date + ' 00:00:00" AND "' + to_date + '  23:59:59"';
                            }
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT iduser, idaccount, (idaccount + 100000000) AS san, current_month_failure, last_month_failure, last_to_last_month_failure, current_balance, created_at,customer_name FROM user_failed_payment_summary ufp WHERE 1=1" + conditionU + condition;
                            obj.prepare();
                            obj.execute((_error, result) => {
                                if (_error == 1) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, message: "Failed Billing Customer Fetched!", status: 200 });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ data: result, message: "Something Went Wrong With Connection!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare({ status: 401, message: "Unauthorized User!" });
                objv.execute();
            }
        });
    }
    // to get san number list
    getSanNumber(req, res, next) {
        let obj = new RawQuery_1.ModelRawQuery(req, res);
        obj.qrysql = "SELECT u.`type`,a.`san`,u.`iduser`, u.`idaccount`, u.`idtariff`, u.`is_deleted`, c.`firstname` `first_name`, c.`lastname` `last_name` FROM `user` u LEFT JOIN `account` a ON a.`idaccount`=u.`idaccount` LEFT JOIN `user_profile` c ON u.`iduser`=c.`iduser` WHERE u.`is_deleted` = '0' GROUP BY u.`idaccount`";
        obj.prepare();
        obj.execute((error, getUrl) => {
            if (error == 1) {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ data: getUrl, message: "User Detail Fetched Successfully!", status: 200 });
                objv.execute();
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Somthing went wrong with connection!", status: 502 });
                objv.execute();
            }
        });
    }
    updateOrdering(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        // if (sessdata.type == 1) {
                        let sdata = req.body.data;
                        let orderdata = sdata ? sdata.order : null;
                        let msg = '';
                        switch (true) {
                            case !sdata:
                                msg = 'Request body not found!';
                                break;
                            case !orderdata:
                                msg = 'Order data not found!';
                                break;
                            case !Array.isArray(orderdata):
                                msg = 'Invalid order data format!';
                                break;
                        }
                        if (msg) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: msg });
                            objv.execute();
                            return;
                        }
                        else {
                            // let orderdata = sdata.order;
                            let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                            obj.nonqrysql = "DELETE FROM `signup_referral_link_tariff` WHERE link_id='" + sdata.linkid + "'";
                            obj.prepare();
                            obj.execute((error1, result) => {
                                if (error1 == 1) {
                                    let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    let qry0 = "INSERT INTO `signup_referral_link_tariff` (iduser,idaccount,link_id,idtariff,order_by) VALUES ";
                                    for (let i = 0; i < orderdata.length; i++) {
                                        let order = orderdata[i];
                                        let orderby = order.selectedOrderId || 0;
                                        qry0 += "('" + sdata.iduser + "','" + sessdata.idaccount + "','" + sdata.linkid + "','" + orderdata[i].idtariff + "','" + orderby + "'),";
                                    }
                                    qry0 = qry0.slice(0, -1);
                                    obj1.nonqrysql = qry0;
                                    obj1.prepare();
                                    obj1.execute((err, result1) => {
                                        if (err == 1) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 201, message: "Tariff order Updated successfully!" });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ status: 502, message: "Faild to Updated Tariff order successfully!" });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Something Went Wrong!" });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
}
exports.UserManagement = UserManagement;
class TZ {
    /**
     * To create the default TimeZone of user
     */
    CreateTZ(req, res, next, callback) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                let obj1 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj1.nonqrysql = "REPLACE INTO `tbl_timezone_config`(id_timezone, id_user) VALUES(192, " + sessdata.iduser + ");";
                obj1.prepare();
                obj1.execute((error, result) => {
                    if (error == 1) {
                        /**
                         * Update the TimeZone in user's session data
                         */
                        let obj2 = new RawQuery_1.ModelRawQuery(req, res);
                        obj2.qrysql = "SELECT a.utc client_time FROM tbl_timezones a WHERE a.id=192;";
                        obj2.prepare();
                        obj2.execute((error, result) => {
                            if (error == 1 && Array.isArray(result) && result.length > 0) {
                                let obj3 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                obj3.nonqrysql = "UPDATE `session` SET `client_time`='" + result[0].client_time + "' WHERE `authkey`='" + sessdata.authkey + "';";
                                obj3.prepare();
                                obj3.execute((error, result2) => {
                                    sessdata.client_time = result[0].client_time;
                                    server_1.sessiondata.set(sessdata.authkey, sessdata);
                                    callback(error, result);
                                });
                            }
                            else {
                                callback(error, result);
                            }
                        });
                    }
                    else {
                        callback(error, result);
                    }
                });
            }
            else {
                callback(error, { status: 401, message: "Unauthorized User!" });
            }
        });
    }
}
exports.TZ = TZ;
