"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Volt = void 0;
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const Session_1 = require("../lib/model/Session");
// import { AppRoute } from "../lib/AppRoute";
const RawQuery_1 = require("../lib/model/RawQuery");
const setting_config_1 = require("../config/setting.config");
const markError_1 = require("./markError");
const crypto = require('crypto');
let volt = new setting_config_1.VOLT();
class Volt {
    constructor() {
        // super();
    }
    generateKeyPair() {
        const key = crypto.generateKeyPairSync('ec', {
            namedCurve: 'P-256',
        });
        return {
            privateKey: key.privateKey.export({
                format: 'pem',
                type: 'pkcs8',
            }),
            publicKey: key.publicKey.export({
                format: 'pem',
                type: 'spki',
            }),
        };
    }
    signMessage(privateKey, message) {
        const sign = crypto.createSign('SHA256');
        sign.write(message);
        sign.end();
        const signature = sign.sign(privateKey, 'hex');
        return signature;
    }
    logintoVolt(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((err, sessdata) => {
            if (err == 1) {
                let sdata = req.body;
                const volt = new Volt();
                const { privateKey, publicKey } = volt.generateKeyPair();
                const message = 'account_id:' + sdata.idaccount + '|user_id:' + sdata.email + '';
                const hash_message = crypto.createHash('sha256').update(message).digest('hex');
                const signature = volt.signMessage(privateKey, hash_message);
                if (signature) {
                    let sdata = req.body;
                    let obj = new RawQuery_1.ModelRawQuery(req, res);
                    obj.qrysql = "SELECT u.volt_status, up.email, u.is_deleted FROM `user` u INNER JOIN `user_profile` up ON u.iduser = up.iduser WHERE up.email = '" + sdata.email + "' AND u.idaccount = '" + sdata.idaccount + "';";
                    obj.prepare();
                    obj.execute((_errorr, resultt) => {
                        if (_errorr == 1 && resultt.length > 0) {
                            if (resultt[0].is_deleted == '0') {
                                if (resultt[0].volt_status == '1') {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `volt_response` SET `account_id`='" + sdata.idaccount + "',`key`='" + (0, markError_1.parseBody)(privateKey) + "',`signature`='" + (0, markError_1.parseBody)(signature) + "' WHERE `user_id`='" + sdata.email + "'";
                                    obj.prepare();
                                    obj.execute((_error, result) => {
                                        if (_error == 1 && result.affectedRows > 0) {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Volt Login Successfully.", status: 200, result: { result: result, signature: signature } });
                                            objv.execute();
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({ message: "Volt Not Logged In Successfully.", status: 502 });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                    obj.nonqrysql = "UPDATE `user` SET `volt_status`='1' WHERE `iduser`='" + sessdata.iduser + "'";
                                    obj.prepare();
                                    obj.execute((_error, result) => {
                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                        obj.nonqrysql = "INSERT INTO `volt_response` (`account_id`, `user_id`, `status`,`key`,`signature`) VALUES('" + sdata.idaccount + "', '" + sdata.email + "' , '0', '" + (0, markError_1.parseBody)(privateKey) + "', '" + (0, markError_1.parseBody)(signature) + "')";
                                        obj.prepare();
                                        obj.execute((_error, result1) => {
                                            if (_error == 1) {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Volt Login Successfully!", status: 200, result: { result: result, signature: signature } });
                                                objv.execute();
                                            }
                                            else {
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ message: "Volt Not Logged In Successfully!", status: 502 });
                                                objv.execute();
                                            }
                                        });
                                    });
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ status: 404, message: "User does not exist!" });
                                objv.execute();
                            }
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 401, message: "User is not Authorized!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ message: "Volt Not Logged In Successfully!!", status: 502 });
                    objv.execute();
                }
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session Trying to access", status: 401 });
                objv.execute();
            }
        });
    }
    signalmashAuthentication(req, res, next) {
        let token = req.headers.authorization || req.body.authorization || req.query.authorization || req.body.Authorization || req.query.Authorization;
        if (token && token == volt.TOKEN) {
            let sdata = req.body;
            let obj = new RawQuery_1.ModelRawQuery(req, res);
            obj.qrysql = "SELECT u.username, u.iduser, u.volt_status, up.email, u.idaccount FROM `user` u INNER JOIN `user_profile` up ON u.iduser = up.iduser WHERE up.email = '" + sdata.user_id + "' AND u.idaccount = '" + sdata.account_id + "' AND u.`is_deleted`='0';";
            obj.prepare();
            obj.execute((_error, result) => {
                if (_error == 1 && result.length > 0) {
                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                    obj.nonqrysql = "UPDATE `volt_response` SET `account_id`='" + sdata.account_id + "',`volt_org_id`='" + (0, markError_1.setToZero)(sdata.volt_org_id) + "',`webhook_url`='" + (0, markError_1.parseBody)(sdata.webhook_url) + "',`volt_user_id`='" + (0, markError_1.parseBody)(sdata.volt_user_id) + "',`status`='1',`updated_at`= NOW() WHERE `user_id`='" + sdata.user_id + "'";
                    obj.prepare();
                    obj.execute((_error2, result2) => {
                        if (_error2 == 1 && result2.affectedRows > 0) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 200, message: "User is Authorized!", data: sdata });
                            objv.execute();
                        }
                        else {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 404, message: "User is not Authorized!" });
                            objv.execute();
                        }
                    });
                }
                else {
                    let objv = new RawView_1.RawView(res);
                    objv.prepare({ status: 401, message: "User is not Authorized!" });
                    objv.execute();
                }
            });
        }
        else {
            let objv = new RawView_1.RawView(res);
            objv.prepare({ status: 406, message: "Invalid Token to Access" });
            objv.execute();
        }
    }
}
exports.Volt = Volt;
