"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Management = void 0;
const ModelListView_1 = require("./model/ModelListView");
const ModelAdd_1 = require("./model/ModelAdd");
const ModelDelete_1 = require("./model/ModelDelete");
const Add_1 = require("./view/Add");
const Listview_1 = require("./view/Listview");
const ModelUpdate_1 = require("./model/ModelUpdate");
const Update_1 = require("./view/Update");
const Delete_1 = require("./view/Delete");
const _404_1 = require("./view/404");
const RawQuery_1 = require("./model/RawQuery");
const RawView_1 = require("./view/RawView");
const _405_1 = require("./view/405");
const ModelPdfUpload_1 = require("./model/ModelPdfUpload");
const Session_1 = require("./model/Session");
const _403_1 = require("./view/403");
const ModelLogin_1 = require("./model/ModelLogin");
const module_config_1 = require("../config/module.config");
const _406_1 = require("./view/406");
const RawNonQuery_1 = require("./model/RawNonQuery");
const ModelProcedure_1 = require("./model/ModelProcedure");
const KeyCloak_1 = require("../include/KeyCloak");
let keycloak = new KeyCloak_1.Keycloak();
class Management {
    _isfiltered = false;
    _filtered;
    _sessdata;
    req;
    res;
    next;
    constructor(req, res, next) {
        this.req = req;
        this.res = res;
        this.next = next;
    }
    set filtered(val) {
        if (val == undefined)
            return;
        if (val == null)
            return;
        if (val == "")
            return;
        this._isfiltered = true;
        this._filtered = val;
    }
    set sessdata(val) {
        if (val == undefined) {
            let objv = new _406_1.Res406(this.res);
            objv.prepare("Error in session");
            objv.execute();
        }
        if (val == null) {
            let objv = new _406_1.Res406(this.res);
            objv.prepare("Error in session");
            objv.execute();
        }
        if (val == "") {
            let objv = new _406_1.Res406(this.res);
            objv.prepare("Error in session");
            objv.execute();
        }
        this._sessdata = val;
    }
    UploadFiles() {
        if (this._sessdata.error > 0) {
            let objv = new _406_1.Res406(this.res);
            objv.prepare("Error in session");
            objv.execute();
        }
        let objfile = new ModelPdfUpload_1.ModelPdfUpload(this.req, this.res);
        objfile.fileUpload();
        if (objfile.prepare()) {
            objfile.execute((error, result) => {
                let objv = new Add_1.AddData(this.res);
                objv.prepare(result);
                objv.execute();
            });
        }
    }
    RawQryList() {
        if (this._isfiltered) {
            let obj = new RawQuery_1.ModelRawQuery(this.req, this.res);
            console.log("Into RawQry List function : " + this.req.url);
            obj.qrysql = this._filtered.sqlqry;
            if (this._filtered.session != undefined) {
                let tmp = {};
                for (let index in this._filtered.session) {
                    tmp[index] = this._sessdata.session[this._filtered.session[index]];
                }
                /* Object.entries(this._filtered.session).forEach(
                  ([key, value]) => {
                    tmp[key]=this._sessdata.session[value.toString()];
                }); */
                if (obj.isfilter) {
                    obj.filter = Object.assign(obj.filter, tmp);
                }
                else
                    obj.filter = tmp;
                console.log(obj.filter);
            }
            if (this._filtered.group != undefined)
                obj.group = this._filtered.group;
            if (this._filtered.order != undefined)
                obj.order = this._filtered.order;
            if (this._filtered.limit != undefined)
                obj.limit = this._filtered.limit;
            if (this._filtered.where != undefined)
                obj.where = this._filtered.where;
            if (obj.prepare()) {
                obj.execute((error, result) => {
                    console.log("Get RawQry List View Has completed at Management");
                    let objv = new RawView_1.RawView(this.res);
                    objv.prepare(result);
                    objv.execute();
                });
            }
            else {
                let objv = new _405_1.Res405(this.res);
                objv.prepare({ error: "Few parameter are missing in request" });
                objv.execute();
            }
        }
        else {
            let objv = new _404_1.Res404(this.res);
            objv.prepare({ error: "From raw-query running management" });
            objv.execute();
        }
    }
    Delete() {
        if (this._isfiltered) {
            let obj = new ModelDelete_1.ModelDelete(this.req, this.res);
            console.log(this.req.body);
            obj.table = this._filtered.table;
            if (this._filtered.filter != undefined)
                obj.filter = this._filtered.filter;
            if (this._filtered.session != undefined) {
                let tmp = {};
                for (let index in this._filtered.session) {
                    tmp[index] = this._sessdata.session[this._filtered.session[index]];
                }
                if (obj.isfilter) {
                    obj.filter = Object.assign(obj.filter, tmp);
                }
                else
                    obj.filter = tmp;
                console.log(obj.filter);
            }
            if (obj.prepare()) {
                obj.execute((error, result) => {
                    let objv = new Delete_1.DeleteData(this.res);
                    objv.prepare(result);
                    objv.execute();
                });
            }
            else {
                let objv = new _405_1.Res405(this.res);
                objv.prepare({ error: "Few parameter are missing in request" });
                objv.execute();
            }
        }
        else {
            let objv = new _404_1.Res404(this.res);
            objv.prepare({ error: "From Delete running management" });
            objv.execute();
        }
    }
    Update() {
        if (this._isfiltered) {
            let obj = new ModelUpdate_1.ModelUpdate(this.req, this.res);
            console.log(this.req.body.data);
            obj.table = this._filtered.table;
            if (this._filtered.filter != undefined)
                obj.filter = this._filtered.filter;
            if (this._filtered.session != undefined) {
                let tmp = {};
                for (let index in this._filtered.session) {
                    tmp[index] = this._sessdata.session[this._filtered.session[index]];
                }
                if (obj.isfilter) {
                    obj.filter = Object.assign(obj.filter, tmp);
                }
                else
                    obj.filter = tmp;
                console.log(obj.filter);
            }
            if (obj.prepare(this._filtered.fields)) {
                obj.execute((error, result) => {
                    let objv = new Update_1.UpdateData(this.res);
                    objv.prepare(result);
                    objv.execute();
                });
            }
            else {
                let objv = new _405_1.Res405(this.res);
                objv.prepare({ error: "Few parameter are missing in request" });
                objv.execute();
            }
        }
        else {
            let objv = new _404_1.Res404(this.res);
            objv.prepare({ error: "From Update running management" });
            objv.execute();
        }
    }
    Save() {
        if (this._isfiltered) {
            let obj = new ModelAdd_1.ModelAdd(this.req, this.res);
            obj.table = this._filtered.table;
            if (this._filtered.session != undefined) {
                let tmp = {};
                for (let index in this._filtered.session) {
                    tmp[index] = this._sessdata.session[this._filtered.session[index]];
                }
                obj.data = tmp;
            }
            if (obj.prepare(this._filtered.fields)) {
                obj.execute((error, result) => {
                    let objv = new Add_1.AddData(this.res);
                    objv.prepare(result);
                    objv.execute();
                });
            }
            else {
                let objv = new _405_1.Res405(this.res);
                objv.prepare({ error: "Few parameter are missing in request" });
                objv.execute();
            }
        }
        else {
            let objv = new _404_1.Res404(this.res);
            objv.prepare({ error: "From Save running management" });
            objv.execute();
        }
    }
    ListView() {
        if (this._isfiltered) {
            let obj = new ModelListView_1.ModelListView(this.req, this.res);
            console.log("Into Module List function : " + this.req.url);
            obj.table = this._filtered.table;
            obj.data = this._filtered.fields;
            if (this._filtered.filter != undefined)
                obj.filter = this._filtered.filter;
            if (this._filtered.session != undefined) {
                let tmp = {};
                for (let index in this._filtered.session) {
                    tmp[index] = this._sessdata.session[this._filtered.session[index]];
                }
                if (obj.isfilter) {
                    obj.filter = Object.assign(obj.filter, tmp);
                }
                else
                    obj.filter = tmp;
                console.log("Current filter set " + obj.filter);
            }
            if (this._filtered.group != undefined)
                obj.group = this._filtered.group;
            if (this._filtered.order != undefined)
                obj.order = this._filtered.order;
            if (this._filtered.limit != undefined)
                obj.limit = this._filtered.limit;
            if (obj.prepare()) {
                obj.execute((error, result) => {
                    console.log("Get List View Has completed at Management");
                    let objv = new Listview_1.ListData(this.res);
                    objv.prepare({ data: result, message: "List is Loaded successfully" });
                    objv.execute();
                });
            }
            else {
                console.log("Error in Get List View at Management");
                let objv = new _405_1.Res405(this.res);
                objv.prepare({ error: "Few parameter are missing in request" });
                objv.execute();
            }
        }
        else {
            console.log("Error in listview");
            let objv = new _404_1.Res404(this.res);
            objv.prepare({ error: "From ListView running management" });
            objv.execute();
        }
    }
    OptionList() {
        if (this._isfiltered) {
            let obj = new RawQuery_1.ModelRawQuery(this.req, this.res);
            console.log("Into Option List function : " + this.req.url);
            obj.qrysql = "SELECT `" + this._filtered.label + "` `label`, `" + this._filtered.value + "` `value` FROM `" + this._filtered.table + "`";
            if (this._filtered.filter != undefined)
                obj.filter = this._filtered.filter;
            if (this._filtered.session != undefined) {
                let tmp = {};
                for (let index in this._filtered.session) {
                    tmp[index] = this._sessdata.session[this._filtered.session[index]];
                }
                if (obj.isfilter) {
                    obj.filter = Object.assign(obj.filter, tmp);
                }
                else
                    obj.filter = tmp;
                console.log(obj.filter);
                obj.qrysql = obj.qrysql + " WHERE ";
            }
            if (obj.prepare()) {
                obj.execute((error, result) => {
                    console.log("Get Option Has completed at Management");
                    let objv = new Listview_1.ListData(this.res);
                    objv.prepare(result);
                    objv.execute();
                });
            }
            else {
                let objv = new _405_1.Res405(this.res);
                objv.prepare({ error: "Few parameter are missing option request" });
                objv.execute();
            }
        }
        else {
            let objv = new _404_1.Res404(this.res);
            objv.prepare({ error: "From OptionList running management" });
            objv.execute();
        }
    }
    NotFound() {
        console.log(this.req.url);
        let objv = new _404_1.Res404(this.res);
        objv.prepare({ error: "From wrong request running management" });
        objv.execute();
    }
    UserLogin() {
        let obj = new ModelLogin_1.ModelLogin(this.req, this.res);
        if (obj.prepare()) {
            obj.execute((error, result) => {
                if (error == 2) {
                    let session = new Session_1.SessionManagment(this.req, this.res, this.next);
                    session.SetSession(result, (error, sessdata) => {
                        let objv = new RawView_1.RawView(this.res);
                        objv.prepare(result);
                        objv.execute();
                    });
                }
                else {
                    let objv = new _403_1.Res403(this.res);
                    objv.prepare({ error: "Invalid Username and password to set proper session" });
                    objv.execute();
                }
            });
        }
    }
    UserLogout() {
        let session = new Session_1.SessionManagment(this.req, this.res, this.next);
        session.GetSession((error, sessdata) => {
            let obj = new RawNonQuery_1.ModelRawNonQuery(this.req, this.res);
            obj.nonqrysql = "UPDATE `user_login_history` SET `logout_time`=NOW(), `logout_type`='logout' WHERE `token`='" + sessdata.authkey + "'";
            obj.prepare();
            obj.execute((error, result) => {
                keycloak.logOut(this.req, this.res, sessdata, (errorR, resR) => {
                    // console.log("Keycloak Logout response:", resR);
                    let key = this.req.headers.hasOwnProperty("authorization");
                    session.DeleteSession((error, data) => {
                        let objv = new RawView_1.RawView(this.res);
                        objv.prepare({ error: "User is logout successfully" });
                        objv.execute();
                    });
                });
            });
        });
    }
    ResetPasswprd() {
        let obj = new RawNonQuery_1.ModelRawNonQuery(this.req, this.res);
        let config = new module_config_1.modLogin();
        obj.nonqrysql = "UPDATE `" + config.data.table + "` SET `password`='" + this.req.body.newpassword + "' WHERE id=" + this.sessdata.session.id + " AND `password`='" + this.req.body.oldpassword + "'";
        if (obj.prepare()) {
            obj.execute((error, data) => {
                if (error == 1) {
                    let objv = new RawView_1.RawView(this.res);
                    objv.prepare(data);
                    objv.execute();
                }
            });
        }
    }
    RawProcedureList() {
        if (this._isfiltered) {
            let obj = new ModelProcedure_1.ModelProcedure(this.req, this.res);
            console.log("Into Module List function : " + this.req.url);
            obj.name = this._filtered.name;
            obj.data = this._filtered.fields;
            if (obj.prepare(this._filtered.fields)) {
                obj.execute((error, result) => {
                    console.log("Get List View Has completed at Management");
                    let objv = new Listview_1.ListData(this.res);
                    objv.prepare({ data: result, message: "List is Loaded successfully" });
                    objv.execute();
                });
            }
            else {
                console.log("Error in Get List View at Management");
                let objv = new _405_1.Res405(this.res);
                objv.prepare({ error: "Few parameter are missing in request" });
                objv.execute();
            }
        }
        else {
            console.log("Error in listview");
            let objv = new _404_1.Res404(this.res);
            objv.prepare({ error: "From ListView running management" });
            objv.execute();
        }
    }
}
exports.Management = Management;
