"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminApis = void 0;
const RawView_1 = require("../lib/view/RawView");
const Session_1 = require("../lib/model/Session");
const RawQuery_1 = require("../lib/model/RawQuery");
const numberApi_1 = require("./numberApi");
const markError_1 = __importStar(require("./markError"));
const usermanagement_class_1 = require("./usermanagement.class");
const APIBase_1 = require("./APIBase");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
let validuser = new APIBase_1.APIBase();
class AdminApis {
    constructor() {
        // super();
    }
    /******************** *
    * Number APIs Started *
    * =================== *
    ********************* */
    EnableSMSAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        const sdata = req.body;
                        let userPayLoad1 = {
                            iduser: sdata.iduser,
                            idaccount: sdata.idaccount
                        };
                        let userPayLoad = (0, markError_1.checkUserPayload)(userPayLoad1);
                        let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                        obj1.qrysql = "SELECT `idtariff` FROM `user` WHERE `idaccount`= '" + sdata.idaccount + "' LIMIT 1";
                        obj1.prepare();
                        obj1.execute((proration_error, tariffdata) => {
                            if (proration_error == 1) {
                                let otherPayLoad = {
                                    idtariff: tariffdata[0].idtariff
                                };
                                let numberapi = new numberApi_1.Number();
                                numberapi.EnableSMS(req, res, userPayLoad, otherPayLoad, next);
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    DisableSMSAdmin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((_error, sessdata) => {
            if (_error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        const sdata = req.query;
                        let userPayLoad1 = {
                            iduser: sdata.iduser,
                            idaccount: sdata.idaccount
                        };
                        let userPayLoad = (0, markError_1.checkUserPayload)(userPayLoad1);
                        let numberapi = new numberApi_1.Number();
                        numberapi.DisableSMS(req, res, userPayLoad, next);
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /******************** *
     * Ob Sip Start       *
     * ================== *
     ******************** */
    GetBrandedCallerDID(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query.type;
                        let data = JSON.parse(sdata);
                        let userPayLoad1 = {
                            iduser: data.iduser,
                            idaccount: data.idaccount
                        };
                        let otherPayLoad = {
                            type: data.type,
                        };
                        let userPayLoad = (0, markError_1.checkUserPayload)(userPayLoad1);
                        let UM = new usermanagement_class_1.UserManagement();
                        UM.Getbrandcallerdid(req, res, userPayLoad, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    SaveBcidEid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body.data;
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad = {
                            eid: sdata.eid,
                            eidName: sdata.eidName,
                        };
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);
                        let UM = new usermanagement_class_1.UserManagement();
                        UM.addBcidEid(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    UpdateBcidEid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body.data;
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad = {
                            eid: sdata.data.eid,
                            eidName: sdata.data.eidName,
                            idbcideid: sdata.id
                        };
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);
                        let UM = new usermanagement_class_1.UserManagement();
                        UM.editBcidEid(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    deleteBcidEidById(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query;
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad = {
                            idbcideid: sdata.ID
                        };
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);
                        let UM = new usermanagement_class_1.UserManagement();
                        UM.deleteBcidEid(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getBcidEidDetail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        let data = (sdata.data == 'main' || sdata.data == '') ? '' : JSON.parse(sdata.data);
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad = {
                            fromDate: data.from_date ?? '',
                            toDate: data.to_date ?? '',
                            eidName: data.EIDName ?? '',
                            eiD: data.bcidEid ?? ''
                        };
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);
                        let UM = new usermanagement_class_1.UserManagement();
                        UM.getBcidEid(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    getBcidDidDetail(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query;
                        let data = JSON.parse(sdata.type);
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad = {
                            fromDate: data.from_date,
                            toDate: data.to_date,
                            sipID: data.sipname,
                            bcidEID: data.bcidEid,
                            accountID: data.idaccount,
                            did: data.did
                        };
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);
                        let UM = new usermanagement_class_1.UserManagement();
                        UM.getBcidDid(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    SaveBcidDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = [];
                        sdata = req.body.data;
                        let sipIP = sdata.sipName?.[0]?.idsipts;
                        const rawUserdata = sdata?.san?.[0]?.userdata;
                        const iduser = (typeof rawUserdata === 'string' && rawUserdata.includes('-'))
                            ? rawUserdata.split('-', 1)[0]
                            : '';
                        const idaccount = (typeof rawUserdata === 'string' && rawUserdata.includes('-'))
                            ? rawUserdata.split('-', 2)[1] ?? ''
                            : '';
                        const didList = Array.isArray(sdata?.did)
                            ? sdata.did.map((d) => d?.did)
                            : [];
                        let userPayLoad1 = {
                            iduser: iduser,
                            idaccount: idaccount
                        };
                        let otherPayLoad = {
                            idsipts: sipIP,
                            idbcideid: sdata.bcidEid?.[0]?.idbcideid,
                            did: didList
                        };
                        let userPayLoad = (0, markError_1.checkUserPayload)(userPayLoad1);
                        let UM = new usermanagement_class_1.UserManagement();
                        UM.addBcidDID(req, res, userPayLoad, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    UpdateBcidDid(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body.data;
                        const didList = Array.isArray(sdata?.Number)
                            ? sdata.Number.map((d) => d?.did)
                            : [];
                        let userPayLoad1 = {
                            iduser: sdata.data.iduser,
                            idaccount: sdata.data.san
                        };
                        let otherPayLoad = {
                            idsipts: sdata.data.sipName,
                            idbcideid: sdata.data.bcidEid,
                            did: didList,
                            idbcidoverride: sdata.id
                        };
                        let userPayLoad = (0, markError_1.checkUserPayload)(userPayLoad1);
                        let UM = new usermanagement_class_1.UserManagement();
                        UM.editBcidDID(req, res, userPayLoad, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    deleteBcidDidById(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query;
                        // let userPayLoad1: any = {
                        //     iduser: data.iduser,
                        //     idaccount: data.idaccount
                        // }
                        let otherPayLoad = {
                            idbcidoverride: sdata.ID
                        };
                        // let userPayLoad: any = checkUserPayload(userPayLoad1);
                        let UM = new usermanagement_class_1.UserManagement();
                        UM.deleteBcidDID(req, res, otherPayLoad, next);
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /******************** *
    * Number APIs End     *
    * =================== *
    ********************* */
    /******************** **
    * Hidden Endpoint Start*
    * =================== **
    ********************* */
    add_user_note(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        let data = sdata;
                        if (!sdata.SAN) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 400, message: "SAN is required" });
                            objv.execute();
                            return;
                        }
                        let idacc = data.SAN - 100000000;
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `iduser` FROM `user` WHERE `idaccount`='" + idacc + "' AND `type`='2'";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1 && result.length > 0) {
                                let userPayLoad1 = {
                                    iduser: result[0].iduser,
                                    idaccount: idacc
                                };
                                let otherPayLoad = {
                                    description: data.note_description,
                                    files: req.files
                                };
                                let userPayLoad = (0, markError_1.checkUserPayload)(userPayLoad1);
                                let UM = new usermanagement_class_1.UserManagement();
                                UM.saveusernotefilesforadmin(req, res, userPayLoad, otherPayLoad, next);
                            }
                            else {
                                let objvs = new RawView_1.RawView(res);
                                objvs.prepare({ status: 504, message: "Something went wrong with get user detail!" });
                                objvs.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    service_suspend_status(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body;
                        if (!sdata.SAN) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 400, message: "SAN is required" });
                            objv.execute();
                            return;
                        }
                        let idacc = sdata.SAN - 100000000;
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `iduser` FROM `user` WHERE `idaccount`='" + idacc + "' AND `type`='2'";
                        obj.prepare();
                        obj.execute((error, result) => {
                            if (error == 1 && result.length > 0) {
                                let userPayLoad1 = {
                                    iduser: result[0].iduser,
                                    idaccount: idacc
                                };
                                let otherPayLoad = {
                                    data: sdata.data
                                };
                                let userPayLoad = (0, markError_1.checkUserPayload)(userPayLoad1);
                                let UM = new usermanagement_class_1.UserManagement();
                                UM.updateserviceforadmin(req, res, userPayLoad, otherPayLoad, next);
                            }
                            else {
                                let objvs = new RawView_1.RawView(res);
                                objvs.prepare({ status: 504, message: "Something Went Wrong wWth Get User Detail!" });
                                objvs.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        // objvs.prepare({ message: "You cannot use this service. Please contact administration!", status: 504 });
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
    /******************** **
    * Hidden Endpoint End  *
    * =================== **
    ********************* */
    updatesuspendedlogin(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid_1(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.body.data;
                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                        obj.nonqrysql = "UPDATE `failed_login_account_suspension` SET `failed_Attempt`='0',`suspension_status` = '0'  WHERE `username`='" + (0, markError_1.default)(sdata.username) + "'";
                        obj.prepare();
                        obj.execute((error1, result) => {
                            if (error1 == 1) {
                                let obj1 = new RawView_1.RawView(res);
                                obj1.prepare({ status: 201, message: 'Account re-activated successfully!' });
                                obj1.execute();
                            }
                            else {
                                let obj2 = new RawView_1.RawView(res);
                                obj2.prepare({ status: 502, message: 'Something went wrong with re-activate account!' });
                                obj2.execute();
                            }
                        });
                    }
                    else {
                        let objvs = new RawView_1.RawView(res);
                        objvs.prepare(dt);
                        objvs.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ status: 401, message: "Unauthorized User" });
                objv.execute();
            }
        });
    }
}
exports.AdminApis = AdminApis;
