"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Keycloak = void 0;
const axios_1 = require("./axios");
const setting_config_1 = require("../config/setting.config");
const server_1 = require("../server");
const RawView_1 = require("../lib/view/RawView");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const markError_1 = require("./markError");
let credentials = new setting_config_1.KeyclockCredintials();
class Keycloak {
    constructor() {
    }
    /* public VerifyTokenValidity(req: Request, res: Response, sessdata: any, callback: (err: any, data: any) => void) {
        const tokenOptions: any = {
            method: 'POST',
            url: credentials.keycloakBaseUrl + '/realms/master/protocol/openid-connect/token/introspect',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            form: {
                token: sessdata.authkey,
                client_id: credentials.client_id,
                client_secret: credentials.client_secret
            }
        };
        request(tokenOptions, (err: any, result: any) => {
            if (!err && result && result.body) {
                try {
                    let tokenvalidity = JSON.parse(result.body);
                    if (tokenvalidity.active == true || tokenvalidity.active == 'true') {
                        callback(1, { status: 200, message: 'Token is valid', data: tokenvalidity });
                    } else {
                        callback(2, { status: 403, message: 'Token is invalid' });
                    }
                } catch (parseError) {
                    console.error("VerifyTokenValidity - Error parsing response:", parseError);
                    callback(0, { status: 404, message: 'Something went wrong with Token is checking'});
                }
            } else {
                // Error occurred or result is undefined
                // Handle network errors (ECONNRESET, ETIMEDOUT, etc.) gracefully
                const errorMessage = err?.message || err?.code || 'Unknown error';
                const errorCode = err?.code || 'UNKNOWN';
                console.error("VerifyTokenValidity - Request error:", errorCode, errorMessage);
                
                // For network errors, treat as connection failure (errorR = 0)
                // This allows the checkToken to continue checking other sessions
                callback(0, { status: 404, message: 'Something went wrong with Token is checking', error: errorCode });
            }
        });
    }
     */
    VerifyTokenValidity(req, res, sessdata, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        const tokenOptions = {
            method: 'POST',
            url: credentials.keycloakBaseUrl + '/realms/' + credentials.adminRealm + '/protocol/openid-connect/token/introspect',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                'X-Forwarded-For': sysInfo.ipAddress[0],
                'User-Agent': sysInfo.browserName
            },
            form: {
                token: sessdata.authkey,
                client_id: credentials.client_id,
                client_secret: credentials.client_secret
            }
        };
        // console.log("tokenOptions :::::::: ", tokenOptions);
        (0, axios_1.request)(tokenOptions, (err, result) => {
            if (!err) {
                let tokenvalidity = JSON.parse(result.body);
                console.log("tokenvalidity :::::::: ", tokenvalidity);
                if (tokenvalidity.active == true || tokenvalidity.active == 'true') {
                    console.log("Token is valid :::::::: ", tokenvalidity);
                    callback(1, { status: 200, message: 'Token is valid', data: tokenvalidity });
                }
                else {
                    callback(2, { status: 403, message: 'Token is invalid' });
                }
            }
            else {
                callback(0, { status: 404, message: 'Something went wrong with Token is checking' });
            }
        });
    }
    // Async version of VerifyTokenValidity
    async VerifyTokenValidityAsync(req, res, sessdata) {
        return new Promise((resolve) => {
            this.VerifyTokenValidity(req, res, sessdata, (errorR, resR) => {
                resolve({ errorR, resR });
            });
        });
    }
    async checkToken(req, res, next) {
        const keycloak = new Keycloak();
        const panelSessions = [];
        for (const [key, value] of server_1.sessiondata.entries()) {
            if (value.sessionType == "PANEL") {
                // console.log("key :: ", key);
                panelSessions.push({ key, value });
            }
        }
        if (panelSessions.length === 0) {
            console.log("CheckToken - No PANEL sessions found");
            let objv = new RawView_1.RawView(res);
            objv.prepare({ message: "No PANEL sessions found", status: 404 });
            objv.execute();
            return;
        }
        console.log("CheckToken - Processing", panelSessions.length, "PANEL sessions");
        const invalidSessionKeys = [];
        const BATCH_SIZE = 100; // Delete from DB after every 100 invalid sessions
        for (const { key, value } of panelSessions) {
            try {
                console.log("CheckToken - Checking PANEL session:", key);
                const { errorR, resR } = await keycloak.VerifyTokenValidityAsync(req, res, value);
                console.log("CheckToken - Verification result for key:", key, "errorR:", errorR);
                if (errorR == 1) {
                    console.log("CheckToken - Valid session found:", key);
                    // Delete any remaining invalid sessions before returning
                    if (invalidSessionKeys.length > 0) {
                        console.log("CheckToken - Deleting", invalidSessionKeys.length, "remaining invalid sessions before returning");
                        await keycloak.deleteInvalidSessionsFromDB(req, res, invalidSessionKeys);
                        invalidSessionKeys.length = 0; // Clear the array
                    }
                    next();
                    return;
                }
                else if (errorR == 2) {
                    console.log("CheckToken - Invalid session detected (errorR == 2), removing:", key);
                    const keyExists = server_1.sessiondata.has(key);
                    if (keyExists) {
                        server_1.sessiondata.remove(key);
                        console.log("CheckToken - ✓ Session successfully removed from hashmap:", key);
                        if (server_1.sessiondata.has(key)) {
                            console.error("CheckToken - ✗ ERROR: Session still exists in hashmap after deletion:", key);
                        }
                        else {
                            console.log("CheckToken - ✓ Verified: Session no longer in hashmap");
                        }
                    }
                    else {
                        console.log("CheckToken - Session was not in hashmap (may have been already removed):", key);
                    }
                    invalidSessionKeys.push(key);
                    // Delete from DB in batches of 100
                    if (invalidSessionKeys.length >= BATCH_SIZE) {
                        console.log("CheckToken - Batch limit reached. Deleting", BATCH_SIZE, "invalid sessions from database");
                        const batchToDelete = invalidSessionKeys.splice(0, BATCH_SIZE);
                        await keycloak.deleteInvalidSessionsFromDB(req, res, batchToDelete);
                    }
                }
                else {
                    console.log("CheckToken - Other error (errorR == 0 or other), key:", key, "errorR:", errorR);
                }
            }
            catch (error) {
                console.error("CheckToken - Error verifying token for key:", key, error);
            }
        }
        // Delete any remaining invalid sessions at the end
        if (invalidSessionKeys.length > 0) {
            console.log("CheckToken - All sessions checked. Deleting", invalidSessionKeys.length, "remaining invalid sessions from database");
            await keycloak.deleteInvalidSessionsFromDB(req, res, invalidSessionKeys);
        }
        console.log("CheckToken - No valid sessions found after checking all");
        let objv = new RawView_1.RawView(res);
        objv.prepare({ status: 200, message: "Removing Invalid tokens from database" });
        objv.execute();
    }
    async deleteInvalidSessionsFromDB(req, res, keys) {
        if (keys.length === 0)
            return;
        const escapedKeys = keys.map(key => "'" + key.replace(/'/g, "''") + "'").join(',');
        console.log("escapedKeys :: ", escapedKeys);
        const deleteQuery = `DELETE FROM \`session\` WHERE \`authKey\` IN (${escapedKeys})`;
        console.log("CheckToken - Deleting invalid sessions from database:", keys.length, "sessions");
        return new Promise((resolve) => {
            try {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                obj.nonqrysql = deleteQuery;
                obj.prepare();
                obj.execute((err, result) => {
                    if (err == 1) {
                        console.log("CheckToken - Successfully deleted", keys.length, "invalid sessions from database");
                    }
                    else {
                        console.error("CheckToken - Error deleting invalid sessions from database:", err);
                    }
                    resolve();
                });
            }
            catch (dbError) {
                console.error("CheckToken - Database connection error while deleting sessions:", dbError.message || dbError);
                resolve();
            }
        });
    }
    logOut(req, res, sessData, callback) {
        console.log("Logout request data:", sessData);
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        const resetUrl = credentials.keycloakBaseUrl + '/realms/' + credentials.adminRealm + '/protocol/openid-connect/logout';
        const resetOptions = {
            method: 'POST',
            url: resetUrl,
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                'X-Forwarded-For': sysInfo.ipAddress[0],
                'User-Agent': sysInfo.browserName
            },
            form: {
                client_id: credentials.client_id,
                client_secret: credentials.client_secret,
                refresh_token: sessData.refresh_token
            }
        };
        console.log("Logout request data:", resetOptions);
        (0, axios_1.request)(resetOptions, (err, resp, body) => {
            // console.log("Logout response:", resp.statusCode, body);
            if (!err && resp && (resp.statusCode === 204 || resp.statusCode === 200)) {
                callback(1, { status: 200, message: 'Logout successful' });
            }
            else {
                callback(0, { status: 403, message: 'Logout failed' });
            }
        });
    }
    loginKeyClock(req, res, username, password, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        console.log("loginKeyClock - password:", password);
        if (!(0, markError_1.isMissing)(password)) {
            const tokenOptions = {
                method: 'POST',
                url: credentials.keycloakBaseUrl + '/realms/' + credentials.adminRealm + '/protocol/openid-connect/token',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'X-Forwarded-For': sysInfo.ipAddress[0],
                    'User-Agent': sysInfo.browserName
                },
                form: {
                    grant_type: credentials.grant_type,
                    client_id: credentials.client_id,
                    username,
                    password,
                    client_secret: credentials.client_secret
                }
            };
            console.log("loginKeyClock - tokenOptions:", tokenOptions);
            (0, axios_1.request)(tokenOptions, (err, result) => {
                console.log("loginKeyClock - result ::", result);
                if (!err) {
                    if (result.body && result.statusCode == 200) {
                        callback(1, { status: 200, message: 'Login successful', data: result });
                    }
                    else {
                        callback(0, { status: 404, message: 'Username or Password is incorrect please try again!' });
                    }
                }
                else {
                    callback(0, { status: 404, message: 'Something went wrong with Login' });
                }
            });
        }
        else {
            // Managing email verification link
            callback(1, { status: 200, message: 'Password is not required', data: {} });
        }
    }
    loginKeyClocRealm(req, res, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        const Options = {
            method: 'POST',
            url: credentials.keycloakBaseUrl + '/realms/' + credentials.adminRealm + '/protocol/openid-connect/token',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                'X-Forwarded-For': sysInfo.ipAddress[0],
                'User-Agent': sysInfo.browserName
            },
            form: {
                grant_type: 'password',
                client_id: 'admin-cli',
                username: credentials.adminUsername,
                password: credentials.adminPassword,
                client_secret: credentials.client_secret
            }
        };
        console.log("loginKeyClocRealm - Options:", Options);
        (0, axios_1.request)(Options, (err, result) => {
            console.log("loginKeyClocRealm - result:", result);
            if (!err) {
                callback(1, { status: 200, message: 'Logged In successfully', data: result });
            }
            else {
                callback(0, { status: 404, message: 'Something went wrong with Logged In' });
            }
        });
    }
    createUserKeyClock(req, res, username, adminToken, email, firstName, lastName, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        const createUrl = credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users';
        const createOptions = {
            method: 'POST',
            url: createUrl,
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer ' + adminToken,
                'X-Forwarded-For': sysInfo.ipAddress[0],
                'User-Agent': sysInfo.browserName
            },
            body: JSON.stringify({
                username: username,
                enabled: true,
                email: email,
                firstName: firstName,
                lastName: lastName
            })
        };
        console.log("createUserKeyClock - createOptions:", createOptions);
        (0, axios_1.request)(createOptions, (err, resp, body) => {
            console.log("createUserKeyClock - resp:", resp);
            // if (err) {
            //     callback(0, { status: 500, message: 'Something went wrong with Create User' });
            //     return;
            // }
            if (err || resp?.statusCode >= 400) {
                const errorResponse = this.keycloakErrorHandler(resp);
                callback(0, errorResponse);
                return;
            }
            let userId;
            if (resp && resp.statusCode == 201) {
                const location = resp.headers['location'];
                const parts = location ? location.split('/') : [];
                userId = parts.length ? parts[parts.length - 1] : null;
                callback(1, { status: 200, message: 'User created successfully', data: userId });
            }
            else if (resp && resp.statusCode == 409) {
                callback(0, { status: 409, message: 'User already exists', data: userId });
            }
            else {
                callback(0, { status: resp ? resp.statusCode : 500, message: 'Something went wrong with Create User' });
            }
        });
    }
    keycloakErrorHandler(resp) {
        try {
            const body = typeof resp?.body == 'string' ? JSON.parse(resp.body) : resp?.body;
            const formatFieldName = (field) => {
                if (!field)
                    return "Field";
                return field
                    .replace(/([A-Z])/g, ' $1')
                    .replace(/^./, (c) => c.toUpperCase());
            };
            /** MULTIPLE VALIDATION ERRORS */
            if (Array.isArray(body?.errors) && body?.errors.length > 0) {
                const fields = body.errors.map((e) => formatFieldName(e.field));
                let fieldMsg = "";
                if (fields.length == 1) {
                    fieldMsg = fields[0];
                }
                else if (fields.length == 2) {
                    fieldMsg = `${fields[0]} and ${fields[1]}`;
                }
                else {
                    fieldMsg = `${fields.slice(0, -1).join(', ')} and ${fields[fields.length - 1]}`;
                }
                return {
                    status: resp?.statusCode || 400,
                    message: `Invalid characters in ${fieldMsg}.`
                };
            }
            /** SINGLE FIELD VALIDATION ERROR */
            if (body?.field && body?.errorMessage) {
                const field = formatFieldName(body.field);
                return {
                    status: resp?.statusCode || 400,
                    message: `Invalid characters in ${field}.`
                };
            }
            /** GENERIC STRING ERROR FROM KEYCLOAK */
            if (body?.error) {
                let message = body.error;
                // Extract "Unrecognized field \"firstName1\"" reliably
                const match = body.error.match(/Unrecognized field\s+"([^"]+)"/);
                if (match && match[1]) {
                    message = `Unrecognized field "${match[1]}"`;
                }
                return {
                    status: resp?.statusCode || 502,
                    message
                };
            }
            return {
                status: 501,
                message: "Something went wrong with user data"
            };
        }
        catch (e) {
            return {
                status: 500,
                message: "Unexpected error while handling response"
            };
        }
    }
    setPasswordForUserKeyClock(req, res, userId, pwd, adminToken, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        const resetOptions = {
            method: 'PUT',
            url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users/' + userId + '/reset-password',
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer ' + adminToken,
                'X-Forwarded-For': sysInfo.ipAddress[0],
                'User-Agent': sysInfo.browserName
            },
            body: JSON.stringify({
                type: 'password',
                value: pwd,
                temporary: false
            })
        };
        console.log("setPasswordForUserKeyClock - resetOptions:", resetOptions);
        (0, axios_1.request)(resetOptions, (err, resp, body) => {
            console.log("setPasswordForUserKeyClock - resp:", resp);
            if (err) {
                callback(0, { status: 404, message: 'Something went wrong with Password set' });
                return;
            }
            else {
                if (resp.body == null || resp.body == '') {
                    callback(1, { status: 200, message: 'Password set successfully' });
                }
                else if (resp.body && resp.body != null) {
                    let body = JSON.parse(resp.body);
                    callback(0, { status: 404, message: body.error_description });
                }
                else {
                    callback(0, { status: 404, message: 'Password set failed' });
                }
            }
        });
    }
    createUser(req, res, username, password, email, firstName, lastName, callback) {
        this.loginKeyClocRealm(req, res, (errorR, resR) => {
            if (errorR == 1) {
                let tokenData = resR.data;
                let token;
                try {
                    token = JSON.parse(tokenData.body);
                }
                catch (e) {
                    token = tokenData.body;
                }
                this.createUserKeyClock(req, res, username, token.access_token, email, firstName, lastName, (errorU, resU) => {
                    if (errorU == 1) {
                        this.setPasswordForUserKeyClock(req, res, resU.data, password, token.access_token, (errorP, resP) => {
                            console.log("createUser setPasswordForUserKeyClock - callback:", errorP, resP);
                            resP.userID = resU.data;
                            callback(errorP, resP);
                        });
                    }
                    else {
                        console.log("createUser createOrGetUserKeyClock else - callback:", errorU, resU);
                        callback(errorU, resU);
                    }
                });
            }
            else {
                callback(0, { status: 404, message: 'Token generation failed' });
            }
        });
    }
    clearRequiredActions(req, res, accessToken, userId, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        const options = {
            method: 'PUT',
            url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users/' + userId,
            headers: {
                'Authorization': 'Bearer ' + accessToken,
                'Content-Type': 'application/json',
                'X-Forwarded-For': sysInfo.ipAddress[0],
                'User-Agent': sysInfo.browserName
            },
            body: JSON.stringify({
                requiredActions: []
            })
        };
        (0, axios_1.request)(options, (err) => {
            if (!err) {
                callback(1, { status: 200, message: 'Required actions cleared successfully' });
            }
            else {
                callback(0, { status: 404, message: 'Something went wrong with Clear Required Actions' });
            }
        });
    }
    resetKeyclockPassword(req, res, accessToken, username, newPassword, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        const userOptions = {
            method: 'GET',
            url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users?username=' + username,
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer ' + accessToken,
                'X-Forwarded-For': sysInfo.ipAddress[0],
                'User-Agent': sysInfo.browserName
            }
        };
        console.log("resetKeyclockPassword - userOptions:", userOptions);
        (0, axios_1.request)(userOptions, (err, result) => {
            console.log("resetKeyclockPassword - result:", result);
            if (err) {
                console.error("Error fetching user:", err);
                callback(0, { status: 404, message: 'Something went wrong with Reset Password' });
            }
            else {
                try {
                    const body = JSON.parse(result.body || '[]');
                    if (Array.isArray(body) && body.length > 0) {
                        const userId = body[0].id;
                        const resetOptions = {
                            method: 'PUT',
                            url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users/' + userId + '/reset-password',
                            headers: {
                                'Authorization': 'Bearer ' + accessToken,
                                'Content-Type': 'application/json',
                                'X-Forwarded-For': sysInfo.ipAddress[0],
                                'User-Agent': sysInfo.browserName
                            },
                            body: JSON.stringify({
                                type: 'password',
                                value: newPassword,
                                temporary: false
                            })
                        };
                        (0, axios_1.request)(resetOptions, (err, result) => {
                            if (!err) {
                                this.clearRequiredActions(req, res, accessToken, userId, (errorR, resR) => {
                                    console.log("resetKeyclockPassword - callback:", errorR, resR);
                                    callback(errorR, resR);
                                });
                            }
                            else {
                                console.log("resetKeyclockPassword - callback:", 0, { status: 404 });
                                callback(0, { status: 404, message: 'Something went wrong with Reset Password' });
                            }
                        });
                    }
                    else {
                        console.error("User not found for password reset");
                        callback(0, { status: 404, message: 'User not found for password reset' });
                    }
                }
                catch (parseError) {
                    console.error("Response parsing error:", parseError);
                    callback(0, { status: 404, message: 'Response parsing error' });
                }
            }
        });
    }
    resetKeyCloakPass(req, res, data, callback) {
        this.loginKeyClock(req, res, credentials.adminUsername, credentials.adminPassword, (errorR, resR) => {
            console.log("resetKeyCloakPass - loginKeyClock - callback:", errorR, resR);
            if (errorR == 1) {
                let name = (typeof data?.type === "object" && data.type.username) ? data.type.username : data.username;
                let acces_token = JSON.parse(resR.data.body);
                console.log("resetKeyCloakPass - acces_token:", acces_token);
                this.resetKeyclockPassword(req, res, acces_token.access_token, name, data.password, (errorR2, resR2) => {
                    console.log("resetKeyCloakPass - callback:", errorR2, resR2);
                    callback(errorR2, resR2);
                });
            }
            else {
                console.log("resetKeyCloakPass else - callback:", errorR, resR);
                callback(errorR, resR);
            }
        });
    }
    editKeyclockuser(req, res, data, callback) {
        this.loginKeyClock(req, res, credentials.adminUsername, credentials.adminPassword, (errorR, resR) => {
            if (errorR == 1) {
                let acces_token = JSON.parse(resR.data.body);
                this.getUserByUsername(req, res, acces_token.access_token, data, (errorR, resR) => {
                    console.log("editKeyclockuser - callback:", errorR, resR);
                    callback(errorR, resR);
                });
            }
            else {
                console.log("editKeyclockuser else - callback:", errorR, resR);
                callback(errorR, resR);
            }
        });
    }
    DeleteuserKeyclock(req, res, username, callback) {
        this.loginKeyClock(req, res, credentials.adminUsername, credentials.adminPassword, (errorR, resR) => {
            if (errorR == 1) {
                let acces_token = JSON.parse(resR.data.body);
                this.deleteKeyclockUser(req, res, acces_token.access_token, username, (errorR, resR) => {
                    console.log("DeleteuserKeyclock - callback:", errorR, resR);
                    callback(errorR, resR);
                });
            }
            else {
                console.log("DeleteuserKeyclock else - callback:", errorR, resR);
                callback(errorR, resR);
            }
        });
    }
    deleteKeyclockUser(req, res, accessToken, username, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        const userOptions = {
            method: 'GET',
            url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users?username=' + username,
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer ' + accessToken,
                'X-Forwarded-For': sysInfo.ipAddress[0],
                'User-Agent': sysInfo.browserName
            }
        };
        (0, axios_1.request)(userOptions, (err, result) => {
            if (err) {
                console.error("Error fetching user:", err);
                callback(0, { status: 404, message: 'Something went wrong with Delete User' });
            }
            else {
                try {
                    const body = JSON.parse(result.body || '[]');
                    if (Array.isArray(body) && body.length > 0) {
                        const userId = body[0].id;
                        const deleteOptions = {
                            method: 'DELETE',
                            url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users/' + userId,
                            headers: {
                                'Authorization': 'Bearer ' + accessToken,
                                'Content-Type': 'application/json',
                                'X-Forwarded-For': sysInfo.ipAddress[0],
                                'User-Agent': sysInfo.browserName
                            }
                        };
                        (0, axios_1.request)(deleteOptions, (err, result) => {
                            if (!err) {
                                callback(1, { status: 200, message: 'User deleted successfully' });
                            }
                            else {
                                console.error("Error deleting user:", err || result.statusCode);
                                callback(0, { status: 404, message: 'Something went wrong with Delete User' });
                            }
                        });
                    }
                    else {
                        console.error("User not found for deletion");
                        callback(2, { status: 404, message: 'User not found for deletion' });
                    }
                }
                catch (parseError) {
                    console.error("Response parsing error:", parseError);
                    callback(0, { status: 404, message: 'Response parsing error' });
                }
            }
        });
    }
    getUserByUsername(req, res, accessToken, data, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        const userOptions = {
            method: 'GET',
            url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users?username=' + data.user_name,
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer ' + accessToken,
                'X-Forwarded-For': sysInfo.ipAddress[0],
                'User-Agent': sysInfo.browserName
            }
        };
        (0, axios_1.request)(userOptions, (err, result) => {
            if (err) {
                console.error("Error fetching user:", err);
                callback(0, { status: 404, message: 'Something went wrong with Get User' });
            }
            else {
                try {
                    const body = JSON.parse(result.body || '{}');
                    if (result.statusCode >= 200 && result.statusCode < 300 && body[0]?.id) {
                        const options = {
                            method: 'PUT',
                            url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users/' + body[0].id,
                            headers: {
                                'Authorization': 'Bearer ' + accessToken,
                                'Content-Type': 'application/json',
                                'X-Forwarded-For': sysInfo.ipAddress[0],
                                'User-Agent': sysInfo.browserName
                            },
                            body: JSON.stringify({
                                firstName: data.first_name,
                                lastName: data.last_name,
                                email: data.email,
                                attributes: {
                                    san: [data.san],
                                    usertype: [data.usertype]
                                }
                            })
                        };
                        (0, axios_1.request)(options, (err, res) => {
                            if (err || res?.statusCode >= 400) {
                                console.log("getUserByUsername - callback:", 0, { status: 404 });
                                const errorResponse = this.keycloakErrorHandler(res);
                                callback(0, errorResponse);
                                return;
                            }
                            else {
                                this.clearRequiredActions(req, res, accessToken, body[0].id, (errorR, resR) => {
                                    console.log("getUserByUsername - callback:", errorR, resR);
                                    callback(errorR, resR);
                                });
                            }
                        });
                    }
                    else {
                        let errorcode = data.usertype == '2' ? '0' : '1';
                        console.log("getUserByUsername - callback:", 0, { status: 404, message: 'User not found for edit' });
                        callback(errorcode, { status: 404, message: 'User not found for edit' });
                    }
                }
                catch (parseError) {
                    console.error("Response parsing error::", parseError);
                    callback(0, { status: 404, message: 'Response parsing error' });
                }
            }
        });
    }
    userEnableDisbale(req, res, data1, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        let msg = '';
        if (data1.enabled == true) {
            msg: 'Enabled';
        }
        else {
            msg: 'Disabled';
        }
        // // Step 1 → Login Keycloak first
        this.loginKeyClock(req, res, credentials.adminUsername, credentials.adminPassword, (loginErr, loginRes) => {
            if (loginErr == 1) {
                let accessToken = JSON.parse(loginRes.data.body);
                const getOptions = {
                    method: 'GET',
                    url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users?username=' + data1.user_name,
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': 'Bearer ' + accessToken.access_token,
                        'X-Forwarded-For': sysInfo.ipAddress[0],
                        'User-Agent': sysInfo.browserName
                    }
                };
                console.log("getOptions for userEnableDisbale :: ", getOptions);
                (0, axios_1.request)(getOptions, (err, result) => {
                    console.log("Response for userEnableDisbale :: ", result.body);
                    if (err) {
                        console.error("Keycloak Get User Error:", err);
                        return callback(0, { status: 404, message: 'Something went wrong while fetching user.' });
                    }
                    try {
                        const body = JSON.parse(result.body || '{}');
                        if (result.body && result.statusCode == 200) {
                            const userId = body[0].id;
                            const disableOptions = {
                                method: 'PUT',
                                url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users/' + userId,
                                headers: {
                                    'Authorization': 'Bearer ' + accessToken.access_token,
                                    'Content-Type': 'application/json',
                                    'X-Forwarded-For': sysInfo.ipAddress[0],
                                    'User-Agent': sysInfo.browserName
                                },
                                body: JSON.stringify({
                                    enabled: data1.enabled
                                })
                            };
                            console.log("disableOptions for userEnableDisbale :: ", disableOptions);
                            (0, axios_1.request)(disableOptions, (error, result) => {
                                console.log("Response for userEnableDisbale :: ", result);
                                if (!error) {
                                    console.log("User " + msg + " in Keycloak");
                                    callback(1, { status: 200, message: 'User ' + msg + ' successfully!' });
                                }
                                else {
                                    callback(0, { status: 404, message: 'Error ' + msg + ' User' });
                                }
                            });
                        }
                        else {
                            callback(0, { status: 404, message: 'User not found' });
                        }
                    }
                    catch (parseError) {
                        console.error("JSON Parse Error:", parseError);
                        callback(0, { status: 500, message: 'Response parsing error' });
                    }
                });
            }
            else {
                callback(loginErr, loginRes);
            }
        });
    }
    sendVerifyEmail(req, res, username, isEmail, type, callback) {
        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
        if ((isEmail == 'false' || isEmail == false) && type == '1') {
            callback(1, { message: "No need for Email verified!" });
        }
        else {
            this.loginKeyClock(req, res, credentials.adminUsername, credentials.adminPassword, (loginErr, loginRes) => {
                if (loginErr == 1) {
                    let accessToken = JSON.parse(loginRes.data.body);
                    const searchOptions = {
                        method: 'GET',
                        url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users?username=' + username,
                        headers: {
                            'Content-Type': 'application/json',
                            'Authorization': 'Bearer ' + accessToken.access_token,
                            'X-Forwarded-For': sysInfo.ipAddress[0],
                            'User-Agent': sysInfo.browserName
                        }
                    };
                    console.log("sendVerifyEmail - searchOptions:", searchOptions);
                    (0, axios_1.request)(searchOptions, (err, result) => {
                        console.log("sendVerifyEmail - result:", result);
                        if (err) {
                            console.error("Error fetching user:", err);
                            callback(0, { status: 404, message: 'Something went wrong with email verified' });
                        }
                        else {
                            try {
                                const body = JSON.parse(result.body || '[]');
                                if (Array.isArray(body) && body.length > 0) {
                                    const userId = body[0].id;
                                    const verifyOptions = {
                                        method: 'PUT',
                                        url: credentials.keycloakBaseUrl + '/admin/realms/' + credentials.adminRealm + '/users/' + userId,
                                        headers: {
                                            'Authorization': 'Bearer ' + accessToken.access_token,
                                            'Content-Type': 'application/json',
                                            'X-Forwarded-For': sysInfo.ipAddress[0],
                                            'User-Agent': sysInfo.browserName
                                        },
                                        body: JSON.stringify({
                                            emailVerified: isEmail
                                        })
                                    };
                                    (0, axios_1.request)(verifyOptions, (err, result) => {
                                        if (!err) {
                                            console.log("sendVerifyEmail - callback:", err, result);
                                            callback(1, { message: "Email verified successfully" });
                                        }
                                        else {
                                            console.log("sendVerifyEmail - callback:", 0, { status: 404 });
                                            callback(0, { status: 404, message: 'Something went wrong with email verified' });
                                        }
                                    });
                                }
                                else {
                                    console.error("User not found for email verified");
                                    callback(0, { status: 404, message: 'User not found for email verified' });
                                }
                            }
                            catch (parseError) {
                                console.error("Response parsing error:", parseError);
                                callback(0, { status: 404, message: 'Response parsing error' });
                            }
                        }
                    });
                }
                else {
                    callback(loginErr, loginRes);
                }
            });
        }
    }
}
exports.Keycloak = Keycloak;
