"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelCsvUpload = void 0;
const ModelObject_1 = require("./ModelObject");
const setting_config_1 = require("../../config/setting.config");
var fs = require('fs');
class ModelCsvUpload extends ModelObject_1.ModelObject {
    constructor(req, res) {
        super(req, res);
        this.type = "INSERT";
    }
    fileUpload() {
        console.log('file', this.req.file);
        if (!this.req.file) {
            throw new Error("No file uploaded");
        }
        var uploaddir = new setting_config_1.UploadDirectory();
        var fullname = this.req.file.originalname.split(".");
        var finelfile = fullname[0] + "_" + (new Date().getTime()) + '.' + fullname[1];
        var target_path = uploaddir.UPLOADSDIR + finelfile;
        var tmp_path = this.req.file.path;
        var src = fs.createReadStream(tmp_path);
        var dest = fs.createWriteStream(target_path);
        src.pipe(dest);
        var data = [finelfile, uploaddir.UPLOADSDIR, tmp_path];
        return data;
    }
    prepare() {
        var ret = true;
        if (!this.req.file) {
            console.log("No file uploaded");
            return false;
        }
        if (this.req.file.mimetype == "text/plain" || this.req.file.mimetype == "text/csv") {
            console.log("Invalid File type");
            ret = true;
        }
        else {
            ret = false;
        }
        if (this.table.length < 1 || this.table == null) {
            console.log("Table is not defined properly.");
            ret = false;
        }
        if (this.req.body.hasOwnProperty('data')) {
            this.nonquery.data = this.req.body.data;
        }
        else {
            console.log("Data is not found into the request");
            ret = false;
        }
        return ret;
    }
    execute(callback) {
        this.log.Debug("Calling Add function in ModelObject.");
        //this.nonquery.prepare();
        this.nonquery.LoadFileExecute((err, data) => {
            this.respond(err, data, callback);
        });
    }
}
exports.ModelCsvUpload = ModelCsvUpload;
