"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const multer = require('multer');
const setting_config_1 = require("../config/setting.config");
const MIME_TYPE_MAP = {
    'image/png': 'png',
    'image/jpeg': 'jpeg',
    'image/jpg': 'jpg',
    'application/pdf': 'pdf',
    'text/plain': 'txt',
    'image/bmp': 'bmp',
    'image/tiff': 'tiff',
    'text/html': 'htm',
    'application/vnd.oasis.opendocument.text': 'odt',
    'application/rtf': 'rtf',
    'application/xml': 'xml',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document': 'docx'
};
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        let appealdir = new setting_config_1.UploadDirectory();
        const isValid = MIME_TYPE_MAP[file.mimetype];
        let error = "";
        if (!isValid) {
            error = new Error("Invalid file type");
        }
        cb(error, appealdir.APPEALUPLOADS);
    },
    filename: (req, file, cb) => {
        let file_path = file.originalname;
        let extension = file_path.split('.').pop();
        let randomName = Math.random().toString(36).substring(2, 12);
        const filenm = file.originalname;
        const flName = Date.now() + '-' + filenm.replace(filenm, randomName);
        const fileName = flName + '.' + extension;
        const ext = MIME_TYPE_MAP[file.mimetype];
        cb(null, fileName);
    }
});
const errorHandler = (err, req, res, next) => {
    if (err) {
        res.status(502).json({ status: 404, message: err.message });
    }
    else {
        next();
    }
};
module.exports = [multer({ storage: storage }).array('ATTACHMENTS'), errorHandler];
