"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwaggerApi = void 0;
const Session_1 = require("../lib/model/Session");
const RawQuery_1 = require("../lib/model/RawQuery");
const RawView_1 = require("../lib/view/RawView");
const _406_1 = require("../lib/view/406");
const RawNonQuery_1 = require("../lib/model/RawNonQuery");
const setting_config_1 = require("../config/setting.config");
const markError_1 = require("./markError");
const numberApi_1 = require("./numberApi");
const APIBase_1 = require("./APIBase");
let validuser = new APIBase_1.APIBase();
const axios_1 = require("./axios");
const cspSetting = new setting_config_1.CSPApiConfig();
const authKey = cspSetting.AUTHKEY;
const apiUrl = cspSetting.APIURL;
const appealEvidence = new setting_config_1.AppealEvidence();
const Str = require('@supercharge/strings').Str;
const makeNumber = (length) => {
    let result = '';
    let characters = '09876543212346543098765123456789';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const makeChar = (length) => {
    let result = '';
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const makeRanChar = (length) => {
    let result = '';
    let characters = 'ABCDE2FGHIJklmno345pqrsUVWXYZabcdefg0hijGHIJKLMNOPQRtuvwxyx354';
    let charactersLength = characters.length;
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
};
const generatePassword = () => {
    let result = '';
    return result = makeRanChar(5).substring(0, 3).toLowerCase() + makeNumber(1) + makeRanChar(5).substring(3, 5) + makeChar(1).toUpperCase() + makeChar(1).toLowerCase();
};
class SwaggerApi {
    constructor() {
    }
    BuyTollfree(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                // if (sessdata.type == 2 || sessdata.type == 22 || sessdata.type == 201 || sessdata.type == 202) {
                validuser.checksessionvalid2_22_201_202(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        const sdata = req.query ?? req.body.data;
                        let Quantity = sdata.Quantity ?? req.body.data;
                        let message = "";
                        switch (true) {
                            case (!sdata || sdata == '' || sdata == 'null' || sdata == 'undefined'):
                                message = "Missing parameter: Quantity!";
                                break;
                            case (!Quantity || Quantity == '' || Quantity == 'null' || Quantity == 'undefined'):
                                message = "Quantity is required!";
                                break;
                            case (!/^[1-9]\d*$/.test(Quantity)):
                                message = "Quantity must be an integer and greater than or equal to 1!";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ status: 507, message: message });
                            objv.execute();
                        }
                        else {
                            let obj0 = new RawQuery_1.ModelRawQuery(req, res);
                            obj0.qrysql = "SELECT e.idendpoint, e.connection_key, i.inbound_key, o.outbound_key FROM `endpoint` e JOIN `inbound` i ON e.idendpoint = i.idendpoint JOIN `outbound` o ON e.idendpoint = o.idendpoint WHERE e.`isDefault`='true' AND e.`iduser`= '" + sessdata.iduser + "'";
                            obj0.prepare();
                            obj0.execute((connErr, connRes) => {
                                if (connErr == 1) {
                                    let quantity = Quantity;
                                    let fun = new numberApi_1.Number();
                                    fun.prorationGet(req, res, 'TF', 0, sessdata.idtariff, (error, proration) => {
                                        if (error == 1) {
                                            let rate = new APIBase_1.APIBase();
                                            rate.getRate(req, res, sessdata.idtariff, "message", "TF", (err, voice_rate) => {
                                                rate.prorateCalculator(req, res, proration.proration, voice_rate[0].rate, proration.setup_cost, (pc_err, prorate1) => {
                                                    if (pc_err == 1) {
                                                        let fullrates = parseFloat(voice_rate[0].rate) + parseFloat(proration.setup_cost);
                                                        let prorate = typeof prorate1 != 'undefined' && prorate1 > 0 ? prorate1 : 0;
                                                        let RateS = (parseFloat(prorate) * quantity).toFixed(3);
                                                        rate.checkBalance(req, res, sessdata.idaccount, RateS, (walletError, wallet) => {
                                                            if (walletError == 1) {
                                                                let connKey = connRes.length > 0 ? connRes[0].connection_key : '';
                                                                let inbounKey = connRes.length > 0 ? connRes[0].inbound_key : '';
                                                                let outboundKey = connRes.length > 0 ? connRes[0].outbound_key : '';
                                                                let GOpayload = {
                                                                    name: "SOD" + String(new Date().getTime()),
                                                                    total_dids: Quantity,
                                                                    numbers: '',
                                                                    routing: connKey,
                                                                    in_routing: inbounKey,
                                                                    out_routing: outboundKey,
                                                                    campaign: '',
                                                                    sessdata: sessdata
                                                                };
                                                                let swag = new SwaggerApi();
                                                                swag.CreateGroupOrder(req, res, GOpayload, (error, response) => {
                                                                    if (error == 1) {
                                                                        let groupID = response.data.id_grouporder;
                                                                        let numberapi = new numberApi_1.Number();
                                                                        numberapi.BuyTollfreeNumber(req, res, groupID, err => {
                                                                            if (err == 0) {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ status: "200", message: "Tollfree Order Created Successfully!" });
                                                                                objv.execute();
                                                                            }
                                                                            else {
                                                                                let objv = new RawView_1.RawView(res);
                                                                                objv.prepare({ status: 503, message: "Service Unavailable!" });
                                                                                objv.execute();
                                                                            }
                                                                        });
                                                                    }
                                                                    else {
                                                                        let objv = new RawView_1.RawView(res);
                                                                        objv.prepare({ status: 201, message: "Group Order is not Created!" });
                                                                        objv.execute();
                                                                    }
                                                                });
                                                            }
                                                            else {
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({
                                                                    error_code: 0,
                                                                    error: walletError,
                                                                    message: "You have insufficient funds in your account. Kindly add funds to your account!",
                                                                    status: 503
                                                                });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({
                                                            error_code: 0,
                                                            error: 'Wallet Issue',
                                                            message: "Something Went Wrong to Fetch Account Balance.",
                                                            status: 503
                                                        });
                                                        objv.execute();
                                                    }
                                                });
                                            });
                                        }
                                        else {
                                            let objv = new RawView_1.RawView(res);
                                            objv.prepare({
                                                error_code: 0,
                                                status: 502,
                                                message: "Something went wrong with connection!"
                                            });
                                            objv.execute();
                                        }
                                    });
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Something Went Wrong With Connection!" });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare({
                            error: 1,
                            status: 404,
                            message: "Not Permitted"
                        });
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    CreateGroupOrder(req, res, GOpayload, callback) {
        let checkService = new APIBase_1.APIBase();
        checkService.serviceActivation(req, res, GOpayload.sessdata, "5", (err, resp) => {
            if (resp.status == 200) {
                let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                let totalDID = GOpayload.total_dids;
                let process_dids = 0;
                obj.nonqrysql = "INSERT INTO `did_group_order` SET iduser=" + GOpayload.sessdata.iduser + ", idaccount=" + GOpayload.sessdata.idaccount + ", name='" + GOpayload.name + "', total_dids=" + (0, markError_1.setToZero)(totalDID) + ", process_dids=" + (0, markError_1.setToZero)(process_dids) + ", numbers='" + GOpayload.numbers + "', routing='" + GOpayload.routing + "', in_routing='" + GOpayload.in_routing + "', out_routing='" + GOpayload.out_routing + "', campaign='" + GOpayload.campaign + "';";
                obj.prepare();
                obj.execute((error, result) => {
                    callback(1, {
                        status: 202,
                        message: "Group successfully created.",
                        data: {
                            id_grouporder: result.insertId
                        }
                    });
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({
                    error: 1,
                    status: resp.status,
                    message: resp.message.replace(/::SN::/g, "DID Buy")
                });
                objv.execute();
            }
        });
    }
    /**
     *  brand and vetting Appeal API start
     */
    appealEvidence(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid2_22_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let sdata, message = '', files = [];
                        try {
                            sdata = JSON.parse(req.body);
                        }
                        catch (e) {
                            sdata = req.body;
                        }
                        switch (true) {
                            case (!sdata || !('brandId' in req.body || 'Type' in req.body)):
                                message = "Missing request body";
                                break;
                            case ((0, markError_1.isMissing)(sdata.brandId)):
                                message = "BrandId is required";
                                break;
                            case ((0, markError_1.isMissing)(sdata.Type)):
                                message = "Type is required";
                                break;
                            case (!req.files || Object.keys(req.files).length == 0):
                                message = "ATTACHMENTS is required";
                                break;
                            case (sdata.brandId && (0, markError_1.checkBrandId)(sdata.brandId) != ''):
                                message = (0, markError_1.checkBrandId)(sdata.brandId);
                                break;
                            case (sdata.Type && !["BrandAppeal", "BrandVettingAppeal"].includes(sdata.Type)):
                                message = "Type is invalid";
                                break;
                            default:
                                message = '';
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 501 });
                            objv.execute();
                            return;
                        }
                        else {
                            let Obj_ap = new RawQuery_1.ModelRawQuery(req, res);
                            Obj_ap.qrysql = "SELECT `iduser`,`idaccount`,`identityStatus`, `brandId` FROM `brand` WHERE `idaccount`=" + sessdata.idaccount + " AND `brandId`= '" + sdata.brandId + "'";
                            Obj_ap.prepare();
                            Obj_ap.execute((result_appeal, result_ap) => {
                                if (result_appeal == 1 && result_ap.length > 0) {
                                    files = req.files;
                                    let fileSizes = [];
                                    // let key = Math.random().toString(36).slice(2);
                                    files.forEach((element, index) => {
                                        fileSizes.push(element.size);
                                    });
                                    const maxIndividualFileSizeBytes = 10 * 1024 * 1024;
                                    const individualFileLimitReached = fileSizes.every((fileSize) => fileSize <= maxIndividualFileSizeBytes);
                                    if (individualFileLimitReached) {
                                        var fs = require('fs');
                                        let options = {
                                            'method': 'POST',
                                            'url': apiUrl + 'brand/' + sdata.brandId + '/appeal/evidence',
                                            'headers': {
                                                'Content-Type': 'application/json',
                                                'Authorization': 'Basic ' + authKey
                                            },
                                            formData: {
                                                'file': {
                                                    'value': fs.createReadStream(files[0].path.replace(/\.\.[/\\]/g, '')),
                                                    'options': {
                                                        'filename': files[0].filename,
                                                        'contentType': null
                                                    }
                                                }
                                            }
                                        };
                                        (0, axios_1.request)(options, function (error, response) {
                                            console.log("response :: evidenceRequest ::", response.body);
                                            if (!error) {
                                                try {
                                                    if (response.statusCode == 200) {
                                                        let resp = JSON.parse(response.body);
                                                        let value = appealEvidence.fileEvidence + resp.fileName;
                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "INSERT INTO `evidence_files` (`iduser`,`idaccount`,`brandId`,`uuid`,`key`,`mimeType`,`fileName`,`path`,`evidence_type`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + resp.uuid + "','','" + resp.mimeType + "','" + resp.fileName + "' ,'" + value + "', '" + sdata.Type + "')";
                                                        obj.prepare();
                                                        obj.execute((err, result) => {
                                                            if (err == 1) {
                                                                console.log("Data inserted Successfully");
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: 200, message: "Appeal evidence save successfully", data: resp });
                                                                objv.execute();
                                                            }
                                                            else {
                                                                console.log("Something Went wrong data not inserted");
                                                                let desc = resp[0].description && resp[0].description != undefined ? resp[0].description : 'Data not inserted!';
                                                                let code = resp[0].code && resp[0].code != undefined ? resp[0].code : 502;
                                                                let objv = new RawView_1.RawView(res);
                                                                objv.prepare({ status: code, message: desc });
                                                                objv.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 502, message: response[0].description });
                                                        objv.execute();
                                                    }
                                                }
                                                catch (e) {
                                                    console.log("Error :: evidenceRequest ::", e);
                                                    console.log("Something Went wrong data not inserted");
                                                    let objv = new RawView_1.RawView(res);
                                                    objv.prepare({ status: 503, message: "Something went wrong!" });
                                                    objv.execute();
                                                }
                                            }
                                            else {
                                                console.log("response description");
                                                let objv = new RawView_1.RawView(res);
                                                objv.prepare({ status: response.code, message: response[0].description });
                                                objv.execute();
                                            }
                                        });
                                    }
                                    else {
                                        console.log("Individual file size limit exceeded.");
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 504, message: "Individual file size limit exceeded." });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objk = new RawView_1.RawView(res);
                                    objk.prepare({ status: 406, message: "Brand Id Not Found!" });
                                    objk.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare("No session data there");
                objv.execute();
            }
        });
    }
    brandAppeal(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((errsess, sessdata) => {
            if (errsess == 1) {
                validuser.checksessionvalid2_22_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let appeal_rate = 11;
                        let key = Math.random().toString(36).slice(2);
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let sdata = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
                        let message = '';
                        switch (true) {
                            case (!sdata):
                                message = "Missing request body";
                                break;
                            case ((0, markError_1.isMissing)(sdata.brandId)):
                                message = "BrandId is required";
                                break;
                            case ((0, markError_1.isMissing)(sdata.category)):
                                message = "category is required";
                                break;
                            /* case (isMissing(sdata.explanation)):
                                message = "Explanation is required";
                                break; */
                            case (sdata.brandId && (0, markError_1.checkBrandId)(sdata.brandId) != ''):
                                message = (0, markError_1.checkBrandId)(sdata.brandId);
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 501 });
                            objv.execute();
                            return;
                        }
                        else {
                            validuser.checkBalance(req, res, sessdata.idaccount, appeal_rate, (walletError, wallet) => {
                                if (walletError == 1) {
                                    if (Array.isArray(sdata.uuids) && sdata.uuids.length > 0) {
                                        let Obj_ap = new RawQuery_1.ModelRawQuery(req, res);
                                        Obj_ap.qrysql = "SELECT `iduser`,`idaccount`,`identityStatus`, `brandId` FROM `brand` WHERE `idaccount`=" + sessdata.idaccount + " AND `brandId`= '" + sdata.brandId + "'";
                                        Obj_ap.prepare();
                                        Obj_ap.execute((result_appeal, result_ap) => {
                                            if (result_appeal == 1 && result_ap.length > 0) {
                                                if (result_ap[0].identityStatus !== "VETTED_VERIFIED") {
                                                    const evidenceId = sdata.uuids.split(',').map((u) => `'${u.trim()}'`).join(',');
                                                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj1.qrysql = "SELECT uuid from `evidence_files` WHERE `iduser`=" + sessdata.iduser + " AND uuid IN (" + evidenceId + ") AND `brandId`='" + sdata.brandId + "' AND (`key` IS NULL OR `key` = '' OR `key` = 'undefined') AND `evidence_type`='BrandAppeal'";
                                                    obj1.prepare();
                                                    obj1.execute((uuid_error, uuid_success) => {
                                                        let Resuuids = [];
                                                        Resuuids = JSON.parse(JSON.stringify(uuid_success));
                                                        const uuids = Resuuids.map((item) => item.uuid);
                                                        if (uuid_error == 1 && uuid_success.length > 0) {
                                                            uuids.forEach((element, index) => {
                                                                var options = {
                                                                    'method': 'POST',
                                                                    'url': apiUrl + 'brand/' + sdata.brandId + '/appeal',
                                                                    'headers': {
                                                                        'Content-Type': 'application/json',
                                                                        'Authorization': 'Basic ' + authKey
                                                                    },
                                                                    body: JSON.stringify({
                                                                        "appealCategories": sdata.category,
                                                                        "attachmentUuids": element,
                                                                        "explanation": sdata.explanation
                                                                    })
                                                                };
                                                                (0, axios_1.request)(options, function (error, response) {
                                                                    if (!error) {
                                                                        try {
                                                                            let escapedLog = JSON.stringify([response.body, datasess]);
                                                                            let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                                            let appealRequest = response.body == '' ? response.body : JSON.parse(response.body);
                                                                            if (uuids.length - 1 == index) {
                                                                                if (response.statusCode == 204) {
                                                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                    obj4.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appeal_rate + "','Pending',1,'Brand Appeal Requested Successfully','" + combinedLog + "')";
                                                                                    obj4.prepare();
                                                                                    obj4.execute((_err, result) => {
                                                                                        console.log("Brand Appeal Log Updated");
                                                                                    });
                                                                                    let obj2 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                    obj2.nonqrysql = "INSERT INTO `brand_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`attachmentUuids`,`explanation`,`vetting_status`,`key`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appeal_rate + "','" + sdata.category + "','" + element + "','" + (0, markError_1.parseBody)(sdata.explanation) + "','Pending','" + key + "')";
                                                                                    obj2.prepare();
                                                                                    obj2.execute((_err, result) => {
                                                                                        if (_err == 1) {
                                                                                            let payload = {
                                                                                                idaccount: sessdata.idaccount,
                                                                                                amount: appeal_rate,
                                                                                                purpose: 'brand appeal',
                                                                                                type: '-'
                                                                                            };
                                                                                            validuser.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                                                console.log("appealRequest => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                                            });
                                                                                            let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                            obj5.nonqrysql = "UPDATE `evidence_files` set `key`='" + key + "' WHERE `uuid`='" + element + "' AND `brandId`='" + sdata.brandId + "'";
                                                                                            obj5.prepare();
                                                                                            obj5.execute((_err, result) => {
                                                                                                console.log("Brand Appeal Log Updated");
                                                                                            });
                                                                                            console.log("Brand Appeal Requested Successfully!");
                                                                                            let objh = new RawView_1.RawView(res);
                                                                                            objh.prepare({ status: 200, message: "Brand Appeal Requested Successfully!" });
                                                                                            objh.execute();
                                                                                        }
                                                                                        else {
                                                                                            console.log("Appeal Request Not Saved Successfully!");
                                                                                            let objh = new RawView_1.RawView(res);
                                                                                            objh.prepare({ status: 200, message: "Brand Appeal Request Raised But Not Saved!" });
                                                                                            objh.execute();
                                                                                        }
                                                                                    });
                                                                                }
                                                                                else {
                                                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                    obj.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Failed',4,'Brand Appeal Request Failed','" + combinedLog + "')";
                                                                                    obj.prepare();
                                                                                    obj.execute((_err, result) => {
                                                                                        console.log("Brand Log Updated");
                                                                                    });
                                                                                    let objv = new RawView_1.RawView(res);
                                                                                    objv.prepare({ status: 502, message: appealRequest[0].description });
                                                                                    objv.execute();
                                                                                }
                                                                            }
                                                                        }
                                                                        catch (e) {
                                                                            console.log("Error :: appealRequest ::", e);
                                                                            let obj = new RawView_1.RawView(res);
                                                                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                            obj.execute();
                                                                        }
                                                                    }
                                                                    else {
                                                                        let obj = new RawView_1.RawView(res);
                                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                        obj.execute();
                                                                    }
                                                                });
                                                            });
                                                        }
                                                        else {
                                                            let objk = new RawView_1.RawView(res);
                                                            objk.prepare({ status: 404, message: "UUID not found!" });
                                                            objk.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objk = new RawView_1.RawView(res);
                                                    objk.prepare({ status: 405, message: "Appeals are limited to the entities with UNVERIFIED identity status" });
                                                    objk.execute();
                                                }
                                            }
                                            else {
                                                let objk = new RawView_1.RawView(res);
                                                objk.prepare({ status: 406, message: "Brand Id Not Found!" });
                                                objk.execute();
                                            }
                                        });
                                    }
                                    else {
                                        const options = {
                                            'method': 'POST',
                                            'url': apiUrl + 'brand/' + sdata.brandId + '/appeal',
                                            'headers': {
                                                'Content-Type': 'application/json',
                                                'Authorization': 'Basic ' + authKey
                                            },
                                            body: JSON.stringify({
                                                "appealCategories": sdata.category,
                                                "explanation": sdata.explanation
                                            })
                                        };
                                        (0, axios_1.request)(options, function (error, response) {
                                            if (!error) {
                                                try {
                                                    let escapedLog = JSON.stringify([response.body, datasess]);
                                                    let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                    let payloadResp = response.body == '' ? response.body : JSON.parse(response.body);
                                                    if (response.statusCode == 204) {
                                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj4.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appeal_rate + "','Pending',1,'Brand Appeal Requested Successfully','" + combinedLog + "')";
                                                        obj4.prepare();
                                                        obj4.execute((_err, result) => {
                                                            console.log("Brand Appeal Log Updated");
                                                        });
                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "INSERT INTO `brand_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`explanation`,`vetting_status`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appeal_rate + "','" + sdata.category + "','" + (0, markError_1.parseBody)(sdata.explanation) + "','Pending')";
                                                        obj.prepare();
                                                        obj.execute((_err, result) => {
                                                            if (_err == 1) {
                                                                let payload = {
                                                                    idaccount: sessdata.idaccount,
                                                                    amount: appeal_rate,
                                                                    purpose: 'brand appeal',
                                                                    type: '-'
                                                                };
                                                                validuser.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                    console.log("appealRequest => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                });
                                                                console.log("Brand Appeal Requested Successfully!");
                                                                let objh = new RawView_1.RawView(res);
                                                                objh.prepare({ status: 200, message: "Brand Appeal Requested Successfully!" });
                                                                objh.execute();
                                                            }
                                                            else {
                                                                console.log("Brand Appeal Request Not Saved Successfully!!!");
                                                                let objh = new RawView_1.RawView(res);
                                                                objh.prepare({ status: 200, message: "Brand Appeal Request Raised But Not Saved. We will Fix it Soon!" });
                                                                objh.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj4.nonqrysql = "INSERT INTO `brand_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Pending',4,'Brand Appeal Request Failed','" + combinedLog + "')";
                                                        obj4.prepare();
                                                        obj4.execute((_err, result) => {
                                                            console.log("Brand Appeal Log Updated");
                                                        });
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 502, message: payloadResp[0].description });
                                                        objv.execute();
                                                    }
                                                }
                                                catch (e) {
                                                    console.log("Error :: appealRequest ::", e);
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                    obj.execute();
                                                }
                                            }
                                            else {
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                obj.execute();
                                            }
                                        });
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ error: walletError, message: "You have insufficient funds in your account. Kindly add funds to your account!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    brandVettingAppeal(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((errsess, sessdata) => {
            if (errsess == 1) {
                validuser.checksessionvalid2_22_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let appealV_rate = 11;
                        let key = Math.random().toString(36).slice(2);
                        let sysInfo = (0, markError_1.ipAddressAndBrowser)(req);
                        let datasess = {
                            iduser: sessdata.iduser,
                            idaccount: sessdata.idaccount,
                            ipAddress: sysInfo.ipAddress[0],
                        };
                        let sdata = req.body.data == undefined ? req.body : JSON.parse(req.body.data);
                        let message = "";
                        switch (true) {
                            case (!sdata):
                                message = "Missing request body";
                                break;
                            case ((0, markError_1.isMissing)(sdata.brandId)):
                                message = "BrandId is required";
                                break;
                            case ((0, markError_1.isMissing)(sdata.category)):
                                message = "category is required";
                                break;
                            case ((0, markError_1.isMissing)(sdata.evpId)):
                                message = "evpId is required";
                                break;
                            case ((0, markError_1.isMissing)(sdata.vettingId)):
                                message = "vettingId is required";
                                break;
                            case (sdata.brandId && (0, markError_1.checkBrandId)(sdata.brandId) != ''):
                                message = (0, markError_1.checkBrandId)(sdata.brandId);
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 501 });
                            objv.execute();
                            return;
                        }
                        else {
                            validuser.checkBalance(req, res, sessdata.idaccount, appealV_rate, (walletError, wallet) => {
                                if (walletError == 1) {
                                    if (Array.isArray(sdata.uuids) && sdata.uuids.length > 0) {
                                        let Obj_ap = new RawQuery_1.ModelRawQuery(req, res);
                                        Obj_ap.qrysql = "SELECT `iduser`,`idaccount`,`identityStatus`, `brandId` FROM `brand` WHERE `idaccount`=" + sessdata.idaccount + " AND `brandId`= '" + sdata.brandId + "'";
                                        Obj_ap.prepare();
                                        Obj_ap.execute((result_appeal, result_ap) => {
                                            if (result_appeal == 1 && result_ap.length > 0) {
                                                if (result_ap[0].identityStatus !== "UNVERIFIED") {
                                                    const evidenceId = sdata.uuids.split(',').map((u) => `'${u.trim()}'`).join(',');
                                                    let obj1 = new RawQuery_1.ModelRawQuery(req, res);
                                                    obj1.qrysql = "SELECT uuid from `evidence_files` WHERE `iduser`=" + sessdata.iduser + " AND uuid IN (" + evidenceId + ") AND `brandId`='" + sdata.brandId + "' AND (`key` IS NULL OR `key` = '' OR `key` = 'undefined') AND `evidence_type`='BrandVettingAppeal'";
                                                    obj1.prepare();
                                                    obj1.execute((uuid_error, uuid_success) => {
                                                        let Resuuids = [];
                                                        Resuuids = JSON.parse(JSON.stringify(uuid_success));
                                                        const uuids = Resuuids.map((item) => item.uuid);
                                                        if (uuid_error == 1 && uuid_success.length > 0) {
                                                            uuids.forEach((element, index) => {
                                                                var options = {
                                                                    'method': 'POST',
                                                                    'url': apiUrl + 'brand/' + sdata.brandId + '/externalVetting/appeal',
                                                                    'headers': {
                                                                        'Content-Type': 'application/json',
                                                                        'Authorization': 'Basic ' + authKey
                                                                    },
                                                                    body: JSON.stringify({
                                                                        "evpId": sdata.evpId,
                                                                        "vettingId": sdata.vettingId,
                                                                        "appealCategories": sdata.category,
                                                                        "attachmentUuids": element,
                                                                        "explanation": sdata.explanation,
                                                                    })
                                                                };
                                                                (0, axios_1.request)(options, function (error, response) {
                                                                    if (!error) {
                                                                        try {
                                                                            let escapedLog = JSON.stringify([response.body, datasess]);
                                                                            let combinedLog = escapedLog.replace(/'/g, "\\'");
                                                                            let appealVettingRequest = response.body == '' ? response.body : JSON.parse(response.body);
                                                                            if (uuids.length - 1 == index) {
                                                                                if (response.statusCode == 204) {
                                                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                    obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`vettingId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + sdata.vettingId + "','" + appealV_rate + "','Pending',1,'Brand Vetting Appeal Requested Successfully','" + combinedLog + "')";
                                                                                    obj4.prepare();
                                                                                    obj4.execute((_err, result) => {
                                                                                        console.log("Brand Vetting Appeal Log Updated");
                                                                                    });
                                                                                    let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                    obj.nonqrysql = "INSERT INTO `brand_vetting_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`attachmentUuids`,`explanation`,`vetting_status`,`key`,`evpId`,`vettingId`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appealV_rate + "','" + sdata.category + "','" + element + "','" + (0, markError_1.parseBody)(sdata.explanation) + "','Pending','" + key + "','" + sdata.evpId + "','" + sdata.vettingId + "')";
                                                                                    obj.prepare();
                                                                                    obj.execute((_err, result) => {
                                                                                        if (_err == 1) {
                                                                                            let payload = {
                                                                                                idaccount: sessdata.idaccount,
                                                                                                amount: appealV_rate,
                                                                                                purpose: 'brand appeal',
                                                                                                type: '-'
                                                                                            };
                                                                                            validuser.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                                                console.log("appealRequest => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                                            });
                                                                                            let obj5 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                            obj5.nonqrysql = "UPDATE `evidence_files` set `key`='" + key + "' WHERE `uuid`='" + element + "' AND `brandId`='" + sdata.brandId + "'";
                                                                                            obj5.prepare();
                                                                                            obj5.execute((_err, result) => {
                                                                                                console.log("Brand Appeal Log Updated");
                                                                                            });
                                                                                            console.log("Brand Vetting Appeal Request sent Successfully!");
                                                                                            let objh = new RawView_1.RawView(res);
                                                                                            objh.prepare({ status: 200, message: "Appeal Request sent Successfully!" });
                                                                                            objh.execute();
                                                                                        }
                                                                                        else {
                                                                                            console.log("Brand Vetting Appeal Request Not Saved Successfully!");
                                                                                            let objh = new RawView_1.RawView(res);
                                                                                            objh.prepare({ status: 200, message: "New Appeal Request Raised But Not Saved. We Will Fix it Soon!" });
                                                                                            objh.execute();
                                                                                        }
                                                                                    });
                                                                                }
                                                                                else {
                                                                                    let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                                                    obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Failed',4,'Brand Vetting Appeal Requested Failed','" + combinedLog + "')";
                                                                                    obj4.prepare();
                                                                                    obj4.execute((_err, result) => {
                                                                                        console.log("Brand Vetting Appeal Log Updated");
                                                                                    });
                                                                                    let objv = new RawView_1.RawView(res);
                                                                                    objv.prepare({ status: 502, message: appealVettingRequest[0].description });
                                                                                    objv.execute();
                                                                                }
                                                                            }
                                                                        }
                                                                        catch (e) {
                                                                            console.log("Error :: appealRequest ::", e);
                                                                            let obj = new RawView_1.RawView(res);
                                                                            obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                            obj.execute();
                                                                        }
                                                                    }
                                                                    else {
                                                                        let obj = new RawView_1.RawView(res);
                                                                        obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                                        obj.execute();
                                                                    }
                                                                });
                                                            });
                                                        }
                                                        else {
                                                            let objk = new RawView_1.RawView(res);
                                                            objk.prepare({ status: 404, message: "UUID not found!" });
                                                            objk.execute();
                                                        }
                                                    });
                                                }
                                                else {
                                                    let objk = new RawView_1.RawView(res);
                                                    objk.prepare({ status: 405, message: "Appeals are limited to the entities with UNVERIFIED identity status" });
                                                    objk.execute();
                                                }
                                            }
                                            else {
                                                let objk = new RawView_1.RawView(res);
                                                objk.prepare({ status: 406, message: "Brand Id Not Found!" });
                                                objk.execute();
                                            }
                                        });
                                    }
                                    else {
                                        var options = {
                                            'method': 'POST',
                                            'url': apiUrl + 'brand/' + sdata.brandId + '/externalVetting/appeal',
                                            'headers': {
                                                'Content-Type': 'application/json',
                                                'Authorization': 'Basic ' + authKey
                                            },
                                            body: JSON.stringify({
                                                "evpId": sdata.evpId,
                                                "vettingId": sdata.vettingId,
                                                "appealCategories": sdata.category,
                                                "explanation": sdata.explanation,
                                            })
                                        };
                                        (0, axios_1.request)(options, function (error, response) {
                                            let escapedLog = JSON.stringify([response.body, datasess]);
                                            let combinedLog = escapedLog.replace(/'/g, "\\'");
                                            if (!error) {
                                                try {
                                                    let appealVettingRequest = response.body == '' ? response.body : JSON.parse(response.body);
                                                    if (response.statusCode == 204) {
                                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`vettingId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + sdata.vettingId + "','" + appealV_rate + "','Pending',1,'Brand Vetting Appeal Requested Successfully','" + combinedLog + "')";
                                                        obj4.prepare();
                                                        obj4.execute((_err, result) => {
                                                            console.log("Brand Log Updated");
                                                        });
                                                        let obj = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj.nonqrysql = "INSERT INTO `brand_vetting_appeal` (`iduser`,`idaccount`,`brandId`,`cost`,`appealCategories`,`explanation`,`vetting_status`,`evpId`,`vettingId`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "','" + appealV_rate + "','" + sdata.category + "','" + (0, markError_1.parseBody)(sdata.explanation) + "','Pending','" + sdata.evpId + "','" + sdata.vettingId + "')";
                                                        obj.prepare();
                                                        obj.execute((_err, result) => {
                                                            if (_err == 1) {
                                                                let payload = {
                                                                    idaccount: sessdata.idaccount,
                                                                    amount: appealV_rate,
                                                                    purpose: 'Brand Vetting Appeal Request',
                                                                    type: '-'
                                                                };
                                                                validuser.walletDeduction(req, res, payload, (errorD, dataD) => {
                                                                    console.log("appealRequest => walletDeduction Wallet deduction response:", errorD, dataD);
                                                                });
                                                                console.log("Appeal Request sent Successfully!");
                                                                let objh = new RawView_1.RawView(res);
                                                                objh.prepare({ status: 200, message: "Appeal Request sent Successfully!" });
                                                                objh.execute();
                                                            }
                                                            else {
                                                                console.log("Brand Vetting Appeal Request Not Saved Successfully!!");
                                                                let objh = new RawView_1.RawView(res);
                                                                objh.prepare({ status: 200, message: "New Appeal Request Raised But Not Saved!" });
                                                                objh.execute();
                                                            }
                                                        });
                                                    }
                                                    else {
                                                        let obj4 = new RawNonQuery_1.ModelRawNonQuery(req, res);
                                                        obj4.nonqrysql = "INSERT INTO `brand_vetting_appeal_log` (`iduser`,`idaccount`,`brandId`,`cost`,`status`,`event_type`,`description`,`webhook_full_log`) VALUES (" + sessdata.iduser + ", " + sessdata.idaccount + ",'" + sdata.brandId + "',0,'Failed',4,'Brand Vetting Appeal Requested Failed','" + combinedLog + "')";
                                                        obj4.prepare();
                                                        obj4.execute((_err, result) => {
                                                            console.log("Brand Vetting Appeal Log Updated");
                                                        });
                                                        let objv = new RawView_1.RawView(res);
                                                        objv.prepare({ status: 502, message: appealVettingRequest[0].description });
                                                        objv.execute();
                                                    }
                                                }
                                                catch (e) {
                                                    console.log("Error :: AppealVettingRequest ::", e);
                                                    let obj = new RawView_1.RawView(res);
                                                    obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                    obj.execute();
                                                }
                                            }
                                            else {
                                                let obj = new RawView_1.RawView(res);
                                                obj.prepare({ error_code: 0, status: 502, message: "Something went wrong!" });
                                                obj.execute();
                                            }
                                        });
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ error: walletError, message: "You have insufficient funds in your account. Kindly add funds to your account!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Session!", status: 401 });
                objv.execute();
            }
        });
    }
    getBrandAppeal(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                validuser.checksessionvalid1_2_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let ext_field;
                        if (sessData.type == 1) {
                            ext_field = "iduser,idaccount,";
                        }
                        let sdata = req.query, data, message = "";
                        try {
                            data = JSON.parse(sdata);
                        }
                        catch {
                            data = sdata;
                        }
                        switch (true) {
                            case (!req.query || !('brandId' in req.query)):
                                message = "Missing request body";
                                break;
                            case ((0, markError_1.isMissing)(data.brandId)):
                                message = "brandId is required";
                                break;
                            case (data.brandId && (0, markError_1.checkBrandId)(data.brandId) != ''):
                                message = (0, markError_1.checkBrandId)(data.brandId);
                                break;
                            case (sessData.type == 1 && (0, markError_1.isMissing)(data.idaccount)):
                                message = "idaccount is required for admin";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 501 });
                            objv.execute();
                            return;
                        }
                        else {
                            let idaccount = sessData.type == 1 ? data.idaccount : sessData.idaccount;
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT " + ext_field + " brandID,appealCategories,attachmentUuids,explanation,vetting_status,`key`,vetting_status_update_at,created_at FROM `brand_appeal` WHERE brandId='" + data.brandId + "' AND idaccount=" + idaccount + " ";
                            obj.prepare();
                            obj.execute((err, result) => {
                                if (err == 1) {
                                    if (result.length > 0) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: 'Brand Appeal Fatched Successfully!', data: result, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Brand Appeal Not Found!" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something went wrong with get brand appeal!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    getBrandVettingAppeal(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                validuser.checksessionvalid1_2_22_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query;
                        let data;
                        try {
                            data = JSON.parse(sdata);
                        }
                        catch {
                            data = sdata;
                        }
                        let message = "";
                        switch (true) {
                            case (!data):
                                message = "Missing Parameter brandId";
                                break;
                            case ((0, markError_1.isMissing)(data.brandId)):
                                message = "BrandId is required";
                                break;
                            case (data.brandId && (0, markError_1.checkBrandId)(data.brandId) != ''):
                                message = (0, markError_1.checkBrandId)(data.brandId);
                                break;
                            case (sessData.type == 1 && (!data?.idaccount || data.idaccount == "" || data.idaccount == "null" || data.idaccount == "undefined")):
                                message = "Idaccount is required for admin";
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                        }
                        else {
                            let brandId = data.brandId;
                            let iduser = sessData.type == 1 ? data.idaccount : sessData.idaccount;
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT ba.brandId, ba.appealCategories, ba.explanation, ba.vetting_status,ba.vetting_status_update_at,ba.created_at,ef.uuid, ef.fileName, ef.key, ef.path,ef.mimeType FROM `brand_vetting_appeal`ba LEFT JOIN `evidence_files` ef ON ef.key=ba.key WHERE ba.`idaccount`=" + iduser + " AND ba.`brandId`='" + brandId + "' ORDER BY `created_at` DESC";
                            obj.prepare();
                            obj.execute((err, result) => {
                                if (err == 1) {
                                    if (result.length > 0) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ message: 'Brand Vetting Appeal Fatched Successfully!', data: result, status: 200 });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: "Brand Vetting Appeal Not Found!" });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something Went Wrong With Vetting Appeal Detail!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
    brandAppealCategory(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid2_22_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `appeal_category_name`,`appeal_category`,`explanation` FROM `brand_appeal_categories` WHERE `appeal_type`='0'";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                if (result.length > 0) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 200, message: "Brand Appeal Categories Fetched Successfully!", data: result });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Brand Appeal Categories Not Found!" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With get appeal category!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    brandVettingAppealCategory(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((error, sessdata) => {
            if (error == 1) {
                validuser.checksessionvalid2_22_201_202_203(req, res, sessdata, (err, dt) => {
                    if (err == 1) {
                        let obj = new RawQuery_1.ModelRawQuery(req, res);
                        obj.qrysql = "SELECT `appeal_category_name`,`appeal_category`,`explanation` FROM `brand_appeal_categories` WHERE `appeal_type`='1'";
                        obj.prepare();
                        obj.execute((_error, result) => {
                            if (_error == 1) {
                                if (result.length > 0) {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 200, message: "Vetting Appeal Categories Fetched Successfully!", data: result });
                                    objv.execute();
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ status: 502, message: "Vetting Appeal Categories Not Found!" });
                                    objv.execute();
                                }
                            }
                            else {
                                let objv = new RawView_1.RawView(res);
                                objv.prepare({ message: "Something Went Wrong With get vetting appeal category!", status: 502, error: result });
                                objv.execute();
                            }
                        });
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new _406_1.Res406(res);
                objv.prepare(session);
                objv.execute();
            }
        });
    }
    getAppealEvidence(req, res, next) {
        let session = new Session_1.SessionManagment(req, res, next);
        session.GetSession((sessErr, sessData) => {
            if (sessErr == 1) {
                validuser.checksessionvalid2_22_201_202_203(req, res, sessData, (err, dt) => {
                    if (err == 1) {
                        let sdata = req.query, data, message = "";
                        try {
                            data = JSON.parse(sdata);
                        }
                        catch {
                            data = sdata;
                        }
                        switch (true) {
                            case (!req.query || !('brandId' in req.query)):
                                message = "Missing request body";
                                break;
                            case ((0, markError_1.isMissing)(data.brandId)):
                                message = "brandId is required";
                                break;
                            case (data.brandId && (0, markError_1.checkBrandId)(data.brandId) != ''):
                                message = (0, markError_1.checkBrandId)(data.brandId);
                                break;
                            default:
                                message = "";
                        }
                        if (message) {
                            let objv = new RawView_1.RawView(res);
                            objv.prepare({ message: message, status: 502 });
                            objv.execute();
                        }
                        else {
                            let obj = new RawQuery_1.ModelRawQuery(req, res);
                            obj.qrysql = "SELECT uuid, fileName, `key`, `path`, `mimeType`,`evidence_type` FROM `evidence_files` WHERE  `brandId`='" + data.brandId + "'";
                            obj.prepare();
                            obj.execute((err, result) => {
                                if (err == 1) {
                                    if (result.length > 0) {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 200, message: 'Appeal File Fatched Successfully!', data: result });
                                        objv.execute();
                                    }
                                    else {
                                        let objv = new RawView_1.RawView(res);
                                        objv.prepare({ status: 502, message: 'Appeal File Not Found!' });
                                        objv.execute();
                                    }
                                }
                                else {
                                    let objv = new RawView_1.RawView(res);
                                    objv.prepare({ message: "Something went wrong with get appeal evidence!", status: 502 });
                                    objv.execute();
                                }
                            });
                        }
                    }
                    else {
                        let objv = new RawView_1.RawView(res);
                        objv.prepare(dt);
                        objv.execute();
                    }
                });
            }
            else {
                let objv = new RawView_1.RawView(res);
                objv.prepare({ message: "Invalid Authorization!", status: 401 });
                objv.execute();
            }
        });
    }
}
exports.SwaggerApi = SwaggerApi;
