<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends MY_controller {

	public function login()
	{
		$this->load->model('Auth_model');
		if($this->Auth_model->authorized()== true)
		{
			redirect(base_url('Auth/dashboard'));
		}
		$this->load->library('form_validation');
		$this->form_validation->set_rules('userName','User Name','required');
		$this->form_validation->set_rules('password','Password','required');
		if($this->form_validation->run() == true){
		           $email = $this->input->post('userName');
		           $user = $this->Auth_model->checkUser($email);

		           if (!empty($user)) {
		           	$password = md5($this->input->post('password'));
		           	if ($password == $user['password']) {
		           		
		           		
		           		$this->session->set_userdata('user',$user);
		           		redirect(base_url('Auth/dashboard'));		           		
		           	}else{
		           		$this->session->set_flashdata('msg','password is Incorrect.');
		           	redirect(base_url('Auth/login'));
		           	}
		           	
		           }else{
		           	$this->session->set_flashdata('msg','Username is Incorrect.');
		           	redirect(base_url('Auth/login'));

		           }

		}else{
			$this->load->view('login/auth-login');
		}
	}

	public function register(){
		$this->load->model('Auth_model');
		if($this->Auth_model->authorized() == true){
			redirect(base_url('Auth/dashboard'));
		}
		$this->load->library('form_validation');
		$this->form_validation->set_message('is_unique','User Name Already Exist Please Try Another');
		$this->form_validation->set_rules('userName', 'User Name','required|is_unique[users.userName]');

		 $userEmail = $this->input->post('userEmail');
		 if(!empty($userEmail)){
		 	$recd = $this->db->get_where('users', array('user_email =' => $userEmail))->result_array();
		 	if(!empty($recd)){
		 	  $this->form_validation->set_message('check_email','User Email Already Exist');
		 	  $this->form_validation->set_rules('userEmail', 'User Email','required|valid_email|check_email');

		 	}else{
		       $this->form_validation->set_rules('userEmail', 'User Email','required|valid_email');
		 	}
		 	// print_r($recd); die;

		 }else{
		$this->form_validation->set_rules('userEmail', 'User Email','required|valid_email');
		 }
		$this->form_validation->set_rules('password', 'Password','required');
		$this->form_validation->set_rules('mobileNo', 'Mobile No.','required');

		if($this->form_validation->run() == false){
			$this->load->view('login/auth-register');
		}else{
			$formArray = array();
			$formArray['username'] = $this->input->post('userName');
			$formArray['user_email'] = $this->input->post('userEmail');
		    $formArray['password'] =md5($this->input->post('password'));
			$formArray['mobile_no'] = $this->input->post('mobileNo');
			$this->Auth_model->create($formArray);

			$this->session->set_flashdata('msg','Your Account Has Been Created Successfully.');
			redirect(base_url('Auth/register'));
		}
	}

	public function forget_pwd(){
		$this->load->model('Auth_model');
		if($this->Auth_model->authorized()==true){
			redirect(base_url('Auth/dashboard'));
		}
			$this->load->library('form_validation');
			$this->form_validation->set_rules('userEmail','User Email', 'required|valid_email');

			
			if($this->form_validation->run() == false){
                 $this->load->view('login/forget_pwd');
				
			}else{
				$user_email = $this->input->post('userEmail');
				   $recd = $this->db->get_where('users', array('user_email =' => $user_email))->result_array();
				   // echo "<pre>";
				   // print_r($recd[0]['id']); die;
				   $id = $recd[0]['id'];
					$message='';
				$emailsend = 'noreply@sfglife.com';
				$message.= "<p>Hi,<br/> Click On the link Mention below For Changing Your Password <br/> Change Password:- <a href='".base_url('Auth/change_pwd/'.$id)."' >Change Password</a>  <br/> <br/> Thank you <br/>  </p>";

				
				// sendMail('',$user_email,'Forget Password',$message,'Forget Password');
				$selectedTime = date('H:i:s');
					$expire_time_sec = strtotime("+2 minutes", strtotime($selectedTime));
					$expire_time = date('Y-m-d H:i:s', $expire_time_sec);

					$formData = array('valid_time_pwd' => $expire_time);
					$this->Auth_model->update_user($id, $formData);
					// echo $expire_time; die;

				print_r($message); die;

			}

	}

	function change_pwd($id){
		$this->load->model('Auth_model');
		 $user_data = $this->db->get_where('users', array('id =' => $id))->result_array();
		 $data['user_details'] = $user_data[0]; 
		$data['id'] = $id;

		if($this->Auth_model->authorized()==true){
			redirect(base_url('Auth/dashboard'));
		}else{
			$this->load->library('form_validation');
				$this->form_validation->set_rules('password', 'Password','required');
				$this->form_validation->set_rules('conf_password', 'Confirm Password','required|matches[password]');

				if($this->form_validation->run() == false){
					$this->load->view('login/change_pwd',$data);
				}else{
					// print_r($_POST); die;
					
					$data_id = $this->input->post('data_id');
					$formData = array('password' => md5($this->input->post('password')),'updated_at' => date("Y-m-d H:i:s"));
					$this->Auth_model->update_user($data_id, $formData);
						$this->session->set_flashdata('msg','Password Change Successfully');
							redirect(base_url('Auth/login'));

				}

		}
	}

	function dashboard(){
		$this->load->model('Auth_model');
		if($this->Auth_model->authorized() == false){
			$this->session->set_flashdata('msg','You Are Not Authorized To Access This Section.');
			redirect(base_url('Auth/login'));
		}
		$user = $this->session->userdata('user');
		$data['user'] = $user;
		$this->pageload('dashboard/index',$data);
	} 

	function logout(){
		$this->session->unset_userdata('user');
		redirect(base_url('Auth/login')); 
	}

	public function api()
	{
		$this->load->model('Auth_model');
		$user = $this->session->userdata('user');
		$data['user'] = $user;
		$id = $data['user']['id'];
		$data['apidata'] = $this->Auth_model->getapidata($id);
		$this->pageload('api',$data);	
	}
	
	public function api_credential()
	{
		$this->load->model('Auth_model');
		$user = $this->session->userdata('user');
		$data['user'] = $user;
		$id = $data['user']['id'];
		$user_email = $data['user']['user_email'];
		$name =  explode('@', $user_email);
		$username = $name[0];
		if($id)
		{
			$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
			$randusername  = substr(str_shuffle($characters),0,4);
			
			$chars = date('ymdhs')."abc$%defghijk!@#$%lmno%&*#$@pqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
			$randpassword = substr(str_shuffle($chars),0,8);	
	    	$pass_encoded = base64_encode($randpassword);

			$apidata = array(
				'apiusername'=> $username.$randusername,
				'apipassword'=> $pass_encoded
			);

			$result = $this->Auth_model->apiupdate($id, $apidata);
			if($result){
				$this->session->set_flashdata('msg','API Credential updated Successfully');

			}else{
				$this->session->set_flashdata('msg','API Credential not updated');
				
			}
		}
		redirect('Auth/api');
	}
}
