<?php 
defined('BASEPATH')OR exit('No direct script access allowed');

/**
 * 
 */
class Charges extends CI_Controller
{
    protected $__user_id;

    protected $__username;

    protected $__password;

    protected $__client_id;

    protected $__client_profile_id;

    protected $__db2;

    function __construct()
    {
        parent::__construct();
        $this->load->model('base_model');
        
        if (isset($_SERVER['HTTP_ORIGIN'])) 
        {
            header("Access-Control-Allow-Origin: *");
            header("Access-Control-Allow-Credentials: true");
            header("Access-Control-Max-Age: 86400");
        }

        if ($_SERVER['REQUEST_METHOD']=='OPTIONS')
        {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE, PATCH");         

                if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                    header("Access-Control-Allow-Headers:{$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
                exit(0);
            }
        }

        if (empty($this->session->userdata('token')))
        {
            header("Content-type: application/json");
            echo json_encode([
                'result'=>'',
                'message'=>'No Token Provided',
                'error'=>1
            ]);
            exit;
        }

        //Staging API
        $this->__auth_token ='Basic dmlrYXNAZ3ZlbnR1cmUubmV0OmshR3BBdDNKNU5GTUt3UA==';        
        $this->__username = 'vikas@gventure.net';
        $this->__password = 'k!GpAt3J5NFMKwP';
        $this->__client_id = 2221;
        $this->__client_profile_id = 1;
        $this->__baseUrl = "https://communicationsua.avalara.net/api/v2/";

        //Production API
        /* $this->__auth_token ='Basic YXBpQHNpZ25hbG1hc2guY29tOllQRjFteGQ0bWVjLXlhajh1eHc=';
        $this->__username = 'api@signalmash.com';
        $this->__password = 'YPF1mxd4mec-yaj8uxw';
        $this->__client_id = 2221;
        $this->__client_profile_id = 1; 
        $this->__baseUrl = "https://communications.avalara.net/api/v2/"; */

        $this->__user_id = $this->session->userdata('userdata')['id'] ? $this->session->userdata('userdata')['id'] : 0;

        $this->__db2 = $this->load->database('signalmash_prod2_db', TRUE);
    }

    public function index()
    {
        echo "Avalara tax calculation API v1.0";
    }

    public function cal_taxaxtion()
    {
        $url=$this->__baseUrl.'afc/CalcTaxes';
        $ch = curl_init();
        $ch2 = curl_init();
        
        $post_data1=file_get_contents('php://input');

        if ($post_data1)
        {
            $post_data=json_decode($post_data1, true);
        }
        else
        {
            $post_data=$_POST;
        }
        //print_r($post_data);
        //if (empty($post_data['itms'][0]['type']))
        if (empty($post_data['itms'][0]['type'])||empty($post_data['itms'][1]['type'])||empty($post_data['itms'][2]['type'])||empty($post_data['itms'][3]['type'])||empty($post_data['itms'][4]['type'])||empty($post_data['itms'][5]['type'])||empty($post_data['itms'][6]['type'])||empty($post_data['itms'][7]['type'])||empty($post_data['itms'][8]['type'])||empty($post_data['itms'][9]['type'])||empty($post_data['itms'][10]['type'])||empty($post_data['itms'][11]['type'])||empty($post_data['itms'][12]['type'])||empty($post_data['itms'][13]['type'])||empty($post_data['itms'][14]['type']))
        {
            header("Content-type: application/json");
            echo json_encode([
                'result'=>'',
                'message'=>'One or more line item missing, please check again!',
                'error'=>1
            ]);
            exit;
        }
        else
        {
            $package = [];
            $__package2 = [];

            foreach ($post_data['itms'] as  $value) 
            {
                if($value['type']=='mrc_nn')
                {
                    $mrc_nn = array(
                        'ref' =>'Line Item 1 (MRC Local Number)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'mrc_nn'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>59,
                        'serv'=>577
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $mrc_nn);
                }
                elseif($value['type']=='mrc_tf')
                {
                    $mrc_tf = array(
                        'ref' =>'Line Item 2 (MRC Tollfree Number)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'mrc_tf'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>59,
                        'serv'=>577
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $mrc_tf);
                }
                elseif($value['type']=='camp_mrc')
                {
                    $camp_mrc = array(
                        'ref' =>'Line Item 3 (MRC Campaign)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'camp_mrc'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>24,
                        'serv'=>636
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $camp_mrc);
                }
                elseif($value['type']=='obcall_usatier')
                {
                    $obcall_usatier = array(
                        'ref' =>'Line Item 4 (OB USA Tier Call)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'obcall_usatier'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>20000,
                        'serv'=>20001
                    );
                    if(intval($value['quantity'])>0)
                        array_push($__package2, $obcall_usatier);
                }
                elseif($value['type']=='obcall_tollfree')
                {
                    $obcall_tollfree = array(
                        'ref' =>'Line Item 5 (ON Tollfree Call)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'obcall_tollfree'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>20000,
                        'serv'=>20001
                    );
                    if(intval($value['quantity'])>0)
                        array_push($__package2, $obcall_tollfree);
                }
                
                elseif($value['type']=='ibcall_usatier')
                {
                    $ibcall_usatier = array(
                        'ref' =>'Line Item 6 (IB USA Tier Call)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'ibcall_usatier'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>20000,
                        'serv'=>20001
                    );
                    if(intval($value['quantity'])>0)
                        array_push($__package2, $ibcall_usatier);
                }
                elseif($value['type']=='ibcall_tollfree')
                {
                    $ibcall_tollfree = array(
                        'ref' =>'Line Item 7 (IB Tollfree Call)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'ibcall_tollfree'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>20000,
                        'serv'=>20001
                    );
                    if(intval($value['quantity'])>0)
                        array_push($__package2, $ibcall_tollfree);
                }            
                elseif($value['type']=='sms_ibtc')
                {
                    $sms_ibtc = array(
                        'ref' =>'Line Item 8 (SMS IB Transaction)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'sms_ibtc'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>24,
                        'serv'=>636
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $sms_ibtc);
                }
                elseif($value['type']=='sms_ibsr')
                {
                    $sms_ibsr = array(
                        'ref' =>'Line Item 9 (SMS IB Surcharge)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'sms_ibsr'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>24,
                        'serv'=>636
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $sms_ibsr);
                }
                elseif($value['type']=='sms_obtc')
                {
                    $sms_obtc = array(
                        'ref' =>'Line Item 10 (SMS OB Transaction)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'sms_obtc'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>24,
                        'serv'=>636
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $sms_obtc);
                }
                elseif($value['type']=='sms_obsr')
                {
                    $sms_obsr = array(
                        'ref' =>'Line Item 11 (SMS OB Surcharge)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'sms_obsr'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>24,
                        'serv'=>636
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $sms_obsr);
                }
                elseif($value['type']=='nca_nn')
                {
                    $nca_nn = array(
                        'ref' =>'Line Item 12 (NRC Local Number)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'nca_nn'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>59,
                        'serv'=>577
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $nca_nn);
                }
                elseif($value['type']=='nca_tf')
                {
                    $nca_tf = array(
                        'ref' =>'Line Item 13 (NRC Tollfree Number)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'nca_tf'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>59,
                        'serv'=>577
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $nca_tf);
                }
                
                elseif($value['type']=='a2ppac_nrcbrnd')
                {
                    $a2ppac_nrcbrnd = array(
                        'ref' =>'Line Item 14 (NRC Brand)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'a2ppac_nrcbrnd'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>24,
                        'serv'=>636
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $a2ppac_nrcbrnd);
                }
                elseif($value['type']=='a2ppac_nrcmp')
                {
                    $a2ppac_nrcmp = array(
                        'ref' =>'Line Item 15 (NRC Campaign)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'a2ppac_nrcmp'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>24,
                        'serv'=>636
                    );
                    if(intval($value['quantity'])>0)
                        array_push($package, $a2ppac_nrcmp);
                }
                elseif($value['type']=='subs')
                {
                    $subscription = array(
                        'ref' =>'Line Item 16 (Subscription)',
                        'chg'=> $value['amount'],
                        'line'=> 0,
                        'sale'=> 1,
                        'subscription'=> intval($value['quantity']),
                        'incl'=>false,
                        'proadj'=> 0,
                        'tran'=>20000,
                        'serv'=>20003
                    );
                    if(intval($value['quantity'])>0)
                        array_push($__package2, $subscription);
                }
            }
            // @unique document code
            // $__document = uniqid("doc_{$this->__user_id}_");
            $__document = $post_data['document'];
            $__account_ref = isset($post_data['account_ref']) && $post_data['account_ref'] ? $post_data['account_ref'] : 0;
            $__customer_ref = isset($post_data['customer_ref']) && $post_data['customer_ref'] ? $post_data['customer_ref'] : '';

            // $package=array($software,$sms,$minute,$callerid,$voicemail,$lines);
            $__taxes = new stdClass();
            $__taxes->sales_tax = 0.00; // 1-Sales and Use Taxes
            $__taxes->bussiness_tax = 0.00; // 2-Business Taxes
            $__taxes->grt_tax = 0.00; // 3-Gross Receipts Taxes
            $__taxes->excise_tax = 0.00; // 4-Excise Taxes
            $__taxes->ucf_tax = 0.00; // 5-Connectivity Charges
            $__taxes->fcc_tax = 0.00; // 6-Regulatory Charges
            $__taxes->e911_tax = 0.00; // 7-E-911 Charges
            $__taxes->utility_user_tax = 0.00;   // 8-Utility User Taxes
            $__taxes->rwf_tax = 0.00;            // 9-Right of Way Fees
            $__taxes->comm_service_tax = 0.00;          // 10-Communications Services Tax
            $__taxes->crf_tax = 0.00;            // 11-Cable Regulatory Fees
            $__taxes->reserve_tax = 0.00;        // 12-Reserved
            $__taxes->va_tax = 0.00;             // 13-Value Added Taxes

            $__taxes->all_tax_sum = 0.00;             // for sum of all taxes 

            /*
            * It is For Packege 1 (Start)
            */  
            $result = "{}";
            if(isset($package) && count($package) > 0){
                $pack=json_encode($package);

                $postedArr='{"cmpn": {"bscl": 1,"svcl": 1,"fclt":false,"frch":false,"reg": false  },
                "inv": [{"doc": "'.$__document.'","cmmt":false,
                "bill": {"ctry":"'.$post_data['country'].'", "pcd": '.$post_data['pcode'].', "city":"'.$post_data['city'].'", "st": "'.$post_data['state'].'", "zip": "'.$post_data['zip'].'" },
                "cust": 1,"date":"'.$post_data['date'].'", "itms":'.$pack.', "acct":"'.$__account_ref.'", "custref":"'.$__customer_ref.'"}]}';
                // ,"from": {"pcd":"'.$post_data['pcode'].'"}
                //print_r($postedArr);
                $request_arr=json_decode($postedArr);
                   
                if(!empty($request_arr))
                {
                    $cmpn = $request_arr->cmpn;

                    $cmp_ins = $this->db->insert('tbl_request',[
                        'user_id'=>  $this->__user_id,
                        'country' =>  $post_data['country'],
                        'state' =>   $post_data['state'],
                        'city' =>  $post_data['city'],
                        'zip' =>   $post_data['zip'],
                        'document_code'=> $__document,
                        'billing_status'=>  'pending',
                        'itms'=>  $pack,
                        'business_class' =>  $cmpn->bscl,
                        'service_class' =>  $cmpn->svcl,
                        'facilities' =>  $cmpn->fclt,
                        'franchise' =>  $cmpn->frch,
                        'regulated' =>  $cmpn->reg,
                        'account_ref'=>  $__account_ref,
                        'customer_ref'=>  $__customer_ref,
                        'created_at'=> date('Y-m-d H:i:s')
                    ]);

                    $last_id= $this->db->insert_id();

                    // @saving tax items
                    if (count($package) > 0) {
                        foreach ($package as $row) {
                            $this->db->insert('tbl_request_items', [
                                'user_id'=>  $this->__user_id,
                                'request_id'=>  $last_id,
                                'reference' => $row['ref'],
                                'charge' => $row['chg'],
                                'line' => $row['line'],
                                'sale' => $row['sale'],
                                'inclusive' => $row['incl'],
                                'proadj' => $row['proadj'],
                                'transaction' => $row['tran'],
                                'service' => $row['serv'],
                                'created_at' => date('Y-m-d H:i:s')
                            ]);
                        }
                    }

                    $inv = $request_arr->inv;

                    if(!empty($inv))
                    {
                        $inv_key = array_keys($inv);
                        for ($i=0; $i < count($inv); $i++)
                        {
                            $inv_data = $inv[$inv_key[$i]];
                            $bill = $inv_data->bill;
                            $cust = $inv_data->cust;
                            $date = $inv_data->date;

                            $this->db->where('id', $last_id);
                            $this->db->update('tbl_request', array(
                                'country_req' => $bill->ctry,
                                'state_req' => $bill->st,
                                'city_req' => $bill->city,
                                'zip_req' => $bill->zip,
                                'customer_type' => $cust,
                                'date' => $date
                            ));

                            $itms = $inv_data->itms;

                            if(!empty($itms))
                            {
                                $itms_key = array_keys($itms);
                                for($a=0; $a < count($itms); $a++)
                                {
                                    $itms_data = $itms[$itms_key[$i]];
                                    
                                    $this->db->where('id', $last_id);
                                    $this->db->update('tbl_request', array(
                                        'price_req' => $itms_data->chg,
                                        'sale' => $itms_data->sale,
                                        'transaction_type' => $itms_data->tran,
                                        'service_type' => $itms_data->serv
                                    ));
                                }
                            }
                        }
                    }
                }
                //'.$post_data['pcode'].'
                // $headers = array('client_id: '.$this->__client_id.'','client_profile_id: '.$this->__client_profile_id.'','Content-Type: application/json','Authorization: '.$this->__auth_token.'');
                $headers = array("client_id: {$this->__client_id}","client_profile_id: {$this->__client_profile_id}","Content-Type: application/json","Authorization: {$this->__auth_token}");
                $post_type='POST';
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $post_type);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_POSTFIELDS,$postedArr);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
                //curl_setopt($ch, CURLOPT_USERPWD, "$this->__username:$this->__password");
                $result = curl_exec($ch);

                curl_close($ch);
                $responseArray =json_decode($result,true);
                
                if (!empty($responseArray))
                {
                    $responseitmsErr = isset($responseArray['inv'][0]['err']) ? TRUE : FALSE;
                    if($responseitmsErr) {
                        header("Content-type: application/json");
                        echo json_encode([
                            'result'=> $responseArray['inv'][0]['err'],
                            'message'=>'Address Not Found',
                            'error'=>1
                        ]);
                    }
                    else {
                        $reskey =array_keys($responseArray);
                        for($a = 0; $a < count($responseArray); $a++)
                        {
                            $invdata = $responseArray[$reskey[$a]];
                            if (!empty($invdata))
                            {
                                $invArkey = array_keys($invdata);
                                for($b = 0; $b < count($invdata); $b++)
                                {
                                    $responseitms = $invdata[$invArkey[$b]]['itms'];
                                    if (!empty($responseitms))
                                    {
                                        $itmsArKey = array_keys($responseitms);
                                        for($c = 0; $c < count($responseitms); $c++)
                                        {
                                            $responseTxs = $responseitms[$itmsArKey[$c]]['txs'];
                                            if (!empty($responseTxs))
                                            {
                                                $txsKey = array_keys($responseTxs);
                                                for($d = 0; $d < count($responseTxs); $d++)
                                                {
                                                    // print_r($responseTxs[$txsKey[$d]]);die;
                                                    $invTxsArData = $this->db->insert('tbl_response',[
                                                        'user_id'=>  $this->__user_id,
                                                        'request_id'  =>  $last_id,
                                                        'bill_to_location' =>  $responseTxs[$txsKey[$d]]['bill'],
                                                        'compliance' =>  $responseTxs[$txsKey[$d]]['cmpl'],
                                                        'taxable_measure' =>  $responseTxs[$txsKey[$d]]['tm'],
                                                        'calculation' =>  $responseTxs[$txsKey[$d]]['calc'],
                                                        'tax_category' =>  $responseTxs[$txsKey[$d]]['cat'],
                                                        'tax_category_id' =>  $responseTxs[$txsKey[$d]]['cid'],
                                                        'tax_name' =>  $responseTxs[$txsKey[$d]]['name'],
                                                        'exempt_sale_amount' =>  $responseTxs[$txsKey[$d]]['exm'],
                                                        'num_line_tax' =>  $responseTxs[$txsKey[$d]]['lns'],
                                                        'min_tax' =>  $responseTxs[$txsKey[$d]]['min'],
                                                        'p_code' =>  $responseTxs[$txsKey[$d]]['pcd'],
                                                        'tax_rate' =>  $responseTxs[$txsKey[$d]]['rate'],
                                                        'sur_charge' =>  $responseTxs[$txsKey[$d]]['sur'],
                                                        'tax' =>  $responseTxs[$txsKey[$d]]['tax'],
                                                        'tax_level' =>  $responseTxs[$txsKey[$d]]['lvl'],
                                                        'tax_type_id' =>  $responseTxs[$txsKey[$d]]['tid'],
                                                        'created_on'=> date('Y-m-d H:i:s')
                                                    ]);
                                                    $invTxsArDataNew = $this->__db2->insert('invoice_tax',[
                                                        'idaccount'=>  $post_data['account_ref'],
                                                        'idinvoice'=>  $post_data['idinvoice'],
                                                        'bill_to_location' =>  $responseTxs[$txsKey[$d]]['bill'],
                                                        'compliance' =>  $responseTxs[$txsKey[$d]]['cmpl'],
                                                        'taxable_measure' =>  $responseTxs[$txsKey[$d]]['tm'],
                                                        'calculation' =>  $responseTxs[$txsKey[$d]]['calc'],
                                                        'tax_category' =>  $responseTxs[$txsKey[$d]]['cat'],
                                                        'tax_category_id' =>  $responseTxs[$txsKey[$d]]['cid'],
                                                        'tax_name' =>  $responseTxs[$txsKey[$d]]['name'],
                                                        'exempt_sale_amount' =>  $responseTxs[$txsKey[$d]]['exm'],
                                                        'num_line_tax' =>  $responseTxs[$txsKey[$d]]['lns'],
                                                        'min_tax' =>  $responseTxs[$txsKey[$d]]['min'],
                                                        'p_code' =>  $responseTxs[$txsKey[$d]]['pcd'],
                                                        'tax_rate' =>  $responseTxs[$txsKey[$d]]['rate'],
                                                        'sur_charge' =>  $responseTxs[$txsKey[$d]]['sur'],
                                                        'tax' =>  $responseTxs[$txsKey[$d]]['tax'],
                                                        'tax_level' =>  $responseTxs[$txsKey[$d]]['lvl'],
                                                        'tax_type_id' =>  $responseTxs[$txsKey[$d]]['tid']
                                                    ]);
        
                                                    // @to calculate 1-Sales and Use Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 1) {
                                                        $__taxes->sales_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 2-Business Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 2) {
                                                        $__taxes->bussiness_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 3-Gross Receipts Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 3) {
                                                        $__taxes->grt_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 4-Excise Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 4) {
                                                        $__taxes->excise_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }

                                                    // @to calculate 5-Connectivity Charges
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 5) {
                                                        $__taxes->ucf_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 6-Regulatory Charges
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 6) {
                                                        $__taxes->fcc_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 7-E-911 Charges
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 7) {
                                                        $__taxes->e911_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 8-Utility User Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 8) {
                                                        $__taxes->utility_user_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }

                                                    // @to calculate 9-Right of Way Fees
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 9) {
                                                        $__taxes->rwf_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 10-Communications Services Tax
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 10) {
                                                        $__taxes->comm_service_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 11-Cable Regulatory Fees
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 11) {
                                                        $__taxes->crf_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 12-Reserved
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 12) {
                                                        $__taxes->reserve_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }

                                                    // @to calculate 13-Value Added Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 13) {
                                                        $__taxes->reserve_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
                                                    if($responseTxs[$txsKey[$d]]['cid']){
                                                        $__taxes->all_tax_sum += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                else
                {
                    header("Content-type: application/json");
                    echo json_encode([
                        'result'=>'',
                        'message'=>'No Records Found',
                        'error'=>1
                    ]);
                    exit;
                }
            }
            /*
            * It is For Packege 1 (End)
            */
            /*
            * It is For Packege 2 (Start)
            */ 
            $result2 = "{}";
            if(isset($__package2) && count($__package2) > 0){
                $__pack2=json_encode($__package2);
               
                $postedArr2='{"cmpn": {"bscl": 1,"svcl": 1,"fclt":false,"frch":false,"reg": false  },
                "inv": [{"doc": "'.$__document.'","cmmt":false,
                "bill": {"ctry":"'.$post_data['country'].'", "pcd": '.$post_data['pcode'].', "city":"'.$post_data['city'].'", "st": "'.$post_data['state'].'", "zip": "'.$post_data['zip'].'" },
                "cust": 1,"date":"'.$post_data['date'].'", "itms":'.$__pack2.', "acct":"'.$__account_ref.'", "custref":"'.$__customer_ref.'"}]}';

                //print_r($postedArr);
                $request_arr2=json_decode($postedArr2);

                if(!empty($request_arr2))
                {
                    $cmpn = $request_arr2->cmpn;

                    $cmp_ins = $this->db->insert('tbl_request',[
                        'user_id'=>  $this->__user_id,
                        'country' =>  $post_data['country'],
                        'state' =>   $post_data['state'],
                        'city' =>  $post_data['city'],
                        'zip' =>   $post_data['zip'],
                        'document_code'=> $__document,
                        'billing_status'=>  'pending',
                        'itms'=>  $__pack2,
                        'business_class' =>  $cmpn->bscl,
                        'service_class' =>  $cmpn->svcl,
                        'facilities' =>  $cmpn->fclt,
                        'franchise' =>  $cmpn->frch,
                        'regulated' =>  $cmpn->reg,
                        'account_ref'=>  $__account_ref,
                        'customer_ref'=>  $__customer_ref,
                        'created_at'=> date('Y-m-d H:i:s')
                    ]);

                    $last_id= $this->db->insert_id();

                    // @saving tax items
                    if (count($__package2) > 0) {
                        foreach ($__package2 as $row) {
                            $this->db->insert('tbl_request_items', [
                                'user_id'=>  $this->__user_id,
                                'request_id'=>  $last_id,
                                'reference' => $row['ref'],
                                'charge' => $row['chg'],
                                'line' => $row['line'],
                                'sale' => $row['sale'],
                                'inclusive' => $row['incl'],
                                'proadj' => $row['proadj'],
                                'transaction' => $row['tran'],
                                'service' => $row['serv'],
                                'created_at' => date('Y-m-d H:i:s')
                            ]);
                        }
                    }

                    $inv = $request_arr2->inv;

                    if(!empty($inv))
                    {
                        $inv_key = array_keys($inv);
                        for ($i=0; $i < count($inv); $i++)
                        {
                            $inv_data = $inv[$inv_key[$i]];
                            $bill = $inv_data->bill;
                            $cust = $inv_data->cust;
                            $date = $inv_data->date;

                            $this->db->where('id', $last_id);
                            $this->db->update('tbl_request', array(
                                'country_req' => $bill->ctry,
                                'state_req' => $bill->st,
                                'city_req' => $bill->city,
                                'zip_req' => $bill->zip,
                                'customer_type' => $cust,
                                'date' => $date
                            ));

                            $itms = $inv_data->itms;

                            if(!empty($itms))
                            {
                                $itms_key = array_keys($itms);
                                for($a=0; $a < count($itms); $a++)
                                {
                                    $itms_data = $itms[$itms_key[$i]];
                                    
                                    $this->db->where('id', $last_id);
                                    $this->db->update('tbl_request', array(
                                        'price_req' => $itms_data->chg,
                                        'sale' => $itms_data->sale,
                                        'transaction_type' => $itms_data->tran,
                                        'service_type' => $itms_data->serv
                                    ));
                                }
                            }
                        }
                    }
                }
                //echo "Request 2 \n";
                //print_r($postedArr2); echo "\n";
                //$__headers2 = array('client_id: '.$this->__client_id.'','client_profile_id: '.$this->__client_profile_id.'','Content-Type: application/json','Authorization: '.$this->__auth_token.'','client_profile_id: 1');
                $__headers2 = array("client_id: {$this->__client_id}","client_profile_id: {$this->__client_profile_id}","Content-Type: application/json","Authorization: {$this->__auth_token}");
                $post_type='POST';
                curl_setopt($ch2, CURLOPT_URL, $url);
                curl_setopt($ch2, CURLOPT_CUSTOMREQUEST, $post_type);
                curl_setopt($ch2, CURLOPT_HTTPHEADER, $__headers2);
                curl_setopt($ch2, CURLOPT_POSTFIELDS,$postedArr2);
                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch2, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
                //curl_setopt($ch2, CURLOPT_USERPWD, "$this->__username:$this->__password");
                $result2 = curl_exec($ch2);
               
                curl_close($ch2);
                $responseArray2 =json_decode($result2,true);
                //echo "Response 2 \n";
                //print_r($result2); echo "\n";
                if (!empty($responseArray2))
                {
                    
                    $responseitmsErr2 = isset($responseArray2['inv'][0]['err']) ? TRUE : FALSE;
                    if($responseitmsErr2 == TRUE) {
                        //print_r($responseArray2['inv'][0]['err']);
                        header("Content-type: application/json");
                        echo json_encode([
                            'result'=> $responseArray2['inv'][0]['err'],
                            'message'=>'Address Not Found',
                            'error'=>1
                        ]);
                    }
                    else {
                        $reskey =array_keys($responseArray2);
                        for($a = 0; $a < count($responseArray2); $a++)
                        {
                            $invdata = $responseArray2[$reskey[$a]];
                            if (!empty($invdata))
                            {
                                $invArkey = array_keys($invdata);
                                for($b = 0; $b < count($invdata); $b++)
                                {
                                    $responseitms = $invdata[$invArkey[$b]]['itms'];
                                    if (!empty($responseitms))
                                    {
                                        $itmsArKey = array_keys($responseitms);
                                        for($c = 0; $c < count($responseitms); $c++)
                                        {
                                            $responseTxs = $responseitms[$itmsArKey[$c]]['txs'];
                                            if (!empty($responseTxs))
                                            {
                                                $txsKey = array_keys($responseTxs);
                                                for($d = 0; $d < count($responseTxs); $d++)
                                                {
                                                    // print_r($responseTxs[$txsKey[$d]]);die;
                                                    $invTxsArData = $this->db->insert('tbl_response',[
                                                        'user_id'=>  $this->__user_id,
                                                        'request_id'  =>  $last_id,
                                                        'bill_to_location' =>  $responseTxs[$txsKey[$d]]['bill'],
                                                        'compliance' =>  $responseTxs[$txsKey[$d]]['cmpl'],
                                                        'taxable_measure' =>  $responseTxs[$txsKey[$d]]['tm'],
                                                        'calculation' =>  $responseTxs[$txsKey[$d]]['calc'],
                                                        'tax_category' =>  $responseTxs[$txsKey[$d]]['cat'],
                                                        'tax_category_id' =>  $responseTxs[$txsKey[$d]]['cid'],
                                                        'tax_name' =>  $responseTxs[$txsKey[$d]]['name'],
                                                        'exempt_sale_amount' =>  $responseTxs[$txsKey[$d]]['exm'],
                                                        'num_line_tax' =>  $responseTxs[$txsKey[$d]]['lns'],
                                                        'min_tax' =>  $responseTxs[$txsKey[$d]]['min'],
                                                        'p_code' =>  $responseTxs[$txsKey[$d]]['pcd'],
                                                        'tax_rate' =>  $responseTxs[$txsKey[$d]]['rate'],
                                                        'sur_charge' =>  $responseTxs[$txsKey[$d]]['sur'],
                                                        'tax' =>  $responseTxs[$txsKey[$d]]['tax'],
                                                        'tax_level' =>  $responseTxs[$txsKey[$d]]['lvl'],
                                                        'tax_type_id' =>  $responseTxs[$txsKey[$d]]['tid'],
                                                        'created_on'=> date('Y-m-d H:i:s')
                                                    ]);
                                                    $invTxsArDataNew = $this->__db2->insert('invoice_tax',[
                                                        'idaccount'=>  $post_data['account_ref'],
                                                        'idinvoice'=>  $post_data['idinvoice'],
                                                        'bill_to_location' =>  $responseTxs[$txsKey[$d]]['bill'],
                                                        'compliance' =>  $responseTxs[$txsKey[$d]]['cmpl'],
                                                        'taxable_measure' =>  $responseTxs[$txsKey[$d]]['tm'],
                                                        'calculation' =>  $responseTxs[$txsKey[$d]]['calc'],
                                                        'tax_category' =>  $responseTxs[$txsKey[$d]]['cat'],
                                                        'tax_category_id' =>  $responseTxs[$txsKey[$d]]['cid'],
                                                        'tax_name' =>  $responseTxs[$txsKey[$d]]['name'],
                                                        'exempt_sale_amount' =>  $responseTxs[$txsKey[$d]]['exm'],
                                                        'num_line_tax' =>  $responseTxs[$txsKey[$d]]['lns'],
                                                        'min_tax' =>  $responseTxs[$txsKey[$d]]['min'],
                                                        'p_code' =>  $responseTxs[$txsKey[$d]]['pcd'],
                                                        'tax_rate' =>  $responseTxs[$txsKey[$d]]['rate'],
                                                        'sur_charge' =>  $responseTxs[$txsKey[$d]]['sur'],
                                                        'tax' =>  $responseTxs[$txsKey[$d]]['tax'],
                                                        'tax_level' =>  $responseTxs[$txsKey[$d]]['lvl'],
                                                        'tax_type_id' =>  $responseTxs[$txsKey[$d]]['tid']
                                                    ]);

                                                    // @to calculate 1-Sales and Use Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 1) {
                                                        $__taxes->sales_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 2-Business Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 2) {
                                                        $__taxes->bussiness_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 3-Gross Receipts Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 3) {
                                                        $__taxes->grt_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 4-Excise Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 4) {
                                                        $__taxes->excise_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }

                                                    // @to calculate 5-Connectivity Charges
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 5) {
                                                        $__taxes->ucf_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 6-Regulatory Charges
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 6) {
                                                        $__taxes->fcc_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 7-E-911 Charges
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 7) {
                                                        $__taxes->e911_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 8-Utility User Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 8) {
                                                        $__taxes->utility_user_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }

                                                    // @to calculate 9-Right of Way Fees
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 9) {
                                                        $__taxes->rwf_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 10-Communications Services Tax
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 10) {
                                                        $__taxes->comm_service_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 11-Cable Regulatory Fees
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 11) {
                                                        $__taxes->crf_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
        
                                                    // @to calculate 12-Reserved
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 12) {
                                                        $__taxes->reserve_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }

                                                    // @to calculate 13-Value Added Taxes
                                                    if ($responseTxs[$txsKey[$d]]['cid'] == 13) {
                                                        $__taxes->reserve_tax += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
                                                    if($responseTxs[$txsKey[$d]]['cid']){
                                                        $__taxes->all_tax_sum += $responseTxs[$txsKey[$d]]['tax'];
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                else
                {
                    header("Content-type: application/json");
                    echo json_encode([
                        'result'=>'',
                        'message'=>'No Records Found For Calling',
                        'error'=>1
                    ]);
                    exit;
                }
            }
            /*
            * It is For Packege 2 (End)
            */  
            // @formatting all over taxes
            $__taxes->sales_tax = number_format((float)$__taxes->sales_tax, 2, '.', '');
            $__taxes->bussiness_tax = number_format((float)$__taxes->bussiness_tax, 2, '.', '');
            $__taxes->grt_tax = number_format((float)$__taxes->grt_tax, 2, '.', '');
            $__taxes->excise_tax = number_format((float)$__taxes->excise_tax, 2, '.', '');
            $__taxes->ucf_tax = number_format((float)$__taxes->ucf_tax, 2, '.', '');
            $__taxes->fcc_tax = number_format((float)$__taxes->fcc_tax, 2, '.', '');
            $__taxes->e911_tax = number_format((float)$__taxes->e911_tax, 2, '.', '');
            $__taxes->utility_user_tax = number_format((float)$__taxes->utility_user_tax, 2, '.', '');
            $__taxes->rwf_tax = number_format((float)$__taxes->rwf_tax, 2, '.', '');
            $__taxes->comm_service_tax = number_format((float)$__taxes->comm_service_tax, 2, '.', '');
            $__taxes->crf_tax = number_format((float)$__taxes->crf_tax, 2, '.', '');
            $__taxes->reserve_tax = number_format((float)$__taxes->reserve_tax, 2, '.', '');
            $__taxes->va_tax = number_format((float)$__taxes->va_tax, 2, '.', '');
           
            $__taxes->all_tax_sum = number_format((float)$__taxes->all_tax_sum, 2, '.', '');

            //header("Content-type: application/json");
            echo json_encode([
                'result'=>$__taxes,
                'message'=>'CalcTaxes success !',
                'error'=>0
            ]);
            exit;           
        }
    }

    public function commit_tax_transactions()
    {
        $url=$this->__baseUrl.'afc/Commit';
        $ch = curl_init();
        $post_data1=file_get_contents('php://input');

        
        if ($post_data1)
        {
            $post_data=json_decode($post_data1, true);
        }
        else
        {
            $post_data=$_POST;
        }

        if (empty($post_data))
        {
            header("Content-type: application/json");
            echo json_encode([
                'result'=>'',
                'message'=>'Payload can not be empty!',
                'error'=>1
            ]);
            exit;
        }
        $billed_data = $this->db->query("Select * from tbl_request where document_code='".$post_data['document']."'")->result_array();
        if (count($billed_data) > 0)
        {
            if ($post_data['billingtype'] == 'billed')
            {
                $postedArr = '{
                    "doc": "'. $post_data['document'] .'",
                    "cmmt": true,
                    "opt": [
                        {
                            "key": "1",
                            "value": "' . $post_data['invoice'] . '"
                        }
                    ]
                }';
                // $headers = array('client_id: '.$this->__client_id.'','client_profile_id: '.$this->__client_profile_id.'','Content-Type: application/json','Authorization: '.$this->__auth_token.'',);
                $headers = array("client_id: {$this->__client_id}","client_profile_id: {$this->__client_profile_id}","Content-Type: application/json","Authorization: {$this->__auth_token}");
                $post_type='POST';
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $post_type);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_POSTFIELDS,$postedArr);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
                //curl_setopt($ch, CURLOPT_USERPWD, "$this->__username:$this->__password");
                $result = curl_exec($ch);
                curl_close($ch);
                
                $responseArray =json_decode($result,true);
                if (!empty($result))
                {
                    $this->base_model->update_record_by_id('tbl_request', array(
                        'billing_status' =>'billed'
                    ), array(
                        'document_code' => $post_data['document']
                    ));

                    header("Content-type: application/json");
                    echo json_encode([
                        'result'=>$responseArray,
                        'message'=>'CalcTaxes Commit success.',
                        'error'=>0
                    ]);
                    exit;
                }
                else
                {
                    header("Content-type: application/json");
                    echo json_encode([
                        'result'=>'',
                        'message'=>'No Records Found',
                        'error'=>1
                    ]);
                    exit;
                }
            }
            else if ($post_data['billingtype'] == 'refund')
            {
                $postedArr = '{
                    "doc": "' . $post_data['document'] . '",
                    "cmmt": false,
                    "opt": [
                        {
                            "key": "1",
                            "value": "' . $post_data['invoice'] . '"
                        }
                    ]
                }';
                // print_r($postedArr);die;

                //$headers = array('client_id: '.$this->__client_id.'','client_profile_id: '.$this->__client_profile_id.'','Content-type: application/json','Authorization: '.$this->__auth_token.'',);
                $headers = array("client_id: {$this->__client_id}","client_profile_id: {$this->__client_profile_id}","Content-Type: application/json","Authorization: {$this->__auth_token}");
                $post_type='POST';
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $post_type);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_POST,$postedArr);
                curl_setopt($ch, CURLOPT_POSTFIELDS,$postedArr);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
                curl_setopt($ch, CURLOPT_USERPWD, "$this->__username:$this->__password");
                $result = curl_exec($ch);
                curl_close($ch);
                
                $responseArray =json_decode($result,true);

                if (!empty($result)) 
                {
                    $this->base_model->update_record_by_id('tbl_request', array(
                        'billing_status' =>'Refund'
                    ), array(
                        'document_code' => $post_data['document']
                    ));

                    header("Content-type: application/json");
                    echo json_encode([
                        'result'=>$responseArray,
                        'message'=>'CalcTaxes Refund sucess.',
                        'error'=>0
                    ]);
                    exit;
                }
                else
                {
                    header("Content-type: application/json");
                    echo json_encode([
                        'result'=>'',
                        'message'=>'No Records Found!',
                        'error'=>1
                    ]);
                    exit;
                }
            }
            else
            {
                header("Content-type: application/json");
                echo json_encode([
                    'result'=>'',
                    'message'=>'Invalid billingtype!',
                    'error'=>1
                ]);
                exit;
            } 
        }
        else
        {
            header("Content-type: application/json");
            echo json_encode([
                'result'=>'',
                'message'=>'Requested data did not found!',
                'error'=>1
            ]);
            exit;
        }
    }
    public function pcode()
    {
        $url=$this->__baseUrl.'afc/pCode';
        $ch = curl_init();
        $post_data1=file_get_contents('php://input');

        
        if ($post_data1)
        {
            $post_data=json_decode($post_data1, true);
        }
        else
        {
            $post_data=$_POST;
        }

        if (empty($post_data))
        {
            header("Content-type: application/json");
            echo json_encode([
                'result'=>'',
                'message'=>'Payload can not be empty!',
                'error'=>1
            ]);
            exit;
        }
        $postedArr = '{
            "CountryIso": "'. $post_data['CountryIso'] .'",
            "State": "'. $post_data['State'] .'",
            "County": "'. $post_data['County'] .'",
            "City": "'. $post_data['City'] .'",
            "ZipCode": "'. $post_data['ZipCode'] .'",
            "BestMatch": '. $post_data['BestMatch'] .',
            "LimitResults": 1,
            "NpaNxx": "'. $post_data['NpaNxx'] .'",
            "Fips": "'. $post_data['Fips'] .'",
          }';
        //$headers = array('client_id: '.$this->__client_id.'','client_profile_id: '.$this->__client_profile_id.'','Content-Type: application/json','Authorization: '.$this->__auth_token.'',);
        $headers = array("client_id: {$this->__client_id}","client_profile_id: {$this->__client_profile_id}","Content-Type: application/json","Authorization: {$this->__auth_token}");
        $post_type='POST';
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $post_type);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS,$postedArr);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        //curl_setopt($ch, CURLOPT_USERPWD, "$this->__username:$this->__password");
        $result = curl_exec($ch);
        curl_close($ch);
        $responseArray =json_decode($result,true);
        if (!empty($result))
        {
            header("Content-type: application/json");
            echo json_encode([
                'result'=>$responseArray,
                'message'=>'pCode success.',
                'error'=>0
            ]);
            exit;
        }
        else
        {
            header("Content-type: application/json");
            echo json_encode([
                'result'=>'',
                'message'=>'No Records Found',
                'error'=>1
            ]);
            exit;
        }
    }
    public function geoCode()
    {
        //$url='https://communicationsua.avalara.net/api/v2/geo/geocode';
        $url=$this->__baseUrl.'geo/geocode';
        $post_data1=file_get_contents('php://input');
        
        if ($post_data1)
        {
            $post_data=json_decode($post_data1, true);
        }
        else
        {
            $post_data=$_POST;
        }
        if (empty($post_data))
        {
            header("Content-type: application/json");
            echo json_encode([
                'result'=>'',
                'message'=>'Payload can not be empty!',
                'error'=>1
            ]);
            exit;
        }
        $postedArr = '[
            {
              "ref": "'. $post_data['ref'] .'",
              "cass": '. $post_data['cass'] .',
              "addr": "'. $post_data['addr'] .'",
              "city": "'. $post_data['city'] .'",
              "st": "'. $post_data['st'] .'",
              "zip": "'. $post_data['zip'] .'"
            }
        ]';
        
        //$headers = array('client_id: '.$this->__client_id.'','client_profile_id: '.$this->__client_profile_id.'','Content-Type: application/json','Authorization: '.$this->__auth_token.'',);
        $headers = array("client_id: {$this->__client_id}","client_profile_id: {$this->__client_profile_id}","Content-Type: application/json","Authorization: {$this->__auth_token}");
        $post_type='POST';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $post_type);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS,$postedArr);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        //curl_setopt($ch, CURLOPT_USERPWD, "$this->__username:$this->__password");
        $result = curl_exec($ch);
        curl_close($ch);
        $responseArray =json_decode($result,true);
        if (isset($responseArray[0]['pcd']) && !empty($responseArray[0]['pcd']) && $responseArray[0]['pcd'] > 0)
        {
            header("Content-type: application/json");
            echo json_encode([
                'result'=>$responseArray,
                'message'=>'Geo Code Available.',
                'error'=>0
            ]);
            exit;
        }
        else
        {
            $postedArrStatic = '[
                {
                  "ref": "Address Request",
                  "cass": true,
                  "addr": "3 Centerpointe Dr",
                  "city": "Lake Oswego",
                  "st": "OR",
                  "zip": "97035"
                }
            ]';
            $chs = curl_init();
            curl_setopt($chs, CURLOPT_URL, $url);
            curl_setopt($chs, CURLOPT_CUSTOMREQUEST, $post_type);
            curl_setopt($chs, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($chs, CURLOPT_POSTFIELDS,$postedArrStatic);
            curl_setopt($chs, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($chs, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($chs, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
            //curl_setopt($chs, CURLOPT_USERPWD, "$this->__username:$this->__password");
            $resultStatic = curl_exec($chs);
            curl_close($chs);
            $responseArrayStatic =json_decode($resultStatic,true);
            if (isset($responseArrayStatic[0]['pcd']) && !empty($responseArrayStatic[0]['pcd']) && $responseArrayStatic[0]['pcd'] > 0)
            {
                header("Content-type: application/json");
                echo json_encode([
                    'result'=>$responseArrayStatic,
                    'message'=>'Geo Code Available.',
                    'error'=>0
                ]);
                exit;
            } 
            else {
                header("Content-type: application/json");
                echo json_encode([
                    'result'=>'',
                    'message'=>'No Records Found From Goe Code',
                    'error'=>1
                ]);
                exit;
            }
        }
    }


    // public function refeunded_transaction()
    // {
    //     $username='vikas@gventure.net';
    //     $password='$Gventure@59#';
    //     $client_id=1057;
    //     $url='https://communicationsua.avalara.net/api/v2/afc/CalcTaxes';
    //     $ch = curl_init();
    //     $post_data1=file_get_contents('php://input'); 
    //     if ($post_data1)
    //     {
    //       $post_data=json_decode($post_data1, true);
    //     }
    //     else
    //     {
    //       $post_data=$_POST;
    //     }
    //     //print_r($post_data);die;
    //     $billed_data=$this->db->query("Select * from tbl_request where document_code='".$post_data['document']."'")->result_array();
        
    //    foreach ($billed_data as $val) 
    //    {
    //         $postedArr='{
    //             "cmpn": {
    //                 "bscl": 1,
    //                 "svcl": 1,
    //                 "fclt":false,
    //                 "frch":false,
    //                 "reg": false 
    //             },
    //             "inv": [
    //                 {
    //                     "doc": "'.$val['document_code'].'",
    //                     "cmmt":true,
    //                     "bill": {
    //                         "ctry":"'.$val['country'].'",
    //                         "city":"'.$val['city'].'",
    //                         "st": "'.$val['state'].'",
    //                         "zip":"'.$val['zip'].'"
    //                     },
    //                     "cust": 1,
    //                     "date":"'.$val['date'].'",
    //                     "itms":'.$val['itms'].'
    //                 }
    //             ]
    //         }';
        
    //    }
    //     $headers = array('client_id: 1057','Content-type: application/json','Authorization: Basic',);

    //     //print_r($post_data);die;
    //          $post_type='POST';
    //         curl_setopt($ch,CURLOPT_URL, $url);
    //         curl_setopt($ch,CURLOPT_CUSTOMREQUEST, $post_type);
    //         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    //         curl_setopt($ch,CURLOPT_POST,$postedArr);
    //         curl_setopt($ch,CURLOPT_POSTFIELDS,$postedArr);
    //         curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    //         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    //         curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
    //         curl_setopt($ch, CURLOPT_USERPWD, "$username:$password");
    //         $result = curl_exec($ch);
    //         curl_close($ch);
    //         // echo "<pre>";
    //         $responseArray =json_decode($result,true);

    //   if (!empty($result)) 
    //   {
    //      $this->base_model->update_record_by_id('tbl_request',array('billing_status' =>'Refund'),array('document_code' =>$post_data['document']));
    //     echo json_encode(['result'=>$responseArray,'message'=>'CalcTaxes Refund sucess !','error'=>0]);
    //     exit;
    //   }
    //   else
    //   {
        
    //     echo json_encode(['result'=>'','message'=>'No Records Found','error'=>1]);
    //     exit;
    //   }
    // }

}