<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends MY_controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('Auth_model');
		$session_data=$this->session->userdata('user');
		if(empty($session_data))
		{		
			redirect(base_url('Auth/login'));
		}
	}

	public function index()
	{
		$table='users';
		$where= array('user_type' =>2);
		$data['users_info'] = $this->base_model->get_all_record_by_users_condition($table,$where);
		//print_r($data);die;
		$this->pageload('users/index',$data);
	}

	public function edit_user_detail($id)
	{
		$session_data = $this->session->userdata('user');
		$table='users';
		$where= array('id'=> $id, 'user_type' => 2);
		$data['users_info']=$this->base_model->get_all_record_by_condition($table,$where);
		// print_r($data);exit;

		$this->load->library('form_validation');

		$this->form_validation->set_rules('first_name', 'First Name', 'required');
		$this->form_validation->set_rules('last_name', 'Last Name', 'required');
		$this->form_validation->set_rules('username', 'User Name', 'required');
		$this->form_validation->set_rules('email', 'User Email','required|valid_email');
		$this->form_validation->set_rules('phone', 'Phone','required');
		$this->form_validation->set_rules('address', 'Address','required');
		$this->form_validation->set_rules('zip_code', 'Zip Code','required');
		$this->form_validation->set_rules('city', 'City','required');
		$this->form_validation->set_rules('country', 'Country','required');
		$this->form_validation->set_rules('state', 'State','required');
		$this->form_validation->set_rules('website', 'Website or domain name','required');

		if($this->form_validation->run() == false){
			$this->pageload('users/edit_user_detail',$data);
		}else{
			$formData = array();
			$id = $data['users_info']->id;
			date_default_timezone_set("Asia/Kolkata");
			$updated_date = date("Y-m-d H:i:s");

			$formData = array(
				'first_name' => $this->input->post('first_name'),
				'last_name' => $this->input->post('last_name'),
				'username' => $this->input->post('username'),
				'user_email' => $this->input->post('email'),
				'mobile_no' => $this->input->post('phone'),
				'address' => $this->input->post('address'),
				'post_code' => $this->input->post('zip_code'),
				'city' => $this->input->post('city'),
				'country' => $this->input->post('country'),
				'state' => $this->input->post('state'),
				'domain_name' => $this->input->post('website'),
				'updated_at' => $updated_date
			);

			$this->Auth_model->update_user($id, $formData);
			// $this->session->set_flashdata('msg','Data has been updated successfully!');
			redirect(base_url('users/index'));
		}	
		
	}

	public function edit_user()
	{
		$session_data=$this->session->userdata('user');
		//print_r($session_data);die;
		$table='users';
		$where= array('id' =>$session_data['id']);
		$data['users_info']=$this->base_model->get_all_record_by_condition($table,$where);
		// print_r($data['users_info']->id);exit;

		$this->load->library("form_validation");

		$this->form_validation->set_rules('first_name', 'First Name', 'required');
		$this->form_validation->set_rules('last_name', 'Last Name', 'required');
		$this->form_validation->set_rules('username', 'User Name', 'required');
		$this->form_validation->set_rules('email', 'User Email','required|valid_email');
		$this->form_validation->set_rules('phone', 'Phone','required');
		$this->form_validation->set_rules('address', 'Address','required');
		$this->form_validation->set_rules('zip_code', 'Zip Code','required');
		$this->form_validation->set_rules('city', 'City','required');
		$this->form_validation->set_rules('country', 'Country','required');
		$this->form_validation->set_rules('state', 'State','required');
		$this->form_validation->set_rules('website', 'Website or domain name','required');


		if($this->form_validation->run() == false){
			$this->pageload('users/edit_user',$data);
		}else{
			$formData = array();
			date_default_timezone_set("Asia/Kolkata");
			$updated_date = date("Y-m-d H:i:s");

			$id = $data['users_info']->id;
			$formData = array(
				'first_name' => $this->input->post('first_name'),
				'last_name' => $this->input->post('last_name'),
				'username' => $this->input->post('username'),
				'user_email' => $this->input->post('email'),
				'mobile_no' => $this->input->post('phone'),
				'address' => $this->input->post('address'),
				'post_code' => $this->input->post('zip_code'),
				'city' => $this->input->post('city'),
				'country' => $this->input->post('country'),
				'state' => $this->input->post('state'),
				'domain_name' => $this->input->post('website'),
				'updated_at' => $updated_date
			);

			$this->Auth_model->update_user($id, $formData);

			$this->session->set_flashdata('msg','Your data has been updated successfully!');
			redirect(base_url('users/edit_user'));
		}	
	}

	public function add_user()
	{
		$session_data = $this->session->userdata('user');
		$this->load->library('form_validation');

		$where = array('user_type' => 2);
		$table = 'users';
		$data = '';

		$this->form_validation->set_rules('first_name', 'First Name', 'required');
		$this->form_validation->set_rules('last_name', 'Last Name', 'required');
		$this->form_validation->set_rules('username', 'User Name', 'required');
		$this->form_validation->set_rules('email', 'User Email','required|valid_email');
		$this->form_validation->set_rules('phone', 'Phone','required');
		$this->form_validation->set_rules('address', 'Address','required');
		$this->form_validation->set_rules('zip_code', 'Zip Code','required');
		$this->form_validation->set_rules('city', 'City','required');
		$this->form_validation->set_rules('country', 'Country','required');
		$this->form_validation->set_rules('state', 'State','required');
		$this->form_validation->set_rules('website', 'Website or domain name','required');

		if($this->form_validation->run() == false){
			$this->pageload('users/add_user',$data);
		}else{
			$formArray = array();
			date_default_timezone_set("Asia/Kolkata");
			$created_date = date("Y-m-d H:i:s");

			$chars = date('ymdhs')."abc$%defghijk!@#$%lmno%&*#$@pqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
			$password = substr(str_shuffle($chars),0,8);

			$formArray['first_name'] = $this->input->post('first_name');
			$formArray['last_name'] = $this->input->post('last_name');
			$formArray['username'] = $this->input->post('username');
			$formArray['user_email'] = $this->input->post('email');
			$formArray['password'] = md5($password);
			$formArray['mobile_no'] = $this->input->post('phone');
			$formArray['address'] = $this->input->post('address');
			$formArray['post_code'] = $this->input->post('zip_code');
			$formArray['city'] = $this->input->post('city');
			$formArray['country'] = $this->input->post('country');
			$formArray['state'] = $this->input->post('state');
			$formArray['domain_name'] = $this->input->post('website');
			$formArray['created_at'] = $created_date;

			$result = $this->Auth_model->create($formArray);
			if($result)
			{
				$payload = [];
				$payload['name'] = $formArray['first_name'];
				$payload['username'] = $formArray['username'];
				$payload['password'] = $formArray['password'];
				$payload['user_email'] = $formArray['user_email'];

				$message='';
				$emailsend = 'noreply@sfglife.com';
				$message.= "<p>Hi ".$payload['name']." ,<br/> You are successfully Registred  with the SFG Virtual Mentor .Your Login Details are, <br/> Your account username:-".ucwords(strtolower($payload['username']))." and your account password:-".$password.",<br/> <br/> Thank you <br/> Symmetry Financial Group </p>";
				
				sendMail('',$payload['user_email'],'Remark of Account',$message,'Insurance');
				$userdata = $this->base_model->get_record_by_id('users', array('id'=> $insertID));
				$this->session->set_userdata('users',$userdata);
				$session_data=$this->session->userdata('user_login');
				if (!empty($session_data)) 
				{
					redirect(base_url('users/add_user'));
				}
				else
				{
					redirect('users/index');
				}
			}
			else{
				echo "User not add successfully";
			}
			redirect(base_url('users/index'));
		}	
	}
	public function changePassword()
	{
		$session_data = $this->session->userdata('user');
		$this->load->library('form_validation');
		$table='users';
		$where= array('id' =>$session_data['id']);
		$data['users_info']=$this->base_model->get_all_record_by_condition($table,$where);
		// print_r($data['users_info']->password);exit;

		$this->form_validation->set_rules('currentpassword', 'Current Password', 'required');
		$this->form_validation->set_rules('newpassword', 'New Password', 'required');
		$this->form_validation->set_rules('confirmpassword', 'Confirm Password','required|matches[newpassword]');

		if($this->form_validation->run() == false)
		{
			$this->pageload('users/change_password', $data);
		}else{
			$currentpassword = md5($this->input->post('currentpassword'));
			$newpassword = md5($this->input->post('newpassword'));
			$confirmpassword = $this->input->post('confirmpassword');


			if ($currentpassword!=$data['users_info']->password){
				$this->session->set_flashdata('error','Current password wrong');
				redirect(base_url('users/changePassword'));
			}elseif ($currentpassword == $newpassword) {
				$this->session->set_flashdata('failed','Current and New password are same, Try another password');
				redirect(base_url('users/changePassword'));
			}else{
				$id = $data['users_info']->id;
				date_default_timezone_set("Asia/Kolkata");
				$updated_date = date("Y-m-d H:i:s");
				$c_data = [];
				$c_data = array(
					'password' => $newpassword,
					'updated_at' => $updated_date
				);

				$this->Auth_model->updatePassword($id, $c_data);
				$this->session->set_flashdata('success','Password Change Successfully');
				redirect(base_url('users/changePassword'));
			}		
		}
		
	}

	
}