const express = require("express");
const { connection, key } = require("./dbcon/db");
const bodyparser = require("body-parser");
var app = express();
const HashMap = require("hashmap");
const allWalletBalance = new HashMap();
app.use(bodyparser.json());

// To Load Wallet Data in HashMap
function loadBalance() {
    getWalletBalance(function (err, resBAl) {
        if (err == 1 && resBAl.length > 0) {
            for (let i = 0; i < resBAl.length; i++) {
                allWalletBalance.set(resBAl[i].idaccount, resBAl[i]);            
            }
            // console.log("Wallet HashMap Set :: ", allWalletBalance);
        }
        else
            console.info("No Record Available in wallet ");
    });
}

// To Get Balance
function getWalletBalance(callback) {
    let qry = "SELECT w.idaccount, IF(w.`balance`+w.`credit_limit`>0,1,0) isbalance, w.balance,(w.`balance`+w.`credit_limit`) `totalBalance`, u.`is_deleted` FROM wallet w LEFT JOIN `user` u ON u.idaccount=w.idaccount";
    console.log("DID Query Load:: ", qry);
    connection.execute(qry, (err, rows) => {
        if(err==1){
            callback(1, rows);
        }
        else{
            callback(0, {status: 500, message: "Internal Server Error", error: err.message });
        }        
    });
};

// Route  : To Get Wallet Detail By Idaccount
app.get('/wallet/getbalance/:idaccount', (req, res) => {
    let token = req.headers.authorization || req.headers.token
    
    if (token !== key) {

        res.send({
            "message": "Invalid Session you are trying to access",
            "error": "Invalid session is called to access!"
        });
        return false;
    }
    const idaccount = req.params.idaccount;
    console.log("Requested Idaccount :: ", idaccount);

    let message = "";
    if (!idaccount)
        message = "Invalid Idaccount";

    if (!message) {
        
        if(allWalletBalance.has(parseInt(idaccount))){
            let data = allWalletBalance.get(parseInt(idaccount));
            res.send({ status: 200, data: data });
        }
        else {
            let qry = "SELECT w.idaccount, IF(w.`balance`+w.`credit_limit`>0,1,0) isbalance, w.balance,(w.`balance`+w.`credit_limit`) `totalBalance`, u.`is_deleted` FROM wallet w LEFT JOIN `user` u ON u.idaccount=w.idaccount WHERE w.idaccount='" + idaccount + "' LIMIT 1";
            connection.execute(qry, (err, rows) => {
                if (err==1 && Object.keys(rows).length > 0) {
                    allWalletBalance.set(rows[0].idaccount, rows[0]);
                    res.send({ status: 200, data: rows[0] });
                } else
                    res.send({ status: 404, message: "Wallet Data Does Not Exist!" });
            });
        }
    }
    else {
        res.send({ status: 401, message: message });
    }
});

setInterval(() => loadBalance(), 60 * 1000);

app.listen(4224, () => {
    loadBalance();
    console.log("Server is Connected at Port :: 4224");
});