const express = require("express");
const { connection, key } = require("./dbcon/db");
const bodyparser = require("body-parser");
const HashMap = require("hashmap");
const app = express();
const allBCIDDID = new HashMap();
app.use(bodyparser.json());

// To Load BCID DIDs in HashMap
function loadBCIDDIDs() {
    getAllBCIDDIDs(function (err, resBCIDDID) {
        if (err === 1 && resBCIDDID.length > 0) {
            for (let i = 0; i < resBCIDDID.length; i++) {
                allBCIDDID.set(resBCIDDID[i].did.trim(), resBCIDDID[i]);
            }
            // console.log("BCID DID HashMap Set:", allBCIDDID);
        }
        else {
            console.info("No Record Available in sip_bcid_override for BCID");
        }
    });
}

// To Get BCID DIDs
function getAllBCIDDIDs(callback) {
    let qry = `SELECT TRIM(did) AS did, idaccount, sip_override_prefix, sip_override_ip, eid FROM sip_bcid_override`;
    // console.log("BCID DID Query Load:", qry);
    connection.execute(qry, (err, rows) => {      
        if(err==1){
            callback(1, rows);
        }
        else{
            callback(0, {status: 500, message: "Internal Server Error", error: err.message });
        }    
    });
}

// Route: To Get BCID DID Detail By DID
app.get('/getbciddid/:did', (req, res) => {
    let token = req.headers.authorization || req.headers.token;
    if (token !== key) {
        return res.status(401).send({
            message: "Invalid Session you are trying to access",
            error: "Invalid session is called to access!"
        });
    }

    const did = req.params.did.trim();
    console.log("Requested BCID DID:", did);

    if (!did) {
        return res.status(400).send({ status: 400, message: "Invalid BCID DID" });
    }

    let data = allBCIDDID.get(did);
    if (data) {
        res.status(200).send({ status: 200, data: data});
    } else {
        loadBCIDDIDs();
        let qry = `SELECT TRIM(did) AS did, idaccount, sip_override_prefix, sip_override_ip, eid FROM sip_bcid_override WHERE TRIM(did) = '${did}' LIMIT 1`;
        console.log("Query BCID DID Get:", qry);
        connection.execute(qry, (err, rows) => {
            if(err == 1) {
                if(rows.length > 0) {
                    allBCIDDID.set(rows[0].did.trim(), rows[0]);
                    res.status(200).send({ status: 200, message: "BCID DID Data Exist!", data: rows[0]});
                } else {
                    res.status(404).send({ status: 404, message: "BCID DID Data Does Not Exist!", data: {}});
                }
            }
            else{
                res.status(500).send({ status: 500, message: "Internal Server Error"});
            }
        });
    }
});

setInterval(() => loadBCIDDIDs(), 5 * 60 * 1000);

app.listen(3002, () => {
    loadBCIDDIDs();
    console.log("BCID DID Server is connected at port 3002");
}); 