const express = require("express");
const { connection, key } = require("./dbcon/db");
const bodyparser = require("body-parser");
const HashMap = require("hashmap");
const app = express();
const allDID = new HashMap();
app.use(bodyparser.json());

// To Load DIDs in HashMap
function loadDIDs() {
    getAllDIDs(function (err, resDID) {
        if (err === 1 && resDID.length > 0) {
            for (let i = 0; i < resDID.length; i++) {
                allDID.set(resDID[i].did.trim(), resDID[i]);
            }
            // console.log("DID HashMap Set:", allDID);
        }
        else {
            console.info("No Record Available in did_buy");
        }
    });
}

// To Get DIDs
function getAllDIDs(callback) {
    let qry = `SELECT TRIM(db.did) AS did, db.type, db.iduser, db.account_id, i.forward_type, i.forward, i.connection_key, i.idaccount, ib.dnis, ib.ani, u.is_deleted FROM did_buy db LEFT JOIN endpoint i ON i.connection_key = db.connection_key LEFT JOIN inbound ib ON ib.idendpoint = i.idendpoint
        LEFT JOIN user u ON u.iduser = db.iduser WHERE db.disconnect_did_status = '1' GROUP BY db.did`;
    // console.log("DID Query Load:", qry);
    connection.execute(qry, (err, rows) => {      
        if(err==1){
            callback(1, rows);
        }
        else{
            callback(0, {status: 500, message: "Internal Server Error", error: err.message });
        }    
    });
}

// Route: To Get DID Detail By DID
app.get('/getdid/:did', (req, res) => {
    let token = req.headers.authorization || req.headers.token;
    if (token !== key) {
        return res.status(401).send({
            message: "Invalid Session you are trying to access",
            error: "Invalid session is called to access!"
        });
    }

    const did = req.params.did.trim();
    console.log("Requested DID:", did);

    if (!did) {
        return res.status(400).send({ message: "Invalid DID" });
    }

    let data = allDID.get(did);
    if (data) {
        res.status(200).send(data);
    } else {
        loadDIDs();
        let qry = `SELECT TRIM(db.did) AS did, db.type, db.iduser, db.account_id, i.forward_type, i.forward, i.connection_key, i.idaccount, ib.dnis, ib.ani, u.is_deleted FROM did_buy db LEFT JOIN endpoint i ON i.connection_key = db.connection_key LEFT JOIN inbound ib ON ib.idendpoint = i.idendpoint
            LEFT JOIN user u ON u.iduser = db.iduser WHERE db.disconnect_did_status = '1' AND TRIM(db.did) = '${did}' GROUP BY db.did LIMIT 1`;
        console.log("Query DID Get:", qry);
        connection.execute(qry, (err, rows) => {      
            if(err==1 && rows.length > 0) {
                allDID.set(rows[0].did.trim(), rows[0]);
                res.status(200).send(rows[0]);
            } else {
                res.status(404).send({ message: "DID Data Does Not Exist!" });
            }
        });
    }
});

setInterval(() => loadDIDs(), 5 * 60 * 1000);

app.listen(3001, () => {
    loadDIDs();
    console.log("Server is connected at port 3001");
});