const express = require("express");
const { connection, key } = require("./dbcon/db");
const bodyparser = require("body-parser");
var app = express();
const HashMap = require("hashmap");
const lergInfo = new HashMap();
app.use(bodyparser.json());

// To Load LergInfo in HashMap
function loadLergerInfo() {
    getLergInfo(function (err, resLerg) {
        if (err == 1 && resLerg.length > 0) {
            lergInfo.clear();
            for (let i = 0; i < resLerg.length; i++) {
                lergInfo.set(resLerg[i].npa+'_'+resLerg[i].nxx, resLerg[i]);
            }
            console.log("LergInfo HashMap Set",lergInfo);
        } else {
            console.info("No Record Available in lerge_info",resLerg);
        }
    });
}
// as_status ==1 means active and 0 means inactive
// To Get LergInfo
function getLergInfo(callback) {
    let qry = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`, `category`,`region`,`lata_name` `lata name`,`country` FROM `lerg_info`";
    console.log("LergInfo Query Load:: ", qry);
    connection.execute(qry, (err, rows) => {      
        if(err==1){
            callback(1, rows);
        }
        else{
            callback(0, {status: 500, message: "Internal Server Error", error: err.message });
        }    
    });
}

// Route  : To Get LergInfo Detail By npa nxx
app.get('/getLergeInfoDetail/:NPA/:NXX', (req, res) => {
    let token = req.headers.authorization || req.headers.token;
    if (token !== key) {
        res.send({status: 502, message: "Something went wrong with checking lerge info detail!"});
        return false;
    }
    const npa = req.params.NPA;
    const nxx = req.params.NXX;
    console.log("Requested npa :: ", npa);
    console.log("Requested nxx :: ", nxx);

    let message = "";
    if (!npa || !nxx) {
        message = "Invalid NPA or NXX";
    }

    if (!message) {
        let npanxx = npa+'_'+nxx;
        console.log("NPANXX:::", npanxx);  
        let data = lergInfo.get(npanxx)
        if (data) {
            console.log("Retrieved Data :: ", data);
            res.send({ status: 200, data: data, message: "LergInfo is found!" });
        } 
        else{
            let qry = "SELECT `npa`,`nxx`,`block`,`ocn`,`lata`,`state` ,`co_name_spec_c` `operator`, `category`,`region`,`lata_name` `lata name`,`country` FROM `lerg_info` WHERE `npa`=" + npa + " AND `nxx`=" + nxx + "";
            console.log("Query Lerge Get:: ", qry);
            connection.execute(qry, (err, rows) => {      
                if(err==1 && rows.length > 0) {
                    res.send({ status: 200, data: rows[0], message: "Lerge Info Found." });
                } else {
                    res.send({ status: 404, message: "Lerge Info Does Not Exist!" });
                }
            });
        }
    } else {
        res.send({ status: 401, message: message });
    }
});

// setInterval(() => loadLergerInfo(), 60 * 1000);
setInterval(() => loadLergerInfo(), 24 * 60 * 60 * 1000);

app.listen(4225, () => {
    loadLergerInfo();
    console.log("Server is Connected at Port :: 4225");
});