const express = require("express");
const { connection, key } = require("./dbcon/db");
const bodyparser = require("body-parser");
const HashMap = require("hashmap");
const app = express();
const moment = require("moment");
const allMessageBusinessHours = new HashMap();
app.use(bodyparser.json());

// To Load Message Business Hours in HashMap
function loadMessageBusinessHours() {
    getAllMessageBusinessHours(function (err, resMessageBusinessHours) {
        if (err === 1 && resMessageBusinessHours.length > 0) {
            for (let i = 0; i < resMessageBusinessHours.length; i++) {
                allMessageBusinessHours.set(resMessageBusinessHours[i].idaccount + '_' + resMessageBusinessHours[i].state_abbr, resMessageBusinessHours[i]);
            }
            console.log("Message Business Hours HashMap Set:", allMessageBusinessHours);

        }
        else {
            console.info("No Record Available in message_business_hours for Message Business Hours");
        }
    });
}

// To Get Message Business Hours
function getAllMessageBusinessHours(callback) {
    // let qry = `SELECT mb_id, idaccount, state_abbr, msg_status, day, CASE day WHEN '1' THEN 'Monday' WHEN '2' THEN 'Tuesday' WHEN '3' THEN 'Wednesday' WHEN '4' THEN 'Thursday' WHEN '5' THEN 'Friday' WHEN '6' THEN 'Saturday' WHEN '7' THEN 'Sunday' ELSE 'N/A' END AS day_name, full_day, from_time, to_time,holiday FROM message_business_hours`;
    let qry = `SELECT mb_id,idaccount,state_abbr,msg_status,day,full_day,from_time,to_time,holiday,(SELECT COALESCE(name,'N/A') FROM message_business_holiday h WHERE h.mh_id=mbh.holiday LIMIT 1) AS holiday_name,(SELECT COALESCE(date,'N/A') FROM message_business_holiday h WHERE h.mh_id=mbh.holiday LIMIT 1) AS holiday_date FROM message_business_hours mbh`;
    console.log("Message Business Hours Query Load:", qry);
    connection.execute(qry, (err, rows) => {      
        if(err==1){
         
            callback(1, rows);
            console.log("Rows:");
rows.forEach(r => console.log(r));

        }
        else{
            callback(0, {status: 500, message: "Internal Server Error", error: err.message });
        }    
    });
}

// Route: To Get Message Business Hours Detail By ID Account and State
app.get('/getmsgBusinessHour/:idaccount/:state', (req, res) => {
    let token = req.headers.authorization || req.headers.token;
    if (token !== key) {
        return res.status(401).send({
            message: "Invalid Session you are trying to access",
            error: "Invalid session is called to access!"
        });
    }

    const idaccount = req.params.idaccount.trim();
    const state = req.params.state.trim();
    console.log("Requested Message Business Hours:", idaccount, "State:", state);

    if (!idaccount) {
        return res.status(400).send({ status: 400, message: "Invalid ID Account" });
    }

    if (!state) {
        return res.status(400).send({ status: 400, message: "Invalid State" });
    }

    let data = allMessageBusinessHours.get(idaccount + '_' + state);
    // if (data) {
    //     console.log({ status: 422, message: "Messages cannot be sent to recipients in " +state});
    //     res.status(422).send({ status: 422, message: "Messages cannot be sent to recipients in " +state});
    // } else {
    //     console.log({ status: 200, message: "Messaging allowed!"});
    //     res.status(200).send({ status: 200, message: "Messaging allowed!"});
    // }
let today = moment().format("YYYY-MM-DD");      
let currentDay = moment().isoWeekday();        
let currentTime = moment().format("HH:mm:ss");

if (!data) {
    return res.status(200).send({
        status: 200,
        message: "Messaging allowed (no restriction found)"
    });
}


if (data.holiday_date && moment(data.holiday_date).format("YYYY-MM-DD") === today) {
    return res.status(422).send({
        status: 422,
        message: `Messages cannot be sent on holiday (${data.holiday_name}) in ${data.state_abbr}`
    });
}


if (data.day != currentDay) {
    return res.status(200).send({
        status: 200,
        message: "Messaging allowed (different weekday)"
    });
}


if (data.full_day == 1) {
    return res.status(200).send({
        status: 200,
        message: "Messaging allowed (full day allowed)"
    });
}


if (data.full_day == 0) {

    if (currentTime < data.from_time || currentTime > data.to_time) {
        return res.status(422).send({
            status: 422,
            message: `Messages cannot be sent to recipients in ${data.state_abbr}`
        });
    }

    return res.status(200).send({
        status: 200,
        message: "Messaging allowed "
    });
}




});
// hourly load message business hours
setInterval(() => loadMessageBusinessHours(), 60 * 60 * 1000);

app.listen(3005, () => {
    loadMessageBusinessHours();
    console.log("Message Business Hours Server is connected at port 3005");
});
