const express = require("express");
const { connection, key } = require("./dbcon/db");
const bodyparser = require("body-parser");
const HashMap = require("hashmap");
const app = express();
const allDID = new HashMap();
app.use(bodyparser.json());

// To Load DIDs in HashMap
function loadDIDs() {
    getAllDIDs(function (err, resDID) {
        if (err === 1 && resDID.length > 0) {
            for (let i = 0; i < resDID.length; i++) {
                allDID.set(resDID[i].account_id+"_"+resDID[i].did.trim(), resDID[i]);
            }
            // console.log("DID HashMap Set:", allDID);
        }
        else {
            console.info("No Record Available in did_buy");
        }
    });
}

// To Get DIDs
function getAllDIDs(callback) {
    let qry = `SELECT sms_provider SmsProvider, provider DIDProvider, camp_registry campaignId, did, iddid, type FROM did_buy
		WHERE disconnect_did_status=1 AND sinch_status=1 LIMIT 1`;
    // console.log("DID Query Load:", qry);
    connection.execute(qry, (err, rows) => {      
        if(err==1){
            callback(1, rows);
        }
        else{
            callback(0, {status: 500, message: "Internal Server Error", error: err.message });
        }    
    });
}

// Route: To Get DID Detail By DID
app.get('/getdid/:idaccount/:did', (req, res) => {
    let token = req.headers.authorization || req.headers.token;
    if (token !== key) {
        return res.status(401).send({
            message: "Invalid Session you are trying to access",
            error: "Invalid session is called to access!"
        });
    }

    const did = req.params.did.trim();
    const idaccount = req.params.idaccount.trim();
    console.log("Requested Detail to get DID ::", idaccount, did);

    if (!did) {
        return res.status(400).send({ status: 400, message: "Invalid DID" });
    }
    if (!idaccount) {
        return res.status(400).send({ status: 400, message: "Invalid idaccount" });
    }

    let data = allDID.get(idaccount+"_"+did);
    if (data) {
        res.status(200).json({ status: 200, data: data });        
    } else {
        loadDIDs();
        let qry = `SELECT account_id, sms_provider SmsProvider, provider DIDProvider, camp_registry campaignId, did, iddid, type FROM did_buy
		WHERE account_id=${idaccount} AND did=${did} AND disconnect_did_status=1 AND sinch_status=1 LIMIT 1;`;
        console.log("Query DID Get:", qry);
        connection.execute(qry, (err, rows) => {      
            if(err==1 && rows.length > 0) {
                allDID.set(rows[0].account_id+"_"+rows[0].did.trim(), rows[0]);
                res.status(200).json({ status: 200, data: rows[0] });                
            } else {
                res.status(502).json({ status: 502, message: "Invalid Account Setting or Invalid DID!" });                
            }
        });
    }
});

setInterval(() => loadDIDs(), 5 * 60 * 1000);

app.listen(3001, () => {
    loadDIDs();
    console.log("Server is connected at port 3001");
});