const express = require("express");
const { connection, key } = require("./dbcon/db");
const bodyparser = require("body-parser");
var app = express();
const HashMap = require("hashmap");
const allservice = new HashMap();
app.use(bodyparser.json());

// To Load service in HashMap
function loadService() {
    getServiceActivate(function (err, resSer) {
        if (err == 1 && resSer.length > 0) {
            allservice.clear();
            for (let i = 0; i < resSer.length; i++) {
                if (!allservice.has(resSer[i].idaccount)) {
                    allservice.set(resSer[i].idaccount, new Map());
                }
                allservice.get(resSer[i].idaccount).set(resSer[i].fs_id, resSer[i]);
            }
            // console.log("Service HashMap Set",allservice);
            // console.log("Service HashMap Set",allservice.get(202));
        } else {
            console.info("No Record Available in account_service",resSer);
        }
    });
}
// as_status ==1 means active and 0 means inactive
// To Get Service
function getServiceActivate(callback) {
    let qry = "SELECT fs_id, idaccount, as_status FROM `account_service`";
    console.log("Service Query Load:: ", qry);
    connection.execute(qry, (err, rows) => {
        if(err==1){
            callback(1, rows);
        }
        else{
            callback(0, {status: 500, message: "Internal Server Error", error: err.message });
        }    
    });
}

// Route  : To Get Service Detail By Idaccount & fservice_id
app.get('/getService/:idaccount/:fservice_id', (req, res) => {
    let token = req.headers.authorization || req.headers.token;
    if (token !== key) {
        res.send({status: 502, message: "Something went wrong with checking service activation"});
        return false;
    }
    const idaccount = req.params.idaccount;
    const fsid = req.params.fservice_id;
    console.log("Requested Idaccount :: ", idaccount);
    console.log("Requested fservice_id :: ", fsid);

    let message = "";
    if (!fsid || !idaccount) {
        message = "Invalid Fs_ID OR IDAccount";
    }

    if (!message) {
        let data = allservice.get(parseInt(idaccount))?.get(parseInt(fsid));
        console.log("Retrieved Data :: ", data);
        if (data && data.as_status && parseInt(data.as_status)==1) {
            res.send({ status: 200, data: data, message: "::SN:: service is activated" });
        } 
        else if(data && data.as_status=='0'){
            res.send({ status: 200, data: data, message: "::SN:: service is deactivated" });
        }
        else{
            let qry = "SELECT fs_id, idaccount, as_status FROM `account_service` WHERE idaccount='" + idaccount + "' AND fs_id='" + fsid + "' AND `as_status`='1'  LIMIT 1";
            console.log("Query Service Get:: ", qry);
            connection.execute(qry, (err, rows) => {      
                if(err==1 && rows.length > 0) {
                    res.send({ status: 200, data: rows[0], message: "::SN:: service is activated" });
                } else {
                    res.send({ status: 404, message: "Service Data Does Not Exist!" });
                }
            });
        }
    } else {
        res.send({ status: 401, message: message });
    }
});

setInterval(() => loadService(), 60 * 1000);

app.listen(3003, () => {
    loadService();
    console.log("Server is Connected at Port :: 3003");
});