const express = require("express");
const { connection, key } = require("./dbcon/db");
const bodyparser = require("body-parser");
const HashMap = require("hashmap");
const app = express();
const allTwilioDID = new HashMap();
app.use(bodyparser.json());

// To Load Twilio DIDs in HashMap
function loadTwilioDIDs() {
    getAllTwilioDIDs(function (err, resDID) {
        if (err === 1 && resDID.length > 0) {
            for (let i = 0; i < resDID.length; i++) {
                allTwilioDID.set(resDID[i].did.trim(), resDID[i]);
            }
            console.log("Twilio DID HashMap Set:", allTwilioDID);
        }
        else {
            console.info("No Record Available in did_buy for Twilio");
        }
    });
}

// To Get Twilio DIDs
function getAllTwilioDIDs(callback) {
    let qry = "SELECT TRIM(db.`did`) AS did, MAX(db.`order_id`) AS order_id, MAX(db.`camp_registry`) AS camp_registry, MAX(db.`account_id`) AS account_id, MAX(db.`provider`) AS provider, MAX(db.`sms_provider`) AS sms_provider, MAX(vs.`subaccount_sid`) AS subaccount_sid, MAX(ts.subaccount_sid) AS sub_username, MAX(ts.subaccount_secret) AS `sub_password` FROM did_buy db JOIN verified_sender vs ON vs.unique_request_id = db.camp_registry LEFT JOIN `twillio_subaccount` ts ON ts.sid=vs.subaccount_sid WHERE db.disconnect_did_status = '1' AND db.`provider`='twilio' AND db.sinch_status=1 GROUP BY TRIM(db.did)";
    console.log("Twilio DID Query Load:", qry);
    connection.execute(qry, (err, rows) => {      
        if(err==1){
            callback(1, rows);
        }
        else{
            callback(0, {status: 500, message: "Internal Server Error", error: err.message });
        }    
    });
}

// Route: To Get Twilio DID Detail By DID
app.get('/gettwiliodid/:did', (req, res) => {
    let token = req.headers.authorization || req.headers.token;
    if (token !== key) {
        return res.status(401).send({
            message: "Invalid Session you are trying to access",
            error: "Invalid session is called to access!"
        });
    }

    const did = req.params.did.trim();
    console.log("Requested Twilio DID:", did);

    if (!did) {
        return res.status(400).send({ status: 400, message: "Invalid DID" });
    }

    let data = allTwilioDID.get(did);
    if (data) {
        res.status(200).send({status: 200, data: data});
    } else {
        loadTwilioDIDs();
        let qry = "SELECT TRIM(db.`did`) AS did, MAX(db.`order_id`) AS order_id, MAX(db.`camp_registry`) AS camp_registry, MAX(db.`account_id`) AS account_id, MAX(db.`provider`) AS provider, MAX(db.`sms_provider`) AS sms_provider, MAX(vs.`subaccount_sid`) AS subaccount_sid, MAX(ts.subaccount_sid) AS sub_username, MAX(ts.subaccount_secret) AS `sub_password` FROM did_buy db JOIN verified_sender vs ON vs.unique_request_id = db.camp_registry LEFT JOIN `twillio_subaccount` ts ON ts.sid=vs.subaccount_sid WHERE db.disconnect_did_status = '1' AND db.`provider`='twilio' AND db.sinch_status=1 AND TRIM(db.did) = "+did+" GROUP BY TRIM(db.did) LIMIT 1";
        console.log("Query Twilio DID Get:", qry);
        connection.execute(qry, (err, rows) => {      
            if(err==1 && rows.length > 0) {
                allTwilioDID.set(rows[0].did.trim(), rows[0]);
                res.status(200).send({status: 200, data: rows[0]});
            } else {
                res.status(404).send({ status: 404, message: "Twilio DID Data Does Not Exist!" });
            }
        });
    }
});
// per hour load twilio dids
setInterval(() => loadTwilioDIDs(), 60 * 60 * 1000);

app.listen(3003, () => {
    loadTwilioDIDs();
    console.log("Twilio DID Server is connected at port 3003");
}); 