const express = require("express");
const { connection } = require("./dbcon/db");
const bodyparser = require("body-parser");
var app = express();
const HashMap = require("hashmap");
const iptracklist = new HashMap();
const notexistIpList = new HashMap();
app.use(bodyparser.json());
 
function loadService() {
    getipleveldetail(function (err, resSer) {
        if (err == 1 && resSer.length > 0) {
            iptracklist.clear();
            for (let i = 0; i < resSer.length; i++) {
                if(resSer[i].api_type == 1 && resSer[i].ip){
                    iptracklist.set(resSer[i].ip+'_'+resSer[i].key, resSer[i]);
                }
                else if(resSer[i].api_type == 0){
                    iptracklist.set(resSer[i].key, resSer[i]);
                }
            }
            console.log("iptracklist loaded successfully. Total entries: ", iptracklist);
        } else {
            console.info("No Record Available in api ::", resSer);
        }
    });
}
 
function getipleveldetail(callback) {
    let qry = "SELECT ip.ip, ip.idapi, a.key, a.api_type FROM api a LEFT JOIN api_ip ip ON a.idapi = ip.idapi";
    console.log("Loading api Query :: ", qry);
    connection.execute(qry, (err, rows) => {
        if (err == 1) {
            callback(1, rows);
        } else {
            callback(0, { status: 500, message: "Internal Server Error", error: err.message });
        }
    });
}

app.get('/getiplevel/:ipaddress/:authkey', (req, res) => {
    const Ipaddress = req.params.ipaddress;
    const Authkeyid = req.params.authkey;
    console.log("Requested ipaddress :: ", Ipaddress);
    console.log("Requested authkey :: ", Authkeyid);
 
    if (!Ipaddress || !Authkeyid) {
        return res.send({ status: 401, message: "Invalid authkey OR ipaddress!" });
    }

    // First, try to get data from HashMap for api_type=1 (IP + Key combination)
    let data = iptracklist.get(Ipaddress+'_'+Authkeyid);
    
    // If not found, try to get data for api_type=0 (Key only)
    if (!data) {
        data = iptracklist.get(Authkeyid);
    }

    console.log("Data from HashMap :: ", data);

    // If data found in HashMap
    if (data) {
        // For api_type=1: Must match both IP and Key
        if(data.api_type == 1) {
            if(data.ip == Ipaddress && data.key == Authkeyid) {
                return res.send({ status: 200, data: data, message: "API is allowed." });
            }
            else {
                return res.send({ status: 204, message: "API is not allowed for current IP!" });
            }
        }
        // For api_type=0: Only Key needs to match (no IP check)
        else if(data.api_type == 0) {
            if(data.key == Authkeyid) {
                return res.send({ status: 200, data: data, message: "API is allowed." });
            }
            else {
                return res.send({ status: 404, message: "API Data Does Not Exist!" });
            }
        }
        else{
            return res.send({ status: 501, message: "API Data Does Not Exist!" });
        }
    }
    else{
        data = notexistIpList.get(Ipaddress+'_'+Authkeyid);
        if(data){
            return res.send({ status: 204, message: "API is not allowed for current IP!" });
        }
        // If data not found in HashMap, fetch from DB
        let qry = "SELECT ip.ip, ip.idapi, a.key, a.api_type FROM api a LEFT JOIN api_ip ip ON a.idapi = ip.idapi WHERE a.key='" + Authkeyid + "'";
        console.log("Query api Get :: ", qry);
        connection.execute(qry, (err, rows) => {
            if (err == 1) {
                if (rows.length > 0) {
                    // Find matching row based on api_type
                    let matchedRow = null;
                    
                    for(let i = 0; i < rows.length; i++) {
                        // For api_type=1, check if IP matches
                        if(rows[i].api_type == 1 && rows[i].ip == Ipaddress) {
                            matchedRow = rows[i];
                            // Store in HashMap for future use
                            iptracklist.set(rows[i].ip+'_'+rows[i].key, rows[i]);
                            console.log("set data in HashMap for api_type=1 :: ", rows[i].ip+'_'+rows[i].key + " :: " + rows[i]);
                            break;
                        }
                        // For api_type=0, just check key (no IP required)
                        else if(rows[i].api_type == 0) {
                            matchedRow = rows[i];
                            // Store in HashMap for future use
                            iptracklist.set(rows[i].key, rows[i]);
                            console.log("set data in HashMap for api_type=0 :: ", rows[i].key + " :: " + rows[i]);
                            break;
                        }
                        else{
                            notexistIpList.set(Ipaddress+'_'+Authkeyid, {api_type: 1, ip: Ipaddress, key: Authkeyid});
                        }
                    }
                    
                    if(matchedRow) {
                        // For api_type=1: Verify IP matches
                        if(matchedRow.api_type == 1) {
                            if(matchedRow.ip == Ipaddress && matchedRow.key == Authkeyid) {
                                return res.send({ status: 200, data: matchedRow, message: "API is allowed." });
                            }
                            else {
                                return res.send({ status: 204, message: "API is not allowed for current IP!" });
                            }
                        }
                        // For api_type=0: Success (no IP check)
                        else if(matchedRow.api_type == 0) {
                            return res.send({ status: 200, data: matchedRow, message: "API is allowed." });
                        }
                        else{
                            return res.send({ status: 404, message: "API Data Does Not Exist!" });
                        }
                    }
                    else {
                        notexistIpList.set(Ipaddress+'_'+Authkeyid, {api_type: 1, ip: Ipaddress, key: Authkeyid});
                        return res.send({ status: 204, message: "API is not allowed for current IP!" });
                    }
                }
                else {
                    notexistIpList.set(Ipaddress+'_'+Authkeyid, {api_type: 1, ip: Ipaddress, key: Authkeyid});
                    return res.send({ status: 404, message: "API Data Does Not Exist!" });
                }
            } else {
                console.error("Error or No Rows Found :: ", err);
                return res.send({ status: 500, message: "Internal Server Error", error: err.message });
            }
        });
    }
});
function resetNotexistIpList() {
    notexistIpList.clear();
    console.log("notexistIpList reset successfully. Total entries: ", notexistIpList);
}
 
setInterval(() => loadService(), 2 * 60 * 1000);
setInterval(() => resetNotexistIpList(), 2 * 60 * 1000);

app.listen(3009, () => {
    loadService();
    resetNotexistIpList();
    console.log("Server is Connected at Port :: 3009");
});


/**
 * ========================================================================================
 * WHITELISTED IP CHECK SERVICE - STEP BY STEP PROCESS
 * ========================================================================================
 * 
 * PURPOSE:
 * This service validates API requests by checking if the provided IP address and 
 * authentication key combination is whitelisted. It supports two types of APIs with 
 * different validation requirements.
 * 
 * API TYPES:
 * - api_type = 1: IP-restricted API (requires both IP address AND key to match)
 * - api_type = 0: Key-only API (requires only key to match, no IP validation)
 * 
 * DATA STRUCTURES:
 * - iptracklist: Main HashMap storing whitelisted APIs (refreshed every 2 minutes)
 *   * api_type=1 entries: Stored as "IP_Key" (e.g., "192.168.1.1_abc123key")
 *   * api_type=0 entries: Stored as "Key" (e.g., "abc123key")
 * 
 * - notexistIpList: Cache for failed IP+Key combinations (reset every 2 minutes)
 *   * Prevents repeated database queries for known invalid combinations
 *   * Stored as "IP_Key" format
 * 
 * ========================================================================================
 * STEP-BY-STEP REQUEST PROCESSING FLOW:
 * ========================================================================================
 * 
 * STEP 1: INITIAL VALIDATION
 *   1.1 Extract IP address and authentication key from request parameters
 *   1.2 Validate both IP and key are provided
 *   1.3 If missing, return 401 error
 * 
 * STEP 2: CHECK MAIN HASHMAP (iptracklist)
 *   2.1 First, try to get data using "IP_Key" combination (for api_type=1)
 *   2.2 If not found, try to get data using just "Key" (for api_type=0)
 * 
 * STEP 3: IF DATA FOUND IN HASHMAP
 *   3.1 For api_type=1:
 *       - Verify both IP and Key match exactly
 *       - If match: Return 200 (API allowed)
 *       - If mismatch: Return 204 (API not allowed for current IP)
 * 
 *   3.2 For api_type=0:
 *       - Verify Key matches
 *       - If match: Return 200 (API allowed)
 *       - If mismatch: Return 404 (API Data Does Not Exist)
 * 
 * STEP 4: IF DATA NOT FOUND IN HASHMAP
 *   4.1 Check notexistIpList cache for "IP_Key" combination
 *   4.2 If found in cache: Return 204 (skip database query)
 *   4.3 If not in cache: Proceed to database query
 * 
 * STEP 5: DATABASE QUERY
 *   5.1 Query database for all records matching the provided key
 *   5.2 Search through results to find matching row:
 *       - For api_type=1: Find row where IP matches requested IP
 *       - For api_type=0: Find any row with matching key (no IP check)
 * 
 * STEP 6: PROCESS DATABASE RESULTS
 *   6.1 If matching row found:
 *       - Store in iptracklist HashMap (for future fast lookup)
 *       - Return 200 (API allowed) or 204 (if IP doesn't match for api_type=1)
 * 
 *   6.2 If no matching row found:
 *       - Store in notexistIpList (to prevent repeated queries)
 *       - Return 204 (API not allowed) or 404 (API Data Does Not Exist)
 * 
 * ========================================================================================
 * BACKGROUND PROCESSES:
 * ========================================================================================
 * 
 * LOAD SERVICE (loadService):
 *   - Runs every 2 minutes
 *   - Fetches all API and IP data from database
 *   - Populates iptracklist HashMap:
 *     * api_type=1 with IP: Store as "IP_Key"
 *     * api_type=0: Store as "Key" only
 * 
 * RESET NOTEXIST LIST (resetNotexistIpList):
 *   - Runs every 2 minutes
 *   - Clears notexistIpList cache
 *   - Allows re-checking failed combinations (in case data was added to DB)
 * 
 * ========================================================================================
 */