const mysql = require('mysql');
class DatabaseConnection {
    constructor(config) {
        this.config = config;
        this.connection = null;
    }

    open() {
        if (!this.connection) {
            this.connection = mysql.createConnection(this.config);
            this.connection.connect((err) => {
                if (err) {
                    console.error('Error connecting to the database:', err);
                    this.connection = null;
                } else {
                    console.log('Database connected');
                }
            });
        }
    }

    close() {
        if (this.connection) {
            this.connection.end((err) => {
                if (err) {
                    console.error('Error closing connection:', err);
                } else {
                    console.log('Database connection closed');
                }
            });
        }
        this.connection = null;
    }

    execute(query, callback) {
        try {
            this.open(); // Ensure connection is opened before query
            if (!this.connection) {
                throw new Error('No database connection');
            }
            this.connection.query(query, (err, rows) => {
                if (err) {
                    console.error('Error executing query:', err);
                    callback(0, rows);
                    this.close(); // Close the connection
                    return;
                }
                callback(1, rows);
                this.close(); // Close the connection after successful query
            });
        } catch (err) {
            console.error('Error executing query:', err);
            callback(0, []);
        }
    }
}

module.exports = DatabaseConnection;
